<?php
/* -----------------------------------------------------------------------------------------
   $Id: account.php,v 1.49 2019/04/09 14:52:59 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project (earlier name of osCommerce)
   (c) 2002-2003 osCommerce (account.php,v 1.59 2003/05/19); www.oscommerce.com
   (c) 2003      nextcommerce (account.php,v 1.12 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
require_once(DIR_WS_CLASSES.'order.php');


require_once(DIR_FS_CATALOG.'admin/includes/classes/yes_shipping.php');

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_checkbox_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_pull_down_menu.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_textarea_field.inc.php');
require_once(DIR_FS_INC . 'xtc_get_path.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_name.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_image.inc.php');
require_once(DIR_FS_INC . 'yes_get_orders_default_search_types.inc.php');
require_once(DIR_FS_INC . 'xtc_address_label.inc.php');

if (!xtc_session_is_registered('customer_id')) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}
$customers_id = (int)$_SESSION['customer_id'];
$all = \YES4Trade\Model\customers::get_orders_sum($customers_id, [
    1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_VERSENDET
]);
if($all > 0) {
    $addon  = '<div style="width:100%; border:1px solid #000000; background-color:#ffffff;">';
    $addon .= '<b>Gesamtwert offene Bestellungen:</b> '.number_format($all,2,',','.').' '.DEFAULT_CURRENCY;
    $addon .= '</div>';
}else{
    $addon = '';
}

$breadcrumb->add(NAVBAR_TITLE_ACCOUNT, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
require(DIR_WS_INCLUDES . 'header.php');

if ($messageStack->size('account') > 0) {
    $smarty->assign('error_message',$messageStack->output('account'));
}


//$max=$_SESSION['tracking']['products_history'];
$products_history = array();
$i=0;
$max = (isset($_SESSION['tracking']['products_history'])) ? count($_SESSION['tracking']['products_history']) : 0;
if($max > 10) {
    $max = 10;
}
while ($i < $max) {
    $hpID = intval($_SESSION['tracking']['products_history'][$i]);
    $parameters = [
        'products_id'=>$hpID,
    ];
    $product_history_query_raw = sprintf(
        "select products_price from %s where products_status = '1' and products_id = :products_id",
        TABLE_PRODUCTS
    );
    $product_history_query = yes_query($product_history_query_raw,$parameters);
    if(sizeOf($product_history_query)){
        $history_product = current($product_history_query);
        $products_name = xtc_get_products_name($hpID);
        $products_image = xtc_get_products_image($hpID);
        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
            $hpID,
            yes_get_store_country_id()
        );
        $format = true;
        $products_price = $xtPrice->xtcGetPrice(
            $hpID,
            $format,
            1,
            $products_tax_class_id,
            $history_product['products_price']
        );
        $buy_now = sprintf('<a href="%s">%s</a>',
            xtc_href_link(basename(__FILE__), 
                xtc_get_all_get_params(array('action')) 
                . 'action=buy_now&BUYproducts_id=' . $hpID
            ),
            xtc_image_button('button_buy_now.gif', IMAGE_BUTTON_IN_CART)
        );
        $cpath= xtc_get_product_path($hpID);
        $products_history[]=array(
            'PRODUCTS_NAME' => $products_name,
            'PRODUCTS_IMAGE' => DIR_WS_THUMBNAIL_IMAGES . $products_image,
            'PRODUCTS_PRICE' => $products_price,
            'PRODUCTS_URL' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $hpID),
            'PRODUCTS_CATEGORY_URL' => xtc_href_link(FILENAME_DEFAULT, 'cPath=' . $cpath),
            'BUY_NOW_BUTTON' => $buy_now
        );
   }
   $i++;
}

$order_content=array();
$xtPrice = new xtcPrice($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
$total_customer_orders = \YES4Trade\Model\customers::count_orders($customers_id);
if ($total_customer_orders > 0) {
	$orders_query = xtc_db_query("select
            o.orders_id,
            o.orders_status,
            o.date_purchased,
            o.delivery_name,
            o.delivery_country,
            o.billing_name,
            o.billing_country,
            ot.text as order_total,
            o.delivery_address_format_id
            from " . TABLE_ORDERS . " o LEFT JOIN " . TABLE_ORDERS_TOTAL . "
            ot USING(orders_id) 
            where o.customers_id = '" . $customers_id . "'
            and ot.class = 'ot_total'
            order by orders_id desc limit 3"
	);
	$oc = 0;
        $_tmp = [];
	while ($orders = xtc_db_fetch_array($orders_query)) {
            $_tmp[] = $orders;
        }
        foreach($_tmp as $orders){
            $order = new order($orders['orders_id'],$xtPrice);
            if (xtc_not_null($orders['delivery_name'])) {
                $order_name = $orders['delivery_name'];
                $order_country = $orders['delivery_country'];
            } else {
                $order_name = $orders['billing_name'];
                $order_country = $orders['billing_country'];
            }
            $order_content[$oc] = array(
                'ORDER_ID' =>$orders['orders_id'],
                'ORDER_DATE' =>xtc_date_short($orders['date_purchased']),
                'DELIVERY_ADDRESS'=> xtc_address_format($orders['delivery_address_format_id'],$order->delivery,true,'<br />',"\r\n"),
                'TRACKING'=>$order->get_shipping_tracking_id_array(),
                'SHIPPING_METHOD'=>$order->info['shipping_method'],
                'DATE_SHIPPING'=>($order->info['date_shipping'] > 0) ? $order->info['date_shipping'] : '',
                'ORDER_STATUS' =>main::get_orders_status_name($orders['orders_status'],$_SESSION['languages_id']),
                'ORDER_TOTAL' =>$orders['order_total'],
                'ORDER_LINK' => xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $orders['orders_id'], 'SSL') ,
                'ORDER_BUTTON' => '<a href="'.xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $orders['orders_id'], 'SSL') . '">' . xtc_image_button('small_view.gif', SMALL_IMAGE_BUTTON_VIEW) . '</a>'
            );
                
            if(!isset($_SESSION['rma'][$orders['orders_id']]) and in_array($orders['orders_status'],array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET))){
                $order_content[$oc]['RMA_LINK'] = xtc_href_link('rma.php', 'orders_id=' . $orders['orders_id'], 'SSL');
            }
            $oc++;
	}
}
$smarty->assign('LINK_EDIT',xtc_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL'));
$smarty->assign('LINK_WISHLIST', xtc_href_link(FILENAME_WISHLIST));     // wishlist
$smarty->assign('LINK_ADDRESS',xtc_href_link(FILENAME_ADDRESS_BOOK, '', 'SSL'));
$smarty->assign('LINK_PASSWORD',xtc_href_link(FILENAME_ACCOUNT_PASSWORD, '', 'SSL'));
$smarty->assign('LINK_ORDERS',xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
$smarty->assign('LINK_NEWSLETTER',xtc_href_link(FILENAME_NEWSLETTER, '', 'SSL'));
$smarty->assign('LINK_NOTIFICATIONS',xtc_href_link(FILENAME_ACCOUNT_NOTIFICATIONS, '', 'SSL'));
$smarty->assign('LINK_ALL',xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
$smarty->assign('order_content',$order_content);
$smarty->assign('products_history',$products_history);

$entries = \YES4Trade\Model\customers::count_orders($customers_id, [ORDERS_STATUS_UPSELLING]);
if($entries > 0){
    $smarty->assign('ebaylink','1');
}
    
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
$smarty->assign('CUSTOMER_TOTAL_ORDERS',$addon);
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/account.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);

if($_SESSION['customers_status']['customers_status_public'] == 1){
    $smarty->assign( 'CUSTOMERS_STATUS_NAME',$_SESSION['customers_status']['customers_status_name'] );
}

$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');

include( 'includes/application_bottom.php');
