<?php
/* --------------------------------------------------------------
   $Id: categories.php,v 1.535 2020/09/17 14:39:12 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(categories.php,v 1.140 2003/03/24); www.oscommerce.com
   (c) 2003  nextcommerce (categories.php,v 1.37 2003/08/18); www.nextcommerce.org

   Released under the GNU Generacal Public License
   --------------------------------------------------------------
   Third Party contribution:
   Enable_Disable_Categories 1.3               Autor: Mikel Williams | mikel@ladykatcostumes.com
   New Attribute Manager v4b                   Autor: Mike G | mp3man@internetwork.net | http://downloads.ephing.com
   Category Descriptions (Version: 1.5 MS2)    Original Author:   Brian Lowe <blowe@wpcusrgrp.org> | Editor: Lord Illicious <shaolin-venoms@illicious.net>
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   --------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_INC.'yes_get_products_distributors_stock.inc.php');
require_once('includes/classes/'.FILENAME_IMAGEMANIPULATOR);
require_once('includes/classes/class.products_characteristic.php');
require_once(DIR_FS_INC .'xtc_get_tax_rate.inc.php');
require_once(DIR_FS_INC .'xtc_get_products_mo_images.inc.php');
require_once(DIR_FS_INC .'yes_get_products_condition.inc.php');	
require_once(DIR_FS_INC .'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC .'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC .'xtc_get_units_title.inc.php');
require_once(DIR_FS_INC .'xtc_get_category_path.inc.php');
require_once(DIR_FS_INC.'xtc_wysiwyg.inc.php');
require_once(DIR_FS_INC.'yes_products_calc_in_auction_quantity.inc.php');
require_once('categories.functions.inc.php'); // FUNKTIONEN FUER categories.php UND categories_view.php

require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_WS_CLASSES . 'class.basics.php');
require_once(DIR_WS_CLASSES . 'product.php');
if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
    require_once(DIR_WS_CLASSES . 'yes_hitmeister.php');
}
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'yes_get_products_packaging_details.inc.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');

define('FILTER_PRODUCTS_DATE_ADDED_DURATIONS',	array(
    array('id'=>1,'text'=>'1 Tag'),
    array('id'=>3,'text'=>'3 Tage'),
    array('id'=>7,'text'=>'7 Tage'),
    array('id'=>14,'text'=>'2 Wochen'),
    array('id'=>28,'text'=>'1 Monat'),
    array('id'=>84,'text'=>'3 Monate'),
    array('id'=>365,'text'=>'1 Jahr')
));

$currencies = new currencies();
$basics = new basics;
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'image_search'){
    $search_dir = DIR_FS_CATALOG.'files/';
    $term = xtc_db_input($_REQUEST['term']);
    $matched_files = $basics->find_files($search_dir,$term);
    $items = array();
    foreach($matched_files as $file){
	$path = substr($file->getPathName(),strlen($search_dir));
	$items[] = array(
	    'value'=>$path,
	    'path'=>  dirname($path),
	    'label'=>basename($path),
	    'img'=>  xtc_image(DIR_WS_CATALOG.'files/'.$path, $path, '', '', 'align="left" class="image_search_res_img"')
	);
    }
    $json = array('item'=>$items);
    die(json_encode($items));
}


if(isset($_REQUEST['query'])){
		$search_term = xtc_db_input($_REQUEST['query']);
		if(mb_detect_encoding($_REQUEST['query']) == 'UTF-8')
			$search_term = yes_decode_string($search_term);
		$limit = (isset($_REQUEST['limit'])) ? (int)$_REQUEST['limit'] : 50;
		
		$exclude_products = array();
		if(isset($_REQUEST['exclude_products']) and is_array($_REQUEST['exclude_products'])){
		    foreach($_REQUEST['exclude_products'] as $exclude){
			$exclude_products[] = (int)xtc_db_input($exclude);
		    }
		}
                
		if(isset($_REQUEST['search_ean']) and $_REQUEST['search_ean'] == 1){
		    $query = xtc_db_query(
			sprintf("SELECT p.products_id FROM products p "
                                . "WHERE ( p.products_ean LIKE '%s%%'"
                                . " or p.products_model LIKE '%s%%' "
                                . "or p.mpn LIKE '%s%%'"
                                . " ) LIMIT %d",
				$search_term,$search_term,$search_term,
                                $limit
		    ));
		}else{
			$query = xtc_db_query(sprintf(
				"SELECT products_id,products_name FROM products_description pd "
                                . "WHERE products_name LIKE '%s%%' "
                                . "and language_id='%d' "
                                . "and products_name != '' "
                                . " ORDER BY products_name LIMIT %d",
				$search_term,$_SESSION['languages_id'],
                                $limit
			));
		}
		$suggestions = array();
		$datas = array();
		while($record = xtc_db_fetch_array($query)){
			if(in_array($record['products_id'], $exclude_products)){
			    //continue;
			}
			if(!isset($record['products_name'])){
				$record['products_name'] = xtc_get_products_name($record['products_id']);
			}
			if(!empty($record['products_name'])){
				$name = str_replace(array(':','{','}','[',']','"',"'"),' ',$record['products_name']);
				$picpath = DIR_FS_CATALOG.'images/product_images/thumbnail_images/'.$record['products_id'].'_0.';
				$picurl = '../images/product_images/thumbnail_images/'.$record['products_id'].'_0.';
				if(is_file($picpath.'jpg')){
					$img_src = '<img src="'.$picurl.'jpg" style="display: inline;vertical-align: middle;max-width:80px;max-height:80px;" border="0" />';
				}else if(is_file($picpath.'JPG')){
					$img_src = '<img src="'.$picurl.'JPG" style="display: inline;vertical-align: middle;max-width:80px;max-height:80px;" border="0" />';
				}else{
					$img_src = "";
				}
                                $sugg = $name;
                                if(mb_detect_encoding($sugg) != 'UTF-8'){
                                        $sugg = yes_encode_string($name);
                                }
				$sugg = '(pID '.$record['products_id'].') '.$sugg;
				if(strlen($sugg) > 42){
					// NORMALES SUBSTR ZERSTOERT SONDERZEICHEN
					// 11/19 mario
				    $sugg = mb_substr($sugg,0,39).'...';
				}
				$datas[] = array('value'=>$record['products_id'],
				    'label'=>$sugg,
				    'icon'=>$img_src
				);
				
			}
		}
		$response = json_encode($datas);
		echo $response;
		exit;
}

  if(isset($_GET['stat']) and $_GET['stat'] == '1'){
  	require('products_stats.inc.php');
	exit;
  }
  if(isset($_GET['action']) and $_GET['action'] == 'ajax_image_details'){
	include('ajax_image_details.php');
	exit;
  }
  if(isset($_GET['action']) and ($_GET['action'] == 'image_visible_in_shop_update' or $_GET['action'] == 'image_visible_in_shop')){
	include('ajax_image_visible_in_shop.php');
	exit;
  }
  if(isset($_GET['action']) and $_GET['action'] == 'ajax_image_upload'){
	include('ajax_image_upload.php');
	exit;
  }
  
  if(isset($_GET['action']) and $_GET['action'] == 'image_download'){
	  $name = xtc_db_input($_GET['name']);
	  $name = str_replace(array('\.\.','\\','/'),'',$name);
	  if(strlen($name)<=3) die('Missing Parameter in '.yes_get_httpinfo());
	  $file = DIR_FS_CATALOG.'images/product_images/original_images/'.$name;
	  $basics->download_file($file);
  }
  	  
$admin_access = main::get_admin_access();
  
if (isset($_GET['function'])){
	switch ($_GET['function']) {
            case 'update_staffelprice':
                require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
                $xtPrice = new xtcPrice(DEFAULT_CURRENCY,(int)xtc_db_input($_REQUEST['groupID']));
		$pID = (int)xtc_db_input($_REQUEST['pID']);
                $group_price_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                    (int)xtc_db_input($_REQUEST['groupID']), 
                    $pID
                );
                $return_value = '';
                switch($_REQUEST['field']){
                    case 'quantity':
                        $update_field = 'quantity';
                        $update_value = (int)$_REQUEST['new_value'];
                        $old_value = (int)xtc_db_input($_REQUEST['id_key']);
                        $new_value = $update_value;
                        foreach($group_price_items as $GPI){
                            if($GPI->quantity == $old_value){
                                $old_value = $GPI->personal_offer;
                                $GPI_update = new \YES4Trade\Model\group_prices_item([
                                    'products_id'=>$GPI->products_id,
                                    'price_id'=>$GPI->price_id,
                                    'personal_offer'=>$GPI->personal_offer,
                                    'quantity'=>$update_value,
                                ]);
                                break;
                            }
                        }
                        break;
                    case 'price':
                        $update_field = 'personal_offer';
                        $update_value = (float)$_REQUEST['new_value'];
                        foreach($group_price_items as $GPI){
                            if($GPI->quantity == (int)xtc_db_input($_REQUEST['id_key'])){
                                $old_value = $GPI->personal_offer;
                                break;
                            }
                        }
                        $tcID = xtc_db_input($_REQUEST['tcID']);
                        if (PRICE_IS_BRUTTO=='true'){
                            $update_value = ($update_value/(xtc_get_tax_rate($tcID) +100)*100);
                            $netto = $update_value;
                            $old_value = xtc_oe_get_price_i_tax($old_value,xtc_get_tax_rate($tcID),false);
                        }
                        $old_value = number_format($old_value,2,',','.');
                        $update_value=xtc_round($update_value,PRICE_PRECISION);
                        $GPI_update = new \YES4Trade\Model\group_prices_item([
                            'products_id'=>$GPI->products_id,
                            'price_id'=>$GPI->price_id,
                            'personal_offer'=>$update_value,
                            'quantity'=>$GPI->quantity,
                        ]);
                        $return_value = number_format($_REQUEST['new_value'],2,',','.');
                        $new_value = number_format($_REQUEST['new_value'],2,',','.');
                        if (PRICE_IS_BRUTTO=='true'){
                            $return_value .= ' <br /><i>'.TEXT_NETTO . $xtPrice->xtcFormat( $netto,true) .'</i>';
                        }
                        break;
                }
                $GPI_update->update( (int)xtc_db_input($_REQUEST['groupID']) );
                product::add_history_static($pID, sprintf(TEXT_PRODUCTS_HISTORY_GROUP_ENTRY_UPDATE,
                    xtc_get_customers_status_name((int)xtc_db_input($_REQUEST['groupID'])),
                    $update_field,$old_value,
                    $new_value
                ));
                $msg = yes_encode_string($insert_sql_array['comments']);
                $json = array('MSG'=>$msg,'VALUE'=>$return_value);
                die(json_encode($json));
                break;
	    case 'copy_confirm':
		require_once(DIR_FS_INC . 'xtc_get_tax_rate.inc.php');
		//require_once(DIR_FS_INC . 'xtc_format_price.inc.php');

		require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
		$statusID = (int)xtc_db_input($_REQUEST['statusID']);
		$copy_statusID = (int)xtc_db_input($_REQUEST['copy_statusID']);
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$tcID = (int)xtc_db_input($_REQUEST['tcID']);
		if($statusID < 1 or $copy_statusID < 1 or $pID < 1 or $statusID == $copy_statusID){
		    die(json_encode(array(
			'ERROR'=>'Parameter invalid'
		    )));
		}
                \YES4Trade\Model\group_prices::delete_by_products_id(
                    $statusID,
                    $pID
                );
                $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                    $copy_statusID, $pID
                );
		foreach($group_prices_items as $GPI){
		    if($GPI->personal_offer == 0){
			continue;
                    }
                    $GPI_new = new \YES4Trade\Model\group_prices_item([
                        'products_id'=>$pID,
                        'quantity'=>$GPI->quantity,
                        'personal_offer'=>$GPI->personal_offer
                    ]);
                    $GPI_new->create($statusID);
                    $data[] = $GPI_new->toArray();
		}
		$xtPrice = new xtcPrice(DEFAULT_CURRENCY,$_SESSION['customers_status']['customers_status_id']);
                
                $from_cs = xtc_get_customers_status_name($copy_statusID);
                $to_cs = xtc_get_customers_status_name($statusID);
                
		foreach($data as $nr=>$st){
		    $comments = sprintf('Kopie der Staffelpreise von Kundengruppe %s in Kundengruppe %s',
                        $from_cs,
                        $to_cs
		    );
                    product::add_history_static($pID, $comments);
		    $netto_str = '';
		    if (PRICE_IS_BRUTTO=='true' and $st['personal_offer'] > 0){
                        $netto_str = TEXT_NETTO . $xtPrice->xtcFormat($st['personal_offer'],true);
		    }
		    $price = $st['personal_offer'];
		    if ($st['personal_offer'] === 0) {
			$price = 0.00;
		    } else {
			if (PRICE_IS_BRUTTO=='true'){
                            $price = ($price/(xtc_get_tax_rate($tcID) +100)*100);
			}
			$price=xtc_round($price,PRICE_PRECISION);
		    }
		    $data[$nr]['netto_str'] = $netto_str;
		    $data[$nr]['price'] = $xtPrice->xtcFormat($price,true);
		}
		die(json_encode(array(
		    'ERROR'=>'',
		    'data'=>$data
		)));
		break;
	    case 'copy':
		$statusID = (int)xtc_db_input($_REQUEST['statusID']);
		$cs = xtc_get_customers_statuses();
		$statii = array();
		foreach($cs as $cs_entry){
		    if($cs_entry['id'] != $statusID and $cs_entry['id'] > 0){
			$statii[] = array(
			    'id'=>$cs_entry['id'],
			    'text'=>$cs_entry['text']
			);
		    }
		}
		
		printf('<p>%s</p>',TEXT_COPY_STAFFELPREISE_INTRO);
		echo xtc_draw_pull_down_menu('copy_statusID',$statii);
		echo '<input type="button" class="ui-button ui-corner-all ui-state-default copy_confirm" value="'.IMAGE_COPY.'" />';
		exit;
		break;
            case 'delete':
                $pID = (int)xtc_db_input($_REQUEST['pID']);
                $statusID = (int)xtc_db_input($_REQUEST['statusID']);
                $quantity = (int)xtc_db_input($_REQUEST['quantity']);
                $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id($statusID, $pID);
                foreach($group_prices_items as $GPI){
                    if($GPI->quantity === $quantity ){
                        product::add_history_static($pID, sprintf(
                                'Kundengr.-Preis Anzahl %d: %s gel&ouml;scht.',
                                $quantity, number_format($GPI->personal_offer,2,',','.')
                        ));
                        $GPI->delete($statusID, $GPI->price_id);
                    }
                }
                break;
            case 'add':
                if(!isset($_GET['statusID']) or $_GET['pID'] < 1 or $_GET['quantity'] < 1){
                    die(json_encode(array(
                        'error'=>'invalid data'
                    )));
                }
                $pID = (int)xtc_db_input($_REQUEST['pID']);
                $statusID = (int)xtc_db_input($_REQUEST['statusID']);
                $cs_array = xtc_get_customers_statuses();
                foreach($cs_array as $cs){
                    if($cs['id'] == $statusID){
                        $statusName = $cs['text'];
                    }
                }
                $quantity = (int)xtc_db_input($_REQUEST['quantity']);
                $price_submitted = (float)xtc_db_input(str_replace(',','.',$_REQUEST['price']));
                $price = $price_submitted;
                // VERALTETES HANDLING                   
                // $tcID = xtc_db_input($_REQUEST['tcID']);
                // EU OSS HANDLING
                $tcID = yes_eu_oss_get_products_tax_class_id($pID, STORE_COUNTRY);
                if ($price === 0) {
                    $price = 0.00;
                } else {
                    if (PRICE_IS_BRUTTO=='true'){
                        $price= ($price/(xtc_get_tax_rate($tcID) +100)*100);
                    }
                    $price=xtc_round($price,PRICE_PRECISION);
                }
                
                $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id($statusID, $pID);
                foreach($group_prices_items as $GPI){
                    if($GPI->quantity === $quantity ){
                        $GPI->delete($statusID, $GPI->price_id);
                    }
                }
                $GPI = new \YES4Trade\Model\group_prices_item([
                    'products_id' => $pID,
                    'quantity' => $quantity,
                    'personal_offer' => $price
                ]);
                $GPI->create($statusID);
                $comments = sprintf(HISTORY_PRODUCTS_GROUP_PRICE_INSERTED,$statusName,$quantity, number_format((float)$price,2,',','.'));
                product::add_history_static($pID, $comments);
                $netto_str = '';
                require_once(DIR_FS_INC . 'xtc_get_tax_rate.inc.php');
                require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
                $xtPrice = new xtcPrice(DEFAULT_CURRENCY,$_SESSION['customers_status']['customers_status_id']);
                if (PRICE_IS_BRUTTO=='true' and $price > 0){
                    $netto_str = TEXT_NETTO . $xtPrice->xtcFormat($price,true);
                }
                die(json_encode(array(
                    'ERROR'=>'',
                    'PRICE_NETTO_STRING'=>$netto_str,
                    'PRICE'=>$xtPrice->xtcFormat($price_submitted,true)
                )));
                break;
	}
	if(!isset($_REQUEST['ajax']) and $_REQUEST['ajax'] != 1){
	    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $_GET['cPath'] . '&action=new_product&pID=' . (int)$_GET['pID']));
	}else{
	    die(json_encode(array(
		'SUCCESS'=>1
	    )));
	}
}
if(isset($_GET['pID']) and xtc_not_null($_GET['pID'])){
	$cPath = xtc_get_product_path( $_GET['pID'] );
}
if(isset($_GET['gotopID']) and $_GET['gotopID'] > 0){
	$pID = xtc_db_input($_GET['gotopID']);
	$checkQ = xtc_db_query("SELECT count(1) as anzahl FROM products WHERE products_id='".$pID."'");
	$check = xtc_db_fetch_array($checkQ);
	if($check['anzahl'] == 1){
		$cPath = xtc_get_product_path( $pID );
		xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,'pID='.$pID.'&cPath='.$cPath.	'&action=new_product'));
	}else{
		$messageStack->add_session(sprintf(MSG_PRODUCT_NOT_EXISTS,$pID),'error');
		xtc_redirect(xtc_href_link(FILENAME_CATEGORIES));
	}
	exit;
}
if(isset($admin_access['amazon_export'])){
    require_once(DIR_WS_CLASSES . 'amazon_export.php');
}
$directories = array(
    '../images/product_images/original_images/',
    DIR_WS_CATALOG_INFO_IMAGES,
    DIR_WS_CATALOG_POPUP_IMAGES,
    DIR_WS_CATALOG_THUMBNAIL_IMAGES
);
if(is_dir(DIR_FS_CATALOG.'images/product_images/ebaycategory_images')){
    $directories[] = '../images/product_images/ebaycategory_images';
}

if (isset($_REQUEST['action'])) {
	switch ($_REQUEST['action']) {
        case 'un_classifications':
            require('categories.un_classifications.php');
            exit;
            break;
        case 'dropzone-import':
            $dropzone_main_dir = 'importdata/DROPZONE_UPLOAD/';
            if(!is_dir($dropzone_main_dir)){
                mkdir($dropzone_main_dir, 0775, true);
            }
            $sessionUploadDir = sprintf(
                $dropzone_main_dir.'%s_%d/',
                session_id(),
                (int)$_GET['products_id']
            );
            if(!is_dir($sessionUploadDir)){
                mkdir($sessionUploadDir, 0775, true);
            }

            $error = '';
            $json = json_decode(file_get_contents('php://input'), true);
            if(!is_countable($json) or !sizeOf($json)){
                $error = 'Invalid Data';
                printf("<script type=\"text/javascript\">alert('%s');</script>", $error);
                exit;
            }else{
                $products_id = (int)xtc_db_input($_GET['products_id']);
                $default_image_query = xtc_db_query(sprintf(
                    "SELECT products_image FROM products WHERE products_id='%s'",
                    $products_id
                ));
                if(xtc_db_num_rows($default_image_query)){
                    $default_image = xtc_db_fetch_array($default_image_query);
                    if(!empty($default_image['products_image'])){
                        foreach($directories as $dir){
                            if(is_file($dir.$default_image['products_image'])){
                                unlink($dir.$default_image['products_image']);
                            }
                        }
                    }
                }
                $mo_images_query = xtc_db_query(sprintf(
                    "SELECT image_name FROM products_images WHERE products_id='%s'",
                    $products_id
                ));
                if(xtc_db_num_rows($mo_images_query)){
                    while($mo_images = xtc_db_fetch_array($mo_images_query)){
                        foreach($directories as $dir){
                            if(is_file($dir.$mo_images['image_name'])){
                                unlink($dir.$mo_images['image_name']);
                            }
                        }
                    }
                }
                xtc_db_query(sprintf(
                    "DELETE FROM products_images WHERE products_id='%s'",
                    $products_id
                ));
                foreach($json as $pi){
                    $ext = current(array_reverse(explode('.',$pi['file'])));
                    $tmp_name = $sessionUploadDir.$pi['file'];
                    $image_number = intval($pi['sort'])-1;
                    rename($tmp_name,DIR_FS_CATALOG.'images/product_images/original_images/'.$products_id.'_'.$image_number.'.'.$ext);
                    $products_image_name = $products_id.'_'.$image_number.'.'.$ext;
                    $tmp_name = DIR_FS_CATALOG.'images/product_images/original_images/'.$products_image_name;
                    qpa_save_images($products_id, $products_image_name, $image_number, intval($pi['webshop']));

                } // EOF foreach IMAGES
                $insert_sql_array = array(
                    'products_id'=>$products_id,
                    'editor_id'=>$_SESSION['customer_id'],
                    'date_saved'=>'now()',
                    'comments'=>TEXT_HISTORY_CART_PRODUCT_SAVED
                );
                xtc_db_perform('products_history',$insert_sql_array);
            } // end if !error

            exit;
            break;
        case 'dropzone-delete':
            $dropzone_main_dir = 'importdata/DROPZONE_UPLOAD/';
            if(!is_dir($dropzone_main_dir)){
                mkdir($dropzone_main_dir, 0775, true);
            }
            $sessionUploadDir = sprintf(
                $dropzone_main_dir.'%s_%d/',
                session_id(),
                (int)$_GET['products_id']
            );
            if(!is_dir($sessionUploadDir)){
                mkdir($sessionUploadDir, 0775, true);
            }

            header('Content-Type: application/json; charset=utf-8');
            // JSON-Daten empfangen
            $data = json_decode(file_get_contents('php://input'), true);
            $filename = basename($data['filename'] ?? '');

            if (!$filename) {
                echo json_encode(['success' => false, 'message' => 'No file received']);
                exit;
            }

            $uploadDir = $sessionUploadDir;
            $file = $uploadDir . $filename;

            if (file_exists($file)) {
                if (unlink($file)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false, 'message' => 'File delete failed']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'File not found']);
            }
            exit;
            break;
        case 'dropzone-upload':
            $dropzone_main_dir = 'importdata/DROPZONE_UPLOAD/';
            if(!is_dir($dropzone_main_dir)){
                mkdir($dropzone_main_dir, 0775, true);
            }
            $sessionUploadDir = sprintf(
                $dropzone_main_dir.'%s_%d/',
                session_id(),
                (int)$_GET['products_id']
            );
            if(!is_dir($sessionUploadDir)){
                mkdir($sessionUploadDir, 0775, true);
            }

            header('Content-Type: application/json; charset=utf-8');

            if (!empty($_FILES['file']['tmp_name'])) {
                $uploadDir = $sessionUploadDir;
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0775, true);
                }

                $fileName = basename($_FILES['file']['name']);
                $targetFile = $uploadDir . $fileName;

                if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
                    echo json_encode(['success' => true, 'file' => $fileName]);
                } else {
                    http_response_code(500);
                    echo json_encode(['success' => false, 'message' => 'Upload failed']);
                }
                exit;
            }

            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'No file received']);
            exit;
            break;

        case 'clearcache':
                if($admin_access['f_categories_clearcache'] == '1'){
                    // wird in categories_view verwendet - nur alle 10 min
                    $_SESSION['f_categories_clearcache_lastaction'] = time();
                    $dir = DIR_FS_CATALOG;
                    $system_cmd = 'rm -Rf '.$dir.'/templates_c/*';
                    system($system_cmd);
                    $messageStack->add_session('Template Cache geleert.','success');
                }
                xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
                break;
        case 'delete_groups_allocation':
                $gID = (int)xtc_db_input($_GET['groups_id']);
                $group_name = 'Unknown';
                $gh = new \YES4Trade\Model\group_handler($_SESSION['language_id']);
                foreach($gh->groups as $g){
                    if($g['groups_id'] == $gID){
                        $group_name = $g['groups_title'];
                    }
                }
                foreach($_GET['pID'] as $pID_raw){
                    $pID = (int)xtc_db_input($pID_raw);
                    \YES4Trade\Model\groups_products::delete($gID, $pID);
                    product::add_history_static($pID, sprintf(
                            HISTORY_PRODUCT_GROUPS_ALLOCATION_DELETED,
                            $group_name,$gID
                    ));
                }
                $messageStack->add_session(sprintf(MSG_SUCCESS_GROUPS_ALLOCATION_DELETED,sizeOf($_GET['pID'])),'success');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['action','pID'])));
                break;
            case 'xy_prices':
                require_once('product_properties_xy_prices.php');
                exit;
                break;
            case 'copy_category_confirm':
                echo '<div style="border: 1px solid red; padding: 10px; text-align:center;">';
                echo '<p style="font-size: 1.2em;">'.TEXT_COPY_CATEGORY_INTRO.'</p>';
                printf('<a href="%s"><button style="padding:4px;font-size: 1.4em" class="ui-button ui-corner-all ui-state-default">%s</button></a>',
                    xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['action']).'action=copy_category'),
                    TEXT_CATEGORY_COPY
                );
                echo '</div>';
                exit;
                break;
            case 'copy_category':
                $cID = (int)xtc_db_input($_GET['cID']);
                require_once(DIR_WS_CLASSES.'class.products_export.php');
                $copies = [(object)[
                    'id' => $cID,
                    'parent' => 0,
                ]];
                $pe = new products_export;
                $pe->only_active_categories = false;
                $pe->getChilds($cID);
                foreach($pe->selected_categories as $scID=>$egal){
                    if(!in_array($scID, $copies)){
                        $copies[] = (object)['id'=>$scID,'parent'=>$pe->getParent($scID)];
                    }
                }
                
                $new_cID_test = 100;
                $_helper = [];
                foreach($copies as $c){
                    $cat = \YES4Trade\Model\category::get_by_categories_id($c->id);
                    if($cat === null){
                        throw new Exception('Invalid categories_id "'.$c->id.'" for copy');
                    }
                    $r = $cat->toArray();
                    $orig_parent = $r['parent_id'];
                    $unset = ['categories_id','parent_id','date_added','last_modified'];
                    foreach($unset as $u){
                        unset($r[$u]);
                    }
                    $r['date_added'] = date('Y-m-d H:i:s');
                    $r['last_modified'] = '';
                    $new = new \YES4Trade\Model\category($r);
                    $new_cID = $new->create();
                    $cd_list = \YES4Trade\Model\categories_description::get_by_categories_id($c->id);
                    $desc = [];
                    foreach($cd_list as $cd){
                        $cd_array = $cd->toArray();
                        $cd_array['categories_id'] = intval($new_cID);
                        $new = new \YES4Trade\Model\categories_description($cd_array);
                        $new->create();
                    }
                    $gcat = \YES4Trade\Model\groups_categories::get_by_categories_id($c->id);
                    if($gcat != null){
                        $data = $gcat->toArray();
                        if(isset($data['characteristics'])){
                            unset($data['characteristics']);
                        }
                        $data['categories_id'] = (int)$new_cID;
                        $new_gcat = new \YES4Trade\Model\groups_categories($data);
                        $new_gcat->create();
                    }
                    
                    $_helper[] = ['orig'=>$c->id,'new'=>$new_cID];
                    
                    // DAS IST NICHT DIE KATEGORIE DIE VOM USER GEWAEHLT WURDE. 
                    // ALSO parent_id UEBERSCHREIBEN
                    if($c->id != $cID){
                        $update_parent_id = '';
                        foreach($_helper as $_h){
                            if($_h['orig'] == $orig_parent){
                                $update_parent_id = $_h['new'];
                            }
                        }
                    }else{
                        $update_parent_id = $orig_parent;
                    }
                    $upd = new \YES4Trade\Model\category([
                        'parent_id'=>intval($update_parent_id),
                        'categories_id'=>intval($new_cID)
                    ]);
                    $upd->update();
                }
                \yescache_helper::cache_bump_generation($InstanceCache, 'categories');
                
                $messageStack->add_session(MSG_SUCCESS_CATEGORY_COPY,'success');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES));
                break;
            case 'get_products_tax_status':
                $pID = (int)xtc_db_input($_GET['pID']);
                $allocated = yes_eu_oss_get_tax_class_allocation($pID);
                $country_id = STORE_COUNTRY;
                echo '<div class="ui-widget" style="width: 500px;padding: 4px;">';
                if(is_countable($allocated) and isset($allocated['source']) and $allocated['source'] != ''){
                    $tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, $country_id);
                    $title = xtc_get_tax_class_title( $tax_class_id);
                    printf('<div class="ui-widget-header" style="padding: 4px;">Steuerklasse &raquo;%s&laquo; (%s)</div>',
                        $title,
                        xtc_get_country_name($country_id),
                        $tax_class_id
                    );
                }
                echo '<div class="ui-widget-content" style="padding: 4px;font-size: 0.8em;">';
                if(is_countable($allocated)){
                    switch($allocated['source']){
                        case 'product':
                            echo TAX_CLASS_FROM_PRODUCT;
                            break;
                        case 'group':
                            printf(TAX_CLASS_FROM_GROUP,$allocated['source_info']);
                            break;
                        default:
                            printf('<div class="ui-widget ui-state-error"><b>%s</b><br /><i>%s</i></div>',NO_TAX_CLASS_ALLOCATION,NO_TAX_CLASS_ALLOCATION_INTRO);
                            break;
                    }
                }else{
                    printf('<div class="ui-widget ui-state-error"><b>%s</b><br /><i>%s</i></div>',NO_TAX_CLASS_ALLOCATION,NO_TAX_CLASS_ALLOCATION_INTRO);
                }
                echo '</div></div>';
                exit;
                break;
            case 'htg_import':
                include(realpath(__DIR__).DIRECTORY_SEPARATOR.'htg.php');
                break;
            case 'delete_images_process':
                if(!isset($_GET['pID']) or (int)$_GET['pID'] < 1){
                    die('Invalid Call');
                }
                $pID = (int)xtc_db_input($_GET['pID']);
                if(!product::isProduct($pID)){
                    die('Invalid product');
                }
                $product = new product($pID);
                foreach($product->get_images() as $nr=>$img){
                    if($nr == 0){
                        $update_sql_array = array('products_image'=>'');
                        xtc_db_perform(TABLE_PRODUCTS,$update_sql_array,'update',"products_id='".$pID."'");
                    }
                    $product->delete_image($img['name']);
                }
                xtc_db_query(sprintf(
                        "DELETE FROM %s WHERE products_id='%d'",
                        TABLE_PRODUCTS_IMAGES,$pID
                ));
                $product->add_history(MSG_SUCCESS_PRODUCTS_IMAGES_DELETED);
                $messageStack->add_session('pID '.$pID.' '.MSG_SUCCESS_PRODUCTS_IMAGES_DELETED,'success');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=new_product'));
                break;
            case 'delete_images':
                printf('<p>%s</p>',TEXT_REALLY_DELETE_IMAGES);
                printf('<a style="padding: 3px;" class="ui-button ui-corner-all ui-state-highlight" href="%s">%s</a>',
                        xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=delete_images_process'),
                        IMAGE_DELETE
                );
                exit;
                break;
            case 'import_product_images_example_file':
                $file_content = "pID\tBild #1\t";
                for($i=0;$i<MO_PICS;$i++){
                    $file_content .= "Bildlink #".($i+2);
                    if($i < (MO_PICS-1)){
                        $file_content .= "\t";
                    }
                }
                $file_content .= "\r\n";
                $basics->create_file(\main::get_exportdata_path().'PRODUCTS_IMAGES_UPLOAD_VORLAGE.csv', $file_content);
                $basics->download_file(\main::get_exportdata_path().'PRODUCTS_IMAGES_UPLOAD_VORLAGE.csv', true);
                exit;
                break;
            case 'import_product_images':
                $import_dir = \main::get_importdata_path();
                $import_filename = 'PRODUCTS_IMAGES_UPLOAD.csv';
                if(isset($_FILES['products_images_import'])){
                    $import_success = false;
                    $data_checked = false;
                    require_once(DIR_WS_CLASSES.'class.csv.php');
                    $CSV = new CSVfile($_FILES['products_images_import']['tmp_name']);
                    $CSV->delimiter = "\t";
                    $CSV->open('r');
                    $current_imports = [];
                    while($row = $CSV->readRow()){
                        // MOPICS +2 ENTSPRICHT MAX-ANZAHL ZUSATZBILDER UND SPALTE PID
                        if(sizeOf($row) <> (MO_PICS+2)){
                            continue;
                        }
                        $current_imports[] = $row;
                    }
                    $CSV->close();
                    if(sizeOf($current_imports)){
                        if(yes_try_upload('products_images_import', $import_dir, 755, array('CSV','csv'),str_replace('.csv','',$import_filename))){
                            $import_success = true;
                        }
                    }else{
                        $data_checked = true; // wir haben geprueft
                        $messageStack->add_session(TEXT_IMPORT_PRODUCT_IMAGES_CHECK_INVALID,'error');
                    }
                    if(!$import_success){
                        if(!$data_checked){
                            $messageStack->add_session('Invalid Filetype '.$_FILES['products_images_import']['type'],'error');
                        }
                    }else{
                        $messageStack->add_session(TEXT_IMPORT_PRODUCT_IMAGES_IN_PROCESS,'success');
                    }
                    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action'))));
                }
                if(file_exists($import_dir.$import_filename)){
                    die(TEXT_IMPORT_PRODUCT_IMAGES_IN_PROCESS);
                }
                
                echo '<div class="main">';
                echo '<p>'.TEXT_IMPORT_PRODUCT_IMAGES_INTRO.'</p>';
                printf('<a href="%s">%s</a>',xtc_href_link(FILENAME_CATEGORIES,'action=import_product_images_example_file'),
                    TEXT_IMPORT_PRODUCT_IMAGES_EXAMPLE_FILE
                );
                echo '<hr noshade="noshade" />';
                echo xtc_draw_form('products_images_import_form','categories.php',xtc_get_all_get_params(),'post','enctype="multipart/form-data"');
                echo '<input type="file" name="products_images_import" />';
                echo '<input type="submit" value="'.IMAGE_UPLOAD.'" class="ui-button ui-corner-all" />';
                echo '</form></div>';
                exit;
                break;
            case 'images_download':
                $directories = [
                    ['id'=>'original_images','text'=>'Original'],
                    ['id'=>'thumbnail_images','text'=>'Thumbnail'],
                    ['id'=>'info_images','text'=>'Info'],
                    ['id'=>'popup_images','text'=>'Popup'],
                    ['id'=>'ebaycategory_images','text'=>'eBay']
                ];
                $pID = (int)xtc_db_input($_GET['pID']);
                $product = new product($pID);
                if(!$product->isProduct($pID)){
                    $messageStack->add_session('Unknown pID '.$_GET['products_id'],'error');
                    xtc_redirect(xtc_href_link(xtc_get_all_get_params(array('action')).'action=new_product'));
                }
                $current_images = $product->get_images();
                if(!sizeOf($current_images)){
                    die('No images available');
                }
                if(isset($_POST['size'])){
                    $files = [];
                    $zip_dir = 'PRODUCTS_IMAGES_ZIP_PID'.$pID;
                    $target_dir = \main::get_exportdata_path().$zip_dir;
                    if(!is_dir($target_dir)){
                        mkdir($target_dir);
                    }
                    $picdir = $_POST['size'];
                    $exists = false;
                    foreach($directories as $dir){
                        if($dir['id'] == $picdir){
                            $exists = true;
                        }
                    }
                    if(!$exists){
                        die('Invalid directory');
                    }
                        
                    foreach($current_images as $ci){
                        copy(DIR_FS_CATALOG.'images/product_images/'.$picdir.'/'.$ci['name'],
                             $target_dir.'/'.$ci['name']
                        );
                    }
                    $basics->zip_files($zip_dir, $zip_dir.'.zip', \main::get_exportdata_path(), true);
                    $basics->download_file(\main::get_exportdata_path().$zip_dir.'.zip', true);
                    //echo $_POST['size'];
                    exit;
                }
                echo xtc_draw_form('download_images_form','categories.php',xtc_get_all_get_params(),'post');
                echo 'Size: ';
                echo xtc_draw_pull_down_menu('size',$directories);
                echo '<input type="submit" value="Download" class="ui-button ui-corner-all ui-state-default" />';
                echo '</form>';
                exit;
                break;
            case 'ajax_image_sort':
                $pID = (int)xtc_db_input($_GET['products_id']);
                $product = new product($pID);
                if(!$product->isProduct($pID)){
                    die(json_encode(array(
                        'ERROR'=>'Unknown pID '.$_GET['products_id']
                    )));
                }
                $new_sorting = explode(':',xtc_db_input($_GET['sorting']));
                $current_images = $product->get_images();
                $new_images = [];
                foreach($new_sorting as $pos){
                    foreach($current_images as $ci){
                        if($pos == $ci['nr']){
                            $new_images[] = $ci;
                        }
                    }
                }
                $new_images_clean = [];
                foreach($new_images as $nnr=>$ni){
                    if($nnr != $ni['nr']){
                        $new_images_clean[] = array_merge(array('new_pos'=>$nnr),$ni);
                    }
                }
                $directories = ['ebaycategory_images','original_images','thumbnail_images','info_images','popup_images'];
                $dir_path = DIR_FS_CATALOG.'images/product_images/';
                $tmp_path = \main::get_exportdata_path();
                // TEMPORAERE KOPIEN ERZEUGEN
                foreach($new_images_clean as $img){
                    foreach($directories as $dir){
                        $src  = $dir_path.$dir.'/'.$img['name'];
                        if(!is_file($src)){
                            continue;
                        }
                        $dest = $tmp_path.$dir.'_'.$img['name'];
                        copy($src,$dest);
                    }
                }
                // ORIGINALE MIT TEMPORAEREN ERSETZEN
                foreach($new_images_clean as $img){
                    foreach($directories as $dir){
                        $src = $tmp_path.$dir.'_'.$img['name'];
                        if(!is_file($src)){
                            continue;
                        }
                        $dest = $dir_path.$dir.'/'.str_replace('_'.$img['nr'].'.','_'.$img['new_pos'].'.',$img['name']);
                        copy($src,$dest);
                        unlink($src);
                    }
                }
                die(json_encode(array(
                    'ERROR'=>''
                )));
                break;
            case 'customers_status_prices_import':
                require_once('customers_status_prices_import.php');
                exit;
                break;
            case 'products_delete_check':
                $error = '';
                $mssgs = array();
                if(!isset($_GET['pID']) or empty($_GET['pID'])){
                    $error = 'Missing parameter';
                }else{
                    $pID = (int)xtc_db_input($_GET['pID']);
                    $product = new product($pID);
                    $res = $product->check_delete();
                    foreach($res as $rsn=>$num){
                        if($num > 0){
                            $mssgs[] = sprintf('%s: %s',$rsn,$num);
                        }
                    }
                    $msg = implode(', ',$mssgs);
                }
                die(json_encode(array(
                    'ERROR'=>$error,
                    'MSG'=>$msg
                )));
                break;
            case 'set_default_storage':
                if(!isset($_REQUEST['products_id'])){
                    die(json_encode(array(
                        'MSG'=>'Missing Parameter'
                    )));
                }
                $pID = (int)xtc_db_input($_REQUEST['products_id']);
                $default_storage_id = (int)xtc_db_input($_REQUEST['default_storage_id']);
                $product = new product($pID);
                $orig = ($product->info['default_storage'] > 0) ? xtc_get_storage_name($product->info['default_storage']) : '';
                $new = ($default_storage_id > 0) ? xtc_get_storage_name($default_storage_id) : '';
                $update_sql_array = array(
                    'default_storage'=>$default_storage_id,
                    'products_last_modified'=>'now()'
                );
                xtc_db_perform(TABLE_PRODUCTS,$update_sql_array,'update',"products_id='".$pID."'");
                $msg = sprintf(TEXT_PRODUCTS_DEFAULT_STORAGE_CHANGED,$orig,$new);
                $product->add_history($msg);
                die(json_encode(array(
                    'MSG'=>yes_encode_string($msg),
                    'NEW_STORAGE_LINK'=>xtc_href_link('storage_numbers.php','products_id='.$pID.'&action=ajax_add&stID='.$default_storage_id),
                    'BUTTON_NEW_STORAGE_NUMBER'=>BUTTON_NEW_STORAGE_NUMBER,
                )));
                break;
            case 'get_products_images_array':
                if(!isset($_REQUEST['pID'])){
                    die('missing params');
                }
                $array = array();
                $nr = 0;
                $pID = (int)xtc_db_input($_REQUEST['pID']);
                $product = new product($pID);
                if($product->info['products_image'] != ''){
                    $array[] = array(
                        'file'=>$product->info['products_image'],
                        'nr'=>$nr
                    );
                }
                if(sizeOf($product->mo_images)){
                    foreach($product->mo_images as $mo){
                        $array[] = array(
                            'file'=>$mo['image_name'],
                            'nr'=>$mo['image_nr']
                        );
                    }
                }
                die(json_encode(array(
                    'IMAGES'=>$array
                )));
                break;
	    case 'get_products_slaves_data':
		require_once(DIR_FS_INC.'yes_get_master_slave_keys.inc.php');
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		if($pID < 1)
		    die('parameter invalid');
		$smarty = new yesSmarty;
		$product = new product($pID);
		$slaves = $product->get_slaves();
		$slaves_data = array();
		foreach($slaves as $spID){
		    $sSQ = new products_quantity($spID);
		    $slave = new product($spID);
		    $slave_info = array_merge($slave->info,array(
			'PHYS'=>$sSQ->get_gesamtbestand_qty(),
			'V1'=>$sSQ->get_available1_qty(),
			'V2'=>$sSQ->get_available2_qty(),
		    ));
		    $slaves_data[] = array_merge($slave_info,array(
			'master_slave_values'=>$slave->get_master_slave_values($pID, $_SESSION['languages_id'])
		    ));
		}
		$smarty->assign(array(
		    'SLAVES'=>$slaves_data,
		    'MASTER_PID'=>$pID,
		    'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
		    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('categories_view_slaves.html');
		exit;
		break;
	    case 'cat2xml':
		require_once(DIR_FS_CATALOG.'includes/classes/cat2xml.php');
		$languages = xtc_get_languages();
		if(is_file(DIR_FS_CATALOG.'cat2xml_'.$languages[0]['id'].'.xml')){
		    $filectime = filectime(DIR_FS_CATALOG.'cat2xml_'.$languages[0]['id'].'.xml');
		    if($filectime > (time()-(60*60*1))  ){
			$comm = sprintf(MSG_ERROR_TIMESPAN_CATEGORIES_XML,
				date('H:i:s',$filectime)
			);
			$messageStack->add_session($comm,'error');
			xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
		    }
		}
		$basics->parseTime('start', 'createXML');
		foreach($languages as $l){
		    $cat2xml = new cat2xml($l['id']);
		    $cat2xml->create_xml_file( DIR_FS_CATALOG.'cat2xml_'.$l['id'].'.xml');
		}
		$res = $basics->parseTime('end', 'createXML');
		$messageStack->add_session(MSG_SUCCESS_GENERATED_CATEGORIES_XML.' - '.$res,'success');
		xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
		break;
	    case 'update_products_properties_property_file_image':
		$ppvID = (int)xtc_db_input($_REQUEST['ppvID']);
		$msg = '';
		$path = str_replace('..','',$_REQUEST['file_image']);
		if($path[0] == '/') $path[0] = '.';
		if(!is_file(DIR_FS_CATALOG.'files/'.$path)){
		    $msg = 'File '.$path.' unknown';
		}else{
		    $update_sql_array = array(
			'files_image'=>$path,
			'image'=>''
		    );
		    xtc_db_perform('products_properties_values',$update_sql_array,'update',"products_properties_values_id='".$ppvID."'");
		}
		die(json_encode(array(
		    'MSG'=>$msg
		)));
		break;
	    case 'search_results_filter':
		require_once('categories.search_results_filter.php');
		exit;
		break;
	    case 'allocate_master_slave_confirm':
		$invalid_products = array();
		$valid_products = array();
		foreach($_REQUEST['pID'] as $pID){
		    $pID = (int)xtc_db_input($pID);
		    $product = new product($pID);
		    if($product->info['products_master'] > 0){
			$invalid_products[] = array(
			    'products_id'=>$pID,
			    'message'=>sprintf(TEXT_ERROR_ALLOCATE_MASTER_SLAVE_IS_SLAVE,$product->info['products_master'])
			);
		    }elseif($product->info['products_master_status'] > 0){
			$invalid_products[] = array(
			    'products_id'=>$pID,
			    'message'=>TEXT_ERROR_ALLOCATE_MASTER_SLAVE_IS_MASTER
			);
		    }else{
			$valid_products[] = array(
			    'products_id'=>$pID,
			    'products_name'=>  xtc_get_products_name($pID),
			    'input'=>xtc_draw_radio_field('products_master',$pID,((!sizeOf($valid_products))?true:false))
			);
		    }
		    //echo '<li>'.$product->getSlaves();
		}
		$smarty = new yesSmarty;
		$smarty->assign(array(
		    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
		    'VALID_PRODUCTS'=>$valid_products,
		    'INVALID_PRODUCTS'=>$invalid_products,
		    'ALLOW_SUBMIT'=>(sizeOf($valid_products)>1) ? true : false,
		    'FORM'=>xtc_draw_form('allocate_master_slave',basename(__FILE__),'','GET'),
		    'HIDDEN_FIELDS'=>xtc_draw_hidden_field('action','master_slave').
			xtc_draw_hidden_field('ms_action','add_to_master'),
		    'FORM_END'=>'</form>',
		    'TEXT_ERROR_ALLOCATE_MASTER_SLAVE_NO_VALID_PRODUCTS'=>TEXT_ERROR_ALLOCATE_MASTER_SLAVE_NO_VALID_PRODUCTS
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('categories_allocate_master_slave_confirm.html');
		exit;
		break;
	    case 'copy_properties_process':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		if(!sizeOf($_REQUEST['ppID'])){
		    $messageStack->add_session(MSG_ERROR_COPY_PROPERTIES,'error');
		    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=new_product'));
		}
		foreach($_REQUEST['ppID'] as $ppID){
		    $ppID = (int)xtc_db_input($ppID);
		    $pp = new product_properties($ppID);
		    $copy_values = (isset($_REQUEST['copy_ppv'][$ppID]) and $_REQUEST['copy_ppv'][$ppID] == 1) ? true : false;
		    $pp->copy_to_product($pID,$copy_values);
		}
		$messageStack->add_session(MSG_SUCCESS_COPY_PROPERTIES,'success');
		xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=new_product'));
		break;
	    case 'get_product_properties_for_copy':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$ppID_array = yes_get_products_properties_id_array($pID);
		if(!sizeOf($ppID_array)){
		    $msg = sprintf(TEXT_ERROR_NO_PROPERTIES_FOR_PRODUCT,$pID);
		}
		$language_id = $_SESSION['languages_id'];   
		$props = array();
		foreach($ppID_array as $ppID){
		    $pp = new product_properties($ppID);
		    $ppd = $pp->getDescription($language_id);
		    $ppvalues = array();
		    foreach($pp->getValues($language_id) as $ppv){
			$ppvalues[] = array(
			    'title'=>yes_encode_string($ppv['description']->getTitle()),
			    'sort_order'=>$ppv['sort_order'],
			);
		    }
		    $props[] = array(
			'ppID'=>$ppID,
			'title'=>yes_encode_string($ppd->getTitle()),
			'values'=>$ppvalues
		    );
		}
                
		//header('Content-Type: text/html; charset='.CHARSET);
		die(json_encode(array(
		    'MSG'=>$msg,
		    'PROPERTIES'=>$props
		)));
		exit;
		break;
	    case 'copy_properties':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$smarty = new yesSmarty;
		$smarty->assign(array(
		    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
		    'PRODUCTS_ID'=>$pID,
		    'COPY_FORM_ACTION'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','ppID','copy_ppv')).'action=copy_properties_process'),
		    'JS_ERROR_INVALID_PID'=>JS_ERROR_INVALID_PID,
		    'TEXT_COPY_PRODUCTS_PROPERTIES_VALUES'=>TEXT_COPY_PRODUCTS_PROPERTIES_VALUES,
		    'JS_ERROR_SELF_PID'=>JS_ERROR_SELF_PID,
		    'TEXT_INTRO_COPY_PROPERTIES'=>TEXT_INTRO_COPY_PROPERTIES,
		    'TEXT_INTRO_LONG_COPY_PROPERTIES'=>TEXT_INTRO_LONG_COPY_PROPERTIES
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('product_properties_copy.html');
		exit;
		break;
	    case 'get_product_tags':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		require_once(DIR_FS_CATALOG.'includes/classes/yes_tags.php');
		$yt = new yes_tags('product');
		$as_tags = $yt->get_tag_list($pID);
		$av_tags = $yt->get_available_tag_list();
		$json = array(
			'availableTags'=>$av_tags,
			'assignedTags'=>$as_tags
		);
		die(json_encode($json));
		break;
	    case 'update_product_tags':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		require_once(DIR_FS_CATALOG.'includes/classes/yes_tags.php');
		$yt = new yes_tags('product');
		$yt->update_list($pID,$_REQUEST['tags']);
		exit;
		break;
	    case 'fake_sets':
		require_once(DIR_WS_MODULES.'YES_PAYMODULE_products_fake_sets.php');
		exit;
		break;
	case 'update_products_group_prices':
		require_once(DIR_FS_CATALOG.'/includes/classes/xtcPrice.php');
		require_once(DIR_WS_CLASSES . 'currencies.php');
		$products_id = (int)xtc_db_input($_REQUEST['products_id']);
		$collies = xtc_get_product_collies($products_id);
		$preisbindung = xtc_is_preisbindung($products_id);
		$submitted_price = (float)str_replace(',','.',xtc_db_input($_REQUEST['products_price']));
		
		// um price_is_brutto abfragen etc zu sparen, geben wir am ende einfach 
		// den vom User uebergebenen Preis zurueck. dann stimmts in jedem fall
		$return_price = $submitted_price; 
		
                // VERALTET
		//$submitted_tax_class_id = (int)xtc_db_input($_REQUEST['products_tax_class_id']);
                // EU OSS Konform
                $tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, STORE_COUNTRY);
                
		if (PRICE_IS_BRUTTO=='true' && $_REQUEST['products_price']){
                    if(COLLI_ACTIVE and sizeOf($collies)>0 and $preisbindung){
                        $tax_rate = xtc_get_product_collies_tax_value($collies, STORE_COUNTRY,0);
                        $submitted_price = ($submitted_price/($tax_rate+100)*100);
                    }else{
                        $submitted_price = ($submitted_price/(xtc_get_tax_rate($tax_class_id,STORE_COUNTRY)+100)*100);
                    }
		}
		$xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);
		// PREISBINDUNG CHECK
		if($preisbindung and sizeOf($collies)>0){
                    $preisbindung = xtc_get_preisbindung_value($products_id,1,$xtPrice);
                    if($preisbindung > $submitted_price){
                        die(json_encode(array(
                            'MSG'=>sprintf(MSG_ERROR_PRODUCTS_UPDATE_GROUP_PRICES,number_format($preisbindung,2,',','.'))
                        )));
                    }
		}
		// BOF - PREISE UEBERTRAGEN AUF SLAVES
		if(isset($_REQUEST['change_slave_prices']) and $_REQUEST['change_slave_prices'] == 1){
                    $slaves_array = array();
                    $slaves_query = xtc_db_query(sprintf(
                        "SELECT products_id FROM products WHERE products_master='%d'",
                        $products_id
                    ));
                    while($slaves = xtc_db_fetch_array($slaves_query)){
                        $slaves_array[] = $slaves['products_id'];
                    }
                    if(sizeOf($slaves_array)){
                        foreach($slaves_array as $slave_products_id){
                            $slave_update_sql_array = array(
                                'products_price'=>$submitted_price,
                                'products_discount_allowed'=>xtc_db_prepare_input($_REQUEST['products_discount_allowed']),
                            );
                            xtc_db_perform('products',$slave_update_sql_array,'update','products_id='.$slave_products_id);
                            product::add_history_static($slave_products_id, sprintf(
                                TEXT_UPDATE_PRODUCTS_GROUP_PRICES,
                                $products_id,$submitted_price,
                                xtc_db_prepare_input($_REQUEST['products_discount_allowed']),
                                xtc_get_tax_rate($submitted_tax_class_id)
                            ));
			}
                    }
		}
		// EOF PREISE UEBERTRAGEN AUF SLAVES
		
		$update_sql_array = array(
		    'products_last_modified'=>'now()',
		    'products_price'=>$submitted_price,
		    'products_discount_allowed'=>xtc_db_input(str_replace(',','.',$_REQUEST['products_discount_allowed']))
		);
		xtc_db_perform(TABLE_PRODUCTS,$update_sql_array,'update',"products_id='".$products_id."'");
		$product = new product($products_id);
		$product->add_history(sprintf(TEXT_HISTORY_PRODUCT_PRICE_CHANGE,
			number_format($submitted_price,2,',','.'),
			number_format(xtc_get_tax_rate($tax_class_id),2,',','.')
		));
		// KUNDENGRUPPENPREISE
		// Here we go, lets write Group prices into db
		// start
		$preisbindung_aktiv = false;
		if(COLLI_ACTIVE){
		      if(sizeOf($collies)>0){
			      if(xtc_is_preisbindung($products_id)){
				      $preisbindung_aktiv = true;
			      }
		      }
		}

		// ERMITTELE ALLE KUNDENGRUPPEN
		$i = 0;
		$group_data = array();
                $cs_array = xtc_get_customers_statuses();
		foreach($cs_array as $group_values) {
                    if($group_values['id'] > 0){
                        // load data into array
                        $i++;
                        $group_data[$i] = array(
                            'STATUS_ID' => $group_values['id'],
                            'STATUS_NAME' => $group_values['text'],
                        );
                    }
		}

		if($preisbindung){
                    // LOESCHE ALLE STAFFEL/KUNDENGRUPPENPREISE
		    for ($col = 0, $n = sizeof($group_data); $col < $n+1; $col++) {
                        if ($group_data[$col]['STATUS_ID'] == '') {
                            continue;
                        }
                        \YES4Trade\Model\group_prices::delete_by_products_id(
                            $group_data[$col]['STATUS_ID'], $products_id
                        );
		    }

		    $in_collies = xtc_get_product_in_collies($products_id);
		    if(sizeOf($in_collies)>0){
                        foreach($in_collies as $k=>$v){
                            $icpID = $v['products_id'];
                            // LOESCHE DIE STAFFEL/KUNDENGRUPPENPREISE DER STUECKLISTENPRODUKTE
                            // DIE DIESES PRODUKT ENTHALTEN
                            for ($col = 0, $n = sizeof($group_data); $col < $n+1; $col++) {
                                if ($group_data[$col]['STATUS_ID'] == '') {
                                    continue;
                                }
                                \YES4Trade\Model\group_prices::delete_by_products_id(
                                    $group_data[$col]['STATUS_ID'], $icpID
                                );
                            }
                            // CHECKE DIE PREISBINDUNG DER STKLISTEN
                            $ic_collies = xtc_get_product_collies($icpID);
                            $ic_preisbindung = xtc_get_preisbindung_value($icpID,1,$xtPrice);
                            $ic_tax_rate = xtc_get_product_collies_tax_value($ic_collies, STORE_COUNTRY,0);
                            $ic_products_price_query = xtc_db_query("SELECT products_price FROM products WHERE products_id='".$icpID."'");
                            $ic_products_price = xtc_db_fetch_array($ic_products_price_query);
                            $ic_products_price = ($ic_products_price['products_price']/($ic_tax_rate+100)*100);
                            // PREIS UNTERHALB PREISBINDUNG -> PRODUKTSTATUS NULL UND MELDUNG
                            if($ic_preisbindung > $ic_products_price){
                                $pname = xtc_get_products_name($products_id);
                                $ipname = xtc_get_products_name($icpID);
                                $string = sprintf(NOTICE_NOTE_PRICE_FIXING_PRODUCT_ALERT,
                                    $pname,
                                    $products_id,
                                    number_format($submitted_price,2,',',''),
                                    $ipname,
                                    $icpID
                                );
                                product::update_status($icpID, false, $string);
                                $capt = sprintf(NOTICE_CAPT_PRICE_FIXING_PRODUCT_ALERT,$icpID);
                                $recipients_array = main::get_notice_recipients('f_change_products_price_fixing');
                                yes_write_notice($capt, $string, 0, $recipients_array);
                            }
			}
		    }
		}else{
		    for ($col = 0, $n = sizeof($group_data); $col < $n+1; $col++) {
                        if (!isset($group_data[$col]['STATUS_ID']) or $group_data[$col]['STATUS_ID'] == '') {
                            continue;
                        }
                        $personal_price = xtc_db_prepare_input(str_replace(',','.',$_REQUEST['products_price_' . $group_data[$col]['STATUS_ID']]));
                        if ($personal_price == '' or $personal_price=='0.0000') {
                            $personal_price = 0;
                        } else {
                            if (PRICE_IS_BRUTTO=='true'){
                                $personal_price= ($personal_price/(xtc_get_tax_rate($tax_class_id) +100)*100);
                            }
                            $personal_price=xtc_round($personal_price,PRICE_PRECISION);
                        }
                        $group_price_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                            $group_data[$col]['STATUS_ID'], $products_id
                        );
                        foreach($group_price_items as $GPI){
                            if($GPI->quantity == 1){
                                $GPI_one = $GPI;
                            }
                        }
                        if($GPI_one->personal_offer <> (float)$personal_price){
                            $GPI_update = new \YES4Trade\Model\group_prices_item([
                                'products_id'=>(int)$GPI_one->products_id,
                                'price_id'=>(int)$GPI_one->price_id,
                                'quantity'=>(int)$GPI_one->quantity,
                                'personal_offer'=>(float)$personal_price
                            ]);
                            $GPI_update->update($group_data[$col]['STATUS_ID']);
                            // products_history
                            $comments = sprintf(HISTORY_PRODUCTS_GROUP_PRICE_CHANGED,
                                $group_data[$col]['STATUS_NAME'],
                                number_format($GPI_one->personal_offer,2,',','.'),
                                number_format((float)$personal_price,2,',','.')
                            );
                            product::add_history_static($products_id, $comments);
                        }
                        
                        // BOF - SLAVE PREISE
                        if(isset($_REQUEST['change_slave_prices']) and $_REQUEST['change_slave_prices'] == 1){
                            if(sizeOf($slaves_array)){
                                foreach($slaves_array as $slave_products_id){
                                    $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                                        $group_data[$col]['STATUS_ID'], $slave_products_id
                                    );
                                    foreach($group_prices_items as $GPI){
                                        if($GPI->quantity <> 1){
                                            continue;
                                        }
                                        $GPI_update = new \YES4Trade\Model\group_prices_item([
                                            'price_id'=>$GPI->price_id,
                                            'products_id'=>$GPI->products_id,
                                            'quantity'=>$GPI->quantity,
                                            'personal_offer'=>$personal_price
                                        ]);
                                        $GPI_update->update($group_data[$col]['STATUS_ID']);
                                        product::add_history_static($GPI->products_id, 
                                            sprintf(
                                                TEXT_UPDATE_PRODUCTS_GROUP_PRICES_SHORT,
                                                $group_data[$col]['STATUS_NAME'],
                                                $products_id,
                                                number_format($personal_price,2,',','.')
                                            )
                                        );
                                    }
                                }
                            }
                        } // end if chance slave_prices
                    } // end for customers_statuses
		}// end if !$preisbindung
		
		die(json_encode(array(
		    'MSG'=>'',
		    'products_id'=>$products_id,
		    'price'=>$xtPrice->xtcFormat($return_price,true)
		)));
		break;
	    case 'edit_price_json':
		if($admin_access['f_change_products_price'] != 1){
		    die('missing auth');
		}
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$product = new product($pID);
		$tax_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
		$tax_class_query = xtc_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
		while ($tax_class = xtc_db_fetch_array($tax_class_query)) {
			$tax_class_array[] = array('id' => $tax_class['tax_class_id'],
				'text' => $tax_class['tax_class_title']);
		}
		$pInfo = new objectInfo($product->info);
		$collies = xtc_get_product_collies($pID);
		$smarty = new yesSmarty;
		$_GET['pID'] = $pID;
		$USE_NO_STAFFELPREISE = 1;
		include(DIR_WS_MODULES.'group_prices.php');
		$smarty->assign(array(
		    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
		    'products_id'=>$pID,
		    'TOGGLE_GROUP_PRICES'=>TOGGLE_GROUP_PRICES
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('product_group_prices_edit.html');
		exit;
		break;
	    case 'update_category_ebayapi_cart_process':
		$cID = (int)xtc_db_input($_REQUEST['cID']);
		if(isset($_REQUEST['ebayapi_cart']) and $_REQUEST['ebayapi_cart'] == 1){
		    $ebayapi_cart = 1;
		}else{
		    $ebayapi_cart = 0;
		}
                $upd = new \YES4Trade\Model\category([
                    'categories_id'=>(int)$cID,
                    'ebayapi_cart'=>$ebayapi_cart
                ]);
                $upd->update();
		if(isset($_REQUEST['recursion']) and $_REQUEST['recursion'] == 1){
			xtc_set_categories_ebayapi_cart_rekursiv($cID, $ebayapi_cart);
		}
		die(json_encode(array(
		    'cID'=>$cID,
		    'ebayapi_cart'=>$ebayapi_cart
		)));
		break;
	    case 'update_category_ebayapi_cart':
		$cID = (int)xtc_db_input($_REQUEST['cID']);
                $ec = \YES4Trade\Model\category::get_by_categories_id($cID,[
                    'ebayapi_cart'
                ]);
                if($ec == null){
                    die('Unknown category '.$cID);
                }
		$cart = ($ec !== null) ? intval($ec->ebayapi_cart) : 0;
		echo xtc_draw_form('change_category_ebayapi_cart',FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=update_category_ebayapi_cart_process');
		printf('%s&nbsp;&nbsp;%s<br />', 
			xtc_draw_checkbox_field('ebayapi_cart','1',(($cart == 1)?true:false),false),
			TEXT_UPDATE_CATEGORY_EBAYAPI_CART
		);
		printf('&nbsp;&nbsp;&nbsp;&nbsp;%s&nbsp;&nbsp;<i>%s</i><br />',
			xtc_draw_checkbox_field('recursion','1',false),
			TEXT_UPDATE_CATEGORY_EBAYAPI_CART_RECURSION
		);
		echo '<br /><input type="button" value="'.IMAGE_UPDATE.'" class="ui-button ui-corner-all ui-state-default" onclick="update_ebayapi_cart();" />';
		echo '</form>';
		exit;
		break;
	case 'labelprint':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$query = xtc_db_query(sprintf(
			"SELECT products_model,products_ean FROM %s WHERE products_id='%s' AND products_ean != ''",
			TABLE_PRODUCTS,$pID
		));
		if(!xtc_db_num_rows($query)){
		    $messageStack->add_session(sprintf(MSG_ERROR_LABELPRINT_NO_EAN,$pID));
		    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
		}
        $config = parse_ini_file(DIR_FS_ADMIN."includes/barcode.conf");
        foreach($config as $k=>$v){
            $config[$k] = str_replace("'",'',$v);
        }
        $record = xtc_db_fetch_array($query);
		
        $smarty = new yesSmarty;
        $files = array();
        $image_query = xtc_db_query(sprintf(
                "SELECT products_image FROM products WHERE products_id='%s'",
                (int)xtc_db_input($_REQUEST['pID'])
        ));
        $image = xtc_db_fetch_array($image_query);
        if($image['products_image'] != ''){
            $files[] = $image['products_image'];
        }
        $mo_image_query = xtc_db_query(sprintf(
                "SELECT image_name FROM products_images WHERE products_id='%s'",
                (int)xtc_db_input($_REQUEST['pID'])
        ));
        while($mo_image = xtc_db_fetch_array($mo_image_query)){
            $files[] = $mo_image['image_name'];
        }
        $barcode_file_name = 'PBC_'.$pID.'.png';
        if(is_file(\main::get_exportdata_path().$barcode_file_name)){
            unlink(\main::get_exportdata_path().$barcode_file_name);
        }
        require_once(DIR_FS_INC.'xtc_generate_packingslip_barcode.inc.php');
        $filename = xtc_generate_packingslip_barcode($pID, \main::get_exportdata_path().$barcode_file_name);
        $smarty->assign(array(
            'BARCODE'=>"<img src=\"".HTTPS_CATALOG_SERVER."admin/barcode.php?code=$pID\" />",
            'EAN'=>$record['products_ean'],
            'PRODUCTS_MODEL'=>$record['products_model'],
            'PRODUCTS_ID'=>$pID
        ));
        if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                $smarty->assign('PRODUCTS_MODEL','<span style="font-size: 9px;">'.$record['products_model'].'</span><br />');
                $px2pt_faktor = 1.3333333333333;
                $smarty->assign('BARCODE',"<img src=\"".HTTPS_CATALOG_SERVER."/admin/barcode.php?code=$pID\" width=\"150\" alt=\"$pID\">");
        }


		$html = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/barcode_products.html');
		if( !defined('USE_DOMPDF') or USE_DOMPDF != 'True'){
		    require_once("includes/classes/class.html2pdf.php");
		}
		// FUEGE ORDER AN GESAMTPDF AN
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $pdf = new yes_pdf();
            // KEIN PLAN 05/25
            // pt -> mm = Faktor 0,3527
            //$mm2pt_faktor = 0.3527;
            //$paper_size = array(0,0,((int)$config['barcode_page_width']/$mm2pt_faktor),((int)$config['barcode_page_height']/$mm2pt_faktor));
            //$smarty->assign('PRODUCTS_MODEL',$record['products_model']);
		    //$pdf->set_paper($paper_size);
		    $pdf->set_html($html);
		    $pdf->output('PRODUCTS_LABEL_'.$pID.'.pdf');
		    exit;
		}else{
		    $packingslip_pdf=new HTML2FPDF('P','mm',array($config['barcode_page_width'],$config['barcode_page_height']));
		    $packingslip_pdf->SetMargins(1,1);
		    $packingslip_pdf->lineheight = 4;
		    $packingslip_pdf->SetFont('Helvetica','',10);
		    // FUEGE LIEFERSCHEIN AN GESAMTPDF AN
		    $packingslip_pdf->AddPage();
		    $packingslip_pdf->WriteHTML($html);
		    $packingslip_pdf->Output('PRODUCTS_LABEL_'.$pID.'.pdf','D'); //Read the FPDF.org manual to know the other options
		}
		
		exit;
		break;
	    case 'quick_physical_qty':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$SQ = new products_quantity($pID,'direct');
		$new_qty = (int)xtc_db_input($_REQUEST['qty']);
		$comment = sprintf(MSG_SUCCESS_EDIT_PRODUCTS_PHYSICAL_QUANTITY,$new_qty);
		$SQ->inventur_qty( $new_qty, $comment,$update_storage_quantity=true);
		xtc_db_query(sprintf(
			"UPDATE storage_products SET quantity=0 WHERE products_id='%s'",
			$SQ->get_products_id()
		));
		$SQ = new products_quantity($pID);
		die(sprintf(
			SHORT_PRODUCTS_QUANTITY_INFO,
			$SQ->get_products_total_qty(),
			$SQ->get_available1_qty(),
			$SQ->get_available2_qty()
		));
		exit;
		break;
            case 'images_upload':

                // AUFRAEUMEN VERALTETE UPLOADS
                $dropzone_main_dir = 'importdata/DROPZONE_UPLOAD/';
                if(!is_dir($dropzone_main_dir)){
                    mkdir($dropzone_main_dir, 0775, true);
                }
                $files = new DirectoryIterator($dropzone_main_dir);
                $now = time();

                foreach ($files as $f) {
                    if ($f->isDot() || !$f->isDir()) continue;
                    $dir = $f->getPathname();
                    if ($now - $f->getMTime() > 3600 * 24) { // älter als 24 Stunden
                        shell_exec("rm -rf " . escapeshellarg($dir));
                    }
                }            



                @include(DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/quick_product_add.php');
                $smarty = new yesSmarty;
                $files = array();
                $image_query = xtc_db_query(sprintf(
                        "SELECT products_image FROM products WHERE products_id='%s'",
                        (int)xtc_db_input($_REQUEST['pID'])
                ));
                $image = xtc_db_fetch_array($image_query);
                if($image['products_image'] != ''){
                    $files[] = $image['products_image'];
                }
                $mo_image_query = xtc_db_query(sprintf(
                        "SELECT image_name FROM products_images WHERE products_id='%s'",
                        (int)xtc_db_input($_REQUEST['pID'])
                ));
                while($mo_image = xtc_db_fetch_array($mo_image_query)){
                    $files[] = $mo_image['image_name'];
                }

                $bytes = \basics::ini_get_bytes(ini_get('upload_max_filesize'));
                $mb = (int) round($bytes / 1024 / 1024);

                $ps_bytes = \basics::ini_get_bytes(ini_get('post_max_size'));
                $ps_mb = (int) round($ps_bytes / 1024 / 1024);
                $limits = [
                    'max_file_uploads'=>ini_get('max_file_uploads'),
                    'upload_max_filesize'=>$mb,
                    'post_max_size'=>$ps_mb,
                ];
                $smarty->assign(array(
                    'PRODUCTS_ID'=>(int)xtc_db_input($_REQUEST['pID']),
                    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
                    'BUTTON_IMAGES_UPLOAD'=>BUTTON_IMAGES_UPLOAD,
                    'BUTTON_START'=>BUTTON_START,
                    'BUTTON_ADD'=>BUTTON_ADD,
                    'PHP_LIMITS'=>$limits,
                    'BUTTON_CANCEL'=>BUTTON_CANCEL,
                    'HEADING_TITLE'=>HEADING_TITLE,
                    'ERROR'=>((isset($_REQUEST['error']))?1:0),
                    'SUCCESS'=>((isset($_REQUEST['products_id']))? sprintf(TEXT_PRODUCT_ADDED,$link_pID): ''),
                    'TEXT_NO_EBAY_IMAGE'=>TEXT_NO_EBAY_IMAGE,
                    'TEXT_NO_SHOP_IMAGE'=>TEXT_NO_SHOP_IMAGE,
                    'TEXT_EBAY_GALLERY'=>TEXT_EBAY_GALLERY,
                    'JS_ERROR_FILL_OUT_ALL_FIELDS'=>JS_ERROR_FILL_OUT_ALL_FIELDS,
                    'FILES'=>$files,
                    'FORM_ACTION'=>xtc_href_link('categories.php',xtc_get_all_get_params(array('action')).'action=process_images_upload'),
                    'EXISTING_FILES_INTRO'=>EXISTING_FILES_INTRO,
                    'JQUERY_CSS_LINK'=>yes_get_cdn_link('jquery-ui-css','1.10.3','start'),
                    'JQUERY_JS_LINK'=>yes_get_cdn_link('jquery','1.9.1'),
                    'JQUERYUI_JS_LINK'=>yes_get_cdn_link('jquery-ui','1.10.3'),
                ));
                yes_draw_pre_header();
                $smarty->display('products_images_upload.html');
                exit;
                break;
	    case 'update_property_value_image':
		$image = (isset($_REQUEST['image'])) ? xtc_db_input($_REQUEST['image']) : '';
		$ppvID = (int)xtc_db_input($_REQUEST['id']);
		xtc_db_query(sprintf(
			"UPDATE products_properties_values SET image='%s',files_image='' WHERE products_properties_values_id='%s'",
			$image,$ppvID
		));
		die($image);
		break;
    case 'add_products_properties_property_value':
			$ppID = (int)xtc_db_input($_REQUEST['products_properties_id']);
			$pp = new product_properties($ppID);
			$languages = xtc_get_languages();
			$smarty = new yesSmarty;
			$smarty->secure_dir[] = DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/';
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                (int)xtc_db_input($_REQUEST['pID']), STORE_COUNTRY
            );
            $products_tax_rate = xtc_get_tax_rate($products_tax_class_id, STORE_COUNTRY);
//			$record = xtc_db_fetch_array($query);
			$_images_array = array();
			$_images_array[] = array('id'=>'','text'=>TEXT_NONE);
			$images_array = xtc_array_merge($_images_array,yes_get_products_images((int)xtc_db_input($_REQUEST['pID'])));
			
			$saved_values = array();
			foreach($languages as $lang){
                            $values = $pp->getValues($lang['id']);
                            foreach($values as $v){
                                if (PRICE_IS_BRUTTO == 'true'){
                                    $price = xtc_oe_get_price_i_tax($v['price'], $products_tax_rate);
                                } else {
                                    $price = $v['price'];
                                }
                                $saved_values[ $v['description']->getProducts_properties_values_id() ][ $lang['id'] ] = array(
                                    'title'=>$v['description']->getTitle(),
                                    'sort_order'=>$v['sort_order'],
                // BOF - input_span AENDERUNGEN 2023/06
                                    'input_span'=>$v['input_span'],
                // EOF - input_span AENDERUNGEN 2023/06
                                    'price'=>number_format($price,2,'.',''),
                                    'xy_percent_add'=>number_format($v['xy_percent_add'],2,'.',''),
                                    'image'=>$v['image'],
                                    'image_input'=>xtc_draw_pull_down_menu('image',  $images_array,$v['image'],'id="'.$v['description']->getProducts_properties_values_id().'" class="select_property_value_image"'),
                                    'files_image_input'=>xtc_draw_input_field('files_image','','size="32" maxlength="128" id="files_image_'.$v['description']->getProducts_properties_values_id().'"'),
                                    'files_image'=>$v['files_image']
                                );
                            }
			}
			$smarty->assign(array(
                'link_add_products_property_values'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=add_product_property_values'),
                'link_update_property_value_image'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=update_property_value_image'),
                'link_delete_products_properties_property_value'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=delete_product_properties_property_value'),
                'languages'=>$languages,
                'saved_values'=>$saved_values,
                'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
                'PATH_TO_TINYMCE_FILEMANAGER'=>yes_get_cdn_link('tinymce_filemanager'),
                'CDN_LINK_TINYMCE'=>yes_get_cdn_link('tinymce'),
			));
			header('Content-Type: text/html; charset='.CHARSET);
			$html = $smarty->fetch(DIR_FS_ADMIN.'templates/product_properties_values.html');
			echo $html;
			exit;
			break;
		case 'add_product_property_values':
			$ppID = (int)xtc_db_input($_REQUEST['products_properties_id']);
			// KEIN WIRKLICHES EDIT - EINFACH DELETE UND NEU
			$ppvID = 0;
			if(isset($_REQUEST['ppvID']) and $_REQUEST['ppvID'] > 0){
			    $ppvID = (int)xtc_db_input($_REQUEST['ppvID']);
			}
			$sort_order = (isset($_REQUEST['sort_order'])) ? (int)xtc_db_input($_REQUEST['sort_order']) : 0;
                        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            (int)xtc_db_input($_REQUEST['pID']),STORE_COUNTRY
                        );
                        $products_tax_rate = xtc_get_tax_rate(
                            $products_tax_class_id, STORE_COUNTRY
                        );
			$price = xtc_db_input(str_replace(',','.',$_REQUEST['price']));
                        
                        // BOF - input_span AENDERUNGEN 2023/06
                        $input_span = '';
                        if(isset($_GET['input_span']) and $_GET['input_span'] != ''){
                            $input_span = xtc_db_input($_GET['input_span']);
                        }
                        // EOF - input_span AENDERUNGEN 2023/06

                        $xy_percent_add = 0;
                        if(isset($_GET['xy_percent_add']) and $_GET['xy_percent_add'] != ''){
                            $xy_percent_add = (float)xtc_db_input(str_replace(',','.',$_GET['xy_percent_add']));
                        }
                        
			if (PRICE_IS_BRUTTO == 'true'){
                            $price = xtc_oe_get_price_o_tax($price, $products_tax_rate);
    			}
			if($ppvID == 0){ // NEU
			    $insert_sql_array = array(
                                'products_properties_id'=>$ppID,
                                'sort_order'=>$sort_order,
                                'price'=>$price,
                                'xy_percent_add'=>$xy_percent_add,
                // BOF - input_span AENDERUNGEN 2023/06
                                'input_span'=>$input_span,
                // EOF - input_span AENDERUNGEN 2023/06
			    );
			    xtc_db_perform('products_properties_values',$insert_sql_array);
			    $ppvID = xtc_db_insert_id();
			    $_images_array = array();
			    $_images_array[] = array('id'=>'','text'=>TEXT_NONE);
			    $images_array = xtc_array_merge($_images_array,yes_get_products_images((int)xtc_db_input($_REQUEST['pID'])));
			    $json_array = array(
                                'sort_order'=>$sort_order,
                                'price'=>number_format(str_replace(',','.',$_REQUEST['price']),2,'.',''),
                                'xy_percent_add'=>$xy_percent_add,
                                'products_properties_values_id'=>$ppvID,
                                'products_properties_id'=>$ppID,
                                'description'=>array(),
                                'image_input'=>xtc_draw_pull_down_menu('image',  $images_array,'','id="'.$ppvID.'" class="select_property_value_image"'),
                                'files_image_input'=>xtc_draw_input_field('files_image','','size="32" maxlength="128" id="files_image_'.$ppvID.'"'),
                                'files_image'=>'',
                // BOF - input_span AENDERUNGEN 2023/06
                                'input_span'=>$input_span,
                // EOF - input_span AENDERUNGEN 2023/06
                                'updated'=>0
			    );
			    foreach($_REQUEST['title'] as $language_id=>$title){
                                $insert_sql_array = array(
                                    'products_properties_values_id'=>$ppvID,
                                    'language_id'=>$language_id,
                                    'title'=>yes_decode_string($title)
                                );
                                xtc_db_perform('products_properties_values_description',$insert_sql_array);
                                $json_array['description'][] = array(
                                    'title'=>$title,
                                    'language_id'=>$language_id
                                );
			    }
			}else{
			    $update_sql_array = array(
                                'sort_order'=>$sort_order,
                                'price'=>$price,
                                'xy_percent_add'=>$xy_percent_add,
                // BOF - input_span AENDERUNGEN 2023/06
                                'input_span'=>$input_span,
                // EOF - input_span AENDERUNGEN 2023/06
			    );
			    xtc_db_perform('products_properties_values',$update_sql_array,'update',"products_properties_values_id='".$ppvID."'");
			    $json_array = array(
                                'sort_order'=>$sort_order,
                                'price'=>number_format(str_replace(',','.',$_REQUEST['price']),2,'.',''),
                                'xy_percent_add'=>number_format($xy_percent_add,2,'.',''),
                                'products_properties_values_id'=>$ppvID,
                                'products_properties_id'=>$ppID,
                                'description'=>array(),
                // BOF - input_span AENDERUNGEN 2023/06
                                'input_span'=>$input_span,
                // EOF - input_span AENDERUNGEN 2023/06
                                'updated'=>1
			    );
			    foreach($_REQUEST['title'] as $language_id=>$title){
                                $update_sql_array = array(
                                    'title'=>yes_decode_string($title)
                                );
                                xtc_db_perform('products_properties_values_description',$update_sql_array,'update',"products_properties_values_id='".$ppvID."' AND language_id='".$language_id."'");
                                $json_array['description'][] = array(
                                    'title'=>$title,
                                    'language_id'=>$language_id
                                );
			    }
			}
			die(json_encode($json_array));
			break;
		case 'delete_product_property':
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$ppID = (int)xtc_db_input($_REQUEST['products_properties_id']);
			$pp = new product_properties($ppID);
			$pp->delete();
			echo $ppID; // ausgeben lassen
			exit;
			break;
		case 'delete_product_properties_property_value':
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$ppvID = (int)xtc_db_input($_REQUEST['products_properties_values_id']);
			$ppID = (int)xtc_db_input($_REQUEST['products_properties_id']);
			$ppv = new product_properties_values($ppvID);
			$ppv->delete();
			echo $ppID;
			exit;
			break;
		case 'product_properties':
			$pID = (int)xtc_db_input($_REQUEST['pID']);
                        $product = new \product($pID);
			$languages = xtc_get_languages();
			$smarty = new yesSmarty;
			$smarty->secure_dir[] = DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/';
			$properties = array();
			$products_properties = yes_get_products_properties_id_array($pID);
                        
			if(sizeOf($products_properties)){
				foreach($products_properties as $ppID){
					$pp = new product_properties($ppID);
					$descriptions = array();
					$values = array();
					foreach($languages as $lang){
						$desc = $pp->getDescription( $lang['id'] );
						$descriptions[ $lang['id'] ] = array(
							'title'=>$desc->getTitle(),
                                                        'text'=>$desc->getText(),
							'products_properties_description_id'=>$desc->getProducts_properties_description_id()
						);
						$val_array = $pp->getValues( $lang['id'] );
						$num_values = 0;
						foreach($val_array as $val){
							$values[ $lang['id'] ][] = array(
								'title'=>$val['description']->getTitle(),
								'products_properties_values_description_id'=>$val['description']->getProducts_properties_values_description_id()
							);
							$num_values++;
						}
					}
					$properties[] = array(
						'products_properties_id'=>$pp->getProducts_properties_id(),
						'sort_order'=>$pp->getSort_order(),
                                                'tag'=>$pp->getTag(),
						'descriptions'=>$descriptions,
						'values'=>$values,
						'num_values'=>$num_values
					);
				}
			}
                        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($pID);
                        $xy_exists = ($xy === false) ? '0' : '1';
			$smarty->assign(array(
				'link_add_product_property'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=add_product_property'),
				'link_delete_products_property'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=delete_product_property'),
				'languages'=>$languages,
				'saved_properties'=>$properties,
				'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
				'link_add_products_properties_property_value'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=add_products_properties_property_value'),
				'BUTTON_COPY_FROM_PID'=>BUTTON_COPY_FROM_PID,
			    'PRODUCTS_ID'=>$pID,
			    'COPY_PROPERTIES_BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))),
                            'XY_EXISTS'=>$xy_exists,
                            'XY'=>$xy,
			));
			header('Content-Type: text/html; charset='.CHARSET);
			$html = $smarty->fetch(DIR_FS_ADMIN.'templates/product_properties.html');
			echo $html;
			exit;
			break;
		case 'add_product_property':
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$ppID = (isset($_REQUEST['products_properties_id']) and $_REQUEST['products_properties_id'] > 0) ? (int)xtc_db_input($_REQUEST['products_properties_id']) : 0;
			$sort_order = (isset($_REQUEST['sort_order'])) ? (int)xtc_db_input($_REQUEST['sort_order']) : 0;
			$tag = (isset($_REQUEST['tag'])) ? xtc_db_input($_REQUEST['tag']) : '';
			$insert_sql_array = array(
				'products_id'=>$pID,
				'date_added'=>'now()',
				'sort_order'=>$sort_order,
                            'tag'=>$tag,
			);
			if($ppID == 0){
			    xtc_db_perform('products_properties',$insert_sql_array);
			    $ppID = xtc_db_insert_id();
			}else{
			    unset($insert_sql_array['date_added']);
			    xtc_db_perform('products_properties',$insert_sql_array,'update',"products_properties_id='".$ppID."'");
			}
			$languages = xtc_get_languages();
			$json_array = array(
				'sort_order'=>$sort_order,
				'products_properties_id'=>$ppID,
				'description'=>array(),
                            'tag'=>$tag,
			);
			foreach( $_REQUEST['title'] as $language_id=>$title){
				xtc_db_query(sprintf(
				    "DELETE FROM products_properties_description WHERE products_properties_id='%s' AND language_id='%s'",
				    $ppID,$language_id
				));
                                $desc = $_REQUEST['properties_text'][$language_id];
				$insert_sql_array = array(
					'products_properties_id'=>$ppID,
					'language_id'=>$language_id,
					'title'=>yes_decode_string($title),
                                    'properties_text'=>yes_decode_string($desc),
				);
				xtc_db_perform('products_properties_description',$insert_sql_array);
				$ppdID = xtc_db_insert_id();
				foreach($languages as $lang){
					if($lang['id'] == $language_id){
						$language_name = $lang['name'];
					}
				}
				$json_array['description'][] = array(
					'products_properties_description_id'=>$ppdID,
					'title'=>$title,
                                    'properties_text'=>$desc,
					'language_id'=>$language_id,
				);
			}
			die(json_encode($json_array));
			break;
		case 'autoscroll':
			print_r($_REQUEST);
			exit;
			break;
		case 'move_from_products_detail_page_process':
			$pID = intval($_REQUEST['pID']??0);
			if($pID <= 0){
                throw new Exception('Missing params for move_from_products_detail_page_process');
            }
			$src = (int)xtc_db_input($_REQUEST['src_categories_id']);
			if(!isset($_REQUEST['categories_id']) or intval($_REQUEST['categories_id']) < 0){
				$messageStack->add_session(MSG_ERROR_NO_TARGET_CATEGORY_SELECTED,'error');
				xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=new_product'));
			}
			$target = (int)xtc_db_input($_REQUEST['categories_id']);
			
            $p2c_count = \YES4Trade\Model\products_to_categories::count_items(
                $pID,$target
            );
                                
			if($p2c_count > 0){
                $messageStack->add_session(MSG_ERROR_TARGET_CATEGORY_ALLOCATION_EXISTS,'error');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=new_product'));
			}
			$product = new product($pID);
            // BOF - default_category
            if($product->info['default_category'] == $src){
                $update_sql_array = [
                    'default_category'=>$target
                ];
                yes_db_perform(TABLE_PRODUCTS, $update_sql_array,'update',[
                    'products_id'=>$pID
                ]);
            }
            // EOF - default_category
                        
            \YES4Trade\Model\products_to_categories::delete($pID,(int)$src);
            $new = new \YES4Trade\Model\products_to_categories([
                'products_id'=>$pID,
                'categories_id'=>(int)$target
            ]);
            $new->create();
			$comments = sprintf(TEXT_HISTORY_PRODUCT_MOVED, xtc_get_categories_name($src, $_SESSION['languages_id']), xtc_get_categories_name($target, $_SESSION['languages_id']));
			$product->add_history($comments);
			$messageStack->add_session($comments,'success');
			xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=new_product'));
			exit;
			break;
		case 'move_from_products_detail_page':
			$smarty = new yesSmarty;
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			if($pID <= 0){
				throw new Exception('Missing parameter for move_from_products_detail_page');
            }
            $items = \YES4Trade\Model\products_to_categories::get_items_by_products_id($pID);
			$categories_array = array();
			foreach($items as $p2c){
				$categories_array[] = array(
                    'id'=>$p2c->categories_id,
                    'text'=>xtc_get_categories_name($p2c->categories_id, $_SESSION['languages_id'])
				);
			}
            $cat_select = \YES4Trade\Model\category::get_categories_tree_select([
                'return_function'=>sprintf('$(\'input[name="categories_id"]\').val(id);'),
                'ALL_ITEMS_SELECTABLE'=>'false'
            ], new \yesSmarty());
            
			$smarty->assign(array(
                'FORM'=>xtc_draw_form('move_from_products_detail_page_form',FILENAME_CATEGORIES,xtc_get_all_get_params(array('action','categories_id')).'action=move_from_products_detail_page_process'),
                'INPUT_SRC'=>xtc_draw_pull_down_menu('src_categories_id',$categories_array),
                'IMAGE_SAVE'=>IMAGE_SAVE,
                'INPUT_CATEGORIES'=>$cat_select
                    . '<br />Category ID'
                    . xtc_draw_input_field('categories_id','','size="8"',false,'number'),
                'TEXT_MOVE_PRODUCT_FROM_CATEGORY'=>TEXT_MOVE_PRODUCT_FROM_CATEGORY,
                'TEXT_MOVE_PRODUCT_TO_CATEGORY'=>TEXT_MOVE_PRODUCT_TO_CATEGORY
			));
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('move_from_products_detail_page.html');
			exit;
			
			break;
		case 'filter_new_products':
			$durations = array(
				array('id'=>1,'text'=>'1 Tag'),
				array('id'=>3,'text'=>'3 Tage'),
				array('id'=>7,'text'=>'7 Tage'),
				array('id'=>14,'text'=>'2 Wochen'),
				array('id'=>28,'text'=>'1 Monat'),
				array('id'=>84,'text'=>'3 Monate'),
				array('id'=>365,'text'=>'1 Jahr')
			);
			echo '<div class="main">'.xtc_draw_form('dayform',FILENAME_CATEGORIES,'','GET');
                        foreach($_GET as $get_key=>$get_value){
                            $add = true;
                            switch($get_key){
                                case 'x':
                                case 'y':
                                case 'page':
                                case 'days':
                                case 'action':
                                    $add = false;
                                    break;
                            }
                            if($add){
                                echo xtc_draw_hidden_field($get_key, $get_value);
                            }
                        }
			printf('<fieldset><legend>%s</legend>',TEXT_FILTER_NEW_PRODUCTS_INTRO);
			printf('<label for="days">%s</label>%s',TEXT_FILTER_NEW_PRODUCTS_DAYS,xtc_draw_pull_down_menu('days',FILTER_PRODUCTS_DATE_ADDED_DURATIONS,7,'id="days"'));
			printf('<input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" />',IMAGE_SELECT);
			echo '</fieldset></form></div>';
			exit;
			break;
		case 'save_products_storage_sort':
			$cPath = $_REQUEST['cPath'];
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			if(!isset($_REQUEST['spID']) or !is_array($_REQUEST['spID'])){
				die(json_encode(array(
					'MSG'=>yes_encode_string(MSG_ERROR_PRODUCTS_STORAGE_SORT)
				)));
			}
			foreach($_REQUEST['spID'] as $sort=>$spID){
				xtc_db_query(sprintf(
					"UPDATE storage_products SET priority=%s WHERE id=%s",
					$sort,(int)xtc_db_input($spID)
				));
			}
			die(json_encode(array(
				'MSG'=>yes_encode_string(MSG_SUCCESS_PRODUCTS_STORAGE_SORT)
			)));
			break;
		case 'products_storage_sort':
			$smarty = new yesSmarty;
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$query = xtc_db_query(sprintf(
				"SELECT id,storage_id,storage_places_id,priority,quantity FROM storage_products WHERE products_id=%s ORDER BY priority",
				(int)xtc_db_input($_REQUEST['pID'])
			));
			$pstorages = array();
			while($record = xtc_db_fetch_array($query)){
			    if($record['storage_places_id'] > 0){
				$record['storage_place'] = yes_get_storage_place_title($record['storage_places_id']);
			    }
				$record['storage'] = xtc_get_storage_name($record['storage_id']);
				$pstorages[] = $record;
			}
			$smarty->assign(array(
				'TEXT_PRIORITY_INTRO'=>TEXT_PRIORITY_INTRO,
				'storages'=>$pstorages,
				'LINK_SAVE_SORT'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=save_products_storage_sort')
			));
			$smarty->display('products_storage_sort.html');
			exit;
			break;
		case 'setCFlag_confirm':
			echo '<p class="main">';
			echo xtc_draw_form('csetform',FILENAME_CATEGORIES,xtc_get_all_get_params(array('action','update_products','update_categories')).'action=setcflag');
			echo '<fieldset><p>';
			if(defined('NO_ASK_FOR_SET_FLAG_PRODUCTS') and NO_ASK_FOR_SET_FLAG_PRODUCTS == 'True') {
				echo xtc_draw_checkbox_field('update_products',1,false,false,'id="up"');
			}else{
				echo xtc_draw_checkbox_field('update_products',1,true,false,'id="up"');
			}
			printf('<label for="up">%s</label></p><p>',JS_CONFIRM_SET_CFLAG_FOR_PRODUCTS);
			if(defined('NO_ASK_FOR_SET_FLAG_PRODUCTS') and NO_ASK_FOR_SET_FLAG_PRODUCTS == 'True') {
				echo xtc_draw_checkbox_field('update_products_shop',1,false,false,'id="up_shop"');
			}else{
				echo xtc_draw_checkbox_field('update_products_shop',1,true,false,'id="up_shop"');
			}
			printf('<label for="up_shop">%s</label></p><p>',TEXT_UPDATE_PRODUCTS_LISTING_STATUS);
                        
			echo xtc_draw_checkbox_field('update_categories',1,true,false,'id="us"');
			printf('<label for="us">%s</label>',JS_CONFIRM_SET_CFLAG_FOR_SUBCATEGORIES);
			printf('</p><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" />',IMAGE_UPDATE);
			echo '</fieldset>';
			echo '</form></p>';
			exit;
			break;
		case 'delete_master_process':
			$pID = (int)xtc_db_input($_REQUEST['products_id']);
			$collies = xtc_get_product_collies($pID);
			for($i=0;$i<sizeOf($collies);$i++){
                                product::add_history_static(
                                    $collies[$i]['collie_products_id'],
                                    sprintf(TEXT_PRODUCTS_MASTER_FROM_COLLI_DELETED,$pID)
                                );
			}
                        product::add_history_static($pID,TEXT_PRODUCTS_MASTER_DELETED);
			
			xtc_db_query(sprintf(
				"UPDATE products SET products_master=0 WHERE products_master=%s",$pID
			));
			xtc_db_query(sprintf(
				"UPDATE products SET products_master_status=0 WHERE products_id=%s",$pID
			));
			$messageStack->add_session(MSG_SUCCESS_DELETE_MASTER,'success');
			xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,'pID='.$pID.'&action=new_product&cPath='.xtc_get_path($pID)));
			break;
		case 'delete_master':
			echo '<div class="main">'.xtc_draw_form('delmas',FILENAME_CATEGORIES,'action=delete_master_process&products_id='.$_REQUEST['products_id']);
			echo TEXT_REALLY_DELETE_MASTER;
			printf('<br /><input type="submit" value="%s" class="yesButton" />',IMAGE_DELETE);
			echo '</form></div>';
			exit;
			break;
                case 'update_slave_sortings':
                    $msg = '';
                    $sorts = explode(',',$_GET['sortings']);
                    if(!sizeOf($sorts)){
                        $msg = 'Keine sortierbaren Elemente';
                    }else{
                        foreach($sorts as $sort){
                            $parts = explode(':',$sort);
                            $update_sql_array = array(
                                'products_master_sorting'=>$parts[1]
                            );
                            xtc_db_perform(TABLE_PRODUCTS,$update_sql_array,'update',"products_id='".$parts[0]."'");
                        }
                    }
                    die(json_encode(array(
                        'MSG'=>$msg
                    )));
                    break;
		case 'master_slave':
			include('products_master.php');
			break;
		case 'delete_cset':
			$pcID = (int)xtc_db_input($_REQUEST['cID']);
			$gID = (int)xtc_db_input($_REQUEST['gID']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$query = xtc_db_query(sprintf(
				"SELECT no_sets FROM products_characteristic WHERE products_characteristic_id=%s AND groups_id=%s",
				$pcID,$gID
			));
			if(!xtc_db_num_rows($query)){
				die('No characteristics found');
			}
			$record = xtc_db_fetch_array($query);
			if($record['no_sets'] == 0){
				$query = xtc_db_query(sprintf(
					"SELECT title FROM products_characteristic_description WHERE products_characteristic_id=%s AND language_id=%s",
					$pcID,$_SESSION['languages_id']
				));
				$record = xtc_db_fetch_array($query);
				$cset_name = $record['title'];
				$pcsID_array = array();
				$query = xtc_db_query(sprintf(
					"SELECT products_characteristic_set_id FROM products_characteristic_set WHERE products_characteristic_id=%s",
					$pcID
				));
				while($record = xtc_db_fetch_array($query)){
					$pcsID_array[] = $record['products_characteristic_set_id'];
				}
				xtc_db_query(sprintf(
					"DELETE FROM products_to_characteristics WHERE products_id=%s and products_characteristic_set_id IN(%s)",
					$pID,implode(',',$pcsID_array)
				));
			}
			$messageStack->add_session(sprintf(MSG_SUCCESS_CSET_ALLOCATION_RESETTED,$cset_name),'success');
			xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action','cID','gID')).'action=new_product'));
			exit;
			break;
		case 'special_price':
			$pID = (int)xtc_db_input($_REQUEST['products_id']??0);
			if($pID < 1){
                            die('Missing param pID');
                        }
			$smarty = new yesSmarty;
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$special_query = xtc_db_query("SELECT * FROM specials WHERE products_id='".$pID."'");
			if(xtc_db_num_rows($special_query)){
				$special = xtc_db_fetch_array($special_query);
				$values = $special;
			}else{
				$values = array(
					/*'specials_quantity'=>'0',*/
					'specials_new_products_price'=>'0.00',
					'expires_date'=>date('Y-m-d',time()+(60*60*24*7)),
					'start_date'=>date('Y-m-d'),
					'sell_to_v1null'=>0,
					'ebay_price_revise'=>0
				);
			}
			
			$smarty->assign(array(
                            'action'=>'special_price',
                            'FORM_END'=>'</form>',
                            'INPUT_START_DATE'=>xtc_draw_input_field('start_datum',date('Y-m-d',strtotime($values['start_date'])),'size="16" id="start_datum"',false,'date'),
                            'INPUT_EXP_DATE'=>xtc_draw_input_field('datum',date('Y-m-d',strtotime($values['expires_date'])),'size="16" id="datum"',false,'date'),
                            'INPUT_SELL_TO_V1NULL'=>xtc_draw_checkbox_field('sell_to_v1null', '1',$values['sell_to_v1null'],false,'id="sell_to_v1null"'),
                            'INPUT_EBAY_PRICE_REVISE'=>xtc_draw_checkbox_field('ebay_price_revise', '1',$values['ebay_price_revise'],false, 'id="ebay_price_revise"'),
                            'VALUES'=>$values,
                            'FORM'=>  xtc_draw_form('special_price_form', 'specials.php', 'action=json_insert&products_id='.$pID, 'post', 'id="special_price_form"'),
			));
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('new_product.html');
			exit;
			break;
		case 'delete_category_additional_image':
                    $cID = (int)xtc_db_input($_REQUEST['cID']);
                    $addimage = \YES4Trade\Model\category::get_by_categories_id($cID,[
                        'categories_additional_image'
                    ]);
                    if($addimage !== null and !empty($addimage->categories_additional_image)){
                        unlink(DIR_FS_CATALOG.'images/categories/'.$addimage->categories_additional_image);
                        $upd = new \YES4Trade\Model\category([
                            'categories_id'=>$cID,
                            'categories_additional_image'=>'',
                        ]);
                        $upd->update();
                        $messageStack->add_session('2. Kategoriebild wurde entfernt.','success');
                    }
                    xtc_redirect(xtc_href_link('categories.php',xtc_get_all_get_params(array('action')).'action=edit_category_ACD'));
                    break;
		case 'delete_category_image':
                    $cID = (int)xtc_db_input($_REQUEST['cID']);
                    $image = \YES4Trade\Model\category::get_by_categories_id($cID,[
                        'categories_image'
                    ]);
                    if($image !== null and !empty($image->categories_image)){
                        unlink(DIR_FS_CATALOG.'images/categories/'.$image->categories_image);
                        $upd = new \YES4Trade\Model\category([
                            'categories_id'=>$cID,
                            'categories_image'=>''
                        ]);
                        $upd->update();
                        $messageStack->add_session('Kategoriebild wurde entfernt.','success');
                    }
                    xtc_redirect(xtc_href_link('categories.php',xtc_get_all_get_params(array('action')).'action=edit_category_ACD'));
                    break;
		case 'meldebestand_user_save':
			if(!isset($_REQUEST['pID'])){
				throw new Exception('Missing params for meldebestand_user_save');
			}
			$pID = (int)xtc_db_input($_REQUEST['pID']);
                        $pmc_list = \YES4Trade\Model\products_meldebestand_customers::get_by_products_id($pID);
                        foreach($pmc_list as $pmc){
                            \YES4Trade\Model\products_meldebestand_customers::delete($pmc->products_meldebestand_customers_id);
                        }

			for($i=0;$i<sizeOf($_REQUEST['customers_id']);$i++){
				$cID = (int)xtc_db_input($_REQUEST['customers_id'][$i]);
				if($cID > 0){
                                    $new = new \YES4Trade\Model\products_meldebestand_customers([
                                        'products_id'=>$pID, 
                                        'customers_id'=>$cID,
                                    ]);
                                    $new->create();
				}
			}
			die(MSG_SUCCESS_MELDEBESTAND_USER_SAVED);
			break;
        case 'meldebestand_user_confirm':
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			if($pID < 1){
				throw new Exception('Missing param pID for meldebestand_user_confirm');
            }
			$smarty = new yesSmarty;
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$customers = array();
			$smarty->assign(array(
				'VERSION_OF_JQUERY_UI'=>VERSION_OF_JQUERY_UI,
				'VERSION_OF_JQUERY'=>VERSION_OF_JQUERY,
				'FORM_END'=>'</form>',
				'FORM'=>  xtc_draw_form('meldebestand_user', 'categories.php', xtc_get_all_get_params(array('action')).'action=meldebestand_user_save', 'post', 'id="meldebestand_user_form"'),
				'TEXT_SAVE_BUTTON'=>IMAGE_SAVE,
				'TEXT_INTRO'=>TEXT_MELDEBESTAND_USER_CONFIRM_INTRO
			));
            $diffc=[];
            $customers_array = \main::get_notice_recipients('f_products_meldebestand');
            foreach($customers_array as $cID){
                if(!isset($diffc[$cID])){
				    $customers[] = array('ID'=>$cID,
					    'NAME'=>  xtc_get_editor_name($cID),
					    'SAVED'=>yes_get_products_meldebestand_active_by_recipient($pID,$cID)
				    );
                    $diffc[$cID] = true;
                }
			}
			$smarty->assign('CUSTOMER_ARRAY',$customers);
			$smarty->display('meldebestand_user_allocation.html');
			exit;
			break;
        case 'navigation':
			$parent_id = (isset($_REQUEST['cpath'])) ? (int)xtc_db_input($_REQUEST['cpath']): 0;
			$smarty = new yesSmarty;
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			
			if(isset($_REQUEST['target_link'])){
				$target_link = $_REQUEST['target_link'];
				$smarty->assign('target_link',$target_link);
			}else{
				$target_link = xtc_href_link('categories.php');
			}
			

			$smarty->assign(array(
				'VERSION_OF_JQUERY_UI'=>VERSION_OF_JQUERY_UI,
				'VERSION_OF_JQUERY'=>VERSION_OF_JQUERY,
				'PARENT_ID'=>$parent_id,
				'IMAGE_SAVE'=>IMAGE_SAVE,
				'close_modal'=>((isset($_REQUEST['close_modal'])) ? $_REQUEST['close_modal'] : 0)
			));

			$query = yes_db_query(sprintf(
				"select cd.categories_name,c.categories_id from %s c LEFT JOIN %s cd using(categories_id) where cd.language_id = '%s' and c.parent_id = '%s' and link_id=0 ORDER BY sort_order,cd.categories_name",
				TABLE_CATEGORIES,TABLE_CATEGORIES_DESCRIPTION,
				$_SESSION['languages_id'],$parent_id
			),true);
			$categories = array();
			if($parent_id == 0){
				$categories = array(0=>array(
					'categories_id'=>0,
					'categories_name'=>'TOP',
					'link'=>$target_link.'?cPath='.xtc_get_category_path(0)
				));
			}
			if(yes_db_num_rows($query)){
				if($parent_id == 0){
					$smarty->assign('SHOW_HEADER',1);
				} // end if parent_id == 0
				foreach($query as $record){
					$record['link'] = $target_link.'?cPath='.xtc_get_category_path($record['categories_id']);
					$categories[] = $record;
				}
				$smarty->assign('CATEGORIES',$categories);
			}
			if(isset($_REQUEST['return_value']) and $_REQUEST['return_value'] != ''){
				$smarty->assign('RETURN_VALUE',$_REQUEST['return_value']);
			}
			if(sizeOf($categories) > 0){
				header('Content-Type: text/html; charset='.CHARSET);
				$smarty->display('category_navigation.html');
			}
			exit;
			break;
	  case 'save_cgroup':
            $categories_id = (int)xtc_db_input($_GET['cID']);
            $groups_id = (int)xtc_db_input($_POST['group']);
            $allocated = \YES4Trade\Model\groups_categories::get_by_categories_id($categories_id);
            if($allocated != null){
                \YES4Trade\Model\groups_categories::delete( $allocated->categories_to_groups_id );
            }
            $new_gcat = new \YES4Trade\Model\groups_categories([
                'categories_id'=>$categories_id,
                'groups_id'=>$groups_id,
            ]);
            $new_gcat->create();
            $messageStack->add_session('Die Zuweisungen der Produktgruppe zur Kategorie wurde gespeichert.','success');
            xtc_redirect(xtc_href_link('categories.php',xtc_get_all_get_params(array('action','group','group_char'))));
            break;
      case 'copy_to':
		  if(!isset($products_id) or $products_id < 1){
			  $products_id = xtc_db_input($_REQUEST['products_id']);
		  }
			$smarty = new yesSmarty;
			$smarty->assign('action','copy_to');

			$smarty->assign('form',xtc_draw_form('copy_to', 'categories.php',xtc_get_all_get_params(array('action','mode')).'action=copy_to_confirm&mode=edit','POST','id="copy_to_form"') . xtc_draw_hidden_field('products_id', $products_id));
			$smarty->assign('FORM_END','</form>');
			$smarty->assign('TEXT_INTRO',TEXT_INFO_COPY_TO_INTRO);
			$smarty->assign('TEXT_INFO_CURRENT_CATEGORIES', TEXT_INFO_CURRENT_CATEGORIES);
			$smarty->assign('CURRENT_CATEGORIES',xtc_output_generated_category_path($products_id, 'product'));

            $cat_select = \YES4Trade\Model\category::get_categories_tree_select([
                'return_function'=>sprintf('$(\'input[name="categories_id"]\').val(id);'),
                'ALL_ITEMS_SELECTABLE'=>'false'
            ], new \yesSmarty());
			$smarty->assign('TEXT_CATEGORIES', 'Kopiere in Kategorie: '
                    . $cat_select
                    . '<br />Category ID'
                    . xtc_draw_input_field('categories_id','','size="8"',false,'number'),
            );
			$smarty->assign('TEXT_HOWTO_COPY', '<br />' . TEXT_HOW_TO_COPY . '<br />' . xtc_draw_radio_field('copy_as', 'link') . ' ' . TEXT_COPY_AS_LINK . '<br />' . xtc_draw_radio_field('copy_as', 'duplicate',true) . ' ' . TEXT_COPY_AS_DUPLICATE);
			$smarty->assign('TEXT_QUANTITY', 'Beim Duplizieren des Produkts k&ouml;nnen Sie hier angeben, wieviel verschiedene Kopien erzeugt werden sollen. (Max. 500)<br />' . xtc_draw_input_field('copy_qty', '1', 'size="4" maxlength="3"'));
			$smarty->assign('INPUT_COPY',yes_draw_href_button(IMAGE_COPY,'','width:130px;','submit'));
			$smarty->assign('INPUT_CANCEL',yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $products_id),'width:130px;'));
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$smarty->display('new_product.html');
			exit;
	        break;
		case 'view_amazon':
			$smarty = new yesSmarty;
			$smarty->assign('mode','view');
			if(is_file('includes/config.amazonmws.inc.php')){
				$amazon_values = yes_get_products_amazon_values(xtc_db_input($_GET['pID']));
				if(sizeOf($amazon_values)){
					$amz_array = array();
					foreach($amazon_values as $amzval){
						$query = xtc_db_query(sprintf(
							"SELECT amazon_feeds_quantity_items_id FROM amazon_feeds_quantity_items WHERE sku='%s' AND processed=0",
							$amzval['sku']
						));
						$qty_update_in_progress = false;
						if(xtc_db_num_rows($query)){
						    $qty_update_in_progress = true;
						}
                                                if($qty_update_in_progress === false){
                                                    $collected = \YES4Trade\Model\amazon_feed_collector::sku_exists($amzval['sku'], 'JSON_LISTINGS_FEED.quantity');
                                                    if($collected === true){
                                                        $qty_update_in_progress = true;
                                                    }
                                                }
                                                $amazon_feeds_price_items = \YES4Trade\Model\amazon_feeds_price_items::get_by_sku_and_processed($amzval['sku'],0);
						$price_update_in_progress = (sizeOf($amazon_feeds_price_items)>0)?true:false;
                                                if($price_update_in_progress === false){
                                                    $collected = \YES4Trade\Model\amazon_feed_collector::sku_exists($amzval['sku'], 'JSON_LISTINGS_FEED.price');
                                                    if($collected === true){
                                                        $price_update_in_progress = true;
                                                    }
                                                }
                                                        
						// EOF - Amazon Background Processing
						$asin = (!empty($amzval['asin'])) ? $amzval['asin'] : TEXT_NO_AMAZON_ASIN;
						$amz_array[] = array(
						    'QTY'=>$amzval['quantity'],
						    'ASIN'=>$asin,
						    'SKU'=>$amzval['sku'],
						    'PRICE'=>$amzval['price'],
						    'MERCHANT_ID'=>$amzval['merchant_id'],
                                                    'SELLING_PARTNER_ID'=>$amzval['selling_partner_id'],
						    'qty_update_in_progress'=>$qty_update_in_progress,
                                                    'price_update_in_progress'=>$price_update_in_progress,
						);
					}
					$smarty->assign(array(
						'PRODUCTS_ID'=>$_GET['pID'],
						'AMAZON_VALUES'=>$amz_array
					));
				}else{
					$smarty->assign('NO_AMAZON',1);
					$smarty->assign('ADD_LINK',xtc_href_link('categories.php','action=add_to_amazon&pID='.$_GET['pID']));
				}
			}
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('amazon_helper.html');
			exit;
			break;
		case 'add_to_amazon':
			// NOCH NICHT AKTIV SCHEINBAR
			require_once(DIR_FS_CATALOG.'/includes/classes/xtcPrice.php');
			require_once(DIR_WS_CLASSES . 'currencies.php');
			$merchant_id = xtc_db_input($_REQUEST['merchant_id']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$amazon_values = yes_get_products_amazon_values($pID,$merchant_id);
			$product = new product($pID);
			$xtPrice = new xtcPrice(DEFAULT_CURRENCY,EBAY_CUSTOMERS_STATUS);
			$currencies = new currencies();
			$smarty = new yesSmarty;
			$lang_vars = array(
				'TEXT_REQUEST_IS_PROCESSED'=>TEXT_REQUEST_IS_PROCESSED,
				'TEXT_LEGEND'=>TEXT_UPDATE_AMAZON,
				'TEXT_AMAZON_PRICE_BRUTTO'=>TEXT_AMAZON_PRICE_BRUTTO,
				'TEXT_AMAZON_QUANTITY'=>TEXT_AMAZON_QUANTITY,
				'TEXT_AMAZON_SKU'=>TEXT_AMAZON_SKU,
				'TEXT_AMAZON_PLEASE_WAIT'=>TEXT_AMAZON_PLEASE_WAIT
			);
			$smarty->assign($lang_vars);
			if(!sizeOf($amazon_values)){
			}else{
				$smarty->assign('mode','add_product');
				$smarty->assign('AJAX_REFRESH_LINK',xtc_href_link('categories.php','action=view_amazon&pID='.$pID));
				$amazon_form_id = 'amazon_product_submit';
				$smarty->assign('AMAZON_FORM_ID',$amazon_form_id);
				$smarty->assign('FORM',xtc_draw_form($amazon_form_id,'amazon.php','action=update_product&pID='.$pID,'post','id="'.$amazon_form_id.'" onsubmit="return false;"'));
				$smarty->assign('FORM_END','</form>');

				$smarty->assign('INPUT_PRICE',xtc_draw_input_field('price',$amazon_values['price']));
				$smarty->assign('INPUT_QUANTITY',xtc_draw_input_field('qty',$amazon_values['quantity']));
				$smarty->assign('INPUT_SKU',xtc_draw_input_field('sku',$amazon_values['sku']));
			}
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('amazon_helper.html');
			exit;
			break;
		case 'delete_products_distributors':
			if(!isset($_REQUEST['dID']) or $_REQUEST['dID'] < 1){
				die(MSG_ERROR_NO_DISTRIBUTOR);
			}
			if(!isset($_REQUEST['pID']) or $_REQUEST['pID'] < 1){
				die('Missing parameters');
			}
			$pID = xtc_db_input($_REQUEST['pID']);
			$dID = xtc_db_input($_REQUEST['dID']);
			xtc_db_query(sprintf(
				"DELETE FROM distributor_product_prices WHERE products_id='%s' and distributor_id='%s'",
				$pID,$dID
			));
                        $pd = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id(
                                intval($pID),intval($dID),['id']
                        );
                        if($pd === null){
                            throw new Exception('cant delete_products_distributors: products_distributors item not found');
                        }
                        \YES4Trade\Model\products_distributors::delete($pd->id);
                        product::add_history_static($pID, sprintf(
                            MSG_SUCCESS_DISTRIBUTOR_DELETED,
                            xtc_get_distributor_name($dID)
			));
			die('1');
			break;
    case 'add_distributor':
        if(!isset($_REQUEST['distributor_id']) or $_REQUEST['distributor_id'] < 1){
                die(MSG_ERROR_NO_DISTRIBUTOR);
        }
        if(!isset($_REQUEST['pID']) or $_REQUEST['pID'] < 1){
                throw new Exception('Missing parameters for add_distributor');
        }
        $pID = intval($_REQUEST['pID']);
        $dID = intval($_REQUEST['distributor_id']);
        $pd = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id(
                intval($pID),intval($dID),['id']
        );
        if($pd !== null){
                die(MSG_ERROR_DISTRIBUTOR_SAVED);
        }
        if($_REQUEST['is_default'] == 1){
            \YES4Trade\Model\products_distributors::unset_default_for_products_id($pID);
        }
        $new = new \YES4Trade\Model\products_distributors([
            'products_id'=>$pID,
            'distributor_id'=>$dID,
            'distributor_products_number'=>yes_decode_string($_REQUEST['distributor_products_number']),
            'mindestbestellmenge'=>(int)$_REQUEST['mindestbestellmenge'],
            'distributor_products_link'=>yes_decode_string($_REQUEST['distributor_products_link']),
            'comments'=>yes_decode_string($_REQUEST['comments']),
            'is_default'=>intval($_REQUEST['is_default'])
        ]);
        $new->create();
        product::add_history_static($pID, sprintf(
                MSG_SUCCESS_DISTRIBUTOR_ADDED,
                xtc_get_distributor_name($dID)
        ));
        die('1');
    case 'update_distributor':
        if(!isset($_REQUEST['distributor_id']) or $_REQUEST['distributor_id'] < 1){
                die(MSG_ERROR_NO_DISTRIBUTOR);
        }
        if(!isset($_REQUEST['pID']) or $_REQUEST['pID'] < 1){
                throw new Exception('Missing parameters for update_distributor');
        }
        $pID = intval($_REQUEST['pID']);
        $dID = intval($_REQUEST['distributor_id']);
        if($_REQUEST['is_default'] == 1){
            \YES4Trade\Model\products_distributors::unset_default_for_products_id($pID);
        }
        $pd = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id($pID, $dID,['id']);
        if($pd === null){
            throw new Exception('cant update distributor product: No item found');
        }
        $upd = new \YES4Trade\Model\products_distributors([
            'id'=>$pd->id,
            'distributor_products_number'=>yes_decode_string($_REQUEST['distributor_products_number']),
            'mindestbestellmenge'=>(int)$_REQUEST['mindestbestellmenge'],
            'distributor_products_link'=>yes_decode_string($_REQUEST['distributor_products_link']),
            'comments'=>yes_decode_string($_REQUEST['comments']),
            'is_default'=>intval($_REQUEST['is_default']),
            'products_id'=>$pID,
            'distributor_id'=>$dID
        ]);
        $upd->update();
        product::add_history_static($pID,sprintf(MSG_SUCCESS_DISTRIBUTOR_UPDATED,
            xtc_get_distributor_name($dID)
        ));
        die('1');
    case 'edit_products_distributor':
        if(!isset($_REQUEST['dID']) or $_REQUEST['dID'] < 1){
                die(MSG_ERROR_NO_DISTRIBUTOR);
        }
        if(!isset($_REQUEST['pID']) or $_REQUEST['pID'] < 1){
                die('Missing parameters');
        }
        $pID = intval($_REQUEST['pID']);
        $dID = intval($_REQUEST['dID']);
        $dName = xtc_get_distributor_name($dID);
        $pd = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id($pID,$dID);
        if($pd === null){
            throw new Exception('Cant edit_products_distributor: products_distributors item not found');
        }
        $record = $pd->toArray();
        
        $smarty = new yesSmarty;
        $smarty->assign('INPUT_DISTRIBUTOR',xtc_draw_hidden_field('distributor_id',$dID).$dName);
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR',TEXT_PRODUCTS_DISTRIBUTOR);
        $smarty->assign('INPUT_PRODUCTS_DISTRIBUTOR_NUMBER',xtc_draw_input_field('distributor_products_number', $record['distributor_products_number'],'maxlength="128" size="32"'));
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR_NUMBER',TEXT_PRODUCTS_DISTRIBUTOR_NUMBER);
        $smarty->assign('INPUT_MINDESTBESTELLMENGE',xtc_draw_input_field('mindestbestellmenge',$record['mindestbestellmenge'],'maxlength="12" size="6"'));
        $smarty->assign('TEXT_MINDESTBESTELLMENGE',TEXT_MINDESTBESTELLMENGE);
        $smarty->assign('INPUT_DISTRIBUTOR_PRODUCTS_LINK',xtc_draw_input_field('distributor_products_link',$record['distributor_products_link'],'maxlength="255" size="32"'));
        $smarty->assign('TEXT_DISTRIBUTOR_PRODUCTS_LINK',TEXT_DISTRIBUTOR_PRODUCTS_LINK);
        $smarty->assign('INPUT_IS_DEFAULT',xtc_draw_checkbox_field('is_default','1',$record['is_default']));
        $smarty->assign('TEXT_COMMENTS',TEXT_COMMENTS);
        $smarty->assign('INPUT_COMMENTS',xtc_draw_textarea_field('comments', 'virtual', 40, 4,$record['comments']));
        $smarty->assign('TEXT_IS_DEFAULT',TEXT_IS_DEFAULT);
        $smarty->assign('TEXT_SAVE',IMAGE_UPDATE);
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR_INTRO',TEXT_PRODUCTS_DISTRIBUTOR_INTRO);
        $smarty->assign('MODE','add');
        $smarty->assign('pID',$pID);
        $smarty->assign('FORM_END','</form>');
        $smarty->assign('FORM',xtc_draw_form('edit_distributor','categories.php',xtc_get_all_get_params(array('action')).'action=update_distributor','post','id="edit_distributor"'));
        $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        header('Content-Type: text/html; charset='.CHARSET);
        $smarty->display('ajax_products_distributors.html');
        exit;
        break;
    case 'new_products_distributor':
        $pID = intval($_GET['pID']);
        // ist der Artikel zu irgendeinem Lieferanten als Default gesetzt?
        // halte ich fuer fragwuerdig diese Abfrage. 2025/04
        // hier wird ja erstmal ein dropdown aller lieferanten angezeigt,
        // wie soll dieses Flag da irgendwas entscheiden koennen ...
        $is_default = \YES4Trade\Model\products_distributors::is_default_from_products_id($pID);
        $saved = \YES4Trade\Model\products_distributors::get_distributor_id_array_from_products_id($pID);
        $where = '';
        if(sizeOf($saved)){
                $where = sprintf(" WHERE id NOT IN(%s) ",implode(',',$saved));
        }
        $query_raw = sprintf(
                "SELECT id,name FROM distributors %s ORDER BY name",$where
        );
        $query = xtc_db_query($query_raw);
        $distributor_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
        while($record = xtc_db_fetch_array($query)){
                $distributor_array[] = array(
                        'id'=>$record['id'],
                        'text'=>$record['name']
                );
        }
        $smarty = new yesSmarty;
        $smarty->assign('INPUT_DISTRIBUTOR',xtc_draw_pull_down_menu('distributor_id',$distributor_array));
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR',TEXT_PRODUCTS_DISTRIBUTOR);
        $smarty->assign('INPUT_PRODUCTS_DISTRIBUTOR_NUMBER',xtc_draw_input_field('distributor_products_number','','maxlength="128" size="32"'));
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR_NUMBER',TEXT_PRODUCTS_DISTRIBUTOR_NUMBER);
        $smarty->assign('INPUT_MINDESTBESTELLMENGE',xtc_draw_input_field('mindestbestellmenge','0','maxlength="12" size="6"'));
        $smarty->assign('TEXT_MINDESTBESTELLMENGE',TEXT_MINDESTBESTELLMENGE);
        $smarty->assign('INPUT_DISTRIBUTOR_PRODUCTS_LINK',xtc_draw_input_field('distributor_products_link','','maxlength="255" size="32"'));
        $smarty->assign('TEXT_DISTRIBUTOR_PRODUCTS_LINK',TEXT_DISTRIBUTOR_PRODUCTS_LINK);
        $smarty->assign('TEXT_COMMENTS',TEXT_COMMENTS);
        $smarty->assign('INPUT_COMMENTS',xtc_draw_textarea_field('comments', 'virtual', 40, 4));
        $smarty->assign('INPUT_IS_DEFAULT',xtc_draw_checkbox_field('is_default','1',$is_default));
        $smarty->assign('TEXT_IS_DEFAULT',TEXT_IS_DEFAULT);
        $smarty->assign('TEXT_SAVE',IMAGE_INSERT);
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR_INTRO',TEXT_PRODUCTS_DISTRIBUTOR_INTRO);
        $smarty->assign('MODE','add');
        $smarty->assign('pID',$pID);
        $smarty->assign('FORM_END','</form>');
        $smarty->assign('FORM',xtc_draw_form('edit_distributor','categories.php',xtc_get_all_get_params(array('action')).'action=add_distributor','post','id="edit_distributor"'));
        $smarty->assign(array(
            'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
            'JS_ERROR_NO_DISTRIBUTOR_PRODUCTS_NUMBER'=>JS_ERROR_NO_DISTRIBUTOR_PRODUCTS_NUMBER
        ));
        header('Content-Type: text/html; charset='.CHARSET);
        $smarty->display('ajax_products_distributors.html');
        exit;
        break;
    case 'products_distributors':
        $pID = (int)xtc_db_input($_GET['pID']);
        $smarty = new yesSmarty;
        $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        $smarty->assign('HEADING_TITLE',TEXT_PRODUCTS_DISTRIBUTORS);
        $smarty->assign('pID',$pID);
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR',TEXT_PRODUCTS_DISTRIBUTOR);
        $smarty->assign('TEXT_PRODUCTS_DISTRIBUTOR_NUMBER',TEXT_PRODUCTS_DISTRIBUTOR_NUMBER);
        $query = xtc_db_query(sprintf(
                "SELECT d.id,distributor_products_number,name,is_default FROM products_distributors pd LEFT JOIN distributors d ON pd.distributor_id=d.id WHERE products_id=%s AND d.id IS NOT NULL",
                $pID
        ));
        $dist_array = array();
        while($record = xtc_db_fetch_array($query)){
                $name = ($record['is_default'] == 1) ? sprintf('<b>%s</b>',xtc_db_prepare_input($record['name'])) : xtc_db_prepare_input($record['name']);
                $nummer = ($record['is_default'] == 1) ? sprintf('<b>%s</b>',xtc_db_prepare_input($record['distributor_products_number'])) : xtc_db_prepare_input($record['distributor_products_number']);
                $dist_array[] = array(
                    'name'=>$name,
                    'num'=>$nummer,
                    'edit_link'=>sprintf('categories.php?action=edit_products_distributor&dID=%s&pID=%s',
                            $record['id'],$pID
                    ),
                    'delete_link'=>sprintf('categories.php?action=delete_products_distributors&dID=%s&pID=%s',
                            $record['id'],$pID
                    ),
                    'ek_prices_link'=>sprintf('distributor_products.php?view=prices&pID=%s&distID=%s',
                            $pID,$record['id']
                    ),
                    'stock'=> yes_get_products_distributors_stock($record['id'], $pID)
                );
        }
        $smarty->assign('items',$dist_array);
        $smarty->assign('add_link','categories.php?action=new_products_distributor&pID='.$_GET['pID']);
        $smarty->assign('TEXT_ADD',TEXT_ADD_PRODUCTS_DISTRIBUTOR);
        $smarty->assign('TEXT_DISTRIBUTOR_PRICES',TEXT_DISTRIBUTOR_PRICES);
        $smarty->assign('JS_CONFIRM_REALLY_DELETE_DISTRIBUTOR_ALLOCATION',JS_CONFIRM_REALLY_DELETE_DISTRIBUTOR_ALLOCATION);
        header('Content-Type: text/html; charset='.CHARSET);
        $smarty->display('ajax_products_distributors.html');
        exit;
        break;
    case 'update_cart_prices':
        $pID = intval(xtc_db_input($_REQUEST['products_id']));
        $auction_types = xtc_db_prepare_input($_REQUEST['auction_type']);
        if($pID < 1 or !sizeOf($auction_types)){
                $messageStack->add_session(MSG_ERROR_NO_AUCTIONTYPE,'error');
                xtc_redirect($_REQUEST['referrer']);
        }
        require_once(DIR_WS_CLASSES.'class.ebay.php');
        require_once(DIR_WS_CLASSES.'class.ebay_item.php');
        require_once(DIR_WS_CLASSES.'class.ebay_product.php');
        foreach($auction_types as $k=>$t){
                $auction_types[$k] = "'$t'";
        }
        $price = str_replace(',','.',xtc_db_input($_REQUEST['price_brutto']));
        $querys = array();
        if(isset($_REQUEST['cart_id']) and is_array($_REQUEST['cart_id']) and sizeOf($_REQUEST['cart_id'])){
                foreach($_REQUEST['cart_id'] as $k=>$cartID){
                        switch($cartID){
                                case 'ALL':
                                        $querys[] = sprintf(
                                                "SELECT id FROM ebay_products WHERE products_id='%s' and ebay_angebotsformat IN(%s)",
                                                $pID,implode(',',$auction_types)
                                        );
                                        break;
                                default:
                                        $querys[] = sprintf(
                                                "SELECT id FROM ebay_products WHERE products_id='%s' and ebay_angebotsformat IN(%s) and ebay_sammler_id='%s'",
                                                $pID,implode(',',$auction_types),intval(xtc_db_input($cartID))
                                        );
                                        break;
                        }
                }
        }
        $EBAYAPI = new ebayApi;
        $updated = 0;
        if(sizeOf($querys)){
                foreach($querys as $query_raw){
                        $query = xtc_db_query($query_raw);
                        while($row = xtc_db_fetch_array($query)){
                                xtc_db_query(sprintf("UPDATE ebay_products SET ebay_preis='%s' WHERE id='%s'",
                                                $price,
                                                $row['id']
                                ));
                                $comments = sprintf(HISTORY_UPDATE_CART_PRICES,number_format($price,2,',','.'));
                                $EBAYAPI->save_history($row['id'], $comments, $_SESSION['customers_id']);
                                $updated++;
                        }
                }
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_UPDATE_CART_PRICES,$updated),'success');
        xtc_redirect($_REQUEST['referrer']);
        exit;
        break;
    case 'change_cart_prices':
        if(!isset($_REQUEST['products_id']))
                die(yes_get_inline_error_message('Missing parameter'));
        $pID = intval(xtc_db_input($_REQUEST['products_id']));
        $query = xtc_db_query(sprintf(
                "SELECT DISTINCT(ebay_sammler_id) FROM ebay_products WHERE products_id='%s'",
                $pID
        ));
        if(!xtc_db_num_rows($query))
                die(yes_get_inline_error_message(TEXT_NO_CART_ITEMS));
        require_once(DIR_WS_CLASSES.'class.ebay.php');
        require_once(DIR_WS_CLASSES.'class.ebay_item.php');
        require_once(DIR_WS_CLASSES.'class.ebay_sammler.php');
        require_once(DIR_WS_CLASSES.'product.php');
        require_once(DIR_FS_CATALOG.'/includes/classes/xtcPrice.php');
        require_once(DIR_WS_CLASSES . 'currencies.php');
        $smarty = new yesSmarty;
        $diff_carts = array(
                array(
                        'id'=>'ALL',
                        'text'=>TEXT_ALL_CARTS
                )
        );
        while($row = xtc_db_fetch_array($query)){
                $cart = new ebay_sammler($row['ebay_sammler_id']);
                $diff_carts[] = array(
                        'id' => $row['ebay_sammler_id'],
                        'text' => $cart->getSammlerTitle()
                );
        }
        $smarty->assign('TEXT_UPDATE_CART_PRICES_INTRO',TEXT_UPDATE_CART_PRICES_INTRO);
        $smarty->assign('TEXT_UPDATE_CART_PRICES_LEGEND',TEXT_UPDATE_CART_PRICES_LEGEND);
        $smarty->assign('types',$_YES_auction_types);
        $smarty->assign('action','change_cart_prices');
        $smarty->assign('FORM_END','</form>');
        $smarty->assign('FORM',xtc_draw_form('update_prices_form','categories.php',xtc_get_all_get_params(array('action')).'action=update_cart_prices').
                xtc_draw_hidden_field('referrer',$_SERVER['HTTP_REFERER'])
        );
        $smarty->assign('INPUT_CARTS',xtc_draw_pull_down_menu('cart_id[]',$diff_carts,'ALL','size="10" multiple="multiple"'));
        $product = new product($pID);
        $xtPrice = new xtcPrice($_SESSION['currency'],EBAY_CUSTOMERS_STATUS);
        $currencies = new currencies();
        $price=$product->info['products_price'];
        $price=xtc_round($price,PRICE_PRECISION);
        if (PRICE_IS_BRUTTO=='true'){
                $price_netto=xtc_round($price,PRICE_PRECISION);
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, STORE_COUNTRY,0);
                $tax_rate = xtc_get_tax_rate($products_tax_class_id, STORE_COUNTRY,0);
                $price = ($price*($tax_rate+100)/100);
        }
        $smarty->assign('INPUT_PRICE', xtc_draw_input_field('price_brutto',number_format($price,2,'.',''),'size="10" maxlength="10"'));
        $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        header('Content-Type: text/html; charset='.CHARSET);
        echo $smarty->display('new_product.html');
        exit;
        break;
    case 'change_cart_ebay_title':
        if(!isset($_REQUEST['products_id']))
                die(yes_get_inline_error_message('Missing parameter'));
        $pID = intval(xtc_db_input($_REQUEST['products_id']));
        $query = xtc_db_query(sprintf(
                "SELECT DISTINCT(ebay_sammler_id) FROM ebay_products WHERE products_id='%s'",
                $pID
        ));
        if(!xtc_db_num_rows($query))
                die(yes_get_inline_error_message(TEXT_NO_CART_ITEMS));
        require_once(DIR_WS_CLASSES.'class.ebay.php');
        require_once(DIR_WS_CLASSES.'class.ebay_item.php');
        require_once(DIR_WS_CLASSES.'class.ebay_sammler.php');
        require_once(DIR_WS_CLASSES.'product.php');
        require_once(DIR_FS_CATALOG.'/includes/classes/xtcPrice.php');
        require_once(DIR_WS_CLASSES . 'currencies.php');
        $smarty = new yesSmarty;
        $diff_carts = array(
                array(
                        'id'=>'ALL',
                        'text'=>TEXT_ALL_CARTS
                )
        );
        while($row = xtc_db_fetch_array($query)){
                $cart = new ebay_sammler($row['ebay_sammler_id']);
                $diff_carts[] = array(
                        'id' => $row['ebay_sammler_id'],
                        'text' => $cart->getSammlerTitle()
                );
        }
        $smarty->assign('TEXT_UPDATE_CART_EBAY_TITLE_INTRO',TEXT_UPDATE_CART_EBAY_TITLE_INTRO);
        $smarty->assign('TEXT_UPDATE_CART_EBAY_TITLE_LEGEND',TEXT_UPDATE_CART_EBAY_TITLE_LEGEND);
        $smarty->assign('action','change_cart_ebay_title');
        $smarty->assign('FORM_END','</form>');
        $smarty->assign('FORM',xtc_draw_form('update_ebay_title_form','categories.php',xtc_get_all_get_params(array('action')).'action=update_cart_ebay_title').
                xtc_draw_hidden_field('referrer',$_SERVER['HTTP_REFERER'])
        );
        $smarty->assign('INPUT_CARTS',xtc_draw_pull_down_menu('cart_id[]',$diff_carts,'ALL','size="5" multiple="multiple"'));
        $product = new product($pID);
        $smarty->assign('INPUT_EBAY_TITLE', xtc_draw_input_field('ebay_title',$product->info['ebay_title'],'size="32" maxlength="85"'));
        $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        header('Content-Type: text/html; charset='.CHARSET);
        echo $smarty->display('new_product.html');
        exit;
        break;
    case 'update_cart_ebay_title':
        $pID = intval(xtc_db_input($_REQUEST['products_id']));
        if($pID < 1){
            $messageStack->add_session(MSG_ERROR_NO_AUCTIONTYPE,'error');
            xtc_redirect($_REQUEST['referrer']);
        }
        require_once(DIR_WS_CLASSES.'class.ebay.php');
        require_once(DIR_WS_CLASSES.'class.ebay_item.php');
        require_once(DIR_WS_CLASSES.'class.ebay_product.php');
        $ebay_title = xtc_db_prepare_input($_REQUEST['ebay_title']);
        $querys = array();
        if(isset($_REQUEST['cart_id']) and is_array($_REQUEST['cart_id']) and sizeOf($_REQUEST['cart_id'])){
            foreach($_REQUEST['cart_id'] as $k=>$cartID){
                switch($cartID){
                    case 'ALL':
                        $querys[] = sprintf(
                                "SELECT id FROM ebay_products WHERE products_id='%s'",
                                $pID
                        );
                        break;
                    default:
                        $querys[] = sprintf(
                                "SELECT id FROM ebay_products WHERE products_id='%s' and ebay_sammler_id='%s'",
                                $pID,intval(xtc_db_input($cartID))
                        );
                        break;
                }
            }
        }
        $EBAYAPI = new ebayApi;
        $updated = 0;
        if(sizeOf($querys)){
            foreach($querys as $query_raw){
                $query = xtc_db_query($query_raw);
                $rows = array();
                while($row = xtc_db_fetch_array($query)){
                    $rows[] = $row;
                }
                foreach($rows as $row){
                    $update_sql_array = array(
                        'ebay_titel'=>$ebay_title
                    );
                    xtc_db_perform('ebay_products',$update_sql_array,'update',"products_id='".$row['id']."'");
                    $comments = sprintf(HISTORY_UPDATE_CART_EBAY_TITLE,$ebay_title);
                    $EBAYAPI->save_history($row['id'], $comments, $_SESSION['customers_id']);
                    $updated++;
                }
            }
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_UPDATE_CART_EBAY_TITLE,$updated),'success');
        xtc_redirect($_REQUEST['referrer']);
        break;
    case 'update_products_description':
        $sql_data_array = array('products_description' => xtc_db_prepare_input(yes_decode_string($_POST['products_description_'.$_POST['lang']])));
        xtc_db_perform(TABLE_PRODUCTS_DESCRIPTION, $sql_data_array, 'update', 'products_id = \'' . intval(xtc_db_input($_GET['pID'])) . '\' and language_id=\''.intval(xtc_db_input($_POST['lang'])).'\'');
        $product = new product(intval(xtc_db_input($_GET['pID'])));
        $product->add_history(HISTORY_DESCRIPTION_UPDATED);
        if(isset($_REQUEST['update_ebay_products_description']) and $_REQUEST['update_ebay_products_description'] == '1'){
                $update_sql_array = array(
                        'ebay_beschreibung'=>xtc_db_prepare_input(yes_decode_string($_POST['products_description_'.$_POST['lang']]))
                );
                xtc_db_perform('ebay_products',$update_sql_array,'update','products_id='.intval(xtc_db_input($_GET['pID'])));
        }
        if(strlen($_POST['products_description_'.$_POST['lang']])>0){
                die('1');
        }
        die('-1');
        break;
    case 'update_products_extra_text':
        $sql_data_array = array('products_extra_text' => xtc_db_prepare_input(yes_decode_string($_POST['products_extra_text_'.$_POST['lang']])));
        xtc_db_perform(TABLE_PRODUCTS_DESCRIPTION, $sql_data_array, 'update', 'products_id = \'' . intval(xtc_db_input($_GET['pID'])) . '\' and language_id=\''.intval(xtc_db_input($_POST['lang'])).'\'');
        $product = new product(intval(xtc_db_input($_GET['pID'])));
        $product->add_history(HISTORY_EXTRATEXT_UPDATED);
        if(isset($_REQUEST['update_ebay_products_description']) and $_REQUEST['update_ebay_products_description'] == '1'){
                $update_sql_array = array(
                'ebay_beschreibung'=>xtc_db_prepare_input(yes_decode_string($_POST['products_extra_text_'.$_POST['lang']]))
                );
                xtc_db_perform('ebay_products',$update_sql_array,'update','products_id='.intval(xtc_db_input($_GET['pID'])));
        }
        if(strlen($_POST['products_extra_text_'.$_POST['lang']])>0){
                die('1');
        }
        die('-1');
        break;
    case 'update_products_short_description':
        $sql_data_array = array('products_short_description' => xtc_db_prepare_input(yes_decode_string($_POST['products_short_description_'.$_POST['lang']])));
        xtc_db_perform(TABLE_PRODUCTS_DESCRIPTION, $sql_data_array, 'update', 'products_id = \'' . intval(xtc_db_input($_GET['pID'])) . '\' and language_id=\''.intval(xtc_db_input($_POST['lang'])).'\'');
        $product = new product(intval(xtc_db_input($_GET['pID'])));
        $product->add_history(HISTORY_SHORT_DESCRIPTION_UPDATED);
        if(strlen($_POST['products_short_description_'.$_POST['lang']])>0){
                die('1');
        }
        die('-1');
        break;
    case 'get_template_content':
        $cID = intval(xtc_db_input($_REQUEST['cID']));
        $lID = intval(xtc_db_input($_REQUEST['lID']));
        $cgID = intval(xtc_db_input($_REQUEST['cgID']));
        if($cID < 1 or $lID < 1 or $cgID < 1) {
            die('Missing Parameters.');
        }
        $item = \YES4Trade\Model\content_manager::get_by_content_group_and_content_id_and_languages_id($cgID,$cID,$lID);
        if($item != null){
            header('Content-Type: text/html; charset='.CHARSET);
            echo xtc_db_prepare_input($item->content_text);
        }
        exit;
        break;
    case 'description_status':
        $pID = (int)xtc_db_input($_GET['pID']);
        $language_id = (int)xtc_db_input($_GET['language_id']);
        switch($_GET['src']){
                case 'products_extra_text':
                        $field = 'products_extra_text';
                        break;
                case 'products_short_description':
                        $field = 'products_short_description';
                        break;
                default:
                        $field = 'products_description';
                        break;
        }
        $query = xtc_db_query(sprintf("SELECT %s FROM products_description WHERE products_id='%s' and language_id='%s'",$field,$pID,$language_id));
        $result = xtc_db_fetch_array($query);
        if(strlen($result[$field])==0){
                echo "-1";
                exit;
        }
        echo "1";
        exit;
        break;
    case 'products_group_allocation':
            require('products_groups_allocation.php');
            exit;
            break;
    case 'products_group_allocation_grouped':
            require('products_groups_allocation_grouped.php');
            exit;
            break;
    case 'yes_import':
            require('yes_import.php');
            exit;
            break;
    // neues p2c check
    case 'yes_import2':
            require('yes2_import.php');
            exit;
            break;
    case 'multicopy':
        $smarty = new yesSmarty;
        $smarty->assign('TITLE',BUTTON_MULTICOPY);
        $smarty->assign('FORM', xtc_draw_form('mc_form', FILENAME_CATEGORIES, xtc_get_all_get_params(array('action')).'action=multicopy_save','POST','id="copy_to_form"'));
        $smarty->assign('FORM_END', '</form>');
        $smarty->assign('INPUT_MOVE',xtc_draw_radio_field('move',1,true));
        $smarty->assign('INPUT_COPY',xtc_draw_radio_field('move',3));
        $smarty->assign('INPUT_LINK',xtc_draw_radio_field('move',2));
        $smarty->assign('TEXT_MOVE',TEXT_MULTICOPY_MOVE);
        $smarty->assign('TEXT_COPY',TEXT_MULTICOPY_COPY);
        $smarty->assign('TEXT_LINK',TEXT_MULTICOPY_LINK);
        $cat = (isset($_GET['catID'])) ? xtc_db_input($_GET['catID']):'';
        $split = explode('_',$cat);
        $cat = $split[ sizeOf($split)-1 ];

		$cat_select = \YES4Trade\Model\category::get_categories_tree_select([
			'return_function'=>sprintf('$(\'input[name="move_to_category_id"]\').val(id);'),
			'ALL_ITEMS_SELECTABLE'=>'true'
		], new \yesSmarty());
        $smarty->assign('INPUT_CATEGORIES',$cat_select
			. '<br />Category ID'
			. xtc_draw_input_field('move_to_category_id','','size="8"',false,'number')
        );

        $smarty->assign('INPUT_SAVE',xtc_draw_input_field('sub',IMAGE_SAVE,'class="ui-button ui-corner-all ui-state-default" onclick="mc_save(this);"','','button'));
        header('Content-Type: text/html; charset='.CHARSET);
        $smarty->display('categories_multicopy.html');
        exit;
        break;
    // neues p2c check
    case 'multicopy_save':
        $new_parent_id = xtc_db_prepare_input($_REQUEST['move_to_category_id']);
        foreach($_REQUEST['pID'] as $k=>$pID){
            $products_id = (int)xtc_db_prepare_input($pID);
            if($_REQUEST['move'] == '1'){
                $cat_id = current(array_reverse(explode('_',xtc_db_prepare_input($_REQUEST['cPath']))));
                $new_parent_id = (int)xtc_db_input($_REQUEST['move_to_category_id']);
                $p2c_count = \YES4Trade\Model\products_to_categories::count_items(
                    $products_id, $new_parent_id
                );
                if ($p2c_count < 1) {
                    $update = false;
                    if($cat_id){
                        \YES4Trade\Model\products_to_categories::delete($products_id,(int)$cat_id);
                        $new = new \YES4Trade\Model\products_to_categories([
                            'products_id'=>$products_id,
                            'categories_id'=>$new_parent_id
                        ]);
                        $new->create();
                        $update = true;
                    }else{
                        $p2c_product_count = \YES4Trade\Model\products_to_categories::count_items($products_id);
                        if($p2c_product_count == 1){
                            \YES4Trade\Model\products_to_categories::delete($products_id);
                            $new = new \YES4Trade\Model\products_to_categories([
                                'products_id'=>$products_id,
                                'categories_id'=>$new_parent_id
                            ]);
                            $new->create();
                            $update = true;
                        }
                    }
                    if($update){

                        // BOF - default_category
                        $products_query = xtc_db_query(sprintf(
                                "SELECT default_category FROM products WHERE products_id='%s'",
                                $products_id
                        ));
                        $product = xtc_db_fetch_array($products_query);
                        if($product['default_category'] == $cat_id){
                            xtc_db_query(sprintf(
                                    "UPDATE products SET default_category='%s' WHERE products_id='%s'",
                                    $new_parent_id,$products_id
                            ));
                        }
                        // EOF - default_category


                        $comments = sprintf(HISTORY_PRODUCT_MOVED,xtc_output_generated_category_path(xtc_db_input($new_parent_id)) );
                        product::add_history_static($products_id, $comments);
                    }
                }
            }else if($_REQUEST['move'] == 2){
                $p2c_count = \YES4Trade\Model\products_to_categories::count_items(
                        $products_id, (int)$new_parent_id
                );
                if ($p2c_count < 1) {
                    $new = new \YES4Trade\Model\products_to_categories([
                        'products_id'=>$products_id,
                        'categories_id'=>(int)$new_parent_id
                    ]);
                    $new->create();
                    $comments = sprintf(HISTORY_PRODUCT_LINKED,xtc_output_generated_category_path(xtc_db_input($new_parent_id)));
                    product::add_history_static($products_id, $comments);
                }
            }else{ // copy
                $target_categories_array=array();
                $copy_qty=1;
                yes_copy_product($products_id,$new_parent_id,$target_categories_array,$copy_qty);
            }
        }
        $get_param_pid = '';
        if(is_array($_REQUEST['pID']) and sizeOf($_REQUEST['pID'])){
                $get_param_pid = 'pID='.current($_REQUEST['pID']);
        }
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action','pID','cPath')).xtc_get_path($new_parent_id).'&'.$get_param_pid));
        break;
    // neues p2c check
    case 'remove_other_links':
        $pID = xtc_db_prepare_input($_REQUEST['pID']);
        $cPath = xtc_db_prepare_input($_REQUEST['cPath']);
        $cPath_split = explode('_',$cPath);
        if(sizeOf($cPath_split)>0){
            $cPathID = $cPath_split[ (sizeOf($cPath_split)-1) ];
        }else{
            $cPathID = $cPath;
        }
        if($pID <= 0 or ($cPathID <= 0 and $cPathID != '0') ){
            $messageStack->add_session(MSG_ERROR_REMOVE_OTHER_LINKS,'error');
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','pID'))));
        }
        \YES4Trade\Model\products_to_categories::delete_by_products_id_exclude_category(
                (int)$pID,(int)$cPathID
        );
        $messageStack->add_session(sprintf(MSG_SUCCESS_REMOVE_OTHER_LINKS,$pID),'success');
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','pID'))));
        break;
    // neues p2c check
    case 'remove_link':
        $pID = xtc_db_prepare_input($_REQUEST['pID']);
        $cPath = xtc_db_prepare_input($_REQUEST['cPath']);
        $cPath_split = explode('_',$cPath);
        $ajax_mode = (isset($_REQUEST['ajax_mode']) and $_REQUEST['ajax_mode'] == 1) ? true : false;
        if(sizeOf($cPath_split)>0){
            $cPathID = $cPath_split[ (sizeOf($cPath_split)-1) ];
        }else{
            $cPathID = $cPath;
        }
        if($pID and $pID > 0 and ($cPathID > 0 or $cPathID == '0') ){
            $p2c_count = \YES4Trade\Model\products_to_categories::count_items((int)$pID);
            if ($p2c_count < 2) {
                if(!$ajax_mode){
                    $messageStack->add_session(MSG_REMOVE_LINK_ERROR,'error');
                    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
                }else{
                    header('Content-Type: text/html; charset='.CHARSET);
                    die(ICON_ERROR.': '.MSG_REMOVE_LINK_ERROR);
                }
            }else{
                \YES4Trade\Model\products_to_categories::delete((int)$pID,(int)$cPathID);
                $products_query = xtc_db_query(sprintf(
                    "SELECT default_category FROM products WHERE products_id='%d'",
                    $pID
                ));
                $product = xtc_db_fetch_array($products_query);
                if($product['default_category'] == $cPathID){
                    xtc_db_query(sprintf(
                        "UPDATE products SET default_category='0' WHERE products_id='%s'",
                        $pID
                    ));
                }
                // EOF - default_category


                // products_history
                $comments = sprintf(HISTORY_PRODUCTS_LINK_REMOVED,xtc_output_generated_category_path(xtc_db_input($cPathID)) );
                product::add_history_static((int)$pID, $comments);
                if(!$ajax_mode){
                    $messageStack->add_session($comments,'success');
                    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action','pID'))));
                }else{
                    header('Content-Type: text/html; charset='.CHARSET);
                    die(sprintf('<font color="red">'.$comments.'</font>'));
                }
            }
        }else{
            if(!$ajax_mode){
                $messageStack->add_session('Fehlende Parameter','error');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
            }else{
                header('Content-Type: text/html; charset='.CHARSET);
                die(ICON_ERROR.': '.'Fehlende Parameter');
            }
        }
        break;
    case 'new_category_ACD':
    case 'edit_category_ACD':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
        }else{
                $messageStack->add_session(MSG_AUTH_EDIT_CATEGORY,'error');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
        }
        break;
    case 'new_product':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
        }else{
            $messageStack->add_session(MSG_AUTH_EDIT_PRODUCTS,'error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
        }
        break;
    // neues p2c check
    case 'setcflag':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
        }else{
            $messageStack->add_session(MSG_AUTH_SET_CFLAG,'error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
        }
        if ( ($_GET['flag'] == '0') || ($_GET['flag'] == '1') ) {
            if ($_GET['cID']) {
                // BRAUCHEN WIR FUER DEN FALL, DAS SUBKATEGORIEN NICHT AKTUALISIERT WERDEN SOLLEN, ABER DIE ARTIKEL
                $start_cid = $_GET['cID'];
                // Neuer Parameter fuer update_products_shop
                // TICKET 3276
                xtc_set_categories_rekursiv($_GET['cID'], 
                    $_GET['flag'],
                    $_REQUEST['update_products'],
                    $_REQUEST['update_categories'], 
                    $_REQUEST['update_products_shop']
                );
            }
        }
        \yescache_helper::cache_bump_generation($InstanceCache, 'categories');
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','flag'))));
        break;
    case 'setpflag_json_confirm':
        $smarty = new yesSmarty;
        $smarty->display('products_status_update.html');
        exit;
        break;
    // neues p2c check
    case 'setpflag_json':
        require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'class.ebay.php');
        $EBAYAPI = new ebayAPI;
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
        }else{
            die(json_encode(array(
                'MSG'=>MSG_AUTH_SET_CFLAG
            )));
        }
        $flag = (int)xtc_db_input($_REQUEST['flag']);
        $pID = (int)xtc_db_input($_REQUEST['pID']);
        $error = false;
        if($flag == 1 and defined('CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE') and CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE == 'true'){
            $price_query = xtc_db_query(sprintf(
                "SELECT products_price FROM products WHERE products_id=%s",
                $pID
            ));
            $price = xtc_db_fetch_array($price_query);
            if($price['products_price'] <= 0){
                $error = true;
                die(json_encode(array(
                    'MSG'=>MSG_ERROR_CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE
                )));
            }
        }
        $messages = array();
        $SQ = new products_quantity($pID);
        if($flag == 0 and isset($_REQUEST['ps_cancel_amazon']) and $_REQUEST['ps_cancel_amazon'] == 1){
            if($SQ->get_amazon_qty() > 0){
                $update_qty = 0;

                require_once('includes/classes/amz_Helper.php');
                require_once('includes/classes/amazon_sp.php');
                $A = new amazon_helper;
                $fl = yes_get_products_amazon_fulfillmentlatency($pID);
                $sku_query = xtc_db_query(sprintf(
                        "SELECT sku,selling_partner_id FROM amazon_products WHERE products_id=%s",
                        $pID
                ));
                $json_array = ['feeds'=>[]];
                $sku_records = [];
                while($sku = xtc_db_fetch_array($sku_query)){
                    $sku_records[] = $sku;
                }

                foreach($sku_records as $sku){
                    $auth_params = $A->get_auth_data_array($sku['selling_partner_id']);
                    if(main::isDev(true)){ // amazon auth
                        $auth_params['marketplace_id'] = 'IRGENDEINE_MARKETPLACEID';
                    }
                    if(!isset($json_array['feeds'][$sku['selling_partner_id']])){
                        $json_array['feeds'][$sku['selling_partner_id']] = [];
                    }
                    $json_array['feeds'][$sku['selling_partner_id']][] = [
                        'sku'=>$sku['sku'],
                        'update_qty'=>$update_qty,
                        'fl'=>$fl,
                        'type'=>'update_qty',
                    ];
                } // end while sku / merchants
                $ASP = new amazon_sp(null,false);
                $json = json_encode($json_array, JSON_PRETTY_PRINT);
                $ASP->createFeedFile($json);
            }
        }

        if($flag == 0 and isset($_REQUEST['ps_cancel_auctions']) and $_REQUEST['ps_cancel_auctions'] == 1){
            if($SQ->get_auction_qty() > 0){
                $ea_list = \YES4Trade\Model\ebay_auctions::get_runnings_by_products_id(intval($pID));
                foreach($ea_list as $ea_obj){
                    $res = $EBAYAPI->ebay_end_auction(intval($ea_obj->id));
                    if($res['status'] == 'error'){
                        $messages[] = '[Null Revise: Seller '.$ea_obj->user.' / '.$ea_obj->ebay_id.'] '.  html_entity_decode(strip_tags($res['text']));
                        $error = true;
                    }
                }
                // hier war mal extra Variantenhandling fuer 
                // beendete Auktionen, aber das Varianten-
                // handling wird in ebay_end_auction bereits
                // ausgefuehrt - 2020/05
            }
        }
        if(!$error){
            xtc_set_product_status($pID, $flag);
            // products_history
            $comments = sprintf(HISTORY_SET_CFLAG,xtc_db_input($flag));
            product::add_history_static($pID, $comments);

            if(isset($_REQUEST['products_listing_status_update']) and $_REQUEST['products_listing_status_update'] == 1){
                $update_sql_array = array(
                    'products_listing_status'=>$flag
                );
                xtc_db_perform('products',$update_sql_array,'update',"products_id='".$pID."'");
                $comments = sprintf(HISTORY_SET_CFLAG_WITH_PRODUCTS_LISTING_STATUS,xtc_db_input($flag));
                product::add_history_static($pID, $comments);
            }

        }
        // wenn fehler, dann alten Status behalten
        $phys = 0;
        $v1 = 0;
        $v2 = 0;
        $ebay = 0;
        $amazon = 0;
        if($error){
            $flag = ($flag == 0) ? 1 : 0;
        }else{
            $SQ = new products_quantity($pID);
            $phys = $SQ->get_products_total_qty();
            $v1 = $SQ->get_available1_qty();
            $v2 = $SQ->get_available2_qty();
            $ebay = $SQ->get_auction_qty();
            $amazon = $SQ->get_amazon_qty();
        }
        die(json_encode(array(
            'MSG'=>implode("\r\n",$messages),
            'STATUS'=>$flag,
            'products_id'=>$pID,
            'phys' => $phys,
            'v1' => $v1,
            'v2' => $v2,
            'ebay' => $ebay,
            'amazon' => $amazon
        )));
        break;
    case 'setpflag':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
        }else{
            $messageStack->add_session(MSG_AUTH_SET_CFLAG,'error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
        }
        if ( isset($_REQUEST['flag']) and ($_GET['flag'] == '0') || ($_GET['flag'] == '1') ) {
            if (isset($_GET['pID'])) {
                $pID = (int)xtc_db_input($_REQUEST['pID']);
                $error = false;
                if($_GET['flag'] == 1 and defined('CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE') and CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE == 'true'){
                    $price_query = xtc_db_query(sprintf(
                        "SELECT products_price FROM products WHERE products_id=%s",
                        $pID
                    ));
                    $price = xtc_db_fetch_array($price_query);
                    if($price['products_price'] <= 0){
                        $error = true;
                        $messageStack->add_session(MSG_ERROR_CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE,'error');
                    }
                }
                if(!$error){
                    $flag = (int)xtc_db_input($_GET['flag']);
                    xtc_set_product_status($pID, $flag);
                    // products_history
                    $comments = sprintf(HISTORY_SET_CFLAG,xtc_db_input($flag));
                    product::add_history_static($pID, $comments);
                }
            }
            if($_GET['flag'] == '0' and isset($_REQUEST['ps_cancel_auctions']) and $_REQUEST['ps_cancel_auctions'] == 1){
                die('Cancel auctions');
            }
        }
        if (isset($_GET['pID'])) {
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','flag','ps_cancel_auctions','ps_cancel_amazon')) ) );
        } else {
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','flag','ps_cancel_auctions','ps_cancel_amazon')) ) );
        }
        break;
        
    case 'new_category':
    case 'edit_category':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
        }else{
                $messageStack->add_session(MSG_AUTH_EDIT_CATEGORIES,'error');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
        }
        if (ALLOW_CATEGORY_DESCRIPTIONS == 'true'){
            $_GET['action']=$_GET['action'] . '_ACD';
        }
        break;

    // neues p2c check
    case 'insert_category':
    case 'update_category':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
        }else{
            $messageStack->add_session(MSG_AUTH_EDIT_CATEGORIES,'error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
        }
        if (isset($_POST['edit_x']) or isset($_POST['edit_y'])) {
            $_GET['action'] = 'edit_category_ACD';
        } else {
            $categories_id = xtc_db_prepare_input($_POST['categories_id']);
            if ($categories_id == '') {
                $categories_id = xtc_db_prepare_input($_GET['cID']);
            }
            $sort_order = (int)xtc_db_prepare_input($_POST['sort_order']);
            $categories_status = xtc_db_prepare_input($_POST['categories_status']);
            // set allowed c.groups
            $group_ids='';
            if(isset($_POST['groups'])) foreach($_POST['groups'] as $b){
                $group_ids .= 'c_'.$b."_group ,";
            }
            $customers_statuses_array=xtc_get_customers_statuses();
            if (strstr($group_ids,'c_all_group')) {
                $group_ids='c_all_group,';
                for ($i=0;$n = sizeof($customers_statuses_array),$i < $n; $i++) {
                    $group_ids .='c_'.$customers_statuses_array[$i]['id'].'_group,';
                }
            }
            $sql_data_array = array(
                'sort_order' => intval($sort_order),
                'group_ids'=>$group_ids,
                'categories_status' => intval($categories_status),
                'products_sorting' => $_POST['products_sorting'],
                'products_sorting2' => $_POST['products_sorting2'],
                'categories_template'=>$_POST['categorie_template'],
                'listing_template'=>$_POST['listing_template'],
                'link_id'=>intval($_POST['link_id']??0),
                'ebayapi_cart'=>intval($_POST['ebayapi_cart']??0),
            );

            if ($_GET['action'] == 'insert_category') {
                $insert_sql_data = array(
                    'parent_id' => intval($current_category_id),
                    'date_added' => date('Y-m-d H:i:s')
                );
                $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                $new = new \YES4Trade\Model\category($sql_data_array);
                $categories_id = $new->create();
            } elseif ($_GET['action'] == 'update_category') {
                $update_sql_data = array(
                    'last_modified' => date('Y-m-d H:i:s'),
                    'categories_id'=>intval($categories_id)
                );
                $sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
                $upd = new \YES4Trade\Model\category($sql_data_array);
                $upd->update();
            }
            xtc_set_groups($categories_id,$group_ids);
            $languages = xtc_get_languages();
            $action = $_GET['action']??'';
            for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                $categories_name_array = $_POST['categories_name']??'';
                $language_id = $languages[$i]['id'];
                $sql_data_array = array(
                    'categories_name' => xtc_db_prepare_input($categories_name_array[$language_id]),
                    'categories_id' => intval($categories_id),
                    'language_id' => intval($languages[$i]['id'])
                );
                if (defined('ALLOW_CATEGORY_DESCRIPTIONS') and ALLOW_CATEGORY_DESCRIPTIONS == 'true') {
                    $sql_data_array['categories_name'] = xtc_db_prepare_input($_POST['categories_name'][$language_id]);
                    $sql_data_array['categories_heading_title'] = xtc_db_prepare_input($_POST['categories_heading_title'][$language_id]);
                    $sql_data_array['categories_description'] = xtc_db_prepare_input($_POST['categories_description'][$language_id]);
                    $sql_data_array['categories_meta_title'] = xtc_db_prepare_input($_POST['categories_meta_title'][$language_id]);
                    $sql_data_array['categories_meta_description'] = xtc_db_prepare_input($_POST['categories_meta_description'][$language_id]);
                    $sql_data_array['categories_meta_keywords'] = xtc_db_prepare_input($_POST['categories_meta_keywords'][$language_id]);
                    if(defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True'){
                        $sql_data_array['google_product_feed_category'] = xtc_db_prepare_input($_POST['google_product_feed_category'][$language_id]);
                    }
                }
                if(isset($admin_access['amazon_export'])){
                    $sql_data_array['amazon_flatfile'] = xtc_db_prepare_input($_POST['amazon_flatfile'][$language_id]);
                    $sql_data_array['amazon_browse_node_id'] = xtc_db_prepare_input($_POST['amazon_browse_node_id'][$language_id]);
                }
                if ($action == 'insert_category') {
                    $new = new \YES4Trade\Model\categories_description($sql_data_array);
                    $new->create();
                } elseif ($action == 'update_category') {
                    $upd = new \YES4Trade\Model\categories_description($sql_data_array);
                    $upd->update();
                }
            }
            if ($categories_image = &xtc_try_upload('categories_image', DIR_FS_CATALOG_IMAGES.'categories/')) {
                $cname_arr = explode('.',$categories_image->filename);
                $cnsuffix = array_pop($cname_arr);
                $categories_image_name = $categories_id . '.' . $cnsuffix;
                @unlink(DIR_FS_CATALOG_IMAGES.'categories/'.$categories_image_name);
                rename(DIR_FS_CATALOG_IMAGES.'categories/'.$categories_image->filename, DIR_FS_CATALOG_IMAGES.'categories/'.$categories_image_name);
                $upd = new \YES4Trade\Model\category([
                    'categories_image' => $categories_image_name,
                    'categories_id'=>intval($categories_id)
                ]);
                $upd->update();
            }
            
            if ($categories_additional_image = &xtc_try_upload('categories_additional_image', DIR_FS_CATALOG_IMAGES.'categories/')) {
                $cname_arr = explode('.',$categories_additional_image->filename);
                $cnsuffix = array_pop($cname_arr);
                $categories_additional_image_name = $categories_id . '_2.' . $cnsuffix;
                @unlink(DIR_FS_CATALOG_IMAGES.'categories/'.$categories_additional_image_name);
                rename(DIR_FS_CATALOG_IMAGES.'categories/'.$categories_additional_image->filename, DIR_FS_CATALOG_IMAGES.'categories/'.$categories_additional_image_name);
                $upd = new \YES4Trade\Model\category([
                    'categories_additional_image' => $categories_additional_image_name,
                    'categories_id'=>intval($categories_id)
                ]);
                $upd->update();
            }
            \yescache_helper::cache_bump_generation($InstanceCache, 'categories');

            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action','cID'))));
        }
        break;

    // neues p2c check
    case 'delete_category_confirm':
	    require_once(DIR_WS_CLASSES.'class.ebay.php');
        $EBAYAPI = new ebayAPI;
	    require_once(DIR_WS_CLASSES.'class.ebay_item.php');
	    require_once(DIR_WS_CLASSES.'class.ebay_product.php');
	// yes accounting
	    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
	    }else{
            $messageStack->add_session(MSG_AUTH_DELETE_CATEGORIES,'error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
	    }
        if (isset($_POST['categories_id']) and $_POST['categories_id'] > 0) {
            $categories_id = intval($_POST['categories_id']);
            // ersetzt die alte xtc_get_category_tree
            $categories = \YES4Trade\Model\category::get_categories_id_text_values_by_categories_id($categories_id);

            $products = array();
            $products_delete = array();

            foreach ($categories as $category) {
                $items = \YES4Trade\Model\products_to_categories::get_items_by_categories_id(
                    (int)$category['id']
                );
                foreach($items as $row) {
                    $products[$row['products_id']]['categories'][] = $category['id'];
                }
            }
            if(defined('MAX_DELETE_PRODUCTS_LIMIT')){
                $delete_limit = (int)MAX_DELETE_PRODUCTS_LIMIT;
            }else{
                $delete_limit = 1000;
            }
            if(sizeOf($products)>$delete_limit){
                $messageStack->add_session(sprintf(MSG_ERROR_DELETE_PRODUCTS,$delete_limit),'error');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
            }
			  

            reset($products);
            foreach($products as $key => $value) {
                $category_ids = '';
                for ($i = 0, $n = sizeof($value['categories']); $i < $n; $i++) {
                    $category_ids .= '\'' . $value['categories'][$i] . '\', ';
                }
                $category_ids = substr($category_ids, 0, -2);
                $check_query = xtc_db_query("select count(*) as total from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . $key . "' and categories_id not in (" . $category_ids . ")");
                $check = xtc_db_fetch_array($check_query);
                if ($check['total'] < '1') {
                    $products_delete[$key] = $key;
                }
            }

            // Removing categories can be a lengthy process
            @xtc_set_time_limit(0);
            foreach ($categories as $category) {
                xtc_remove_category(intval($category['id']));
            }

            reset($products_delete);
            $lz = array(); // Laufzeitmessung
            foreach($products_delete as $key => $egal) {
                xtc_remove_product($key);
            }
        }
        if (USE_CACHE == 'true') {
                xtc_reset_cache_block('categories');
                xtc_reset_cache_block('also_purchased');
        }
        \yescache_helper::cache_bump_generation($InstanceCache, 'categories');
        $messageStack->add_session(MSG_SUCCESS_CATEGORY_DELETE,'success');
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath));
        break;
    // neues p2c check
    case 'delete_product_confirm':
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
	}else{
            $messageStack->add_session(MSG_AUTH_DELETE_PRODUCT,'error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
	}
        if ( isset($_POST['products_id']) and (is_countable($_POST['product_categories'])) ) {
            $product_id = xtc_db_prepare_input($_POST['products_id']);
            $product_categories = $_POST['product_categories'];
            for ($i = 0, $n = sizeof($product_categories); $i < $n; $i++) {
                \YES4Trade\Model\products_to_categories::delete(
                      (int)$product_id,(int)$product_categories[$i]
                );
            }
            $p2c_count = \YES4Trade\Model\products_to_categories::count_items((int)$product_id);
            if ($p2c_count < 1) {
                xtc_remove_product($product_id);
            }
        }

        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath));
        break;
    // neues p2c check
    case 'move_category_confirm':
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
	}else{
		$messageStack->add_session(MSG_AUTH_MOVE_CATEGORIES,'error');
		xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
	}
        if ( ($_POST['categories_id']) && ($_POST['categories_id'] != $_POST['move_to_category_id']) ) {
          $categories_id = xtc_db_prepare_input($_POST['categories_id']);
          $new_parent_id = xtc_db_prepare_input($_POST['move_to_category_id']);
          $upd = new \YES4Trade\Model\category([
              'parent_id' => intval($new_parent_id),
              'last_modified' => date('Y-m-d H:i:s'),
              'categories_id' => intval($categories_id)
          ]);
          $upd->update();
        }

        \yescache_helper::cache_bump_generation($InstanceCache, 'categories');
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $new_parent_id . '&cID=' . $categories_id));
        break;
        
    // neues p2c check
    case 'move_product_confirm':
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
	}else{
            $messageStack->add_session(MSG_AUTH_MOVE_CATEGORIES,'error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
	}
        $products_id = (int)xtc_db_prepare_input($_POST['products_id']);
        $new_parent_id = xtc_db_prepare_input($_POST['move_to_category_id']);

        $p2c_count = \YES4Trade\Model\products_to_categories::count_items(
            (int)$products_id,(int) $new_parent_id
        );
        if ($p2c_count < 1) {
            // BOF - default_category
            $products_query = xtc_db_query(sprintf(
                    "SELECT default_category FROM products WHERE products_id='%s'",
                    $products_id
            ));
            $product = xtc_db_fetch_array($products_query);
            if($product->info['default_category'] == $current_category_id){
                xtc_db_query(sprintf(
                        "UPDATE products SET default_category='%s' WHERE products_id='%s'",
                        xtc_db_input($new_parent_id),$products_id
                ));
            }
            // EOF - default_category
            
            \YES4Trade\Model\products_to_categories::delete(
                    (int)$products_id,(int)$current_category_id
            );
            $new = new \YES4Trade\Model\products_to_categories([
                'products_id'=>(int)$products_id,
                'categories_id'=>(int)$new_parent_id
            ]);
            $new->create();
            // products_history
            $comments = sprintf(HISTORY_PRODUCT_MOVED,xtc_output_generated_category_path(xtc_db_input($new_parent_id)));
            product::add_history_static($products_id, $comments);
	}
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $new_parent_id . '&pID=' . $products_id));
        break;
      
    // neues p2c check
    case 'insert_product':
    case 'update_product':
    case 'insert_master':
    case 'update_master':
        $products_id = (int)xtc_db_input($_GET['pID']);
        $product = new product($products_id);
        require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
        $xtPrice = new xtcPrice($_SESSION['currency'],1); // GAST
        // BOF SHIPPING EXTRA CHARGE GRADUATION COUNTRIES
        $product->load_shipping_extra_charges();
        $submitted_extra_charges = array();
        $saved_array = $check_against_saved_array = array();
        $sec_changes_string_array = array();
        foreach(main::get_shipping_graduation_groups() as $sgg){
            $saved_matched = false;
            foreach($product->shipping_extra_charges as $sec){
                if($sec->shipping_graduation_groups_id == $sgg['id']){
                    $saved_array[] = $sgg['id'].':'.number_format($sec->shipping_extra_charge,2,'.','');
                    $saved_matched = true;
                }
            }
            if(!$saved_matched){
                $saved_array[] = $sgg['id'].':'.number_format(0,2,'.','');
            }
            $check_against_matched = false;
            if(isset($_POST['shipping_extra_charges'][$sgg['id']])){
                $amount = $_POST['shipping_extra_charges'][$sgg['id']];
                $amount = str_replace(',','.',$amount);
                $amount = (float)xtc_db_input($amount);
                $check_against_saved_array[] = $sgg['id'].':'.number_format($amount,2,'.','');
                $check_against_matched = true;
                $sec_changes_string_array[] = $sgg['text'].': '.$amount;
            }
            if(!$check_against_matched){
                $check_against_saved_array[] = $sgg['id'].':'.number_format(0,2,'.','');
            }
        }
        if(sizeOf(array_diff($saved_array,$check_against_saved_array))){
            xtc_db_query(sprintf(
                    "DELETE FROM products_shipping_extra_charge WHERE products_id='%s'",
                    $products_id
            ));
            foreach($_POST['shipping_extra_charges'] as $sggID=>$amount){
                $sggID = (int)xtc_db_input($sggID);
                $amount = str_replace(',','.',$amount);
                $amount = (float)xtc_db_input($amount);
                if($amount < 0.01){
                    continue;
                }
                $insert_sql_array = array(
                    'products_id'=>$products_id,
                    'shipping_graduation_groups_id'=>$sggID,
                    'shipping_extra_charge'=>$amount,
                    'date_added'=>'now()'
                );
                xtc_db_perform('products_shipping_extra_charge',$insert_sql_array);
            }
            $product->add_history(sprintf(HISTORY_PRODUCTS_SHIPPING_EXTRA_CHARGE_UPDATED,
                    implode(', ',$sec_changes_string_array)
            ));
        }
        // EOF SHIPPING EXTRA CHARGE GRADUATION COUNTRIES
		  
        if(defined('CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE') and CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE == 'true'){
            if ($_GET['action'] == 'update_product' or $_GET['action'] == 'update_master') {
                $price = (float)str_replace(',','.',$_POST['products_price']);
                if($_POST['products_status'] == 1 and $price <= 0){
                    $_POST['products_status'] = 0;
                    $messageStack->add_session(MSG_ERROR_CHECK_PRODUCTS_PRICE_AT_STATUS_CHANGE,'error');
                }
            }
        }
	   
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
	}else{
            $messageStack->add_session('Keine Berechtigung zum Produkt anlegen/bearbeiten.','error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
	}
	
	
	if(defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True'){
		xtc_db_query(sprintf(
			"DELETE FROM products_google_feed_data WHERE products_id='%s'",
			$products_id
		));
		$insert_sql_array = array(
			'google_condition'=>$_REQUEST['condition'],
			'availability'=>$_REQUEST['availability'],
			'gtin'=>$_REQUEST['gtin'],
			'mpn'=>$_REQUEST['mpn'],
			'adwords_grouping' => $_REQUEST['adwords_grouping'],
			'adwords_labels' => $_REQUEST['adwords_labels'],
			'products_id'=>$products_id
		);
		xtc_db_perform('products_google_feed_data',$insert_sql_array);
		
		if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
			$languages = xtc_get_languages();
			xtc_db_query(sprintf(
				"DELETE FROM products_google_feed_apparel WHERE products_id='%s'",
				$products_id
			));
			foreach($languages as $lang){
				$insert_sql_array = array(
                                    'gender'=>$_REQUEST['gender'][ $lang['id'] ],
                                    'age_group'=>$_REQUEST['age_group'][ $lang['id'] ],
                                    'color'=>$_REQUEST['color'][ $lang['id'] ],
                                    'size'=>$_REQUEST['size'][ $lang['id'] ],
				    'description'=>$_REQUEST['description'][ $lang['id'] ],
				    'material'=>$_REQUEST['material'][ $lang['id'] ],
				    'pattern'=>$_REQUEST['pattern'][ $lang['id'] ],
                                    'language_id' => $lang['id'],
                                    'products_id'=>$products_id
				);
				xtc_db_perform('products_google_feed_apparel',$insert_sql_array);
			}
		}
	}
	
	

	$collies = xtc_get_product_collies($products_id);
	$preisbindung = xtc_is_preisbindung($products_id);
        if (PRICE_IS_BRUTTO=='true' && $_POST['products_price']){
            if(COLLI_ACTIVE and sizeOf($collies)>0 and $preisbindung){
                $tax_rate = xtc_get_product_collies_tax_value($collies, STORE_COUNTRY,0);
                $_POST['products_price'] = (str_replace(',','.',$_POST['products_price'])/($tax_rate+100)*100);
            }else{
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, STORE_COUNTRY);
                $tax_rate = xtc_get_tax_rate($products_tax_class_id);
                $_POST['products_price'] = ( floatval(str_replace(',','.',$_POST['products_price'])) / (floatval($tax_rate)+100) *100);
            }
        }

	// PREISBINDUNG CHECK
	if($preisbindung and sizeOf($collies)>0){
            $preisbindung = xtc_get_preisbindung_value($products_id,1,$xtPrice);
            if(floatval($preisbindung) > floatval($_POST['products_price'])){
                $messageStack->add_session('Preisbindung: Der Preis muss mindestens '.number_format($preisbindung,2,',','.').' betragen.','error');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
            }
	}

	if ( isset($_POST['edit_x']) || isset($_POST['edit_y']) ) {
          if($_GET['action'] == 'insert_product')
	  	$_GET['action'] = 'new_product';
          else if($_GET['action'] == 'insert_product')
          	$_GET['action'] = 'new_master';
        } else {
            $products_date_available = xtc_db_prepare_input($_POST['products_date_available']);
            $products_date_available = (date('Y-m-d') < $products_date_available) ? $products_date_available : 'null';
            // set allowed c.groups
            $group_ids='';
            if(isset($_POST['groups'])) {
                foreach($_POST['groups'] as $b){
                    $group_ids .= 'c_'.$b."_group ,";
                }
            }
            $customers_statuses_array=xtc_get_customers_statuses();
            if (strstr($group_ids,'c_all_group')) {
        	$group_ids='c_all_group,';
         	for ($i=0; $n=sizeof($customers_statuses_array),$i < $n;$i++) {
            		$group_ids .='c_'.$customers_statuses_array[$i]['id'].'_group,';
         	}
            }
	  
            $orig_data_query = xtc_db_query("SELECT * FROM products WHERE products_id='".$products_id."'");
            $orig_data = xtc_db_fetch_array($orig_data_query);

            // Versandaufschlag	  
            $shipping_extra_charge = str_replace(',','.',$_POST['shipping_extra_charge']);

            if($orig_data['shipping_extra_charge'] <> $shipping_extra_charge){
		// products_history
		$comments = sprintf(HISTORY_PRODUCTS_SHIPPINGCOST_CHANGED,(float)xtc_db_prepare_input($shipping_extra_charge));
                product::add_history_static($products_id, $comments);
            }	  	  
            if($orig_data['cron_cancel_auctions_exclude'] != (int)$_REQUEST['cron_cancel_auctions_exclude']){
		// products_history
		$comments = sprintf(HISTORY_PRODUCTS_CRON_CANCEL_AUCTIONS_EXCLUDE_CHANGE,($_REQUEST['cron_cancel_auctions_exclude'] == 1)?'True':'False');
                product::add_history_static($products_id, $comments);
            }
            if($orig_data['cron_cancel_auctions_max_quantity'] <> (int)$_REQUEST['cron_cancel_auctions_max_quantity']){
		// products_history
		$comments = sprintf(HISTORY_PRODUCTS_CRON_CANCEL_AUCTIONS_MAX_QUANTITY_CHANGE,$_REQUEST['cron_cancel_auctions_max_quantity']);
                product::add_history_static($products_id, $comments);
            }
          

            if( $_POST['units_id'] and $orig_data['units_id'] != xtc_db_prepare_input($_POST['units_id']) ){
		// products_history
		$comments = sprintf(HISTORY_PRODUCTS_UNIT_CHANGED,xtc_get_units_title(xtc_db_prepare_input($_POST['units_id'])));
                product::add_history_static($products_id, $comments);
            }
            if( xtc_db_prepare_input($orig_data['comments']) != xtc_db_prepare_input($_POST['comments']) ){
		// products_history
		$comments = sprintf(HISTORY_PRODUCTS_COMMENT_CHANGED,xtc_db_input($_POST['comments']));
                product::add_history_static($products_id, $comments);
            }
            if( xtc_db_prepare_input($orig_data['shipping_comments']) != xtc_db_prepare_input($_POST['shipping_comments']) ){
		// products_history
		$comments = sprintf(HISTORY_PRODUCTS_SHIPPING_COMMENT_CHANGED,xtc_db_input($_POST['shipping_comments']));
                product::add_history_static($products_id, $comments);
            }
            $checks = array(
                0=>array('db'=>'products_model','admin'=>'model'),
                1=>array('db'=>'products_ean','admin'=>'barcode'),
                2=>array('db'=>'products_discount_allowed','admin'=>'price'),
                3=>array('db'=>'products_weight','admin'=>'weight'),
                4=>array('db'=>'products_status','admin'=>'status'),
                5=>array('db'=>'ebay_template','admin'=>'ebaytemplate'),
                6=>array('db'=>'manufacturers_id','admin'=>'manufacturer'),
                7=>array('db'=>'default_storage','admin'=>'defaultstorage'),
                8=>array('db'=>'products_fsk18','admin'=>'fsk18','post'=>'fsk18','type'=>'int'),
                9=>array('db'=>'price_fixing','admin'=>'price_fixing','type'=>'int'),
                10=>array('db'=>'products_weight_netto','admin'=>'weight'),
            );
            foreach($checks as $k=>$v){
                switch($v['db']){
                    case 'default_storage':
                    case 'manufacturers_id':
                        if($orig_data[$v['db']] != (int)$_POST[$v['db']] and $admin_access['f_change_products_'.$v['admin']] == '1'){
                            // products_history
                            $comments = sprintf(HISTORY_PRODUCTS_FIELD_CHANGED,$v['db'],xtc_db_input($_POST[$v['db']]));
                            product::add_history_static($products_id, $comments);
                        }
                        break;
                    default:
                        $postvalue = isset($v['post']) ? $v['post'] : $v['db'];
                        $check = (isset($v['type']) and $v['type'] == 'int') ? (int)@$_POST[$postvalue]:@$_POST[$postvalue];
                        if($orig_data[$v['db']] != $check and $admin_access['f_change_products_'.$v['admin']] == '1'){
                            // products_history
                            $comments = sprintf(HISTORY_PRODUCTS_FIELD_CHANGED,$v['db'],xtc_db_input($_POST[$postvalue]));
                            product::add_history_static($products_id, $comments);
                        }
                        break;
                }
            }


            $sql_data_array = array( 'group_ids'=>$group_ids );
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_products_meldebestand'] == '1')) {
                $sql_data_array['products_meldebestand'] = (int)xtc_db_input($_POST['products_meldebestand']);
                $mba = (isset($_POST['meldebestand_active'])) ? (int)xtc_db_input($_POST['meldebestand_active']) : 0;
                $sql_data_array['meldebestand_active'] = $mba;
            }
            $sql_data_array['shipping_extra_charge'] = xtc_db_prepare_input($shipping_extra_charge);
	  
            if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
                $sql_data_array['packaging_costs'] = (float)  xtc_db_prepare_input(str_replace(',','.',$_REQUEST['packaging_costs']));
            }

            if(defined('PRICE_IS_BRUTTO') and PRICE_IS_BRUTTO == 'true'){
                $tax_rate = xtc_get_tax_rate((int)xtc_db_input($_REQUEST['products_tax_class_id']));
                $uvp_value = xtc_oe_get_price_o_tax(str_replace(',','.',xtc_db_input($_REQUEST['uvp'])), $tax_rate);
            }else{
                $uvp_value = str_replace(',','.',xtc_db_input($_REQUEST['uvp']));
            }
            $sql_data_array['uvp'] = (float) $uvp_value;

            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_status'] == '1')) {
                  $sql_data_array['products_status'] = xtc_db_prepare_input($_POST['products_status']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_model'] == '1')) {
                  $sql_data_array['products_model'] = xtc_db_prepare_input($_POST['products_model']);
            }

            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price_fixing'] == '1')) {
                  $price_fixing = (isset($_POST['price_fixing'])) ? xtc_db_prepare_input($_POST['price_fixing']) : 0;
                  $sql_data_array['price_fixing'] = $price_fixing;
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_barcode'] == '1')) {
                  $sql_data_array['products_ean'] = xtc_db_prepare_input($_POST['products_ean']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['units'] == '1')) {
                  $sql_data_array['units_id'] = (isset($_POST['units_id'])) ? (int)xtc_db_input($_POST['units_id']) : 0;
            }
            $sql_data_array['packagings_id'] = (isset($_POST['packagings_id'])) ? (int)xtc_db_input($_POST['packagings_id']):0;
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_sort'] == '1')) {
                  $sql_data_array['products_sort'] = (int)xtc_db_input($_POST['products_sort']);
                  $startpage = (isset($_POST['products_startpage'])) ? xtc_db_prepare_input($_POST['products_startpage']) : 0;
                  $sql_data_array['products_startpage'] = $startpage;
                  $sql_data_array['products_startpage_sort'] = (int)xtc_db_input($_POST['products_startpage_sort']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_shippingtime'] == '1')) {
                  $sql_data_array['products_shippingtime'] = (int)xtc_db_input($_POST['shipping_status']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')) {
		  
		// BOF - PREISE UEBERTRAGEN AUF SLAVES
		if(isset($_REQUEST['change_slave_prices']) and $_REQUEST['change_slave_prices'] == 1){
                    $slaves_array = array();
                    $slaves_query = xtc_db_query(sprintf(
                            "SELECT products_id FROM products WHERE products_master='%d'",
                            $products_id
                    ));
                    while($slaves = xtc_db_fetch_array($slaves_query)){
                            $slaves_array[] = $slaves['products_id'];
                    }
                    if(sizeOf($slaves_array)){
                        foreach($slaves_array as $slave_products_id){
                            $slave_update_sql_array = array(
                                'products_price'=>xtc_db_prepare_input(str_replace(',','.',$_POST['products_price'])),
                                'products_discount_allowed'=>xtc_db_prepare_input($_POST['products_discount_allowed']),
                            );
                            xtc_db_perform('products',$slave_update_sql_array,'update','products_id='.$slave_products_id);
                            $comments = sprintf(
                                TEXT_UPDATE_PRODUCTS_GROUP_PRICES,
                                $products_id,xtc_db_prepare_input(str_replace(',','.',$_POST['products_price'])),
                                xtc_db_prepare_input($_POST['products_discount_allowed']),
                                xtc_get_tax_rate(xtc_db_prepare_input($_POST['products_tax_class_id']))
                            );
                            product::add_history_static($slave_products_id, $comments);
                        }
                    }
			
		}
                
                // BOF - default_category
		$sql_data_array['default_category'] = (int)xtc_db_input($_POST['default_category']);
                // EOF - default_category
                
		// EOF SLAVE PRICES
		$sql_data_array['products_price'] = (float)xtc_db_input(str_replace(',','.',$_POST['products_price']));
		$sql_data_array['products_discount_allowed'] = (int)xtc_db_input($_POST['products_discount_allowed']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_date_available'] == '1')) {
                  $sql_data_array['products_date_available'] = xtc_db_prepare_input($_POST['products_date_available']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_weight'] == '1')) {
                  $sql_data_array['products_weight'] = (float)xtc_db_input(str_replace(',','.',$_POST['products_weight']));
                  $sql_data_array['products_weight_netto'] = (float)xtc_db_input(str_replace(',','.',$_POST['products_weight_netto']));
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_infotemplate'] == '1')) {
                  $sql_data_array['product_template'] = xtc_db_prepare_input($_POST['info_template']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_ebaytemplate'] == '1')) {
                  $otemplate = (isset($_POST['options_template'])) ? xtc_db_prepare_input($_POST['options_template']) : '';
                  $sql_data_array['options_template'] = $otemplate;
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_optionstemplate'] == '1')) {
                  $sql_data_array['characteristics_template'] = xtc_db_prepare_input($_POST['characteristics_template']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_ebaytemplate'] == '1')) {
                  $sql_data_array['ebay_template'] = xtc_db_prepare_input($_POST['ebay_template']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_manufacturer'] == '1')) {
                  $sql_data_array['manufacturers_id'] = (int)xtc_db_input($_POST['manufacturers_id']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_defaultstorage'] == '1')) {
                  $sql_data_array['default_storage'] = (int)xtc_db_input($_POST['default_storage']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_size'] == '1')) {
                  $sql_data_array['size_width'] = (int)xtc_db_input($_POST['size_width']);
                  $sql_data_array['size_height'] = (int)xtc_db_input($_POST['size_height']);
                  $sql_data_array['size_depth'] = (int)xtc_db_input($_POST['size_depth']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_comments'] == '1')) {
                  $sql_data_array['comments'] = xtc_db_prepare_input($_POST['comments']);
                  $sql_data_array['storage_comments'] = xtc_db_prepare_input($_POST['storage_comments']);
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_fsk18'] == '1')) {
                  $sql_data_array['products_fsk18'] = xtc_db_prepare_input($_POST['fsk18']);
            }
				  	  
            $sql_data_array['products_conditions_id'] = (int)$_REQUEST['products_conditions_id'];
            $sql_data_array['mpn'] = $_REQUEST['mpn'];
            $sql_data_array['ebay_ProductReferenceID'] = $_REQUEST['ebay_productreferenceid'];
            $sql_data_array['disable_cron_update_products_status'] = (isset($_REQUEST['disable_cron_update_products_status']) and $_REQUEST['disable_cron_update_products_status'] == '1') ? 1 : 0;
// MASTER/SLAVE	  
            $sql_data_array['products_listing_status'] = xtc_db_prepare_input($_POST['products_listing_status']);
	//$sql_data_array['products_master_status'] = xtc_db_prepare_input($_POST['products_master_status']);
    //    $sql_data_array['products_master'] = xtc_db_prepare_input($_POST['products_master']);
	  
	  //get the next ai-value from table products if no products_id is set
            if(!$products_id || $products_id == '') {
                $new_pid_query = xtc_db_query("SHOW TABLE STATUS LIKE '" . TABLE_PRODUCTS . "'");
                $new_pid_query_values = xtc_db_fetch_array($new_pid_query);
                $products_id = $new_pid_query_values['Auto_increment'];
            }

            // **** LIEFERANTENVERWALTUNG *****
            if(isset($_POST['products_distributor']) and is_array($_POST['products_distributor'])){
                if($_GET['action'] == 'insert_product' or $_GET['action'] == 'insert_master'){
                    foreach($_POST['products_distributor'] as $k=>$distributor_id){
                        $new = new \YES4Trade\Model\products_distributors([
                            'products_id'=>intval($products_id),
                            'distributor_id'=>(int)$distributor_id
                        ]);
                        $new->create();

                        // lagername holen
                        $products_distributors_query = xtc_db_query("SELECT name FROM distributors WHERE id='".(int)$distributor_id."'");
                        $products_distributors = xtc_db_fetch_array($products_distributors_query);
                        $products_distributors_name = $products_distributors['name'];

                        // products_history
                        $comments = sprintf(HISTORY_PRODUCTS_DISTRIBUTOR_ADDED,xtc_db_input($products_distributors_name));
                        product::add_history_static($products_id, $comments);
                    }
                }else{
                        $exist_distributors = array();
			$submitted_distributors = array();
                        $items = \YES4Trade\Model\products_distributors::get_by_products_id(intval($products_id),[
                            'distributor_id','id'
                        ]);
                        foreach($items as $pdist){
                            $exist_distributors[] = $pdist->distributor_id;
                            if( !in_array( $pdist->distributor_id, $_POST['products_distributor'] ) ){
                                    // distributor geloescht
                                    $pd = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id(
                                        intval($products_id), intval($pdist->distributor_id)
                                    );
                                    if($pd !== null){
                                        \YES4Trade\Model\products_distributors::delete($pd->id);
                                    }

                                    // lagername holen
                                    $products_distributors_query = xtc_db_query("SELECT name FROM distributors WHERE id='".(int)$pdist->distributor_id."'");
                                    $products_distributors = xtc_db_fetch_array($products_distributors_query);
                                    $products_distributors_name = $products_distributors['name'];

                                    // products_history
                                    $comments = sprintf(HISTORY_PRODUCTS_DISTRIBUTOR_DELETED,xtc_db_input($products_distributors_name));
                                    product::add_history_static($products_id, $comments);
                            }
			}
                        foreach($_POST['products_distributor'] as $k=>$distributor_id){
				$submitted_distributors[] = $distributor_id;
				if( !in_array( $distributor_id, $exist_distributors ) ){
					// neuer distributor
                                    $new = new \YES4Trade\Model\products_distributors([
                                        'products_id'=>intval($products_id), 
                                        'distributor_id'=>(int)$distributor_id
                                    ]);
	                            $new->create();

                                    // lagername holen
                                    $products_distributors_query = xtc_db_query("SELECT name FROM distributors WHERE id='".(int)$distributor_id."'");
                                    $products_distributors = xtc_db_fetch_array($products_distributors_query);
                                    $products_distributors_name = $products_distributors['name'];
                                    // products_history
                                    $comments = sprintf(HISTORY_PRODUCTS_DISTRIBUTOR_ADDED,xtc_db_input($products_distributors_name));
                                    product::add_history_static($products_id, $comments);
				}
			}
                }
            }
            // **** ENDE LIEFERANTENVERWALTUNG ****
		  
            // BOF - VPE HANDLING
            $sql_data_array['products_vpe'] = (int)$_POST['products_vpe'];
            $vpe_status = (isset($_POST['products_vpe_status'])) ? xtc_db_prepare_input($_POST['products_vpe_status']) : 0;
            $sql_data_array['products_vpe_status'] = $vpe_status;
            $sql_data_array['products_vpe_value'] = (float)str_replace(',','.',$_POST['products_vpe_value']);
            $sql_data_array['products_vpe_base_measure'] = (float)str_replace(',','.',$_POST['products_vpe_base_measure']);
            // EOF - VPE HANDLING

            // BOF AMAZON HANDLING
            $sql_data_array['amazon_fulfillmentlatency'] = (int)xtc_db_input($_REQUEST['amazon_fulfillmentlatency']);
            $sql_data_array['amazon_revise'] = (isset($_REQUEST['amazon_revise']) and $_REQUEST['amazon_revise'] == 1) ? 1 : 0;
            $sql_data_array['amazon_revise_qty'] = (isset($_REQUEST['amazon_revise_qty']) and $_REQUEST['amazon_revise_qty'] > 0) ? (int)xtc_db_input($_REQUEST['amazon_revise_qty']) : 0;
            // EOF AMAZON HANDLING

            $sql_data_array['zollwarennummer'] = (isset($_REQUEST['zollwarennummer']) and $_REQUEST['zollwarennummer'] != '') ? $_REQUEST['zollwarennummer'] : '';
            $sql_data_array['no_yatego_export'] = (isset($_REQUEST['no_yatego_export']) and $_REQUEST['no_yatego_export'] > 0) ? 1 : 0;
            $sql_data_array['no_google_product_feed_export'] = (isset($_REQUEST['no_google_product_feed_export']) and $_REQUEST['no_google_product_feed_export'] > 0) ? 1 : 0;
            $sql_data_array['cron_cancel_auctions_exclude'] = (isset($_REQUEST['cron_cancel_auctions_exclude']) and $_REQUEST['cron_cancel_auctions_exclude'] == 1) ? 1 : 0;
            $sql_data_array['cron_cancel_auctions_max_quantity'] = (isset($_REQUEST['cron_cancel_auctions_max_quantity']) and $_REQUEST['cron_cancel_auctions_max_quantity'] > 0) ? (int)xtc_db_input($_REQUEST['cron_cancel_auctions_max_quantity']) : 0;
		  
            if ($_GET['action'] == 'insert_product' or $_GET['action'] == 'insert_master') {
                $insert_sql_data = array('products_date_added' => 'now()');
                $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                xtc_db_perform(TABLE_PRODUCTS, $sql_data_array);
                $products_id = xtc_db_insert_id();
                $new = new \YES4Trade\Model\products_to_categories([
                    'products_id'=>(int) $products_id,
                    'categories_id'=>(int) $current_category_id
                ]);
                $new->create();
            } elseif ($_GET['action'] == 'update_product' or $_GET['action'] == 'update_master') {
                $update_sql_data = array('products_last_modified' => 'now()');
                $sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
                xtc_db_perform(TABLE_PRODUCTS, $sql_data_array, 'update', 'products_id = \'' . xtc_db_input($products_id) . '\'');
            }

            $languages = xtc_get_languages();

            // KUNDENGRUPPENPREISE
            // Here we go, lets write Group prices into db
            // start
            $preisbindung_aktiv = false;
            if(COLLI_ACTIVE){
                  if(sizeOf($collies)>0){
                          if(xtc_is_preisbindung((int)$_GET['pID'])){
                                  $preisbindung_aktiv = true;
                          }
                  }
            }

            // ERMITTELE ALLE KUNDENGRUPPEN
            $i = 0;
            $group_data = array();
            $cs_array = xtc_get_customers_statuses();
            foreach($cs_array as $group_values) {
                if($group_values['id'] > 0){
                    // load data into array
                    $i++;
                    $group_data[$i] = array(
                        'STATUS_ID' => $group_values['id'],
                        'STATUS_NAME'=>$group_values['text'],
                    );
                }
            }
        
            if($preisbindung){
                // LOESCHE ALLE STAFFEL/KUNDENGRUPPENPREISE
                for ($col = 0, $n = sizeof($group_data); $col < $n+1; $col++) {
                    \YES4Trade\Model\group_prices::delete_by_products_id(
                        $group_data[$col]['STATUS_ID'], 
                        $products_id
                    );
                }

                $in_collies = xtc_get_product_in_collies($products_id);
                if(sizeOf($in_collies)>0){
                    foreach($in_collies as $k=>$v){
                        $icpID = $v['products_id'];
                        // LOESCHE DIE STAFFEL/KUNDENGRUPPENPREISE DER STUECKLISTENPRODUKTE
                        // DIE DIESES PRODUKT ENTHALTEN
                        for ($col = 0, $n = sizeof($group_data); $col < $n+1; $col++) {
                            if ($group_data[$col]['STATUS_ID'] != '') {
                                \YES4Trade\Model\group_prices::delete_by_products_id(
                                    $group_data[$col]['STATUS_ID'], 
                                    $icpID
                                );
                            }
                        }
                        // CHECKE DIE PREISBINDUNG DER STKLISTEN
                        $ic_collies = xtc_get_product_collies($icpID);
                        $ic_preisbindung = xtc_get_preisbindung_value($icpID,1,$xtPrice);
                        // EU OSS SAFE
                        $ic_tax_rate = xtc_get_product_collies_tax_value($ic_collies, STORE_COUNTRY,0);
                        $ic_products_price_query = xtc_db_query("SELECT products_price FROM products WHERE products_id='".$icpID."'");
                        $ic_products_price = xtc_db_fetch_array($ic_products_price_query);
                        $ic_products_price = ($ic_products_price['products_price']/($ic_tax_rate+100)*100);
                        // PREIS UNTERHALB PREISBINDUNG -> PRODUKTSTATUS NULL UND MELDUNG
                        if($ic_preisbindung > $ic_products_price){
                            $string = sprintf(NOTICE_NOTE_PRICE_FIXING_PRODUCT_ALERT,xtc_get_products_name($products_id),$products_id,number_format(str_replace(',','.',$_POST['products_price']),2,',',''),xtc_get_products_name($icpID),$icpID);
                            product::update_status($icpID, 0, $string);
                            // comment an auktion berechtigte
                            $capt = sprintf(NOTICE_CAPT_PRICE_FIXING_PRODUCT_ALERT,$icpID);
                            $recipients_array = main::get_notice_recipients('f_change_products_price_fixing');
                            yes_write_notice($capt, $string, 0, $recipients_array);
                        }
                    }
                }
            }else{ // end if preisbindung
                foreach ($group_data as $col=>$gdata) {
                    $personal_price = (float)xtc_db_prepare_input(str_replace(',','.',$_POST['products_price_' . $group_data[$col]['STATUS_ID']]));
                    if (PRICE_IS_BRUTTO=='true' && $personal_price <> 0){
                        $country_id = STORE_COUNTRY;
                        $tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, $country_id);
                        $personal_price= ($personal_price/(xtc_get_tax_rate($tax_class_id) +100)*100);
                    }
                    $personal_price=xtc_round($personal_price,PRICE_PRECISION);
                    $group_price_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                        $group_data[$col]['STATUS_ID'], $products_id
                    );
                    $found_gpi = false;
                    $GPI_one = null;
                    foreach($group_price_items as $GPI){
                        if($GPI->quantity==1){
                            $GPI_one = $GPI;
                            $found_gpi = true;
                            break;
                        }
                    }

                    if($found_gpi === true){
                        if($GPI_one->personal_offer <> (float)$personal_price){
                            $comments = sprintf(HISTORY_PRODUCTS_GROUP_PRICE_CHANGED,
                                $group_data[$col]['STATUS_NAME'],
                                number_format((float)$GPI_one->personal_offer,2,',','.'),
                                number_format((float)$personal_price,2,',','.')
                            );
                            product::add_history_static($products_id, $comments);
                        }
                        $GPI_one->personal_offer = (float)$personal_price;
                        $GPI_one->update($group_data[$col]['STATUS_ID']);
                    }else{
                        $GPI_new = new \YES4Trade\Model\group_prices_item([
                            'products_id'=>(int)$products_id,
                            'quantity'=>1,
                            'personal_offer'=>(float)$personal_price
                        ]);
                        $GPI_new->create($group_data[$col]['STATUS_ID']);
                        $comments = sprintf(HISTORY_PRODUCTS_GROUP_PRICE_CHANGED,
                            $group_data[$col]['STATUS_NAME'],
                            '0,00',
                            number_format((float)$personal_price,2,',','.')
                        );
                        product::add_history_static($products_id, $comments);
                    }
                    // BOF - SLAVE PREISE
                    if(is_countable($slaves_array) and sizeOf($slaves_array) and isset($_REQUEST['change_slave_prices']) and $_REQUEST['change_slave_prices'] == 1){
                        foreach($slaves_array as $slave_products_id){
                            $slave_group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                                $group_data[$col]['STATUS_ID'], 
                                $slave_products_id
                            );
                            foreach($slave_group_prices_items as $sGPI){
                                if($sGPI->quantity <> 1){
                                    continue;
                                }
                                $sGPI->update($group_data[$col]['STATUS_ID'], 
                                    $sGPI->price_id, 
                                    $personal_price
                                );
                            }
                            product::add_history_static($slave_products_id,
                                sprintf(
                                    TEXT_UPDATE_PRODUCTS_GROUP_PRICES_SHORT,
                                    $group_data[$col]['STATUS_NAME'],
                                    $products_id,number_format($personal_price,2,',','.')
                                )
                            );
                        }
                    }
                    // EOF - SLAVE PREISE
                } // end for customers_statuses
            }// end if !$preisbindung

            // PRODUKTBESCHREIBUNG
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_desc'] == '1')) {
		for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
			$language_id = $languages[$i]['id'];
			$sql_data_array = array(
			    'products_name' => xtc_db_prepare_input($_POST['products_name'][$language_id]),
			    'ebay_title' => substr(xtc_db_prepare_input($_POST['ebay_title'][$language_id]),0,MAX_SIZE_EBAY_TITLE ),
			    'products_url' => (isset($_POST['products_url'][$language_id])) ? xtc_db_prepare_input($_POST['products_url'][$language_id]) : '',
			    'products_meta_title' => xtc_db_prepare_input($_POST['products_meta_title'][$language_id]),
			    'products_meta_description' => xtc_db_prepare_input($_POST['products_meta_description'][$language_id]),
			    'products_meta_keywords' => xtc_db_prepare_input($_POST['products_meta_keywords'][$language_id]),
			    'products_description' => xtc_db_prepare_input($_POST['products_description'][$language_id]),
			    'products_short_description' => xtc_db_prepare_input($_POST['products_short_description'][$language_id]),
			    'products_extra_text' => xtc_db_prepare_input($_POST['products_extra_text'][$language_id]),
			    'amazon_title' => xtc_db_prepare_input($_POST['amazon_title'][$language_id]),
			);
			if(isset($_POST['products_condition'][$language_id])){
			    $sql_data_array['products_condition'] = $_POST['products_condition'][$language_id];
			}else{
			    $sql_data_array['products_condition'] = '';
			}
			if(isset($admin_access['amazon_export'])){
				$sql_data_array['amazon_flatfile'] = xtc_db_prepare_input($_POST['amazon_flatfile'][$language_id]);
				$sql_data_array['amazon_browse_node_id'] = xtc_db_prepare_input($_POST['amazon_browse_node_id'][$language_id]);
				$sql_data_array['products_description_amazon'] = xtc_db_prepare_input(strip_tags($_POST['products_description_amazon'][$language_id]));
			}
			if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
			    for($agkc=1;$agkc<=5;$agkc++){
				if(isset($_POST['amazon_generic_keywords'.$agkc][$language_id])){
				    $sql_data_array['amazon_generic_keywords'.$agkc] = xtc_db_prepare_input($_POST['amazon_generic_keywords'.$agkc][$language_id]);
				}
			    }
			}
			if($admin_access['f_change_products_slave_title'] == '1'){
				$sql_data_array['slave_title'] = xtc_db_prepare_input($_POST['slave_title'][$language_id]);
			}
	
			if ($_GET['action'] == 'insert_product' or $_GET['action'] == 'insert_master') {
				$insert_sql_data = array('products_id' => $products_id,
					'language_id' => $language_id);
				$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
				xtc_db_perform(TABLE_PRODUCTS_DESCRIPTION, $sql_data_array);
			} elseif ($_GET['action'] == 'update_product' or $_GET['action'] == 'update_master') {
				$orig_name_query = xtc_db_query("SELECT products_name FROM products_description WHERE products_id='".$products_id."' and language_id = '".$language_id."'");
				$orig_num = xtc_db_num_rows($orig_name_query);
				$orig_name = xtc_db_fetch_array($orig_name_query);
				if($orig_name['products_name'] != xtc_db_prepare_input($_POST['products_name'][$language_id])){
                                    // products history
                                    product::add_history_static(intval($products_id), sprintf(
                                        HISTORY_PRODUCTS_NAME_CHANGED,
                                        xtc_db_input($_POST['products_name'][$language_id])
                                    ));
				}
				if($orig_num > 0){
					xtc_db_perform(TABLE_PRODUCTS_DESCRIPTION, $sql_data_array, 'update', 'products_id = \'' . xtc_db_input($products_id) . '\' and language_id = \'' . $language_id . '\'');
				}else{
					$insert_sql_data = array('products_id' => $products_id,
						'language_id' => $language_id);
					$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
					xtc_db_perform(TABLE_PRODUCTS_DESCRIPTION, $sql_data_array);
				}
			}
			if(isset($_REQUEST['update_cart_description']) and $_REQUEST['update_cart_description'] != ''){
			    $update_params = explode('_',$_REQUEST['update_cart_description']);
			    switch($update_params[0]){
				case 'pd':
				    $content = xtc_db_input($_POST['products_description'][$update_params[1]]);
				    break;
				case 'sd':
				    $content = xtc_db_input($_POST['products_short_description'][$update_params[1]]);
				    break;
				case 'et':
				    $content = xtc_db_input($_POST['products_extra_text'][$update_params[1]]);
				    break;
			    }
			    xtc_db_query(sprintf(
				    "UPDATE ebay_products SET ebay_beschreibung='%s' WHERE products_id='%s'",
				    $content,$products_id
			    ));
			}
		}
            }
	  
            // ERWEITERTE VERSANDKOSTEN JE PRODUKT
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_products_ext_shippingcosts'] == '1')) {
	  	if($_POST['ext_shippingcosts'] == '1'){
                    if(is_array($_POST['shipping_price'])){
                        yes_query("DELETE FROM shipping_graduation_products WHERE products_id=:id",[
                            'id'=>intval($products_id)
                        ]);
                        foreach($_POST['shipping_price'] as $group_id=>$v){
                            foreach($v as $grad_id=>$value){
                                $value = xtc_db_input($value);
                                $value = str_replace(',','.',$value);
                                yes_db_perform('shipping_graduation_products',[
                                    'shipping_graduation_groups_id'=>intval($group_id), 
                                    'graduation_id'=>intval($grad_id), 
                                    'products_id'=>intval($products_id),
                                    'value'=>$value
                                ]);
                                
                            }
                        }
                    }
                    xtc_db_query("UPDATE products SET ext_additionalcosts='".(float)str_replace(',','.',$_POST['ext_additionalcosts'])."' WHERE products_id='".$products_id."'");
	  	}else{
			xtc_db_query("DELETE FROM shipping_graduation_products WHERE products_id='".$products_id."'");
		}
            }
            \YES4Trade\Model\shipper_profiles::allocate_to_products_id($_REQUEST['default_shipper'], $products_id );
            $messageStack->add_session(sprintf(MSG_SUCCESS_PRODUCTS_EDIT,$products_id),'success');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $products_id));
        } // end if ($_POST['edit_x']) || ($_POST['edit_y'])
        break;
    // neues p2c check
    case 'copy_to_confirm':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
        }else{
                $messageStack->add_session(MSG_AUTH_PRODUCTS_COPY,'error');
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))));
        }
        $products_id = intval($_POST['products_id']??0);
        $categories_id = intval($_POST['categories_id']??0);

    	if ( $products_id > 0 && $categories_id > 0 ) {
            if($_POST['copy_as'] == 'link'){
                $p2c_count = \YES4Trade\Model\products_to_categories::count_items(
                    $products_id, 
                    $categories_id
                );
                if ($p2c_count < 1) {
                    $new = new \YES4Trade\Model\products_to_categories([
                        'products_id'=>$products_id,
                        'categories_id'=>$categories_id
                    ]);
                    $new->create();
                    // products_history
                    $comments = sprintf(HISTORY_PRODUCT_LINKED,xtc_output_generated_category_path($categories_id));
                    product::add_history_static($products_id, $comments);
                    $messageStack->add_session(MSG_SUCCESS_PRODUCTS_LINK_SAVED, 'success');
                } else  {
                    $messageStack->add_session(ERROR_CANNOT_LINK_TO_SAME_CATEGORY, 'error');
                }
            }else{
                $copy_qty = (int)$_POST['copy_qty'];
                if($copy_qty < 1) {
                    $copy_qty = 1;
                }
                if($copy_qty > 500) {
                    $copy_qty = 500;
                }
                yes_copy_product($products_id,$categories_id,$_POST['cat_ids'],$copy_qty);
            }
	    }
        if(isset($_REQUEST['mode']) and $_REQUEST['mode'] == 'edit'){
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('cPath','pID','action')).'action=new_product&cPath=' . $categories_id . '&pID=' . $products_id));
        }else{
                xtc_redirect(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('cPath','pID','action')).'cPath=' . $categories_id . '&pID=' . $products_id));
        }
        break;
    } // end switch action
} // end if action
  

  // check if the catalog image directory exists
if (is_dir(DIR_FS_CATALOG_IMAGES)) {
    if (!is_writeable(DIR_FS_CATALOG_IMAGES)) {
        $messageStack->add(ERROR_CATALOG_IMAGE_DIRECTORY_NOT_WRITEABLE, 'error');
    }
} else {
    $messageStack->add(ERROR_CATALOG_IMAGE_DIRECTORY_DOES_NOT_EXIST, 'error');
}

if( isset($_GET['action']) and $_GET['action'] == 'new_product' && $_GET['pID'] < 1 ){
    // BOF - Amazon Fulfillment Latency TICKET 1808
    if(defined('MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY') and MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY > 0){
	$affl = MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY;
    }else{
	$affl = 0;
    }
    // EOF - Amazon Fulfillment Latency TICKET 1808
    // BUGFIX: date_added=now() statt date_added='now()'
    $insert_sql_array = [
        'products_date_added'=>'now()',
        'products_status'=>0,
        'amazon_fulfillmentlatency'=>$affl,
        'comments'=>'',
        'in_auction'=>0
    ];
    yes_db_perform(TABLE_PRODUCTS, $insert_sql_array);
    $new_pid = xtc_db_insert_id();
    $insert_sql_array = array(
        'products_id'=>$new_pid,
        'language_id'=>$_SESSION['languages_id'],
        'ebay_title'=>'',
        'slave_title'=>'',
        'products_condition'=>0,
        'amazon_generic_keywords1'=>'',
        'amazon_generic_keywords2'=>'',
        'amazon_generic_keywords3'=>'',
        'amazon_generic_keywords4'=>'',
        'amazon_generic_keywords5'=>'',
        'amazon_flatfile'=>'',
        'amazon_browse_node_id'=>'',
        'products_description_amazon'=>'',
        'amazon_title'=>''
    );
    yes_db_perform('products_description',$insert_sql_array);
    $new = new \YES4Trade\Model\products_to_categories([
        'products_id'=>(int)$new_pid,
        'categories_id'=>(int)$current_category_id
    ]);
    $new->create();
        
      
    if(defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True'){
        if(MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_CONDITION != '' and MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_AVAILABILITY != ''){
            $insert_sql_array = array(
                'products_id'=>$new_pid,
                'google_condition'=>MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_CONDITION,
                'availability'=>MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_AVAILABILITY,
                'gtin'=>'',
                'mpn'=>'',
                'adwords_grouping'=>'',
                'adwords_labels'=>''
            );
            xtc_db_perform('products_google_feed_data',$insert_sql_array);
        }
    }
      xtc_redirect(xtc_href_link('categories.php','cPath='.$_GET['cPath'].'&action=new_product&pID='.$new_pid));
}
if( isset($_GET['action']) and $_GET['action'] == 'new_product'){
  	if(NO_STORAGENUMBER_WARNING > 0){
		$storage_warning_query = xtc_db_query("SELECT count(1) as anzahl FROM storage_numbers WHERE products_id='".xtc_db_prepare_input($_GET['pID'])."'");
		$storage_warning = xtc_db_fetch_array($storage_warning_query);
		if($storage_warning['anzahl'] < 1){
			$messageStack->add(MSG_ERROR_PRODUCTS_NO_STORAGE_NUMBER);
		}
	}
}

if(isset($_REQUEST['export_csv']) and $_REQUEST['export_csv'] == 1){
    include('categories_view.php');
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script src="<?php echo yes_get_cdn_link('tinymce'); ?>"></script>
<script type="text/javascript" src="minify_js.php?file=js/amazon.min.js"></script>

<script type="text/javascript"><!--
// PROTOTYPE ONLOAD FUNCTION INIT
var ONLOADPAGE = 'categories';
<?php 
if(!isset($_GET['action'])){?> 
var ONLOADFUNC = "ajax_onload";
var ONLOADFUNCPARAM = 'mcopy'; // FORMNAME AJAXLISTING
var AJAX_LINK = '<?php echo xtc_href_link('ajax_categories_details.php'); ?>';


// **********************************************************************
// YES-LISTER FUNCTIONS
// **********************************************************************
var ajax_last_id;

function _parseUrl(base,params){
	params_array = params.split('&');
	params = '';
	for(i=0;i < params_array.length;i++){
	  keypair = params_array[i].split('=');
	  params += keypair[0]+'='+ escape(keypair[1]) +'&';
	}
	return base+'?'+params;
}

function yes_ajax_box_action(box_url){
	$.ajax({
		url: box_url,
		success: function(data) {
			$('#orderdetails').html(data);
		}
	});
}

function ajax_box_action(id,action){
   switch(action){
		case 'move_category':
		case 'delete_category':
			AJAX_GET_PARAMS = document.forms[ONLOADFUNCPARAM].elements['ajax_box_link['+id+']'].value;
			break;
		default:
			AJAX_GET_PARAMS = document.forms[ONLOADFUNCPARAM].elements['ajax_box_link[prod'+id+']'].value;
			break;
   }
  params = AJAX_GET_PARAMS+"&action="+action;
	$.ajax({
	  url: _parseUrl(AJAX_LINK,params),
	  success: function(data) {
		$('#orderdetails').html(data);
	  }
	});
}
var opener_dialog = false;
function ajax_onload(formname){
return true;
}
<?php
}else if($_GET['action'] == 'new_product' or $_GET['action'] == 'new_master'){
?>
	//-->
	</script>

    <script type="text/javascript" src="minify_js.php?file=js/ajaxupload.min.js"></script>
    <script type="text/javascript">
	<!--

	
var ONLOADFUNC = "ajax_onload_new_product";
var ONLOADFUNCPARAM = "";

function reset_wysiwygs(){
    
    
	<?php
	$src_array = array('products_description','products_extra_text','products_short_description');
	$languages = xtc_get_languages();
	for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
		for($j = 0;$j < sizeOf($src_array); $j++){
		    $src_link_id = $src_array[$j].'_status_'.$languages[$i]['name'];
		    $target_div_id = 'wsw_'.$src_array[$j].'_'.$languages[$i]['name'];	
	?>
			var default_button_class = 'default';
			$.each(tinymce.editors, function(index, editor){
			    if(editor.id == '<?php echo $src_array[$j].'['.$languages[$i]['id'].']';?>' ){
				if(editor.getContent() != ''){
				    default_button_class = 'active';
				}
			    }
			});
			$('button#<?php echo $src_link_id; ?>').attr('class','ui-state-'+default_button_class);
			$('div#<?php echo $target_div_id; ?>').hide();
			    
	<?php
		}
	}
	?>
}

function ajax_onload_new_product(){

	var ajax_updater_params = 'action=show';
	var ajax_updater_url = '<?php echo xtc_href_link('categories.php'); ?>';
	<?php
	$src_array = array('products_description','products_extra_text','products_short_description');
	$languages = xtc_get_languages();
	for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
	    $pd_query = xtc_db_query(sprintf(
		    "SELECT %s FROM %s WHERE products_id='%s' AND language_id='%s'",
		    implode(',',$src_array),TABLE_PRODUCTS_DESCRIPTION,
		    (int)xtc_db_input($_REQUEST['pID']),$languages[$i]['id']
	    ));
	    $pd = xtc_db_fetch_array($pd_query);
		for($j = 0;$j < sizeOf($src_array); $j++){
		    $src_link_id = $src_array[$j].'_status_'.$languages[$i]['name'];
		    $target_div_id = 'wsw_'.$src_array[$j].'_'.$languages[$i]['name'];
	?>
			var default_button_class = 'default';
				<?php if($pd[$src_array[$j]] != '') { ?>
				    default_button_class = 'active';
				<?php } ?>
			$('button#<?php echo $src_link_id; ?>').attr('class','ui-state-'+default_button_class);
			$('button#<?php echo $src_link_id; ?>').click(function(){
			    if(!$(this).hasClass('ui-state-highlight')){
				reset_wysiwygs();
			    }
			    $(this).toggleClass('ui-state-highlight');
			    $('div#<?php echo $target_div_id; ?>').toggle();
			});
			    
	<?php
		}
	}
	?>
	$('#tabs').show();
	$("#tabs").tabs();
	$('#products_distributors').load('categories.php?action=products_distributors&pID=<?php echo $_GET['pID']; ?>',
		{},
		function(){
			$('.lbOn_pd_action').click(
				function(){
					showPreloader();
					if($(this).hasClass('bigWidth'))
						width = YES_MODAL_BIGWIDTH;
					if($(this).hasClass('fullWidth')){
						width = YES_MODAL_FULLWIDTH;
					}
					$('#modal_window').dialog({title: this.title,width:500,modal:true}).load(this.id,function(){
						hidePreloader();
					});
				}
			);
		}
	);
<?php
	if(is_file(DIR_FS_ADMIN.'amazon.php')){
?>
	$('#amazon').load('categories.php?action=view_amazon&pID=<?php echo $_GET['pID']; ?>',
		{},
		function(){
			$('.lbOn_amazon_action').click(
				function(){
					showPreloader();
					$('#modal_window').dialog({title: this.title,width:500,modal:true}).load(this.id,function(){
						hidePreloader();
					});
				}
			);
		}
	);
<?php
	}
?>

}
<?php
} // end if new product
?>
var current_products_id = '<?php echo ((isset($_GET['pID']))?$_GET['pID']:'0'); ?>';
function ajax_delete_image(nr,file){
	confirm_string = '<?php echo JS_CONFIRM_REALLY_DELETE_IMAGE; ?>';
	yes = confirm(sprintf(confirm_string,file));
	if(yes){
		var url = '<?php echo xtc_href_link('categories.php','action=ajax_image_upload'); ?>';
		$('#pimage'+nr).load(url,
			{
			  file: file,
			  products_id: <?php echo ((isset($_GET['pID']))?$_GET['pID']:'0'); ?>,
			  nr: nr,
			  del: 1
			},
			function(response,status){
				load_image(nr,'');
			}
		);
	}
}
function toggle_visible_in_shop(nr){
	yes = confirm('<?php echo JS_CONFIRM_REALLY_VISIBLE_IN_SHOP; ?>');
	if(!yes){
		return false;
	}
	$('#visible_in_shop'+nr).load('categories.php?action=image_visible_in_shop_update&products_id=<?php echo ((isset($_GET['pID']))?$_GET['pID']:'0'); ?>&nr='+nr);
}

function load_visible_in_shop(nr){
	$('#visible_in_shop'+nr).load('categories.php?action=image_visible_in_shop&products_id=<?php echo ((isset($_GET['pID']))?$_GET['pID']:'0'); ?>&nr='+nr);
}
function load_image(nr,file){
    $('#pimage'+nr).load(
        '<?php echo xtc_href_link('categories.php'); ?>?file='+file+'&action=ajax_image_details&products_id=<?php echo ((isset($_GET['pID']))?$_GET['pID']:'0'); ?>&nr='+nr
    );
    if(file.length > 0){
            $('imgupload'+nr).hide();
    }
}

// clear_slots ist ohne funktionalitaet
function load_products_images(pID,clear_slots){
    $('div[id^="pimage"]').each(function(){
        $(this).html('');
    });
    var pimages = new Array();
    $.ajax({
       url: 'categories.php?action=get_products_images_array&pID='+pID,
       dataType: 'json',
       success: function(json){
            var ACTUAL_PIMAGE_FILE = json.IMAGES[0].file;
            var ACTUAL_PIMAGE_NR = 0;

            pimages_counter = 0;
            pimages[pimages_counter] = new Object();
            pimages[pimages_counter]['nr'] = 0;
            pimages[pimages_counter]['file'] = ACTUAL_PIMAGE_FILE;
            pimages_counter++;
            for(var i=1;i<json.IMAGES.length;i++){
                img = json.IMAGES[i];
                pimages[pimages_counter] = new Object();
                pimages[pimages_counter]['nr'] = img.nr;
                pimages[pimages_counter]['file'] = img.file;
                pimages_counter++;
            }
            for(i=0;i<pimages.length;i++){
                    ACTUAL_PIMAGE_FILE = pimages[i]['file'];
                    ACTUAL_PIMAGE_NR = pimages[i]['nr'];
                    load_image(ACTUAL_PIMAGE_NR,ACTUAL_PIMAGE_FILE);
                    
            }
            $( "#pics" ).sortable({
                items: '.product_pic',
                update: function(event, ui){
                    var sort_order = new Array();
                    $.each( $('#pics').sortable('toArray'),function(k,v){
                        sort_order.push(v.substring(2));
                    });
                    $.ajax({
                        url: 'categories.php?action=ajax_image_sort&products_id=<?php echo ((isset($_GET['pID']))?$_GET['pID']:'0'); ?>&sorting='+sort_order.join(':'),
                        dataType: 'json',
                        success: function(json){
                            if(json.ERROR != ''){
                                alert('Error: '+json.ERROR);
                                return false;
                            }
                            $('#pics .product_pic').each(function(index){
                                $(this).attr('id','PP'+index);
                                var h3_text = $(this).find('h3').text();
                                var file_parts = h3_text.split('_');
                                var file_nr_parts = file_parts[1].split('.');
                                new_filename = file_parts[0]+'_'+index+'.'+file_nr_parts[1];
                                $(this).find('h3').text(new_filename);
                                $(this).find('.PPNR').html('#'+(index+1));
                                $(this).find('.pp_details').attr('id','pimage'+index);
                                $(this).find('a.pp_upload_link').attr('id','image_upload_link'+index);
                                $(this).find('a#previewpic_link').attr('class','').addClass('imageSwap'+index);
                                var prvw_href = $(this).find('a#previewpic_link').attr('href');
                                var prvw_href_parts = prvw_href.split('/'+current_products_id+'_');
                                var prvw_href_nr_parts = prvw_href_parts[1].split('.');
                                prvw_href = prvw_href_parts[0]+'/'+current_products_id+'_'+index+'.'+prvw_href_nr_parts[1];
                                $(this).find('a#previewpic_link').attr('href', prvw_href);
                                $(this).find('img.pp_img_src').attr('id','mainImage'+index);
                                //$(this).find('img.pp_img_src').attr('src',prvw_href.replace(/original_images/,'thumbnail_images'));


                                $(this).find('a.download_product_img').attr('href',
                                    "categories.php?action=image_download&name="+new_filename
                                );
                                $(this).find('a.delete_product_img').attr('href',
                                    "javascript:void( ajax_delete_image("+index+",'"+new_filename+"'));"
                                );
                            });
                        },
                        error: function(xhr, err){
                            alert('Sorting Error - Informieren Sie das YES Team');
                        }
                    });
                }
            });
            $( "#pics" ).disableSelection();
     
       }
    });
}
// TEMPLATEAUSWAHL-PASTE IN BESCHREIBUNGEN
function template_select(forminstance){

	var id = forminstance.elements['vorlage'].value;
	var url = forminstance.action;
	return false;
}
function preview(href){
	window.open(href,'popup','width=<?php echo EXT_POPUP_WIDTH; ?>,height=<?php echo EXT_POPUP_HEIGHT; ?>,scrollbars=yes,resizable=yes');
}
//-->
</script>


<?php
if( isset($_GET['action']) and ($_GET['action'] == 'new_product' or $_GET['action'] == 'new_master')) {
    yes_draw_quicknote();
}
?>
<script type="text/javascript">
$(function(){
		$('.pAction').each(function(){ 
			$(this).change(function(){
			dom = document.forms['mcopy'];
			var min_check = 0;
			if(dom.elements['pID[]'].checked !== false)
					min_check++;
			for(i=0;i<dom.elements['pID[]'].length;i++){
				if(dom.elements['pID[]'][i].checked !== false)
					min_check++;
			}
			if(min_check == 0)
				return false;
			action = this.value;
			this.value = '';
			switch(action){
				case 'amz':
					var url = '<?php echo xtc_href_link('amazon.php',xtc_get_all_get_params(array('pID','action','catID')).'action=export');?>';
					var pids_selected = '';
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected += '&pID[]='+dom.elements['pID[]'][i].value;
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected += '&pID[]='+dom.elements['pID[]'].value;
						}
					}
					url += pids_selected;
					window.location.href = url;
					break;
                                case 'gd':
                                    // definiert in categories_view
                                    delete_products_groups_allocation();
				case 'mc':
					var url = '<?php echo xtc_href_link('categories.php',xtc_get_all_get_params(array('pID','action','catID')).'action=multicopy');?>';
					var dialog = $('<div title="<?php echo TEXT_INFO_HEADING_MULTICOPY; ?>" style="display:hidden"></div>').appendTo('body');
					dialog.load(
							url,
							{},
							function (responseText, textStatus, XMLHttpRequest) {
									dialog.dialog({modal:true,width:650});
							}
					);
					break;
				case 'ga':
					var url = '<?php echo xtc_href_link('categories.php',xtc_get_all_get_params(array('pID','action','catID')).'action=products_group_allocation'); ?>';
					var pids_selected = '';
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'][i].value;
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'].value;
						}
					}
					url += pids_selected;
					window.open(url,'groups','width=<?php echo EXT_POPUP_WIDTH; ?>,height=<?php echo EXT_POPUP_HEIGHT; ?>,scrollbars=yes,resizable=yes');
					break;
				case 'gag':
					var url = '<?php echo xtc_href_link('categories.php',xtc_get_all_get_params(array('pID','action','catID')).'action=products_group_allocation_grouped'); ?>';
					var pids_selected = '';
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'][i].value;
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'].value;
						}
					}
					url += pids_selected;
					window.open(url,'groupsg','width=<?php echo EXT_POPUP_WIDTH; ?>,height=<?php echo EXT_POPUP_HEIGHT; ?>,scrollbars=yes,resizable=yes');
					break;
				case 'ec':
				    var yes = confirm('<?php echo JS_CONFIRM_SAVE_SHOPPRODUCTS; ?>');
				    if(!yes) return false;
					var url = '<?php echo xtc_href_link('ebayapi_cart.php','action=saveshopproducts'); ?>';
					var pids_selected = new Array();
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected.push(dom.elements['pID[]'][i].value);
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected.push(dom.elements['pID[]'].value);
						}
					}
					url += '&add_pid='+pids_selected.join(',');
					window.location.href=url;
					break;
				case 'sc':
				    var yes = confirm('<?php echo JS_CONFIRM_ADD_SPECIALS; ?>');
				    if(!yes) return false;
					var url = '<?php echo xtc_href_link('specials.php','action=add_multiple_confirm'); ?>';
					var dialog = $('<div title="<?php echo TEXT_INFO_HEADING_MULTICOPY; ?>" style="display:hidden"></div>').appendTo('body');
					dialog.load(
						url,
						{},
						function (responseText, textStatus, XMLHttpRequest) {
							dialog.dialog({
								modal:true,
								width:650,
								create:function(){
									var opener_dialog = $(this);
								}
							});
						}
					);
					break;
				case 'st':
					var url = '<?php echo xtc_href_link('storage_admin.php','action=add_multiple_confirm'); ?>';
					var pids_selected = new Array();
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected.push(dom.elements['pID[]'][i].value);
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected.push(dom.elements['pID[]'].value);
						}
					}
					if(pids_selected.length < 1){
					    return false;
					}
					url += '&pID[]='+pids_selected.join('&pID[]=');
                                        
                                        //bof bugfix: erzeugtes div immer pruefen ob es existiert
                                        if($('#storage_products_multi_allocation').length){
                                            $('#storage_products_multi_allocation').remove();
                                        }
                                        // eof bugfix
                                        
					var dialog = $('<div title="<?php echo TEXT_MULTI_PRODUCTS_STORAGE_ALLOCATION; ?>" id="storage_products_multi_allocation" style="display:hidden"></div>').appendTo('body');
					dialog.load(
						url,
						{},
						function (responseText, textStatus, XMLHttpRequest) {
							dialog.dialog({
								modal:true,
								width:'1000',
								create:function(){
									var opener_dialog = $(this);
								}
							});
						}
					);
					break;
				case 'ms':
					var url = '<?php echo xtc_href_link(basename(__FILE__),'action=allocate_master_slave_confirm'); ?>';
					var pids_selected = new Array();
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected.push(dom.elements['pID[]'][i].value);
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected.push(dom.elements['pID[]'].value);
						}
					}
					if(pids_selected.length < 1){
					    return false;
					}
					url += '&pID[]='+pids_selected.join('&pID[]=');
					var dialog = $('<div title="<?php echo TEXT_CREATE_MASTER_SLAVE_ALLOCATION; ?>" id="allocate_master_slave_confirm" style="display:hidden"></div>').appendTo('body');
					dialog.load(
						url,
						{},
						function (responseText, textStatus, XMLHttpRequest) {
							dialog.dialog({
								modal:true,
								width:'auto',
								create:function(){
									var opener_dialog = $(this);
								}
							});
						}
					);
					break;
				case 'exp_yes2':
					var url = '<?php echo xtc_href_link('module_export.php',xtc_get_all_get_params(array('pID','action','catID')).'action=yes2_products_id_export'); ?>';
					var pids_selected = '';
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'][i].value;
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'].value;
						}
					}
					url += pids_selected;
					var dialog = $('<div title="Export yes Modul" id="export_yes2" style="display:hidden"></div>').appendTo('body');
					dialog.load(
						url,
						{},
						function (responseText, textStatus, XMLHttpRequest) {
							dialog.dialog({
								modal:true,
								width:'auto',
								create:function(){
									var opener_dialog = $(this);
								}
							});
						}
					);
					break;
				case 'un':
					var url = '<?php echo xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action','un_classifications_id')).'action=un_classifications'); ?>';
					var pids_selected = '';
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'][i].value;
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected += '&products_id[]='+dom.elements['pID[]'].value;
						}
					}
					url += pids_selected;
					var dialog = $('<div title="UN Classifications allocation" id="un_classification_allocation" style="display:hidden"></div>').appendTo('body');
					dialog.load(
						url,
						{},
						function (responseText, textStatus, XMLHttpRequest) {
							dialog.dialog({
								modal:true,
								width:'auto',
								create:function(){
									var opener_dialog = $(this);
								}
							});
						}
					);
					break;
				}
		  });
	});
});
</script>
<div id="modal_div" class="main"></div>

<!-- body //-->
<?php
//----- new_category / edit_category (when ALLOW_CATEGORY_DESCRIPTIONS is 'true') -----
if (isset($_GET['action']) and ($_GET['action'] == 'new_category_ACD' || $_GET['action'] == 'edit_category_ACD')) {
	echo '<table border="0" width="100%" cellspacing="0" cellpadding="0">';
	include('new_categorie.php');
	echo '</table>';
  	//----- new_category_preview (active when ALLOW_CATEGORY_DESCRIPTIONS is 'true') -----
} elseif (isset($_GET['action']) and $_GET['action'] == 'new_category_preview') {
  	// removed
} elseif( isset($_GET['action']) and ($_GET['action'] == 'new_product' or $_GET['action'] == 'new_master')) {
	include('new_product.php');
} elseif (isset($_GET['action']) and $_GET['action'] == 'new_product_preview') {
	  // preview removed
} else {
	echo '<table border="0" width="100%" cellspacing="2" cellpadding="2">';
  	//set $cPath to 0 if not set - FireFox workaround, didn't work when de/activating categories and $cPath wasn't set
  	if (!$cPath) {
            $cPath = '0';
        }
  	include('categories_view.php');
	echo '</table>';
}
require(DIR_WS_INCLUDES . 'footer.php');
