<?php
/* --------------------------------------------------------------
   $Id: content_manager.php,v 1.31 2018/03/21 12:43:12 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommercecoding standards www.oscommerce.com 
   (c) 2003	 nextcommerce (content_manager.php,v 1.18 2003/08/25); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contribution:
   SPAW PHP WYSIWYG editor  Copyright: Solmetra (c)2003 All rights reserved. | www.solmetra.com

   Released under the GNU General Public License
   --------------------------------------------------------------
*/

require('includes/application_top.php');
require_once(DIR_FS_INC . 'xtc_format_filesize.inc.php');
require_once(DIR_FS_INC . 'xtc_filesize.inc.php');
require_once(DIR_FS_INC . 'xtc_wysiwyg.inc.php');
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$languages = xtc_get_languages();
$musthaves_german = \YES4Trade\Model\content_manager::get_musthaves_by_languages_id(2);

if(isset($_GET['action']) and $_GET['action'] == 'create_musthaves'){
    if(!isset($_GET['languages_id'])){
        $messageStack->add_session('Keine Language &uuml;bergeben.','error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    $exists = false;
    foreach($languages as $l){
        if($l['id'] == $_GET['languages_id']){
            $exists = true;
        }
    }
    if(!$exists){
        $messageStack->add_session('Language invalid.','error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    $target_languages_id = (int)xtc_db_input($_GET['languages_id']);
    if($target_languages_id == 2){
        $messageStack->add_session('Kann Pflichtcontent nicht auf eigene Sprache kopieren.','error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    \YES4Trade\Model\content_manager::clear_musthaves_by_languages_id($target_languages_id);
    foreach($musthaves_german as $mh){
        $data = $mh->toArray();
        unset($data['content_id']);
        $data['languages_id'] = $target_languages_id;
        $new = new \YES4Trade\Model\content_manager( $data );
        $new->create();
    }
    $messageStack->add_session(MSG_MUSTHAVES_CREATED,'success');
    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
}


if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'replace'){
	include('content_manager_replace.php');
	exit;
}
if ( isset($_GET['special']) and $_GET['special']=='delete') {
	xtc_db_query("DELETE FROM ".TABLE_CONTENT_MANAGER." where content_id='".(int)$_GET['coID']."'");
	xtc_redirect(xtc_href_link(FILENAME_CONTENT_MANAGER)); 
} // if get special

if (isset($_GET['special']) and $_GET['special']=='delete_product') {
    \YES4Trade\Model\products_content::delete(intval($_GET['coID'])); // loescht descriptions mit
    foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
        if(strpos($cd->getKey(),'content.php')>-1 or strpos($cd->getKey(),'information.php')>-1){
            $InstanceCache->deleteItem($cd->getKey());
        }
    }
    xtc_redirect(xtc_href_link(FILENAME_CONTENT_MANAGER,'mode=products_content&pID='.(int)$_GET['pID']));
} // if get special

if (isset($_GET['id']) and ($_GET['id']=='update' or $_GET['id']=='insert')) {
    // set allowed c.groups
    $group_ids='';
    if(isset($_POST['groups'])){
        foreach($_POST['groups'] as $b){
            $group_ids .= 'c_'.$b."_group ,";
        }
    }
    $customers_statuses_array=xtc_get_customers_statuses();
    if (strstr($group_ids,'c_all_group')) {
            $group_ids='c_all_group,';
            for ($i=0;$n=sizeof($customers_statuses_array),$i<$n;$i++) {
                    $group_ids .='c_'.$customers_statuses_array[$i]['id'].'_group,';
            }
    }

    $content_title=xtc_db_prepare_input($_POST['cont_title']);
    $content_header=xtc_db_prepare_input($_POST['cont_heading']);
    $content_text=xtc_db_prepare_input($_POST['cont']);
    $coID=(int)xtc_db_prepare_input($_POST['coID']);
    $upload_file=xtc_db_prepare_input($_POST['file_upload']);
    $content_status=xtc_db_prepare_input($_POST['status']);
    $content_language=xtc_db_prepare_input($_POST['language']);
    $select_file=xtc_db_prepare_input($_POST['select_file']);
    $file_flag_raw = str_replace('ff_','',$_POST['file_flag']);
    $file_flag = intval($file_flag_raw);
    $parent_check=xtc_db_prepare_input($_POST['parent_check']);
    $parent_id=(int)xtc_db_prepare_input($_POST['parent']);
    $group_id=(int)xtc_db_prepare_input($_POST['content_group']);
    $group_ids = $group_ids;
    $sort_order = (int)xtc_db_prepare_input($_POST['sort_order']);
    $content_meta_title = xtc_db_prepare_input($_POST['cont_meta_title']);
    $content_meta_description = xtc_db_prepare_input($_POST['cont_meta_description']);
    $content_meta_keywords = xtc_db_prepare_input($_POST['cont_meta_keywords']);

    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
        if ($languages[$i]['code']==$content_language) {
            $content_language=$languages[$i]['id'];
        }
    } // for

    $error=false; // reset error flag
    if (strlen($content_title) < 1) {
        $error = true;
        $messageStack->add(ERROR_TITLE,'error');
    }  // if

    if ($content_status=='yes'){
        $content_status=1;
    } else{
        $content_status=0;
    }  // if

    if ($parent_check=='yes'){
        $parent_id = (int)$parent_id;
    } else{
        $parent_id = 0;
    }  // if

    if (!$error) {
        // file upload
        if ($select_file!='default') {
            $content_file_name=$select_file;
        }
        $ftype = array_pop( explode( ".", strtolower( $_FILES['file_upload']['name'] ) ) );
        if(in_array($ftype,array('html','htm','doc','pdf','gif','jpeg','jpg','png','bmp','zip','txt'))){
                if ($content_file = &xtc_try_upload('file_upload', DIR_FS_CATALOG.'media/content/')) {
                    $content_file_name=$content_file->filename;
                }  // if
        }else{
            if($_FILES['file_upload']['name'] and $_FILES['file_upload']['name'] !='' ){
                $messageStack->add_session(sprintf(
                    FORBIDDEN_FILE_UPLOAD,
                    $ftype
                ),'error');
            }
        }
        $cmobj = new \YES4Trade\Model\content_manager([
            'languages_id' => $content_language,
            'content_title' => $content_title,
            'content_heading' => $content_header,
            'content_text' => $content_text,
            'content_file' => $content_file_name,
            'content_status' => $content_status,
            'parent_id' => $parent_id,
            'group_ids' => $group_ids,
            'content_group' => $group_id,
            'sort_order' => $sort_order,
            'file_flag' => $file_flag,
            'content_meta_title' => $content_meta_title,
            'content_meta_description' => $content_meta_description,
            'content_meta_keywords' => $content_meta_keywords
        ]);

        if ($_GET['id']=='update') {
            $cmobj->content_id = $coID;
            $cmobj->update();
        } else {
            $cmobj->create();
        }
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            if(strpos($cd->getKey(),'content.php')>-1 or strpos($cd->getKey(),'information.php')>-1){
                $InstanceCache->deleteItem($cd->getKey());
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_CONTENT_MANAGER,xtc_get_all_get_params(['action','id','coID'])));
    }
} // if 
 
if (isset($_GET['id']) and ($_GET['id']=='update_product' or $_GET['id']=='insert_product')) {
	$content_link=xtc_db_prepare_input($_POST['cont_link']);
	$product=(int)xtc_db_prepare_input($_POST['product']);
	$upload_file=xtc_db_prepare_input($_POST['file_upload']);
	$filename=xtc_db_prepare_input($_POST['file_name']);
	$coID=(int)xtc_db_prepare_input($_POST['coID']);
	$select_file=xtc_db_prepare_input($_POST['select_file']);
	$group_ids = $group_ids;
	$error=false; // reset error flag

	$content_title=$_POST['cont_title'];
	$file_comment=$_POST['file_comment'];
    foreach($content_title as $language_id=>$ct){
        if (strlen($ct) < 1) {
            $error = true;
            $messageStack->add(ERROR_TITLE.' (language_id '.$language_id.')','error');
        }  // if
    }
	if (!$error) {
            if ($select_file=='default' && isset($_FILES['file_upload'])) {
                $ftype = array_pop( explode( ".", strtolower( $_FILES['file_upload']['name'] ) ) );
                if(in_array($ftype,array('html','htm','doc','pdf','gif','jpeg','jpg','png','bmp','zip','txt'))){
                    try{
                        $content_file = &xtc_try_upload('file_upload', DIR_FS_CATALOG.'media/products/');
                    }catch(Exception $e){
                        die($e->getMessage());
                    }
                    if ($content_file) {
                        $content_file_name=$content_file->filename;
                        $old_filename=$content_file->filename;
                        $timestamp=str_replace('.','',microtime());
                        $timestamp=str_replace(' ','',$timestamp);
                        $content_file_name=$timestamp.strstr($content_file_name,'.');
                        $rename_string=DIR_FS_CATALOG.'media/products/'.$content_file_name;
                        rename(DIR_FS_CATALOG.'media/products/'.$old_filename,$rename_string);
                        copy($rename_string,DIR_FS_CATALOG.'media/products/backup/'.$content_file_name);
                    }
                }else{
                    $messageStack->add_session(sprintf(
                        FORBIDDEN_FILE_UPLOAD,
                        $ftype
                    ),'error');
                }
                if ($content_file_name=='') $content_file_name=$filename;
            } else {
                $content_file_name=$select_file;
            }  
            $obj = new \YES4Trade\Model\products_content([
                'products_id' => $product,
                'group_ids' => $group_ids, 
                'content_file' => $content_file_name,
                'content_link' => $content_link,
            ]);
            
            if ($_GET['id']=='update_product') {
                $obj->content_id = $coID;
                $obj->update();
                foreach($content_title as $language_id=>$ct){
                    $pcd = \YES4Trade\Model\products_content_description::get_by_content_id_and_language_id(intval($coID),intval($language_id),[
                        'products_content_description_id'
                    ]);
                    
                    $lang_obj = new \YES4Trade\Model\products_content_description([
                        'content_name' => $ct,
                        'file_comment' => $file_comment[$language_id],
                        'products_content_description_id'=>intval($pcd->products_content_description_id)
                    ]);
                    $lang_obj->update();
                }

            } else {
                $coID = $obj->create();
                foreach($content_title as $language_id=>$ct){
                    $lang_obj = new \YES4Trade\Model\products_content_description([
                        'content_name' => $ct,
                        'file_comment' => $file_comment[$language_id],
                        'content_id'=>intval($coID),
                        'language_id'=>intval($language_id)
                    ]);
                    $lang_obj->create();
                }
            } // if get id
            foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
                if(strpos($cd->getKey(),'content.php')>-1 or strpos($cd->getKey(),'information.php')>-1){
                    $InstanceCache->deleteItem($cd->getKey());
                }
            }
            xtc_redirect(xtc_href_link(FILENAME_CONTENT_MANAGER,xtc_get_all_get_params(['id','action','coID'])));
	}// if error
}
$mode = (isset($_GET['mode']) and $_GET['mode'] == 'products_content')?'products_content':'';
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
$buttons[] = array('text'=>BUTTON_DB_REPLACE,
    'link'=>xtc_href_link(FILENAME_CONTENT_MANAGER,xtc_get_all_get_params(array('action')).'action=replace'),
    'lbOn'=>false,
    'auth'=>true
);
if(!isset($_GET['action'])){
    if($mode == ''){
        $buttons[] = array('text'=>HEADING_PRODUCTS_CONTENT,
            'link'=>xtc_href_link(FILENAME_CONTENT_MANAGER,'mode=products_content'),
            'lbOn'=>false,
            'auth'=>true
        );
    }else{
        $buttons[] = array('text'=>HEADING_CONTENT,
            'link'=>xtc_href_link(FILENAME_CONTENT_MANAGER),
            'lbOn'=>false,
            'auth'=>true
        );
    }
}

if(isset($_GET['action']) and $_GET['action'] == 'edit'){
    $buttons[] = array('text'=>ADD_QUICKNOTE,
        'link'=>'javascript:void(toggleBox(\'addquicknote\'))',
        'lbOn'=>false,
        'auth'=>true
    );
}
$additional_title = '';
$language_id = (isset($_GET['languages_id']))?(int)xtc_db_input($_GET['languages_id']):2;
$current_language_name = '';
foreach($languages as $l){
    if($l['id'] == $language_id){
        $current_language_name = $l['name'];
    }
}
$space_info = [];
$right_content = '';
if (!isset($_GET['action'])) {
    if($mode == ''){
        xtc_spaceUsed(DIR_FS_CATALOG.'media/content/');
    }else{
        xtc_spaceUsed(DIR_FS_CATALOG.'media/products/');
    }
    $space_info = [
        'USED_SPACE'=>USED_SPACE,
        'USED_SPACE_SIZE'=>xtc_format_filesize($total)
    ];
    $right_content = sprintf('%s %s',
            $space_info['USED_SPACE'],
            $space_info['USED_SPACE_SIZE']
    );
    $languages_list = [[
        'id'=>'',
        'text'=>TEXT_SELECT
    ]];
    foreach($languages as $l){
        if($l['id'] == $language_id){
            if($mode == ''){
                $additional_title = sprintf('%s - %s',HEADING_CONTENT, $l['name']);
            }else{
                $additional_title = sprintf('%s - %s',HEADING_PRODUCTS_CONTENT, $l['name']);
            }
        }
        $languages_list[] = [
            'id'=>$l['id'],
            'text'=>$l['name']
        ];
    }
    if(sizeOf($languages)>1){
        $smarty->assign('LANGUAGE_SELECT',xtc_draw_pull_down_menu('languages_id',$languages_list,$language_id));
    }
}else{
    switch($_GET['action']){
        case 'new_products_content':
        case 'new':
            $additional_title = TEXT_NEW_CONTENT;
            break;
        case 'edit_products_content':
        case 'edit':
            $additional_title = TEXT_EDIT;
            break;
    }
}
$smarty->assign(array(
    'LANG_BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['languages_id']).'languages_id='),
    'HEADING_TITLE'=>HEADING_TITLE,
    'ADDITIONAL_TITLE'=>$additional_title,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TINYMCE_VERSION'=>TINYMCE_VERSION,
    'RIGHT_CONTENT'=>$right_content,
    'CONTENT_NOTE'=>CONTENT_NOTE,
    'ACTION'=>(isset($_GET['action']))?$_GET['action']:'',
    'LINK_ADD_CONTENT'=>xtc_href_link(FILENAME_CONTENT_MANAGER,'action=new'),
    'TEXT_NEW_CONTENT'=>TEXT_NEW_CONTENT,
    'MODE'=>$mode,
));
if (!isset($_GET['action'])) {
    if($mode == ''){
        $table = new tableBlock();
        $table->table_parameters = 'class="yesListTable_minimal"';
        $contents = [[
            ['text'=>TABLE_HEADING_CONTENT_ID,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_TITLE,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_GROUP,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_SORT,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_FILE,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_STATUS,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_BOX,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_ACTION,'th'=>true]
        ]];
        $items = \YES4Trade\Model\content_manager::get_by_parent_id_and_languages_id(0,$language_id);
        foreach($items as $content_data){
            $ff = \YES4Trade\Model\cm_file_flags::get_by_file_flag($content_data->file_flag);
            $ctitle = $content_data->content_title;
            if($content_data->content_delete=='0'){
                $ctitle .= sprintf('&nbsp;<font title="%s" color="#ff0000">*</font>','System');
            }
            $action = sprintf('<a href="%s" style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-highlight ui-corner-all">%s</a>',
                xtc_href_link(FILENAME_CONTENT_MANAGER,'action=edit&coID='.$content_data->content_id.'&languages_id='.$language_id),
                TEXT_EDIT
            );
            $not_exists = '';
            if(!empty($content_data->content_file)){
                $target_file = HTTPS_CATALOG_SERVER.'shop_content.php?coID='.$content_data->content_group.'&popup=1';
                if(is_file(DIR_FS_CATALOG.'media/content/'.$content_data->content_file)){
                    $action .= sprintf('<a href="javascript:void(window.open(\'%s\', \'popup\', \'toolbar=0, width=%s, height=%s\'));" style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-highlight ui-corner-all">%s</a>',
                        $target_file,
                        EXT_POPUP_WIDTH, EXT_POPUP_HEIGHT,TEXT_PREVIEW
                    );
                }else{
                    $not_exists = '&nbsp;<img src="images/icons/warning.gif" title="File not exists" alt="File not exists" />';
                }
            }
            if ($content_data->content_delete==1){
                $action .= sprintf('<a href="%s" onclick="return confirm(\'%s\'" style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-error ui-corner-all">%s</a>',
                    xtc_href_link(FILENAME_CONTENT_MANAGER,'special=delete&coID='.$content_data->content_id),
                    CONFIRM_DELETE,TEXT_DELETE
                );
            }
            $contents[] = [
                ['text'=>$content_data->content_id],
                ['text'=>$ctitle],
                ['text'=>$content_data->content_group],
                ['text'=>$content_data->sort_order],
                ['text'=>(!empty($content_data->content_file)) ? $content_data->content_file.$not_exists : 'database'],
                ['text'=>($content_data->content_status==0)? TEXT_NO : TEXT_YES],
                ['text'=>($ff != null)?$ff->file_flag_name:'&nbsp;'],
                ['text'=>$action],
            ];
            $children = \YES4Trade\Model\content_manager::get_by_parent_id_and_languages_id($content_data->content_id, $language_id);
            foreach($children as $chl){
                $chff = \YES4Trade\Model\cm_file_flags::get_by_file_flag($chl->file_flag);
                $ch_action = sprintf('<a href="%s" style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-highlight ui-corner-all">%s</a>',
                    xtc_href_link(FILENAME_CONTENT_MANAGER,'action=edit&coID='.$chl->content_id),
                    TEXT_EDIT
                );
                $ch_action .= sprintf('<a href="javascript:void(window.open(\'%s\', \'popup\', \'toolbar=0, width=%s, height=%s\'));" style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-highlight ui-corner-all">%s</a>',
                    xtc_href_link(FILENAME_CONTENT_PREVIEW,'coID='.$chl->content_id),
                    EXT_POPUP_WIDTH,
                    EXT_POPUP_HEIGHT,
                    TEXT_PREVIEW
                );
                if ($chl->content_delete =='1' ){
                    $ch_action .= sprintf('<a href="%s" onclick="return confirm(\'%s\')" style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-highlight ui-corner-all">%s</a>',
                        xtc_href_link(FILENAME_CONTENT_MANAGER,'special=delete&coID='.$chl->content_id),
                        CONFIRM_DELETE,
                        TEXT_DELETE
                    );
                }
                $contents[] = [
                    ['text'=>$chl->content_id],
                    ['text'=>'--'.$chl->content_title],
                    ['text'=>$chl->content_file],
                    ['text'=>($chl->content_status==0)? TEXT_NO : TEXT_YES],
                    ['text'=>($chff != null)?$chff->file_flag_name:'&nbsp;'],
                    ['text'=>$ch_action],
                ];
            } // eof foreach children
        } // foreach items
        $musthave_import = '';
        if($language_id != 2){
            $musthaves = \YES4Trade\Model\content_manager::get_musthaves_by_languages_id($language_id);
            if(sizeOf($musthaves) <> sizeOf($musthaves_german)){
                $musthave_import = sprintf(MUSTHAVE_IMPORT_INTRO,
                        sizeOf($musthaves_german),
                        $current_language_name,
                        sizeOf($musthaves),
                );
            }
        }
        $smarty->assign([
            'LIST_TABLE'=>$table->tableBlock_draw($contents),
            'MUSTHAVE_IMPORT'=>$musthave_import,
            'BUTTON_MUSTHAVE_IMPORT'=>BUTTON_MUSTHAVE_IMPORT,
            'LINK_MUSTHAVE_IMPORT'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action']).'action=create_musthaves')
        ]);
    }else{
        $table = new tableBlock();
        $table->table_parameters = 'class="yesListTable_minimal"';
        $contents = [[
            ['text'=>'pID','th'=>true],
            ['text'=>TABLE_HEADING_PRODUCTS,'th'=>true],
            ['text'=>'Typ','th'=>true],
            ['text'=>TABLE_HEADING_LANGUAGE,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_NAME,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_FILE,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_FILESIZE,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_LINK,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_HITS,'th'=>true],
            ['text'=>TABLE_HEADING_CONTENT_ACTION,'th'=>true]
        ]];
        $items = \YES4Trade\Model\products_content::get();
        foreach($items as $item){
            $coa = $item->toArray();
            $allowed_filetypes = array('jpg','gif','jpeg','png','html','htm','txt','bmp'); 
            $file_ext = current(array_reverse(explode('.',$coa['content_file'])));
            if (!empty($coa['content_file'])) {
                if(in_array(strtolower($file_ext),['jpeg','jpg'])){
                    $icon = xtc_image(DIR_WS_CATALOG.'admin/images/icons/icon_jpg.jpg');
                }else{
                    if(is_file(DIR_WS_CATALOG.'admin/images/icons/icon_'.$file_ext.'.gif')){
                        $icon = xtc_image(DIR_WS_CATALOG.'admin/images/icons/icon_'.$file_ext.'.gif');
                    }else{
                        $icon = xtc_image(DIR_WS_CATALOG.'admin/images/icons/file.gif');
                    }
                }
            } else {
                $icon = '<span title="Link">&#128279;</span>';
            }
            $pcd = \YES4Trade\Model\products_content_description::get_by_content_id_and_language_id(intval($coa['content_id']),intval($language_id));
            for ($xx=0,$zz=sizeof($languages); $xx<$zz;$xx++){
                if ($languages[$xx]['id']==$language_id) {
                    $lang_dir=$languages[$xx]['directory'];	
                    break;
                }	
            }
            $actions = sprintf('<a style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-error ui-corner-all" href="%s" onClick="return confirm(\'%s\')">%s</a>',
                xtc_href_link(FILENAME_CONTENT_MANAGER,'special=delete_product&coID='.$coa['content_id']),
                CONFIRM_DELETE,
                TEXT_DELETE
            );
            $actions .= sprintf('<a style="padding:2px;text-decoration:none;" class="ui-button ui-button-text-only ui-widget ui-state-highlight ui-corner-all" href="%s">%s</a>',
                xtc_href_link(FILENAME_CONTENT_MANAGER,'action=edit_products_content&coID='.$coa['content_id'].'&languages_id='.$language_id,),
                TEXT_EDIT
            );
            // display preview button if filetype 
            // .gif,.jpg,.png,.html,.htm,.txt,.tif,.bmp
            $rel_path = \YES4Trade\Model\products_content::get_file_content_dir($coa['content_file']);
            if (!empty($coa['content_file'])) {
    
                $actions .= sprintf('<a style="padding:2px;" class="ui-button ui-button-text-only ui-widget ui-state-highlight ui-corner-all" onClick="javascript:window.open(\'%s\', \'popup\', \'toolbar=0, width=640, height=600\')" href="javascript:;">%s</a>',
                    HTTPS_CATALOG_SERVER.$rel_path,
                    TEXT_PREVIEW
                );
            }
            $pcd = \YES4Trade\Model\products_content_description::get_by_content_id_and_language_id(intval($coa['content_id']),intval($language_id),[
                'content_name'
            ]);
            $contents[] = [
                ['text'=>$coa['products_id']],
                ['text'=>xtc_get_products_name($coa['products_id'])],
                ['text'=>$icon],
                ['text'=>xtc_image(DIR_WS_CATALOG.'lang/'.$lang_dir.'/admin/images/icon.gif')],
                ['text'=>(!empty($pcd->content_name))?$pcd->content_name:'&nbsp;'],
                ['text'=>(!empty($coa['content_file']))?$coa['content_file']:'&nbsp;'],
                ['text'=>(!empty($coa['content_file'])) ? basics::formatBytes(filesize(DIR_FS_CATALOG.$rel_path)) : '&nbsp;'],
                ['text'=>(!empty($coa['content_link'])) ? sprintf(
                        '<a href="%s" target="new">%s</a>',
                        $coa['content_link'],$coa['content_link']
                ) : '&nbsp;'],
                ['text'=>$coa['content_read']],
                ['text'=>$actions],
            ];
        } // eof foreach pc items
        $smarty->assign([
            'LINK_ADD_PC' => xtc_href_link(FILENAME_CONTENT_MANAGER,'action=new_products_content'),
            'TEXT_NEW_CONTENT'=>TEXT_NEW_CONTENT,
            'PC_TABLE'=>$table->tableBlock_draw($contents),
        ]);
    }
} else { // IF GET ACTION
    switch ($_GET['action']) {
        case 'new':    
        case 'edit':
            $default_languages_id = $language_id;
            if ($_GET['action']!='new') {
                $item = \YES4Trade\Model\content_manager::get_by_content_id((int)xtc_db_input($_GET['coID']));
                $default_languages_id = $item->languages_id;
            }else{
                $item = new \YES4Trade\Model\content_manager();
            }
            $languages_array = array();
            for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
                if ($languages[$i]['id']==$default_languages_id) {
                    $languages_selected=$languages[$i]['code'];
                    $languages_id=$languages[$i]['id'];
                }               
                $languages_array[] = array(
                    'id' => $languages[$i]['code'],
                    'text' => $languages[$i]['name']
                );

            }
            yes_draw_quicknote();
            if ($_GET['action']!='new') {
                $form = xtc_draw_form('edit_content',FILENAME_CONTENT_MANAGER,'action=edit&id=update&coID='.$_GET['coID'].'&languages_id='.$language_id,'post','enctype="multipart/form-data"').xtc_draw_hidden_field('coID',$_GET['coID']);
            } else {
                $form = xtc_draw_form('edit_content',FILENAME_CONTENT_MANAGER,'action=edit&id=insert&coID='.$_GET['coID'].'&languages_id='.$language_id,'post','enctype="multipart/form-data"').xtc_draw_hidden_field('coID',$_GET['coID']);
            } 
            if($item->content_delete != 0 or !isset($item->content_delete) /*or $ACTION == 'new'*/){
                $input_content_group = xtc_draw_input_field('content_group',$item->content_group,'size="5"').TEXT_GROUP_DESC;
            }else{
                $input_content_group = xtc_draw_hidden_field('content_group',$item->content_group).$item->content_group;
            }
            $ff = \YES4Trade\Model\cm_file_flags::get_all();
            foreach($ff as $file_flag){
                $file_flag_array[] = array('id' => 'ff_'.$file_flag->file_flag, 'text' => $file_flag->file_flag_name);
            }
            $group_check_array = [];
            if (GROUP_CHECK=='true') {
                $customers_statuses_array = xtc_get_customers_statuses();
                $customers_statuses_array=array_merge(array(array('id'=>'all','text'=>TXT_ALL)),$customers_statuses_array);
                for ($i=0;$n=sizeof($customers_statuses_array),$i<$n;$i++) {
                    if (strstr($item->group_ids,'c_'.$customers_statuses_array[$i]['id'].'_group')) {
                        $checked='checked ';
                    } else {
                        $checked='';
                    }
                    $group_check_array[] = '<input type="checkbox" name="groups[]" value="'.$customers_statuses_array[$i]['id'].'"'.$checked.'> '.$customers_statuses_array[$i]['text'];
                }
            }
            $dir= opendir(DIR_FS_CATALOG.'media/content/');
            if ($dir){
                while  (($file = readdir($dir)) !==false) {
                    if (is_file( DIR_FS_CATALOG.'media/content/'.$file) and ($file !="index.html")){
                        $files[]=array(
                            'id' => $file,
                            'text' => $file
                        ); 
                    }//if
                } // while
                closedir($dir);
            }
            // set default value in dropdown!
            if (empty($item->content_file)){
                $default_array[]=array('id' => 'default','text' => TEXT_SELECT);
                $default_value='default';
                if (!is_countable($files) or !sizeOf($files)){
                    $files = $default_array;
                }else{
                    $files=array_merge($default_array,$files);
                }
            } else {
                $default_array[]=array('id' => 'default','text' => TEXT_NO_FILE);
                $default_value=$content['content_file'];
                if (!sizeOf($files)){
                    $files = $default_array;
                }else{
                    $files=array_merge($default_array,$files);
                }
            }
            $input_choose_file = TEXT_CHOOSE_FILE_SERVER.'</br>';
            $input_choose_file .= xtc_draw_pull_down_menu('select_file',$files,$default_value);
            if (!empty($item->content_file)) {
                $input_choose_file .= TEXT_CURRENT_FILE.' <b>'.$item->content_file.'</b>';
            }
            $input_content = xtc_draw_textarea_field('cont','virtual',80,35,$item->content_text,'class="tinymce"')
                .xtc_wysiwyg(array());

            $smarty->assign([
                'FORM'=>$form,
                'TEXT_LANGUAGE'=>TEXT_LANGUAGE,
                'INPUT_LANGUAGE'=>xtc_draw_pull_down_menu('language',$languages_array,$languages_selected),
                'content'=>$item,
                'TEXT_GROUP'=>TEXT_GROUP,
                'INPUT_CONTENT_GROUP'=>$input_content_group,
                'INPUT_FILE_FLAG'=>xtc_draw_pull_down_menu('file_flag',$file_flag_array,'ff_'.$item->file_flag),
                'TEXT_FILE_FLAG'=>TEXT_FILE_FLAG,
                'TEXT_SORT_ORDER'=>TEXT_SORT_ORDER,
                'INPUT_SORT_ORDER'=>xtc_draw_input_field('sort_order',$item->sort_order,'size="5"'),
                'TEXT_STATUS_DISPLAY'=>TEXT_STATUS_DISPLAY,
                'INPUT_STATUS_DISPLAY'=>xtc_draw_checkbox_field('status', 'yes',($item->content_status == 1)).' '.TEXT_STATUS_DESCRIPTION,
                'ENTRY_CUSTOMERS_STATUS'=>ENTRY_CUSTOMERS_STATUS,
                'GROUP_CHECK_ARRAY'=>$group_check_array,
                'TEXT_TITLE'=>TEXT_TITLE,
                'INPUT_TITLE'=>xtc_draw_input_field('cont_title',$item->content_title,'size="60"'),
                'TEXT_HEADING'=>TEXT_HEADING,
                'INPUT_HEADING'=>xtc_draw_input_field('cont_heading',$item->content_heading,'size="60"'),
                'INPUT_META_TITLE'=>xtc_draw_input_field('cont_meta_title',$item->content_meta_title,'size="60"'),
                'INPUT_META_DESC'=>xtc_draw_input_field('cont_meta_description',$item->content_meta_description,'size="60"'),
                'INPUT_META_KEYWORDS'=>xtc_draw_input_field('cont_meta_keywords',$item->content_meta_keywords,'size="60"'),
                'TEXT_UPLOAD_FILE'=>TEXT_UPLOAD_FILE,
                'INPUT_UPLOAD_FILE'=>xtc_draw_file_field('file_upload').' '.TEXT_UPLOAD_FILE_LOCAL,
                'TEXT_CHOOSE_FILE'=>TEXT_CHOOSE_FILE,
                'INPUT_CHOOSE_FILE'=>$input_choose_file,
                'TEXT_FILE_DESCRIPTION'=>TEXT_FILE_DESCRIPTION,
                'TEXT_CONTENT'=>TEXT_CONTENT,
                'INPUT_CONTENT'=>$input_content,
                'BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])),
            ]);
            break;
    case 'edit_products_content':
    case 'new_products_content':
        $content = array();
        if ($_GET['action']=='edit_products_content') {
            $contentObj = \YES4Trade\Model\products_content::get_by_content_id((int)xtc_db_input($_GET['coID']));
            $content = $contentObj->toArray();
        }
        $pcd_list = \YES4Trade\Model\products_content_description::get_by_content_id(intval($content['content_id']));
        $languages_array = array();
        $content_files_array = \YES4Trade\Model\products_content::get_distinct_content_file();
        $content_files = [];
        foreach($content_files_array as $cf){
            $content_files[] = ['id'=>$cf,'text'=>$cf];
        }
        // add default value to array
        $default_array = [['id' => 'default','text' => TEXT_SELECT]];
        $default_value='default';
        if(sizeOf($content_files)){
            $content_files = array_merge($default_array,$content_files);
        }else{
            $content_files = $default_array;
        }
        // mask for product content

        if ($_GET['action']!='new_products_content') {
            $inp_product = xtc_draw_hidden_field('product',$content['products_id']).$content['products_id'];
            $inp_lang = xtc_draw_hidden_field('language',$languages_selected).$languages_selected;
            $form = xtc_draw_form('edit_content',FILENAME_CONTENT_MANAGER,'mode=products_content&action=edit_products_content&id=update_product&coID='.$_GET['coID'].'&languages_id='.$language_id,'post','enctype="multipart/form-data"').xtc_draw_hidden_field('coID',$_GET['coID']);
        } else {
            $inp_product = xtc_draw_input_field('product',$content['products_id']);
            $inp_lang = xtc_draw_pull_down_menu('language',$languages_array,$languages_selected);
            $form = xtc_draw_form('edit_content',FILENAME_CONTENT_MANAGER,'mode=products_content&action=edit_products_content&id=insert_product&languages_id='.$language_id,'post','enctype="multipart/form-data"');
        }

        $lang_inputs = [];
        foreach($languages as $lang){
            foreach($pcd_list as $pcd){
                if($pcd->language_id == $lang['id']){
                    $pcd_val = $pcd->toArray();
                }
            }
            $lang_inputs[] = [
                'title'=>$lang['name'],
                'input_title'=>xtc_draw_input_field('cont_title['.$lang['id'].']',$pcd_val['content_name'],'size="60"'),
                'input_file_comment'=> xtc_draw_textarea_field('file_comment['.$lang['id'].']','virtual',80,35,$pcd_val['file_comment'],'class="tinymce"')
            ];
        }
        $smarty->assign([
            'FORM'=>$form,
            'TEXT_CONTENT_DESCRIPTION'=>TEXT_CONTENT_DESCRIPTION,
            'TEXT_PRODUCT'=>TEXT_PRODUCT,
            'INPUT_PRODUCT'=>$inp_product,
            'TEXT_LANGUAGE'=>TEXT_LANGUAGE,
            'LANGUAGES'=>$lang_inputs,
            'TEXT_TITLE_FILE'=>TEXT_TITLE_FILE,
//            'INPUT_TITLE'=>xtc_draw_input_field('cont_title',$content['content_name'],'size="60"'),
            'TEXT_LINK'=>TEXT_LINK,
            'INPUT_LINK'=>xtc_draw_input_field('cont_link',$content['content_link'],'size="60"'),
            'TEXT_FILE_DESC'=>TEXT_FILE_DESC,
//            'INPUT_FILE_COMMENT'=>$input_content,
            'TEXT_CHOOSE_FILE'=>TEXT_CHOOSE_FILE,
            'INPUT_CHOOSE_FILE'=>xtc_draw_pull_down_menu('select_file',$content_files,$default_value). ' ' .TEXT_CHOOSE_FILE_DESC,
            'TEXT_UPLOAD_FILE'=>TEXT_UPLOAD_FILE,
            'INPUT_FILE_UPLOAD'=>xtc_draw_file_field('file_upload').' '.TEXT_UPLOAD_FILE_LOCAL,
            'TEXT_FILENAME'=>TEXT_FILENAME,
            'INPUT_FILENAME'=>xtc_draw_hidden_field('file_name',$content['content_file']).'<b>'.xtc_image(DIR_WS_CATALOG.'admin/images/icons/icon'.strstr($content['content_file'],'.').'.gif').$content['content_file'].'</b>',
            'CONTENT_FILE'=>$content['content_file'],
            'WYSIWYG'=>xtc_wysiwyg(array()),
        ]);
        break;
    } // END OF SWITCH ACTION
} // END IF ACTION IS SET
$smarty->display('content_manager.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');