<?php
/*------------------------------------------------------------------------------

   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *

                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter

   ---------------------------------------------------------------------------*/
include('includes/cron_application_top.php');

if(FEEDBACK_REMINDER_ACTIVE != 'True'){
	die('Feedback Reminder nicht aktiv');
}

if( !defined('FEEDBACK_REMINDER_INTERVAL') or (int)FEEDBACK_REMINDER_INTERVAL < 1){
	mail('mario.aspeleiter@agri-consulting.de','Feedback Reminder Konfigurationsfehler','Die Konstante FEEDBACK_REMINDER_INTERVAL ist nicht gesetzt oder hat einen ungueltigen Wert. ('.FEEDBACK_REMINDER_INTERVAL.')'."\r\n".STORE_NAME);
	exit;
}

if( !defined('FEEDBACK_REMINDER_MAX_COUNTER') or (int)FEEDBACK_REMINDER_MAX_COUNTER < 1){
	mail('mario.aspeleiter@agri-consulting.de','Feedback Reminder Konfigurationsfehler','Die Konstante FEEDBACK_REMINDER_MAX_COUNTER ist nicht gesetzt oder hat einen ungueltigen Wert. ('.FEEDBACK_REMINDER_MAX_COUNTER.')'."\r\n".STORE_NAME);
	exit;
}

require("includes/classes/order.php");
require(DIR_FS_INC."xtc_get_site_country_id.inc.php");
require(DIR_FS_INC."xtc_is_language_installed.inc.php");
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');

$smarty = new yesSmarty;
$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');

$languages = xtc_get_languages();

$sites_lang = array();
function getLanguage($site,$languages){
	global $sites_lang;
	if(!$sites_lang[$site]){
		$cID = xtc_get_site_country_id($site);
		$lID = xtc_is_language_installed($cID);
		if(!$lID){
			$lID = '2';
		}
		for ($li = 0, $n = sizeof($languages); $li < $n; $li++) {
			if($languages[$li]['id'] == $lID)
				$sites_lang[$site] = $languages[$li]['directory'];
		}
	}
	return $sites_lang[$site];
}

$seller_array = array();
function getSellerData($seller){
	global $seller_array;
	if(!$seller_array[$seller]){
		$ebay_seller_query_raw = sprintf("SELECT store_name,email_address,bank,vat_id,store_name_wrap,bank_wrap FROM ebay_auth WHERE user='%s' and environment='%s'",$seller,((EBAY_TESTMODE == 1)?'sandbox':'production'));
		$ebay_seller_data_query = xtc_db_query($ebay_seller_query_raw);
		$ebay_seller_data = xtc_db_fetch_array($ebay_seller_data_query);
		$ebay_seller_data = xtc_db_prepare_input($ebay_seller_data);
		$seller_array[$seller] = $ebay_seller_data;
	}
	return $seller_array[$seller];
}


$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$smarty->assign(array(
    'logo_path'=>HTTP_SERVER  . 'templates/'.CURRENT_TEMPLATE.'/img/',
    'STORE_NAME_ADDRESS'=>STORE_NAME_ADDRESS
));

$next_action_days = 60*60*24*FEEDBACK_REMINDER_INTERVAL;

$records = array();
$feedback_reminder_query = xtc_db_query(sprintf("SELECT * FROM feedback_reminder WHERE UNIX_TIMESTAMP(last_action)+%s < UNIX_TIMESTAMP() and mailcounter < %s",$next_action_days,FEEDBACK_REMINDER_MAX_COUNTER));
while($row = xtc_db_fetch_array($feedback_reminder_query)){
	$records[] = $row;
}
if(!sizeOf($records)){
	die('Nothing to do.');
}

foreach($records as $feedback_reminder){
	$order = new order($feedback_reminder['orders_id']);

	$days_feedback_active = 60; // wie lange kann man bei ebay bewerten
	$diff = (time()-strtotime($order->info['date_purchased']))/60/60/24;

	// nicht versenden wenn sperre oder wenn kein bewerten mehr moeglich
	if($order->info['ebayfeedback_block_status'] == 0 and $diff < $days_feedback_active){
		$ebay_data = array('site'=>EBAY_SITE,'user'=>'','title'=>'');
		$ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($feedback_reminder['ebay_id'],[
			'title','site','user'
		]);
		if($ea !== null)
			$ebay_data = $ea->toArray();

		$ebay_transaction_query = yes_db_query(sprintf(
			"SELECT transactionid FROM ebay_transactions WHERE ebayid='%s' and orders_id='%s'",
			$feedback_reminder['ebay_id'],
			intval($feedback_reminder['orders_id'])
		),true);
		if(yes_db_num_rows($ebay_transaction_query)){
			$ebay_transaction = current($ebay_transaction_query);
		}
		$language = getLanguage($ebay_data['site'],$languages);

		if(!defined( 'FEEDBACK_REMINDER_SUBJECT_'.strtoupper($language) ) ) {
			require(DIR_FS_LANGUAGES.$language.'/admin/cron_feedback_reminder_sendmail.php');
		}
		$title = str_replace('{ebay_id}',$feedback_reminder['ebay_id'],constant('FEEDBACK_REMINDER_SUBJECT_'.strtoupper($language) ) );

		$smarty->assign('language', $language);
		$smarty->assign('title', $title);
		$smarty->assign('seller',$ebay_data['user']);
		$smarty->assign('orders_id',$feedback_reminder['orders_id']);
		$smarty->assign('ebay_id',$feedback_reminder['ebay_id']);
		$smarty->assign('auction_title',xtc_db_prepare_input($ebay_data['title']));
		$smarty->assign('feedback_link','http://feedback.ebay.de/ws/eBayISAPI.dll?LeaveFeedbackShow&useridfrom='.urlencode($feedback_reminder['ebay_user_id']).'&useridto='.urlencode($ebay_data['user']).'&item='.$feedback_reminder['ebay_id'].'&transactid='.$ebay_transaction['transactionid']);

		$ebay_seller_data = getSellerData($ebay_data['user']);

		$smarty->assign('STORE_NAME_ADDRESS',$ebay_seller_data['store_name_wrap']);
		$smarty->assign('STORE_NAME_ADDRESS_PLAIN',$ebay_seller_data['store_name']);
		$smarty->assign('customers_name',$order->customer['name']);
		$smarty->assign('customers_email_address',$order->customer['email_address']);
		$smarty->assign('customers_ebayuser',$feedback_reminder['ebay_user_id']);
		$html_mail = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/mail/'.$language.'/feedback_reminder.html');
		$txt_mail = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/mail/'.$language.'/feedback_reminder.txt');

		$order_subject=$title;
		// send mail to customer
		xtc_php_mail($ebay_seller_data['email_address'],
			$ebay_seller_data['store_name'],
			$order->customer['email_address'],
			$order->customer['name'],
			'',
			$ebay_seller_data['email_address'],
			$ebay_seller_data['store_name'],
			'',
			'',
			$order_subject,
			$html_mail,
			$txt_mail
		);
		
		\YES4Trade\Model\ebay_emails::create_ebay_emails([
			'subject'=>$order_subject,
			'mailto'=>$order->customer['email_address'],
			'from_name'=>$ebay_seller_data['store_name'],
			'from_email'=>$ebay_seller_data['email_address'],
			'date'=>date('Y-m-d H:i:s'),
			'ebay_id'=>$feedback_reminder['ebay_id'],
			'customers_id'=>intval($order->customer['ID']),
			'orders_id'=>intval($feedback_reminder['orders_id']),
			'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
			'saved'=>\YES4Trade\Model\ebay_emails::SAVED1,
			'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL1,
			'format'=>'text/html'
		], $html_mail);
		yes_query(
			"UPDATE feedback_reminder SET last_action=:last_action,mailcounter=mailcounter+1 WHERE feedback_reminder_id=:id",
			[
				'id'=>intval($feedback_reminder['feedback_reminder_id']),
				'last_action'=>date('Y-m-d H:i:s')
			]
		);
		$order->add_history($order->info['orders_status'],'1','Bewertungsreminder fuer Auktion '.$feedback_reminder['ebay_id']);
	}
}