<?php
/* --------------------------------------------------------------
   $Id: customers.php,v 1.177 2020/09/24 14:24:30 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(customers.php,v 1.76 2003/05/04); www.oscommerce.com
   (c) 2003	 nextcommerce (customers.php,v 1.22 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   --------------------------------------------------------------*/

require('includes/application_top.php');
require_once('includes/classes/order.php');
require_once('includes/classes/customer.php');
require_once('includes/classes/class.ebaymail.php');
$user_upload_filetypes = array('jpg','jpeg','png','gif','txt','pdf','bmp');

require_once('includes/classes/class.basics.php');
require_once('includes/classes/class.ebay.php');
require_once('includes/classes/class.csv.php');
require_once('includes/classes/reclamation.php');
require_once('includes/classes/retoure.php');
require_once('includes/classes/rueckerstattung.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid_status.inc.php');
require_once(DIR_FS_INC . 'yes_get_address_book_classes.inc.php');
require_once(DIR_FS_INC . 'yes_get_address_book_class_name.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid.inc.php');
require_once(DIR_FS_INC . 'xtc_get_geo_zone_code.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require_once(DIR_FS_INC.'xtc_get_auction_site.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'yes_customers_email_alias_functions.inc.php');
require_once(DIR_FS_INC . 'xtc_create_password.inc.php');

function draw_varchar_address_field($table,$name,$default_value,$err,$required = false){
    global $db_ini;
    $cur_size = 32;
    $db_field_len = yes_get_database_table_field_length($db_ini, $table, $name);
    if($db_field_len > -1){
        $cur_size = $db_field_len;
    }
    $cur_max_length = $cur_size;
    return xtc_draw_input_field($name,$default_value, sprintf('size="%s" maxlength="%s"',$cur_size,$cur_max_length),$required).$err;
}

// yes accounting  
$admin_access = main::get_admin_access();

$customers_statuses_array = xtc_get_customers_statuses();

if(isset($_REQUEST['query']) and !isset($_REQUEST['menugroup'])){
		$keywords = xtc_db_input($_REQUEST['query']);
		if(mb_detect_encoding($_REQUEST['query']) == 'UTF-8')
			$keywords = yes_decode_string($keywords);
		$cq_from_sql = sprintf("%s c",TABLE_CUSTOMERS);
		if(isset($_REQUEST['searchmode']) and $_REQUEST['searchmode'] == 'standard'){
		    $cq_from_sql .= ' LEFT JOIN customers_email_aliases cea USING(customers_id) ';
                }
                $cq_from_sql .= sprintf(", %s a" ,TABLE_ADDRESS_BOOK);
		if(isset($_REQUEST['searchmode']) and $_REQUEST['searchmode'] == 'standard'){
		    $search = "and (a.entry_company like '%" . $keywords . "%' or (cea.email_address like '%".$keywords."%') or c.customers_email_address like '%" . $keywords . "%' or c.customers_ebay_userid LIKE '%".$keywords."%')";
                }elseif(isset($_REQUEST['searchmode']) and $_REQUEST['searchmode'] == 'staff'){
		    $search = "and (LOWER(CONCAT(TRIM(c.customers_firstname), ' ',TRIM(c.customers_lastname))) like '%" . $keywords . "%') AND customers_status=0";
		}else{
		    $search = "and (LOWER(CONCAT(TRIM(c.customers_firstname), ' ',TRIM(c.customers_lastname))) like '%" . $keywords . "%')";
		}
                
                if(isset($_REQUEST['disallow_guest'])){
                    $search .= " and c.customers_status != '1'";
                }
		$cq_select_sql = "c.customers_id,CONCAT(c.customers_firstname,' ', c.customers_lastname) as name, a.entry_company,c.customers_email_address";
		$customers_query_raw = sprintf(
			"select %s
			 from %s 
			 WHERE a.customers_id=c.customers_id and c.customers_default_address_id = a.address_book_id %s
			 group by c.customers_id order by customers_id DESC LIMIT 50",
			$cq_select_sql,$cq_from_sql,$search
		);
		$query = yes_db_query($customers_query_raw);
		$datas = array();
		foreach($query as $record){
			if(!empty($record['name'])){
				$name = str_replace(array(':','{','}','[',']','"'),' ',$record['name']);
				$company = str_replace(array(':','{','}','[',']','"'),' ',$record['entry_company']);
				if(!empty($company)){
					$sugg = yes_encode_string($company.', '.$name).' (cID '.$record['customers_id'].')';
				}else{
					$sugg = yes_encode_string($name).' (cID '.$record['customers_id'].')';
				}
				if(strlen($sugg) > 42){
				    $sugg = substr($sugg,0,39).'...';
				}
				if(isset($_REQUEST['getemail'])){
					$datas[] = array(
					    'value'=>$record['customers_email_address'],
					    'label'=>$sugg
					);
				}else{
					$datas[] = array(
					    'value'=>$record['customers_id'],
					    'label'=>$sugg
					);
				}
			}
		}
		$response = json_encode($datas);
		echo $response;
		exit;
}

// ORDERS PAGING FUER CRM
if(isset($_REQUEST['orders_page'])){
    require_once(DIR_WS_CLASSES.'yes_shipping.php');
    $customers_id = (int)xtc_db_input($_REQUEST['cID']);
    $smarty = new yesSmarty;
    $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

	// RECHNUNGEN DES KUNDEN
	$max_items = 25;
	$orders_page = (isset($_REQUEST['orders_page'])) ? (int)xtc_db_input($_REQUEST['orders_page']) : 0;
	$orders_start = ($orders_page * $max_items);
	$orders_end = $orders_start+$max_items;
	$orders_query_raw = sprintf(
		"SELECT orders_id FROM %s WHERE customers_id='%s' ORDER BY date_purchased DESC",
		TABLE_ORDERS,xtc_db_prepare_input($customers_id)
	);
	$query = xtc_db_query($orders_query_raw);
	$total_items = xtc_db_num_rows($query);
	if(isset($_REQUEST['info']) and $_REQUEST['info'] == '1'){
	    $next_page = 0;
	    if($total_items > $orders_end){
		$next_page = 1;
	    }
	    if($orders_end > $total_items) $orders_end = $total_items;
	    die(json_encode(array(
		'items_num'=>$orders_end,
		'items_total'=>$total_items,
		'next_page'=>$next_page
	    )));
	}
	
	$orders_query_raw .= sprintf(" LIMIT %s, %s ",
		$orders_start,$max_items
	);
	$_orders = array();
	$orders_query = xtc_db_query($orders_query_raw);
	while($orders = xtc_db_fetch_array($orders_query)){
	    $_orders[] = $orders;
	}
	foreach($_orders as $orders){
		$oID = $orders['orders_id'];
		$order = new order($oID);
		$paydate = '';
		$products_date_available = $order->get_products_date_available();
		$orders_products_array = array();
		for($i=0;$i<count($order->products);$i++){
                    if( isset( $products_date_available[ $order->products[$i]['id'] ] ) ) {
                        $date_available = $products_date_available[ $order->products[$i]['id'] ];
                    }else{
                        $date_available = false;
                    }
                    $orders_products_array[] = array('QTY'=>$order->products[$i]['qty'],
                        'DATE_AVAILABLE'=>$date_available,
                        'PRODUCTS_NAME'=>$order->products[$i]['name'],
                        'PRODUCTS_PRICE'=>number_format($order->products[$i]['final_price'],2,',','.'),
                        'PRODUCTS_ID'=>$order->products[$i]['id'],
                        'PROPERTIES'=>$order->products[$i]['properties']
                    );
		}
		$ot = array();
		foreach($order->totals as $k=>$totaldata){
		    $ot[] = $totaldata;
		}
		$delivery = TEXT_SHIPPING_ADDRESS.':<br />';
		$delivery .= xtc_address_format($order->delivery['format_id'], $order->delivery, true,'',', ');
		$date_payment = '';
		if($order->info['date_payment'] != '0000-00-00 00:00:00' and DateTime::createFromFormat('Y-m-d H:i:s', $order->info['date_payment']) !== false){
                    $date_payment = yes_strftime('%d.%m.%y',strtotime($order->info['date_payment']));
		}

		$deliveries = array();
		$getship_query = xtc_db_query("SELECT id FROM shippings WHERE orders_id='".$oID."'");
		while($ship = xtc_db_fetch_array($getship_query)){
		    $ys = new yes_shipping( $ship['id'] );
		    $str = sprintf(TEXT_SHIPPED_WITH,$ys->getVersender(),xtc_date_short($ys->getDate_finished()));
		    if(sizeOf($ys->getTracking_id_array())){
			$str .= sprintf('&nbsp;%s:&nbsp;%s',TEXT_SHIPPING_TRACKING_IDS,implode(', ',$ys->getTracking_id_array()));
		    }
		    $deliveries[] = $str;
		}
		/*
		$getship_query = xtc_db_query("SELECT versender,DATE_FORMAT(date_finished,'%d.%m.%Y') as datum FROM shippings WHERE orders_id='".$oID."'");
		while( $getship = xtc_db_fetch_array($getship_query) ){
			$deliveries[] = sprintf(TEXT_SHIPPED_WITH,$getship['versender'],$getship['datum']);
		}
		*/
		$MAHN = '';	
		if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT){
			switch($order->info['warning_status']){
				case '0': $color = 'white'; $fcolor = 'black'; break;
				case '1': $color = 'yellow'; $fcolor = 'black'; $MAHN = TEXT_WARNING_STATUS1; break;
				case '2': $color = 'orange'; $fcolor = 'black'; $MAHN = TEXT_WARNING_STATUS2; break;
				case '3': $color = 'red'; $fcolor = 'white'; $MAHN = TEXT_WARNING_STATUS3; break;
			}
		}else{
			$color = 'white';
			$fcolor = 'red';
		}
		$select_str = '';
		if($order->info['select_set'] == '1' and $order->info['select_set_status'] == '0'){
			$select_str = '<br />'.xtc_image('images/icons/warning.gif',IMAGE_SELECT_SET_ERROR);
		}

		$combined_orders_id = '';
		if($order->info['combined_orders_id']>0){
			$combined_orders_id = '<br />[<a href="'.xtc_href_link('orders.php','action=edit&oID='.$order->info['combined_orders_id']).'" alt="'.TEXT_ORDER_COMBINED.'" title="'.TEXT_ORDER_COMBINED.'">K'.$order->info['combined_orders_id'].'</a>]';
		}
		$ebay_id = '';
		$auctions = $order->get_auction_array();
		if(sizeOf($auctions)){
			foreach($auctions as $auction){
				$ebay_id .= '<a target="_blank" href="'.xtc_get_ebay_link(xtc_get_auction_site($auction)).$auction.'">'.$auction.'</a> ';
			}
			$ebay_id .= $select_str;
		}
		$amazon_orders = $order->get_amazon_items();
		if(sizeOf($amazon_orders)){
			$double_oaid = array();
			foreach($amazon_orders as $ao){
			    if(!in_array($ao['orig_amazon_orders_id'], $double_oaid)){
				$ebay_id .= sprintf('<a target="_blank" href="https://sellercentral.amazon.de/orders-v3/order/%s">%s</a> ',
					$ao['orig_amazon_orders_id'],$ao['orig_amazon_orders_id']
				);	
				$double_oaid[] = $ao['orig_amazon_orders_id'];
			    }
			}
		}
		$orders_array[] = array('OID'=>'<a class="crm_orders_id" target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$oID).'" title="'.$MAHN.'" alt="'.$MAHN.'">'.$oID.'</a>',
		    'COMBINED_ORDERS_ID'=>$combined_orders_id,
                    'DATE_PURCHASED_TITLE'=>ENTRY_DATE_PURCHASED,
                    'DATE_PURCHASED'=>yes_strftime('%d.%m.%Y',strtotime( $order->info['date_purchased']) ).$paydate,
                    'LAST_MODIFIED_TITLE'=>ENTRY_LAST_MODIFIED,
                    'LAST_MODIFIED'=>($order->info['last_modified'] >0) ? yes_strftime('%d.%m.%Y',strtotime( $order->info['last_modified'])) : '',
			'DATE_PAYMENT_TITLE'=>ENTRY_EXPENSED,
			'DATE_PAYMENT'=>$date_payment,
		    'DELIVERIES'=>$deliveries,
			'SHIPPING_METHOD'=>$order->info['shipping_method'],
			'PAYMENT_METHOD'=>$order->info['payment_method'],
			'FINAL_PRICE'=>$total,
			'RUECKSTAND'=>(($order->info['rueckstand']==1 and !in_array($order->info['orders_status'],array(ORDERS_STATUS_VERSENDET,ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_STORNIERT))) ? 1 : 0),
			'EBAYID'=>$ebay_id,
			'ORDERS_STATUS_NAME'=>  xtc_get_orders_status_name($order->info['orders_status']),
			'ORDERS_STATUS_STORNIERT'=>($order->info['orders_status'] == ORDERS_STATUS_STORNIERT) ? 1 : 0,
			'products'=>$orders_products_array,
			'address'=>$delivery,
			'ORDERS_TOTAL'=>$ot
		);
	}
	$smarty->assign(array(
	    'ORDERS'=>$orders_array
	));
	$smarty->display('crm_order_listing_page.html');
	exit;
} // eof order paging

if (isset($_GET['special']) and $_GET['special'] == 'remove_memo') {
    $mID = (int)xtc_db_input($_GET['memoID']);
    $cm = \YES4Trade\Model\customers_memo::get_by_memo_id($mID);
    \YES4Trade\Model\customers_memo::delete($mID);
    yes_add_history(sprintf(HISTORY_MEMO_DELETED,
        $cm->memo_title,$cm->customers_id
    ));
    die(json_encode([
        'MSG'=>MEMO_DELETED,
        'ACK'=>1,
    ]));
}

if (isset($_GET['action']) and ($_GET['action'] == 'edit' || $_GET['action'] == 'update')) {
    if ($_GET['cID'] == 1 && $_SESSION['customer_id'] == 1)  {
    } else {
        if ($_GET['cID'] != 1)  {
            // yes accounting
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_customers_edit'] == '1')) {
            }else{
                $messageStack->add_session(MSG_AUTH_CUSTOMERS_EDIT,'error');
                xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action')).'action=crm'));
            }
        } else {
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS, ''));
        }
    }
    if($_GET['direct'] == '1'){
        $_CID = (int)xtc_db_input($_GET['cID']);
        if(!\YES4Trade\Model\customers::exists($_CID)){
            $messageStack->add_session(MSG_ERROR_UNKNOWN_CUSTOMERS_ID,'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
        }
    }
}

require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
$action = $_GET['action'] ?? '';
switch ($action) {
    case 'create_ebayuser_netto_copy':
        $cID = intval($_GET['cID']??0);
        $csID = intval($_GET['csID']??-1);
        $email = $_GET['email'];
        if($cID < 1 or $csID < 0 or !xtc_validate_email($email) ){
            die(json_encode([
                'MSG'=>'Error: Missing or invalid Parameters.'
            ]));
        }
        $mail_exists = \YES4Trade\Model\customers::email_exists(
            $email
        );
        if($mail_exists){
            die(json_encode([
                'MSG'=>'Error: Email Address '.$email.' exists.'
            ]));
        }

        $customer = \YES4Trade\Model\customers::get_by_customers_id($cID);
        $orig = $customer->toArray();
        $default_abID = intval($orig['customers_default_address_id']);

        unset($orig['customers_id']);
        $orig['customers_status'] = $csID;
        $orig['customers_email_address'] = $email;
        unset($orig['customers_default_address_id']);
        $orig['customers_password'] = xtc_create_password(12);
        $new_customer = new \YES4Trade\Model\customers($orig);
        $new_cID = $new_customer->create();
        
        $orig_ab_obj = \YES4Trade\Model\address_book::get_by_address_book_id($default_abID);
        $orig_ab = $orig_ab_obj->toArray();
        unset($orig_ab['address_book_id']);
        $orig_ab['customers_id'] = intval($new_cID);
        $orig_ab['address_date_added'] = date('Y-m-d H:i:s');
        $orig_ab['address_last_modified'] = '';
        $new_ab = new \YES4Trade\Model\address_book($orig_ab);
        $new_abID = $new_ab->create();
        
        $upd_customer = new \YES4Trade\Model\customers([
            'customers_id'=>intval($new_cID),
            'customers_default_address_id'=>intval($new_abID)
        ]);
        $upd_customer->update();
        $new_memo = new \YES4Trade\Model\customers_memo([
            'customers_id'=>intval($new_cID),
            'memo_date'=>date('Y-m-d'),
            'memo_title'=>'ebay netto copy',
            'memo_text'=>'copy of customer id '.$cID,
            'poster_id'=>intval($_SESSION['customer_id']),
        ]);
        $new_memo->create();

        $orig_memo = new \YES4Trade\Model\customers_memo([
            'customers_id'=>intval($cID),
            'memo_date'=>date('Y-m-d'),
            'memo_title'=>'ebay netto copy',
            'memo_text'=>'customer id '.$new_cID.' created as copy with email '.$email,
            'poster_id'=>intval($_SESSION['customer_id']),
        ]);
        $orig_memo->create();
        $messageStack->add_session('customer #'.$new_cID.' created (copy of '.$cID.') in: '.xtc_get_customers_status_name($csID),'success');
        die(json_encode([
            'MSG'=>'',
            'ID'=>intval($new_cID)
        ]));
        break;
    case 'address_book':
        include('customers.address_book.php');
        exit;
        break;
    case 'change_kasse_email_process':
        if(!isset($admin_access['change_kasse_email']) or $admin_access['change_kasse_email'] != 1){
            die('Missing auth');
        }
        if(!defined('KASSE_USER') or intval(KASSE_USER) < 1){
            die('Missing config KASSE_USER');
        }
        $email = xtc_db_input($_REQUEST['email_address']);
        if(!xtc_validate_email($email)){
            $messageStack->add_session(sprintf(MSG_ERROR_EMAIL_ADDRESS_INVALID,$email),'error');
            xtc_redirect(xtc_href_link(basename(__FILE__)));
        }

        $exists = \YES4Trade\Model\customers::email_exists($email);
        if($exists){
            $messageStack->add_session(ERROR_EMAIL_ALIAS_FORBIDDEN,'error');
            xtc_redirect(xtc_href_link(basename(__FILE__)));
        }
        $query = xtc_db_query(sprintf(
            "SELECT email_address FROM customers_email_aliases WHERE email_address='%s'",
            $email
        ));
        if(xtc_db_num_rows($query)){
            $messageStack->add_session(ERROR_EMAIL_ALIAS_FORBIDDEN,'error');
            xtc_redirect(xtc_href_link(basename(__FILE__)));
        }
        $update_sql_array = array(
            'customers_email_address'=>$email,
            'customers_id'=>intval(KASSE_USER),
        );
        $upd = new \YES4Trade\Model\customers($update_sql_array);
        $upd->update();
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>(int)KASSE_USER,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>'Kasse Email changed',
            'memo_text'=>'Kasse Email address changed to '.$email,
            'poster_id'=>(int)$_SESSION['customer_id']
        ]);
        $new->create();
        $messageStack->add_session(MSG_SUCCESS_KASSE_EMAIL_CHANGED,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'delete_address_book':
        $aID = (int)xtc_db_input($_GET['aID']);
        $cID = (int)xtc_db_input($_GET['cID']);
        $error = false;
        $customer = \YES4Trade\Model\customers::get_by_customers_id($cID);
        $default_ab_id = $customer->customers_default_address_id;
        if($default_ab_id == $aID){
            $error = true;
            $messageStack->add_session(MSG_ERROR_DELETE_ADDRESS_BOOK_ENTRY_DEFAULT,'error');
        }else{
            $items = \YES4Trade\Model\address_book::get_by_customers_id($cID);
            $addresses_num = sizeOf($items);
            if($addresses_num < 2){
                $error = true;
                $messageStack->add_session(MSG_ERROR_DELETE_ADDRESS_BOOK_ENTRY,'error');
            }
        }

        if(!$error){
            \YES4Trade\Model\address_book::delete($aID);
            $new = new \YES4Trade\Model\customers_memo([
                'customers_id' => $cID,
                'memo_date' => date("Y-m-d H:i:s"),
                'memo_title' =>HISTORY_MEMO_ADDRESS_BOOK_ENTRY_DELETE,
                'memo_text' => HISTORY_MEMO_ADDRESS_BOOK_ENTRY_DELETE,
                'poster_id' => (int)$_SESSION['customer_id']
            ]);
            $new->create();
            $messageStack->add_session(MSG_SUCCESS_DELETE_ADDRESS_BOOK_ENTRY,'success');
        }
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS, 'cID=' . $cID . '&action=edit'));
        break;
    case 'dsvgo_delete_process':
        require_once(DIR_FS_INC.'xtc_random_charcode.inc.php');
        $cID = (int)xtc_db_input($_GET['cID']);
        $update_sql_array = array(
            'customers_id'=>$cID,
            'customers_email_address'=>'DSGVO_'.time().'-'.EMAIL_SUPPORT_ADDRESS,
            'customers_password'=> xtc_random_charcode(16),
            'customers_cid'=>'XXX',
            'customers_vat_id'=>'XXX',
            'customers_firstname'=>'XXX',
            'customers_lastname'=>'XXX',
            'customers_dob'=>'0000-00-00',
            'customers_telephone'=>'XXX',
            'customers_fax'=>'XXX',
            'customers_newsletter'=>'n',
            'customers_newsletter_mode'=>'0',
            'customers_ebay_userid'=>'',
            'kto_nummer'=>'XXX',
            'kto_blz'=>'XXX',
            'kto_bank'=>'XXX',
            'kto_inhaber'=>'XXX',
            'kto_iban'=>'XXX',
            'kto_swift'=>'XXX',
            'mobile'=>'XXX',
            'customers_last_modified'=>date('Y-m-d H:i:s'),
            'hpsu_iban'=>'',
            'hpsu_bic'=>''
        );
        $upd = new \YES4Trade\Model\customers($update_sql_array);
        $upd->update();
        xtc_db_query(sprintf(
            "DELETE FROM customers_email_aliases WHERE customers_id='%d'",
            $cID
        ));
        xtc_db_query(sprintf(
            "DELETE FROM customers_basket WHERE customers_id='%d'",
            $cID
        ));
        xtc_db_query(sprintf(
            "DELETE FROM customers_basket_attributes WHERE customers_id='%d'",
            $cID
        ));
        xtc_db_query(sprintf(
            "DELETE FROM newsletter_recipients WHERE customers_id='%d'",
            $cID
        ));
        $items = \YES4Trade\Model\address_book::get_by_customers_id( (int)$cID );
        $abIDs = [];
        foreach($items as $it){
            $abIDs[] = $it->address_book_id;
        }
        foreach($abIDs as $abID){
            $upd = new \YES4Trade\Model\address_book([
                'address_book_id'=>(int)$abID,
                'entry_company'=>'XXX',
                'entry_firstname'=>'XXX',
                'entry_lastname'=>'XXX',
                'entry_street_address'=>'XXX',
                'entry_suburb'=>'XXX',
                'entry_postcode'=>'XXX',
                'entry_city'=>'XXX',
                'entry_state'=>'XXX',
                'entry_country_id'=>0,
                'entry_zone_id'=>0,
                'address_last_modified'=>date('Y-m-d H:i:s')
            ]);
            $upd->update();
        }
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>(int)$cID,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>MEMO_ADD_DSGVO_CLEAN,
            'memo_text'=>MEMO_ADD_DSGVO_CLEAN_INTRO,
            'poster_id'=>(int)$_SESSION['customer_id']
        ]);
        $new->create();
        $messageStack->add_session(MSG_SUCCESS_DSGVO_DELETE,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__),'action=edit&cID='.$cID));
        break;
    case 'dsvgo_delete':
        printf('<p>%s</p><input type="button" onclick="dsgvo_yes()" class="ui-button ui-corner-all ui-state-default" value="%s" /><input type="button" onclick="dsgvo_no()" class="ui-button ui-corner-all ui-state-error" value="%s" />',DSVGO_INTRO,YES,NO);
        exit;
        break;
    case 'duplicate_process':
        if(!sizeOf($_REQUEST['dup'])){
            $messageStack->add_session(MSG_ERROR_DUPLICATE_PROCESS_NO_DATA,'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
        }
        foreach($_REQUEST['dup'] as $email=>$cID){
            if(!xtc_validate_email($email)){
                $messageStack->add_session(sprintf(MSG_ERROR_DUPLICATE_PROCESS_INVALID_EMAIL,$email),'error');
                xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
            }
            $cID = (int)xtc_db_input($cID);
            $exists = \YES4Trade\Model\customers::customers_id_and_email_address_allocation_exists(
                $cID, $email
            );
            if($cID == KASSE_USER or !$exists){
                $messageStack->add_session(sprintf(MSG_ERROR_DUPLICATE_PROCESS_EMAIL_FORBIDDEN,$email),'error');
                xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
            }
        }
        require_once(DIR_WS_CLASSES.'reclamation.php');
        require_once(DIR_WS_CLASSES.'retoure.php');
        require_once(DIR_WS_CLASSES.'rueckerstattung.php');
        foreach($_REQUEST['dup'] as $email=>$cID){
            $new_cID = (int)xtc_db_input($cID);
            $target_customers = \YES4Trade\Model\customers::get_customers_email_duplicates( $new_cID, $email );
            foreach($target_customers as $tcID){
                $simple_alloc_tables = array(
                    TABLE_ORDERS=>'orders_id',
                    'reclamations'=>'reclamations_id',
                    'rueckerstattungen'=>'rueckerstattungs_id',
                    'retouren'=>'retoure_id'
                );
                foreach($simple_alloc_tables as $table=>$key){
                    $query = xtc_db_query(sprintf(
                        "SELECT %s FROM %s WHERE customers_id='%s'",
                        $key,$table
                    ));
                    $tc_items = array();
                    while($record = xtc_db_fetch_array($query)){
                        $tc_items[] = $record[$key];
                    }
                    foreach($tc_items as $id){
                        $update_sql_array = array(
                            'customers_id'=>$new_cID
                        );
                        xtc_db_perform($table,$update_sql_array,'update',"customers_id='".$tcID."' AND ".$key."='".$oID."'");
                        switch($table){
                            case TABLE_ORDERS:
                                $order = new order($id);
                                $order->add_history($order->info['orders_status'],false,sprintf(TEXT_DUPLICATE_PROCESS_ORDER_OWNER_CHANGE,$new_cID));
                                break;
                            case 'reclamations':
                                $rec = new reclamation($id);
                                $rec->add_history($rec->info['reclamations_status'], false, sprintf(TEXT_DUPLICATE_PROCESS_ORDER_OWNER_CHANGE,$new_cID));
                                break;
                            case 'rueckerstattungen':
                                $rueck = new rueckerstattung($id);
                                $rueck->add_history($rueck->info['status'], false, sprintf(TEXT_DUPLICATE_PROCESS_ORDER_OWNER_CHANGE,$new_cID));
                                break;
                            case 'retouren':
                                $ret = new retoure($id);
                                $ret->add_history($ret->info['retoure_status'], false, sprintf(TEXT_DUPLICATE_PROCESS_ORDER_OWNER_CHANGE,$new_cID));
                                break;
                        }
                    }
                }
                if($tcID > 0){
                    $new_tmail = 'DUPLICATE_'.$tcID.'@'.time().'.'.$new_cID;

                    \YES4Trade\Model\ebay_emails::change_customers_id(intval($tcID),intval($new_cID));

                    $update_sql_array = array(
                        'customers_id'=>intval($tcID),
                        'customers_email_address'=>$new_tmail
                    );
                    $upd = new \YES4Trade\Model\customers($update_sql_array);
                    $upd->update();
                    
                    $update_sql_array = array('customers_id'=>$new_cID);
                    xtc_db_perform('customers_basket',$update_sql_array,'update',"customers_id='".$tcID."'");

                    $update_sql_array = array('customers_id'=>$new_cID);
                    xtc_db_perform('shippings',$update_sql_array,'update',"customers_id='".$tcID."'");

                    $update_sql_array = array('customers_id'=>$new_cID);
                    xtc_db_perform('customers_basket_attributes',$update_sql_array,'update',"customers_id='".$tcID."'");

                    $simple_delete_tables = array(
                        'products_email_notifications',
                        'newsletter_recipients',
                        'products_notifications',
                        'products_questions',
                        'wishlist_attributes',
                        'wishlist_customers'
                    );
                    foreach($simple_delete_tables as $table){
                        xtc_db_query(sprintf(
                            "DELETE FROM %s WHERE customers_id='%s'",
                            $table,$tcID
                        ));
                    }
                        
                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id'=>(int)$tcID,
                        'memo_date'=>date('Y-m-d H:i:s'),
                        'memo_title'=>'Duplicate Account',
                        'memo_text'=>'Email set to '.$new_tmail.' orders transferred to cID '.$new_cID,
                        'poster_id'=>(int)$_SESSION['customer_id']
                    ]);
                    $new->create();
                }
            }
            $new = new \YES4Trade\Model\customers_memo([
                'customers_id'=>(int)$new_cID,
                'memo_date'=>date('Y-m-d H:i:s'),
                'memo_title'=>'Account Duplication',
                'memo_text'=>'Account merged from cID '.implode(',',$target_customers),
                'poster_id'=>(int)$_SESSION['customer_id']
            ]);
            $new->create();
        }
        $messageStack->add_session(sprintf(
            MSG_SUCCESS_DUPLICATE_PROCESS,sizeOf($_REQUEST['dup'])
        ),'success');
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
        break;
    case 'duplicates_view':
        $duplicates = \YES4Trade\Model\customers::get_email_duplicates();
        $duplicates_array = array();
        foreach($duplicates as $email){
            $customers_array = \YES4Trade\Model\customers::get_customers_id_array_by_email_address($email);
            foreach($customers_array as $custID){
                $cID = intval($custID);
                $customer = new customer($cID);
                $orders = array();
                $orders_query = xtc_db_query(sprintf(
                    "SELECT orders_id FROM %s WHERE customers_id='%d' AND orders_status != %s",
                    TABLE_ORDERS,$cID,ORDERS_STATUS_STORNIERT
                ));
                while($record = xtc_db_fetch_array($orders_query)){
                    $o = new order($record['orders_id']);
                    $title = $o->get_title($o->get_fibunumber(true));
                    $os_title = $o->get_source_title();
                    $orders[] = array(
                        'id'=>$o->info['id'],
                        'title'=>$title.' #'.$o->info['id'].' Status '.$o->info['orders_status_name'],
                        'date_purchased'=>xtc_date_short($o->info['date_purchased']),
                        'source'=>(!empty($os_title)) ? $os_title : 'unbekannt',
                        'products'=>$o->products,
                        'auctions'=>implode(',',$o->get_auction_array())
                    );
                }
                if(!isset($duplicates_array[ $email ])){
                    $duplicates_array[ $email ] = array();
                }
                $duplicates_array[ $email ][] = array(
                    'id'=>$cID,
                    'text'=>sprintf(DUPLICATE_PRODUCTS_SUMMARY,
                        $cID,
                        $customer->count_orders(),
                        number_format($customer->getAccount_value(),2,',','.')),
                    'orders'=>$orders
                );
                    
            }
        }
        $smarty = new yesSmarty;
        $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        $smarty->assign(array(
            'FORM'=>xtc_draw_form('duplicate_form',FILENAME_CUSTOMERS,'action=duplicate_process'),
            'DUPLICATES'=>$duplicates_array,
            'TEXT_CHECK_DUPLICATES_INTRO'=>TEXT_CHECK_DUPLICATES_INTRO,
            'TEXT_NO_SEARCH_RESULTS'=>TEXT_NO_SEARCH_RESULTS
        ));
        $smarty->display('customers_duplicates.tpl');
        break;
    case 'check_customers_email_allocation':
        $cID = (int)xtc_db_input($_REQUEST['cID']);
        $c = \YES4Trade\Model\customers::get_by_customers_id($cID);
        die(json_encode(array(
            'EMAIL'=>$c->customers_email_address
        )));
        break;
    case 'remove_email_alias':
        $cID = (int)xtc_db_input($_REQUEST['cID']);
        $email_address = xtc_db_input($_REQUEST['email_address']);
        $msg = '';
        if(!xtc_validate_email($email_address)){
            $msg = strip_tags(html_entity_decode(ENTRY_EMAIL_ADDRESS_CHECK_ERROR));
        }
        yes_remove_customers_email_alias($email_address);
        die(json_encode(array(
            'MSG'=>$msg
        )));
        break;
    case 'add_email_alias':
        $cID = (int)xtc_db_input($_REQUEST['cID']);
        $email_address = xtc_db_input($_REQUEST['email_address']);
        $allocate_existing_emails = (isset($_REQUEST['allocate_existing_emails']) and $_REQUEST['allocate_existing_emails'] == 1) ? true : false;
        $msg = '';
        if(!xtc_validate_email($email_address)){
            $msg = strip_tags(html_entity_decode(ENTRY_EMAIL_ADDRESS_CHECK_ERROR));
        }else{
            if(!yes_add_customers_email_alias($email_address,$cID,$_SESSION['customer_id'])){
                $msg = ERROR_EMAIL_ALIAS_FORBIDDEN;
            }else{
                if(intval($cID) > 0 and $allocate_existing_emails){
                    \YES4Trade\Model\ebay_emails::update_by_from_email([
                        'customers_id'=>intval($cID),
                        'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
                        'from_email'=>$email_address
                    ]);
                }
            }
        }
        die(json_encode(array(
            'MSG'=>$msg
        )));
        break;
    case 'insert_memo':
        $cID = (int)xtc_db_input($_REQUEST['cID']);
        if(!isset($_POST['memo_title'])){
            die(json_encode([
                'MSG'=>MSG_ERROR_INVALID_MEMO_TITLE,
                'ACK'=>0
            ]));
        }
        $memo_title = xtc_db_input($_POST['memo_title']);
        if(strlen($memo_title)<3){
            die(json_encode([
                'MSG'=>MSG_ERROR_INVALID_MEMO_TITLE,
                'ACK'=>0
            ]));
        }

        $memo_text = (isset($_POST['memo_text']))?xtc_db_input($_POST['memo_text']):'';
        $memo_text = str_replace("\\r\\n","\n",$memo_text);
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id' => (int)$cID,
            'memo_date' => date("Y-m-d H:i:s"),
            'memo_title' =>$memo_title,
            'memo_text' =>$memo_text,
            'poster_id' => (int) $_SESSION['customer_id']
        ]);
        $memoID = $new->create();
        $item = $new->toArray();
        $memo_text_cutted = (strlen($item['memo_text'])>50)?substr($item['memo_text'],0,50).'...':$item['memo_text'];
        $memo_text = sprintf(
            '<span title="%s">%s</span>',
            str_replace(["\n","\t",'"'],'', strip_tags($item['memo_text'])),
            $memo_text_cutted
        );
        $item['memo_id'] = $memoID;
        $item['memo_date'] = xtc_date_short($item['memo_date']);
        $item['memo_text'] = $memo_text;
        $item['poster'] = xtc_get_editor_name($_SESSION['customer_id']);
        die(json_encode([
            'MSG'=>MSG_SUCCESS_MEMO_ADDED,
            'ACK'=>1,
            'ITEM'=>$item
        ]));
        break;
    case 'memo':
        include(DIR_WS_MODULES . FILENAME_CUSTOMER_MEMO);
        break;
    case 'update_current_account_value':
        $cID = (int)xtc_db_input($_REQUEST['cID']);
        if($cID > 0){
            $customer = new customer($cID);
            $customer->update_current_account_value();
        }
        $messageStack->add_session(MSG_SUCCESS_UPDATE_CURRENT_ACCOUNT_VALUE,'success');
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action')).'action=crm'));
        break;
    case 'delete_userfile':
        $cID = (int)xtc_db_input($_REQUEST['cID']);
        $user_dir_name = yes_get_sha1_from_string("$cID");
        $basics = new basics;
        $user_dir = \main::get_importdata_path().'customers_files/'.$user_dir_name;
        if(is_file($user_dir.'/'.$_REQUEST['file'])){
            unlink($user_dir.'/'.xtc_db_input(str_replace('../','',$_REQUEST['file'])));
            $messageStack->add_session(sprintf(MSG_SUCCESS_USERFILE_DELETED,$_REQUEST['file']),'success');
        }
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>(int)$cID,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>'Upload File',
            'memo_text'=>'Delete User File "'.$_REQUEST['file'].'"',
            'poster_id'=>(int)$_SESSION['customer_id']
        ]);
        $new->create();
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action','file')).'action=edit'));
        break;
    case 'upload_userfile':
        $cID = (int)xtc_db_input($_REQUEST['cID']);
        $user_dir_name = yes_get_sha1_from_string("$cID");
        $basics = new basics;
        if(!is_dir(\main::get_importdata_path().'customers_files')){
            mkdir(\main::get_importdata_path().'customers_files');
        }
        $user_dir = \main::get_importdata_path().'customers_files/'.$user_dir_name;
        if(!is_dir($user_dir)){
            mkdir($user_dir);
        }
        $existing_files = $basics->get_directory_content($user_dir.'/');
        if(sizeOf($existing_files)){
            $max_int = 0;
            foreach($existing_files as $file){
                $last_int = (int)current(explode(".",$file));
                if($last_int > $max_int) 
                    $max_int = $last_int;
            }
            $new_int = $max_int+1;
            $nullen = 6-strlen("$new_int");
            $target_filename = '';
            for($i=0;$i<$nullen;$i++){
                $target_filename .= '0';
            }
            $target_filename .= "$new_int";
        }else{
            $target_filename = '000001';
        }
        //if(!in_array(,$existing_files))

        $upload = yes_try_upload('customer_file', $user_dir, '755', $user_upload_filetypes,$target_filename);
        if(is_object($upload)){
            $messageStack->add_session(MSG_SUCCESS_CUSTOMER_UPLOAD,'success');
            $new = new \YES4Trade\Model\customers_memo([
                'customers_id'=>(int)$cID,
                'memo_date'=>date('Y-m-d H:i:s'),
                'memo_title'=>'Upload File',
                'memo_text'=>'Uploaded "'.$_FILES['customer_file']['name'].'" as "'.$upload->file['name'].'"',
                'poster_id'=>(int)$_SESSION['customer_id']
            ]);
            $new->create();
        }
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action')).'action=edit'));  
        break;
    case 'crm_mail':
        break;
    case 'set_password':
        $password = xtc_db_prepare_input($_POST['new_password']);
        $confirmation = xtc_db_prepare_input($_POST['confirmation']);
        $cID = intval(xtc_db_input($_GET['cID']));
        if(strlen($password) < ENTRY_PASSWORD_MIN_LENGTH){
            $messageStack->add_session(sprintf(MSG_ERROR_PASSWORD_LENGTH,ENTRY_PASSWORD_MIN_LENGTH),'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action'))));
        }

        if($password != $confirmation){
            $messageStack->add_session(MSG_ERROR_PASSWORD_CONFIRM,'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action'))));
        }
        $update_sql_array = array(
            'customers_id'=>$cID,
            'customers_password'=>xtc_encrypt_password($password)
        );
        $upd = new \YES4Trade\Model\customers($update_sql_array);
        $upd->update();
        $messageStack->add_session(MSG_SUCCESS_NEW_PASSWORD,'success');
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action'))));
        break;
    case 'crm':
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_customers_crm'] == '1')) {
            if((int)$_GET['cID'] == (int)KASSE_USER){
                $messageStack->add_session(MSG_ERROR_CRM_KASSE,'error');
                xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
            }
        }else{
            $messageStack->add_session(MSG_AUTH_CRM,'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action'))));
        }
        break;
    case 'new_order':
    case 'new_offer':
        // yes accounting
        if($_GET['action'] == 'new_order'){
                $required_auth = 'f_customers_new_order';
        }else{
                $required_auth = 'f_offers';
        }
        $json = (isset($_GET['from_cart']) and $_GET['from_cart'] == '1') ? true : false;
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access[$required_auth] != '1')) {
            if($json){
                if(!stristr(CHARSET,'utf-8')){
                    $comments = utf8_encode(MSG_AUTH_NEW_ORDER);
                }
                die(json_encode(array(
                    'ERROR'=>$comments
                )));
            }
            $messageStack->add_session(MSG_AUTH_NEW_ORDER,'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action'))));
        }
        $customer = new customer(xtc_db_input($_GET['cID']),true);
        $orders_status = ($_GET['action'] == 'new_offer') ? ORDERS_STATUS_OFFER : 1;

        $orders_id = $customer->add_order($orders_status);
        if($_GET['action'] == 'new_offer'){
            $comments = HISTORY_NEW_OFFER;
        }else{
            $comments = HISTORY_NEW_ORDER;
        }
        $insert_sql_array = [
            'orders_id'=>$orders_id,
            'orders_status_id'=>1,
            'date_added'=>'now()',
            'customer_notified'=>0,
            'comments'=>$comments,
            'editor_id'=>$_SESSION['customer_id'],
        ];
        xtc_db_perform('orders_status_history',$insert_sql_array);
        if($json){
            die(json_encode(array(
                'ERROR'=>'',
                'MSG'=>$comments,
                'ORDERS_ID'=>$orders_id
            )));
        }
        $messageStack->add_session($comments,'success');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS, 'oID=' . $orders_id . '&action=edit'));
        break;
    case 'statusconfirm':
        $status = (int)xtc_db_input($_REQUEST['status']);
        $customers_id = intval(xtc_db_prepare_input($_GET['cID']));
        if($customers_id == 1 and intval($_SESSION['customer_id']) != 1){
            $messageStack->add_session(MSG_ERROR_SET_ADMIN_CS,'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
        }
        if($status == 1 and intval($_SESSION['customer_id']) != 1){
            $messageStack->add_session(MSG_ERROR_SET_CS_ADMIN,'error');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
        }
        $customer_updated = false;
        $customer = \YES4Trade\Model\customers::get_by_customers_id($customers_id);
        $check_status = $customer->toArray();
        if (intval($check_status['customers_status']) != $status) {
            $update_sql_array = [
                'customers_id'=>$customers_id,
                'customers_status'=>$status,
                'account_value_alert_notified'=>0
            ];
            $upd = new \YES4Trade\Model\customers($update_sql_array);
            $upd->update();
            $comments = sprintf(MSG_SUCCESS_STATUSCONFIRM,$check_status['customers_firstname'].' '.$check_status['customers_lastname'],xtc_get_customers_status_name($status));
            $messageStack->add_session($comments,'success');
            // create insert for admin access table if customers status is set to 0
            if ($_POST['status']==0) {
                xtc_db_query("INSERT into ".TABLE_ADMIN_ACCESS." (customers_id,start) VALUES ('".xtc_db_input($_GET['cID'])."','1')");
            } else {
                xtc_db_query("DELETE FROM ".TABLE_ADMIN_ACCESS." WHERE customers_id = '".xtc_db_input($_GET['cID'])."'");
            }
            //Temporarily set due to above commented lines
            $customer_notified = 0;
            $insert_sql_array = [
                'customers_id'=>$customers_id, 
                'new_value'=>$status, 
                'old_value'=>$check_status['customers_status'], 
                'date_added'=>'now()', 
                'customer_notified'=>$customer_notified
            ];
            xtc_db_perform(TABLE_CUSTOMERS_STATUS_HISTORY, $insert_sql_array);
            $customer_updated = true;
        }
        $key = 'admin_access';
        $InstanceCache->deleteItem($key); // admin_access
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
	break;
    case 'update':
        $customers_id = intval(xtc_db_prepare_input($_GET['cID']));
        $kto_nummer = xtc_db_prepare_input($_POST['kto_nummer']);
        $kto_blz = xtc_db_prepare_input($_POST['kto_blz']);
        $kto_bank = xtc_db_prepare_input($_POST['kto_bank']);
        $kto_inhaber = xtc_db_prepare_input($_POST['kto_inhaber']);
        $kto_iban = xtc_db_prepare_input($_POST['kto_iban']);
        $kto_swift = xtc_db_prepare_input($_POST['kto_swift']);
        $mobile = xtc_db_prepare_input($_POST['mobile']);
        $block_warnings = xtc_db_prepare_input($_POST['block_warnings']);
        $block_warning_span = xtc_db_prepare_input($_POST['block_dayspan']);
        $customers_cid = xtc_db_prepare_input($_POST['csID']);
        $customers_vat_id = xtc_db_prepare_input($_POST['customers_vat_id']);
        $customers_vat_id_status = (isset($_POST['customers_vat_id_status'])) ? (int)xtc_db_input($_POST['customers_vat_id_status']) : 0;
        $customers_firstname = xtc_db_prepare_input($_POST['customers_firstname']);
        $customers_lastname = xtc_db_prepare_input($_POST['customers_lastname']);
        $customers_email_address = xtc_db_prepare_input($_POST['customers_email_address']);
        $customers_telephone = xtc_db_prepare_input($_POST['customers_telephone']);
        $customers_fax = xtc_db_prepare_input($_POST['customers_fax']);
        $customers_newsletter = xtc_db_prepare_input($_POST['customers_newsletter']);
        
	    $customers_gender = xtc_db_prepare_input($_POST['customers_gender']);
        $customers_dob = xtc_db_prepare_input($_POST['customers_dob']);

        $customers_ebay_userid = (isset($_POST['customers_ebay_userid'])) ? xtc_db_prepare_input($_POST['customers_ebay_userid']) : '';
        $error = false; // reset error flag
        if (strlen($customers_firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
            $error = true;
            $entry_firstname_error = true;
        } else {
            $entry_firstname_error = false;
        }


        if (strlen($customers_lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
            $error = true;
            $entry_lastname_error = true;
        } else {
            $entry_lastname_error = false;
        }


        if (ACCOUNT_DOB == 'true') {
            if (DateTime::createFromFormat('Y-m-d', $customers_dob) !== false) {
                $entry_date_of_birth_error = false;
            } else {
                $error = true;
                $entry_date_of_birth_error = true;
            }
        }

// Vat Check
        if(xtc_get_geo_zone_code($entry_country_id) != '6'){
            if ($customers_vat_id !=''){
                if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {
                    $validate_vatid = validate_vatid($customers_vat_id);
                    if ($validate_vatid == '0') {
                        if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                            $entry_vat_error = true;
                            $error = true;
                        }
                        $customers_vat_id_status  = '0';
                    }
                    if($validate_vatid == '1') {
                        $customers_vat_id_status  = '1';
                    }

                    if($validate_vatid == '8'){
                        if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                            $entry_vat_error = true;
                            $error = true;
                        }
                        $customers_vat_id_status  = '8';
                    }

                    if($validate_vatid == '9'){
                        if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                            $entry_vat_error = true;
                            $error = true;
                        }
                        $customers_vat_id_status  = '9';
                    }
                }
            }
        }
        if (strlen($customers_email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
            $error = true;
            $entry_email_address_error = true;
        } else {
            $entry_email_address_error = false;
        }

        if (!xtc_validate_email($customers_email_address)) {
            $error = true;
            $entry_email_address_check_error = true;
        } else {
            $entry_email_address_check_error = false;
        }

        $entry_telephone_error = false;
        $mail_exists = false;
        if(!empty($customers_email_address)){
            $mail_exists = \YES4Trade\Model\customers::email_exists(
                $customers_email_address, $customers_id
            );
        }
        if ($mail_exists) {
            $error = true;
            $entry_email_address_exists = true;
        } else {
            $entry_email_address_exists = false;
        }
        if ($error == false) {
            $checkit_obj = \YES4Trade\Model\customers::get_by_customers_id($customers_id);
            $checkit = $checkit_obj->toArray();
            $orig_email_address = $checkit['customers_email_address'];
            $orig_customers_ebay_userid = $checkit['customers_ebay_userid'];
            if($orig_email_address != $customers_email_address){
                $new = new \YES4Trade\Model\customers_memo([
                    'customers_id' => $customers_id,
                    'memo_date' => date("Y-m-d H:i:s"),
                    'memo_title' =>HISTORY_MEMO_EMAIL_CHANGE_TITLE,
                    'memo_text' =>sprintf(HISTORY_MEMO_EMAIL_CHANGE_COMMENT,$orig_email_address,$customers_email_address),
                    'poster_id' => (int)$_SESSION['customer_id']
                ]);
                $new->create();

                \YES4Trade\Model\ebay_emails::change_mailto($orig_email_address, $customers_email_address);
                \YES4Trade\Model\ebay_emails::change_from_email($orig_email_address, $customers_email_address);
                
                // BOF - orders updaten - Ticket 1676
                $update_sql_array = array(
                    'customers_email_address'=>$customers_email_address
                );
                xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"customers_id='".$customers_id."'");
                // EOF - orders updaten
            }
            if($orig_customers_ebay_userid != $customers_ebay_userid){
                $new = new \YES4Trade\Model\customers_memo([
                    'customers_id' => (int)xtc_db_input($customers_id),
                    'memo_date' => date("Y-m-d H:i:s"),
                    'memo_title' =>HISTORY_MEMO_EBAY_USERID_CHANGE_TITLE,
                    'memo_text' =>sprintf(HISTORY_MEMO_EBAY_USERID_CHANGE_COMMENT,$orig_customers_ebay_userid,$customers_ebay_userid),
                    'poster_id' => (int)$_SESSION['customer_id']
                ]);
                $new->create();
            }
            if(intval($block_warnings) != intval($checkit['block_warnings'])){
                if($block_warnings == '1'){
                    if($block_warning_span and $block_warning_span != ''){
                        $comment = sprintf(HISTORY_MEMO_NO_WARN_SPAN,$block_warning_span);
                    }else{
                        $comment = HISTORY_MEMO_NO_WARN;
                    }
                    $memo_title = HISTORY_MEMO_NO_WARN_TITLE;
                    $memo_text = $comment;
                }else{
                    $memo_title = HISTORY_MEMO_WARN_TITLE;
                    $memo_text = HISTORY_MEMO_WARN;
                }
                $new = new \YES4Trade\Model\customers_memo([
                    'customers_id' => $customers_id,
                    'memo_date' => date("Y-m-d H:i:s"),
                    'memo_title' =>$memo_title,
                    'memo_text' =>$memo_text,
                    'poster_id' => (int)$_SESSION['customer_id']
                ]);
                $new->create();
            }

            $sql_data_array = array(
                'customers_firstname' => $customers_firstname,
                'customers_cid' => $customers_cid,
                'customers_vat_id' => $customers_vat_id,
                'customers_vat_id_status' => intval($customers_vat_id_status),
                'customers_lastname' => $customers_lastname,
                'customers_email_address' => $customers_email_address,
                'customers_telephone' => $customers_telephone,
                'customers_fax' => $customers_fax,
                'customers_newsletter' => $customers_newsletter,
                'mobile' => $mobile,
                'kto_nummer' => $kto_nummer,
                'kto_blz' => $kto_blz,
                'kto_bank' => $kto_bank,
                'kto_inhaber' => $kto_inhaber,
                'kto_iban' => $kto_iban,
                'block_warnings' => intval($block_warnings),
                'kto_swift' => $kto_swift,
                'customers_ebay_userid'=>$customers_ebay_userid
            );
		
            if (ACCOUNT_GENDER == 'true' or !empty($customers_gender)) {
                $sql_data_array['customers_gender'] = $customers_gender;
            }
            if (ACCOUNT_DOB == 'true') {
                $sql_data_array['customers_dob'] = $customers_dob;
            }
            if(intval($block_warnings) != intval($checkit['block_warnings'])){
                if(intval($block_warnings) == 1){
                    $sql_data_array['block_warnings_span'] = 1;
                    $sql_data_array['block_warnings_dayspan'] = intval($block_warning_span??0);
                    $sql_data_array['block_warnings_date'] = date('Y-m-d H:i:s');
                }else{
                    $sql_data_array['block_warnings_span'] = 0;
                    $sql_data_array['block_warning_span'] = 0;
                    $sql_data_array['block_warnings_date'] = '';
                }
            }
            $sql_data_array['customers_id'] = $customers_id;
            $upd = new \YES4Trade\Model\customers($sql_data_array);
            $upd->update();
            
            $upd = new \YES4Trade\Model\customers_info([
                'customers_info_date_account_last_modified' => date('Y-m-d H:i:s'),
                'customers_info_id'=>intval($customers_id)
            ]);
            $upd->update();

            // NEWSLETTER ABO ADDON
            // XTC SETZT HIER NUR IN DER CUSTOMERS-TABLE EIN FLAG
            // ABER KEINE EINTRAEGE IN DER TABELLE NEWSLETTER-RECIPIENTS

            // customers_status ermitteln
            $customers_status_id = $checkit['customers_status'];
	        
            // 1. Check ob Eintrag in newsletter_recipients
            // 2. Eintrag/Update newsletter recipients
            $sql_array = array(
                    'customers_email_address'=>$customers_email_address,
                    'customers_id'=>xtc_db_input($customers_id),
                    'customers_status'=>$customers_status_id,
                    'customers_firstname'=>$customers_firstname,
                    'customers_lastname'=>$customers_lastname,
                    'mail_status'=>$customers_newsletter
            );
            $check_nl_rec_query = xtc_db_query(sprintf(
                "SELECT mail_id,mail_status FROM newsletter_recipients WHERE customers_email_address='%s'",
                $customers_email_address
            ));
            if(xtc_db_num_rows($check_nl_rec_query)){
                $check_nl_rec = xtc_db_fetch_array($check_nl_rec_query);
                if($check_nl_rec['mail_status'] != $customers_newsletter){
                    $status_message = ($customers_newsletter > 0) ? TEXT_NEWSLETTER_STATUS_ACTIVE : TEXT_NEWSLETTER_STATUS_INACTIVE;
                    xtc_db_perform('newsletter_recipients',$sql_array,'update',sprintf("mail_id='%s'",$check_nl_rec['mail_id']) );
                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id' => (int)xtc_db_input($customers_id),
                        'memo_date' => date("Y-m-d H:i:s"),
                        'memo_title' =>HISTORY_MEMO_NEWSLETTER_TITLE,
                        'memo_text' =>sprintf(HISTORY_MEMO_NEWSLETTER,$status_message),
                        'poster_id' => (int)$_SESSION['customer_id']
                    ]);
                    $new->create();
                }
            }else{
                if($customers_newsletter > 0){
                    require_once(DIR_FS_INC.'xtc_random_charcode.inc.php');
                    $sql_array['date_added'] = 'now()';
                    $sql_array['mail_key'] = xtc_random_charcode(32);
                    xtc_db_perform('newsletter_recipients',$sql_array,'insert');

                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id' => (int)xtc_db_input($customers_id),
                        'memo_date' => date("Y-m-d H:i:s"),
                        'memo_title' =>HISTORY_MEMO_NEWSLETTER_TITLE,
                        'memo_text' =>sprintf(HISTORY_MEMO_NEWSLETTER,TEXT_NEWSLETTER_STATUS_ACTIVE),
                        'poster_id' => (int)$_SESSION['customer_id']
                    ]);
                    $new->create();
                }else{
                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id' => (int)xtc_db_input($customers_id),
                        'memo_date' => date("Y-m-d H:i:s"),
                        'memo_title' =>HISTORY_MEMO_NEWSLETTER_TITLE,
                        'memo_text' =>sprintf(HISTORY_MEMO_NEWSLETTER,TEXT_NEWSLETTER_STATUS_INACTIVE),
                        'poster_id' => (int)$_SESSION['customer_id']
                    ]);
                    $new->create();
                }
	    }
            $messageStack->add_session(sprintf(MSG_SUCCESS_CUSTOMER_UPDATED,$customers_firstname.' '.$customers_lastname),'success');
            xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS, xtc_get_all_get_params(array('cID', 'action')) . 'cID=' . $customers_id));
        } else {
            $cInfo = new objectInfo($_POST);
            $processed = true;
        }
        break;
    case 'deleteconfirm':
        $customers_id = intval(xtc_db_prepare_input($_GET['cID']));

        if ($_POST['delete_reviews'] == 'on') {
            $reviews_query = xtc_db_query(sprintf(
                "select reviews_id from %s where customers_id = '%d'",
                TABLE_REVIEWS,$customers_id
            ));
            while ($reviews = xtc_db_fetch_array($reviews_query)) {
                xtc_db_query(sprintf(
                    "delete from %s where reviews_id = '%d'",
                    TABLE_REVIEWS_DESCRIPTION,
                    $reviews['reviews_id']
                ));
            }
            xtc_db_query(sprintf(
                "delete from %s where customers_id = '%d'",
                TABLE_REVIEWS,$customers_id
            ));
        } else {
            $update_sql_array = [
                'customers_id' => null
            ];
            xtc_db_perform(TABLE_REVIEWS, $update_sql_array, 'update' ,"customers_id = '" . $customers_id . "'");
        }
        $items = \YES4Trade\Model\address_book::get_by_customers_id($customers_id);
        foreach($items as $it){
            \YES4Trade\Model\address_book::delete( (int)$it->address_book_id );
        }
        \YES4Trade\Model\customers::delete($customers_id); // loescht auch customers_info
        
        xtc_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . xtc_db_input($customers_id) . "'");
        xtc_db_query("delete from " . TABLE_CUSTOMERS_BASKET_ATTRIBUTES . " where customers_id = '" . xtc_db_input($customers_id) . "'");
        xtc_db_query("delete from " . TABLE_PRODUCTS_NOTIFICATIONS . " where customers_id = '" . xtc_db_input($customers_id) . "'");
        xtc_db_query("delete from " . TABLE_WHOS_ONLINE . " where customer_id = '" . xtc_db_input($customers_id) . "'");
        xtc_db_query("delete from " . TABLE_CUSTOMERS_STATUS_HISTORY . " where customers_id = '" . xtc_db_input($customers_id) . "'");
        xtc_db_query("delete from " . TABLE_CUSTOMERS_IP . " where customers_id = '" . xtc_db_input($customers_id) . "'");

        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS, xtc_get_all_get_params(array('cID', 'action'))));
        break;
}
if(empty($action) or $action != 'crm_mail'){
    yes_draw_pre_header();
?>    
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
}
if ($action == 'edit' or $action == 'update') {
?>
<script type="text/javascript"><!--
function check_form() {
  var error = 0;
  var error_message = "<?php echo JS_ERROR; ?>";

  var customers_firstname = document.customers.customers_firstname.value;
  var customers_lastname = document.customers.customers_lastname.value;
<?php if (ACCOUNT_DOB == 'true') echo 'var customers_dob = document.customers.customers_dob.value;' . "\n"; ?>
  var customers_email_address = document.customers.customers_email_address.value;
  var customers_telephone = document.customers.customers_telephone.value;

<?php if (ACCOUNT_GENDER == 'true') { ?>
  if (document.customers.customers_gender[0].checked || document.customers.customers_gender[1].checked) {
  } else {
    error_message = error_message + "<?php echo JS_GENDER; ?>";
    error = 1;
  }
  // address book
<?php } ?>

  if (customers_firstname.length < <?php echo ENTRY_FIRST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_FIRST_NAME; ?>";
    error = 1;
  }

  if (customers_lastname == "" || customers_lastname.length < <?php echo ENTRY_LAST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_LAST_NAME; ?>";
    error = 1;
  }

<?php if (ACCOUNT_DOB == 'true') { ?>
  if (customers_dob == "" || customers_dob.length < <?php echo ENTRY_DOB_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_DOB; ?>";
    error = 1;
  }
<?php } ?>

  if (customers_email_address == "" || customers_email_address.length < <?php echo ENTRY_EMAIL_ADDRESS_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_EMAIL_ADDRESS; ?>";
    error = 1;
  }


  if (error == 1) {
    alert(error_message);
    return false;
  } else {
    return true;
  }
}

//--></script>
<?php
}
?>
<script type="text/javascript">
<!--

<?php 
if(empty($action)){?>

var ONLOADFUNC = "";

<?php }else if($action == 'edit'){?>

// NOT ACTIVE
//var ONLOADFUNC = "ajax_onload_tab";
//var ONLOADFUNCPARAM = "info";
function dsgvo_yes(){
    window.location.href = '<?php echo xtc_href_link(basename(__FILE__),'action=dsvgo_delete_process&cID='.$_GET['cID']); ?>';
}
function dsgvo_no(){
    $('#modal_window').dialog('destroy');
}

<?php } ?>
	
//-->
</script>
<?php 
if(empty($action) or $action != 'crm_mail'){
    yes_draw_header(TITLE);
    yes_draw_quicknote($popup_link = false); 
?>

<table border="0" width="100%" cellspacing="0" cellpadding="0">

<?php
}
if ($action == 'edit' or $action == 'update') {
?>
    
    <tr>
	<td>
	
<?php
    $cID = (int)xtc_db_input($_GET['cID']);
    $customer = \YES4Trade\Model\customers::get_by_customers_id($cID);
    if($customer === null){
        $messageStack->add_session('Unknown cID '.$cID.'error');
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
    }
    $cInfo = new objectInfo($customer->toArray());
    $newsletter_array = array(
        array('id' => '1', 'text' => ENTRY_NEWSLETTER_YES), 
        array('id' => '0', 'text' => ENTRY_NEWSLETTER_NO)
    );
    $smarty = new yesSmarty;
    $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
    $add_title = '';
    if($customers_statuses_array[$customers['customers_status']]['csa_image'] != ''){
        $add_title .= xtc_image(DIR_WS_ICONS . $customers_statuses_array[$customers['customers_status']]['csa_image'], '').'&nbsp;&nbsp;';
    }
    foreach($customers_statuses_array as $cs){
        if( intval($cs['id']) == intval($customer->customers_status )) {
            $add_title .= '&nbsp;'.$cs['text'];
        }
    }
    if($cInfo->customers_ebay_userid != ''){
        $add_title .= '&nbsp;('.TEXT_EBAY_USERID.': '.$cInfo->customers_ebay_userid.')';
    }

    $buttons = array(
        array('text'=>ADD_QUICKNOTE,
            'link'=>"javascript:void(toggleBox('addquicknote'));",
            'lbOn'=>false,
            'auth'=>true
        ),
        array(
            'text'=>ADDRESS_BOOKS_HEADING_TITLE,
            'link'=>xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(['action']).'action=address_book'),
            'lbOn'=>false,
            'auth'=>true
        ),
        array('text'=>TEXT_EMAIL,
            'link'=>"javascript:void(window.open('".xtc_href_link('ebay_mail_frame.php', 'email=' . urlencode($cInfo->customers_email_address))."','_blank'));",
            'auth'=>true,
            'lbOn'=>false
        ),
        array('text'=>BUTTON_CRM,
            'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action')).'action=crm'),
            'auth'=>true,
            'lbOn'=>false
        ),
        array('text'=>BUTTON_ORDERS,
            'link'=>xtc_href_link('orders.php','cID='.$_GET['cID']),
            'lbOn'=>false,
            'auth'=>true
        )
    );
    $buttons[] = array('text'=>BUTTON_NEW_ORDER,
        'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action')).'action=new_order'),
        'lbOn'=>false,
        'auth'=>($admin_access['f_customers_new_order'] == '1') ? true : false,
        'error'=>($cInfo->customers_status == 1) ? ERROR_CUSTOMERS_STATUS_GUEST_NOT_ALLOWED_TO_CREATE_NEW_ORDER : false,
        'js_confirmation'=>true,
        'js_confirmation_text'=>BUTTON_NEW_ORDER.'?',
    );
    $buttons[] = array('text'=>BUTTON_NEW_OFFER,
        'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action')).'action=new_offer'),
        'auth'=>($admin_access['f_offers'] == '1') ? true : false,
        'lbOn'=>false,
        'error'=>($cInfo->customers_status == 1) ? ERROR_CUSTOMERS_STATUS_GUEST_NOT_ALLOWED_TO_CREATE_NEW_ORDER : false,
        'js_confirmation'=>true,
        'js_confirmation_text'=>BUTTON_NEW_OFFER.'?',
    );
	
    // BOF - MEMOS AUSLAGERN
    $anz = \YES4Trade\Model\customers_memo::count_by_customers_id((int)xtc_db_input($_GET['cID']));
    $buttons[] = array('text'=>sprintf(BUTTON_MEMO_COUNT,$anz),
        'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action','last_action')).'action=memo&last_action='.$_REQUEST['action']),
        'auth'=>true,
        'lbOn'=>true
    );

    // EOF - MEMOS AUSLAGERN	
    $buttons[] = array('text'=>DSVGO_BUTTON,
        'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action','last_action')).'action=dsvgo_delete&last_action='.$_REQUEST['action']),
        'auth'=>true,
        'add_css_class'=>'ui-state-error',
        'lbOn'=>true
    );

    $smarty->assign(array(
        'HEADING_TITLE'=>sprintf(HEADING_TITLE_CUSTOMERS_EDIT,$_GET['cID'],$cInfo->customers_lastname.', '.$cInfo->customers_firstname),
        'ADDITIONAL_HEADING_TITLE'=>$add_title,
        'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
        'RIGHT_CONTENT'=>$right_content,
        'TEXT_ALLOCATE_EXISTING_EMAILS'=>TEXT_ALLOCATE_EXISTING_EMAILS
    ));
	
    $smarty->assign('CUSTOMER_DETAILS',$customers);
    $smarty->assign('QUICKNOTEADD_LINK_TITLE',QUICKNOTEADD_LINK_TITLE);
    $smarty->assign('HEADING_TITLE_STATUS',HEADING_TITLE_STATUS);
    $smarty->assign('CUSTOMERS_STATUS_NAME',$customers_statuses_array[$customers['customers_status']]['text']);
    $smarty->assign('FORM_END','</form>');

    $smarty->assign('TEXT_DEFAULT_ADDRESS_BOOK',TEXT_DEFAULT_ADDRESS_BOOK);
    $smarty->assign('CUSTOMERS_FORM',xtc_draw_form('customers', FILENAME_CUSTOMERS, xtc_get_all_get_params(array('action')) . 'action=update', 'post', 'onSubmit="return check_form();"') . xtc_draw_hidden_field('default_address_id', $cInfo->customers_default_address_id));
    $smarty->assign('CATEGORY_PERSONAL',CATEGORY_PERSONAL);
    $smarty->assign('ACCOUNT_GENDER',ACCOUNT_GENDER);

    if(ACCOUNT_GENDER == 'true'){
        $smarty->assign('ENTRY_GENDER',ENTRY_GENDER);
        if ($error == true) {
            if ($entry_gender_error == true) {
                $input =  xtc_draw_radio_field('customers_gender', 'm', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_gender', 'f', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . FEMALE . '&nbsp;' . ENTRY_GENDER_ERROR;
            } else {
                $input = ($cInfo->customers_gender == 'm') ? MALE : FEMALE;
                $input .= xtc_draw_hidden_field('customers_gender');
            }
        } else {
            $input = xtc_draw_radio_field('customers_gender', 'm', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_gender', 'f', false, $cInfo->customers_gender) . '&nbsp;&nbsp;' . FEMALE;
        }
        $smarty->assign('INPUT_GENDER',$input);
    }

    $smarty->assign('ENTRY_CID',ENTRY_CID);
    $smarty->assign('INPUT_CID',xtc_draw_input_field('csID', $cInfo->customers_cid, 'maxlength="32"', false));
    $smarty->assign('ENTRY_FIRST_NAME',ENTRY_FIRST_NAME);

    $db_ini = yes_get_database_table_ini();
    $err = ($entry_firstname_error === true) ? '&nbsp;' . ENTRY_FIRST_NAME_ERROR : '';
    $smarty->assign('INPUT_FIRST_NAME',draw_varchar_address_field(TABLE_CUSTOMERS,'customers_firstname',$cInfo->customers_firstname,$err));

    $err = ($error and $entry_lastname_error) ? '&nbsp;' . ENTRY_LAST_NAME_ERROR : '';
    $smarty->assign('ENTRY_LAST_NAME',ENTRY_LAST_NAME);
    $smarty->assign('INPUT_LAST_NAME',draw_varchar_address_field(TABLE_CUSTOMERS,'customers_lastname',$cInfo->customers_lastname,$err,true));

    if ($error == true) {
        if ($entry_lastname_error !== true) {
            $smarty->assign('INPUT_LAST_NAME',$cInfo->customers_lastname . xtc_draw_hidden_field('customers_lastname'));
        }
    }

    $smarty->assign('ACCOUNT_DOB',ACCOUNT_DOB);
    if(ACCOUNT_DOB == 'true'){
        $smarty->assign('ENTRY_DATE_OF_BIRTH',ENTRY_DATE_OF_BIRTH);
        $dob_default = (!empty($cInfo->customers_dob) and $cInfo->customers_dob != '0000-00-00 00:00:00')?date('Y-m-d',strtotime($cInfo->customers_dob)):date('Y-m-d');
        if ($error == true) {
            if ($entry_date_of_birth_error == true) {
                $input = xtc_draw_input_field('customers_dob', $dob_default, 'maxlength="10"',true,'date') . '&nbsp;' . ENTRY_DATE_OF_BIRTH_ERROR;
            } else {
                $input = $cInfo->customers_dob . xtc_draw_hidden_field('customers_dob');
            }
        } else {
            $input = xtc_draw_input_field('customers_dob', $dob_default, 'maxlength="10"', true,'date');
        }
        $smarty->assign('INPUT_DOB',$input);
    }

    $smarty->assign('ENTRY_EMAIL_ADDRESS',ENTRY_EMAIL_ADDRESS);
    $err = '';
    if ($error == true) {
        if ($entry_email_address_error == true) {
            $err = '&nbsp;' . ENTRY_EMAIL_ADDRESS_ERROR;
        } elseif ($entry_email_address_check_error == true) {
            $err = '&nbsp;' . ENTRY_EMAIL_ADDRESS_CHECK_ERROR;
        } elseif ($entry_email_address_exists == true) {
            $err = '&nbsp;' . ENTRY_EMAIL_ADDRESS_ERROR_EXISTS;
        }
    }
    $smarty->assign('INPUT_EMAIL_ADDRESS',draw_varchar_address_field(TABLE_CUSTOMERS,'customers_email_address',$cInfo->customers_email_address,$err,true));

    if ($error == true and $err === '') {
        $smarty->assign('INPUT_EMAIL_ADDRESS',$customers_email_address . xtc_draw_hidden_field('customers_email_address'));
    }

    $smarty->assign('ENTRY_VAT_ID',ENTRY_VAT_ID);
    $err = ($error && $entry_vat_error) ? '&nbsp;' . ENTRY_VAT_ID_ERROR : '';
    if ($error == true && !$entry_vat_error) {
        $smarty->assign('INPUT_VAT_ID',$cInfo->customers_vat_id . xtc_draw_hidden_field('customers_vat_id'));
    }else{
        $smarty->assign('INPUT_VAT_ID',draw_varchar_address_field(TABLE_CUSTOMERS,'customers_vat_id',$cInfo->customers_vat_id,$err,false));
    }
        
    $err = '';
    $smarty->assign('INPUT_CUSTOMERS_EBAY_USERID',draw_varchar_address_field(TABLE_CUSTOMERS,'customers_ebay_userid',$cInfo->customers_ebay_userid,$err,false));

    $smarty->assign('CATEGORY_CONTACT',CATEGORY_CONTACT);
    $smarty->assign('ENTRY_TELEPHONE_NUMBER',ENTRY_TELEPHONE_NUMBER);

    $err = ($entry_telephone_error == true) ? '&nbsp;' . ENTRY_TELEPHONE_NUMBER_ERROR : '';
    $smarty->assign('INPUT_TELEPHONE_NUMBER',draw_varchar_address_field(TABLE_CUSTOMERS,'customers_telephone',$cInfo->customers_telephone,$err,false));
    if ($error == true) {
        if ($entry_telephone_error != true) {
            $smarty->assign('INPUT_TELEPHONE_NUMBER',$cInfo->customers_telephone . xtc_draw_hidden_field('customers_telephone'));
        }
    }

    $smarty->assign('ENTRY_MOBILE',ENTRY_MOBILE);
    $smarty->assign('INPUT_MOBILE',draw_varchar_address_field(TABLE_CUSTOMERS,'mobile',$cInfo->mobile,'',false));

    $smarty->assign('ENTRY_FAX_NUMBER',ENTRY_FAX_NUMBER);
    if ($processed == true) {
        $smarty->assign('INPUT_FAX_NUMBER',$cInfo->customers_fax . xtc_draw_hidden_field('customers_fax'));
    } else {
        $smarty->assign('INPUT_FAX_NUMBER',draw_varchar_address_field(TABLE_CUSTOMERS,'customers_fax',$cInfo->customers_fax,'',false));
    }

    $smarty->assign('TEXT_BANKDATA',TEXT_BANKDATA);
    $smarty->assign('INPUT_KTO_NUMMER',draw_varchar_address_field(TABLE_CUSTOMERS,'kto_nummer',$cInfo->kto_nummer,'',false));
    $smarty->assign('INPUT_KTO_BANK',draw_varchar_address_field(TABLE_CUSTOMERS,'kto_bank',$cInfo->kto_bank,'',false));
    $smarty->assign('INPUT_KTO_INHABER',draw_varchar_address_field(TABLE_CUSTOMERS,'kto_inhaber',$cInfo->kto_inhaber,'',false));
    $smarty->assign('INPUT_KTO_BLZ',draw_varchar_address_field(TABLE_CUSTOMERS,'kto_blz',$cInfo->kto_blz,'',false));
    $smarty->assign('INPUT_KTO_IBAN',draw_varchar_address_field(TABLE_CUSTOMERS,'kto_iban',$cInfo->kto_iban,'',false));
    $smarty->assign('INPUT_KTO_SWIFT',draw_varchar_address_field(TABLE_CUSTOMERS,'kto_swift',$cInfo->kto_swift,'',false));
    $smarty->assign('CATEGORY_OPTIONS',CATEGORY_OPTIONS);
    $smarty->assign('TEXT_WARNINGMODE',TEXT_WARNINGMODE);
    if(($_POST['block_warnings']) and $_POST['block_warnings']!=''){
        $block_warning = $_POST['block_warnings'];
    }else{
        $block_warning = $cInfo->block_warnings;
    }
    $smarty->assign('BLOCK_WARNING',$block_warning);
    $smarty->assign('INPUT_WARNING1',xtc_draw_radio_field('block_warnings','0',(($block_warning==0)?true:false)).' '.TEXT_WARNINGMODE_OFF);
    $smarty->assign('INPUT_WARNING2',xtc_draw_radio_field('block_warnings','1',(($block_warning==1)?true:false)).' '.TEXT_WARNINGMODE_ON);
    if($block_warning==0){
        $dayspan_array = array();
        $dayspan_array[0] = array('id'=>'','text'=>'Dauerhaft sperren');
        for($ds=1;$ds<31;$ds++){
            $dayspan_array[] = array('id'=>$ds,'text'=>$ds.' Tage');
        }
        $smarty->assign('INPUT_BLOCK_DAYSPAN', xtc_draw_pull_down_menu('block_dayspan',$dayspan_array,(($cInfo->block_warnings_span==1)?$cInfo->block_warnings_dayspan:'')));
    }else{
        if($cInfo->block_warnings_dayspan > 0){
            $smarty->assign('TEXT_BLOCK_DAYSPAN',sprintf(TEXT_BLOCK_DAYSPAN,xtc_date_short($cInfo->block_warnings_date),$cInfo->block_warnings_dayspan));
        }
    }
    $smarty->assign('ENTRY_NEWSLETTER',ENTRY_NEWSLETTER);


    if ($processed == true) {
        if ($cInfo->customers_newsletter == '1') {
            $nl_default = ENTRY_NEWSLETTER_YES;
        } else {
            $nl_default = ENTRY_NEWSLETTER_NO;
        }
        $input .= xtc_draw_hidden_field('customers_newsletter',$nl_default);
    } else {
        $input = xtc_draw_pull_down_menu('customers_newsletter', $newsletter_array, (int)$cInfo->customers_newsletter);
    }
    $smarty->assign('INPUT_NEWSLETTER',$input);
    $smarty->assign('FORM_CANCEL_LINK',xtc_href_link(FILENAME_CUSTOMERS, xtc_get_all_get_params(array('action'))));
    $smarty->assign('FORM_PASSWORD',xtc_draw_form('newpassword',"customers.php","action=set_password&cID=".$_GET['cID']));
    $smarty->assign('TEXT_NEW_PASSWORD',TEXT_NEW_PASSWORD);
    $smarty->assign('TEXT_NEW_PASSWORD_INTRO',TEXT_NEW_PASSWORD_INTRO);
    $smarty->assign('ENTRY_NEW_PASSWORD',ENTRY_NEW_PASSWORD);
    $smarty->assign('INPUT_NEW_PASSWORD',xtc_draw_input_field('new_password',''));
    $smarty->assign('ENTRY_CONFIRM_PASSWORD',ENTRY_CONFIRM_PASSWORD);
    $smarty->assign('INPUT_CONFIRM_PASSWORD',xtc_draw_input_field('confirmation',''));
    $cID = xtc_db_input($_REQUEST['cID']);
    $user_dir_name = yes_get_sha1_from_string("$cID");
    $basics = new basics;
    $uploaded_files = array();
    $user_dir = '';
    if(is_dir(\main::get_importdata_path().'customers_files')){
        $user_dir = \main::get_importdata_path().'customers_files/'.$user_dir_name;
        if(is_dir($user_dir)){
            $uploaded_files = $basics->get_directory_content($user_dir.'/');
            sort($uploaded_files);
            $uploaded_files = array_reverse($uploaded_files);
            $_uploaded_files = $uploaded_files;
            $uploaded_files = array();
            foreach($_uploaded_files as $file){
                $image = false;
                if(stristr($file,'gif') or stristr($file,'jpg') or stristr($file,'jpeg') or stristr($file,'png') or stristr($file,'bmp')){
                    $image = true;
                }
                $size = xtc_round($basics->convert_filesize(filesize($user_dir.'/'.$file)),2);
                $uploaded_files[] = array(
                    'name'=>$file,
                    'image'=>$image,
                    'size' => $size.' MB'
                );
            }
        }
    }
	
    // BOF - EMAIL ALIASES
    $smarty->assign(array(
        'EMAIL_ALIASES' =>  yes_get_customers_email_aliases((int)xtc_db_input($_GET['cID'])),
        'EMAIL_ALIASES_ADD_LINK' => xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=add_email_alias'),
        'EMAIL_ALIASES_REMOVE_LINK' => xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=remove_email_alias'),
        'TEXT_EMAIL_ALIASES'=>TEXT_EMAIL_ALIASES,
        'TEXT_ADD_EMAIL_ALIAS'=>TEXT_ADD_EMAIL_ALIAS
    ));
    // EOF - EMAIL ALIASES
	
    $smarty->assign(array(
        'FORM_PASSWORD_SUBMIT'=>yes_draw_href_button(IMAGE_UPDATE,'','width:130px;','submit'),
        'TEXT_CUSTOMERS_FILES'=>TEXT_CUSTOMERS_FILES,
        'TEXT_UPLOAD'=>IMAGE_UPLOAD,
        'FORM_UPLOAD'=>xtc_draw_form('uploadform',"customers.php","action=upload_userfile&cID=".(int)xtc_db_input($_GET['cID']),'post','enctype="multipart/form-data"'),
        'FILETYPES'=>implode(', ',$user_upload_filetypes),
        'UPLOADED_FILES'=>$uploaded_files,
        'UPLOAD_FILE_PATH'=>$user_dir,
        'UPLOAD_DELETE_LINK'=>xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action','file')).'action=delete_userfile'),
        'REALLY_DELETE_FILE'=>JS_CONFIRM_REALLY_DELETE_FILE,
        'CUSTOMERS_EBAY_USERID'=>CUSTOMERS_EBAY_USERID
    ));
    $smarty->display('customers_edit.html');
	
	
	
// ENDE EDIT	

	
	

} else if($action == 'crm') {
    $customers_id = (int)xtc_db_input($_GET['cID']);
    include('includes/crm.php');
    echo $crm_html;
} else if($action == 'crm_mail') {
    $smarty = new yesSmarty;
    $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
    $smarty->assign('no_yes_links',1);
    $crmID = (int)xtc_db_input($_REQUEST['cID']);
    if(\YES4Trade\Model\customers::exists($crmID)){
        $cust = \YES4Trade\Model\customers::get_by_customers_id($crmID);
        if($cust->customers_default_address_id > 0){
            $ab = \YES4Trade\Model\address_book::get_by_address_book_id((int)$cust->customers_default_address_id);
        }else{
            $ab = \YES4Trade\Model\address_book::get_by_customers_id($crmID)[0];
        }
        $customers = xtc_array_merge($cust->toArray(), $ab->toArray());
        $cInfo = new objectInfo($customers);
        echo '<link rel="stylesheet" href="'.HTTP_SERVER.'admin/includes/stylesheet.css.php"></link>';
        include('includes/crm_mail.php');
    }else{
        $crmID = false;
    }
    exit;
} else {
    include('customers_listing.php');
}
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
