<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'context_menu.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');
require_once(DIR_FS_INC . 'changedataout.inc.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC.'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
require(DIR_WS_CLASSES.'qqUploadedFileXhr.php');
if(!function_exists('yes_get_sha1_from_string')){
    require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
}

// yes accounting  
$admin_access = main::get_admin_access();

// yes accounting
if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['distributor_orders'] == '1')) {
}else{
	$messageStack->add_session(MSG_ERROR_NOT_AUTHORIZED_FOR_DISTRIBUTOR_ORDERS,'error');
	xtc_redirect(xtc_href_link('index.php',xtc_get_all_get_params(array('action'))));
}
  
// initiate template engine for mail
$smarty = new yesSmarty;
// dont allow cache
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->assign('FORM_END','</form>');

require(DIR_WS_CLASSES . 'currencies.php');
require(DIR_WS_CLASSES . 'distributor_order.php');
require(DIR_WS_CLASSES . 'distributor.php');

$currencies = new currencies();

$orders_statuses = array();
$orders_status_array = array();
$items = \YES4Trade\Model\distributor_orders_status::get_by_language_id((int)$_SESSION['languages_id']);
foreach($items as $it){
    $orders_statuses[] = array(
        'id' => $it->orders_status_id,
	'text' => $it->orders_status_name
    );
    $orders_status_array[$it->orders_status_id] = $it->orders_status_name;
}
if(isset($_REQUEST['action'])){
    switch($_REQUEST['action']){
    case 'ajax_address_save':	    
            $doID = (int)xtc_db_input($_REQUEST['doID']);
            $json_array = array();
            $address_str = array();
            $do = new distributor_order($doID);
            $prefix = $do->get_update_address_part_prefix($_REQUEST['address_type']);
            foreach($_REQUEST as $key=>$val){
                    if(!strstr($key,$prefix) or $key == 'update_customers_name'){
                            continue;
                    }
                    $address_str[] = xtc_db_prepare_input(yes_decode_string($key.': '.$val));
            }
            $address_str = implode(',',$address_str);

            $update_sql_array = $do->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'',false);

            $do->update_address_part($update_sql_array);
            $json_array = $update_sql_array;
            if(isset($_REQUEST['copy_distributor']) and $_REQUEST['copy_distributor'] == 1){
                    $update_sql_array = $do->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'distributor');
                    $do->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }

            if(isset($_REQUEST['copy_shipping']) and $_REQUEST['copy_shipping'] == 1){
                    $update_sql_array = $do->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'shipping');
                    $do->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }


            $json = array();
            foreach($json_array as $k=>$v){
                    $json[$k]=xtc_db_prepare_input(yes_encode_string($v));
            }
            $do->insert_history($do->info['orders_status'], false, sprintf(HISTORY_ADDRESS_CHANGE,$_REQUEST['address_type'],$address_str));
            header('Content-Type: text/html; charset='.CHARSET);
            die(json_encode(array(
              'UPDATE_ARRAY'=>$json,
                'ADDRESS_TYPE'=>$_REQUEST['address_type'],
                'COPY_SHIPPING'=>(isset($_REQUEST['copy_shipping']) and $_REQUEST['copy_shipping'] == 1) ? 1 : 0,
                'COPY_DISTRIBUTOR'=>(isset($_REQUEST['copy_distributor']) and $_REQUEST['copy_distributor'] == 1) ? 1 : 0,
            )));
            exit;
            break;
        case 'ajax_address_edit':
            require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
            $do = new distributor_order((int)xtc_db_input($_REQUEST['doID']));
?>
<style type="text/css">
    .oe_addresses {
	width: 100%;
    }    
    .oe_addresses .oe_address {
	width: 32%;
	float: left;
	margin:2px;
	display: inline-block;
    }    
   
</style>
<script type="text/javascript">
$().ready(function(){
    var doa_fields = new Array(
          'delivery_company',
          'delivery_name',
          'delivery_street_address',
          'delivery_suburb',
          'delivery_postcode',
          'delivery_city',
          'delivery_country',
          'delivery_telephone'
    );
    var _url = window.location.pathname;
    var _filename = _url.substring(_url.lastIndexOf('/')+1);
	$('#address_update_button').click(function(){
		$.ajax({
			url: $('form#ajax_address_edit').attr('action'),
			dataType: 'json',
			data: $('form#ajax_address_edit').serialize(),
			success: function(json){
                            for(var element in json.UPDATE_ARRAY){
                                    switch(element){
                                            default:
                                                    $('table#address_table td#'+element).html(json.UPDATE_ARRAY[element]);
                                                    break;
                                    }
                            }
                            oe_help_key = json.ADDRESS_TYPE;
                            switch(json.ADDRESS_TYPE){
                                case 'shipping':
                                    oe_help_key = 'delivery';
                                    break;
                                case 'distributor':
                                    oe_help_key = 'distributor';
                                    break;
                            }
                            console.log('oe_help_key: '+oe_help_key+' '+json.UPDATE_ARRAY[oe_help_key+'_postcode']);
                            $('table#address_table td#'+oe_help_key+'_postcode_city').html(json.UPDATE_ARRAY[oe_help_key+'_postcode']+' '+json.UPDATE_ARRAY[oe_help_key+'_city']);
                            if(json.COPY_DISTRIBUTOR == 1){
                                $('table#address_table td#distributor_postcode_city').html(json.UPDATE_ARRAY['distributor_postcode']+' '+json.UPDATE_ARRAY['distributor_city']);
                            }
                            if(json.COPY_SHIPPING == 1){
                                $('table#address_table td#delivery_postcode_city').html(json.UPDATE_ARRAY['delivery_postcode']+' '+json.UPDATE_ARRAY['delivery_city']);
                            }
			    $('#modal_window').dialog('destroy');
			},
			error: function(xhr, ajaxOptions, thrownError){
				alert(xhr+' '+thrownError);
			}
		});
	});
});
</script>
<?php
	echo '<div class="main">';
	echo xtc_draw_form('ajax_address_edit',basename(__FILE__),xtc_get_all_get_params(array('action')).'action=ajax_address_save','POST','onsubmit="return false;" id="ajax_address_edit"');
	echo '<fieldset>';
	printf('<legend>%s</legend>',TEXT_EDIT_ADDRESS);
	switch($_REQUEST['address_type']){
		case 'distributor':
			$sql_prefix = 'distributor_';
			break;
		case 'shipping':
			$sql_prefix = 'delivery_';
			break;
	}
	$fields = array(
		$sql_prefix.'company',
		$sql_prefix.'name',
                $sql_prefix.'street_address',
                $sql_prefix.'suburb',
                $sql_prefix.'postcode',
                $sql_prefix.'city',
                $sql_prefix.'country',
                $sql_prefix.'telephone',
	);
	
	$query = xtc_db_query(sprintf("SELECT %s FROM %s WHERE distributor_orders_id='%s'",
			implode(',',$fields),'distributor_orders',xtc_db_input($_REQUEST['doID'])
	));
	$record = xtc_db_prepare_input(xtc_db_fetch_array($query));
	$countries = xtc_get_countries( $default='',$utf8=true );
        $db_ini = yes_get_database_table_ini();
	foreach($record as $key=>$value){
		$label = constant('TEXT_FIELD_'.strtoupper( substr($key,strlen($sql_prefix),strlen($key)) ));
		$size = 32;
		switch($key){
			case 'distributor_country':
			case 'delivery_country':
				$country_data = xtc_get_country_data_from_name($value);
				$field = xtc_draw_pull_down_menu($key, $countries, $country_data['countries_id'], 'id="'.$key.'"');
				break;
			case 'distributor_postcode':
			case 'shipping_postcode':
				$size = 6;
				$field = xtc_draw_input_field($key,yes_encode_string($value),'id="'.$key.'" size="'.$size.'"');
				break;
			default:
                            $current_size = $size;
                            $max_length = $current_size;
                            if(yes_get_database_table_field_length($db_ini, 'distributor_orders', $key) > $size){
                                $current_size = yes_get_database_table_field_length($db_ini, 'distributor_orders', $key);
                                if($current_size > 64){
                                    $max_length = $current_size;
                                    $current_size = 64;
                                }
                            }
                            $field = xtc_draw_input_field($key,$value,'id="'.$key.'" size="'.$current_size.'" maxlength="'.$max_length.'"');
				break;
		}
		printf('<label for="%s"><b>%s:</b></label><br />%s<br />',$key,$label,$field);
	}
	$copy_list = array(
		'distributor'=>TEXT_ADDRESS_BOOK_CLASS_CUSTOMER,
		'shipping'=>TEXT_ADDRESS_BOOK_CLASS_DELIVERY,
	);
	printf('<hr noshade="noshade" /><p>%s<br />',TEXT_COPY_ADDRESSTYPES_INTRO);
	foreach($copy_list as $copy=>$copy_text){
		if($copy != $_REQUEST['address_type']){
			printf('<input type="checkbox" name="copy_%s" value="1" />%s<br />',$copy,$copy_text);
		}
	}
	echo '</p>';
        if($_REQUEST['address_type'] == 'shipping'){
            $st_smarty = new yesSmarty;
            $items = array();
            $query = xtc_db_query("SELECT * FROM storages ORDER BY default_storage DESC, name");
            while($record = xtc_db_fetch_array($query)){
                $address = array();
                if($record['storage_company'] != '')
                    $address[] = $record['storage_company'];
                if($record['storage_name'] != '')
                    $address[] = $record['storage_name'];
                if($record['storage_suburb'] != '')
                    $address[] = $record['storage_suburb'];
                if($record['storage_street_address'] != '')
                    $address[] = $record['storage_street_address'];
                if($record['storage_city'] != '')
                    $address[] = $record['storage_postcode'].' '.$record['storage_city'];
                $country = ($record['storage_country']>0) ? $record['storage_country'] : STORE_COUNTRY;
                $address[] = xtc_get_country_name($country);
                $record['address'] = implode(', ',$address);
                $items[] = $record;
            }
            if(sizeOf($items)){
                $st_smarty->assign(array(
                    'items'=>$items,
                    'action'=>'get_storages_addresses',
                    'LINK_TEXT_STORAGE_ADDRESS_CONTAINTER_VIEW'=>LINK_TEXT_STORAGE_ADDRESS_CONTAINTER_VIEW
                ));
                $st_smarty->display('distributor_orders_edit.html');
            }
        }
	echo '<hr noshade="noshade" />';
	echo '<input type="button" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_SAVE.'" id="address_update_button" />';
	echo '</fieldset>';
	echo '</form>';
	echo '</div>';
	exit;
        break;
    }
}


if ( (isset($_GET['action']) and $_GET['action'] == 'update_payment_terms') && isset($_GET['doID']) ) {
    $update_sql_array = array('payment_terms'=>yes_decode_string(xtc_db_prepare_input($_REQUEST['payment_terms'])));
    $doID = (int)xtc_db_input($_REQUEST['doID']);
    xtc_db_perform('distributor_orders',$update_sql_array,'update',"distributor_orders_id='".$doID."'");
    $order = new distributor_order($doID);
    $comments = sprintf(MSG_SUCCESS_DISTRIBUTOR_ORDER_PAYMENT_TERMS_CHANGED,$_REQUEST['payment_terms']);
    $order->insert_history($order->info['orders_status'], false, $comments, $_SESSION['customer_id']);
    die(json_encode(array(
	'MSG'=>''
    )));
}
if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && ($_GET['doID']) ) {
	$oID = xtc_db_prepare_input($_GET['doID']);
	$orders_query = xtc_db_query("select distributor_orders_id from distributor_orders where distributor_orders_id = '" . xtc_db_input($oID) . "'");
	$order_exists = true;
	if (!xtc_db_num_rows($orders_query)) {
		$order_exists = false;
		$messageStack->add(sprintf(MSG_ERROR_DISTRIBUTOR_ORDER_NOT_EXISTS, $oID), 'error');
	}
}

if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'save_comments_visible'){
	$oID = (int)xtc_db_input($_REQUEST['doID']);
	$order = new distributor_order($oID);
	$update_sql_array = array(
		'comments_visible'=>$_REQUEST['comments_visible'],
		'last_modified'=>'now()'
	);
	xtc_db_perform('distributor_orders',$update_sql_array,'update','distributor_orders_id='.$oID);
	$comments = MSG_SUCCESS_COMMENTS_VISIBLE_EDIT;
	$order->insert_history($order->info['orders_status'],$customer_notified='0',$comments,$_SESSION['customer_id']);
	$messageStack->add_session($comments,'success');
	xtc_redirect(xtc_href_link('distributor_orders.php','action=edit&doID='.$oID));
}
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'edit_comments_visible'){
	$oID = (int)xtc_db_input($_REQUEST['doID']);
	$order = new distributor_order($oID);
    header('Content-Type: text/html; charset='.CHARSET);
	echo '<div class="main">'.xtc_draw_form('comments_visible_edit','distributor_orders.php','action=save_comments_visible&doID='.$_REQUEST['doID'],'post');
	echo 'Kommentar:<br />'.xtc_draw_textarea_field('comments_visible','virtual',40,5,xtc_db_prepare_input($order->info['comments_visible']));
	echo '<br /><input type="submit" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" />';
	echo '</form></div>';
	exit;
}

if ( (isset($_GET['action']) and $_GET['action'] == 'set_bestellt') && ($_GET['doID']) ) {
	$doID = xtc_db_input($_GET['doID']);
	$order = new distributor_order($doID);
	$order->update_status(DISTRIBUTOR_ORDERS_STATUS_BESTELLT,$msg,$_SESSION['customer_id']);
	$messageStack->add_session($msg,'success');
	xtc_redirect(xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action')).'action=edit'));
}
if ( (isset($_GET['action']) and $_GET['action'] == 'add_products_from_csv')) {
	$contents = file_get_contents($_REQUEST['file']);
	$rows = explode("\n",$contents);
	$query = xtc_db_query(sprintf(
		"SELECT distributor_id FROM distributor_orders WHERE distributor_orders_id='%s'",
		(int)xtc_db_input($_REQUEST['doID'])
	));
	$record = xtc_db_fetch_array($query);
	$dID = $record['distributor_id'];
	$distributor = xtc_get_distributor_name($dID);
	$distributor_info_query = xtc_db_query(sprintf(
		"SELECT tax_orders FROM distributors WHERE id='%s'",
		$dID
	));
	$distributor_info = xtc_db_fetch_array($distributor_info_query);
	$distributor_order_info_query = xtc_db_query(sprintf(
		"SELECT distributor_country FROM distributor_orders WHERE distributor_orders_id='%s'",
		(int)xtc_db_input($_REQUEST['doID'])
	));
	$distributor_order_info = xtc_db_fetch_array($distributor_order_info_query);
	$country = xtc_get_country_data_from_name($distributor_order_info['distributor_country']);
	$countries_id = $country['countries_id'];
        
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*
        if(yes_eu_oss_use_country_handling($country_id)){
            $tax_country_id = $countries_id;
        }else{
            $tax_country_id = STORE_COUNTRY;
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
         
        // BUGF_CH_OSS - COUNTRIES_ID BLEIBT
        $tax_country_id = $countries_id;
        

	$DO = new distributor_order((int)xtc_db_input($_REQUEST['doID']));

	$products = array();
	foreach($rows as $row){
		if(empty($row))
			continue;
		$cols = explode(';',$row);
		if(sizeOf($cols) != 3)
			continue;
		$query = xtc_db_query(sprintf(
			"SELECT distributor_product_prices_id FROM distributor_product_prices WHERE products_id='%s' AND distributor_id='%s'",
				(int)xtc_db_input($cols[0]),$dID,(int)xtc_db_input($_REQUEST['doID'])
		));
		if(xtc_db_num_rows($query)){
			$collies = xtc_get_product_collies($row[0]);
			if(!sizeOf($collies)){
				$products[] = $cols;
			}
		}
	}
	foreach($products as $product){
		$P = new product($product[0]);
		$price = (float)str_replace(',','.',$product[2]);


		$check_query = xtc_db_query(sprintf(
			"SELECT products_quantity,distributor_orders_products_id FROM distributor_orders_products WHERE products_id='%s' and distributor_orders_id='%s'",
			$product[0],(int)xtc_db_input($_REQUEST['doID'])
		));

		if(xtc_db_num_rows($check_query)){
			$check = xtc_db_fetch_array($check_query);
			$update_sql_array = array(
				'products_quantity'=>$product[1]+$check['products_quantity'],
				'products_price'=>$price,
				'final_price'=>$price*($product[1]+$check['products_quantity'])
			);
			xtc_db_perform('distributor_orders_products',$update_sql_array,'update',"distributor_orders_products_id='".$check['distributor_orders_products_id']."'");
			$comments = sprintf(HISTORY_CSV_PRODUCT_UPDATED,$product[0],$product[1],$product[2]);
		}else{
			$check = xtc_db_fetch_array($check_query);
			$tax_rate = xtc_get_tax_rate($P->data['products_tax_class_id'], $tax_country_id);
			$insert_sql_array = array(
				'distributor_orders_id'=>(int)xtc_db_input($_REQUEST['doID']),
				'products_id'=>$product[0],
				'products_model'=>$P->data['products_model'],
				'products_name'=>$P->data['products_name'],
				'products_quantity'=>$product[1]+$check['products_quantity'],
				'products_price'=>$price,
				'final_price'=>$price*$product[1]+$check['products_quantity'],
				'products_tax'=>$tax_rate,
				'allow_tax'=>$distributor_info['tax_orders'],
				'date_added'=>'now()'
			);
			xtc_db_perform('distributor_orders_products',$insert_sql_array);
			$comments = sprintf(HISTORY_CSV_PRODUCT_INSERTED,$product[0],$product[1],$product[2]);
		}
		$DO->insert_history($DO->info['orders_status'], false, $comments, $_SESSION['customer_id']);
	}
	$messageStack->add_session(MSG_SUCCESS_CSV_IMPORT,'success');
	xtc_redirect(xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('action','qqfile','file')).'action=edit'));
}
if ( (isset($_GET['action']) and $_GET['action'] == 'cvs_import')) {
	if(isset($_REQUEST['qqfile'])){
		$allowedExtensions = array('csv','CSV');
		$sizeLimit = 100000;
		$uploader = new qqFileUploader($allowedExtensions,$sizeLimit);
		// Call handleUpload() with the name of the folder, relative to PHP's getcwd()
		$result = $uploader->handleUpload(\main::get_importdata_path());

		// to pass data through iframe you will need to encode all html tags
		$uploaded_file = $result['FN'];
		$contents = file_get_contents($result['FN']);
		$rows = explode("\n",$contents);
		$query = xtc_db_query(sprintf(
			"SELECT distributor_id FROM distributor_orders WHERE distributor_orders_id='%s'",
			(int)xtc_db_input($_REQUEST['doID'])
		));
		$record = xtc_db_fetch_array($query);
		$dID = $record['distributor_id'];
		$distributor = xtc_get_distributor_name($dID);
		$html = array('<b>Resultat</b>');
		$lines = 0; // valid lines
		$valids = 0; // valid imports
		foreach($rows as $row){
			if(empty($row))
				continue;
			$cols = explode(';',$row);
			if(sizeOf($cols) != 3)
				continue;
			$lines++;
			$query = xtc_db_query(sprintf(
				"SELECT distributor_product_prices_id FROM distributor_product_prices WHERE products_id='%s' AND distributor_id='%s'",
					(int)xtc_db_input($cols[0]),$dID
			));
			if(!xtc_db_num_rows($query)){
				$html[] = '<span class="errorText">'.yes_encode_string(sprintf(ERROR_NO_PRODUCTS_ALLOCATION,$cols[0],$distributor)).'</span>';
			}else{
				$collies = xtc_get_product_collies($row[0]);
				if(!sizeOf($collies)){
					$valids++;
					$html[] = sprintf(TEXT_IMPORT_PRODUCT,$cols[1],$cols[0],number_format((float)$cols[2],2,',','.'));
				}else{
					$html[] = sprintf(ERROR_NO_SETPRODUCTS,$cols[0]);
				}
			}
		}
		if($lines == 0)
			$html = ERROR_NO_PRODUCTS;
		else
			$html = implode("<br />",$html);
		if($valids > 0){
			$html .= sprintf('<hr noshade="noshade">%s <input type="button" class="yesButton" value="%s" id="save" /><br />',
					sprintf(TEXT_IMPORTABLE_ITEMS,$valids),
					IMAGE_SAVE
			);
		}else{
			unlink($uploaded_file);
		}
		$result['html'] = $html;
		$result['href'] = xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('action')).'action=add_products_from_csv&file='.urlencode($result['FN']));
		header('Content-Type: text/html; charset=utf-8');
		echo json_encode($result);
		exit;
	}
	$smarty->assign(array(
		'TEXT_CSV_IMPORT_INTRO'=>TEXT_CSV_IMPORT_INTRO,
		'FORM_ACTION'=>xtc_href_link('distributor_orders.php',xtc_get_all_get_params()),
		'IMAGE_UPLOAD'=>IMAGE_UPLOAD,
		'FORM_END'=>'</form>',
		'TEXT_INPUT_FILE'=>TEXT_INPUT_FILE
	));
	$smarty->display('distributor_orders_csv_upload.html');
	$doID = xtc_db_input($_GET['doID']);
	$order = new distributor_order($doID);
	exit;
	$messageStack->add_session($msg,'success');
	xtc_redirect(xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action')).'action=edit'));
}

if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'email'){
        $doID = xtc_db_input($_GET['doID']);
        $order = new distributor_order($doID);
        $email_addresses = [xtc_db_input($_POST['email_to'])];
        $email_addresses_for_order_history = $email_addresses;
        if(isset($_POST['email_cc']) and sizeOf($_POST['email_cc'])){
            foreach($_POST['email_cc'] as $nr=>$email){
                $email_addresses_for_order_history[] = $email;
                if(!isset($_POST['email_mode']) or $_POST['email_mode'][$nr] != 'bcc'){
                    $email_addresses[] = 'cc:'.xtc_db_input($email);
                }else{
                    $email_addresses[] = xtc_db_input($email);
                }
            }
        }
        foreach($email_addresses as $email_address){
            $vmail = str_replace('cc:','',$email_address);
            if(!xtc_validate_email($vmail)){
                $messageStack->add_session(sprintf(MSG_ERROR_VALIDATE_EMAIL,$vmail),'error');
                xtc_redirect(xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('email_address','action')).'action=edit'));
            }
        }
        $smarty->assign('oID',$doID);
        $smarty->assign('date_created',yes_strftime('%d.%m.%Y',strtotime($order->info['date_saved'])));
        $smarty->assign('orders_status',xtc_get_distributor_orders_status_name($order->info['orders_status']));
        $smarty->assign('distributor_name',$order->distributor['name']);
        $smarty->assign('distributor_delivery_company',$order->delivery['company']);
        $smarty->assign('distributor_delivery_name',$order->delivery['name']);
        $smarty->assign('distributor_street_address',$order->distributor['street_address']);
        $smarty->assign('distributor_delivery_street_address',$order->delivery['street_address']);
        if(isset($order->distributor['suburb'])){
            $smarty->assign('distributor_suburb',$order->distributor['suburb']);
        }

        $smarty->assign('distributor_delivery_suburb',$order->delivery['suburb']);
        $smarty->assign('distributor_postcode',$order->distributor['postcode']);
        $smarty->assign('distributor_city',$order->distributor['city']);
        $smarty->assign('distributor_delivery_postcode',$order->delivery['postcode']);
        $smarty->assign('distributor_delivery_city',$order->delivery['city']);
        $smarty->assign('distributor_country',$order->distributor['country']);
        $smarty->assign('distributor_delivery_country',$order->delivery['country']);
        $smarty->assign('distributor_telephone',$order->distributor['telephone']);
        $smarty->assign('distributor_email_address',$order->distributor['email_address']);
        $smarty->assign('comments_visible',xtc_db_prepare_input($order->info['comments_visible']));
        $smarty->assign(array(
            'distributor_ID'=>$order->distributor['ID'],
            'payment_terms'=>$order->info['payment_terms']
        ));
        $D = new distributor($order->distributor['ID']);
        if($D->info['kundennummer'] != '')
                $smarty->assign('csID',$D->info['kundennummer']);
        if($order->info['estimated_date_receipt'] != '0000-00-00 00:00:00' and $order->info['orders_status'] != DISTRIBUTOR_ORDERS_STATUS_EINGETROFFEN ){
                $smarty->assign('estimated_date_receipt',xtc_date_short($order->info['estimated_date_receipt']));
        }
        if($order->info['date_receipt'] != '0000-00-00 00:00:00' ){
                $smarty->assign('date_receipt',xtc_date_short($order->info['date_receipt']));
        }

        $products = array();
        $products_raw = $order->get_products_grouped();
        $products = array();
        $products_num = sizeOf($products_raw);
        for ($i = 0; $i<$products_num; $i++) {
            $rec = '&nbsp;';
            $item = $products_raw[$i];
            $product = $item;
            // auch LieferantenNr anzeigen
            $product['distributor_number'] = yes_get_products_distributor_number($item['id'],$order->info['distributor_id']);
            $product['ean'] = yes_get_products_ean($item['id']);
            $product['pID'] = $item['id'];
            if($item['final_price'] > 0 && $item['qty'] > 0){
                $product['price_netto'] = format_price($item['final_price']/$item['qty'], 1, $order->info['currency'], $item['allow_tax'], $item['tax']);
            }else{
                $product['price_netto'] = format_price(0, 1, $order->info['currency'], $item['allow_tax'], $item['tax']);
            }
            if($item['allow_tax'] > 0){
                $product['tax'] = xtc_display_tax_value($item['tax']);
                if($item['final_price'] > 0 && $item['qty'] > 0){
                    $product['price'] = format_price($item['final_price']/$item['qty'], 1, $order->info['currency'], 0, 0);
                }else{
                    $product['price'] = format_price(0, 1, $order->info['currency'], 0, 0);
                }
            }
            $product['final_price'] = format_price(($item['final_price']),1,$order->info['currency'],0,0);
            $products[] = $product;
        }
        $smarty->assign('products',$products);
        $totals = array();
        for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
            $total = array();
            $total['title'] = $order->totals[$i]['title'];
            $total['text'] = $order->totals[$i]['text'];
            $totals[] = $total;
        }
        $smarty->assign('totals',$totals);
        $smarty->assign('orders_comments',(($order->info['comments']!='')?$order->info['comments']:TEXT_NO_DISTRIBUTOR_ORDER_COMMENT));
        $smarty->assign(array(
            'STORE'=>STORE_WRAP,
            'logo_path'=>HTTP_SERVER  . 'templates/'.CURRENT_TEMPLATE.'/img/',
            'STORE_NAME'=>STORE_NAME,
            'STORE_NAME_ADDRESS'=>STORE_NAME_ADDRESS
        ));
        $file = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/distributor_order.html';
        if(!is_file($file)){
           die(sprintf(TEXT_ERROR_DISTRIBUTOR_TEMPLATE_MISSING,$file));
        }
        $to = array_shift($email_addresses);
        // nach shift wurde das erste element des arrays entfernt
        
	$html = $smarty->fetch($file);
	$header = 'From: '.STORE_NAME.' <'. $_REQUEST['email_from'] . ">\r\n" .
		'Reply-To: ' .$_REQUEST['email_from']. "\r\n" .
		'X-Mailer: PHP/' . phpversion();
        $cc = [];
        $bcc = [];
        foreach($email_addresses as $email){
            if(substr($email,0,3) == 'cc:'){
                $cc[] = str_replace('cc:','',$email);
            }else{
                $bcc[] = $email;
            }
        }
	if(sizeOf($cc)){
	    $header .= "\r\nCc: ".implode(',',$cc);
	}
	if(sizeOf($bcc)){
	    $header .= "\r\nBcc: ".implode(',',$bcc);
	}
	if(isset($_REQUEST['attachment']) and sizeOf($_REQUEST['attachment'])){
	    $mod_att = new module_attachments('distributor_order',$doID);
	    $attachments = array();
	    foreach($_REQUEST['attachment'] AS $att){
		$att_info = $mod_att->get_attachment_info($att);
		if(!isset($att_info['mime_type']) or $att_info['size'] == 0){
		    continue;
		}
		$attachments[] = $att_info;
	    }
	}
	if(is_countable($attachments) and sizeOf($attachments)){
	    $semi_rand = md5(time());
	    $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
	    $header .= "\nMIME-Version: 1.0\n" .
		"Content-Type: multipart/mixed;\n" .
		" boundary=\"{$mime_boundary}\"";
	    $html = "--{$mime_boundary}\n" .
		"Content-Type:text/html; charset=\"utf-8\"\n" .
		"Content-Transfer-Encoding: 7bit\n\n" . $html."\n\n";
	    $html .= "--{$mime_boundary}\n";
	    foreach($attachments AS $att){
		$data = chunk_split(base64_encode($mod_att->get_attachment_content($att['file'])));
		$html .= "Content-Type: {\"".$att['mime_type']."\"};\n" . " name=\"".$att['file']."\"\n" .
		    "Content-Disposition: attachment;\n" . " filename=\"".$att['file']."\"\n" .
		    "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
		$html .= "--{$mime_boundary}\n";
	    }
	}else{ // end sizeof attachments
	    $header .= "\r\n".'Content-type: text/html; charset=utf-8' . "\r\n";
	}
	$subject = yes_encode_string(xtc_db_prepare_input($_REQUEST['email_subject']));
        
	mail($to,$subject,$html,$header);
	$order->insert_history($order->info['orders_status'], 1, sprintf(HISTORY_MAIL_SENT,implode(', ',$email_addresses_for_order_history)), $_SESSION['customer_id']);
	$messageStack->add_session(sprintf(HISTORY_MAIL_SENT,$_REQUEST['email_to']),'success');
	xtc_redirect(xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action','email_address')).'action=edit'));
}

if ( (isset($_GET['action']) and $_GET['action'] == 'confirm_email') && ($_GET['doID']) ) {
	$doID = xtc_db_input($_GET['doID']);
	$order = new distributor_order($doID);
        $add = array(); // zusaetzl emails
        $contacts_query = xtc_db_query("select * from distributor_contacts WHERE distributor_id='".$order->info['distributor_id']."' order by contact_lastname,contact_firstname");
        while ($contact = xtc_db_fetch_array($contacts_query)) {
            if($contact['contact_email'] != ''){
                $add[] = array('email'=>$contact['contact_email'],
                    'name'=>$contact['contact_firstname'].' '.$contact['lastname']
                );
            }
            if($contact['contact_email2'] != ''){
                $add[] = array('email'=>$contact['contact_email2'],
                    'name'=>$contact['contact_firstname'].' '.$contact['contact_lastname']
                );
            }
        }
        $d = new distributor($order->info['distributor_id']);
	$email_query = xtc_db_query(sprintf(
		"SELECT customers_email_address FROM %s WHERE customers_id=%s",
		TABLE_CUSTOMERS, $_SESSION['customer_id']
	));
	$email = xtc_db_fetch_array($email_query);
	$mod_att = new module_attachments('distributor_order', $doID);
	$attachments = $mod_att->get_attachments();
        $att_array = array();
        $smarty->assign(array(
            'FORM'=>xtc_draw_form('send_email','distributor_orders.php',xtc_get_all_get_params(array('action')).'action=email','POST','onsubmit="return check_distributor_order_email_form()"'),
            'INPUT_SUBJECT'=>xtc_draw_input_field('email_subject',SUBJECT_DISTRIBUTOR_ORDER,'id="subject" size="32" maxlength="64"'),
            'INPUT_MAIL_FROM'=>xtc_draw_input_field('email_from',$email['customers_email_address'],'id="email_from" size="32" maxlength="64"'),
            'INPUT_MAIL_TO'=>xtc_draw_input_field('email_to',$order->distributor['email_address'],'id="email_to" size="32" maxlength="255"'),
            'INPUT_MAIL_TO_CC'=>xtc_draw_input_field('email_to_cc','','id="email_to_cc" size="32" maxlength="255"'),
            'INPUT_MAIL_TO_BCC'=>xtc_draw_input_field('email_to_bcc','','id="email_to_bcc" size="32" maxlength="255"'),
            'TEXT_SUBJECT'=>INPUT_MAIL_SUBJECT,
            'TEXT_MAIL_FROM'=>INPUT_MAIL_FROM,
            'TEXT_MAIL_TO'=>INPUT_MAIL_TO,
            'ATTACHEMENTS'=>$att_array,
            'TEXT_EMAIL_CONFIRM_SELECT_ATTACHMENTS'=>TEXT_EMAIL_CONFIRM_SELECT_ATTACHMENTS,
            'TEXT_SEND'=>IMAGE_SEND,
            'ADDITIONAL_EMAILS'=>$add,
            'TEXT_ADDITIONAL_ADDRESSES'=>TEXT_ADDITIONAL_ADDRESSES,
            'TEXT_ADD_EMAIL'=>TEXT_ADD_EMAIL
        ));
	header('Content-Type: text/html; charset='.CHARSET);
        $smarty->display('distributor_order_confirm_email.html');
	exit;
}

if ( (isset($_GET['action']) and $_GET['action'] == 'gen_invoice_process') && ($_GET['doID']) ) {
	$doID = xtc_db_input($_GET['doID']);
	$order = new distributor_order($doID);
	$order->generate_invoice('installment',$msg,$_SESSION['customer_id']);
	$messageStack->add_session($msg,'success');
	xtc_redirect(xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action')).'action=edit'));
}

if ( (isset($_GET['action']) and $_GET['action'] == 'gen_invoice_we_process') && isset($_GET['doID']) ) {
	$doID = xtc_db_input($_GET['doID']);
	$order = new distributor_order($doID);
	$products_array = array();
	for($i=0;$i<sizeOf($order->products);$i++){
		if($item['stuecklisten_id'] == 0){
			if($_POST[ 'invoice_qty_'.$item['id'] ] and $_POST[ 'invoice_qty_'.$item['id'] ] > 0){
				$products_array[ $item['id'] ] = $_POST[ 'invoice_qty_'.$item['id'] ];
			}
		}
	}
	if(sizeOf($products_array)>0){
		/**
		 * ich hab die rueckgabe der variable per & rausgenommen
		 * 02.10.2010 mario
		 * $order->generate_invoice($type='receipt',&$msg,$usr,$products_array);
		 */
		$order->generate_invoice($type='receipt',$msg,$usr,$products_array);
	}else{
		$messageStack->add_session(MSG_ERROR_NO_PRODUCTS_FOR_DISTRIBUTOR_INVOICE,'error');
	}
	xtc_redirect(xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action')).'action=edit'));
}
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
	case 'create_from_order':
		$dID = (int)xtc_db_input($_REQUEST['dID']);
		$distributor = new distributor($dID);
		$doID = $distributor->new_order((int)xtc_db_input($_REQUEST['orders_id']));
		$json_return_products_array = array();
		$counter = 0;
		$netto_sum = array();
		if(isset($_REQUEST['qty'])){
			foreach($_REQUEST['qty'] as $pID => $qty){
				$counter++;
				$pID = xtc_db_input($pID);
				$qty = (int)xtc_db_input($qty);
				
				$properties = array();
				if(strstr($pID,'{')){
					$parts = explode('{',$pID);
					$pID = $parts[0];
					$opID = substr($parts[1],0,(strlen($parts[1])-1 ));
					$query = xtc_db_query(sprintf(
						"SELECT property_title,property_value FROM orders_products_properties WHERE orders_products_id='%s'",
						$opID
					));
					while($record = xtc_db_fetch_array($query)){
						$properties[] = $record;
					}
				}
				
				$collies = xtc_get_product_collies($pID);
				$tax = 0;
				// PRICE NETTO
				$price = xtc_get_price_ek($pID,'MIN',$dID);
				$product_query = xtc_db_query("SELECT p.products_model FROM products p WHERE p.products_id=".$pID);
				$product = xtc_db_fetch_array($product_query);
				if($distributor->info['tax_orders'] > 0){
                                    $delivery_country_name = $distributor->info['land'];
                                    require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
                                    $delivery_country_data = xtc_get_country_data_from_name($delivery_country_name);
                                    $delivery_country_id = $delivery_country_data['countries_id'];
                                    
                                    // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                                    /*if(yes_eu_oss_use_country_handling($delivery_country_id)){
                                        $tax_country_id = $delivery_country_id;
                                    }else{
                                        $tax_country_id = STORE_COUNTRY;
                                    }*/
                                    // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                                    
                                    // BUGF_CH_OSS
                                    $tax_country_id = $delivery_country_id;
                                    
                                    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $delivery_country_id);
                                    $tax = xtc_oe_get_tax_rate($products_tax_class_id);
                                    $tax_divisor = (100+$tax)/100;

                                    $bprice = $price * $tax_divisor;
                                    if(!isset($netto_sum[ $tax ]))
                                            $netto_sum[ $tax ] = 0;
                                    $netto_sum[ $tax ] += ($bprice-$price)*$qty;

                                    $price = $bprice;
				}

				$final_price = $price * $qty;
				$sql_insert_array = array(
					'distributor_orders_id'=>$doID,
					'products_id'=>$pID,
					'products_model'=>$product['products_model'],
					'products_name'=>  xtc_get_products_name($pID),
					'products_price'=>$price,
					'products_discount_made'=>0,
					'final_price'=>$final_price,
					'products_tax'=>$tax,
					'products_quantity'=>$qty,
					'allow_tax'=>$distributor->info['tax_orders'],
					'date_added'=>'now()',
					'stuecklistenartikel'=>((sizeOf($collies))?1:0)
				);
				xtc_db_perform('distributor_orders_products',$sql_insert_array);
				$dopID = xtc_db_insert_id();
				if(sizeOf($properties)){
					foreach($properties as $property){
						$sql_insert_array = array(
							'distributor_orders_products_id'=>$dopID,
							'property_title'=>$property['property_title'],
							'property_value'=>$property['property_value']
						);
						xtc_db_perform('distributor_orders_products_properties',$sql_insert_array);
					}
				}
				
				$json_return_products_array[] = array(
					'DIV_NAME'=>sprintf("qty_%s",$pID),
					'INPUT_NAME'=>sprintf("qty[%s]",$pID)
				);
			}
		}
		if(isset($_REQUEST['qty_set'])){
			foreach($_REQUEST['qty_set'] as $setID=>$set){
				foreach($set as $pID => $qty){
					$counter++;
					$collie_data_query = xtc_db_query(sprintf(
						"SELECT * FROM products_collies WHERE products_id=%s AND collie_products_id=%s",
						$setID,$pID
					));
					$collie_data = xtc_db_fetch_array($collie_data_query);

					$pID = (int)xtc_db_input($pID);
					$qty = (int)xtc_db_input($qty);
					$tax = 0;
					// PRICE NETTO
					$price = xtc_get_price_ek($pID,'MIN',$dID);
					$product_query = xtc_db_query("SELECT p.products_model FROM products p WHERE p.products_id=".$pID);
					$product = xtc_db_fetch_array($product_query);
					if($distributor->info['tax_orders'] > 0){
                                            $delivery_country_name = $distributor->delivery['country'];
                                            require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
                                            $delivery_country_data = xtc_get_country_data_from_name($delivery_country_name);
                                            $delivery_country_id = $delivery_country_data['countries_id'];
                                            
                                            // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                                            /*if(yes_eu_oss_use_country_handling($delivery_country_id)){
                                                $tax_country_id = $delivery_country_id;
                                            }else{
                                                $tax_country_id = STORE_COUNTRY;
                                            }*/
                                            // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                                            
                                            // BUGF_CH_OSS
                                            $tax_country_id = $delivery_country_id;
                                            
                                            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $delivery_country_id);
                                            
                                            $tax = xtc_oe_get_tax_rate($products_tax_class_id);
						$tax_divisor = (100+$tax)/100;
						
						
						$bprice = $price * $tax_divisor;
						if(!isset($netto_sum[ $tax ]))
							$netto_sum[ $tax ] = 0;
						$netto_sum[ $tax ] += ($bprice-$price)*$_REQUEST['qty_set'][$setID][$pID];
						
						$price = $bprice;
					}

					$sql_insert_array = array(
						'distributor_orders_id'=>$doID,
						'products_id'=>$pID,
						'products_model'=>$product['products_model'],
						'products_name'=>  xtc_get_products_name($pID),
						'products_price'=>$price,
						'products_discount_made'=>0,
						'final_price'=>$price*$_REQUEST['qty_set'][$setID][$pID],
						'products_tax'=>$tax,
						'products_quantity'=>$_REQUEST['qty_set'][$setID][$pID],
						'allow_tax'=>$distributor->info['tax_orders'],
						'date_added'=>'now()',
	/*					'stuecklisten_id'=>$setID,
						'collie_qty'=>$collie_data['quantity']*/
					);
					xtc_db_perform('distributor_orders_products',$sql_insert_array);
					$json_return_products_array[] = array(
						'DIV_NAME'=>sprintf("qty_set_%s_%s",$setID,$pID),
						'INPUT_NAME'=>sprintf("qty_set[%s][%s]",$setID,$pID)
					);
				}
			}
		}
		if($counter == 0){
			die(json_encode(array(
				'ERROR'=>sprintf(MSG_ERROR_GENERATE_DISTRIBUTOR_ORDER)
			)));
		}
		$query = xtc_db_query(sprintf(
			"SELECT SUM(final_price) as final FROM distributor_orders_products WHERE distributor_orders_id=%s",
			$doID
		));
		$record = xtc_db_fetch_array($query);
		$update_sql_array = array(
			'text'=>number_format($record['final'],2,',','.').' EUR',
			'value'=>$record['final']
		);
		xtc_db_perform('distributor_orders_total',$update_sql_array,'update','class="ot_subtotal" AND orders_id='.$doID);
		$update_sql_array = array(
			'text'=>number_format($record['final'],2,',','.').' EUR',
			'value'=>$record['final']
		);
		xtc_db_perform('distributor_orders_total',$update_sql_array,'update','class="ot_total" AND orders_id='.$doID);
		if($distributor->info['tax_orders'] == 1){
			xtc_db_query(sprintf(
				"DELETE FROM distributor_orders_total WHERE orders_id=%s AND class='ot_tax'",
				$doID
			));
			foreach($netto_sum as $tax_rate => $value){
				$insert_sql_array = array(
					'text'=>number_format($value,2,',','.').' EUR',
					'value'=>$value,
					'orders_id'=>$doID,
					'title'=>'UST '.number_format($tax_rate,0,'','').'%',
					'class'=>'ot_tax',
					'sort_order'=>'50',
				);
				xtc_db_perform('distributor_orders_total',$insert_sql_array);
			}
		}
		if(isset($_REQUEST['use_delivery_address']) and $_REQUEST['use_delivery_address'] == 1){
			$query = xtc_db_query(sprintf(
				"SELECT delivery_name,delivery_company,delivery_street_address,delivery_suburb,delivery_city,delivery_postcode,delivery_country FROM orders WHERE orders_id=%s",
				(int)xtc_db_input($_REQUEST['orders_id'])
			));
			$record = xtc_db_fetch_array($query);
			xtc_db_perform('distributor_orders',$record,'update','distributor_orders_id='.$doID);
		}
		$order = new order((int)xtc_db_input($_REQUEST['orders_id']));
		
		
		
		$link = sprintf('<a href="%s" target="_blank"><u>%s</u></a>',
				xtc_href_link('distributor_orders.php','menugroup=products&doID='.$doID.'&action=edit'),
				$doID
		);
		$comment = sprintf(MSG_SUCCESS_GENERATE_DISTRIBUTOR_ORDER,$doID);
		$do = new distributor_order($doID);
		$order->add_history($order->info['orders_status'], false, $comment);
		$do->insert_history(1, false, 'Erzeugt aus Re-Nr '.(int)xtc_db_input($_REQUEST['orders_id']), $_SESSION['customer_id']);
		$comment = sprintf(MSG_SUCCESS_GENERATE_DISTRIBUTOR_ORDER,$link);
		die(json_encode(array(
			'products'=>$json_return_products_array,
			'SUCCESS'=>$comment
		)));
		break;
	case 'deleteconfirm':
		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_delete'] == '1')) {
		}else{
			$messageStack->add_session(MSG_ERROR_NOT_AUTHORIZED_FOR_DELETE_DISTRIBUTOR_ORDERS,'error');
			xtc_redirect(xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('action'))));
		}
   		$doID = xtc_db_prepare_input($_GET['doID']);
		$order = new distributor_order($doID);
		$order->delete($msg,$_SESSION['customer_id']);
		$messageStack->add_session($msg,'success');
		xtc_redirect(xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('doID', 'action'))));
		break;
   	case 'delete':
		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_delete'] == '1')) {
		}else{
			$messageStack->add_session(MSG_ERROR_NOT_AUTHORIZED_FOR_DELETE_DISTRIBUTOR_ORDERS,'error');
			xtc_redirect(xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('action'))));
		}
		break;
   	case 'edit':
		break;
      		
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
if(isset($_GET['popurl']) and xtc_not_null($_GET['popurl'])){
?>
<script type="text/javascript">
<!--
var ONLOADFUNC = '_myOnload';
var ONLOADFUNCPARAM = '<?php echo $_GET['popurl']; ?>';
function _myOnload(param){
	window.open(param,'_blank');
}
//-->
</script>
<?php
}
echo yes_draw_quicknote();
$oID = (int)xtc_db_input($_REQUEST['doID']);
$fetch_html = true;
if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && ($order_exists) ) {
	$order = new distributor_order($oID);
	$smarty->assign(array(
	    'edit_mode'=>'1',
	    'oID'=>$oID,
	    'payment_terms'=>$order->info['payment_terms'],
	    'TEXT_DISTRIBUTOR_PAYMENT_TERMS'=>TEXT_DISTRIBUTOR_PAYMENT_TERMS,
            'LINK_ADDRESS_EDIT_DISTRIBUTOR'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=distributor'),
            'LINK_ADDRESS_EDIT_SHIPPING'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=shipping'),
	));
	$order->distributor = xtc_db_prepare_input($order->distributor);
	$order->delivery = xtc_db_prepare_input($order->delivery);
	$smarty->assign('date_created',yes_strftime('%d.%m.%Y',strtotime($order->info['date_saved'])));
	$smarty->assign('orders_status',xtc_get_distributor_orders_status_name($order->info['orders_status']));
	$smarty->assign('distributor_company',$order->distributor['company']);
	$smarty->assign('distributor_name',$order->distributor['name']);
	$smarty->assign('distributor_delivery_company',$order->delivery['company']);
	$smarty->assign('distributor_delivery_name',$order->delivery['name']);
	$smarty->assign('distributor_street_address',$order->distributor['street_address']);
	$smarty->assign('distributor_suburb',$order->distributor['suburb']);
	$smarty->assign('distributor_delivery_street_address',$order->delivery['street_address']);
	$smarty->assign('distributor_delivery_suburb',$order->delivery['suburb']);
	$smarty->assign('distributor_postcode',$order->distributor['postcode']);
	$smarty->assign('distributor_city',$order->distributor['city']);
	$smarty->assign('distributor_delivery_postcode',$order->delivery['postcode']);
	$smarty->assign('distributor_delivery_city',$order->delivery['city']);
	$smarty->assign('distributor_country',$order->distributor['country']);
	$smarty->assign('distributor_delivery_country',$order->delivery['country']);
	$smarty->assign('distributor_telephone',$order->distributor['telephone']);
	$smarty->assign('distributor_delivery_telephone',$order->delivery['telephone']);
	$smarty->assign('distributor_email_address',$order->distributor['email_address']);
	$smarty->assign('distributor_ID',$order->distributor['ID']);
	if($order->info['estimated_date_receipt'] != '0000-00-00 00:00:00' and $order->info['orders_status'] != DISTRIBUTOR_ORDERS_STATUS_EINGETROFFEN ){
		$smarty->assign('estimated_date_receipt',xtc_date_short($order->info['estimated_date_receipt']));
	}
	if($order->info['date_receipt'] != '0000-00-00 00:00:00' ){
		$smarty->assign('date_receipt',xtc_date_short($order->info['date_receipt']));
	}

	$products = array();
	if(isset($_REQUEST['order_by'])){
		$sort_asc = true;
		$order_by = $_REQUEST['order_by'];
		$parts = explode(' ',$_REQUEST['order_by']);
		if(sizeOf($parts)>1){
			list($order_by,$direction) = $parts;
			if(strtolower($direction) == 'desc')
				$sort_asc = false;
		}
		$smarty->assign('SUBMITTED_ORDER_BY',$order_by);
		$smarty->assign('SUBMITTED_ORDER_DIRECTION',(($sort_asc)?'asc':'desc'));
		$order->products = $order->sort_array($order->products, $order_by,$sort_asc);
	}

	$products_raw = $order->get_products_grouped();
	$products = array();
	$products_num = sizeOf($products_raw);
	for ($i = 0; $i<$products_num; $i++) {
		$dlink_query = yes_db_query(sprintf(
			"SELECT distributor_products_link FROM products_distributors WHERE products_id='%s' and distributor_id='%s'",
			$products_raw[$i]['id'],$order->distributor['ID']
		));
		if(yes_db_num_rows($dlink_query)){
			$dlink_record = current($dlink_query);
			$products_raw[$i]['distributor_products_link'] = $dlink_record['distributor_products_link'];
		}
		$rec = '&nbsp;';
		$item = $products_raw[$i];
		$product = $item;
		// auch LieferantenNr anzeigen
		$product['distributor_number'] = xtc_db_prepare_input(yes_get_products_distributor_number($item['id'],$order->info['distributor_id']));
		$product['pID'] = $item['id'];
		if($item['final_price'] > 0 && $item['qty'] > 0){
			$product['price_netto'] = format_price($item['final_price']/$item['qty'], 1, $order->info['currency'], $item['allow_tax'], $item['tax']);
		}else{
			$product['price_netto'] = format_price(0, 1, $order->info['currency'], $item['allow_tax'], $item['tax']);
		}
		if($item['allow_tax'] > 0){
			$product['tax'] = xtc_display_tax_value($item['tax']);
			if($item['final_price'] > 0 && $item['qty'] > 0){
				$product['price'] = format_price($item['final_price']/$item['qty'], 1, $order->info['currency'], 0, 0);
			}else{
				$product['price'] = format_price(0, 1, $order->info['currency'], 0, 0);
			}
		}
		$product['final_price'] = format_price(($item['final_price']),1,$order->info['currency'],0,0);
		$products[] = $product;
	}
	
	$smarty->assign('SORT_BASE_URL',xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('order_by'))));
	$smarty->assign('products',$products);
	//$smarty->assign('products_stk',$products_stk);

	$totals = array();
	for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
		$total = array();
		$total['title'] = $order->totals[$i]['title'];
		$total['text'] = $order->totals[$i]['text'];
		$totals[] = $total;
	}
	$smarty->assign('totals',$totals);
	$smarty->assign('orders_comments',(($order->info['comments']!='')?xtc_db_prepare_input($order->info['comments']):'Kein Kommentar hinterlegt'));
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['distributor_orders_update'] == '1')) {
		$smarty->assign('change_status_link',xtc_href_link('distributor_orders_update.php',xtc_get_all_get_params(array('doID')).'doID='.xtc_db_input($oID)));
	}
	if($order->info['orders_status'] == DISTRIBUTOR_ORDERS_STATUS_OFFEN){
		$dID = $order->info['distributor_id'];
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_orders_bestellen'] == '1')) {
			$smarty->assign('button_status_bestellt','<input class="ui-button ui-corner-all ui-state-default" type="button" style="width:160px;" value="'.IMAGE_PRODUCTS_ORDERED.'" onClick="window.location.href=\''.xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action','doID','dID')).'doID='.$_GET['doID'].'&dID='.$dID.'&action=set_bestellt').'\';">');
		}else{
			$smarty->assign('button_status_bestellt','<input class="ui-button ui-corner-all ui-state-default" type="button" style="width:160px;" value="'.IMAGE_PRODUCTS_ORDERED.'" onClick="alert(\''.JS_ALERT_NOT_AUTHORIZED.'\');">');
		}
	}
	if($order->info['orders_status'] == DISTRIBUTOR_ORDERS_STATUS_BESTELLT){
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['distributor_orders_rueckbuch'] == '1')) {
			$smarty->assign('button_status_eingetroffen','<input class="ui-button ui-corner-all ui-state-default" type="button" style="width:160px;" value="'.IMAGE_PRODUCTS_ARRIVED.'" onClick="window.location.href=\''.xtc_href_link('distributor_orders_rueckbuch.php', 'doID=' . $_GET['doID']).'\';">');
		}else{
			$smarty->assign('button_status_eingetroffen','<input class="ui-button ui-corner-all ui-state-default" type="button" style="width:160px;" value="'.IMAGE_PRODUCTS_ARRIVED.'" onClick="alert(\''.JS_ALERT_NOT_AUTHORIZED.'\');" style="color:#888888;">');
		}
	}
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['distributor_invoices_edit'] == '1')) {
		if($order->allow_invoice()){
			$smarty->assign('button_generate_invoice','<input class="ui-button ui-corner-all ui-state-default" type="button" style="width:160px;" value="'.IMAGE_TEILZAHLUNG.'" onClick="window.location.href=\''.xtc_href_link('distributor_orders.php','action=gen_invoice_process&doID='.$_GET['doID']).'\';">');
		}
		if($order->allow_invoice_we()){
			$smarty->assign('button_generate_invoice_we','<input class="ui-button ui-corner-all ui-state-default" type="button" style="width:160px;" value="'.IMAGE_GENERATE_DISTRIBUTOR_INVOICE.'" onClick="window.location.href=\''.xtc_href_link('distributor_orders.php','action=gen_invoice_we&doID='.$_GET['doID']).'\';">');
		}
	}
	$smarty->assign('send_email_link',xtc_href_link('distributor_orders.php','action=confirm_email&doID='.$_GET['doID']));
	$smarty->assign('print_order_link',xtc_href_link('print_distributor_order.php','doID='.$_GET['doID']));
	$smarty->assign('print_packingslip_link',xtc_href_link('print_distributor_packingslip.php','doID='.$_GET['doID']));
	$smarty->assign('button_back_link',xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action'))));
	
	$smarty->assign(array(
	    'comments_visible'=>xtc_db_prepare_input($order->info['comments_visible']),
	    'comments_visible_edit_link'=>xtc_href_link('distributor_orders.php','action=edit_comments_visible&doID='.$_GET['doID']),
	));
	
	$history_array = array();
	$orders_history_query = xtc_db_query("select orders_status_id, date_added, customer_notified, comments,editor_id from distributor_orders_status_history where distributor_orders_id = '" . xtc_db_input($oID) . "' order by date_added DESC");
	if (xtc_db_num_rows($orders_history_query)) {
		while ($orders_history = xtc_db_fetch_array($orders_history_query)) {
			$history = array();  
			$history['date_added'] = xtc_datetime_short($orders_history['date_added']);
			if ($orders_history['customer_notified'] == '1') {
				$history['notified'] = xtc_image(DIR_WS_ICONS . 'tick.gif', ICON_TICK);
			} else {
				$history['notified'] = xtc_image(DIR_WS_ICONS . 'cross.gif', ICON_CROSS);
			}
			$history['status'] = $orders_status_array[$orders_history['orders_status_id']];
			$history['comments'] = nl2br(xtc_db_output($orders_history['comments']));
			$history['editor'] = xtc_get_editor_name($orders_history['editor_id']);
			$history_array[] = $history;
		}
		$smarty->assign('history_array',$history_array);
	}
} elseif (isset($_GET['action']) and $_GET['action'] == 'gen_invoice_we') {
    $doID = xtc_db_prepare_input($_GET['doID']);
    $order = new distributor_order($doID);
	$smarty->assign('gen_invoice_mode',1);
	$smarty->assign('oID',$doID);
	$smarty->assign('currency',$order->info['currency']);
	$smarty->assign('date_created',yes_strftime('%d.%m.%Y',strtotime($order->info['date_saved'])));
	$smarty->assign('orders_status',xtc_get_distributor_orders_status_name($order->info['orders_status']));
	$smarty->assign('backlink','<a href="' . xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action'))) . '">' . xtc_image_button('button_back.gif', IMAGE_BACK) . '</a>');
	for($i=0;$i<sizeOf($order->products);$i++){
		if($item['stuecklisten_id'] == 0){
			$invoice_qty_array = array();
			for($j=0;$j<=($item['qty_rueckbuch']-$item['rueckbuch_invoice_qty']);$j++){
				$invoice_qty_array[] = array('id'=>$j,'text'=>$j.' Stk.');
			}
			$item['invoice_qty_select'] = xtc_draw_pull_down_menu('invoice_qty_'.$item['id'],$invoice_qty_array,1);
		}
	}
	$smarty->assign('products',$order->products);
	$smarty->assign('invoice_form',xtc_draw_form('gen_invoice_we','distributor_orders.php',xtc_get_all_get_params(array('action')).'action=gen_invoice_we_process'));
} elseif (isset($_GET['action']) and $_GET['action'] == 'custom_action') {

   include('orders_actions.php');
   $fetch_html = false;
} else {
	$pID = (isset($_REQUEST['pID'])) ? (int)xtc_db_input($_REQUEST['pID']) : '';
	$smarty->assign('pid_form',xtc_draw_form('pid', 'distributor_orders.php', xtc_get_all_get_params(array('pID')),'get','class="yesForm"' ));
	$smarty->assign('orders_form',xtc_draw_form('orders', 'distributor_orders.php', '', 'get','class="yesForm"'));
	$smarty->assign('input_doID',xtc_draw_input_field('doID', '', 'size="12"'));
	$smarty->assign('input_pID',xtc_draw_input_field('pID', $pID, 'size="12"'));
	$smarty->assign('input_action',xtc_draw_hidden_field('action', 'edit').xtc_draw_hidden_field(xtc_session_name(), xtc_session_id()));
	$smarty->assign('status_form',xtc_draw_form('status', 'distributor_orders.php', '', 'get','class="yesForm"'));
	$smarty->assign('input_status',xtc_draw_pull_down_menu('status', $orders_statuses, ((isset($_GET['status']))?$_GET['status']:DISTRIBUTOR_ORDERS_STATUS_OFFEN), 'onChange="this.form.submit();"').xtc_draw_hidden_field(xtc_session_name(), xtc_session_id()));
        $status_array = [];
        $items = \YES4Trade\Model\distributor_orders_status::get_by_language_id((int)$_SESSION['languages_id']);
        foreach($items as $it){
            $status_array[] = array(
                'id'=>$it->orders_status_id,
                'text'=>$it->orders_status_name
            );
	}
	$smarty->assign('change_form',xtc_draw_form('change_orders','distributor_orders.php',xtc_get_all_get_params(array('action')).'action=change_orders','POST'));
	if (isset($_GET['dID'])) {
		$dID = xtc_db_prepare_input($_GET['dID']);
		$orders_query_raw = "select d.name,do.*,d.id, ds.orders_status_name, dot.text as order_total from distributor_orders do left join distributor_orders_total dot on (do.distributor_orders_id = dot.orders_id), distributor_orders_status ds,distributors d ";
		if(!empty($pID) and (int)$pID > 0){
		    $orders_query_raw .= ", distributor_orders_products dop ";
		}
		$orders_query_raw .= " where d.id=do.distributor_id && do.distributor_id = '" . xtc_db_input($dID) . "' and do.orders_status = ds.orders_status_id and ds.language_id = '" . $_SESSION['languages_id'] . "' and dot.class = 'ot_total' ";
		if(!empty($pID) and (int)$pID > 0){
		    $orders_query_raw .= sprintf(
			" and dop.products_id='%s' and dop.distributor_orders_id=do.distributor_orders_id and dop.distributor_orders_products_id IS NOT NULL ",
			$pID
		    );
		}
		$orders_query_raw .= " order by do.distributor_orders_id DESC";
	} elseif (isset($_REQUEST['status']) && !isset($_GET['dID'] )) {
		$status = xtc_db_prepare_input($_GET['status']);
		$orders_query_raw = "select d.name,do.*,d.id, ds.orders_status_name, dot.text as order_total from distributor_orders do left join distributor_orders_total dot on (do.distributor_orders_id = dot.orders_id), distributor_orders_status ds,distributors d ";
		if(!empty($pID) and (int)$pID > 0){
		    $orders_query_raw .= ", distributor_orders_products dop ";
		}
		$orders_query_raw .= "where d.id=do.distributor_id && do.orders_status = '" . xtc_db_input($status) . "' and do.orders_status = ds.orders_status_id and ds.language_id = '" . $_SESSION['languages_id'] . "' and dot.class = 'ot_total' ";
		if(!empty($pID) and (int)$pID > 0){
		    $orders_query_raw .= sprintf(
			" and dop.products_id='%s' and dop.distributor_orders_id=do.distributor_orders_id and dop.distributor_orders_products_id IS NOT NULL ",
			$pID
		    );
		}
		$orders_query_raw .= " order by do.distributor_orders_id DESC";
	//      $orders_query_raw = "select c.customers_ebay_userid,o.is_parent,o.orders_status,o.ebay_id,o.orders_id,o.payment_method, o.customers_id,o.customers_name, o.payment_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from distributor_orders o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . TABLE_ORDERS_STATUS . " s,customers c where c.customers_id=o.customers_id && o.orders_status = s.orders_status_id and s.language_id = '" . $_SESSION['languages_id'] . "' and s.orders_status_id = '" . xtc_db_input($status) . "' and ot.class = 'ot_total' order by o.orders_id DESC";
	} else {
		$status = DISTRIBUTOR_ORDERS_STATUS_OFFEN;
		$orders_query_raw = "select d.name,do.*,d.id, ds.orders_status_name, dot.text as order_total from distributor_orders do left join distributor_orders_total dot on (do.distributor_orders_id = dot.orders_id), distributor_orders_status ds,distributors d ";
		if(!empty($pID) and (int)$pID > 0){
		    $orders_query_raw .= ", distributor_orders_products dop ";
                    
		}
		$orders_query_raw .= "where d.id=do.distributor_id ";
		if(!empty($pID) and (int)$pID > 0){
                    
                }else{
                    // wenn pID dann kein Statusfilter
                    $orders_query_raw .= " and do.orders_status = '" . xtc_db_input($status) . "' ";
                }
                $orders_query_raw .= " and do.orders_status = ds.orders_status_id and ds.language_id = '" . $_SESSION['languages_id'] . "' and dot.class = 'ot_total'";
		if(!empty($pID) and (int)$pID > 0){
		    $orders_query_raw .= sprintf(
			" and dop.products_id='%s' and dop.distributor_orders_id=do.distributor_orders_id and dop.distributor_orders_products_id IS NOT NULL ",
			$pID
		    );
		}
		$orders_query_raw .= " order by do.distributor_orders_id DESC";
	}
	$orders_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $orders_query_raw, $orders_query_numrows);
	$orders_query = xtc_db_query($orders_query_raw);
	$orders_array = array();
	while ($orders = xtc_db_fetch_array($orders_query)) {
		$o = array();
		
		$context_menu = new context_menu('distributor_order',$orders['distributor_orders_id'],$_SESSION['customer_id'],$admin_access);
		$o['content_menu_link'] = $context_menu->get_default_element_html();
		
		
		if ((( !isset($_GET['doID']) ) || ($_GET['doID'] == $orders['distributor_orders_id'])) && (!isset($oInfo))) {
			$oInfo = new objectInfo($orders);
		}
		if ( (isset($oInfo) and is_object($oInfo)) && ($orders['distributor_orders_id'] == $oInfo->distributor_orders_id) ) {
			$o['tr'] = '              <tr onmouseover="this.style.cursor=\'hand\'" class="ui-state-highlight">' . "\n";
		} else {
			$o['tr'] = '              <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('doID')).'doID='.$orders['distributor_orders_id'] ) . '\'">' . "\n";
		}
		$o['input_statusOID'] = xtc_draw_checkbox_field('statusOID[]',$orders['distributor_orders_id']);
		$o['distributor_link'] = '<a href="'.xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('doID')) . 'doID=' . $orders['distributor_orders_id']).'">['.$orders['distributor_id'].'] ' . $orders['distributor_name'].'</a>';

		if(isset($_GET['dID']) and $_GET['dID']>0){
			$shippings = 0;
			$order = new distributor_order($orders['distributor_orders_id']);
			for($a=0;$a<sizeOf($order->totals);$a++){
				switch($order->totals[$a]['class']){
					case 'ot_total':
						$o['ot_total'] = xtc_draw_hidden_field('ototal_'.$orders['distributor_orders_id'],$order->totals[$a]['value'] ); 
						break;
					case 'ot_tax':
						$o['otax'] = xtc_draw_hidden_field('otax_'.$orders['distributor_orders_id'],$order->totals[$a]['value'] ); 
						break;
					case 'ot_shipping':
						$o['oship'] = xtc_draw_hidden_field('oship_'.$orders['distributor_orders_id'].'_'.$shippings,$order->totals[$a]['value'] ); 
						$shippings++;
						break;
					case 'ot_subtotal':
						$o['osubtotal'] = xtc_draw_hidden_field('osubtotal_'.$orders['distributor_orders_id'],$order->totals[$a]['value'] ); 
						break;
				}
			}
		}
		$o['distributor_orders_id'] = $orders['distributor_orders_id'];
		$o['order_total'] = strip_tags($orders['order_total']);
		$o['orders_status_name'] = $orders['orders_status_name'];
		$o['estimated_date_receipt'] = xtc_date_short($orders['estimated_date_receipt']);
		$o['date_receipt'] = xtc_date_short($orders['date_receipt']);
		if ( (isset($oInfo) and is_object($oInfo)) && ($orders['distributor_orders_id'] == $oInfo->distributor_orders_id) ) {
			$o['edit_action'] = xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', ''); 
		} else { 
			$o['edit_action'] = '<a href="' . xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('doID', 'action')) . 'doID=' . $orders['distributor_orders_id'] . '&action=edit') . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; 
		}
		$orders_array[] = $o;
	}
	$smarty->assign('orders_array',$orders_array);
	$smarty->assign('split',$orders_split->display_count($orders_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ORDERS,xtc_get_all_get_params(array('page', 'doID', 'action'))).'<br>'.$orders_split->display_links($orders_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page', 'doID', 'action'))));
	$add_html = '</td>';
	$heading = array();
	$contents = array();
	$action = (isset($_GET['action'])) ? $_GET['action'] : '';
	switch ($action) {
		default:
			if (is_object($oInfo)) {
				$heading[] = array('text' => '<b>[' . $oInfo->distributor_orders_id . ']&nbsp;&nbsp;' . xtc_datetime_short($oInfo->date_created) . '</b>');
                                
                                $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_DISTRIBUTOR_ORDERS_EDIT, xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('doID', 'action')) . 'doID=' . $oInfo->distributor_orders_id . '&action=edit'), 'width: 160px;'));
                                $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_DISTRIBUTOR_ORDERS_ADD, xtc_href_link('distributor.php', xtc_get_all_get_params(array('dID', 'action')) . 'dID=' . $oInfo->distributor_id . '&action=new_order'), 'width: 160px;'));
				$contents[] = array('align' => 'left', 'text' => '<b>'.TEXT_DISTRIBUTOR_NAME.'</b> '.xtc_db_prepare_input($oInfo->name));
				$contents[] = array('align' => 'left', 'text' => '<a href="' . xtc_href_link('distributor_orders.php', 'dID=' . $oInfo->distributor_id). '"><u>'.TEXT_SHOW_ALL_DISTRIBUTOR_ORDERS.'</u></a>');
				$contents[] = array('text' => '<br />'.TEXT_DISTRIBUTOR_ORDER_DATE_CREATED.' ' . xtc_date_short($oInfo->date_created));
				if (xtc_not_null($oInfo->last_modified)) $contents[] = array('text' => TEXT_DISTRIBUTOR_ORDER_DATE_CHANGED.' ' . xtc_date_short($oInfo->last_modified));
				// elari added to display product list for selected order
				$order = new distributor_order($oInfo->distributor_orders_id);
				$contents[] = array('text' => '<br><br>' . sizeof($order->products) . ' Products ' );
				for ($i=0; $i<sizeof($order->products); $i++) {
                                    $item = $order->products[$i];
                                    $contents[] = array('text' => $item['qty'] . '&nbsp;x' . $item['name']);
				}
				if($admin_access['distributor'] == 1){
				    $contents[] = array('text' => '<br /><b>'.TEXT_DISTRIBUTOR_ORDER_TOTAL_SUM.'</b>');
				    for ($i=0; $i<sizeof($order->totals); $i++) {
					    $contents[] = array('text' => $order->totals[$i]['title'] . ':&nbsp;' . $order->totals[$i]['text']);
				    }
				}
			}// end if object oInfo
		break;
	} // end switch action

	if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
		$add_html .= '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";
		$box = new box;
		$add_html .= $box->infoBox($heading, $contents);
		$add_html .= '            </td>' . "\n";
	}
	$add_html .= '
          </tr>
        </table></td>
      </tr>';
} // end if action != edit or gen_invoice_we or custom_action



if($fetch_html){
	$buttons = array();
	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	switch($action){
	    case 'gen_invoice_we':
		$smarty->assign('HEADING_TITLE',sprintf(HEADING_TITLE_GEN_INVOICE,$_REQUEST['doID'],yes_strftime('%d.%m.%Y',strtotime($order->info['date_saved']))));
		$buttons[] = array('text'=>IMAGE_BACK,
		    'link'=>xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action'))),
		    'lbOn'=>false,
		    'auth'=>true
		);
		break;
	    case 'edit':
		$smarty->assign('HEADING_TITLE',sprintf(HEADING_TITLE,$_REQUEST['doID'],yes_strftime('%d.%m.%Y',strtotime($order->info['date_saved']))));
		$smarty->assign('ADDITIONAL_TITLE',TEXT_STATUS.' '.  xtc_get_distributor_orders_status_name($order->info['orders_status']));
		$buttons[] = array('text'=>IMAGE_BACK,
		    'link'=>xtc_href_link('distributor_orders.php', xtc_get_all_get_params(array('action'))),
		    'lbOn'=>false,
		    'auth'=>true
		);
                $buttons[] = array('text'=>ADD_QUICKNOTE,
                        'link'=>'javascript:void(toggleBox(\'addquicknote\'))',
                        'lbOn'=>false,
                        'auth'=>true
                );
		    
		if($order->info['orders_status'] != DISTRIBUTOR_ORDERS_STATUS_STORNIERT){
		    $buttons[] = array('text'=>IMAGE_EDIT,
			'link'=>xtc_href_link('distributor_orders_edit.php', 'doID='.$_GET['doID'].'&dID=' . $order->distributor['ID']),
			'lbOn'=>false,
			'auth'=>($admin_access['distributor_orders_edit'] == '1') ? true : false
		    );
		}
		$buttons[] = array('text'=>IMAGE_DISTRIBUTOR_SRM,
		    'link'=>xtc_href_link('distributor.php', 'dID=' . $order->distributor['ID'].'&action=edit'),
		    'lbOn'=>false,
		    'auth'=>($admin_access['distributor'] == '1') ? true : false
		);
		$buttons[] = array('text'=>TEXT_CSV_IMPORT,
		    'link'=>xtc_href_link('distributor_orders.php',xtc_get_all_get_params(array('action')).'action=cvs_import'),
		    'lbOn'=>true,
		    'auth'=>($admin_access['f_distributor_order_allocation'] == '1') ? true : false
		);
		if($order->info['orders_status'] == DISTRIBUTOR_ORDERS_STATUS_EINGETROFFEN){
                    $buttons[] = array('text'=>TEXT_DISTRIBUTOR_ORDER_ALLOCATION,
                        'link'=>xtc_href_link('storage.php',xtc_get_all_get_params(array('action')).'action=distributor_order_allocation'),
                        'lbOn'=>false,
                        'auth'=>true
                    );
                }
                
		$mod_att = new module_attachments('distributor_order', (int)xtc_db_input($_GET['doID']));
		$buttons[] = array(
		    'text'=>$mod_att->get_button_text(),
		    'link'=>$mod_att->get_button_link(),
		    'add_css_class'=>'module_attachments_button',
		    'lbOn'=>true,
		    'auth'=>true
		);

		break;
	    default:
		$smarty->assign('HEADING_TITLE',HEADING_TITLE_LISTING);
		break;
	}
	
	$smarty->assign(array(
	    'JS_CONFIRM_REALLY_SET_NEW_STATUS'=>JS_CONFIRM_REALLY_SET_NEW_STATUS,
	    'JS_CONFIRM_REALLY_SET_NEW_STATUS_MULTI'=>JS_CONFIRM_REALLY_SET_NEW_STATUS_MULTI,
	    'JS_ALERT_NO_INVOICES_SELECTED'=>JS_ALERT_NO_INVOICES_SELECTED,
	    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	    'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER,
	    'TEXT_SEARCH_PID'=>TEXT_SEARCH_PID,
	    'TEXT_SEARCH_DOID'=>TEXT_SEARCH_DOID,
	    'TEXT_SEARCH_STATUS'=>TEXT_SEARCH_STATUS,
	));
    echo $smarty->fetch('distributor_orders.html');
    if(isset($add_html))
	echo $add_html;
}
?>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
