<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
include('includes/application_top.php');
require_once('includes/classes/class.ebaymail.php');
require_once('includes/classes/order.php');
//require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'xtc_php_mail.inc.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_INC . 'yes_customers_email_alias_functions.inc.php');
// anzeigen
function _get_icon($type){
	$part = explode('/',$type);
	if(isset($part[1])){
		switch($part[1]){
			case 'png':
				$part[1] = 'gif';
				break;
		}
		if(is_file('images/icons/icon_'.$part[1].'.gif'))
			return 'images/icons/icon_'.$part[1].'.gif';
	}
	return 'images/icons/file.gif';
}

$epage = (isset($_REQUEST['epage']))?$_REQUEST['epage']:'';
$abonded_years = 2;
define('MAIL_LIMIT', MAX_DISPLAY_SEARCH_RESULTS);
$smarty = new yesSmarty;

$base_get_params = xtc_get_all_get_params(array('action','action2','eId','id')); // ,'scID','sebayID','semail','ssubject','sbody','sboth','startDate'
// falls keine get parameter vorhanden sind, setze ich einfach
// einen parameter, damit im Template dynamische parameter mit
// &var=val hinzugefuegt werden koennen ohne umstaendlich zu pruefen
if(empty($base_get_params)) {
	$base_get_params = '?menugroup=interfaces';
}
$smarty->assign(array(
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'FORM_END'=>'</form>',
    'BASELINK'=>xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params),
    'JS_CONFIRM_REALLY_UNALLOCATION'=>JS_CONFIRM_REALLY_UNALLOCATION
));

$box = (isset($_REQUEST['box'])) ? $_REQUEST['box'] : '';
$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';
$action2 = isset($_REQUEST['action2']) ? $_REQUEST['action2'] : '';

if( empty($action) ) $action = 'inbox';
if( $action2 == 'del' or $action2 == 'save_multi')
	$action = $action2;

switch($action){
    case 'set_staff_allocation_read_status':
        $email_staff_allocation_history_id = (int)xtc_db_input($_GET['email_staff_allocation_history_id']);
        email_staff_allocation::set_history_read_status($email_staff_allocation_history_id, 1);
        exit;
        break;
    case 'add_staff_comment':
        $eID = (int)xtc_db_input($_GET['id']);
        if(strlen(trim($_GET['staff_comments'])) < 1){
            die(json_encode(array(
                'MSG'=>MSG_ERROR_ADD_STAFF_COMMENTS
            )));
        }
        $comments = xtc_db_input(trim($_GET['staff_comments']));
        email_staff_allocation::add_history($eID,$comments);
        die(json_encode(array(
            'MSG'=>'',
            'DATE_ADDED'=>xtc_date_short(date('Y-m-d')),
            'EDITOR'=> xtc_get_editor_name($_SESSION['customer_id'])
        )));
        break;
    case 'staff_remove':
        $esaID = (int)xtc_db_input($_GET['esaID']);
        $email_staff_allocation = new email_staff_allocation($esaID);
        if((int)$email_staff_allocation->getEmail_id() < 1){
            die(json_encode(array(
                'ERROR'=>MSG_ERROR_STAFF_ALLOCATION_DOESNT_EXISTS
            )));
        }
        $email_staff_allocation->delete();
        die(json_encode(array(
            'ERROR'=>''
        )));
        break;
    case 'staff_add':
        $cID = (int)xtc_db_input($_GET['cID']);
        $eID = (int)xtc_db_input($_GET['eID']);
        $email_staff_allocation = new email_staff_allocation;
        if(!$email_staff_allocation->add($eID,$cID)){
            die(json_encode(array(
                'ERROR'=>MSG_ERROR_STAFF_ALLOCATION_EXISTS
            )));
        }
        die(json_encode(array(
            'ERROR'=>'',
            'ALLOCATION_LINK_TITLE_TEXT'=>$email_staff_allocation->get_allocation_link_title($eID)
        )));
        exit;
        break;
    case 'staff_allocation':
        $id = (int)xtc_db_input($_GET['id']);
		try{
        	$email = new DBmail($id,false,true);
		}catch(Exception $e){
			die('Email ID '.$id.' not found.<br /><i>'.$e->getMessage().'</i>');
		}
        $email_staff_allocation = new email_staff_allocation;
        $smarty->assign(array(
            'STAFFS'=>$email_staff_allocation->get_customers(),
            'ALLOCATIONS'=>$email->get_staff_allocations(),
            'EMAIL_ID'=>$id,
            'JS_CONFIRM_STAFF_ALLOCATION_DELETE'=>JS_CONFIRM_STAFF_ALLOCATION_DELETE,
            'HISTORY'=>$email_staff_allocation->get_history($id),
            'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
            'TEXT_STAFF_EMAIL_ADD_COMMENT'=>TEXT_STAFF_EMAIL_ADD_COMMENT,
            'EMAIL'=>$email,
        ));
        $smarty->display('email_staff_allocation.html');
        exit;
        break;
    case 'search_order':
        if(!isset($_GET['q']) or strlen(trim($_GET['q'])) < 3){
            die(json_encode(array(
                'ERROR'=>'Invalid search string'
            )));
        }
        $orders = array();
        $q = xtc_db_input($_GET['q']);
        switch($_GET['mode']){
            case 'amazon_order_id':
                $query = xtc_db_query(sprintf(
                        "SELECT orders_id FROM amazon_orders WHERE orig_amazon_orders_id='%s'",
                        $q
                ));
                while($record = xtc_db_fetch_array($query)){
                    $orders[ $record['orders_id'] ] = true;
                }
                break;
        }
        die(json_encode(array(
            'ERROR'=>'',
            'ORDERS'=>$orders
        )));
        break;
    case 'allocate_order':
		$text = '';
		$msg = '';
		$id = (int)xtc_db_input($_REQUEST['id']);
        $allocation_status_change = false;
        $email = new DBmail($id,false,true);
        $allocate_customer = (isset($_GET['allocate_customer']) and $_GET['allocate_customer'] == 1) ? true : false;
		if((int)$_REQUEST['orders_id'] < 1){
            $update_sql_array = array(
				'id'=>intval($id),
                'orders_id'=>0,
            );
            if($allocate_customer){
                $update_sql_array['customers_id'] = 0;
            }
            if($email->ebay_id == '' and $update_sql_array['allocation_status'] == \YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1){
                $update_sql_array['allocation_status'] = \YES4Trade\Model\ebay_emails::ALLOCATION_STATUS0;
                $allocation_status_change = true;
            }
			\YES4Trade\Model\ebay_emails::update_ebay_email($update_sql_array);
	    	$text = TEXT_ORDER_ALLOCATION;
		}else{
			$orders_id = (int)xtc_db_input($_REQUEST['orders_id']);
			if($orders_id < 1){
				$msg = sprintf(TEXT_ORDER_ALLOCATION_ERROR_ORDERS_ID,$orders_id);
			}else{
				$query = xtc_db_query(sprintf(
					"SELECT orders_id,customers_id FROM orders WHERE orders_id='%s'",
					$orders_id
				));
				if(!xtc_db_num_rows($query)){
					$msg = sprintf(TEXT_ORDER_ALLOCATION_ERROR_ORDERS_ID,$orders_id);
				}else{
					$record = xtc_db_fetch_array($query);
					if($email->allocation_status == 0){
						$allocation_status_change = true;
					}
					$update_sql_array = array(
						'id'=>intval($id),
						'orders_id'=>intval($orders_id),
						'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1
					);
					if($allocate_customer){
						$update_sql_array['customers_id'] = intval($record['customers_id']);
					}
					\YES4Trade\Model\ebay_emails::update_ebay_email($update_sql_array);
					$text = sprintf(TEXT_EXISTING_ORDER_ALLOCATION,$orders_id);
				}
			}
		}
        if(isset($_REQUEST['redirect']) and !empty($_REQUEST['redirect'])){
            $messageStack->add_session($text, 'success');
            xtc_redirect(xtc_href_link($_REQUEST['redirect']));
        }
		die(json_encode(array(
	    	'MSG'=>$msg,
	   		'TEXT'=>$text,
            'ALLOCATION_STATUS_CHANGE'=>$allocation_status_change
		)));
		break;
    case 'allocate_ebayuser':
		$text = '';
		$msg = '';
		$id = (int)xtc_db_input($_REQUEST['id']);
		if($_REQUEST['ebayuser'] == ''){
			\YES4Trade\Model\ebay_emails::update_ebay_email([
				'ebay_user'=>'',
				'id'=>$id
			]);
			$text = TEXT_EBAYUSER_ALLOCATION;
		}else{
			$ebay_user = xtc_db_input($_REQUEST['ebayuser']);
			if($ebay_user == ''){
				$msg = sprintf(TEXT_EBAYUSER_ALLOCATION_ERROR_EBAYUSER,$ebay_user);
			}else{
				\YES4Trade\Model\ebay_emails::update_ebay_email([
					'ebay_user'=>$ebay_user,
					'id'=>$id
				]);
				$text = sprintf('%s (%s)',TEXT_EBAYUSER_ALLOCATION,$ebay_user);
			}
		}
		die(json_encode(array(
			'MSG'=>$msg,
			'TEXT'=>$text
		)));
		break;
    case "del":
		$eId = $_REQUEST['eId']??null;
		if(is_countable($eId) and sizeOf($eId)>0){
			foreach($eId as $k=>$delID){
				$email = new DBmail( (int)xtc_db_input($delID),false,true);
				$email->delete();
			}
		}
		$messageStack->add_session(MESSAGE_EMAIL_DELETED,'success');
		if(isset($_GET['lastaction'])){
			xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),'action='.$_GET['lastaction']));
		}else{
			xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		}
    	break;
    case "save_multi":
		if(is_countable($_REQUEST['eId']) and sizeOf($_REQUEST['eId']) > 0){
			foreach($_REQUEST['eId'] as $k=>$eId){
				\YES4Trade\Model\ebay_emails::update_ebay_email([
					'saved'=>\YES4Trade\Model\ebay_emails::SAVED1,
					'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
					'id'=>intval($eId)
				]);
			}
			$messageStack->add_session(MESSAGE_EMAIL_MARK_AS_SAVED,'success');
		}else{
			$messageStack->add_session(MESSAGE_NO_EMAIL_SELECTED,'error');
		}
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		break;
    case 'save':
		$eId = (int)xtc_db_input($_REQUEST['eId']);
		\YES4Trade\Model\ebay_emails::update_ebay_email([
			'saved'=>\YES4Trade\Model\ebay_emails::SAVED1,
			'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
			'id'=>intval($eId)
		]);
		$messageStack->add_session(MESSAGE_EMAIL_MARK_AS_SAVED,'success');
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		break;
    case 'unsave':
		$eId = (int)xtc_db_input($_REQUEST['eId']);
		\YES4Trade\Model\ebay_emails::update_ebay_email([
			'saved'=>\YES4Trade\Model\ebay_emails::SAVED0,
			'id'=>$eId
		]);
		$messageStack->add_session(MESSAGE_EMAIL_MARK_AS_OPEN,'success');
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		break;
    case 'spam_process':
		$secure_query = xtc_db_query(sprintf(
			"SELECT customers_id,customers_firstname,customers_lastname FROM %s WHERE customers_email_address='%s'",
			TABLE_CUSTOMERS,xtc_db_input($_REQUEST['email'])
		));
		if(xtc_db_num_rows($secure_query)){
			$secure = xtc_db_fetch_array($secure_query);
			$messageStack->add_session(sprintf(MSG_ERROR_SPAM_MAIL_EXISTS_AS_USER,
				$_REQUEST['email'],
				$secure['customers_firstname'],
				$secure['customers_lastname']
			),'error');
		}else{
			$id_array = array();
			$ee_items = \YES4Trade\Model\ebay_emails::filter([
				'from_email'=>$_REQUEST['email']
				],['id']
			);
			foreach($ee_items as $ee){
				$id_array[] = intval($ee->id);
			}
			foreach($id_array as $id){
				$email = new DBmail($id,false,true);
				$email->delete();
			}
			$messageStack->add_session(sprintf(MSG_SUCCESS_SPAM_FILTER,sizeOf($id_array),$_REQUEST['email']),'success');
		}
        xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		break;
    case 'allocate_now':
		$id = (int)xtc_db_input($_REQUEST['id']);
		$customers_id = intval($_REQUEST['cID']??0);
		if($id<1){
			xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		}
		if($customers_id > 0 and isset($_REQUEST['save_alias']) and intval($_REQUEST['save_alias']) == 1){
			$dbm = new DBmail($id,false);
			if(!yes_add_customers_email_alias($dbm->getFrom_email(-1,false),$customers_id,$_SESSION['customer_id'])){
				$messageStack->add_session(sprintf(MSG_ERROR_EMAIL_ALIAS_SAVE,$dbm->getFrom_email(-1,false),'error'));
			}
		}
		$ebay_id = $_REQUEST['ebayID']??'';
		$ebay_user = '';
		if($customers_id > 0){
			$cst = \YES4Trade\Model\customers::get_by_customers_id($customers_id,[
				'customers_ebay_userid'
			]);
			if($cst !== null){
				$ebay_user = $cst->customers_ebay_userid;
			}
		}
		\YES4Trade\Model\ebay_emails::update_ebay_email([
			'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1, 
			'saved' => (isset($_REQUEST['save']) and intval($_REQUEST['save'])==1) ? \YES4Trade\Model\ebay_emails::SAVED1 : \YES4Trade\Model\ebay_emails::SAVED0,
			'customers_id'=>$customers_id,
			'ebay_user'=>$ebay_user,
			'ebay_id'=>$ebay_id,
			'id'=>$id
		]);
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		break;
    case 'allocation':
		$mail = new DBmail( (int)xtc_db_input($_REQUEST['id']) );
		$view = $mail->filter();
		$m1 = '<span style="background-color:yellow;">';
		$m2 = '</span>';
		$zaehler = 0;

		$_double_customers = array();
		$_double_auctions = array();
		foreach($view as $class=>$match){
			switch($class){
				case 'email':
					foreach($match as $value => $muell){
						$customers_query = xtc_db_query("SELECT c.customers_id,c.customers_email_address,c.customers_firstname,c.customers_lastname, ab.entry_company,ab.entry_street_address,ab.entry_postcode,ab.entry_city FROM customers c LEFT JOIN address_book ab USING(customers_id) WHERE LOWER(c.customers_email_address) = '".xtc_db_prepare_input($value)."'");
						// BOF - customers_email_aliases
						if(!xtc_db_num_rows($customers_query)){
							$customers_query = xtc_db_query("SELECT c.customers_id,cea.email_address,c.customers_firstname,c.customers_lastname, ab.entry_company,ab.entry_street_address,ab.entry_postcode,ab.entry_city FROM customers_email_aliases cea LEFT JOIN customers c USING(customers_id) LEFT JOIN address_book ab USING(customers_id) WHERE LOWER(cea.email_address) = '".xtc_db_prepare_input($value)."'");
						}
						// EOF - customers_email_aliases
						while($customers = xtc_db_fetch_array($customers_query)){
							$cID = $customers['customers_id'];
							if(!in_array($cID,$_double_customers)){
								$OUT[$zaehler]['input_class'] = xtc_draw_radio_field('cID',$cID);
								$OUT[$zaehler]['classname'] = 'Email';
								$OUT[$zaehler]['nummer'] = 'Kd-Nr: '.$cID.'<br><a target="_blank" href="customers.php?action=crm&cID='.$cID.'"><u>'.$customers['customers_email_address'].'</u></a>';
								$OUT[$zaehler]['titel'] = (($customers['entry_company']!='')?$customers['entry_company'].'<br>':'') . $customers['customers_firstname'] .' '. $customers['customers_lastname'];
								$OUT[$zaehler]['detail'] = $customers['entry_street_address'].', '. $customers['entry_postcode'].' '.$customers['entry_city'];
								$OUT[$zaehler]['row_color'] = '#CFCFCF';
								$OUT[$zaehler]['radio_color'] = '#00FF00';
								$zaehler++;
								$_double_customers[] = $cID;
							}
						}
					}
					break;
				case 'ebay_id':
					foreach($match as $value => $muell){
						if(!in_array($value,$_double_auctions)){
							$OUT[$zaehler]['input_class'] = xtc_draw_radio_field('ebayID',$value);
							$OUT[$zaehler]['classname'] = 'Auktion';
							$OUT[$zaehler]['nummer'] = 'Auktion: '.$value;
							$ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($value,['title']);
							$ebay_title = ($ea !== null) ? $ea->title : '';
							$OUT[$zaehler]['titel'] = $ebay_title;
							$OUT[$zaehler]['detail'] = '';
							$OUT[$zaehler]['row_color'] = '#FCFCFC';
							$OUT[$zaehler]['radio_color'] = '#0000FF';
							$_double_auctions[] = $value;
							$zaehler++;
						}
					}
					break;
				case 'ebay_user':
					foreach($match as $value => $muell){
						$customers_query = xtc_db_query("SELECT c.customers_id,c.customers_email_address,c.customers_firstname,c.customers_lastname, ab.entry_company,ab.entry_street_address,ab.entry_postcode,ab.entry_city FROM customers c LEFT JOIN address_book ab USING(customers_id) WHERE LOWER(c.customers_ebay_userid) = '".xtc_db_prepare_input($value)."'");
						while($customers = xtc_db_fetch_array($customers_query)){
							$cID = $customers['customers_id'];
							if(!in_array($cID,$_double_customers)){
								$OUT[$zaehler]['input_class'] = xtc_draw_radio_field('cID',$cID);
								$OUT[$zaehler]['classname'] = 'Ebayname';
								$OUT[$zaehler]['nummer'] = 'Kd-Nr: '.$cID.'<br><a target="_blank" href="customers.php?action=crm&cID='.$cID.'"><u>'.$customers['customers_email_address'].'</u></a>';
								$OUT[$zaehler]['titel'] = (($customers['entry_company']!='')?$customers['entry_company'].'<br>':'') . $customers['customers_firstname'] .' '. $customers['customers_lastname'];
								$OUT[$zaehler]['detail'] = $customers['entry_street_address'].', '. $customers['entry_postcode'].' '.$customers['entry_city'];
								$OUT[$zaehler]['row_color'] = '#CFCFCF';
								$OUT[$zaehler]['radio_color'] = '#00FF00';
								$zaehler++;
								$_double_customers[] = $cID;
							}
						}
					}
					break;
				case 'hitmeister_id_order':
					foreach($match as $value => $muell){
						$customers_query = xtc_db_query("SELECT c.customers_id,c.customers_email_address,c.customers_firstname,c.customers_lastname, ab.entry_company,ab.entry_street_address,ab.entry_postcode,ab.entry_city FROM hitmeister_orders ho LEFT JOIN orders o USING(orders_id) LEFT JOIN  customers c USING(customers_id) LEFT JOIN address_book ab USING(customers_id) WHERE ho.hitmeister_id_order LIKE '".xtc_db_prepare_input($value)."'");
						while($customers = xtc_db_fetch_array($customers_query)){
							$cID = $customers['customers_id'];
							if(!in_array($cID,$_double_customers)){
								$OUT[$zaehler]['input_class'] = xtc_draw_radio_field('cID',$cID);
								$OUT[$zaehler]['classname'] = 'HitmeisterIDOrder';
								$OUT[$zaehler]['nummer'] = 'Kd-Nr: '.$cID.'<br><a target="_blank" href="customers.php?action=crm&cID='.$cID.'"><u>'.$customers['customers_email_address'].'</u></a>';
								$OUT[$zaehler]['titel'] = (($customers['entry_company']!='')?$customers['entry_company'].'<br>':'') . $customers['customers_firstname'] .' '. $customers['customers_lastname'];
								$OUT[$zaehler]['detail'] = $customers['entry_street_address'].', '. $customers['entry_postcode'].' '.$customers['entry_city'];
								$OUT[$zaehler]['row_color'] = '#CFCFCF';
								$OUT[$zaehler]['radio_color'] = '#00FF00';
								$zaehler++;
								$_double_customers[] = $cID;
							}
						}
					}
					break;
			}
			$zaehler++;
		}
		$order_allocation_text = TEXT_ORDER_ALLOCATION;
		if($mail->orders_id > 0){
			$order_allocation_text = sprintf(TEXT_EXISTING_ORDER_ALLOCATION,$mail->orders_id);
		}
		if( strpos($mail->getFrom_name(-1, false),'eBay -')!== false){
			if(!sizeOf(yes_get_customers_email_alias_data_by_email_address($mail->from_email))){
				$smarty->assign('EBAY_EMAIL_ALIAS_ALLOW',1);
			}
			$parts = explode('eBay - ',$mail->getFrom_name(-1));
			$smarty->assign('DETECTED_EBAYUSER', strip_tags($parts[1]));
			
		}
		
		$smarty->assign(array(
			'FORM' => xtc_draw_form('matches',basename($_SERVER['PHP_SELF']),'action=allocate_now&id='.xtc_db_input($_REQUEST['id']).'&'.$base_get_params),
			'ITEMS'=>$OUT,
			'BODY'=>$mail->body,
			'SUBJECT'=>$mail->subject,
			'EMAIL_ID'=>(int)xtc_db_input($_REQUEST['id']),
			'FROM_EMAIL_ADDRESS'=>$mail->getFrom_email(-1, false),
			'TEXT_CLOSE_AFTER_FILTER'=>TEXT_CLOSE_AFTER_FILTER,
			'TEXT_NO_FILTER_MATCHES'=>TEXT_NO_FILTER_MATCHES,
			'TEXT_CUSTOMERSEARCH'=>TEXT_CUSTOMERSEARCH,
			'TEXT_HEADER_SEARCH_CUSTOMERS_NAME_PAIR_INTRO'=>TEXT_HEADER_SEARCH_CUSTOMERS_NAME_PAIR_INTRO,
			'TEXT_HEADER_SEARCH_CUSTOMERS_INTRO'=>TEXT_HEADER_SEARCH_CUSTOMERS_INTRO,
			'TEXT_ADD_EMAIL_ALIAS'=>sprintf(TEXT_ADD_EMAIL_ALIAS,$mail->getFrom_email()),
			'TEXT_ORDER_ALLOCATION'=>$order_allocation_text,
			'TEXT_ORDER_ALLOCATION_INPUT'=>TEXT_ORDER_ALLOCATION_INPUT,
			'TEXT_EBAYUSER_ALLOCATION_INPUT'=>TEXT_EBAYUSER_ALLOCATION_INPUT,
			'TEXT_EBAYUSER_ALLOCATION'=>TEXT_EBAYUSER_ALLOCATION,
			'ALLOCATED_EBAY_USER'=>$mail->getEbayUser(),
			'TEXT_ORDER_ALLOCATION_ALLOCATE_USER'=>TEXT_ORDER_ALLOCATION_ALLOCATE_USER,
			'TEXT_ORDER_ALLOCATION_UNALLOCATE_INFO'=>TEXT_ORDER_ALLOCATION_UNALLOCATE_INFO,
			'TEXT_EMAIL_ALLOCATION_CHANGED'=>TEXT_EMAIL_ALLOCATION_CHANGED,
			'TEXT_ORDERSEARCH'=>TEXT_ORDERSEARCH,
			'MSG_ERROR_NO_ORDERS_FOUND'=>MSG_ERROR_NO_ORDERS_FOUND,
			'MSG_SUCCESS_ORDER_FOUND'=>MSG_SUCCESS_ORDER_FOUND,
			'MSG_SUCCESS_MULTIPLE_ORDERS_FOUND'=>MSG_SUCCESS_MULTIPLE_ORDERS_FOUND,
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('ebay_email_filter.html');
		exit;
		break;
    case 'auto_allocate_process':
		if(is_countable($_REQUEST['address']) and sizeOf($_REQUEST['address'])){
			\YES4Trade\Model\ebay_emails::auto_allocate_addresses($_REQUEST['address']);
			$messageStack->add_session(sprintf(MSG_SUCCESS_AUTOMATIC_ALLOCATION,implode(',',$_REQUEST['address'])),'success');
		}
		xtc_redirect(xtc_href_link('ebay_email.php'));
		break;
    case 'auto_allocate':
		$allocate_addresses = array(
			'do-not-reply@amazon.de','fba-ship-confirm@amazon.com','ebay@ebay.de','member@paypal.de'
		);
		echo xtc_draw_form('auto_allocate','ebay_email.php','action=auto_allocate_process','POST');
		echo '<fieldset>';
		foreach($allocate_addresses as $aa){
			printf('%s %s<br />',  xtc_draw_checkbox_field('address[]', $aa, true),$aa);
		}
        require_once(DIR_WS_CLASSES.'userprofile_emailfilter_addresses_allocation.php');
        $up = new userprofile_emailfilter_addresses_allocation( $_SESSION['customer_id'] );
		$addresses_list = $up->getAddresses();
        if(is_countable($addresses_list) and sizeOf($addresses_list)){
            printf('<span style="color: #777;font-style: italic;">%s</span>&nbsp;<a href="start.php?action=user_profile"><img src="images/basicons/black406.png" width="15" height="15" /></a><br />',TEXT_OWN_EMAILFILTER_ADDRESSES);
            foreach($addresses_list as $add){
                printf('%s %s<br />',  xtc_draw_checkbox_field('address[]', $add, true),$add);
            }
        }
		printf('<legend>%s</legend>',TEXT_AUTOMATIC_ALLOCATION_LEGEND);
			
		echo yes_draw_href_button(IMAGE_AUTOMATIC_ALLOCATION, '', '', 'submit');
		echo '</fieldset>';
		echo '</form>';
		printf('<p><i>%s</i></p>',TEXT_AUTOMATIC_ALLOCATION_INTRO);
		exit;
		break;
	case 'unallocation':
		$id = (int)xtc_db_input($_REQUEST['id']);
		\YES4Trade\Model\ebay_emails::update_ebay_email([
			'customers_id'=>0,
			'ebay_id'=>'',
			'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS0,
			'orders_id'=>0,
			'ebay_user'=>'',
			'id'=>$id
		]);
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),$base_get_params));
		$messageStack->add_session(sprintf(MSG_SUCCESS_ALLOCATION_REMOVED,'success'));
		exit;
		break;
	case 'show_attachment':
		$id = xtc_db_input($_REQUEST['id']);
		$att = new ebaymail_attachment($id);
		if($att->getFilename() != ''){
			$filename = \main::get_importdata_path().'mail_attachments/'.$att->getEmail_id().'/'.yes_get_sha1_from_string($att->getFilename());
			header('Content-Description: File Transfer');
			header('Content-Type: application/octet-stream');
			header('Content-Disposition: attachment; filename='.$att->getFilename());
			header('Content-Transfer-Encoding: binary');
			header('Expires: 0');
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Pragma: public');
			header('Content-Length: ' . filesize($filename));
			ob_clean();
			flush();
			readfile($filename);
			exit;
		}
		die('Keine Vorschau m&ouml;glich.');
	case 'export_select':
		$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$smarty->assign('FORM',xtc_draw_form('export_select','ebay_email.php','action=export','post'));
		$smarty->assign('PAGE_TITLE',POPUP_EXPORT_PAGE_TITLE);
		$interval_array = array(
			0=>array('id'=>'daily','text'=>TEXT_EXPORT_DAILY),
			1=>array('id'=>'weekly','text'=>TEXT_EXPORT_WEEKLY),
			2=>array('id'=>'monthly','text'=>TEXT_EXPORT_MONTHLY)
		);
		$smarty->assign('INPUT_EXPORT_INTERVAL',xtc_draw_pull_down_menu('interval',$interval_array,'weekly'/*,'class="iButton"'*/) );
		$smarty->assign('TEXT_CHOOSE_INTERVAL',TEXT_CHOOSE_INTERVAL);

		$ee_items = \YES4Trade\Model\ebay_emails::get_abonded(new DateTime(-$abonded_years.' Years'),['id']);
		$num_emails = sizeOf($ee_items);
		$smarty->assign('TEXT_NUMBER_OF_EMAILS',sprintf(TEXT_NUMBER_OF_EMAILS,$num_emails));
		$smarty->assign('NUM_EMAILS',$num_emails);
		echo $smarty->fetch('popup_export_emails.html');
		exit;
		break;
	case 'export':
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		function add_mbox_file($mbox,$interval_key,$start){
			global $basics;
			if(strlen($mbox)>0){
				if(!is_dir(\main::get_exportdata_path().'mailarchiv'))
					mkdir(\main::get_exportdata_path().'mailarchiv');
				$filename = \main::get_exportdata_path().'mailarchiv/MAILARCHIV_'.$interval_key.'_'.$start.'.mbox';
				$basics->create_file($filename,$mbox);
				return $filename;
			}
		}

		$basics = new basics;
		$start = intval($_GET['start']??0);
		$limit = 5000;
		$ee_items = \YES4Trade\Model\ebay_emails::get_abonded(new DateTime(-$abonded_years.' Years'),[
				'subject','mailto','from_name','from_email','date'
			],$start, $limit
		);

		$num_entries = sizeOf($ee_items);
		$mbox = '';
		$interval_key = '';
		$mbox_files = array();
		foreach($ee_items as $ee){
			$archive = $ee->toArray();
			switch($_POST['interval']){
				case 'daily':
					$act_interval_key = date('Y-z',strtotime($archive['date']));
					break;
				case 'weekly':
					$act_interval_key = date('Y-W',strtotime($archive['date']));
					break;
				case 'monthly':
					$act_interval_key = date('Y-n',strtotime($archive['date']));
					break;
			}
			if($act_interval_key != $interval_key){
				$interval_key = $act_interval_key;
				$file = add_mbox_file($mbox,$interval_key,$start);
				if($file != ''){
					$mbox_files[] = $file;
				}
				$mbox = '';
			}

			$content_type = (xtc_not_null($archive['format'])) ? $archive['format'] : 'text/html';
			$date = date('r',strtotime($archive['date']));
			$mbox .= "From ".$archive['from_email']." ".$date."
Return-Path: ".$archive['from_email']."
Delivered-To: ".$archive['mailto']."
Date: ".$date."
Content-Type: ".$content_type."; charset=".CHARSET."
From: ".$archive['from_name']." ".$archive['from_email']."
To: ".$archive['mailto']."
Subject: ".$archive['subject']."\r\n
".$archive['email_body']."
\r\n";

		}
		// DEN LETZTEN EINTRAG NOCH ARCHIVIEREN
		if($mbox != ''){
			$interval_key = $act_interval_key;
			$file = add_mbox_file($mbox,$interval_key,$start);
			if($file != ''){
				$mbox_files[] = $file;
			}
		}
		if($num_entries == $limit){
			echo xtc_draw_form('expem_cont',basename(__FILE__),xtc_get_all_get_params(array('start')).'start='.($start+$limit),'POST');
			printf('<p>'.TEXT_EXPORT_EMAILS_CONTINUE.'</p>',$limit,IMAGE_EXPORT);
			echo xtc_draw_hidden_field('interval',$_POST['interval']);
			echo '<input type="submit" value="'.IMAGE_EXPORT.'" onclick="this.disabled=true;" />';
			echo '</form>';
			exit;
		}else{
			$files = $basics->get_directory_content(\main::get_exportdata_path().'mailarchiv/');
			if(sizeOf($files)){
				$basics->zip_files('mailarchiv/',$crypt_file.'_mailarchive.zip',\main::get_exportdata_path(),true);
				$file_contents = $basics->read_file_content(\main::get_exportdata_path().$crypt_file.'_mailarchive.zip',$mode='rb');
				unlink(\main::get_exportdata_path().$crypt_file.'_mailarchive.zip');
				// send File to Browser
				$file = 'MAILARCHIV_'.date('Y-m-d_H_i_s').'.zip';
				header('Content-Type: application/octet-stream');
				header('Content-Transfer-Encoding: binary');
				header('Content-disposition: attachment; filename=' . $file);
				echo $file_contents;
				exit;
			}else{
				die('No file data');
			}		
		}

		break;
	case 'save_myfilter':
		xtc_db_query(sprintf("DELETE FROM customers_email_filter WHERE customers_id='%s'",$_SESSION['customer_id']));
		if($_POST['email_address'] and is_array($_POST['email_address']) and sizeOf($_POST['email_address'])>0){
			foreach($_POST['email_address'] as $k=>$email_address){
				$insert_sql_array = array(
					'customers_id'=>$_SESSION['customer_id'],
					'email_address'=>$email_address
				);
				xtc_db_perform('customers_email_filter',$insert_sql_array);
			}
		}
		$messageStack->add_session(MESSAGE_FILTER_UPDATED,'success');
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action')).'action=myemails'));
		break;
	case 'myemails':
		include('ebay_email_myfilter.php');
		break;
	case "autofilter":
		$mail = new DBmail(0); // einfach ne leere instanz
		$newmails = array();
		$ee_items = \YES4Trade\Model\ebay_emails::filter([
				'deleted'=>\YES4Trade\Model\ebay_emails::DELETED0,
				'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS0,
				'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL0
			],['id','from_email']
		);
		foreach($ee_items as $ee){
			$newmails[ $ee->id ] = $mail->get_cleanemail( $ee->from_email );
		}
		$emails = $mail->get_email_data();
		$view = $mail->autofilter($emails,$newmails);
		if(is_countable($view) and sizeOf($view)>0){
			foreach($view as $eId=>$email){
				$cst = \YES4Trade\Model\customers::get_by_email_address($email, ['customers_id']);
				// BOF - customers_email-aliases
				if($cst === null){
				    $customers_query = xtc_db_query( "SELECT customers_id FROM customers_email_aliases WHERE email_address='".$email."'");
					$customer = xtc_db_fetch_array($customers_query);
					$customer_id = intval($customer['customers_id']);
				}else{
					$customer_id = intval($ee->customers_id);
				}
				// EOF - customers_email-aliases
				$upd = new \YES4Trade\Model\ebay_emails([
					'customers_id'=>$customer_id,
					'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
					'id'=>intval($eId)
				]);
				$upd->update();
			}
			$messageStack->add_session(sprintf(MESSAGE_AUTOFILTER_SUCCESS,sizeOf($view)),'success');
		}else{
			$messageStack->add_session(MESSAGE_AUTOFILTER_ERROR,'error');
		}
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF'])));
		break;
	case "unread":
		if(sizeOf($_POST['eId']) > 0){
			foreach($_POST['eId'] as $k=>$eId){
				\YES4Trade\Model\ebay_emails::update_by_from_email([
					'read_status'=>\YES4Trade\Model\ebay_emails::READ_STATUS0,
					'id'=>intval($eId)
				]);
			}
			$messageStack->add_session(MESSAGE_EMAIL_MARK_AS_UNREAD,'success');
		}
		
		xtc_redirect(xtc_href_link('ebay_email.php'));
   		break;
	default:
		$page = (isset($_REQUEST['page']))?$_REQUEST['page']:0;
		$search = array();
		if(isset($_GET['scID']))
			$search['cID'] = $_GET['scID'];
		if(isset($_GET['sebayID']))
			$search['ebayID'] = $_GET['sebayID'];
		if(isset($_GET['semail']))
			$search['email'] = $_GET['semail'];
		if(isset($_GET['ssubject']))
			$search['subject'] = $_GET['ssubject'];
		if(isset($_GET['sbody']))
			$search['body'] = $_GET['sbody'];
		if(isset($_GET['sboth']))
			$search['both'] = $_GET['sboth'];
		if(isset($_REQUEST['startDate']))
			$search['date'] = $_REQUEST['startDate'];
                if(isset($_GET['email_id']) and $_GET['email_id'] > 0){
                    $epage = 'search';
                    $search['email_id'] = (int) xtc_db_input($_GET['email_id']);
                }
		$order_by = isset($_REQUEST['order_by']) ? $_REQUEST['order_by'] : 'date';
		if($epage == 'search'){
		    $order_by = isset($_REQUEST['order_by']) ? $_REQUEST['order_by'] : 'date DESC';
		}
		$maxresults = (isset($_GET['view_mode']) and $_GET['view_mode'] == 'all') ? '1000' : MAIL_LIMIT;
		
		if(!isset($_GET['smode']) && $box != 'reply' and $epage != 'search'){
			$mail_filter = '';
			if(isset($_GET['myfilter'])){
				$mail_filter .= ' and ( ';
				$myfilter_query_raw = sprintf("SELECT email_address,customers_email_filter_id FROM customers_email_filter WHERE customers_id='%s'",$_SESSION['customer_id']);
				$myfilter_query = xtc_db_query($myfilter_query_raw);
				$num_filters = xtc_db_num_rows($myfilter_query);
				while($myfilter = xtc_db_fetch_array($myfilter_query)){
					$mail_filter .= sprintf(" mailto='%s'",$myfilter['email_address']);
					$mail_filter .= ' or ';
				}
				$mail_filter = substr($mail_filter,0,(strlen($mail_filter)-3));
				$mail_filter .= ' )';
				if(!$num_filters)
					$mail_filter = '';
			}
                        $email_staff_allocations_query_from = '';
			switch($epage){
			    case 'my_staff_allocations':
				$where_sql = " esa.customers_id='".$_SESSION['customer_id']."' ";
                                $email_staff_allocations_query_from = " LEFT JOIN email_staff_allocation esa ON esa.email_id=em.id ";
				break;
			    case 'allocated':
				$where_sql = " allocation_status='1' && ownmail='0' && saved=0 ";
				break;
			    default:
				$where_sql = " allocation_status='0' && ownmail='0' ";
				break;
			}
			$q = sprintf("SELECT em.id from ebay_emails em %s where %s %s order by %s",
                                $email_staff_allocations_query_from,
                                $where_sql,$mail_filter,$order_by
                        );
			$timer_split = new splitPageResults( $_GET['page'], $maxresults, $q, $timer_query_numrows);
			$mails_query = xtc_db_query($q);
			
	   		while($mails = xtc_db_fetch_array($mails_query)){
               			$mail[] = $mails['id'];
        		}
		}
		
		if($epage == 'search'){
		    $order_by = ' order by '.$order_by;
			$_double_emails = array();
			foreach($search as $class => $value){
			    if(empty($value)) continue; // bugfix - keine leeren suchstrings
				switch($class){
					case 'cID':
						$mailquery_raw = sprintf("select id from ebay_emails where customers_id='%s' %s %s",xtc_db_prepare_input($value),$mail_filter,$order_by);
						$timer_split = new splitPageResults( $_GET['page'], $maxresults, $mailquery_raw, $timer_query_numrows);
						$mailquery = xtc_db_query($mailquery_raw);
						while($mails = xtc_db_fetch_array($mailquery)){
							if(!in_array($mails['id'],$_double_emails)){
								$mail[] = $mails['id'];
								$_double_emails[] = $mails['id'];
							}
						}
						break;
					case 'ebayID':
						$mailquery_raw = sprintf("select id from ebay_emails where ebay_id='%s' %s %s",xtc_db_prepare_input($value),$mail_filter,$order_by);
						$timer_split = new splitPageResults( $_GET['page'], $maxresults, $mailquery_raw, $timer_query_numrows);
						$mailquery = xtc_db_query($mailquery_raw);
						while($mails = xtc_db_fetch_array($mailquery)){
							if(!in_array($mails['id'],$_double_emails)){
								$mail[] = $mails['id'];
								$_double_emails[] = $mails['id'];
							}
						}
						break;
					case 'email':
						// hier kein sprintf wegen like '%%'
						$mailquery_raw = "select id from ebay_emails where (from_email like '%".xtc_db_prepare_input($value)."%' or mailto like '%".xtc_db_prepare_input($value)."%') ".$mail_filter.$order_by;
						$timer_split = new splitPageResults( $_GET['page'], $maxresults, $mailquery_raw, $timer_query_numrows);
						$mailquery = xtc_db_query($mailquery_raw);
						while($mails = xtc_db_fetch_array($mailquery)){
							if(!in_array($mails['id'],$_double_emails)){
								$mail[] = $mails['id'];
								$_double_emails[] = $mails['id'];
							}
						}
						break;
					case 'subject':
						// hier kein sprintf wegen like '%%'
						$mailquery_raw = "select id from ebay_emails where subject like '%".xtc_db_prepare_input($value)."%'".$mail_filter.$order_by;
						$timer_split = new splitPageResults( $_GET['page'], $maxresults, $mailquery_raw, $timer_query_numrows);
						$mailquery = xtc_db_query($mailquery_raw);
						while($mails = xtc_db_fetch_array($mailquery)){
							if(!in_array($mails['id'],$_double_emails)){
								$mail[] = $mails['id'];
								$_double_emails[] = $mails['id'];
							}
						}
						break;
					case 'body':
						// hier kein sprintf wegen like '%%'
						$mailquery_raw = "select em.id from ebay_emails em,ebay_email_bodys emb where emb.email_body like '%".xtc_db_prepare_input($value)."%' and em.id=emb.email_id".$mail_filter.$order_by;
						$timer_split = new splitPageResults( $_GET['page'], $maxresults, $mailquery_raw, $timer_query_numrows);
						$mailquery = xtc_db_query($mailquery_raw);
						while($mails = xtc_db_fetch_array($mailquery)){
							if(!in_array($mails['id'],$_double_emails)){
								$mail[] = $mails['id'];
								$_double_emails[] = $mails['id'];
							}
						}
						break;
					case 'date':
						$parts = explode('.',$search['date']);
						$value = strtotime($parts[2].'-'.$parts[1].'-'.$parts[0]);
						$mailquery_raw = sprintf("select id from ebay_emails where UNIX_TIMESTAMP(date) > '%s' and UNIX_TIMESTAMP(date) < '%s' %s %s",xtc_db_prepare_input($value),xtc_db_prepare_input( $value+(60*60*24) ),$mail_filter,$order_by);
						$timer_split = new splitPageResults( $_GET['page'], $maxresults, $mailquery_raw, $timer_query_numrows);
						$mailquery = xtc_db_query($mailquery_raw);
						while($mails = xtc_db_fetch_array($mailquery)){
							if(!in_array($mails['id'],$_double_emails)){
								$mail[] = $mails['id'];
								$_double_emails[] = $mails['id'];
							}
						}
						break;
					case 'email_id':
						$mailquery_raw = sprintf("select id from ebay_emails where id='%d'",$value);
						$mailquery = xtc_db_query($mailquery_raw);
						$timer_split = new splitPageResults( $_GET['page'], $maxresults, $mailquery_raw, $timer_query_numrows);
						while($mails = xtc_db_fetch_array($mailquery)){
								if(!in_array($mails['id'],$_double_emails)){
										$mail[] = $mails['id'];
										$_double_emails[] = $mails['id'];
								}
						}
						break;
						
				}
			}
		} // eof size of search
		$num_of_mails = (isset($mail)) ? sizeOf($mail) : 0;
		switch($epage){
		    case 'my_staff_allocations':
		    case 'allocated':
				$headertext = sprintf(TEXT_VIEW_ALLOCATED_EMAILS,$num_of_mails);
				break;
		    case 'search':
				$headertext = sprintf(TEXT_VIEW_SEARCHED_EMAILS,$num_of_mails);
				break;
		    default:
				$headertext = sprintf(TEXT_VIEW_UNALLOCATED_EMAILS,$num_of_mails);
				break;
		}
 		break;

}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$buttons = array();
if(isset($_REQUEST['epage']) and $_REQUEST['epage'] != 'unallocated'){
    $buttons[] = array('text'=>TEXT_LINK_UNALLOCATED_EMAILS,
	'link'=>xtc_href_link('ebay_email.php'),
	'lbOn'=>false,
	'auth'=>true
    );
}
if(!isset($_REQUEST['epage']) or $_REQUEST['epage'] != 'allocated'){
    $buttons[] = array('text'=>TEXT_LINK_ALLOCATED_EMAILS,
	'link'=>xtc_href_link('ebay_email.php?epage=allocated'),
	'lbOn'=>false,
	'auth'=>true
    );
}
$buttons[] = array('text'=>BUTTON_MY_ALLOCATIONS,
        'link'=>xtc_href_link(basename(__FILE__),'epage=my_staff_allocations'),
        'lbOn'=>false,
        'auth'=>true
);
if(!isset($_REQUEST['epage']) or $_REQUEST['epage'] != 'search'){
    $buttons[] = array('text'=>TEXT_LINK_SEARCH_EMAILS,
	'link'=>xtc_href_link('ebay_email.php?epage=search'),
	'lbOn'=>false,
	'auth'=>true
    );
}
$buttons[] = array('text'=>TEXT_LINK_MAILFILTER_EDIT,
	'link'=>xtc_href_link('ebay_email.php',xtc_get_all_get_params(array('action')).'action=myemails'),
	'lbOn'=>false,
	'auth'=>true
);
$buttons[] = array('text'=>TEXT_LINK_MAILEXPORT,
	'link'=>"javascript:void(window.open('".xtc_href_link('ebay_email.php','action=export_select')."','popup','width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_HEIGHT.",scrollbars=yes,resizable=yes'));",
	'lbOn'=>false,
	'auth'=>true
);
if(CRONJOB_EMAILS == 0){
    $buttons[] = array('text'=>TEXT_LINK_GET_EMAILS,
    'link'=>"javascript:void(window.open('ebaymail.php','popup','width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_HEIGHT.",scrollbars=yes,resizable=yes'));",
    'lbOn'=>false,
    'auth'=>true
    );
}
if(!isset($_GET['action']) or $_GET['action'] == ''){
    $buttons[] = array('text'=>TEXT_EMAIL_FILTER,
	'link'=>xtc_href_link('ebay_email.php','action=autofilter'),
	'lbOn'=>false,
	'auth'=>true
    );
}
$buttons[] = array('text'=>'Neue Email',
	'link'=>'javascript:;',
	'lbOn'=>false,
	'auth'=>true,
	'id'=>'new_mail'
);
switch($epage){
    case 'my_staff_allocations':
	$heading_title = PAGE_HEADING_MY_STAFF_ALLOCATIONS;
	break;
    case 'search':
	$heading_title = PAGE_HEADING_SEARCH;
	break;
    case 'allocated':
	$heading_title = PAGE_HEADING_ALLOCATED;
	break;
    default:
	$heading_title = PAGE_HEADING;
	break;
}
$subm_order_by = 'date';
$subm_order_dir = 'desc';
if(isset($_REQUEST['order_by'])){
    $parts = explode(' ',$_REQUEST['order_by']);
    $subm_order_by = $parts[0];
    $subm_order_dir = $parts[1];
}
$sort_parts = explode(' ',$order_by);
$smarty->assign(array(
    'SORT_BASE_URL'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('order_by'))),
    'HEADING_TITLE'=>$heading_title,
    'SHOW_HEADER'=>1,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'JS_CONFIRM_REALLY_DELETE_ITEMS'=>JS_CONFIRM_REALLY_DELETE_ITEMS,
    'SEARCH_DEFAULTDATE'=>(isset($_REQUEST['startDate'])) ? $_REQUEST['startDate'] : date('d.m.Y'),
    'SUBMITTED_ORDER_BY'=>$subm_order_by,
    'SUBMITTED_ORDER_DIRECTION'=>$subm_order_dir,
    'OPEN_STAFF_ALLOCATION_ID'=>(isset($_GET['id']) and (int)$_GET['id'] > 0) ? (int)xtc_db_input($_GET['id']) : 0,
));
$smarty->display('mail_list.html');
$smarty->assign('SHOW_HEADER',0);
?>
	<br clear="all" />
    	<table border="0" width="100%" cellspacing="0" cellpadding="0">
      <tr>
        <td class="main">
	
		<table border="0" cellpadding="4" cellspacing="0" width="100%" class="ui-widget-content">
		<tr>
			<td><?php echo $headertext; ?></td>
			<td align=right>
			<?php 
			if($epage == ''){
				echo xtc_draw_input_field('autofilter',TEXT_BUTTON_AUTOFILTER,'onClick="window.location.href=\''.xtc_href_link('ebay_email.php','action=autofilter').'\';" class="ui-button ui-corner-all ui-state-default"','','button'); 
			}
			?>
			&nbsp;
			<?php
			if(!isset($_GET['myfilter']) and $epage != 'search'){
				echo xtc_draw_input_field('myfilter_on',TEXT_BUTTON_MAILFILTER_ON,'onClick="window.location.href=\''.xtc_href_link('ebay_email.php',xtc_get_all_get_params(array('myfilter')).'myfilter=1').'\';" class="ui-button ui-corner-all ui-state-default"','','button'); 
			}elseif(isset($_GET['myfilter']) and $epage != 'search'){
				echo xtc_draw_input_field('myfilter_off',TEXT_BUTTON_MAILFILTER_OFF,'onClick="window.location.href=\''.xtc_href_link('ebay_email.php',xtc_get_all_get_params(array('myfilter'))).'\';" class="ui-button ui-corner-all ui-state-default"','','button'); 
			}
			if($epage == ''){
			    echo yes_draw_href_button(TEXT_AUTOMATIC_ALLOCATION, xtc_href_link('ebay_email.php','action=auto_allocate'), '', 'button', 'lbOn ui-button ui-corner-all ui-state-default');
			}
			?>
			</td>
		</tr>
		</table>

<?php
if($epage == 'search'){
?>
	<div style="float: left;width: 650px;display: inline-block;padding:5px;margin-top: 5px;" class="ui-widget-content">
	<?php echo xtc_draw_form('search',basename($_SERVER['PHP_SELF']),'','GET'); ?>
	    <input type="hidden" name="epage" value="search" />
	    <legend><b><?php echo TEXT_SEARCH_PARAMS; ?></b></legend>
		<div style="float: left;height: 100%;">
		<?php echo TEXT_LABEL_CUSTOMERS_ID; ?>
		    <?php echo xtc_draw_input_field('scID', ((isset($_GET['scID']))?$_GET['scID']:''),'size="10"'.((isset($_GET['scID']) and !empty($_GET['scID']))?' class="ui-state-highlight"':'')); ?>
		<?php echo TEXT_LABEL_SEARCH_AUCTION; ?>
		    <?php echo xtc_draw_input_field('sebayID',((isset($_GET['sebayID']))?$_GET['sebayID']:''),'size="10"'.((isset($_GET['sebayID']) and !empty($_GET['sebayID']))?' class="ui-state-highlight"':'')); ?>
		<?php echo TEXT_EMAIL; ?>:
		    <?php echo xtc_draw_input_field('semail',((isset($_GET['semail']))?$_GET['semail']:''),'size="20"'.((isset($_GET['semail']) and !empty($_GET['semail']))?' class="ui-state-highlight"':'')); ?>
		<br />
		<?php echo TEXT_LABEL_SEARCH_SUBJECT; ?>
		    <?php echo xtc_draw_input_field('ssubject',((isset($_GET['ssubject']))?$_GET['ssubject']:''),'size="20"'.((isset($_GET['ssubject']) and !empty($_GET['ssubject']))?' class="ui-state-highlight"':'')); ?>
		<?php echo TEXT_LABEL_SEARCH_BODY; ?>
		    <?php echo xtc_draw_input_field('sbody',((isset($_GET['sbody']))?$_GET['sbody']:''),'size="20"'.((isset($_GET['sbody']) and !empty($_GET['sbody']))?' class="ui-state-highlight"':'')); ?>
		</div>
		<div style="width: 70px;display: inline-block;"><?php echo xtc_draw_input_field('subm',IMAGE_SEARCH,'class="ui-state-default"','','submit'); ?></div>
	</form>
	</div>
	<div class="ui-widget-content" style="margin-top: 5px;margin-left: 20px;width: 300px;display:inline-block;padding: 10px; height: ">
	    <?php echo TEXT_LABEL_SEARCH_MAIL_FROM_DATE; ?>
	    <?php echo xtc_draw_form('searchdate',basename($_SERVER['PHP_SELF']),'','GET','id="searchdate"'); ?>
	    <input type="hidden" name="epage" value="search" />
	    <input type="hidden" name="search" value="date" />
	    <input type="hidden" name="action" value="search" />
	    <input <?php if(isset($_REQUEST['startDate'])){ echo 'class="ui-state-highlight"'; } ?> type="text" id="startDate" name="startDate" value="<?php echo ((isset($_REQUEST['startDate']))?$_REQUEST['startDate']:date('d.m.Y')); ?>" />
	    <input type="image" src="images/icon_arrow_right.gif" alt="<?php echo TEXT_DISPLAY_EMAILS_FROM_DATE; ?>" title="<?php echo TEXT_DISPLAY_EMAILS_FROM_DATE; ?>" border="0" />
	    </form>
	</div>
	<br clear="all" />
	    
<?php
}

if(isset($_GET['epage']) and $_GET['epage'] == 'my_staff_allocations'){
    $records = array();
    $query = xtc_db_query(sprintf(
            "SELECT * FROM email_staff_allocation_history WHERE customers_id='%d' AND read_status=0 ORDER BY date_added DESC",
            $_SESSION['customer_id']
    ));
    while ($record = xtc_db_fetch_array($query)) {
        $records[] = $record;
    }
    if(sizeOf($records)){
        $smarty->assign(array(
            'NEW_ALLOCATION_HISTORY'=>$records,
            'BUTTON_MARK_AS_READ'=>BUTTON_MARK_AS_READ,
            'BUTTON_TOGGLE_NEW_HISTORY_ENTRIES'=>BUTTON_TOGGLE_NEW_HISTORY_ENTRIES
        ));
    }
}
$cst = \YES4Trade\Model\customers::get_by_customers_id(intval($_SESSION['customer_id']),
	['customers_email_address']
);
$c_email = $cst->customers_email_address;
$smarty->assign(array(
    'NEW_MAIL_LINK'=>xtc_href_link('ebay_mail_frame.php','menugroup=interfaces&mode=single&email='.urlencode($c_email)),
    'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
    'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
    'TEXT_REPLIED'=>TEXT_REPLIED,
    'AFTER_ALLOCATION_LINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params()),
));
$sort_link = xtc_href_link('ebay_email.php',xtc_get_all_get_params(array('order_by')));
$smarty->assign('SORT_DATE',sprintf("<a href=\"%s\">%s</a>",$sort_link."&order_by=date",'Datum'));
$smarty->assign('SORT_FROM',sprintf("<a href=\"%s\">%s</a>",$sort_link."&order_by=from_email",'Absender'));
$smarty->assign('SORT_SUBJECT',sprintf("<a href=\"%s\">%s</a>",$sort_link."&order_by=subject",'Betreff'));
if(isset($mail) and is_countable($mail)) {
	echo '<p>';
	if(isset($_GET['myfilter'])){
		echo '&nbsp;<b>'.TEXT_MAILFILTER_ON.'</b>';
	}
	echo '</p>';	
	// ****************************** listenansicht ***************************************************************
	$smarty->assign('FORM',xtc_draw_form('mails','ebay_email.php',$base_get_params,'post'));


	$smarty->assign('SORT_EBAYUSER',sprintf("<a href=\"%s\">%s</a>",$sort_link."&order_by=ebay_user",'Ebayuser'));

    $esa = new \email_staff_allocation;
	$tr_array = [];
	foreach($mail as $k=>$id){
		$tr_array[] = smarty_function_mail_list(['id'=>$id],$smarty);
		$email = new DBmail($id,true,true);
		$attachments_array = array();
		$attachments = $email->get_attachments();
		for($i=0;$i<sizeOf($attachments);$i++){
			$att = $attachments[$i];
			$attachments_array[] = array(
				'id'=>$att->getEbay_email_attachments_id(),
				'filename'=>$att->getFilename(),
				'filetype'=>$att->getFiletype(),
				'filetype_icon'=>_get_icon($att->getFiletype()),
				'filesize'=>$att->getFilesize(),
				'filesize_kb'=>number_format(($att->getFilesize() / 1024),2,',','.')
			);
		}
		$email_data[] = array(
		    'ID'=>$email->id,
		    'EMAIL_CLEAN'=>$email->getFrom_email(-1,false),
		    'EID'=>xtc_draw_checkbox_field('eId[]',$email->id),
		    'NAME'=>$email->getFrom_name(30,true),
		    'EMAIL'=>$email->getFrom_email(40),
		    'ALLOCATED_USER'=>$email->customers_id,
		    'ALLOCATED_AUCTION'=>$email->ebay_id,
		    'OWNMAIL'=>$email->ownmail,
		    'READ_STATUS'=>$email->read_status,
		    'REPLY_STATUS'=>$email->reply_status,
		    'SUBJECT'=>$email->getSubject(120),
		    'ATTACHMENTS'=>$attachments_array,
		    'DATE'=>$email->getFormatedDate(),
		    'INPUT_BOX'=>xtc_draw_hidden_field('box',$box),
		    'EBAY_USER'=>$email->getEbayUser(),
		    'ALLOCATION_STATUS'=>$email->allocation_status,
		    'SAVE_STATUS'=>$email->saved,
            'EMAIL_STAFF_ALLOCATION_TITLE'=>$esa->get_allocation_link_title($email->id),
		);
	}
	$smarty->assign([
		'emails'=>$email_data,
		'tr_array'=>$tr_array,
	]);
	
	$navi = $timer_split->display_count($timer_query_numrows, $maxresults, (int)xtc_db_input($_GET['page']), TEXT_DISPLAY_NUMBER_OF_ITEMS);
	$navi .= '<br />'.$timer_split->display_links($timer_query_numrows, $maxresults, MAX_DISPLAY_PAGE_LINKS, (int)xtc_db_input($_GET['page']), xtc_get_all_get_params(array('page')));
	$navi .= "<br><a href='".xtc_href_link('ebay_email.php',xtc_get_all_get_params(array('view_mode')).'view_mode=all')."'><u>".TEXT_SHOW_ALL."</u></a>";
	
	$smarty->assign(array(
	    'NAVIGATION'=>$navi,
	    'REALLY_SPAM_PROCESS'=>REALLY_SPAM_PROCESS,
	    'LINK_SPAM_PROCESS'=>xtc_href_link(basename(__FILE__),'action=spam_process')
	));
	$smarty->assign('EID','1'); // soll die "alle markieren"->l�schen auswahl gezeigt werden?
}
$smarty->assign('FORM_END','</form>');
$main_content= $smarty->fetch('mail_list.html');
echo $main_content;
?>
	</td>
</tr>
</table>
<?php
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
