<?php
/* -----------------------------------------------------------------------------------------
   $Id: gv_mail.php,v 1.2 2017/01/09 10:41:50 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project (earlier name of osCommerce)
   (c) 2002-2003 osCommerce (gv_mail.php,v 1.3.2.4 2003/05/12); www.oscommerce.com

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


require('includes/application_top.php');

require(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();

require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');

// initiate template engine for mail
$smarty = new yesSmarty;

if ( ($_GET['action'] == 'send_email_to_user') && (isset($_POST['customers_email_address']) || isset($_POST['email_to'])) ) {
    if(!isset($_POST['amount'])){
        $messageStack->add_session(ERROR_NO_AMOUNT_SELECTED,'error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    if(!isset($_POST['message']) or empty($_POST['message'])){
        $messageStack->add_session(ERROR_NO_MESSAGE,'error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    $amount = str_replace(',','.',$_POST['amount']);
    if((float)$amount <= 0){
        $messageStack->add_session(ERROR_NO_AMOUNT_SELECTED,'error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    switch ($_POST['customers_email_address']) {
      case '***':
        $mail_query = xtc_db_query("select customers_id,customers_firstname, customers_lastname, customers_email_address from " . TABLE_CUSTOMERS);
        $mail_sent_to = TEXT_ALL_CUSTOMERS;
        break;
      case '**D':
        $mail_query = xtc_db_query("select customers_id,customers_firstname, customers_lastname, customers_email_address from " . TABLE_CUSTOMERS . " where customers_newsletter = '1'");
        $mail_sent_to = TEXT_NEWSLETTER_CUSTOMERS;
        break;
      default:
        $customers_email_address = $_POST['customers_email_address'];
        if(!xtc_validate_email($customers_email_address)){
            $messageStack->add_session(sprintf(MSG_ERROR_INVALID_EMAIL, $customers_email_address),'error');
            xtc_redirect(xtc_href_link(basename(__FILE__)));
        }
        $mail_query = xtc_db_query("select customers_id,customers_firstname, customers_lastname, customers_email_address from " . TABLE_CUSTOMERS . " where customers_email_address = '" . xtc_db_input($customers_email_address) . "'");
        $mail_sent_to = $_POST['customers_email_address'];
        if (isset($_POST['email_to'])) {
            if(!xtc_validate_email($_POST['email_to'])){
                $messageStack->add_session(sprintf(MSG_ERROR_INVALID_EMAIL, $_POST['email_to']),'error');
                xtc_redirect(xtc_href_link(basename(__FILE__)));
            }
            $mail_sent_to = $_POST['email_to'];
        }
        break;
    }

    $from = xtc_db_prepare_input($_POST['from']);
    if(!xtc_validate_email($from)){
        $messageStack->add_session(sprintf(MSG_ERROR_INVALID_FROM_EMAIL, $from),'error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    $subject = xtc_db_prepare_input($_POST['subject']);
    $mail_list = [];
    while ($mail = xtc_db_fetch_array($mail_query)) {
        $mail_list[] = $mail;
    }
    
    
    // assign language to template for caching
    $smarty->assign('language', $_SESSION['language']);
    $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
    $smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
    $smarty->assign('WEBSITE', HTTP_SERVER  . DIR_WS_CATALOG);
    $smarty->assign('AMMOUNT', $currencies->format($amount));
    $smarty->assign('AMOUNT', $currencies->format($amount));
    $smarty->assign('MESSAGE', xtc_db_prepare_input($_POST['message']));
    foreach($mail_list as $mail){
        $id1 = create_coupon_code($mail['customers_email_address']);
        $smarty->assign('GIFT_ID', $id1);
        $link = HTTP_SERVER  . DIR_WS_CATALOG . 'gv_redeem.php' . '?gv_no='.$id1;
        $smarty->assign('GIFT_LINK',$link);

        $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/send_gift.html');
        $txt_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/send_gift.txt');

        if (empty($subject)) {
            $subject=EMAIL_BILLING_SUBJECT;
        }
        if(main::isDev(true)){
        }else{
            xtc_php_mail(EMAIL_BILLING_ADDRESS,EMAIL_BILLING_NAME, 
                  $mail['customers_email_address'] , 
                  $mail['customers_firstname'] . ' ' . $mail['customers_lastname'] , 
                  '', 
                  EMAIL_BILLING_REPLY_ADDRESS, 
                  EMAIL_BILLING_REPLY_ADDRESS_NAME, 
                  '', 
                  '', 
                  $subject, 
                  $html_mail, 
                  $txt_mail
            );
        }
        $new = new \YES4Trade\Model\coupons([
            'coupon_code'=>$id1, 
            'coupon_type'=>'G', 
            'coupon_amount'=>(float)$amount, 
            'date_created'=>date('Y-m-d H:i:s')
        ]);
        $insert_id = $new->create();
        
        $new = new \YES4Trade\Model\coupon_email_track([
            'coupon_id'=>intval($insert_id), 
            'customer_id_sent'=>$mail['customers_id'], 
            'sent_firstname'=>$mail['customers_firstname'], 
            'sent_lastname'=>$mail['customers_lastname'], 
            'emailed_to'=>$mail['customers_email_address'], 
            'date_sent'=>date('Y-m-d H:i:s')
        ]);
        $new->create();
        
        if(main::isDev(true)){
            echo '1. Mail geht an '.$mail['customers_email_address'].' mit Inhalt:<br /><br />'.$html_mail;
            echo '<hr><br /><br />ich breche hier ab.';
            exit;
        }
    }
    
    // WIRD NICHT MEHR VERWENDET
    if (isset($_POST['email_to'])) {
        $id1 = create_coupon_code($_POST['email_to']);

        // assign language to template for caching
        $smarty->assign('language', $_SESSION['language']);

        $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
        $smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');

        $smarty->assign('AMMOUNT', $currencies->format($_POST['amount']));
        $smarty->assign('MESSAGE', $_POST['message']);
        $smarty->assign('GIFT_ID', $id1);
        $smarty->assign('WEBSITE', HTTP_SERVER  . DIR_WS_CATALOG);

        if (SEARCH_ENGINE_FRIENDLY_URLS == 'true') {
            $link = HTTP_SERVER  . DIR_WS_CATALOG . 'gv_redeem.php' . '/gv_no,'.$id1;
        } else {
            $link = HTTP_SERVER  . DIR_WS_CATALOG . 'gv_redeem.php' . '?gv_no='.$id1;
        }

        $smarty->assign('GIFT_LINK',$link);

        $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/send_gift.html');
        $txt_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/send_gift.txt');
        xtc_php_mail(
            EMAIL_BILLING_ADDRESS,
            EMAIL_BILLING_NAME, 
            $_POST['email_to'] , 
            '' , 
            '', 
            EMAIL_BILLING_REPLY_ADDRESS, 
            EMAIL_BILLING_REPLY_ADDRESS_NAME, 
            '', 
            '', 
            EMAIL_BILLING_SUBJECT, 
            $html_mail , 
            $txt_mail
        );

        // Now create the coupon email entry
        $new = new \YES4Trade\Model\coupons([
            'coupon_code'=>$id1, 
            'coupon_type'=>'G', 
            'coupon_amount'=>(float)$amount, 
            'date_created'=>date('Y-m-d H:i:s')
        ]);
        $insert_id = $new->create();
        
        $new = new \YES4Trade\Model\coupon_email_track([
            'coupon_id'=>intval($insert_id), 
            'customer_id_sent'=>0, 
            'sent_firstname'=>'GAST', 
            'emailed_to'=>$_POST['email_to'], 
            'date_sent'=>date('Y-m-d H:i:s')
        ]);
        $new->create();
    }
    xtc_redirect(xtc_href_link(FILENAME_GV_MAIL, 'mail_sent_to=' . urlencode($mail_sent_to)));
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$from = EMAIL_FROM;
$to = '';
if(isset($_GET['cID'])){
    $cust = \YES4Trade\Model\customers::get_by_customers_id(intval($_GET['cID']),[
        'customers_email_address']
    );
    if($cust !== null){
        $to = $cust->customers_email_address;
    }
}        
$smarty->assign([
    'FORM'=>xtc_draw_form('mail', FILENAME_GV_MAIL, 'action=send_email_to_user'),
    'TEXT_ALL_CUSTOMERS'=>TEXT_ALL_CUSTOMERS,
    'TEXT_NEWSLETTER_CUSTOMERS'=>TEXT_NEWSLETTER_CUSTOMERS,
    'INPUT_TO'=>xtc_draw_input_field ('customer_search_dummy', $to,'id="customer_search" size="40"'),
    'TO'=>$to, // initialisierung wenn cID uebergeben
    'INPUT_FROM'=>xtc_draw_input_field ('from', $from,'id="from"'),
    'TEXT_FROM'=>TEXT_FROM,
    'TEXT_TO'=>TEXT_TO,
    'INPUT_SUBJECT'=>xtc_draw_input_field('subject','Gutschein','id="subject"'),
    'TEXT_SUBJECT'=>TEXT_SUBJECT,
    'INPUT_AMOUNT'=>xtc_draw_input_field('amount',0,'id="amount" min="0" step="1"',true,'number'),
    'TEXT_AMOUNT'=>TEXT_AMOUNT,
    'INPUT_MESSAGE'=>xtc_draw_textarea_field('message', 'soft', '60', '15','','id="message"'),
    'TEXT_MESSAGE'=>TEXT_MESSAGE,
    'IMAGE_SEND_EMAIL'=>IMAGE_SEND_EMAIL,
    'JS_ERROR_NO_RECIPIENT' => JS_ERROR_NO_RECIPIENT,
    'JS_ERROR_INVALID_RECIPIENT' => JS_ERROR_INVALID_RECIPIENT,
    'JS_ERROR_AMOUNT' => JS_ERROR_AMOUNT,
    'JS_ERROR_AMOUNT_POSITIVE' => JS_ERROR_AMOUNT_POSITIVE,
    'JS_ERROR_NO_MESSAGE' => JS_ERROR_NO_MESSAGE,
    'SEARCH_CUSTOMER'=>SEARCH_CUSTOMER,
    'TEXT_EMAIL_CONFIG'=>TEXT_EMAIL_CONFIG,
    'TEXT_REVIEW_DATE'=>TEXT_REVIEW_DATE,
]);


$buttons = [];
$smarty->assign(array(
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
));
$smarty->display('gv_mail.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');