<?php
$graph = new graph(400,340);
$graph->parameter['file_name'] = \main::get_exportdata_path().'start_stats.png';
if(defined('YES_PATH_TO_TTF_FONTS'))
	$graph->parameter['path_to_fonts'] = YES_PATH_TO_TTF_FONTS; // path to where fonts are stored
else
	$graph->parameter['path_to_fonts'] = '/usr/X11R6/lib/X11/fonts/TTF/'; // path to where fonts are stored

$days = 7;
$now_time = time();
$from = $now_time - (60*60*24*$days);
$to = time();

function yes_get_xtag($date,$days){
	return ($days-1)+((strtotime($date)-strtotime(date('Y-m-d'))) / (60*60*24));
}

for($i=0;$i<$days;$i++){
	$graph->y_data['alpha'][ $i ] = 0;
	$graph->y_data['beta'][ $i ] = 0;
	$graph->y_data['gamma'][ $i ] = 0;
	$graph->y_data['delta'][ $i ] = 0;
	$graph->y_data['epsilon'][ $i ] = 0;
	$graph->x_data[] = date('d.m.Y',$now_time - (60*60*24*(7-($i+1)))); 
}
$y_max_right =  10;
// gesamt
$alt_text = 'Gesamt: ';
$exclude_sql = " and orders_status != '".ORDERS_STATUS_STORNIERT."'";
$orders_query_raw = "SELECT count(orders_id) as anz,DATE_FORMAT(date_purchased,'%Y-%m-%d') as tag FROM orders WHERE UNIX_TIMESTAMP(date_purchased)>'".$from."' and UNIX_TIMESTAMP(date_purchased)<'".$to."' $exclude_sql GROUP BY tag";
$orders_query = xtc_db_query($orders_query_raw);
$orders_num = xtc_db_num_rows($orders_query);
while($orders = xtc_db_fetch_array($orders_query)){
	$x_tag = yes_get_xtag($orders['tag'],$days);
	$graph->y_data['alpha'][ $x_tag ] = $orders['anz'];

	$alt .= $orders['tag'].": ".$orders['anz']."\r\n";
	if( $orders['anz'] > $y_max_right){
		$y_max_right = $orders['anz'] + 5;
	}
}
if($orders_num){
	// ebay
	$orders_query = xtc_db_query("SELECT count(orders_id) as anz,DATE_FORMAT(date_purchased,'%Y-%m-%d') as tag FROM orders WHERE ebay_id!='' and UNIX_TIMESTAMP(date_purchased)>'".$from."' and UNIX_TIMESTAMP(date_purchased)<'".$to."' $exclude_sql GROUP BY tag");
	while($orders = xtc_db_fetch_array($orders_query)){
		$x_tag = yes_get_xtag($orders['tag'],$days);
		$graph->y_data['beta'][ $x_tag ] = $orders['anz'];
	}


	// Kasse
	$orders_query = xtc_db_query("SELECT count(orders.orders_id) as anz,DATE_FORMAT(orders.date_purchased,'%Y-%m-%d') as tag FROM orders LEFT JOIN kasse USING(orders_id) WHERE kasse.orders_id=orders.orders_id and ebay_id='' and UNIX_TIMESTAMP(orders.date_purchased)>'".$from."' and UNIX_TIMESTAMP(orders.date_purchased)<'".$to."' $exclude_sql GROUP BY tag");
	while($orders = xtc_db_fetch_array($orders_query)){
		$x_tag = yes_get_xtag($orders['tag'],$days);
		$graph->y_data['gamma'][ $x_tag ] = $orders['anz'];
	}

	// Shop
	$orders_query = xtc_db_query("SELECT count(orders.orders_id) as anz,DATE_FORMAT(orders.date_purchased,'%Y-%m-%d') as tag FROM orders LEFT JOIN kasse USING(orders_id) WHERE kasse.orders_id IS NULL and ebay_id='' and customers_ip != '' and UNIX_TIMESTAMP(orders.date_purchased)>'".$from."' and UNIX_TIMESTAMP(orders.date_purchased)<'".$to."' $exclude_sql GROUP BY tag");
	while($orders = xtc_db_fetch_array($orders_query)){
		$x_tag = yes_get_xtag($orders['tag'],$days);
		$graph->y_data['delta'][ $x_tag ] = $orders['anz'];
	}

	// Admin
	$orders_query = xtc_db_query("SELECT count(orders.orders_id) as anz,DATE_FORMAT(orders.date_purchased,'%Y-%m-%d') as tag FROM orders LEFT JOIN kasse USING(orders_id) WHERE kasse.orders_id IS NULL and ebay_id='' and customers_ip='' and UNIX_TIMESTAMP(orders.date_purchased)>'".$from."' and UNIX_TIMESTAMP(orders.date_purchased)<'".$to."' $exclude_sql GROUP BY tag");
	while($orders = xtc_db_fetch_array($orders_query)){
		$x_tag = yes_get_xtag($orders['tag'],$days);
		$graph->y_data['epsilon'][ $x_tag ] = $orders['anz'];
	}


	// NUN NOCH ORDNEN DENN ES FAENGT MIT SONNTAG AN
	if(is_array($graph->x_data)){
/*
	        for($i=0;$i<$days;$i++){
                	if(!isset($graph->x_data[$i]))
        	                $graph->x_data[$i] = '0';
		}
		
		foreach($graph->y_data as $k=>$v){
			$first = $v[0];
			$v = array_slice($v,1,($days-1));
			$v[] = $first;
			$graph->y_data[$k] = $v;
		}
*/
		$graph->parameter['title']             = 'Bestellstatistik';
		$graph->parameter['y_label_right']     = 'Anzahl';
		$graph->parameter['y_decimal_right']   =  0;
		$graph->parameter['x_grid']            = 'none';
		$graph->parameter['x_axis_angle']      =  90;
		$graph->parameter['y_min_right']       =  0;
		$graph->parameter['y_max_right']       =  $y_max_right;
		$graph->parameter['y_axis_gridlines']  =  11;
		$graph->parameter['y_axis_text_right'] =  2;  //print a tick every 2nd grid line
		$graph->parameter['shadow']            = 'none';
		$graph->parameter['legend']            = 'outside-right';
		$graph->parameter['legend_offset']     =  5;
		$graph->parameter['legend_border']     = 'black';
		$graph->parameter['inner_padding']     = 2;

		$graph->y_format['alpha'] = array('colour' => 'YESorange', 'bar' => 'fill', 'legend' => 'Gesamt', 'bar_size' => 1.0, 'y_axis' =>'right');
		$graph->y_format['beta']  = array('colour' => 'YESblue',  'bar' => 'fill', 'legend' => 'Ebay', 'bar_size' => 0.9, 'y_axis' =>'right');
		$graph->y_format['gamma']  = array('colour' => 'YESred',  'bar' => 'fill', 'legend' => 'Kasse', 'bar_size' => 0.8, 'y_axis' =>'right');
		$graph->y_format['delta']  = array('colour' => 'YESyellow',  'bar' => 'fill', 'legend' => 'Shop', 'bar_size' => 0.7, 'y_axis' =>'right');
		$graph->y_format['epsilon']  = array('colour' => 'YESpurple',  'bar' => 'fill', 'legend' => 'Kundendienst', 'bar_size' => 0.6, 'y_axis' =>'right');

		//$graph->y_data['alpha'] = array(6, 7,  5,  4,  8,  9);
		//$graph->y_data['beta']  = array(2, 2,  4,  7,  4,  5);

		$graph->y_order = array('alpha', 'beta','gamma','delta','epsilon');

		$graph->draw_stack();
		$start_grafik = array('src'=>$graph->parameter['file_name'].'.png','alt'=>$alt); 
	}
}
?>
