<?php

namespace YES4Trade\Model;

class coupons_description extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'coupons_description';

    private static $propertyTypes = [
        'coupon_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_id'
        ],
        'language_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_id'
        ],
        'coupon_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_name'
        ],
        'coupon_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_description'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


        /**
         * Aktualisiert den Datensatz
         * Da kein Unique Key in dieser Tabelle ist, wird language_id und
         * coupon_id benoetigt um Datensaetze zu aktualisieren.
         * @throws Exception
         */
	public function update() {
            $data = self::convert_values( $this->toArray(),self::$propertyTypes );
            if(!isset($data['language_id']) or !isset($data['coupon_id'])){
                throw new Exception('Need at least language_id and coupon_id to update coupon_description');
            }
            $language_id = intval($data['language_id']);
            $coupon_id = intval($data['coupon_id']);
            unset($data['language_id']);
            unset($data['coupon_id']);
            yes_db_perform(self::TABLE_NAME, $data,'update',[
                'language_id'=>$language_id,
                'coupon_id'=>$coupon_id
            ]);
	}

        /**
         * Loescht den Datensatz
         * Da kein Unique Key in dieser Tabelle ist, wird language_id und
         * coupon_id benoetigt um Datensaetze zu aktualisieren.
         * @throws Exception
         */
	public static function delete(int $coupon_id, int $language_id) {
            yes_query(sprintf(
                "DELETE FROM %s WHERE coupon_id=:id AND language_id=:language_id",
                    self::TABLE_NAME
                ),['id'=>$coupon_id,'language_id'=>$language_id]
            );
	}
        
        public static function get_by_coupon_id_and_language_id(int $coupon_id, int $language_id = null, array $select_fields = [] ){
            if($language_id === null){
                $language_id = $_SESSION['languages_id']??2;
            }
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                    "SELECT %s FROM %s WHERE coupon_id=:id AND language_id=:language_id",
                            $select_field_string,self::TABLE_NAME, 
                    ),['id'=>$coupon_id,'language_id'=>$language_id]
            );
            if(!sizeOf($query)){
                    return null;
            }
            $record = current($query);
            return new self(self::convert_values($record,self::$propertyTypes));
        }

        public static function get_by_coupon_id(int $coupon_id, array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                    "SELECT %s FROM %s WHERE coupon_id=:id",
                        $select_field_string,self::TABLE_NAME, 
                    ),['id'=>$coupon_id]
            );
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
}
