<?php

namespace YES4Trade\Model;

class rueckerstattungen_types extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'rueckerstattungen_types';
    const TABLE_INDEX = 'rueckerstattungen_type_id';

    private static $propertyTypes = [
        'rueckerstattungen_type_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rueckerstattungen_type_id'
        ],
        'rueckerstattungen_type_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'rueckerstattungen_type_title'
        ],
    ];


    public function __construct(array $values = []) {
	    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
	    parent::__construct($parentValues);
	    if (!array_key_exists(__CLASS__, self::$properties)) {
		self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
	    }
	    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
		self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
	    }
	    $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }

    public static function get_all(){
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s ORDER BY rueckerstattungen_type_title",
                self::TABLE_NAME
        ));
        while($record = xtc_db_fetch_array($query)){
            $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            $items[] = new self($record);
        }
        return $items;
    }

    public static function get_by_rueckerstattungen_type_id(int $rueckerstattungen_type_id) {
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$rueckerstattungen_type_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
        return new self($record);
    }

}

