<?php
class basics
{
	var $session;
	var $cs;
	var $ebay_user;
	var $site_id;
	var $parseTimeMS;
	var $parseTimeMS_array;

	public static function get_directory_content($path,$exclude_files = array() ){
            if(!is_dir($path)){
                return false;
            }
	    if(!$handle = opendir($path)) {
		return false;
	    }
	    $files = array();
	    // Das ist der korrekte Weg, ein Verzeichnis zu durchlaufen.
	    while (false !== ($file = readdir($handle))) {
		if($file != '.' and $file != '..' and is_file($path.$file) and !in_array($file,$exclude_files)){
		    $files[] = $file;
		}
	    }
	    closedir($handle);
	    return $files;
	}

	function set_session($value){
		$this->session = $value;
	}

	function get_session(){
		return $this->session;
	}

	function set_ebay_user($value){
		$this->ebay_user = $value;
	}

	function get_ebay_user(){
		return $this->ebay_user;
	}

	function set_site_id($value){
		$this->site_id = $value;
	}   

	function get_site_id(){
		return $this->site_id;
	}

	function debug_string($string){
		echo '<textarea style="width:90%;height:500px;">'.$string.'</textarea>';
	}

	function read_file_content($file,$mode='r'){
		$content = '';
		if(file_exists($file) and is_readable($file)){
			$handle = fopen($file,$mode);
			while (!feof($handle)) {
				$content .= fgets($handle, 4096);
			}
			fclose ($handle);
		}else{
			die($file.' not exists or not readable.');
		}
		return $content;
	}

        /**
         * Datei erzeugen oder erweitern
         * 
         * Statische Version um Dateien zu erzeugen. Error Exceptions statt 
         * die() Anweisungen bei Fehlern
         * Beim einbinden der Funktion drauf achten, dass try/catch verwendet
         * wird.
         * 
         * @param string $filename
         * @param string $content
         * @param string $mode
         * @return boolean
         */
	public static function create_file2($filename,$content,$mode = 'w'){
            if(file_exists($filename)){
                if($mode != 'a'){
                    unlink( $filename );
                }
            }else{
                if($mode != 'a'){
                    touch($filename);
                }
            }

            if (!$handle = fopen($filename, $mode)) {
                throw new Exception(sprintf("basics::create_file2(%s, %s Zeichen, %s): Kann die Datei nicht lesen oder erstellen",
                        $filename, strlen($content), $mode
                ));
            }

            // Schreibe $somecontent in die geöffnete Datei.
            if (!fwrite($handle, $content)) {
                throw new Exception(sprintf("basics::create_file2(%s, %s Zeichen, %s): Kann die Datei nicht schreiben.",
                        $filename, strlen($content), $mode
                ));
            }
            fclose($handle);
            return true;
        }
        
	function create_file($filename,$content,$mode = 'w'){
		if(file_exists($filename)){
			if($mode != 'a'){
				unlink( $filename );
			}
		}else{
			if($mode != 'a'){
				touch($filename);
			}
		}

		    if (!$handle = fopen($filename, $mode)) {
			 print "Kann die Datei $filename nicht oeffnen";
			 exit;
		    }

		    // Schreibe $somecontent in die geöffnete Datei.
		    if (!fwrite($handle, $content)) {
			print "Kann in die Datei $filename nicht schreiben";
			exit;
		    }
		    fclose($handle);
	}

	function zip_files($target_dir,$target_name,$save_path,$delete_dir=false){
		@exec("cd ".$save_path." && zip -r $target_name $target_dir");
		if($delete_dir){
			$this->rmdir($save_path.$target_dir);
		}
	}
	
	function zip_file($target_dir,$filename_to_zip,$target_filename,$delete_source_file = false,$junk_path = false){
                $junk_path_param = ($junk_path) ? ' -j ' : '';
		@exec("cd $target_dir && zip $junk_path_param $target_filename $filename_to_zip");
		if($delete_source_file){
			if($target_dir[ strlen($target_dir)-1 ] != '/'){
				$target_dir = $target_dir.'/';
			}
			unlink($target_dir.$filename_to_zip);
		}
	}
	
	
	function gz_file($target_dir,$filename_to_gz,$target_filename,$delete_source_file = false){
		@exec("cd $target_dir && gzip -c $filename_to_gz > $target_filename");
		if($delete_source_file){
			unlink($target_dir.$filename_to_gz);
		}
	}

	function rmdir($path){
		if (is_dir($path)) {
			foreach (new DirectoryIterator($path) as $file) {
				if (true === $file->isFile()) {
					unlink($file->getPathName());
				}
			}
			rmdir($path);
		}else{
			die("Cant delete $path - not a directory");
		}
	}

	function rmdir_rec( $path ) {
		if (!is_dir($path)) {
			return false;
		}

		$success = true;

		$items = new FilesystemIterator($path, FilesystemIterator::SKIP_DOTS);
		foreach ($items as $item) {
			$childPath = $item->getPathname();

			if ($item->isDir() && !$item->isLink()) {
				$success = $this->rmdir_rec($childPath);
				if ($success) {
					$success = @rmdir($childPath);
				}
			} else {
				$success = @unlink($childPath);
			}

			if (!$success) {
				return false; // abbrechen, wenn etwas schiefgeht
			}
		}

		return true;
	}

	function get_template_values($directory){
		$files=array();
	 	if ($dir= opendir($directory)){
	 		while  (($file = readdir($dir)) !==false) {
	        		if (is_file( $directory.$file) and ($file !="index.html")){
				        $files[]=array(
	                        		'id' => $file,
	                        		'text' => $file);
	        		}//if
	        	} // while
	        	closedir($dir);
	 	}
		return $files;
	}

	function get_table_size($table){
		$query = xtc_db_query("SHOW TABLE STATUS LIKE '".$table."'");
		$row = xtc_db_fetch_array($query);
		$total = $row['Data_length']+$row['Index_length'];
		return $total;
	}

	function convert_filesize($byte,$target='MB'){
		$size = $byte;
		switch($target){
			case 'KB':
				$size = $size / 1000;
				break;
			case 'MB':
				$size = $size / 1000 / 1000;
				break;
			case 'GB':
				$size = $size / 1000 / 1000 / 1000;
				break;
		}
		return $size;
	}

	/**
	 * Mit dieser Funktion startet ein HTTP Download f�r den User.
	 * Es wird fuer $file der Header Typ ermittelt und dann der Content
	 * ausgegeben
	 * 
	 * @param string $file
	 */
	function download_file($file,$delete_file = false){
		if(is_file($file)){
		   //Gather relevent info about file
			$len = filesize($file);
			$filename = basename($file);
			$file_extension = strtolower(substr(strrchr($filename,"."),1));

			//This will set the Content-Type to the appropriate setting for the file
			switch( $file_extension ) {
			  case "pdf": $ctype="application/pdf"; break;
			  case "exe": $ctype="application/octet-stream"; break;
			  case "zip": $ctype="application/zip"; break;
			  case "doc": $ctype="application/msword"; break;
			  case "xls": $ctype="application/vnd.ms-excel"; break;
			  case "ppt": $ctype="application/vnd.ms-powerpoint"; break;
			  case "gif": $ctype="image/gif"; break;
			  case "png": $ctype="image/png"; break;
			  case "jpeg":
			  case "jpg": $ctype="image/jpg"; break;
			  case "mp3": $ctype="audio/mpeg"; break;
			  case "wav": $ctype="audio/x-wav"; break;
			  case "mpeg":
			  case "mpg":
			  case "mpe": $ctype="video/mpeg"; break;
			  case "mov": $ctype="video/quicktime"; break;
			  case "avi": $ctype="video/x-msvideo"; break;

			  //The following are for extensions that shouldn't be downloaded (sensitive stuff, like php files)
			  case "php":
			  case "htm":
			  case "html":
			  case "txt": die("<b>Cannot be used for ". $file_extension ." files!</b>"); break;

			  default: $ctype="application/force-download";
			}

			//Begin writing headers
			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Cache-Control: public");
			header("Content-Description: File Transfer");

			//Use the switch-generated Content-Type
			header("Content-Type: $ctype");

			//Force the download
			$header="Content-Disposition: attachment; filename=".$filename.";";
			header($header );
			header("Content-Transfer-Encoding: binary");
			header("Content-Length: ".$len);
			@readfile($file);
                        if($delete_file){
                            unlink($file);
                        }
			exit;
		}else{
			die('<p>404 File not Found!</p>');
		}
	}

	/**
	 * Diese Funktion connected sich via curl() zu einem FTP Server um dort zu
	 * einem angegebenem Pfad eine Datei herunterzuladen und lokal zu speichern.
	 * Das Array $ftp soll die folgenden Werte enthalten:
	 * 'user'
	 * 'passwd'
	 * 'host'
	 * 'pfad'
	 * 'file'
	 *
	 * @param array $ftp Daten fuer FTP Transfer
	 * @param string $ftpFile Filename fuer Lokale Kopie der Datei
	 * @return array
	 */
	function curl_download($ftp,$ftpFile,$binary = false) {
		if(!file_exists($ftpFile)){
			touch($ftpFile);
		}

		if($binary)
			$fp   = fopen($ftpFile, "wb");
		else
			$fp   = fopen($ftpFile, "w");
		$url  = "ftp://".$ftp['user'].":".$ftp['passwd']."@".
				   $ftp['host'].":21" . $ftp['pfad'].$ftp['file'];
		$handle = curl_init();

		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, 0);
		curl_setopt($handle, CURLOPT_UPLOAD, 0);
		curl_setopt($handle, CURLOPT_FILE, $fp);
		if($binary)
			curl_setopt($handle, CURLOPT_BINARYTRANSFER,true);
		$result = curl_exec($handle);

		$info = curl_getinfo ($handle);

		curl_close($handle);

		return $info;

	}

	/**
	 * Dummy Funktion - ausgefuehrt wird main::get_notice_recipients()
	 *
	 * @param string $auth
	 * @return array
	 */
	function get_authuser_array($auth){
		return main::get_notice_recipients( $auth );
	}

	/**
	 * Gibt ein Array wieder, welches Basisinfos zur angegebenen Datei enthaelt.
	 * Existiert die Datei nicht, hat der Array Key 'exists' den Value false
	 *
	 * @param string $filename
	 * @return array
	 */
	function get_file_info($filename){
		$status_array = array(
			'exists'=>false,
			'size'=>0,
			'changed'=>false
		);
		if(!file_exists($filename)){
			return $status_array;
		}
		$status_array['exists'] = true;
		$status_array['size'] =	filesize($filename);
		$status_array['changed'] =	filectime($filename);
		return $status_array;
	}

	/**
	 * Prueft ob unter der angegebenen URL eine Bilddatei mit einem definier-
	 * baren MIME TYPE existiert
	 *
	 * @param string $url
	 * @param string $mime_type
	 * @return bool
	 */
	function pic_exists($url,$mime_type='image/jpeg'){
		$s = @getimagesize($url);
		if($s['mime'] and $s['mime'] == $mime_type){
			return true;
		}
		return false;
	}

	/**
	 * Diese Funktion connected sich zu einem FTP Server um dort unter
	 * einem angegebenem Pfad die stats() zu einer Datei zu holen
	 * Das Array $ftp soll die folgenden Werte enthalten:
	 * 'user'
	 * 'passwd'
	 * 'host'
	 * 'pfad'
	 * 'file'
	 *
	 * @param array $ftp Daten fuer FTP Transfer
	 * @return array
	 */
	function get_ftp_file_stats($ftp){
		$url  = "ftp://".$ftp['user'].":".$ftp['passwd']."@".
				   $ftp['host'].":21" . $ftp['pfad'].$ftp['file'];
		return @stat($url);
	}

	function delete_line_from_file($fileName, $lineNum){
			// check the file exists
			if(!is_writable($fileName)){
				return "The file $fileName is not writable";
			}else{
				// read the file into an array
				$arr = file($fileName);
			}
			// the line to delete is the line number minus 1, because arrays begin at zero
			$lineToDelete = $lineNum-1;
			// check if the line to delete is greater than the length of the file
			if($lineToDelete > sizeof($arr)){
				// print an error
				return "You have chosen a line number, <b>[$lineNum]</b>,  higher than the length of the file.";
			}
			unset($arr["$lineToDelete"]);
			// open the file for reading
			if (!$fp = fopen($fileName, 'w+')){
				// print an error
				return "Cannot open file ($fileName)";
			}
			// if $fp is valid
			if($fp){
			// write the array to the file
			foreach($arr as $line) {
				fwrite($fp,$line);
			}
			fclose($fp);
		}
	}

	function generate_password ($length = 8)	{

	  // start with a blank password
	  $password = "";

	  // define possible characters
	  $possible = "0123456789bcdfghjkmnpqrstvwxyz";

	  // set up a counter
	  $i = 0;

	  // add random characters to $password until $length is reached
	  while ($i < $length) {

		// pick a random character from the possible ones
		$char = substr($possible, mt_rand(0, strlen($possible)-1), 1);

		// we don't want this character if it's already in the password
		if (!strstr($password, $char)) {
		  $password .= $char;
		  $i++;
		}

	  }

	  // done!
	  return $password;
	}
	
    public function microtime_float(){
	list($usec, $sec) = explode(" ", microtime());
	   return ((float)$usec + (float)$sec);
    }

	
    public function parseTime($mode='start',$unique_id=''){
	switch($mode){
	    case 'end':
		$time_end = $this->microtime_float();
		if($unique_id != ''){
		    $start_time = $this->parseTimeMS_array[$unique_id];
		}else{
		    $start_time = $this->parseTimeMS;
		}
		$time = $time_end - $start_time;
		return sprintf('Parsetime: %s Sekunden.',$time);
		break;
	    default:
		if($unique_id != ''){
		    if(!isset($this->parseTimeMS_array) or !is_array($this->parseTimeMS_array))
			$this->parseTimeMS_array = array();
		    $this->parseTimeMS_array[$unique_id] = $this->microtime_float();
		}else{
		    $this->parseTimeMS = $this->microtime_float();
		}
		break;
	}
    }
    
    public function get_valid_filename_from_string($string){
	$string = htmlentities($string, ENT_QUOTES, 'UTF-8');
	$string = preg_replace('~&([a-z]{1,2})(acute|cedil|circ|grave|lig|orn|ring|slash|th|tilde|uml);~i', '$1', $string);
	$string = html_entity_decode($string, ENT_QUOTES, 'UTF-8');
	$string = preg_replace(array('~[^0-9a-z]~i', '~[ -]+~'), ' ', $string);
	return str_replace(' ','_',trim($string, ' -'));    
    }
    
    public function get_language_var_from_section($section,$key) {
		if(empty($key)) return '';
		// immer nur deutsch - ist eh eine kruecken loesung 09/2025
		$ini = parse_ini_file(DIR_FS_ADMIN.'includes/language_vars_german.ini', true);
		$return = array_search(strtolower($key), array_map('strtolower', $ini[$section]));
		if($return !== false)
	    	return $return;
		return $key;
    }
    
    public static function find_files($dir, $term, $subdirs = true){
	$files = array();
	$it = new RecursiveDirectoryIterator($dir);
	$display = Array ( 'jpeg', 'jpg', 'png', 'gif' );
	foreach(new RecursiveIteratorIterator($it) as $file){
	    if (in_array(strtolower(array_pop(explode('.', $file))), $display) and strstr(strtolower($file),strtolower($term)) ){
		$files[] = $file;
	    }
	}
	return $files;
    }
    
    function get_directory_subdirectories($dir){
	$files = array();
	$it = new RecursiveDirectoryIterator($dir);
	foreach(new RecursiveIteratorIterator($it) as $file){
            $fn = array_pop(explode('.',$file));
	    if ( in_array($fn,array('html','txt'.'htm','tpl'))){
		$files[] = $file->getPathName();
	    }
	}
	return $files;
    }
    
    /**
     * 
     * @param string $val Dateigroesse mit String, zb '12MB' oder "4g"
     * @return int anzahl der bytes
     */
    public static function return_bytes($val) {
        $val = trim($val);
        $last = strtolower($val[strlen($val)-1]);
        switch($last) {
            // The 'G' modifier is available since PHP 5.1.0
            case 'g':
                $val *= 1024;
            case 'm':
                $val *= 1024;
            case 'k':
                $val *= 1024;
        }
        return $val;
    }
    
    /**
     * Formatiert bytes in eine lesbare Skalierung
     * 
     * @param int $size Anzahl Bytes
     * @param int $precision Praezision fuer runden
     * @return int Bytes
     */
    public static function formatBytes($size, $precision = 2)
    {
        $base = log($size, 1024);
        $suffixes = array('', 'KB', 'MB', 'GB', 'TB');   

        return round(pow(1024, $base - floor($base)), $precision) .' '. $suffixes[floor($base)];
    }
    
    /**
     * Kalkuliert anhand der bytezahl welcher Speicheraufwand eine GD Umwandlung
     * fuer ein Foto entsteht
     * 
     * @param string $sImagePath Pfad zur Fotodatei
     * @return int Benoetigte bytes
     */
    public static function getMemoryRequiredToEdit($sImagePath)
    {
        $aImageInfo = getimagesize($sImagePath);
        return round((($aImageInfo[0] * $aImageInfo[1] * $aImageInfo['bits'] * $aImageInfo['channels'] / 8 + Pow(2, 16)) * 1.65));
    }
    
    /**
     * Ermittelt anhand der php Konfiguration wie gross eine Datei fuer Uploads
     * maximal sein darf.
     * 
     * @return int Max Uploadgroesse in bytes
     */
    public static function get_upload_max_filesize()
    {
        //select maximum upload size
         $max_upload = self::return_bytes(ini_get('upload_max_filesize'));
         //select post limit
         $max_post = self::return_bytes(ini_get('post_max_size'));
         //select memory limit
         $memory_limit = self::return_bytes(ini_get('memory_limit'));
         // return the smallest of them, this defines the real limit
         return min($max_upload, $max_post, $memory_limit);
    }    
    
    /**
     * erzeugt die Datei database_table_structure.ini 
     * diese datei enthaelt die Spalteninformationen aller Tabellen in der DB
     * benoetigt werden diese informationen um die Spaltengroesse auslesen
     * zu koennen, zb um size/maxlength bei input Feldern vorgeben zu koennen
     * 
     * @return string Pfad der erzeugten Ini Datei
     */
    public function create_sql_structure_ini_file(){
        $this->check_importdata_permissions();
        $ini_file = \main::get_importdata_path().'database_table_structure.ini';
        if(is_file($ini_file)){
            unlink($ini_file);
        }
        $tables = array();
        $q = xtc_db_query("SHOW TABLES");
        while($r = xtc_db_fetch_array($q)){
            $tables[] = current($r);
        }
        $content = '';
        foreach($tables as $table){
            $content .= sprintf("[%s]\r\n",$table);
            foreach($this->get_sql_table_informations($table) as $r){
                $content .= sprintf("%s='%s'\r\n",$r['Field'], $r['Type']);
            }
        }
        $this->create_file($ini_file, $content);
        return $ini_file;
    }

    /**
     * prueft ob das verzeichnis importdata existiert und schreibbar ist
     * 
     * @param boolean $return_mode
     * @return boolean success
     */
    private static function check_importdata_permissions($return_mode = false){
        if(!is_dir(\main::get_importdata_path()) or !is_writable(\main::get_importdata_path())){
            if($return_mode){
                return false;
            }
            die(\main::get_importdata_path().' doesnt exists or is not writable');
        }
        return true;
    }
    
    /**
     * Liefert die COLUMNS Informationen einer DB Tabelle
     * @param string $table
     * @return array
     */
    private static function get_sql_table_informations($table){
        $rows = array();
        $q = xtc_db_query(sprintf(
                "SHOW COLUMNS FROM %s",
                $table
        ));
        while($r = xtc_db_fetch_array($q)){
            $rows[] = $r;
        }
        return $rows;
    }

	public static function getDirectoryUsages(array $directories): array {
		$results = [];
	
		foreach ($directories as $dir) {
			if (!is_dir($dir)) {
				$results[] = [
					'directory' => $dir,
					'error' => 'Verzeichnis existiert nicht',
					'files' => 0,
					'total_size' => 0,
					'total_size_formatted' => '0 B'
				];
				continue;
			}
	
			$fileCount = 0;
			$totalSize = 0;
	
			$iterator = new RecursiveIteratorIterator(
				new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS),
				RecursiveIteratorIterator::LEAVES_ONLY
			);
	
			foreach ($iterator as $file) {
				if ($file->isFile()) {
					$fileCount++;
					$totalSize += $file->getSize();
				}
			}
	
			$results[] = [
				'directory' => $dir,
				'directory_clean'=>str_replace(DIR_FS_CATALOG,'',$dir),
				'files' => $fileCount,
				'total_size' => $totalSize,
				'total_size_formatted' => self::formatBytes($totalSize,2)
			];
		}
	
		return $results;
	}

	public static function ini_get_bytes(string $val): int {
		$val = trim($val);
		$last = strtolower($val[strlen($val) - 1]);
		$num = (int)$val;

		switch ($last) {
			case 'g':
				$num *= 1024;
				// kein break – bewusst weiterlaufen
			case 'm':
				$num *= 1024;
				// kein break
			case 'k':
				$num *= 1024;
		}

		return $num; // ergibt Bytes
	}
}
