<?php
/**
 * Ebay transaction FUNKTIONEN
 *
 * @author mario aspeleiter <dazze@gmx.de>
 */
class ebay_transaction {
    var $ebay_id;
    var $transaction_id;
    var $created_date;
    var $paymentmethod_used;
    var $transaction_price;
    var $quantity_purchased;
    var $currency;
    var $auction_title;
    var $products_id;
    var $ebay_products_id;
    var $auctions_id;
    var $orders_id;
    var $customers_id;
    var $customers_email_address;
    var $registration_address = array();
    var $orders_status;
    var $ExternalTransaction = array();

    public function get_orders_status() {
	return $this->orders_status;
    }

    public function set_orders_status($orders_status) {
	$this->orders_status = $orders_status;
    }

    public function get_customers_email_address() {
	return $this->customers_email_address;
    }

    public function set_customers_email_address($customers_email_address) {
	$this->customers_email_address = $customers_email_address;
    }

    public function get_registration_address() {
	return $this->registration_address;
    }

    public function set_registration_address($registration_address) {
	$this->registration_address = $registration_address;
    }

    public function get_orders_id() {
	return $this->orders_id;
    }

    public function set_orders_id($orders_id) {
	$this->orders_id = $orders_id;
    }

    public function get_customers_id() {
	return $this->customers_id;
    }

    public function set_customers_id($customers_id) {
	$this->customers_id = $customers_id;
    }

    public function get_auction_title() {
        return $this->auction_title;
    }

    public function set_auction_title($auction_title) {
        $this->auction_title = $auction_title;
    }

    public function get_products_id() {
        return $this->products_id;
    }

    public function set_products_id($products_id) {
        $this->products_id = $products_id;
    }

    public function get_ebay_products_id() {
        return $this->ebay_products_id;
    }

    public function set_ebay_products_id($ebay_products_id) {
        $this->ebay_products_id = $ebay_products_id;
    }

    public function get_auctions_id() {
        return $this->auctions_id;
    }

    public function set_auctions_id($auctions_id) {
        $this->auctions_id = $auctions_id;
    }

    public function get_ebay_id() {
	return $this->ebay_id;
    }

    public function set_ebay_id($ebay_id) {
	$this->ebay_id = $ebay_id;
    }

    public function get_transaction_id() {
	return $this->transaction_id;
    }

    public function set_transaction_id($transaction_id) {
	$this->transaction_id = $transaction_id;
    }

    public function get_created_date() {
	return $this->created_date;
    }

    public function set_created_date($created_date) {
	$this->created_date = $created_date;
    }

    public function get_paymentmethod_used() {
	return $this->paymentmethod_used;
    }

    public function set_paymentmethod_used($paymentmethod_used) {
	$this->paymentmethod_used = $paymentmethod_used;
    }

    public function get_transaction_price() {
	return $this->transaction_price;
    }

    public function set_transaction_price($transaction_price) {
	$this->transaction_price = $transaction_price;
    }

    public function get_quantity_purchased() {
	return $this->quantity_purchased;
    }

    public function set_quantity_purchased($quantity_purchased) {
	$this->quantity_purchased = $quantity_purchased;
    }
    
    public function getExternalTransaction() {
	return $this->ExternalTransaction;
    }

    public function setExternalTransaction($ExternalTransaction) {
	$this->ExternalTransaction = $ExternalTransaction;
    }

    public function get_currency() {
	return $this->currency;
    }

    public function set_currency($currency) {
	$this->currency = $currency;
    }

    function  __construct($TransactionType,$include_item_data = false) {
	    $item = $TransactionType->Item;
	    $TTStatus = $TransactionType->Status;
	    $TTCTP = $TransactionType->ConvertedTransactionPrice;
	    $this->set_ebay_id($item->ItemID);
	    $this->set_transaction_id($TransactionType->TransactionID);
	    $this->set_created_date($TransactionType->CreatedDate);
	    $this->set_quantity_purchased($TransactionType->QuantityPurchased);
	    $this->set_transaction_price($TTCTP->value);
	    $this->set_currency($TTCTP->currencyID);
	    $this->set_paymentmethod_used($TTStatus->PaymentMethodUsed);
	    $this->set_external_transaction_data($TransactionType->ExternalTransaction);
            if($include_item_data){
                $this->get_item_data_from_auction();
            }
	    $this->get_orders_data();

	    $Buyer = $TransactionType->Buyer;
	    $BA = $Buyer->RegistrationAddress;
		if(is_object($BA)){
			$names = $this->split_string($BA->Name);
			$iso2 = $this->get_iso2($BA->Country);
			$this->set_registration_address(array(
                            'company'=>'',
                            'zone_id'=>'',
                            'firstname'=>$names[0],
                            'lastname'=>$names[1],
                            'street_address'=>$BA->Street1,
                            'suburb'=>$BA->Street2,
                            'city'=>$BA->CityName,
                            'state'=>$BA->StateOrProvince,
                            'country_id'=>$this->get_countries_id_from_iso2( $iso2 ),
                            'postcode'=>$BA->PostalCode
			));
		}else{
			$BA1 = $Buyer->BuyerInfo;
                        $BA = $BA1->ShippingAddress;
			$names = $this->split_string($BA->Name);
			$iso2 = $this->get_iso2($BA->Country);
			$this->set_registration_address(array(
                            'company'=>'',
                            'zone_id'=>'',
                            'firstname'=>$names[0],
                            'lastname'=>$names[1],
                            'street_address'=>$BA->Street1,
                            'suburb'=>$BA->Street2,
                            'city'=>$BA->CityName,
                            'state'=>$BA->StateOrProvince,
                            'country_id'=>$this->get_countries_id_from_iso2( $iso2 ),
                            'postcode'=>$BA->PostalCode
			));
		}
		$this->set_customers_email_address($Buyer->Email);
    }

    /**
     * Ermittelt den Titel der Auktion, die pID sowie ebay_products_id einer
     * Transaction
     *
     * @return Array
     */
    public function get_item_data_from_auction(){
        $ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($this->get_ebay_id(),[
            'id','title','ebay_products_id','products_id'
        ]);
        if($ea !== null){
            $this->set_products_id( intval($ea->products_id) );
            $this->set_ebay_products_id( intval($ea->ebay_products_id));
            $this->set_auctions_id( intval($ea->id));
            $this->set_auction_title($ea->title);
        }
    }

    public function get_orders_data(){
        $query = yes_db_query(sprintf(
            "SELECT et.orders_id, o.customers_id,o.orders_status FROM ebay_transactions et LEFT JOIN orders o USING(orders_id) WHERE et.ebayid='%s' and et.transactionid='%s'",
            $this->get_ebay_id(),$this->get_transaction_id()
        ));
        if(yes_db_num_rows($query)){
            $record = current($query);
            $this->set_orders_id($record['orders_id']);
            $this->set_customers_id($record['customers_id']);
	    $this->set_orders_status($record['orders_status']);
        }
    }
    public static function get_countries_id_from_iso2($code){
            $query = yes_db_query(
                "SELECT countries_name,countries_id FROM countries WHERE countries_iso_code_2='".xtc_db_input(strtoupper( $code ))."'",
                true
            );
            $record = current($query);
            return (($record['countries_id'] > 0)?$record['countries_id']:STORE_COUNTRY);
    }

    public static function split_string($value){
	// WIR BASTELN VOR- UND NACHNAMEN
	$reg_fullname = array();
	$reg_fullname_array = explode(" ",trim($value));
	$reg_fullname[0] = trim(current($reg_fullname_array));
	if( count($reg_fullname_array) > 1 ) {
		for($i=1;$i<count($reg_fullname_array);$i++) {
		    if(!isset($reg_fullname[1]))
			$reg_fullname[1] = '';
		    $reg_fullname[1] .= ' '.trim($reg_fullname_array[$i]);
		}
	}
	return $reg_fullname;
    }

    public static function get_iso2($countryname){
        global $EBAYAPI;
        return $EBAYAPI->get_iso2_from_ebay_countryname($countryname);
    }

    public function get_orders_products($orders_id){
		$orders_products = array();
		$query = yes_db_query(sprintf(
			"SELECT * FROM orders_products WHERE orders_id='%s'",
			$orders_id
		));
		foreach($query as $record){
			$record['price_fixing'] = $this->get_orders_products_price_fixing($record['orders_products_id']);
			$orders_products[] = $record;
		}
		return $orders_products;
    }

    public function get_orders_products_price_fixing($opID){
		$price_fixing = array();
		$query = yes_db_query(sprintf(
			"SELECT * FROM orders_products_price_fixing WHERE orders_products_id='%s'",
			$opID
		));
		foreach($query as $record){
			$price_fixing[] = $record;
		}
		return $price_fixing;
    }
    
    private function set_external_transaction_data($ExternalTransactionType){
	if(isset($ExternalTransactionType->ExternalTransactionID) and $ExternalTransactionType->ExternalTransactionID != ''){
	    $this->setExternalTransaction(array(
		'ExternalTransactionID'=>$ExternalTransactionType->ExternalTransactionID,
		'ExternalTransactionStatus'=>$ExternalTransactionType->ExternalTransactionStatus,
		'ExternalTransactionTime'=>$ExternalTransactionType->ExternalTransactionTime,
		'PaymentOrRefundAmount'=>$ExternalTransactionType->PaymentOrRefundAmount
	    ));
	}
    }
}

