<?php
class EbayMessage {
	var $ebay_mymessage_id;
	var $messagetype; // 1 = message; 0 = alert
	var $sender;
	var $recipientuserid;
	var $sendinguserid;
	var $sendtoname;
	var $subject;
	var $messageid;
	var $externalmessageid;
	var $alertid;
	var $priority;
	var $resolutionstatus;
	var $read;
	var $receivedate;
	var $expirationdate;
	var $istimedresolution;
	var $responseenabled;
	var $responseurl;
	var $folder;
	var $msgtext;
	var $flagged;
	var $ebay_id;
	
	function getMessageTypeString($value){
		switch($value){
			case 0:
				return 'Warnung';
				break;
			case 1:
				return 'Nachricht';
				break;
		}
	}
	
	function is_saved($messageType,$folderId,$ebayId,$Id,$externalMessageId = ''){
		$IDfield = ($messageType == '0') ? 'alertid' : 'messageid';
			
		$query_raw = "SELECT count(1) as anzahl FROM ebay_mymessage WHERE ";
		if(xtc_not_null($ebayId))
			$query_raw .= " ebay_id='".xtc_db_input($ebayId)."' and ";
		$query_raw .= " messagetype='".xtc_db_input($messageType)."' and folder='".xtc_db_input($folderId)."' and ".$IDfield."='".xtc_db_input($Id)."'";
		if(xtc_not_null($externalMessageId))
			$query_raw .= " and externalmessageid='".xtc_db_input($externalMessageId)."'";
		$query = xtc_db_query($query_raw);
		$res = xtc_db_fetch_array($query);
		return $res['anzahl'];
	}
	
	function getTotalAlertCount(){
		$query = xtc_db_query("SELECT count(1) as anzahl FROM ebay_mymessage WHERE messagetype=0");
		$res = xtc_db_fetch_array($query);
		return $res['anzahl'];
	}
	
	function getNewAlertCount(){
		$query = xtc_db_query("SELECT count(1) as anzahl FROM ebay_mymessage WHERE messagetype=0 and is_read=0");
		$res = xtc_db_fetch_array($query);
		return $res['anzahl'];
	}
	
	function getTotalMessageCount(){
		$query = xtc_db_query("SELECT count(1) as anzahl FROM ebay_mymessage WHERE messagetype=1");
		$res = xtc_db_fetch_array($query);
		return $res['anzahl'];
	}
	
	function getNewMessageCount(){
		$query = xtc_db_query("SELECT count(1) as anzahl FROM ebay_mymessage WHERE messagetype=1 and is_read=0");
		$res = xtc_db_fetch_array($query);
		return $res['anzahl'];
	}
	
	function mark_as_read($id,$ebay_user){
		$query = xtc_db_query("UPDATE ebay_mymessage SET is_read='1' WHERE ebay_mymessage_id='".xtc_db_input($id)."' and ebay_user='".$ebay_user."' LIMIT 1");
	}
	
	function save_reply($id,$body,$editor_id,$ebay_user){
		$sql_insert_array = array(
			'ebay_mymessage_id'=>xtc_db_input($id),
			'msgtext'=>xtc_db_input($body),
			'editor_id'=>xtc_db_input($editor_id),
			'date_created'=>'now()',
			'ebay_user'=>$ebay_user);
		xtc_db_perform('ebay_mymessage_reply',$sql_insert_array);
	}
	
	function save_message($messageType,$folderID,$msg,$ebay_user){
		if($messageType == '0'){
		    $msgAlertID = (isset($msg->AlertID)) ? $msg->getAlertID() : '';
		    $msgActionURL = (isset($msg->ActionURL)) ? $msg->getActionURL() : '';
		    $msgPriority = (isset($msg->Priority)) ? $msg->getPriority() : 0;
		    $msgResolutionStatus = (isset($msg->ResolutionStatus)) ? $msg->getResolutionStatus() : '';
			$sql_insert_array = array(
				'messagetype'=>$messageType,
				'sender'=>xtc_db_input($msg->getSender()),
				'recipientuserid'=>xtc_db_input($msg->getRecipientUserID()),
				'subject'=>xtc_db_input($msg->getSubject()),
				
				'alertid'=>xtc_db_input($msgAlertID),
				'actionurl'=>xtc_db_input($msgActionURL),
				
				'priority'=>xtc_db_input($msgPriority),
				'resolutionstatus'=>xtc_db_input($msgResolutionStatus),
				'is_read'=>xtc_db_input($msg->getRead()),
				'receivedate'=>xtc_db_input($msg->getReceiveDate()),
				'expirationdate'=>xtc_db_input($msg->getExpirationDate()),
				'istimedresolution'=>xtc_db_input($msg->getIsTimedResolution()),
				'folder'=>$folderID,
				'ebay_id'=>xtc_db_input($msg->getItemID()),
				'msgtext'=>xtc_db_input($msg->getText()),
				'ebay_user'=>$ebay_user
			);
		}else{
			$rt = $msg->ResponseDetails;
			$rtResponseEnabled = (isset($rt->ResponseEnabled)) ? $rt->ResponseEnabled : 0;
			$rtResponseURL = (isset($rt->ResponseURL)) ? xtc_db_input($rt->ResponseURL) : '';
			$recdate_obj = new \DateTime($msg->ReceiveDate);
			$recdate = $recdate_obj->format('Y-m-d H:i:s');
			$expdate_obj = new \DateTime($msg->ExpirationDate);
			$expdate = $expdate_obj->format('Y-m-d H:i:s');

			$sql_insert_array = array(
				'messagetype'=>$messageType,
				'sender'=>xtc_db_input($msg->Sender),
				'recipientuserid'=>xtc_db_input($msg->RecipientUserID),
				'sendtoname'=>((isset($msg->SendToName)) ? xtc_db_input($msg->SendToName) : ''),
				'subject'=>xtc_db_input($msg->Subject),
				
				'messageid'=>xtc_db_input($msg->MessageID),
				'externalmessageid'=>((isset($msg->ExternalMessageID))?xtc_db_input($msg->ExternalMessageID):''),
				
				'is_read'=>((isset($msg->Read))?xtc_db_input($msg->Read):0),
				'receivedate'=>$recdate,
				'expirationdate'=>$expdate,
				'responseenabled'=>$rtResponseEnabled,
				'responseurl'=>$rtResponseURL,
				'folder'=>$folderID,
				'flagged'=>((isset($msg->Flagged))?xtc_db_input($msg->Flagged):0),
				'ebay_id'=>((isset($msg->ItemID))?xtc_db_input($msg->ItemID):''),
				'msgtext'=>xtc_db_input($msg->Text),
				'ebay_user'=>$ebay_user
			);
		}
		xtc_db_perform('ebay_mymessage',$sql_insert_array);
	}
}
?>
