<?php
class products_export
{
	var $temporary_trees,$CAT,$PARENT,$CATTree,$only_active_products,$only_active_categories,$selected_categories,$language_id,$replace_html_entities,$categories_string;
	function __construct(){
		$this->temporary_trees = array();
		$this->CAT=array();
		$this->PARENT=array();
		$this->CATTree = array();
		$this->only_active_products = true;
		$this->only_active_categories = true;
		$this->replace_html_entities = false;
		$this->selected_categories = array();
		$this->language_id = $_SESSION['languages_id'];
	}
	// mit switch ob nur aktive kategorien gezeigt werden sollen
	function getChilds($catID){
		$visible_child_categories_query_raw = "SELECT categories_id FROM categories WHERE parent_id='%s' ";
		if($this->only_active_categories){
			$visible_child_categories_query_raw .= "AND categories_status=1 ";
		}
		$visible_child_categories_query = xtc_db_query( sprintf($visible_child_categories_query_raw, $catID));
		while($visible_child_categories = xtc_db_fetch_array($visible_child_categories_query)){
			$childcatID = $visible_child_categories['categories_id'];
			$this->selected_categories[$childcatID] = true;
			$this->getChilds($childcatID);
		}
	}

	function prepare_string($value,$convert_eol = false){
		$value = str_replace("\t"," ",$value);
		$value = str_replace('"','""',$value);
		if($convert_eol){
		    //$value = str_replace(PHP_EOL,'',$value);
		}
		return '"'.$value.'"';
	}

	function buildCAT($catID){
		if(!isset($this->language_id))
			$this->language_id = $_SESSION['languages_id'];
		if (isset($this->CAT[$catID])){
		        return  $this->CAT[$catID];
		} else {
		        $cat=array();
		        $tmpID=$catID;

		        while ($this->getParent($catID)!=0 || $catID!=0)
		        {
		                $catname=$this->getCategoryName($catID);
		                $catID=$this->getParent($catID);
		                $cat[]=$catname;
		        }
		        $catStr='';
		        for ($i=count($cat);$i>=0;$i--)
		        {
		                $catStr.=$cat[$i-1].' > ';
		        }
		        $this->CAT[$tmpID]=$catStr;
			return $this->CAT[$tmpID];
		}
	}

	function getParent($catID){
		if (isset($this->PARENT[$catID]))
		{
			return $this->PARENT[$catID];
		} else {
			$parent_query=xtc_db_query("SELECT parent_id FROM ".TABLE_CATEGORIES." WHERE categories_id='".$catID."' and link_id=0");
			$parent_data=xtc_db_fetch_array($parent_query);
			$this->PARENT[$catID]=$parent_data['parent_id'];
			return  $parent_data['parent_id'];
		}
	}

	function buildCATTree($catID,$level,$path){
		$visible_child_categories_query_raw = "SELECT categories_id FROM categories WHERE parent_id='%s' AND link_id=0";
		if($this->only_active_categories){
			$visible_child_categories_query_raw .= " AND categories_status=1 ";
		}
		$visible_child_categories_query = xtc_db_query( sprintf( $visible_child_categories_query_raw, $catID));
		$spaces = '';
		for($i=0;$i<=$level;$i++){
			$spaces .= '&nbsp;&nbsp;&nbsp;&nbsp;';
		}
		while($visible_child_categories = xtc_db_fetch_array($visible_child_categories_query)){
			$childcatID = $visible_child_categories['categories_id'];
			$path_array = explode('_',$path);
			$new_path = $path_array[0];
			for($i=1;$i<=$level;$i++){
				$new_path .= '_'.$path_array[$i];
			}
			$path = $new_path;
			$path .= '_'.$childcatID;
		    	$this->categories_string .= $spaces.$this->drawCatBox($childcatID,$path).$this->getCategoryName($childcatID).'<br>';
			$this->temporary_trees[$catID][$childcatID] = $this->buildCATTree($childcatID,$level+1,$path);
		}
		return @$this->temporary_trees[$catID];
	}

	function getCategoryName($catID):string{
            $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                    intval($catID), 
                    intval($this->language_id),
                    ['categories_name']
            );
            if($cd !== null){
		return $cd->categories_name;
            }
            return '';
	}

	function drawCatBox($catID,$path){
		return '<input type="checkbox" name="cat[]" value="'.$path.'" DISABLED>';
	}

	function getP2CWhereSQLString($all_categories,$categories_array){
		$where = $this->getProductsStatusWhereSQLString();
		if($all_categories != 1){
			for($i=0;$i<sizeOf($categories_array);$i++){
				$split = current(array_reverse(split('_',$categories_array[$i])));
				$catID = $split;
				$this->selected_categories[$catID] = true;
				$this->getChilds($catID);
			}
			if(sizeOf($this->selected_categories)>0){
				$pc_where = ' and (';
				foreach($this->selected_categories as $catID => $v){
					$pc_where .= " p2c.categories_id='".$catID."' or ";
				}
				$pc_where = substr($pc_where,0,(strlen($pc_where)-3));
				$pc_where .= ')';
				$where .= $pc_where;
			}
		}
		return $where;
	}
	
	function getProductsStatusWhereSQLString(){
		if($this->only_active_products){
			return ' AND p.products_status=1 ';
		}
	}

	function getCategoriesString(){
	    if(!isset($this->language_id))
		$this->language_id = $_SESSION['languages_id'];
	    $visible_categories_query_raw = "SELECT categories_id FROM categories WHERE parent_id=0 AND link_id=0";
	    if($this->only_active_categories){
		$visible_categories_query_raw .= " AND categories_status=1 ";
	    }
	    $visible_categories_query = xtc_db_query($visible_categories_query_raw);
	    while($visible_categories = xtc_db_fetch_array($visible_categories_query)){
		    $catID = $visible_categories['categories_id'];
		    $this->categories_string .= xtc_draw_separator().$this->drawCatBox($catID,$catID).$this->getCategoryName($catID).'<br>';
		    $this->tree[$catID] = $this->buildCATTree($catID,$level = 0,$path=$catID);
	    }
	    return '<table border="0" cellspacing="0" id="categories_select_table"><tr><td class="smallText">'.$this->categories_string.'</td></tr></table>';
	}
	    
	function getCategoryJSString(){
	    $script = '<script language="javascript"><!--'."\r\n";
	    $script .= "function allCatFunc(){\r\n";
	    $script .= "    myform = document.forms['modules'];\r\n";
	    $script .= "    myform_len = myform.length;\r\n";
	    $script .= "    mychecked = (myform.allCat.checked)?true:false;\r\n";
	    $script .= "    for(i=0;i<myform_len;i++){\r\n";
	    $script .= "        if(myform.elements[i].name == 'cat[]'){\r\n";
	    $script .= "             myform.elements[i].disabled = mychecked;\r\n";
	    $script .= "        }\r\n";
	    $script .= "    }\r\n";
	    $script .= "}\r\n";
	    $script .= "//--></script>\r\n";
	    return $script;
	}

	// ERZEUGT SEO LINKS
	// WIRD AUCH VERWENDET IN CLASS product.php
	function xtc_href_link($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true, $urlencode=false) {
	    global $request_type, $session_started, $http_domain, $https_domain,$truncate_session_id;

	    if (!xtc_not_null($page)) {
	      //die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine the page link!<br /><br />');
	      $page = 'index.php';
	    }

	    if ($connection == 'NONSSL') {
	      $link = HTTP_SERVER . DIR_WS_CATALOG;
	    } elseif ($connection == 'SSL') {
	      if (ENABLE_SSL == true) {
	        $link = HTTPS_SERVER . DIR_WS_CATALOG;
	      } else {
	        $link = HTTP_SERVER . DIR_WS_CATALOG;
	      }
	    } else {
	      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL</b><br /><br />');
	    }
	    if (xtc_not_null($parameters)) {
	      $link .= $page . '?' . $parameters;
	      $separator = '&';
	    } else {
	      $link .= $page;
	      $separator = '?';
	    }

	    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

	// Add the session ID when moving from different HTTP and HTTPS servers, or when SID is defined
	    if ( ($add_session_id == true) && ($session_started == true) && (SESSION_FORCE_COOKIE_USE == 'False') ) {
	      if (defined('SID') && xtc_not_null(SID)) {
	        $sid = SID;
	      } elseif ( ( ($request_type == 'NONSSL') && ($connection == 'SSL') && (ENABLE_SSL == true) ) || ( ($request_type == 'SSL') && ($connection == 'NONSSL') ) ) {
	        if ($http_domain != $https_domain) {
	          $sid = session_name() . '=' . session_id();
	        }
	      }
	    }

	//--- SEO Hartmut König -----------------------------------------//
	    if ((isset($_REQUEST['test']) && $_REQUEST['test']) ||
	        ((SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true)) )
	        {
	        require_once(DIR_FS_INC . 'shopstat_functions.inc.php');

	        $seolink = shopstat_getSEO( $page,
	                                    $parameters,
	                                    $connection,
	                                    $add_session_id,
	                                    $search_engine_safe,
	                                    'admin');
	        if($seolink)
	            {
	            $link       = $seolink;
	            $elements   = parse_url($link);
	            (isset($elements['query']))
	                ? $separator = '&'
	                : $separator = '?';
	            }
	        }
	//--- SEO Hartmut König -----------------------------------------//

		// remove session if useragent is a known Spider
	    if ($truncate_session_id) $sid=NULL;

	    if (isset($sid)) {
	      $link .= $separator . $sid;
	    }
	/*
	    if ( (SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true) ) {
	      while (strstr($link, '&&')) $link = str_replace('&&', '&', $link);

	      $link = str_replace('?', '/', $link);
	      $link = str_replace('&', '/', $link);
	      $link = str_replace('=', '/', $link);
	      $separator = '?';
	    }
	*/

	    //-- W3C-Conform
	    if($urlencode)
	        {
	        $link = htmlentities($link);
	        }

	    return $link;
	}

	function replace_html_entities($string){
		if($this->replace_html_entities == true){
			return html_entity_decode($string);
		}
		return $string;
	}
}

