<?php
class yes_lister_orders extends yes_lister
{
	var $order;
	function __construct($listing_sql,$listing_table,$page_link,$select_field_array = array(),$where_field_array=array(),$ajax_box = 1,$ajax_get_param_key = 'oID',$ajax_link){
		$this->listing_sql = $listing_sql;
		$this->listing_table = $listing_table;
		$this->select_field_array = $this->setSelectFieldArray($select_field_array);
		$this->where_field_array = $where_field_array;
		$this->page_link = $page_link;
		$this->ajax_box = $ajax_box;
		$this->ajax_get_param = $ajax_get_param_key;
		$this->ajax_link = $ajax_link;
		$this->query();
	}

	function getHeadingRows(){
		$headings = array();
		$rows = $this->select_field_array;
		$ajax_payment_get = '';
		if($_GET['payment_method'] and sizeOf($_GET['payment_method']) > 0 and is_array($_GET['payment_method'])){
			foreach($_GET['payment_method'] as $k=>$payment){
				$ajax_payment_get .= '&payment_method[]='.$payment;
			}
		}
		foreach($rows as $key=>$value){
			if(!$value['heading_hide'] or $value['heading_hide'] == 0){
				$headings[] = array(
					'title'=>$value['heading'],
					'sort'=>$value['sortable'],
					'column'=>$value['column'],
					'sort_href_asc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by','payment_method')).'order_by='.$value['field'].'%20DESC'.$ajax_payment_get),
					'sort_href_desc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by','payment_method')).'order_by='.$value['field'].'%20ASC'.$ajax_payment_get)
				);
			}else{
				if($this->$value['heading_display_function']() == true){
					$headings[] = array(
						'title'=>$value['heading'],
						'sort'=>$value['sortable'],
						'column'=>$value['column'],
						'sort_href_asc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by','payment_method')).'order_by='.$value['field'].'%20DESC'.$ajax_payment_get),
						'sort_href_desc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by','payment_method')).'order_by='.$value['field'].'%20ASC'.$ajax_payment_get)
					);
				}
			}
		}
		return $this->record_sort($headings,'column');
	}

	function display($navigation,$query_numrows,$view_limit){
		global $_GET;

		$ajax_payment_get = '';
		if($_GET['payment_method'] and sizeOf($_GET['payment_method']) > 0 and is_array($_GET['payment_method'])){
			foreach($_GET['payment_method'] as $k=>$payment){
				$ajax_payment_get .= '&payment_method[]='.$payment;
			}
		}

		if($this->ajax_box == 1){
			$this->smarty->assign('ajax_box',1);
			$this->split_string  = $navigation->display_count($query_numrows, $view_limit, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page', 'action','page_type','payment_method')).'page_type='.$page_type.$ajax_payment_get);
			$this->split_string .= '<br />'.$navigation->display_links($query_numrows, $view_limit, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page','page_type','payment_method')).'page_type='.$page_type.$ajax_payment_get);
		}else{
			$this->smarty->assign('split_text',$navigation->display_count($query_numrows, $view_limit, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page', 'action','page_type','payment_method')).'page_type='.$page_type.$ajax_payment_get));
			$this->smarty->assign('split_navi',$navigation->display_links($query_numrows, $view_limit, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page','page_type','payment_method')).'page_type='.$page_type.$ajax_payment_get));
		}

		$this->smarty->assign('TEXT_SORT_ASC',TEXT_SORT_ASC);
		$this->smarty->assign('TEXT_SORT_DESC',TEXT_SORT_DESC);
		$this->smarty->assign('headings',$this->getHeadingRows());
		$this->smarty->assign('listing',$this->result_list);
		$key = $this->select_field_array[$this->index_field]['field'];
		$this->smarty->assign('start_row_input',xtc_draw_hidden_field($this->start_row_input_id,$this->active_row->$key));
		$this->start_row_input = xtc_draw_hidden_field($this->start_row_input_id,$this->active_row->$key);
		$this->smarty->assign('AJAX_GET_PARAM_KEY',$this->ajax_get_param);
		$this->smarty->assign('AJAX_LINK',$this->ajax_link);

		return $this->smarty->fetch($this->template_file);
	}

        /** function_params hier nicht implementiert. Details dazu in der
         *  class.yes_lister.php
         * 
         * @param type $value
         * @param type $class
         * @param type $function
         * @param type $row
         * @param array $function_params
         * @return string
         */
	function formatOutput($value,$class,$function,$row, array $function_params = []){
		if(!strstr($function,'intern::')){
			if(xtc_not_null($function) and function_exists($function)){
				$value = call_user_func($function,$value);
			}
		}else{
			$function = str_replace('intern::','',$function);
			$value_field = '';
			if(strstr($function,'|')){
				$split = explode('|',$function);
				$value_field = $row[$split[1]];
				$function = $split[0];
			}
			if(xtc_not_null($function)){
				$value = $this->$function($value,$value_field);
			}
		}
		switch($class){
			case 'int':
				return (int) $value;
				break;
			case 'currency':
				return number_format($value,2,',','.').'&nbsp;';
				break;
			case 'string':
				return $value;
				break;
			case 'date':
				if($value > 0){
					return xtc_date_short($value);
				}
				return '';
				break;
		}
	}

	function get_orders_column_checkbox($value){
		return xtc_draw_checkbox_field('statusOID[]',$value);
	}

	function get_orders_column($value){
		$order = $this->get_order($value);
		$string = '';
		if($this->active_row->orders_id == $value){
			$string .= xtc_draw_hidden_field('start_oID',$value).$value;
		}else{
			$string .= $value;
		}
		if($order->info['ebay_id'] != '')
			$string .= '<br /><i>('.$order->info['ebay_id'].')</i>';
		return $string;
	}

	function get_total($value){
		$shippings = 0;
		$total_sum = 0;
		$order = $this->get_order($value);
		$string = '';
		for($a=0;$a<sizeOf($order->totals);$a++){
			switch($order->totals[$a]['class']){
				case 'ot_total':
					$string .= xtc_draw_hidden_field('ototal_'.$value,$order->totals[$a]['value'] );
					$total_sum = number_format($order->totals[$a]['value'],2,',','');
					break;
				case 'ot_tax':
					$string .= xtc_draw_hidden_field('otax_'.$value,$order->totals[$a]['value'] ); 
					break;
				case 'ot_shipping':
					$string .= xtc_draw_hidden_field('oship_'.$value.'_'.$shippings,$order->totals[$a]['value'] ); 
					$shippings++;
					break;
				case 'ot_subtotal':
					$string .= xtc_draw_hidden_field('osubtotal_'.$value,$order->totals[$a]['value'] ); 
					break;
			}
		}
		return $string.$total_sum.'&nbsp;'.$order->info['currency'].'&nbsp;';
	}

	function get_customer($customer,$second_field){
		$orders_id = $second_field;
		$order = $this->get_order($orders_id);
		if(xtc_not_null($order->customer['company']))
			return $order->customer['company'].'<br />'.$customer;
		else
			return $customer;
	}

	function get_order($orders_id,$second_field = ''){
		if(!$this->order[$orders_id])
			$this->order[$orders_id] = new order($orders_id);
		return $this->order[$orders_id];
	}

	function get_bezahlt($value,$second_field){
		$bezahldatum = '::HIDE::';
		if($_GET['netto'] == 1){
			$orders_id = $second_field;
			$order = $this->get_order($orders_id);
			$bezahlt_query = xtc_db_query("SELECT date_added FROM orders_status_history WHERE orders_status_id='".ORDERS_STATUS_BEZAHLT."' and orders_id='".$orders_id."' ORDER BY date_added LIMIT 1");
			$bezahlt = xtc_db_fetch_array($bezahlt_query);
			if($order->info['orders_status'] == ORDERS_STATUS_BEZAHLT or $order->info['orders_status'] == ORDERS_STATUS_VERSENDET or $order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN)
				$bezahldatum = ($bezahlt['date_added'] != '' and $bezahlt['date_added'] != '0000-00-00 00:00:00') ? yes_strftime('%d.%m.%Y',strtotime($bezahlt['date_added'])) : yes_strftime('%d.%m.%Y',strtotime($order->info['date_purchased']));
		}
		return $bezahldatum;
	}

	function show_row_netto(){
		if($_GET['netto'] == 1)
			return true;
		else
			return false;
	}
}
?>
