<?php
class email_export {
    var $export_date_to, $write_path;
    const TEMPLATE_ATTACHEMENT = <<<EMLATTTPL
\nContent-Type: TEMPLATE_ATTACH_TYPE;name="TEMPLATE_ATTACH_FILENAME"
Content-Transfer-Encoding: base64
Content-Disposition: attachment;filename="TEMPLATE_ATTACH_FILENAME"

TEMPLATE_ATTACH_CONTENT
--TEMPLATE_ATTACH_UNIQUEID
EMLATTTPL;
    
    const TEMPLATE_EMAIL = <<<EMLTPL
From: TEMPLATE_FROM_ADDRESS
Date: TEMPLATE_DATE
MIME-Version: 1.0
To: TEMPLATE_TO_ADDRESS
Subject: TEMPLATE_SUBJECT
Content-Type: multipart/mixed; boundary="TEMPLATE_UNIQUEID"

This is a message with multiple parts in MIME format.
--TEMPLATE_UNIQUEID
Content-Type: text/html

TEMPLATE_BODY
--TEMPLATE_UNIQUEID
EMLTPL;


    
    function __construct( string $date ){
        $this->export_date_to = $date;
        $this->write_path = main::get_secure_path().'EMAIL_ARCHIV/';
        if(!is_dir($this->write_path)){
            mkdir($this->write_path);
        }
    }
    
    private static function zufall($length = 10) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    private static function schreib($filename, $somecontent){

        if (!$fp = fopen($filename, "w")) {
             print "Kann die Datei $filename nicht öffnen";
             return false;
        }

        // Schreibe $somecontent in die geöffnete Datei.
        if (fwrite($fp, $somecontent) === FALSE) {
            print "Kann nicht in die Datei $filename schreiben";
            return false;
        }
        fclose($fp);
        return true;
    }
    
    private function get_email_data(){
        $q = xtc_db_query(sprintf(
            "SELECT emb.email_body,em.id,subject,mailto,from_name,from_email,date FROM ebay_emails em LEFT JOIN ebay_email_bodys emb ON em.id=emb.email_id WHERE date < '%s'",
            $this->export_date_to
        ));
        $emails = [];
        while($record = xtc_db_fetch_array($q)){
            $emails[] = $record;
        }
        foreach($emails as $nr=>$e){
            $eat_list = \YES4Trade\Model\ebay_email_attachments::get_by_email_id(intval($e['id']),['filename']);
            foreach($eat_list as $eat){
                if(!isset($emails[ $nr ]['attachments'])){
                    $emails[ $nr ]['attachments'] = [];
                }
                $emails[ $nr ]['attachments'][] = $eat->filename;
            }
        }
        return $emails;
    }
    
    private function zip_emails(){
        $dir    = $this->write_path;
        $files = scandir($dir);
        $to_zip = [];
        foreach($files as $f){
            if($f == '.' || $f == '..'){
                continue;
            }
            $to_zip[] = $f;
        }
        if(sizeOf($to_zip)){
            $zipfile = $dir.'EMAILARCHIV-'.$this->export_date_to.'.zip';
            $zip = new ZipArchive;
            if ($zip->open($zipfile,ZipArchive::CREATE) === TRUE) {
                foreach($to_zip as $z){
                    $zip->addFile($dir.$z, $z);
                }
                $zip->close();
                return $zipfile;
            } else {
                echo 'cant create zipfile '.$zipfile;
                return false;
            }
        }
    }
    
    private function download( $file ){
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.basename($file));
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file));
        ob_clean();
        flush();
        readfile($file);
        
        unlink($file);
        $dir    = $this->write_path;
        $files = scandir($dir);
        foreach($files as $f){
            if($f == '.' || $f == '..'){
                continue;
            }
            unlink($dir.$f);
        }
        exit;    
    }
    
    public function export(){
        $emails = $this->get_email_data();
        foreach($emails as $e){
            $id = $this->zufall(24);
            $eml_att = '';
            for($i=0;$i<sizeOf( (array) $e['attachments']);$i++){
                    $file = \main::get_importdata_path().'mail_attachments/'.$e['id'].'/'.yes_get_sha1_from_string($e['attachments'][$i]);
                    if(!is_file($file) or !is_readable($file)){
                        die(basename($file).' not readable');
                    }
                    $mct = mime_content_type($file);
                    $content = file_get_contents($file);
                    $eml_att .= str_replace([
                            'TEMPLATE_ATTACH_TYPE',
                            'TEMPLATE_ATTACH_FILENAME',
                            'TEMPLATE_ATTACH_FILENAME',
                            'TEMPLATE_ATTACH_CONTENT',
                            'TEMPLATE_ATTACH_UNIQUEID',
                    ],[
                            $mct,
                            basename($e['attachments'][$i]),
                            basename($e['attachments'][$i]),
                            base64_encode($content),
                            $id,
                    ],$this::TEMPLATE_ATTACHEMENT);
            }

            $date = new DateTime($e['date']);
            $eml = str_replace([
                    'TEMPLATE_FROM_ADDRESS',
                    'TEMPLATE_DATE',
                    'TEMPLATE_TO_ADDRESS',
                    'TEMPLATE_SUBJECT',
                    'TEMPLATE_BODY',
                    'TEMPLATE_UNIQUEID',
                    'TEMPLATE_UNIQUEID',
            ],[
                    $e['from_email'],
                    $date->format('r'),
                    $e['mailto'],
                    $e['subject'],
                    $e['email_body'],
                    $id,
                    $id,
            ],$this::TEMPLATE_EMAIL);
            if($eml_att !=''){
                    $eml .= $eml_att;
            }
            $sfile = mb_ereg_replace("([^\w\s\d\-_~,;\[\]\(\).])", '', $e['from_email'].'-'.$e['date']);
            // Remove any runs of periods (thanks falstro!)
            $sfile = mb_ereg_replace("([\.]{2,})", '', $sfile);

            $this->schreib($this->write_path.$sfile.'.eml',$eml);
            $zipfile = $this->zip_emails();
            if($zipfile !== false){
                $this->download($zipfile);
            }
        }
    }
}