<?php
/**
 * condition muss beim artikel gesetzt sein
 * die kategorie muss mit google product feed versehen sein
 *
 * @author mario
 */
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
class google_product_feed_export {
	var $separator = "\t";
	var $filename;
	var $tmp_filename = '';
        var $tmp_file_handler;
	var $language_id;
	var $availability = 'in stock';
	#	'available for order'
	#	'out of stock'
	#	'preorder'
	var $xtPrice;
        var $delimiter = "\t";
	
	function __construct($language_id) {
            $this->language_id = $language_id;
            $this->xtPrice = new xtcPrice(DEFAULT_CURRENCY,DEFAULT_CUSTOMERS_STATUS_ID);
            $this->tmp_filename = get_class($this).'_tmp.csv';
            $file = \main::get_exportdata_path().$this->tmp_filename;
            $this->tmp_file_handler = fopen($file, 'a');
            if(!$this->tmp_file_handler){
                throw new Exception(sprintf('Cant open %s for appending',$file));
            }
	}
	
        private function get_pd_sql_field(){
            $desc_from = (isset($_REQUEST['description_src'])) ? $_REQUEST['description_src'] : '';
            $pd_sql_field = 'products_description';
            switch($desc_from){
                    case 'apparel':
                        break;
                    case 'products_description':
                        $pd_sql_field = 'products_description';
                        break;
                    case 'short_description':
                        $pd_sql_field = 'products_short_description';
                        break;
                    case 'extratext':
                        $pd_sql_field = 'products_extra_text';
                        break;
            }
            return $pd_sql_field;
        }
        
        private function append_tmp($fields){
            if(!is_array($fields) or !sizeOf($fields)){
                return false;
            }
	    foreach($fields as $knr=>$kv){
		$fields[$knr] = iconv('UTF-8','WINDOWS-1252',$kv);
	    }
            fputcsv($this->tmp_file_handler, $fields,$this->delimiter);
        }
        
        /**
         * ich habe keine Ahnung was diese Funktion bewirken soll, aber ich lass
         * sie als private Funktion mal drin, falls diese irgendwo gebraucht
         * werden sollte
         * 2017/07
         */
        private function calc_cartesian_netto_prices( $properties ){
            // NUR BEI BEKLEIDUNG - UND DORT AUCH SINNFREI BEI EINZELARTIKELN
            $diff_properties_id = array();
            foreach($properties as $title => $property){
                    $diff_properties_id[ $property['title'] ][] = $property['id'];
            }
            $cartesians = cartesian_product_of_arrays($diff_properties_id);
            if(!sizeOf($cartesians)){
                return false;
            }
            foreach($cartesians as $x => $variation){
                    $netto_price = 0;
                    if(is_array($variation)){
                            foreach($variation as $properties_values_id){
                                    $props = $this->get_property_data_by_properties_values_id($properties_values_id, $properties);
                                    $netto_price += $props['price_netto'];
                            }
                    }else{
                            $props = $this->get_property_data_by_properties_values_id($variation, $properties);
                            $netto_price += $props['price_netto'];
                    }
                    $variation['add_netto_price'] = $netto_price;
            }
        }
        
        private function get_db_values($pd_sql_field){
            $_items = array();
            $query = xtc_db_query(sprintf(
                "SELECT p.products_id,products_name,%s,p.products_image,products_conditions_id,products_price,manufacturers_id,products_weight,p.products_ean,p.mpn as products_mpn FROM products p LEFT JOIN products_description pd USING(products_id) LEFT JOIN products_collies pc ON pd.products_id=pc.collie_products_id WHERE products_status=1 AND language_id='%s' AND pc.products_collies_id IS NULL AND (p.no_google_product_feed_export=0 or p.no_google_product_feed_export IS NULL)",
                $pd_sql_field,$this->language_id
            ));
            $country_id = STORE_COUNTRY;
            while($record = xtc_db_fetch_array($query)){
                $record['products_tax_class_id'] = yes_eu_oss_get_products_tax_class_id($record['products_id'], $country_id);
                $_items[] = $record;
            }
            return $_items;
        }
        
        /**
         * erzeugt eine CSV Datei und gibt den Dateinamen zurueck
         * @return STRING pfad zur erzeugten CSV Datei
         */
	public function get_csv_data(){
            $pd_sql_field = $this->get_pd_sql_field();
            $this->append_tmp( $this->get_header_row() );
            $records = $this->get_db_values($pd_sql_field);
            foreach($records as $record){
                    $products_data = $this->get_products_data($record,$pd_sql_field); // EU OSS SAFE
                    if(sizeOf($products_data['properties'])){
                        $this->calc_cartesian_netto_prices($products_data['properties']);
                    }
                    
                    /**
                     * BOF - MPN/GTIN AUS YES - TICKET 2152
                     */
                           if(!isset($products_data[ 'gtin' ]) or empty($products_data[ 'gtin' ])){
                               $products_data[ 'gtin' ] = $products_data['products_ean'];
                           }
                           if(!isset($products_data[ 'mpn' ]) or empty($products_data[ 'mpn' ])){
                               $products_data[ 'mpn' ] = $products_data['products_mpn'];
                           }
                    /**
                     * EOF - MPN/GTIN AUS YES - TICKET 2152
                     */
                    $csv_row = array(
                            $products_data[ 'products_id' ],
                            $products_data[ 'products_name' ],
                            $products_data[ 'description' ],
                            $products_data[ 'category' ],
                            $products_data[ 'product_type' ],
                            $products_data[ 'link' ],
                            $products_data[ 'image' ],
                            ((isset($products_data[ 'additional_image_link' ]))?$products_data[ 'additional_image_link' ]:''),
                            @$products_data[ 'condition' ],
                            @$products_data[ 'availability' ],
                            @$products_data[ 'price' ],
                            @$products_data[ 'brand' ],
                            @$products_data[ 'gtin' ],
                            @$products_data[ 'mpn' ],
                        @$products_data['unit_pricing_base_measure'],
                        @$products_data['unit_pricing_measure']
                    );
                    if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
                            $csv_row[] = @$products_data[ 'gender' ];
                            $csv_row[] = @$products_data[ 'age_group' ];
                            $csv_row[] = @$products_data[ 'color' ];
                            $csv_row[] = @$products_data[ 'size' ];
                            $csv_row[] = @$products_data[ 'pattern' ];
                            $csv_row[] = @$products_data[ 'material' ];
                            //$csv_row[] = @$products_data[ 'beschreibung' ];
                    }

                    $csv_row[] = $products_data[ 'shipping' ];
                    $csv_row[] = $products_data[ 'weight' ];
                    $csv_row[] = $products_data[ 'adwords_grouping' ];
                    $csv_row[] = $products_data[ 'adwords_labels' ];
                    
                    $this->append_tmp($csv_row);
		}
        fclose($this->tmp_file_handler);
		return \main::get_exportdata_path().$this->tmp_filename;
                
	}
	
	private function get_header_row(){
		if($this->language_id == 2){
			$header = array(
				'ID','Titel','Beschreibung','Google Produktkategorie','Produkttyp','Link','Bildlink','Zusätzlicher Bildlink','Zustand',
				'Verfügbarkeit','Preis',
				'Marke','GTIN','MPN','Einheitsmaß_für_Grundpreis','Maß_für_Grundpreis'
			);
			if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
				$header[] = 'Geschlecht';
				$header[] = 'Altersgruppe';
				$header[] = 'Farbe';
				$header[] = 'Größe';
				$header[] = 'Muster';
				$header[] = 'Material';
				
				// HIER EIGENTLICH VARIANTEN
			}
			$header[] = 'Versand';
			$header[] = 'Versandgewicht';
			$header[] = 'adwords gruppierung';
			$header[] = 'adwords labels';
		}else{
			$header = array(
				'id','title','description','google_product_category','price','condition','link','image_link','additional_image_link','availability','price','brand'
			);
		}
		return $header;
	}
	
	private function get_products_data($record,$pd_sql_field){
		$record['description'] = $this->prepare_string($record[$pd_sql_field]);
		$gpf_data = $this->get_gpf_data($record['products_id']);
		if(is_array($gpf_data) and sizeOf($gpf_data)){
		    foreach($gpf_data as $k=>$v){
                        
			    if($k == 'google_condition') $k = 'condition';
                            
                            if($_REQUEST['description_src'] == 'apparel' and $k == 'beschreibung'){
                                $record['description'] = $this->prepare_string($v);
                            }
                            
			    $record[ $k ] = $v;
		    }
		}

		$mo_images = $this->get_mo_images($record['products_id']);
		if(sizeOf($mo_images)){
			$record['additional_image_link'] = implode(',',$mo_images);
		}
		$record['category'] = $this->get_category_id($record['products_id']);
                
		$record['link'] = $this->xtc_href_link('product_info.php', 'products_id='.$record['products_id'], 'NONSSL', false);
		$record['image'] = $this->get_image_url($record['products_image']);
		$record['price'] = number_format($this->xtPrice->xtcGetPrice($record['products_id'],
                    false,
                    1,
                    $record['products_tax_class_id'], // EU OSS SAFE
                    ''
                ),2,',','.').' '.DEFAULT_CURRENCY;
		$record['price_raw'] = $this->xtPrice->xtcGetPrice($record['products_id'],
                    false,
                    1,
                    $record['products_tax_class_id'], // EU OSS SAFE
                    ''
                );
		$this->category_string = '';
		$cID = $this->get_product_category_id($record['products_id']);
		if($cID > 0){
			$this->get_category_tree($cID);
		}
		$record['product_type'] = $this->category_string;
		$record['brand'] = $this->get_products_manufacturer($record['manufacturers_id']);
                if(defined('MODULE_ORDER_TOTAL_SHIPPING_STATUS') and MODULE_ORDER_TOTAL_SHIPPING_STATUS == 'true'){
                    if(MODULE_ORDER_TOTAL_SHIPPING_DESTINATION == 'national'){
                        if(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true'){
                            if($record['price_raw'] >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER){
                                $record['shipping'] = sprintf('DE::Free:0,00 %s',DEFAULT_CURRENCY);
                            }
                        }
                    }
                }
                if(!isset($record['shipping'])){
                    $record['shipping'] = $this->get_shippingcosts_de($record['products_id']);
                }
                // formatieren mit Komma statt Punkt - ticket 2657
		$record['weight'] = sprintf('%s kg', number_format($record['products_weight'],4,',',''));
		$properties = array();
		if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
			$properties_id_array = yes_get_products_properties_id_array($record['products_id']);
			if(sizeOf($properties_id_array)){
				foreach($properties_id_array as $properties_id){
					$p = new product_properties($properties_id);
					$pd = $p->getDescription($this->language_id);
					//echo $pd->getTitle();
					$pv = $p->getValues($this->language_id);
					foreach($pv as $pvalue){
						$pvID = $pvalue['description']->getProducts_properties_values_id();
						$properties[] = array(
							'title'=>$pd->getTitle(),
							'value'=>$pvalue['description']->getTitle(),
							'price_netto'=>$pvalue['price'],
							'id'=>$pvID);
					}
				}
			}
		}
		$record['properties'] = $properties;
                $record['unit_pricing_base_measure'] = $this->get_unit_pricing_base_measure($record['products_id']);
                $record['unit_pricing_measure'] = $this->get_unit_pricing_measure($record['products_id']);
                
                
		return $record;
	}
	
	private function get_category_id($products_id){
		$query = xtc_db_query(sprintf(
			"SELECT p2c.categories_id,cd.categories_name,cd.google_product_feed_category FROM products_to_categories p2c LEFT JOIN categories c USING(categories_id) LEFT JOIN categories_description cd USING(categories_id) WHERE p2c.products_id='%s' AND c.categories_status=1 AND c.link_id=0 AND cd.language_id='%s' LIMIT 1",
			$products_id,$this->language_id
		));
		if(!xtc_db_num_rows($query))
			return '';
		$record = xtc_db_fetch_array($query);
		return $record['google_product_feed_category'];
	}
	
	private function prepare_string($string){
		return str_replace(array("\r\n","\r","\n"),'',$string);
	}
	
	private function xtc_href_link($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true, $urlencode=false) {
	    global $request_type, $session_started, $http_domain, $https_domain,$truncate_session_id;

	    if (!xtc_not_null($page)) {
	      //die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine the page link!<br /><br />');
	      $page = 'index.php';
	    }

	    if ($connection == 'NONSSL') {
		// KANN WECH
	      //$link = HTTP_SERVER . DIR_WS_CATALOG;
	      $link = HTTP_SERVER;
	    } elseif ($connection == 'SSL') {
	      if (ENABLE_SSL == true) {
	        $link = HTTPS_SERVER . DIR_WS_CATALOG;
	      } else {
	        $link = HTTP_SERVER . DIR_WS_CATALOG;
	      }
	    } else {
	      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL</b><br /><br />');
	    }
	    if (xtc_not_null($parameters)) {
	      $link .= $page . '?' . $parameters;
	      $separator = '&';
	    } else {
	      $link .= $page;
	      $separator = '?';
	    }

	    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

	// Add the session ID when moving from different HTTP and HTTPS servers, or when SID is defined
	    if ( ($add_session_id == true) && ($session_started == true) && (SESSION_FORCE_COOKIE_USE == 'False') ) {
	      if (defined('SID') && xtc_not_null(SID)) {
	        $sid = SID;
	      } elseif ( ( ($request_type == 'NONSSL') && ($connection == 'SSL') && (ENABLE_SSL == true) ) || ( ($request_type == 'SSL') && ($connection == 'NONSSL') ) ) {
	        if ($http_domain != $https_domain) {
	          $sid = session_name() . '=' . session_id();
	        }
	      }
	    }

	//--- SEO Hartmut KÃÂ¶nig -----------------------------------------//
	    if (
	        ((SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true)) )
	        {
	        require_once(DIR_FS_INC . 'shopstat_functions.inc.php');

	        $seolink = shopstat_getSEO( $page,
	                                    $parameters,
	                                    $connection,
	                                    $add_session_id,
	                                    $search_engine_safe,
	                                    'admin');
	        if($seolink)
	            {
	            $link       = $seolink;
	            $elements   = parse_url($link);
	            (isset($elements['query']))
	                ? $separator = '&'
	                : $separator = '?';
	            }
	        }
	//--- SEO Hartmut KÃÂ¶nig -----------------------------------------//

		// remove session if useragent is a known Spider
	    if ($truncate_session_id) $sid=NULL;

	    if (isset($sid)) {
	      $link .= $separator . $sid;
	    }
	/*
	    if ( (SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true) ) {
	      while (strstr($link, '&&')) $link = str_replace('&&', '&', $link);

	      $link = str_replace('?', '/', $link);
	      $link = str_replace('&', '/', $link);
	      $link = str_replace('=', '/', $link);
	      $separator = '?';
	    }
	*/

	    //-- W3C-Conform
	    if($urlencode)
	        {
	        $link = htmlentities($link);
	        }

	    return $link;
	}
	
	private function get_mo_images($products_id){
		$array = array();
		$query = xtc_db_query(sprintf(
			"SELECT image_name FROM products_images WHERE products_id='%s' AND noshop=0",
			$products_id
		));
		while($record = xtc_db_fetch_array($query)){
			$array[] = $this->get_image_url($record['image_name']);
		}
		return $array;
	}
	
	private function get_image_url($image){
		return sprintf('%simages/product_images/thumbnail_images/%s',HTTP_SERVER,$image);
	}
	
	private function get_condition($condition){
		$c = strtolower($condition);
		switch($c){
			case 'neu':
			case 'new':
				return 'new';
				break;
			default:
				return 'used';
				break;
		}
	}
	
	private function get_products_manufacturer($manufacturers_id){
		$query = xtc_db_query(sprintf(
			"SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id='%s'",
			$manufacturers_id
		));
		$record = xtc_db_fetch_array($query);
		return $record['manufacturers_name'];
	}
	
	private function get_gpf_data($products_id){
		$query = xtc_db_query(sprintf(
			"SELECT google_condition,availability,gtin,mpn,adwords_grouping,adwords_labels FROM products_google_feed_data WHERE products_id='%s'",
			$products_id
		));
		$record = xtc_db_fetch_array($query);
		if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
			$query = xtc_db_query(sprintf(
				"SELECT gender,age_group,color,size,pattern,material,description FROM products_google_feed_apparel WHERE products_id='%s' AND language_id='%s'",
				$products_id,$this->language_id
			));
			if(xtc_db_num_rows($query)){
			    $record2 = xtc_db_fetch_array($query);
			    foreach($record2 as $k=>$v){
				if($k == 'description') $k = 'beschreibung';
				    $record[ $k ] = $v;
			    }
			}
		}
                if($record['availability'] == 'in_stock') $record['availability'] = 'in stock';
		return $record;
	}
	
	private function get_product_category_id($products_id){
		$query = xtc_db_query(sprintf(
			"SELECT p2c.categories_id FROM products_to_categories p2c LEFT JOIN categories c USING(categories_id) WHERE products_id='%s' AND categories_status=1 LIMIT 1",
			$products_id
		));
		$record = xtc_db_fetch_array($query);
		return $record['categories_id'];
	}
	
	// BOF VERSANDKRAM
	
	private function get_shippingcosts_de($products_id){
		// versandkosten DE
		if(MODULE_SHIPPING_YES_STATUS != 'True'){
			return 0;
		}
	
		$group_id_germany = main::get_shipping_graduation_groups_id_by_countries_id(STORE_COUNTRY);
		$pweight = xtc_get_ext_products_weight($products_id);
		if($this->get_ext_shipping_costs_status($products_id)){

			$ext_additionalcosts = main::get_product_shipping_extra_charges($products_id, $group_id_germany);

			$costs = $this->get_ext_shipping_costs($products_id);
			foreach($costs as $group_id => $qty_array){
				if($group_id_germany == $group_id){
					$brutto = true;
					$shipping_price = $this->calc_yes_modul($ext_additionalcosts+$qty_array[1],$group_id,$pweight,$products_id,$brutto);
				}
			}
		}else{
			$qty = 1;
			$grad_query = xtc_db_query("select * from shipping_graduation WHERE value=1");
			$grad = xtc_db_fetch_array($grad_query);
			$gID = $grad['shipping_graduation_id'];
			$groups_query = xtc_db_query("select * from shipping_graduation_groups ORDER BY shipping_graduation_groups_id");

			$extra_charge = main::get_product_shipping_extra_charges($products_id,$group_id_germany);

			while($groups = xtc_db_fetch_array($groups_query)){
				$group_id = $groups['shipping_graduation_groups_id'];
				if($group_id_germany == $group_id){
					// pweight nehmen wir fuer die kalkulation des Preises
					$weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
					while ($weight = xtc_db_fetch_array($weight_query)) {
						if((float)$pweight <= (float)$weight['weight']){
							$wID = $weight['shipping_graduation_weights_id'];
						}
					}
					$grad_query_raw = sprintf("SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%s' and shipping_graduation_groups_id='%s' and shipping_graduation_id='%s'",$wID,$group_id,$gID);
					$grad_query = xtc_db_query($grad_query_raw);
					$grad = xtc_db_fetch_array($grad_query);

					$product_shipping = $grad['grad_value']+$extra_charge;

					$price = main::calc_yes_modul($product_shipping,$group_id,$pweight,$products_id);
					$tax_class = constant('MODULE_SHIPPING_YES_TAX_CLASS');
					$tax_value = xtc_get_tax_rate($tax_class);
					$tax_price = $price*(($tax_value+100)/100);
					$c_array = main::get_group_countries($group_id);
					if(sizeOf($c_array)>0){
						$shipping_price = number_format($tax_price,2,'.','');
					}
				}
			}
		}
		return sprintf('DE::Standard:%s %s',$shipping_price,DEFAULT_CURRENCY);
	}
	
	private function get_ext_shipping_costs_status($products_id){
            return main::get_ext_shipping_costs_status($products_id);
	}

	private function get_ext_shipping_costs($products_id){
            return main::get_ext_shipping_costs($products_id);
	}
        
        // OBSOLETE - neue funktion main::get_product_shipping_extra_charges
	private function get_shipping_extra_charge($products_id){
            $extra_charge_query = xtc_db_query("SELECT shipping_extra_charge FROM products WHERE products_id='".$products_id."'");
            $extra_charge = xtc_db_fetch_array($extra_charge_query);
            return $extra_charge['shipping_extra_charge'];
	}
	
	private function calc_yes_modul($shipping,$group_id,$pweight,$pID,$brutto = false){
            return main::calc_yes_modul($shipping, $group_id, $pweight, $pID,$brutto);
        }
	
	private function get_group_countries($gID){
            return main::get_group_countries($gID);
	}

	private function get_weight_calc($gID){
            return main::get_weight_calc($gID);
	}
	
	// EOF VERSANDKRAM
	
	private function get_category_tree($cID){
		$query = xtc_db_query(sprintf(
			"SELECT c.categories_id, cd.categories_name,c.parent_id FROM categories c LEFT JOIN categories_description cd USING(categories_id) WHERE cd.language_id='%s' AND c.categories_id='%s'",
			$this->language_id,$cID
		));
		$record = xtc_db_fetch_array($query);
		if($this->category_string != ''){
			$this->category_string = ' > '.$this->category_string;
		}
		$this->category_string = $record['categories_name'].$this->category_string;
		if($record['parent_id'] > 0){
			$this->get_category_tree($record['parent_id']);
		}
	}
	
	private function get_property_data_by_properties_values_id($properties_values_id,$properties){
		foreach($properties as $property){
			if($property['id'] == $properties_values_id){
				return $property;
			}
		}
	}
        
        // 750ml (also 1/products_vpe_value + lower products_vpe_name)
        private function get_unit_pricing_base_measure($products_id){
            $query = xtc_db_query(sprintf(
                    "SELECT products_vpe_base_measure, products_vpe_name FROM products p LEFT JOIN products_vpe pvpe ON p.products_vpe=pvpe.products_vpe_id WHERE language_id='%s' AND products_id='%s' AND products_vpe_status=1",
                    $this->language_id,$products_id
            ));
            if(!xtc_db_num_rows($query)){
                return '';
            }
            $record = xtc_db_fetch_array($query);
            if($record['products_vpe_base_measure'] < 0.01){
                return '';
            }
            return sprintf('%s %s',number_format($record['products_vpe_base_measure'],2,'.','.'),$record['products_vpe_name']);
        }
        
        // 2 l (also products_vpe_value + products_vpe_name)
        private function get_unit_pricing_measure($products_id){
            $query = xtc_db_query(sprintf(
                    "SELECT products_vpe_value, products_vpe_name FROM products p LEFT JOIN products_vpe pvpe ON p.products_vpe=pvpe.products_vpe_id WHERE language_id='%s' AND products_id='%s' AND products_vpe_status=1",
                    $this->language_id,$products_id
            ));
            if(!xtc_db_num_rows($query)){
                return '';
            }
            $record = xtc_db_fetch_array($query);
            if($record['products_vpe_value'] < 0.01){
                return '';
            }
            return sprintf('%s %s',number_format($record['products_vpe_value'],2,'.',''),$record['products_vpe_name']);
        }
        
        private function get_unit_price($products_id,$price){
            return $price;
            $query = xtc_db_query(sprintf(
                    "SELECT products_vpe_value, products_vpe_name FROM products p LEFT JOIN products_vpe pvpe ON p.products_vpe=pvpe.products_vpe_id WHERE language_id='%s' AND products_id='%s' AND products_vpe_status=1",
                    $this->language_id,$products_id
            ));
            if(!xtc_db_num_rows($query)){
                return '';
            }
            $record = xtc_db_fetch_array($query);
            $value = $this->get_unit_pricing_base_measure_formatted_value($record['products_vpe_name'],$record['products_vpe_value']);
            $um_price = ($price > 0) ? $price / $value : 0;
            return sprintf('%s %s',number_format($um_price,2,'.','').' '.DEFAULT_CURRENCY,$record['products_vpe_name']);
        }
}
