<?php
class main {
    public static function add_message_stacks(){
	    global $messageStack, $date;

        $all_admin_access = self::get_admin_access_values();
        $admin_access = [];
        foreach($all_admin_access as $aa){
            if(intval($aa['customers_id']) != intval($_SESSION['customer_id'])){
                continue;
            }
            $admin_access = $aa;
            break;
        }
        if(!sizeOf($admin_access)){
            throw new Exception('Customer ID '.$_SESSION['customer_id'].' has no admin_access');
        }
        $admin_access_keys = ['amazon','shipping','ebayapi_membermessages','combined_orders','ebayapi_sdk_feeds'];
        if(defined('MODULE_PAYMENT_PAYPAL_STATUS') and constant('MODULE_PAYMENT_PAYPAL_STATUS') == 'True'){
            $admin_access_keys[] = 'paypal';
        }
        foreach($admin_access_keys as $ack){
            $amazon_admin_access[$ack] = intval($admin_access[$ack]);
        }

	// BOF - PRODUCTS EMAIL NOTIFICATIONS
	$start_pen = true;
	if($start_pen && isset($_SESSION['pen_alerts_last_action']) && ($_SESSION['pen_alerts_last_action']+1800) > time() ){
		$start_pen = false;
	}
	if($start_pen){
	    $pen_products_array = array();
	    $query = xtc_db_query(
		    "SELECT DISTINCT(products_id) FROM products_email_notifications WHERE notification_confirmed=1"
	    );
	    while($record = xtc_db_fetch_array($query)){
		    $pen_products_array[ $record['products_id'] ] = true;
	    }
	    $pen_count = 0;
	    if(sizeOf($pen_products_array)){
		foreach($pen_products_array as $pen_pID=>$egal){
		    $SQ = new products_quantity($pen_pID);
		    if($SQ->products_status == 1 and $SQ->get_available1_qty() > 0){
			$pen_count++;
		    }
		}
	    }
	    if($pen_count > 0){
		$_SESSION['pen_alerts_last_action'] = time();
		$messageStack->add(sprintf(MSG_OPEN_PRODUCTS_EMAIL_NOTIFICATIONS,
			$pen_count,
			yes_draw_href_link(IMAGE_SEND,xtc_href_link('products_email_notifications.php','action=send'),'','text-decoration:underline;')
		),'warning');
	    }
	}
	// EOF - PRODUCTS EMAIL NOTIFICATIONS
        
	// BOF - UNKNOWN PAYPAL TXN NOTIFICATIONS
        // stuendlich
        if(defined('MODULE_PAYMENT_PAYPAL_STATUS') and MODULE_PAYMENT_PAYPAL_STATUS == 'True' and $amazon_admin_access['paypal'] == 1){
            // load classes
            if(!class_exists('paypal_checkout')){
                require_once('../includes/classes/paypal_checkout.php');
            }
            if(!function_exists('xtc_format_price')){
                require_once(DIR_FS_INC.'xtc_format_price.inc.php');
            }
            if(!class_exists('paypal_admin')){
                require_once('includes/classes/class.paypal.php');
            }
            $start_pp_txn_notification = true;
            if($start_pp_txn_notification && (isset($_SESSION['pp_txn_alerts_last_action']) && ($_SESSION['pp_txn_alerts_last_action']+3600) > time() ) ){
                $start_pp_txn_notification = false;
            }
            if($start_pp_txn_notification){
                $unknown_ptx = 0;
                $notif_paypal = new paypal_admin();
		$date = array();
		$date['actual']['tt'] = date('d');
		$date['actual']['mm'] = date('m');
		$date['actual']['yyyy'] = date('Y');
		$last_month  = mktime(0, 0, 0, date("m")-1, date("d"),   date("Y"));
		$date['last_month']['tt'] = date('d',$last_month);
		$date['last_month']['mm'] = date('m',$last_month);
		$date['last_month']['yyyy'] = date('Y',$last_month);
		$filter = array(
		    'for' => '1',
		    'span'=>'broad'
		);
		$response = $notif_paypal->TransactionSearch($filter);
                if(is_array($response) and sizeOf($response)){
                   foreach($response as $ptx){
                       if(empty($ptx['EMAIL']) or $ptx['AMT'] <= 0){
                           continue;
                       }
                       $query = xtc_db_query(sprintf(
                               "SELECT paypal_ipn_id FROM paypal WHERE txn_id='%s'",
                               $ptx['TXNID']
                       ));
                       if(!xtc_db_num_rows($query)){
                            $query = xtc_db_query(sprintf(
                                    "SELECT orders_id FROM orders WHERE payment_transaction_id='%s'",
                                    $ptx['TXNID']
                            ));
                            if(!xtc_db_num_rows($query)){
                                $unknown_ptx++;
                            }
                       }
                   }
                }
                if($unknown_ptx > 0){
                    $messageStack->add(sprintf(MSG_UNKNOWN_PAYPAL_TXN_NOTIFICATIONS,
                            $unknown_ptx,
                            yes_draw_href_link(IMAGE_DETAILS,xtc_href_link('paypal.php','view=list'),'','text-decoration:underline;')
                    ),'warning');
                }
                $_SESSION['pp_txn_alerts_last_action'] = time();
            }
        }
	// EOF - UNKNOWN PAYPAL TXN NOTIFICATIONS
        
        // BOF - VERSANDMODUL MELDUNGEN
        if($amazon_admin_access['shipping'] == 1 and in_array(basename($_SERVER['SCRIPT_NAME']),array('orders.php','shipping.php','shipping_history.php'))){
            $query = xtc_db_query("SELECT COUNT(id) AS anz FROM shippings WHERE email_send_status=1");
            $record = xtc_db_fetch_array($query);
            if($record['anz'] > 0){
                $messageStack->add(sprintf(MSG_SHIPPING_EMAILS_TO_SEND,$record['anz']).' <a href="javascript:;" onclick="window.open(\'shipping.php?action=send_shipping_emails\',\'sse\',\'width=500,height=500,scrollbars=yes,toolbar=no\');" style="text-decoration: underline;">'.IMAGE_SEND.'</a>','warning');
            }

            // BOF NEUES SECUPAY
            if(defined('MODULE_PAYMENT_YES_SECUPAY_STATUS') and constant('MODULE_PAYMENT_YES_SECUPAY_STATUS') == 'True'){
                $query = xtc_db_query(sprintf(
                    "SELECT COUNT(s.id) as anz FROM shippings s LEFT JOIN %s o USING ( orders_id ) WHERE o.payment_method='yes_secupay' AND s.status=1 AND s.secupay_send_status=0",
                    TABLE_ORDERS
                ));
                $record = xtc_db_fetch_array($query);
                if(isset($record['anz']) and intval($record['anz']) > 0){
                    $messageStack->add(sprintf(MSG_SHIPPING_SPINV_SEND_CAPTURE,$record['anz']).' <a href="javascript:;" id="secupay.php?action=set_delivery" class="lbOn bigWidth" style="text-decoration: underline;" title="Secupay Versandmeldung">'.IMAGE_SEND.'</a>','warning');
                }
            }
            // EOF NEUES SECUPAY

            /**
             * BOF - SECUPAY VERSANDMELDUNGEN - Ticket 2416
             */
            if(defined('MODULE_PAYMENT_SPINV_STATUS') and MODULE_PAYMENT_SPINV_STATUS == 'Ja'){
                    $query = xtc_db_query(sprintf(
                            "SELECT COUNT(s.id) as anz FROM shippings s LEFT JOIN %s o USING ( orders_id ) LEFT JOIN secupay_transaction_order sto ON sto.ordernr=o.orders_id WHERE secupay_send_status=0 AND payment_class='secupay_inv_xtc' AND sto.hash IS NOT NULL",
                            TABLE_ORDERS
                    ));
                    $record = xtc_db_fetch_array($query);
                    if($record['anz'] > 0){
                        $messageStack->add(sprintf(MSG_SHIPPING_SPINV_SEND_CAPTURE,$record['anz']).' <a href="javascript:;" id="shipping.php?action=send_shipping_secupay" class="lbOn bigWidth" style="text-decoration: underline;" title="Secupay Versandmeldung">'.IMAGE_SEND.'</a>','warning');
                    }
            }
            /**
             * EOF - SECUPAY VERSANDMELDUNGEN - Ticket 2416
             */
            
            /**
             * BOF - EBAY COMPLETESALE
             */
            $completesales_query = yes_db_query(
                    "SELECT orders_id,ebayid,transactionid FROM ebay_transactions WHERE shipped=1"
            );
            $num = yes_db_num_rows($completesales_query);
            if($num > 0){
                $lnk = sprintf('&nbsp;<a class="lbOn_noStyle" href="%s">%s</a>',
                        xtc_href_link('shipping.php','action=ebay_completesales_preview'),
                        IMAGE_SEND
                );
                $messageStack->add(sprintf(MSG_EBAY_COMPLETESALES_PREVIEW,$num).$lnk,'warning');
            }
            /**
             * EOF - EBAY COMPLETESALE
             */
            
        }
        // EOF - VERSANDMODUL MELDUNGEN
	
	if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		if($amazon_admin_access['amazon'] == 1 and $amazon_admin_access['shipping'] == 1){
			$query = yes_db_query(
				"SELECT count(amazon_orders_id) as anz FROM amazon_orders_products WHERE yes_shipping_status=1 AND order_fulfillment_send=0"
			);
			if(yes_db_num_rows($query)){
				$record = current($query);
				if($record['anz'] > 0){
					$messageStack->add(sprintf(MSG_OPEN_AMAZON_FULFILLMENTS,
						$record['anz'],
						yes_draw_href_link(IMAGE_SEND,xtc_href_link('amazon.php','action=order_fulfillments'),'','text-decoration:underline;')
					),'warning');
				}
			}
		}
		// BOF - AMAZON ORDERS COMBINE
		if($amazon_admin_access['amazon'] == 1 and $amazon_admin_access['combined_orders'] == 1){
		    $valid_ac_orders_statuses = array(1,ORDERS_STATUS_BEZAHLT); // NUR ZUM TESTEN MIT ABGESCHL.
		    //$valid_orders_statuses = array(1,ORDERS_STATUS_BEZAHLT);

		$grp = array();
		    $query = xtc_db_query(sprintf(
			    "SELECT ao.orig_amazon_orders_id,o.orders_id FROM amazon_orders ao LEFT JOIN orders o USING(orders_id) WHERE o.orders_status IN(%s) AND (SELECT COUNT(orders_id) FROM orders WHERE combined_orders_id=o.orders_id) = 0",
			    implode(',',$valid_ac_orders_statuses)
		    ));
		    $dbl_chk = array();
		    while($record = xtc_db_fetch_array($query)){
			if(!isset($dbl_chk[$record['orders_id']])){
				if(!isset($grp[ $record['orig_amazon_orders_id'] ])){
					$grp[ $record['orig_amazon_orders_id'] ] = 0;
				}
				$grp[ $record['orig_amazon_orders_id'] ]++;
				$dbl_chk[$record['orders_id']] = true;
			}
		    }
		    $num = 0;
		    foreach($grp as $oaoid=>$anz){
			    if($anz > 1){
				    $num++;
			    }
		    }
		    if($num > 0){
			    $messageStack->add(sprintf(MSG_AMAZON_ORDERS_TO_COMBINE,
				    yes_draw_href_link(IMAGE_SELECT,xtc_href_link('orders.php','action=amazon_orders'),'','text-decoration:underline;')
			    ),'warning');
		    }
		}
		// EOF - AMAZON ORDERS COMBINE
	}
	
	// EOF - EBAY MESSAGES
	if(!in_array  ('curl', get_loaded_extensions())) {
	    $messageStack->add('PHP Extension curl wird ben&ouml;tigt.','error');
	}
        
        
        if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
            // chatgpt optimiert:
            $query_raw = sprintf("SELECT COUNT(s.id) AS anz
                FROM shippings s
                INNER JOIN %s o ON s.orders_id = o.orders_id
                INNER JOIN hitmeister_orders ho ON o.orders_id = ho.orders_id
                INNER JOIN hitmeister_orders_units hou ON ho.hitmeister_orders_id = hou.hitmeister_orders_id
                WHERE o.source = 'hitmeist' AND hou.fulfillment_sent = 0 AND o.orders_status IN (%s)",
                TABLE_ORDERS,
                implode(',',array(ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET))
            );
            /* ALT 
            $query_raw = sprintf(
                    "SELECT COUNT(s.id) as anz FROM shippings s LEFT JOIN %s o USING ( orders_id ) LEFT JOIN hitmeister_orders ho USING(orders_id) LEFT JOIN hitmeister_orders_units hou USING(hitmeister_orders_id) WHERE o.source LIKE 'hitmeis%%' AND hou.fulfillment_sent=0 AND o.orders_status IN(%s) ",
                    TABLE_ORDERS, )
            );
            */
            $query = xtc_db_query($query_raw);
            $record = xtc_db_fetch_array($query);
            if($record['anz'] > 0){
                $messageStack->add(sprintf(MSG_SHIPPING_HITMEISTER_FULFILLMENT_SEND,$record['anz']).' <a href="hitmeister.php?action=fulfillment" style="text-decoration: underline;" title="Kaufland Versandmeldung">'.IMAGE_SEND.'</a>','warning');
            }
            
            if(basename($_SERVER['SCRIPT_FILENAME']) != 'hitmeister.php'){
                require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
                $status_logfile = main::get_secure_path().yes_hitmeister::ORDER_IMPORT_STATUS_LOGFILE_NAME;
                if(is_file($status_logfile)){
                    $content = explode(PHP_EOL,file_get_contents($status_logfile));
                    $msg_str = sprintf(MSG_OPEN_REAL_ORDERS,
                            sizeOf($content)
                    );
                    $messageStack->add(sprintf('<a href="hitmeister.php" title="Logfile vom %s">%s</a>',
                            date('d.m.Y H:i:s',filemtime($status_logfile)),
                            $msg_str
                    ),'warning');
                }
            }
        }
    }
      
    function get_navigation(){
	if(!class_exists('yes_admin_menu')){
	    require_once(DIR_WS_CLASSES.'yes_admin_menu.php');
	}
	$yam = new yes_admin_menu();
	$menu = $yam->getMenuArray();
	/*
	$menu_smarty->assign('JS_ALERT_NO_AUTH',IMAGE_AUTH_DENIED);
	$menu_smarty->assign('TEXT_HEADER_MENU_PROCUREMENT',TEXT_HEADER_MENU_PROCUREMENT);
	$menu_smarty->assign('TEXT_HEADER_MENU_EBAYSELLING',TEXT_HEADER_MENU_EBAYSELLING);
	$menu_smarty->assign('TEXT_HEADER_MENU_SHIPMENT',TEXT_HEADER_MENU_SHIPMENT);
	$menu_smarty->assign('TEXT_HEADER_MENU_WAREHOUSE',TEXT_HEADER_MENU_WAREHOUSE);
	$menu_smarty->assign('TEXT_HEADER_MENU_TOOLS',TEXT_HEADER_MENU_TOOLS);
	$menu_smarty->assign('TEXT_HEADER_MENU_STATS',TEXT_HEADER_MENU_STATS);
	$menu_smarty->assign('TEXT_HEADER_MENU_CONFIG',TEXT_HEADER_MENU_CONFIG);
	$menu_smarty->assign('TEXT_HEADER_MENU_ADMIN',TEXT_HEADER_MENU_ADMIN);
	$menu_smarty->assign('TEXT_HEADER_MENU_TOP_COUNTER',TEXT_HEADER_MENU_TOP_COUNTER);
	 * 
	 */
	//yes_debug($menu);
	$str = '<nav class="mainNav ui-state-default"><div class="contentHolder"><ul>';
	foreach($menu as $group => $entries ){
	    switch($group){
		case 'k1':
		    $group_title = TEXT_HEADER_MENU_PROCUREMENT_HTML5; 
		    $group_class = 'fi-page-multiple';
		    break;
		case 's1':
		    $group_title = TEXT_HEADER_MENU_EBAYSELLING; 
		    $group_class = 'fi-folder';
		    break;
		case 'kt1':
		    $group_title = TEXT_HEADER_MENU_WAREHOUSE;
		    $group_class = 'fi-thumbnails';
		    break;
		case 'z1':
		    $group_title = TEXT_HEADER_MENU_TOOLS_HTML5;
		    $group_class = 'fi-mail';
		    break;
		case 'st1':
		    $group_title = TEXT_HEADER_MENU_STATS;
		    $group_class = 'fi-graph-trend';
		    break;
		case 'ko1':
		    $group_title = TEXT_HEADER_MENU_CONFIG;
		    $group_class = 'fi-widget';
		    break;
		case 'vw1':
		    $group_title = TEXT_HEADER_MENU_ADMIN;
		    $group_class = 'fi-pencil';
		    break;
		case 'ka1':
		    $group_title = TEXT_HEADER_MENU_TOP_COUNTER;
		    $group_class = 'fi-dollar-bill';
		    break;
		case 'v1':
		    $group_title = TEXT_HEADER_MENU_SHIPMENT;
		    $group_class = 'fi-map';
		    break;
	    }
	    $str .= sprintf('<li><a href="#"><i class="%s"></i>&nbsp;%s</a>'."\r\n",$group_class,$group_title);
            $str .= '<ul>';
	    foreach($entries as $entry){
		    $href = ($entry['auth']) ? $entry['link'] : 'javascript:alert(\''.IMAGE_AUTH_DENIED.'\');';
		    $style = ($entry['auth']) ? '' : 'style="color: red;font-style: italic;"';
		
		    if(isset($entry['dialog_confirm']) and $entry['auth']){
                    switch($entry['dialog_confirm']){
                        case 'new_order':
                            $confirm_text = CONFIRM_CREATE_NEW_ORDER;
                            break;
                        case 'tagesabschluss_confirm':
                            $confirm_text = CONFIRM_TAGESABSCHLUSS;
                            break;
                    }
		        $str .= sprintf('<li><a href="javascript:;" id="%s" %s class="yes_menu_dialog-%s" title="%s">%s</a></li>'."\r\n",$entry['link'],$style,$entry['dialog_confirm'],$confirm_text,$entry['title']);
		    }else{
		        $str .= sprintf('<li><a href="%s" %s>%s</a></li>'."\r\n",$href,$style,$entry['title']);
		    }
	    }
        $str .= '</ul></li>';
	}
	$str .= '</ul></div></nav>';
	return $str;
	
/*<nav class="mainNav">
    <div class="contentHolder">
        <ul>
            <li><a href="#"><i class="fi-page-multiple"></i> Auftr�ge </a>
                <ul>
                    <li><a href="#">Link Titel 1</a></li>
                    <li><a href="#">Link Titel 2</a></li>
                    <li><a href="#">Link Titel 3</a></li>
                    <li><a href="#">Link Titel 4</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                </ul></li>
            <li><a href="#"><i class="fi-folder"></i> Ebay Handel </a>
                <ul>
                    <li><a href="#">Link Titel 1</a></li>
                    <li><a href="#">Link Titel 2</a></li>
                    <li><a href="#">Link Titel 3</a></li>
                    <li><a href="#">Link Titel 4</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                </ul></li>
            <li><a href="#"><i class="fi-map"></i> Versand </a></li>
            <li><a href="#"><i class="fi-thumbnails"></i> Lager/Katalog </a>
                <ul>
                    <li><a href="#">Link Titel 1</a></li>
                    <li><a href="#">Link Titel 2</a></li>
                    <li><a href="#">Link Titel 3</a></li>
                    <li><a href="#">Link Titel 4</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                    <li><a href="#">Link Titel 5</a></li>
                </ul></li>
            <li><a href="#"><i class="fi-mail"></i> Mailmaster </a></li>
            <li><a href="#"><i class="fi-graph-trend"></i> Statistiken </a></li>
            <li><a href="#"><i class="fi-widget"></i> Konfiguration </a></li>
            <li><a href="#"><i class="fi-pencil"></i> Verwaltung </a></li>
            <li><a href="#"><i class="fi-dollar-bill"></i> Kasse </a></li>
        </ul>
    </div>
</nav>
*/	
    }
    
    public static function log_process( string $key, string $msg ){
        $logfile = main::get_secure_path().'log-'.$key.'.log';
        if(!is_file($logfile)){
            touch($logfile);
        }
        $fp = fopen($logfile, 'a');
        $line = sprintf("%s\t%s\n",date('Y-m-d H:i:s'),$msg);
        fwrite($fp,$line);
        fclose($fp);
    }
    
    public function log(){
        $logfile = self::get_exportdata_path().'ADMLOG_'.$_SESSION['customer_id'].'.log';
        if(!is_file($logfile)){
            touch($logfile);
        }
        $fp = fopen($logfile, 'a');
        $line = sprintf("%s\t%s\t%s\n",date('Y-m-d H:i:s'),$_SERVER['SCRIPT_NAME'],$_SERVER['QUERY_STRING']);
        fwrite($fp,$line);
        fclose($fp);
    }
    
    /**
     * Liefert den Eintrag aus admin_access fuer den eingeloggten User
     * Wird der Parameter customers_id uebergeben, wird nicht auf 
     * SESSION[customer_id] geprueft sondern auf den parameter
     * Wird der Parameter field nicht uebergeben, wird ein Array aller
     * admin_access Werte des customers zurueckgegeben
     * 
     * @param string $field
     * @param int $customers_id
     * @return boolean or array
     * @throws Exception
     */
    public static function get_admin_access( string $field = '', int $customers_id = -1){
        if($customers_id === -1){
            $customers_id = $_SESSION['customer_id'];
        }
        $avs = self::get_admin_access_values();
        $av = [];
        foreach($avs as $aav){
            if($aav['customers_id'] == $customers_id){
                $av = $aav;
            }
        }
        
        
        if(!sizeOf($av)){
            throw new Exception(sprintf(
                "Customer #%d has no admin access",
                $customers_id
            ));
        }
        if(!empty($field)){
            if(!isset($av[$field])){
                throw new Exception(sprintf(
                    "Theres no admin access for '%s'",
                    $field
                ));
            }
            return ($av[$field]=='1')?true:false;
        }
        return $av;
    }
    
    public static function get_admin_access_values(){
        global $InstanceCache;
        $key = 'admin_access';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $values = [];
            $query = xtc_db_query(
                    "SELECT * FROM admin_access"
            );
            while($record = xtc_db_fetch_array($query)){
                $values[] = $record;
            }
            $CachedString->set($values)->expiresAfter(0);//admin_access
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $values = $CachedString->get();
        }
        return $values;
    }    
    /**
     * Gibt ein Array der Admin customers_id wieder, die in der Tabelle
     * admin_access einen Wert von 1 beim uebergebenen $admin_access_field haben
     * @param string $admin_access_field
     * @return array
     */
    public static function get_notice_recipients( $admin_access_field ){
        $notice_users = array();
        foreach(self::get_admin_access_values() as $ada){
            if($ada[ $admin_access_field ] != 1){
                continue;
            }
            $kasse_user = (defined('KASSE_USER') and KASSE_USER > 0) ? KASSE_USER : 0;
            switch($ada['customers_id']){
                case 1:
                case 'groups':
                case $kasse_user:
                    break;
                default:
                    $notice_users[] = $ada['customers_id'];
                    break;
            }
        }
        return $notice_users;
    }
    
    public function get_language_id_from_iso2($iso2){
        if(empty($iso2)){
            die('main::get_language_id_from_iso2 with empty parameter');
        }
        $query = xtc_db_query(sprintf(
                "SELECT countries_id FROM %s WHERE countries_iso_code_2='%s'",
                TABLE_COUNTRIES,$iso2
        ));
        if(!xtc_db_num_rows($query)){
            die('main::get_language_id_from_iso2 with '.$iso2.' not found');
        }
        $record = xtc_db_fetch_array($query);
        return $record['countries_id'];
    }
    
    public static function has_auth($auth_key){
        if(empty($auth_key)){
            return false;
        }
        try{
            $query = xtc_db_query(sprintf(
                    "SELECT %s FROM admin_access WHERE customers_id='%s'",
                    $auth_key,$_SESSION['customer_id']
            ));
        }catch( Exception $e){
            return false;
        }
        if(!xtc_db_num_rows($query)){
            return false;
        }
        $record = xtc_db_fetch_array($query);
        return boolval($record[$auth_key]);
    }
    
    public static function filesanitize($string = '', $is_filename = True, bool $strtolower = true ){
        // Replace all weird characters with dashes
        $string = preg_replace('/[^\w\-'. ($is_filename ? '~_\.' : ''). ']+/u', '-', $string);
        // Only allow one dash separator at a time (and make string lowercase)
        if($strtolower){
            return mb_strtolower(preg_replace('/--+/u', '-', $string), 'UTF-8');
        }
        return preg_replace('/--+/u', '-', $string);
    }

    /**
     * Gibt den Pfad zu secure_files/ zurueck, mit endendem /
     * @return string
     */
    public static function get_secure_path(){
        $secure_path = YES_SYSTEM_HOME_DIRECTORY.'secure_files'.DIRECTORY_SEPARATOR;
        if(!is_dir($secure_path)){
            die('YES Configuration error: Missing secure path');
        }
        return $secure_path;
    }

    /**
     * Gibt den Pfad zu importdata/ zurueck, mit endendem /
     * @return string
     */
    public static function get_importdata_path():string{
        $conn = '';
        if(substr(constant('DIR_FS_ADMIN'),-1) !== DIRECTORY_SEPARATOR){
            $conn = DIRECTORY_SEPARATOR;
        }
        $path = DIR_FS_ADMIN.$conn.'importdata/';
        if(!is_dir($path)){
            die('YES Configuration error: Missing importdata path');
        }
        return $path;
    }
    /**
     * Gibt den Pfad zu exportdata/ zurueck, mit endendem /
     * @return string
     */
    public static function get_exportdata_path():string{
        if(main::isDev(true)){
            return str_replace('secure_files','data/exportdata',self::get_secure_path());
        }
        $conn = '';
        if(substr(constant('DIR_FS_ADMIN'),-1) !== DIRECTORY_SEPARATOR){
            $conn = DIRECTORY_SEPARATOR;
        }
        $path = DIR_FS_ADMIN.$conn.'exportdata/';
        if(!is_dir($path)){
            die('YES Configuration error: Missing exportdata path');
        }
        return $path;
    }

    
    public static function get_shipping_graduation_groups(){
        $array = array();
        $query = xtc_db_query(
                "SELECT shipping_graduation_groups_id, title FROM shipping_graduation_groups ORDER BY shipping_graduation_groups_id"
        );
        while($record = xtc_db_fetch_array($query)){
            $array[] = array(
                'id'=>$record['shipping_graduation_groups_id'],
                'text'=>xtc_db_prepare_input($record['title'])
            );
        }
        return $array;
    }
    public static function get_shipping_graduation_groups_countries($shipping_graduation_groups_id){
        $array = array();
        if($shipping_graduation_groups_id == 9999){
            return $array;
        }
        $query = xtc_db_query(sprintf(
                "SELECT c.countries_name FROM shipping_graduation_countries sgc LEFT JOIN countries c ON c.countries_id=sgc.country_id WHERE sgc.shipping_graduation_groups_id='%s'",
                $shipping_graduation_groups_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $array[] = xtc_db_prepare_input($record['countries_name']);
        }
        return $array;
    }
    
    public static function get_shipping_graduation_groups_id_by_countries_id($countries_id){
        $query = xtc_db_query(sprintf(
                "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id='%s'",
                $countries_id
        ));
        if(!xtc_db_num_rows($query)){
            return 999999; // ALLE ANDEREN
        }
        $record = xtc_db_fetch_array($query);
        return $record['shipping_graduation_groups_id'];
    }
    
    // BOF - YES Versandkosten Berechnung
    /**
     * Ermittelt den shipping_extra_charge Wert aus products_shipping_extra_charge
     * basierend auf der products_id und optional der shipping_graduation_groups_id
     * Wird keine shipping_graduation_groups_id vorgebenen, dann wird basierend
     * auf der STORE_COUNTRY (ist eine ID) Einstellung die entsprechende Laenderzuordnung 
     * ermittelt
     * @param type $products_id
     * @param type $shipping_graduation_groups_id
     * @return int
     */
    public static function get_product_shipping_extra_charges($products_id, $shipping_graduation_groups_id = null){
        if($shipping_graduation_groups_id === null){
            $shipping_graduation_groups_id = self::get_shipping_graduation_groups_id_by_countries_id(STORE_COUNTRY);
        }
        $query = xtc_db_query(sprintf(
                "SELECT shipping_extra_charge FROM products_shipping_extra_charge WHERE products_id='%s' AND shipping_graduation_groups_id='%s'",
                $products_id, $shipping_graduation_groups_id
        ));
        if(!xtc_db_num_rows($query)){
            return 0;
        }
        $record = xtc_db_fetch_array($query);
        return $record['shipping_extra_charge'];
    }
    
    /**
     * Holt den DB Wert fuer 'weight_calc' aus den Laendergruppen Zuweisungen
     * fuer eine bestimmte Laendergruppe
     * @param int $group_id
     * @return bool
     */
    public static function get_weight_calc($group_id){
      $groups_query = xtc_db_query("SELECT weight_calc FROM shipping_graduation_groups WHERE shipping_graduation_groups_id='".$group_id."'");
      $groups = xtc_db_fetch_array($groups_query);
      return $groups['weight_calc'];
    }
    
    /**
     * OBSOLETE - WIRD DURCH DAS LAENDERGRUPPENBASIERTE
     * SHIPPING EXTRA CHARGE HANDLING ERSETZT
     * @param int $products_id
     * @return float
     */
    public static function get_shipping_extra_charge($products_id){
            $extra_charge_query = xtc_db_query("SELECT shipping_extra_charge FROM products WHERE products_id='".$products_id."'");
            $extra_charge = xtc_db_fetch_array($extra_charge_query);
            return $extra_charge['shipping_extra_charge'];
    }
     
    /**
     * Berechnet den YES basierten Versandkostenpreis basierend auf Grundversand-
     * kostenwert, Laendergruppe, Gewicht, pID und Brutton/Netto Vorgabe
     * @param float $shipping
     * @param int $group_id
     * @param float $pweight
     * @param int $pID
     * @param bool $brutto
     * @return float
     */
    public static function calc_yes_modul($shipping,$group_id,$pweight,$pID,$brutto = false){
        if(self::get_weight_calc($group_id) == 1){
                $extra_charge = self::get_shipping_extra_charge($pID);
                $extra_charge_plus = self::get_product_shipping_extra_charges($pID, $group_id);
                $qty = 1; // gesamtgewicht basierend auf 1 stk

                $grad_query = xtc_db_query("select shipping_graduation_id from shipping_graduation WHERE value=1");
                $grad = xtc_db_fetch_array($grad_query);
                $gID = $grad['shipping_graduation_id'];

                $weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
                while ($weight = xtc_db_fetch_array($weight_query)) {
                        if((float)$pweight <= (float)$weight['weight']){
                                $wID = $weight['shipping_graduation_weights_id'];
                        }
                }

                $grad_query_raw = sprintf("SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%s' and shipping_graduation_groups_id='%s' and shipping_graduation_id='%s'",$wID,$group_id,$gID);
                $grad_query = xtc_db_query($grad_query_raw);
                $grad = xtc_db_fetch_array($grad_query);
                $shipping = $grad['grad_value']+$extra_charge;
        }
        if(!$brutto){
                return ($shipping + MODULE_SHIPPING_YES_HANDLING);
        }else{
                $tax_rate = xtc_get_tax_rate(MODULE_SHIPPING_YES_TAX_CLASS);
                return ($shipping + MODULE_SHIPPING_YES_HANDLING)*(($tax_rate+100)/100);
        }
    }
    
    /**
     * Ermittelt die Laender einer Gruppe basierend auf der Laendergruppen ID
     * Wenn das Flag not_ship in der Laendergruppenzuweisung auf 1 gesetzt ist
     * wird ein leeres Array zurueckgegeben
     * @param int $gID
     * @return array
     */
    public static function get_group_countries($gID){
            $array = array();
            $not_ship_query = xtc_db_query("SELECT not_ship FROM shipping_graduation_groups WHERE shipping_graduation_groups_id='".$gID."'");
            $not_ship = xtc_db_fetch_array($not_ship_query);
            if($not_ship['not_ship'] == 0){
                    if($gID != '999999'){
                            $countries_query = xtc_db_query("SELECT c.countries_name FROM countries c,shipping_graduation_countries sgc WHERE sgc.country_id=c.countries_id AND sgc.shipping_graduation_groups_id='".$gID."'");
                            while($countries = xtc_db_fetch_array($countries_query)){
                                    $array[] = $countries['countries_name'];
                            }
                    }else{
                            $array[] = 'Alle weiteren';
                    }
            }
            return $array;
    }
    
    /**
     * Ermittelt aus der Tabelle 'shipping_graduation_products' ob ein Artikel 
     * erweiterte Versandkosten enthaelt - basierend auf einer products_id
     * @param int $products_id
     * @return bool
     */
    public static function get_ext_shipping_costs_status($products_id){
            $ext_ship_query = xtc_db_query("SELECT sg.value FROM shipping_graduation_products sp,shipping_graduation sg WHERE sp.products_id='".xtc_db_input($products_id)."' and sg.shipping_graduation_id=sp.graduation_id");
            $ext_costs_active = (xtc_db_num_rows($ext_ship_query) > 0) ? true : false;
            return $ext_costs_active;
    }

    /**
     * Ermittelt die Erweiterten Versandkosten basierend auf einer products_id
     * Dabei werden alle Werte aus shipping_graduation_products sowie der
     * zugehoerige value aus shipping_graduation als Array zurueckgegeben
     * @param int $products_id
     * @return array
     */
    public static function get_ext_shipping_costs($products_id){
            $ext_ship_query = xtc_db_query("SELECT sp.*,sg.value as qty FROM shipping_graduation_products sp,shipping_graduation sg WHERE sp.products_id='".xtc_db_input($products_id)."' and sg.shipping_graduation_id=sp.graduation_id and sg.value=1");
            $ext_costs = array();
            while($ext_ship = xtc_db_fetch_array($ext_ship_query)){
                    $ext_costs[ $ext_ship['shipping_graduation_groups_id'] ][ $ext_ship['qty'] ] = $ext_ship['value'];
            }
            return $ext_costs;
    }
    // EOF - YES Versandkosten Berechnung
    
    public static function get_products_in_category($categories_id, &$products, $include_subcategories = true){
        $query = xtc_db_query(sprintf(
                "SELECT products_id FROM %s WHERE categories_id='%s'",
                TABLE_PRODUCTS_TO_CATEGORIES,
                $categories_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $products[] = $record['products_id'];
        }
        if($include_subcategories){
            $query = xtc_db_query(sprintf(
                    "SELECT categories_id FROM %s WHERE parent_id='%s'",
                    TABLE_CATEGORIES,
                    $categories_id
            ));
            $subcategories = array();
            while($record = xtc_db_fetch_array($query)){
                $subcategories[] = $record['categories_id'];
            }
            foreach($subcategories as $sub){
                self::get_products_in_category($sub, $products, $include_subcategories);
            }
        }
    }
    
    public static function get_branches(){
        if(!defined('YES_BRANCHES_COUNT') or YES_BRANCHES_COUNT < 1){
            return array();
        }
        $branches = array();
        $query = xtc_db_query(sprintf(
                "SELECT branches_id,title,stammlager FROM branches ORDER BY title LIMIT %s",
                YES_BRANCHES_COUNT
        ));
        while($record = xtc_db_fetch_array($query)){
            $text = xtc_db_prepare_input($record['title']);
            if($record['stammlager'] == 1){
                $text = '* '.$text;
            }
            $branches[] = array(
                'id'=>$record['branches_id'],
                'text'=>$text
            );
        }
        return $branches;
    }
    
    public static function get_crm_link($crmID){
        return xtc_href_link(FILENAME_CUSTOMERS,'cID='.$crmID.'&action=crm');
    }
    
    public static function isDev($isLocal = false){
        if($isLocal === true){
            
            return (strpos(HTTP_SERVER,'localhost') > -1) ? true : false;
        }
        if(strpos(HTTP_SERVER,'localhost') > -1 or strpos(HTTP_SERVER,'yes-a177922.de') > -1){
            return true;
        }
        return false;
    }

    public static function get_distributors_with_external_stock(){
        // gibt derzeit nur einen
        return (defined('MODULE_OTHER_HTG_STATUS') and MODULE_OTHER_HTG_STATUS == 'True') ? [MODULE_OTHER_HTG_DISTRIBUTOR_ID] : [];
    }
    public static function hasDistributorExternalStock(int $distributor_id){
        if(defined('MODULE_OTHER_HTG_STATUS') and MODULE_OTHER_HTG_STATUS == 'True'){
            if(MODULE_OTHER_HTG_DISTRIBUTOR_ID == $distributor_id){
                return true;
            }
        }
        return false;
    }
    
    public static function get_shipping_method_name_from_shipping_class(string $sc){
        global $ARRAY_ebay_shippingmethods;

        $sc_parts = explode('_',$sc);
        if(sizeOf($sc_parts) == 2){
            if($sc_parts[0] == $sc_parts[1]){
                $sc_class = current($sc_parts);
            }else{
                $sc_class = $sc;
            }
        }else{
            $sc_class = $sc;
        }
        $sc_title = '';
        if(!defined('MODULE_SHIPPING_'.strtoupper($sc_class).'_TEXT_TITLE')){
            if(is_file(DIR_FS_CATALOG.'lang/german/modules/shipping/'.$sc_class.'.php')){
                include(DIR_FS_CATALOG.'lang/german/modules/shipping/'.$sc_class.'.php');
                switch($sc_class){
                    case 'freeamount':
                        $sc_title = constant('MODULE_SHIPPING_FREECOUNT_TEXT_TITLE');
                        break;
                    default:
                        $sc_title = constant('MODULE_SHIPPING_'.strtoupper($sc_class).'_TEXT_TITLE');
                        break;
                }
            }
        }else{
            $sc_title = constant('MODULE_SHIPPING_'.strtoupper($sc_class).'_TEXT_TITLE');
        }
        $c = current($ARRAY_ebay_shippingmethods);
        if(empty($sc_title) and isset($c['ShippingServiceDetails'])){
            foreach($c['ShippingServiceDetails'] as $esm){
            	$c2 = current($esm);
                if($c2['ShippingService'] == $sc_class){
                    $sc_title = $c2->Description;
                }
            }
        }
        if(empty($sc_title)){
            $sc_title = $sc_class;
        }
        return $sc_title;
    }
    
    public static function get_order_sources(){
        $array = array(
            array('id'=>'','text'=>TEXT_SELECT),
            array('id'=>'shop','text'=>'Shop'),
            array('id'=>'counter','text'=>TEXT_ORDERS_SOURCE_COUNTER),
            array('id'=>'admin','text'=>TEXT_ORDERS_SOURCE_ADMIN),
            array('id'=>'ebay','text'=>'eBay'),
        );
        if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
            $array[] = array('id'=>'amazon','text'=>'Amazon');
        }
        if(defined('MODULE_OTHER_YES_WAYFAIR_STATUS') and MODULE_OTHER_YES_WAYFAIR_STATUS == 'True'){
            $array[] = array('id'=>'wayfair','text'=>'Wayfair');
        }
        if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
            $array[] = array('id'=>'hitmeist','text'=>'Kaufland');
        }
        return $array;
    }
    
    public static function get_shipping_class_title(string $shipping_class, $ebay_shipping_methods = null){
        $sc_parts = explode('_',$shipping_class);
        if(sizeOf($sc_parts) == 2){
            if($sc_parts[0] == $sc_parts[1]){
                $sc_class = current($sc_parts);
            }else{
                $sc_class = $sc_parts[0];
            }
        }else{
            $sc_class = $shipping_class;
        }
        $sc_title = '';
        if(!defined('MODULE_SHIPPING_'.strtoupper($sc_class).'_TEXT_TITLE')){
            if(is_file(DIR_FS_CATALOG.'lang/german/modules/shipping/'.$sc_class.'.php')){
                include(DIR_FS_CATALOG.'lang/german/modules/shipping/'.$sc_class.'.php');
                switch($sc_class){
                    case 'freeamount':
                        $sc_title = constant('MODULE_SHIPPING_FREECOUNT_TEXT_TITLE');
                        break;
                    default:
                        $sc_title = constant('MODULE_SHIPPING_'.strtoupper($sc_class).'_TEXT_TITLE');
                        break;
                }
            }
        }else{
            $sc_title = constant('MODULE_SHIPPING_'.strtoupper($sc_class).'_TEXT_TITLE');
        }
        if(empty($sc_title) and $ebay_shipping_methods !== Null){
            $c = current($ebay_shipping_methods);
            if(isset($c['ShippingServiceDetails']) and is_countable($c['ShippingServiceDetails'])){
                foreach($c['ShippingServiceDetails'] as $esm){
                    $c2 = current($esm);
                    if($c2['ShippingService'] == $sc_class){
                        $sc_title = $c2['Description'];
                    }
                }
            }
        }
        if(empty($sc_title))
            $sc_title = $sc_class;
        return $sc_title;
    }
    
    public static function delete_configuration_key( string $key ){
        global $InstanceCache;
        if(empty($key)){
            throw new Exception('delete_configuration_key() needs a valid key');
        }
        xtc_db_query(sprintf("DELETE FROM configuration WHERE configuration_key='%s'",
                $key
        ));
        $InstanceCache->deleteItem('configuration');
    }
    
    public static function configuration_key_exists( string $key ){
        if(empty($key)){
            throw new Exception('configuration_key_exists() needs a valid key');
        }
        $query = xtc_db_query(sprintf(
                "SELECT configuration_id FROM configuration WHERE configuration_key='%s'",
                $key
        ));
        return (xtc_db_num_rows($query)>0)?true:false;
    }
    
    public static function add_configuration( array $params ){
        global $InstanceCache;
        if(empty($params['configuration_key'])){
            throw new Exception('add_configuration() needs a valid key');
        }
        if(self::configuration_key_exists($params['configuration_key'])){
            throw new Exception('add_configuration() key '.$params['configuration_key'].' exists');
        }
        $insert_sql_array = [
            'configuration_key'=>$params['configuration_key'],
            'configuration_value'=>$params['configuration_value'],
            'configuration_group_id'=>(isset($params['configuration_group_id']))?(int)$params['configuration_group_id']:0,
            'sort_order'=>(isset($params['sort_order']))?(int)$params['sort_order']:0,
            'date_added'=>'now()',
            'use_function'=>(isset($params['use_function']))?$params['use_function']:'',
            'set_function'=>(isset($params['set_function']))?$params['set_function']:'',
        ];
        xtc_db_perform('configuration',$insert_sql_array);
        $InstanceCache->deleteItem('configuration');
    }
    
    public static function update_configuration_value( string $key, $value ){
        global $InstanceCache;
        if(empty($key)){
            throw new Exception('update_configuration_value() needs a valid key');
        }
        $update_sql_array = [
            'configuration_value'=>$value,
            'last_modified'=>'now()'
        ];
        xtc_db_perform('configuration', $update_sql_array,'update',"configuration_key='".$key."'");
        $InstanceCache->deleteItem('configuration');
    }
    
    public static function get_configuration_value( string $key ){
        global $InstanceCache;
        if(empty($key)){
            throw new Exception('get_configuration_value() needs a valid key');
        }
        $query = xtc_db_query(sprintf(
                "SELECT configuration_value FROM configuration WHERE configuration_key='%s'",
                $key
        ));
        if(!xtc_db_num_rows($query)){
            return '';
        }
        $record = xtc_db_fetch_array($query);
        return $record['configuration_value'];
    }
    
    public static function get_currencies(){
        global $InstanceCache;
        $key = 'currencies';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $values = [];
            $query = xtc_db_query(sprintf(
                "SELECT * FROM %s",
                TABLE_CURRENCIES
            ));
            while($record = xtc_db_fetch_array($query)){
                $values[] = $record;
            }
            $CachedString->set($values)->expiresAfter(0)->addTag('shop');//currencies
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            return $values;
        }
        return $CachedString->get();
    }
    
    public static function get_customers_status( $customers_status_id, $languages_id = 2 ){
        global $InstanceCache;
        if($customers_status_id === Null){
            $customers_status_id = DEFAULT_CUSTOMERS_STATUS_ID;
        }
        $key = 'customers_status_'.$customers_status_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM %s WHERE customers_status_id='%s' AND language_id='%d'",
                    TABLE_CUSTOMERS_STATUS,$customers_status_id, $languages_id
            ));
            $result = xtc_db_fetch_array($query);
            $CachedString->set($result)->expiresAfter(0)->addTag('shop');//customers_status_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $result = $CachedString->get();
        }
        return $result;
    }
    
    public static function get_country_values( int $countries_id ){
        global $InstanceCache;
        $key = 'country_values_'.$countries_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $query = xtc_db_query(sprintf(
                "SELECT * FROM countries WHERE countries_id='%d'",
                $countries_id
            ));
            $result = xtc_db_fetch_array($query);
            $CachedString->set($result)->expiresAfter(0)->addTag('shop');//country_values_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $result = $CachedString->get();
        }
        return $result;
    }
    
    public static function get_country_values_from_name( string $country_name ){
        global $InstanceCache;
        $key = 'country_values_name_'.$country_name;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM countries WHERE countries_name='%s'",
                    $country_name
            ));
            $result = xtc_db_fetch_array($query);
            $CachedString->set($result)->expiresAfter(0)->addTag('shop');//country_values_name_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $result = $CachedString->get();
        }
        return $result;
    }
    
    public static function get_orders_status_name( int $orders_status_id, $language_id ){
        global $InstanceCache;
        if (empty($language_id) or (int)$language_id < 1) {
            $language_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        }
        $key = 'orders_status_name_'.$orders_status_id.'_'.$language_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $orders_status_query = xtc_db_query(sprintf(
                "select orders_status_name from %s where orders_status_id = '%d' and language_id = '%d'",
                TABLE_ORDERS_STATUS,$orders_status_id,$language_id
            ));
            $orders_status = xtc_db_fetch_array($orders_status_query);
            $CachedString->set($orders_status)->expiresAfter(0)->addTag('shop');//orders_status_name_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $orders_status = $CachedString->get();
        }
        return $orders_status['orders_status_name'];
    }
    public static function substr(string $string, int $length):string{
        if(strlen($string)>$length){
            $string_print = sprintf(
                '<span title="%s">%s[...]</span>',
                str_replace('"',"'",$string),
                substr($string,0,$length)
            );
        }else{
            $string_print = $string;
        }
        return $string_print;
    }

    public static function resize_image(string $image_filename, string $source_image_path,string $target_image_path, array $size):void{
        if(!str_ends_with($source_image_path,DIRECTORY_SEPARATOR)){
            $source_image_path .= DIRECTORY_SEPARATOR;
        }
        $tmpPath = $source_image_path.$image_filename;
        $info = getimagesize($tmpPath);

        if ($info === false) {
            throw new Exception("File ".basename($tmpPath)." is not a valid image.");
        }

        $mime = $info['mime'];

        // Original in GD laden
        switch ($mime) {
            case 'image/jpeg':
                $srcImg = imagecreatefromjpeg($tmpPath);
                break;
            case 'image/png':
                $srcImg = imagecreatefrompng($tmpPath);
                break;
            case 'image/gif':
                $srcImg = imagecreatefromgif($tmpPath);
                break;
            default:
                throw new Exception("Invalid Image Type: ".$mime);
        }

        $origWidth  = imagesx($srcImg);
        $origHeight = imagesy($srcImg);

        // Ordner anlegen (falls nicht vorhanden)
        $outputDir = $target_image_path;
        if(!str_ends_with($outputDir,DIRECTORY_SEPARATOR)){
            $outputDir .= DIRECTORY_SEPARATOR;
        }

        // Für jede Zielgröße speichern
        $maxWidth = $size[0];
        $maxHeight = $size[1];

        $ratio = min($maxWidth / $origWidth, $maxHeight / $origHeight);

        $newWidth  = (int)($origWidth * $ratio);
        $newHeight = (int)($origHeight * $ratio);

        $dstImg = imagecreatetruecolor($newWidth, $newHeight);

        // Transparenz bei PNG/GIF erhalten
        if ($mime === 'image/png' || $mime === 'image/gif') {
            imagecolortransparent($dstImg, imagecolorallocatealpha($dstImg, 0, 0, 0, 127));
            imagealphablending($dstImg, false);
            imagesavealpha($dstImg, true);
        }

        imagecopyresampled($dstImg, $srcImg, 0, 0, 0, 0, $newWidth, $newHeight, $origWidth, $origHeight);

        $savePath = $target_image_path.$image_filename;

        // Speichern abhaengig vom Format
        switch ($mime) {
            case 'image/jpeg':
                imagejpeg($dstImg, $savePath, 90);
                break;
            case 'image/png':
                imagepng($dstImg, $savePath, 6);
                break;
            case 'image/gif':
                imagegif($dstImg, $savePath);
                break;
        }

        imagedestroy($dstImg);        
        imagedestroy($srcImg);
    }
}