<?php
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');

// ALT
//require_once(DIR_WS_CLASSES.'nocc/common.php');


if(!function_exists('yes_return_bytes')){
    function yes_return_bytes($val) {
	$val = trim($val);
	$last = strtolower($val[strlen($val)-1]);
	switch($last) {
	    // The 'G' modifier is available since PHP 5.1.0
	    case 'g':
		$val *= 1024;
	    case 'm':
		$val *= 1024;
	    case 'k':
		$val *= 1024;
	}

	return $val;
    }
}
$att_path = DIR_FS_ADMIN.'importdata/mail_attachments/';
if(!is_dir($att_path)){
	mkdir($att_path);
	//chmod($att_path,0777);
}

function nocc_debug($str){
	print('<h1>DEBUG</h1><textarea cols="80" rows="120">');
	print_r($str);
	print('</textarea><br /><br />');
}
function extract_emails_from($string){
	preg_match_all("/[\._a-zA-Z0-9-+]+@[\._a-zA-Z0-9-]+/i", $string, $matches);
	if(sizeOf($matches)){
		return $matches[0];
	}
	return [];
}
function yes_get_attachment($attach_tab){
	$array = array();
	while ($tmp = array_shift($attach_tab)) {
		if (!empty($tmp['name'])) {
		    $mime = str_replace('/', '-', $tmp['mime']);
		    $att_name = nocc_imap::utf8($tmp['name']);
		    $att_name_dl = $att_name;
		    $array[] = array('url'=>DIR_WS_CLASSES.'nocc/download.php?mail=' . $mail . '&amp;part=' . $tmp['number'] . '&amp;transfer=' . $tmp['transfer'] . '&amp;filename=' . base64_encode($att_name_dl) . '&amp;mime=' . $mime,
				'name'=>$att_name_dl,
				'part'=>$tmp['number'],
				'transfer'=>$tmp['transfer'],
				'mime'=>$tmp['mime']
		    );
		}
	}
	return $array;
}

function yes_import_mail($content,$mail,$pop){
	global $att_path,$imap; // imap kommt aus cron_emails_nocc
	if($content['message_id'] != ''){
		$ee_list = \YES4Trade\Model\ebay_emails::filter([
			'messageid'=>$content['message_id']
		],['id']);
		if(sizeOf($ee_list) > 0){
			return -1;
		}
	}
	$from_email_filter = extract_emails_from($content['from']);
	if(!sizeOf($from_email_filter)){ // spam
		yes_mail_debug('Email ohne gueltige From Adresse ignoriert'."\n\n".print_r($content,true));
		return -1;
	}
	$from_email = current($from_email_filter);
	$from_name = str_replace(array('"','<'.$from_email.'>'),'',$content['from']);
	
	$dt = new DateTime();
	$dt->setTimestamp($content['timestamp']);
	$mailto_plain = extract_emails_from($content['to']);
	if(sizeOf($mailto_plain)){
		$mailto = current($mailto_plain);
	}else{
		$mailto = $imap['email_user'];
	}
	$email_id = \YES4Trade\Model\ebay_emails::create_ebay_emails([
		'subject'=>yes_decode_string($content['subject']),
		'mailto'=>$mailto,
		'from_name'=>yes_decode_string($from_name),
		'from_email'=>yes_decode_string($from_email),
		'messageid'=>$content['message_id'],
		'date'=>$dt->format('Y-m-d H:i:s'),
		'format'=>$content['body_mime']
	],yes_decode_string($content['body']));

	$mail_reader = new NOCC_MailReader($mail, $pop, true);
	$attach_tab = array();
	fillAttachTabFromMailReader($mail_reader, $attach_tab);
	$http_path = dirname($_SERVER["REQUEST_URI"]);
	if ($mail_reader->hasAttachments()) {
		$files = array();
		switch (sizeof($attach_tab)) {
			case 0:
				break;
			default:
				$files = yes_get_attachment($attach_tab);
				break;
		}
		if(sizeOf($files)){
			foreach($files as $att) {

				$save_path = $att_path.$email_id;
				$filename_sha1 = yes_get_sha1_from_string($att['name']);
				$save_name = $save_path.'/'.$filename_sha1;
				if(!is_dir($save_path)){
					mkdir($save_path);
				}
				if(is_file($save_name))
					unlink($save_name);
				if(!$file = $pop->fetchbody($mail, $att['part'])){
				    continue;
				}
				$file = nocc_imap::decode($file, $att['transfer']);
				$somecontent = $file;
				if (!$handle = fopen($save_name, "w")) {
					$ev = new NoccException('Kann Datei $save_name nicht schreiben');
					require DIR_WS_CLASSES.'nocc/html/header.php';
					require DIR_WS_CLASSES.'nocc/html/error.php';
					require DIR_WS_CLASSES.'nocc/html/footer.php';
				}

				// Schreibe $somecontent in die geöffnete Datei.
				if (!fwrite($handle, $somecontent)) {
					$ev = new NoccException('Kann Datei $save_name nicht schreiben');
					require DIR_WS_CLASSES.'nocc/html/header.php';
					require DIR_WS_CLASSES.'nocc/html/error.php';
					require DIR_WS_CLASSES.'nocc/html/footer.php';
					exit;
				}
				fclose($handle);
				\YES4Trade\Model\ebay_email_attachments::create_ebay_email_attachments([
					'email_id'=>intval($email_id),
					'filename'=>$att['name'],
					'filesize'=>filesize($save_name),
					'filetype'=>$att['mime']
				]);

			}
		}
	}
	return $email_id;
}
