<?php
/* --------------------------------------------------------------
   $Id: export_functions.php,v 1.1 2006/04/25 15:15:26 web2 Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce coding standards; www.oscommerce.com
   (c) 2003     nextcommerce (xtc_format_price.inc.php,v 1.7 2003/08/19); www.nextcommerce.org
   (c) 2003     nextcommerce (xtc_get_products_price.inc.php,v 1.13 2003/08/20); www.nextcommerce.org
   (c) 2003     nextcommerce (xtc_format_special_price.inc.php,v 1.6 2003/08/20); www.nextcommerce.org


   Released under the GNU General Public License
   --------------------------------------------------------------*/

require_once(DIR_FS_INC . 'xtc_precision.inc.php');
require_once(DIR_FS_INC . 'xtc_get_currencies_values.inc.php');
// require_once(DIR_FS_INC . 'xtc_get_products_special_price.inc.php');
require_once(DIR_FS_INC . 'xtc_get_qty.inc.php');


function xtc_get_tax_rate_export($class_id, $country_id = -1, $zone_id = -1) {
    global $currency,$InstanceCache; // calculate currencies

    if ( ($country_id == -1) && ($zone_id == -1) ) {
        $country_id = STORE_COUNTRY;
        $zone_id = STORE_ZONE;
    }

    $key = 'tax_rates_'.$country_id.'_'.$zone_id.'_'.$class_id;
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        $tax_query = xtc_db_query(sprintf(
                "select sum(tax_rate) as tax_rate from %s tr left join %s za on (tr.tax_zone_id = za.geo_zone_id) left join %s tz on (tz.geo_zone_id = tr.tax_zone_id) "
               ."where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '%d') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '%d') and tr.tax_class_id = '%d' group by tr.tax_priority",
                TABLE_TAX_RATES,TABLE_ZONES_TO_GEO_ZONES,TABLE_GEO_ZONES,
                $country_id,$zone_id,$class_id
        ));
        if (xtc_db_num_rows($tax_query)) {
            $tax_multiplier = 1.0;
            while ($tax = xtc_db_fetch_array($tax_query)) {
                $tax_multiplier *= 1.0 + ($tax['tax_rate'] / 100);
            }
            $return = ($tax_multiplier - 1.0) * 100;
        } else {
            $return = 0;
        }
        $CachedString->set($return)->expiresAfter(0)->addTag('shop');//tax_rates_*
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $return = $CachedString->get();
    }
    return $return;
}

function xtc_format_special_price_export ($special_price,$price,$price_special,$calculate_currencies,$quantity,$products_tax,$add_tax,$currency)
    {
    // calculate currencies
    global $currency; // calculate currencies
    $currencies_value = xtc_get_currencies_values($currency);
    $currencies_data = [
        'SYMBOL_LEFT'=>$currencies_value['symbol_left'] ,
        'SYMBOL_RIGHT'=>$currencies_value['symbol_right'] ,
        'DECIMAL_PLACES'=>$currencies_value['decimal_places'],
        'DEC_POINT'=>$currencies_value['decimal_point'],
        'THD_POINT'=>$currencies_value['thousands_point'],
        'VALUE'=> $currencies_value['value']
    ];
    if ($add_tax =='0') {
        $products_tax='';
    }
    //$special_price= (xtc_add_tax($special_price,$products_tax))*$quantity;
    //$price= (xtc_add_tax($price,$products_tax))*$quantity;
    $price=$price*$quantity;
    $special_price=$special_price*$quantity;

    if ($calculate_currencies=='true') {
    $special_price=$special_price * $currencies_data['VALUE'];
    $price=$price * $currencies_data['VALUE'];

    }
    // round price
    $special_price=xtc_precision($special_price,$currencies_data['DECIMAL_PLACES'] );
    $price=xtc_precision($price,$currencies_data['DECIMAL_PLACES'] );
    return $special_price;
}
