<?php
/* --------------------------------------------------------------
   $Id: general.php,v 1.35 2003/08/13 23:38:04 mbs Exp

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.156 2003/05/29); www.oscommerce.com
   (c) 2003	 nextcommerce (general.php,v 1.35 2003/08/1); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contributions:

   Customers Status v3.x (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Enable_Disable_Categories 1.3                Autor: Mikel Williams | mikel@ladykatcostumes.com

   Category Descriptions (Version: 1.5 MS2)    Original Author:   Brian Lowe <blowe@wpcusrgrp.org> | Editor: Lord Illicious <shaolin-venoms@illicious.net>

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   --------------------------------------------------------------*/
require(DIR_FS_CATALOG.'inc/xtc_collis.inc.php');
require(DIR_FS_CATALOG.'inc/xtc_get_currencies_values.inc.php');
function clear_string($value) {

  $string=str_replace("'",'',$value);
  $string=str_replace(')','',$string);
  $string=str_replace('(','',$string);
  $array=explode(',',$string);
  return $array;

  }

function xtc_get_sammler_title($sammler_id){
	if(intval($sammler_id) > 0){
		$title_query = yes_query("SELECT titel FROM ebay_sammler WHERE id=:id",[
      'id'=>intval($sammler_id)
    ],true);
    if($title_query !== false){
		  return $title_query['titel'];
    }else{
      return 'unknown sammler #'.$sammler_id;
    }
	}
	return EBAY_SAMMLER_DEFAULT_TITEL;
}

function xtc_get_branch_title($bID){
    if(intval($bID) < 1){
      return TEXT_BRANCHES_COUNTER_MAIN;
    }
    $title_query = yes_query("SELECT title FROM branches WHERE branches_id=:id",[
      'id'=>intval($bID)
      ],true
    );
    if($title_query === false){
      return 'Unknown branch id #'.$bID;
    }
    return $title_query['title'];
}

function xtc_adminuser_subject_from_textitem($userID){
	$user_query = yes_query("SELECT subject_from_textitem FROM customers WHERE customers_id=:id",[
    'id'=>intval($userID)
  ],true);
  if($user_query === false or intval($user_query['subject_from_textitem']) != 1){
    return false;
  }
  return true;
}
  
function xtc_get_distributor_orders_status_name($doID){
    $distributor_orders_array = xtc_get_distributor_orders_status();
    $order = current(array_filter($distributor_orders_array, fn($order) => intval($order['id']) === intval($doID)));
    // Rückgabe des Namens, falls vorhanden
    return $order['text'] ?? 'unknown distributor orders status #'.$doID; // Gibt null zurück, wenn kein Treffer gefunden wurde
}

function xtc_get_distributor_name($dID){
	$dname_query = yes_query("SELECT name FROM distributors WHERE id=:id",[
    'id'=>intval($dID)
  ],true);
  if($dname_query === false){
    return 'unknown distributor #'.$dID;
  }
	return $dname_query['name'];
}

function xtc_get_distributor_orders_status(){
    $languages_id = intval($_SESSION['languages_id']??2);
    $items = \YES4Trade\Model\distributor_orders_status::get_by_language_id($languages_id);
    $distributor_orders_status = array();
    foreach($items as $it){
        $distributor_orders_status[] = array(
            'id'=>$it->orders_status_id,
            'text'=>$it->orders_status_name
        );
    }
    return $distributor_orders_status;
}

function xtc_cfg_pull_down_shipping_methods_list($shipping_method, $key=''){
        require_once(DIR_FS_CATALOG.'includes/classes/shipping.php');
        $shipping_modules = new shipping;
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
        for($i=0;$i<sizeOf($shipping_modules->modules);$i++){
            require_once(DIR_FS_CATALOG.'lang/german/modules/shipping/'.$shipping_modules->modules[$i]);
            $id = str_replace('.php','',$shipping_modules->modules[$i]);
            $txt = constant('MODULE_SHIPPING_'.strtoupper($id).'_TEXT_TITLE');
            $id = $id.'_'.$id;
            $txt .= ' ('.$id.')';
            $array[] = array('id'=>$id,'text'=>$txt);
        }
	return xtc_draw_pull_down_menu($name, $array,$shipping_method);
}

function xtc_cfg_pull_down_distributors($distributor,$key=''){
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
	$query = xtc_db_query("SELECT id,name FROM distributors ORDER BY name");
	while($record = xtc_db_fetch_array($query)){
	  $array[] = array('id'=>$record['id'],'text'=>$record['name']);
	}
	return xtc_draw_pull_down_menu($name, $array,$distributor);
}
  
// ********** START   E B A Y ************************
function xtc_get_products_size($pID){
 	$collies = xtc_get_product_collies($pID);
	$size = array();
	if(is_countable($collies) and sizeOf($collies)>0){
		$sw = 0;
		$sh = 0;
		$sd = 0;
		foreach($collies as $ck=>$collie){
			$vol_query = yes_query(sprintf(
        "SELECT size_width*%d as sw,size_height*%d as sh,size_depth*%d as sd from %s WHERE products_id=:id",
          intval($collie['quantity']),
          intval($collie['quantity']),
          intval($collie['quantity']),
          TABLE_PRODUCTS
        ),['id'=>intval($collie['collie_products_id'])],
        true
      );
      if($vol_query !== false){
        $sw += $vol_query['sw'];
        $sd += $vol_query['sd'];
        $sh += $vol_query['sh'];
      }
		}
		$size = array(
      'width'=>$sw,
      'height'=>$sh,
      'depth'=>$sd
    );
	}else{
		$vol_query = yes_query(
      "SELECT size_width,size_height,size_depth from products WHERE products_id=:id",[
        'id'=>intval($pID)
      ],true
    );
    if($vol_query !== false){
      $size = array(
          'width'=>$vol_query['size_width'],
          'height'=>$vol_query['size_height'],
          'depth'=>$vol_query['size_depth']
      );
    }
	}
	return $size;
}

function xtc_get_volumina($pID, $number_of_nachkommastellen=2){
  $collies = xtc_get_product_collies($pID);
	$volume = 0;
	if(sizeOf($collies)>0){
		foreach($collies as $ck=>$collie){
			$vol_query = xtc_db_query("SELECT ((size_width*size_height*size_depth)*".$collie['quantity'].") as vol from products WHERE products_id='".$collie['collie_products_id']."'");
			$vol_res   = xtc_db_fetch_array($vol_query);
			if( $vol_res['vol'] > 0 ){
				$volume += (int) $vol_res['vol'];
			}
		}
	}else{
		$vol_query = xtc_db_query("SELECT (size_width*size_height*size_depth) as vol from products WHERE products_id='".$pID."'");
		$vol_res   = xtc_db_fetch_array($vol_query);
		if( floatval($vol_res['vol']) > 0 ){
			$volume += (int) $vol_res['vol'];
		}
	}
	if($volume > 0){
		return number_format($volume/1000000,$number_of_nachkommastellen,',','.');
  }
	return 0;
}
  
  
function xtc_get_price_ek($pID,$function = 'MIN',$distributors_id=-1,$check_default=true){
	$price = 0;
	// IS_DEFAULT HANDLING
	if($check_default){
	    if($distributors_id > 0){
		    $is_default_query = xtc_db_query(sprintf(
			    "SELECT is_default,price FROM distributor_product_prices WHERE products_id=%s and distributor_id=%s AND is_default=1",
			    $pID,$distributors_id
		    ));
		    if(xtc_db_num_rows($is_default_query)){
			    $is_default = xtc_db_fetch_array($is_default_query);
			    if($is_default['price'] > 0)
				    return (float)$is_default['price'];
		    }
	    }else{
		    $is_default_query = xtc_db_query(sprintf(
			    "SELECT %s(price) as maxprice FROM distributor_product_prices WHERE products_id=%s AND is_default=1",
			    $function,$pID,$distributors_id
		    ));
		    if(xtc_db_num_rows($is_default_query)){
			    $is_default = xtc_db_fetch_array($is_default_query);
			    if($is_default['maxprice'] > 0)
				    return (float)$is_default['maxprice'];
		    }
	    }
	}
	
	switch($function){
		case 'NEWEST':
		default:
			if($distributors_id>0){
				$ek_query = xtc_db_query("SELECT price as maxprice FROM distributor_product_prices WHERE products_id='".$pID."' and distributor_id='".$distributors_id."' ORDER BY date_saved DESC LIMIT 1");
			}else{
				$ek_query = xtc_db_query("SELECT price as maxprice FROM distributor_product_prices WHERE products_id='".$pID."' ORDER BY date_saved DESC LIMIT 1");
			}
			break;
	}
	$ek = xtc_db_fetch_array($ek_query);
	if( isset($ek['maxprice']) and floatval( $ek['maxprice'] ) > 0.00 ){
		$price += floatval($ek['maxprice']);
	}
	return (float)$price;
}

function xtc_get_price_ek_data($pID,$function = 'MIN',$distributors_id=-1){
		// IS_DEFAULT HANDLING
		if(intval($distributors_id) > 0){
			$is_default_query = yes_query(
				"SELECT * FROM distributor_product_prices WHERE products_id=:pid and distributor_id=:did AND is_default=1",[
          'pid'=>intval($pID),
          'did'=>intval($distributors_id)
        ],true
			);
			if($is_default_query !== false){
				if(floatval($is_default_query['price']) > 0){
				  return $is_default_query;
        }
			}
		}else{
      $is_default_query = yes_query(sprintf(
          "SELECT %s(price) as maxprice, distributor_id, conditions,shippings, shipping_status_id,price,vse,vpe FROM distributor_product_prices WHERE products_id=:id AND is_default=1",
            $function,$pID
          ),['id'=>intval($pID)],true
      );
      if($is_default_query !== false){
        if(floatval($is_default_query['maxprice']) > 0){
          return $is_default_query;
        }
      }
		}
                
    $shippingtime_sql_field='shipping_status_id';
		switch($function){
			case 'NEWEST':
			default:
				if(intval($distributors_id)>0){
					$ek_query = xtc_db_query("SELECT price as maxprice,price, conditions,shippings, ".$shippingtime_sql_field.",vse,vpe,date_saved FROM distributor_product_prices WHERE products_id='".$pID."' and distributor_id='".$distributors_id."' AND price > 0 ORDER BY date_saved DESC LIMIT 1");
				}else{
					$ek_query = xtc_db_query("SELECT price as maxprice, distributor_id, price,conditions,shippings, ".$shippingtime_sql_field.",vse,vpe,date_saved FROM distributor_product_prices WHERE products_id='".$pID."' AND price > 0 ORDER BY date_saved DESC LIMIT 1");
				}
				break;
		}
		$ek = xtc_db_fetch_array($ek_query);
		$_mp = (float) $ek['maxprice'];
		if( $_mp > 0 ){
			return $ek;
		}
}
  
function xtc_get_retoure_status(){
      global $InstanceCache;
      $key = 'retoure_statuses';
      $CachedString = $InstanceCache->getItem($key);
      if (!$CachedString->isHit()) {
          $retoures = array();
          $retoures_query = xtc_db_query("SELECT retoure_status_id,retoure_status_name FROM retoure_status");
          while($retoure = xtc_db_fetch_array($retoures_query)){
              $retoures[] = array(
                  'id'=>$retoure['retoure_status_id'],
                  'text'=>$retoure['retoure_status_name']
              );
          }
          $CachedString->set($retoures)->expiresAfter(0)->addTag('admin','retoure');//retoure_statuses
          $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
      }else{
          $retoures = $CachedString->get();
      }
      return $retoures;
}
  
function xtc_get_retoure_status_name($retoure_status_id){
  $retoure_array = xtc_get_retoure_status();
  $order = current(array_filter($retoure_array, fn($order) => intval($order['id']) === intval($retoure_status_id)));
  // Rückgabe des Namens, falls vorhanden
  return $order['text'] ?? 'unknown retoure status #'.$retoure_status_id; // Gibt null zurück, wenn kein Treffer gefunden wurde
}
  
function xtc_get_rueckerstattungen_types(){
  $ruecks = array();
  $items = \YES4Trade\Model\rueckerstattungen_types::get_all();
  foreach($items as $it){
    $ruecks[] = array(
      'id'=>$it->rueckerstattungen_type_id,
      'text'=>$it->rueckerstattungen_type_title
    );
  }
  return $ruecks;
}
  
function xtc_get_rueckerstattungen_types_name($rID){
      $item = \YES4Trade\Model\rueckerstattungen_types::get_by_rueckerstattungen_type_id((int)$rID);
      if($item !== null){
          return $item->rueckerstattungen_type_title;
      }
      return '';
}  
  
function xtc_get_rueckerstattungen_status(){
  $rueckerstattungen = array();
  $rueckerstattungen_query = xtc_db_query("SELECT rueckerstattungen_status_id,rueckerstattungen_status_title FROM rueckerstattungen_status");
  while($rueckerstattung = xtc_db_fetch_array($rueckerstattungen_query)){
    $rueckerstattungen[] = array('id'=>$rueckerstattung['rueckerstattungen_status_id'],'text'=>$rueckerstattung['rueckerstattungen_status_title']);
  }
  return $rueckerstattungen;
}
  
  function xtc_get_rueckerstattungen_status_name($rID){
    $rueckerstattungen_array = xtc_get_rueckerstattungen_status();
    foreach($rueckerstattungen_array as $k=>$v){
	if($v['id'] == $rID)
    		return $v['text'];
    }
  }
  

  function xtc_get_reclamations_status(){
	$reclamations = array();
	$reclamation_query = xtc_db_query("SELECT reclamations_status_id,reclamations_status_name FROM reclamations_status WHERE language_id='".$_SESSION['languages_id']."'");
	while($reclamation = xtc_db_fetch_array($reclamation_query)){
		$reclamations[] = array('id'=>$reclamation['reclamations_status_id'],'text'=>$reclamation['reclamations_status_name']);
	}
	return $reclamations;
  }
  
  function xtc_get_reclamations_status_name($rsID){
    $reclamations_array = xtc_get_reclamations_status();
    foreach($reclamations_array as $k=>$v){
	if($v['id'] == $rsID)
    		return $v['text'];
    }
    return ' (unbekannt ID '.$rsID.')';
  }

  function xtc_get_reclamations_types(){
	$reclamations_types = array();
	$reclamation_types_query = xtc_db_query("SELECT reclamations_types_id,reclamations_types_title FROM reclamations_types order by reclamations_types_id");
	while($reclamation_types = xtc_db_fetch_array($reclamation_types_query)){
		$reclamations_types[] = array('id'=>$reclamation_types['reclamations_types_id'],'text'=>$reclamation_types['reclamations_types_title']);
	}
	return $reclamations_types;
  }
  
  function xtc_get_reclamations_types_name($rtID){
    $reclamations_types_array = xtc_get_reclamations_types();
    foreach($reclamations_types_array as $k=>$v){
	if($v['id'] == $rtID)
    		return $v['text'];
    }
  }
  
  function yes_get_kasse_payments(){
	$kasse_payments = array();
	$kasse_payments_query = xtc_db_query("SELECT kasse_payments_id,payment_title,image FROM kasse_payments WHERE payment_active=1 order by payment_title");
	while($kasse_payments_res = xtc_db_fetch_array($kasse_payments_query)){
		$kasse_payments[] = array('id'=>$kasse_payments_res['kasse_payments_id'],'text'=>xtc_db_prepare_input($kasse_payments_res['payment_title']),'image'=>$kasse_payments_res['image'] );
	}
	return $kasse_payments;
  }
  
  function yes_get_kasse_payments_name($kpID){
    $kasse_payments_array = yes_get_kasse_payments();
    foreach($kasse_payments_array as $k=>$v){
	if($v['id'] == $kpID)
    		return $v['text'];
    }
  }
  
  
  function _shop_walk($catArray,$level = 0){
  	global $categories_array;
	$trenner = '';
	for($i=0;$i<$level;$i++){
		$trenner .= '--';
	}
	foreach($catArray as $cat) {
		$categories_array[] = array('id'=>$cat->CategoryID,'text'=>$trenner.$cat->Name);
		if(is_countable($cat->ChildCategory) and sizeOf($cat->ChildCategory)>0){
			_shop_walk($cat->ChildCategory,($level+1));
		}
	}
	return $categories_array;
  }
  function xtc_get_ebayshop_categorys( $user = ''){
      global $InstanceCache;
      if(empty($user)){
          if(!defined('EBAY_USER') or empty(constant('EBAY_USER'))){
              return [];
          }
          $user = constant('EBAY_USER');
      }
	    $EBAYAPI = new ebayAPI;
      $key = 'admin.ebay.storefronts.'.md5($user);
      $CachedString = $InstanceCache->getItem($key);
      if (!$CachedString->isHit()) {
        $ebaycalls = new \YES4Trade\Model\ebaycalls();
        $res = $ebaycalls->tradingQuery($user,
          'GetStore',
          $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE'))
        );
        if($res->Ack == 'Failure'){
          $categories_data = [];
        }else{
          $shop = $res->Store;
          $catArray = $shop->CustomCategories->CustomCategory;
          $categories_array = array(array('id' => '', 'text' => ''));
          $cats = _shop_walk($catArray,0);
          $categories_data = xtc_array_merge($categories_array,$cats);
        }
        $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG)->addTag('shop');//admin.ebay.storefronts.*
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
      }else{
        $categories_data = $CachedString->get();
      }
      return $categories_data;
  }

  function xtc_cfg_pull_down_ebay_user($ebay_user,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $user_array = xtc_get_ebay_users();
    return xtc_draw_pull_down_menu($name, $user_array, $ebay_user);
  }

  function xtc_get_ebay_users(){
	  $env = (main::isDev(true) or EBAY_TESTMODE == 1) ? 'sandbox' : 'production';
	  $user_array = array();
	  $user_query = xtc_db_query("SELECT user FROM ebay_auth WHERE environment='".$env."'");
	  while($user = xtc_db_fetch_array($user_query)){
		  $user_array[] = array('id'=>$user['user'],'text'=>$user['user']);
	  }
	  return $user_array;
  }
  
  function xtc_cfg_pull_down_ebay_shopcategory($category_id,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $category_array = xtc_get_ebayshop_categorys();
    return xtc_draw_pull_down_menu($name, $category_array, $category_id);
  }
  
  function xtc_get_ebayshop_category_name($category_id) {
    $category_array = xtc_get_ebayshop_categorys();
    if(is_array($category_array) and sizeOf($category_array)>0){
    	foreach($category_array as $k=>$v){
    		if($v['id'] == $category_id)
    			return $v['text'];
    	}
    }else{
    	return '';
    }
  }
  

  function xtc_get_storages() {
  	$storages = array();
	$storage_query = xtc_db_query("SELECT name,id FROM storages ORDER BY name");
	while($storage = xtc_db_fetch_array($storage_query)){
		$storages[] = array('id'=>$storage['id'],'text'=>$storage['name']);
	}
	return $storages;
  }  
    
  function xtc_get_editor_name($editor_id) {
    if($editor_id == 0) return 'System';
    $editor_name_query = xtc_db_query("SELECT customers_firstname,customers_lastname FROM customers WHERE customers_id='".(int)xtc_db_input($editor_id)."'");
    if(xtc_db_num_rows($editor_name_query)){
	$editor_name = xtc_db_fetch_array($editor_name_query);
	if(empty($editor_name['customers_firstname']) and empty($editor_name['customers_lastname']))
	    return 'leer';
	return $editor_name['customers_firstname'].' '.$editor_name['customers_lastname'];
    }else{
	return 'unbekannt';
    }
  }
  // //
  // Alias function for Store configuration values in the Administration Tool
  function xtc_cfg_pull_down_versender_list($versender_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    return xtc_draw_pull_down_menu($name, \YES4Trade\Model\shipper_profiles::get_selection_list(), $versender_id);
  }
  
  function xtc_cfg_pull_down_ebay_currencies($currency_id,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $currencies_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $currencies_query = xtc_db_query("select id, currency_name from " . TABLE_EBAY_CURRENCIES . " order by id");
    while ($currencies = xtc_db_fetch_array($currencies_query)) {
      $currencies_array[] = array('id' => $currencies['id'],
                                 'text' => $currencies['currency_name']);
    }
    return xtc_draw_pull_down_menu($name, $currencies_array, $currency_id);
  }


  function xtc_get_ebay_currency_name($currency_id) {
    $currency_query = xtc_db_query("select currency_name from " . TABLE_EBAY_CURRENCIES . " where id = '" . $currency_id . "'");
    $currency = xtc_db_fetch_array($currency_query);
    return $currency['currency_name'];
  }

  function yes_get_ebay_available_shiptolocations(){
      $EBAYAPI = new ebayApi;
      $res = $EBAYAPI->get_ebay_details('ShippingLocationDetails');
      $array = array();
      foreach($res->ShippingLocationDetails as $sl){
	  $array[] = array(
	      'id'=>$sl->ShippingLocation,
	      'text'=>$sl->Description.' ('.$sl->ShippingLocation.')'
	  );
      }
      return $array;
  }
  
  function xtc_get_ebay_shiptolocations_name($location_id){
      if(!defined('EBAY_USER') or empty(constant('EBAY_USER'))){
          return '';
      }
	$locations = yes_get_ebay_available_shiptolocations();
	foreach($locations as $loc){
		if($loc['id']==$location_id)
			return $loc['text'];
	}
  }

  function xtc_cfg_pull_down_ebay_shiptolocations_list($location_id,$key=''){
    	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	return xtc_draw_pull_down_menu($name, yes_get_ebay_available_shiptolocations(), $location_id);
  }
  
  
  function xtc_cfg_pull_down_ebay_auctiontypes($type_id,$key = '') {
    	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	global $_YES_auction_types;
	$types = array();
	foreach($_YES_auction_types as $k=>$v){
		$types[] = array('id'=>$k,'text'=>$v);
	}
	return xtc_draw_pull_down_menu($name, $types, $type_id);
  }

  function xtc_get_ebay_auctiontype_name($type_id) {
	global $_YES_auction_types;
	foreach($_YES_auction_types as $k=>$v){
		if($k==$type_id)
			return $v;
	}
  }

  function xtc_cfg_pull_down_ebay_counter($counter_id,$key = '') {
    	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	global $_YES_auction_counter;
	$counters = array();
	foreach($_YES_auction_counter as $k=>$v){
		$counters[] = array('id'=>$k,'text'=>$v);
	}
	return xtc_draw_pull_down_menu($name, $counters, $counter_id);
  }
  
  function xtc_get_ebay_counter_name($counter_id) {
	global $_YES_auction_counter;
	foreach($_YES_auction_counter as $k=>$v){
		if($k==$counter_id)
			return $v;
	}
  }

  function xtc_cfg_pull_down_ebay_durations($duration_id,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $durations_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $durations_query = xtc_db_query("select id, duration from " . TABLE_EBAY_DURATIONS . " order by id");
    while ($durations = xtc_db_fetch_array($durations_query)) {
      if($durations['id'] > 0){
	      $durations_array[] = array('id' => $durations['id'],
                                 'text' => $durations['duration']);
      }else{
	      $durations_array[] = array('id' => $durations['id'],
                                 'text' => 'Bis auf Widerruf (Nur Shop)');
      }
    }
    return xtc_draw_pull_down_menu($name, $durations_array, $duration_id);
  }

  function xtc_get_ebay_duration_name($duration_id) {
    $duration_query = xtc_db_query("select duration from " . TABLE_EBAY_DURATIONS . " where id = '" . $duration_id . "'");
    $duration = xtc_db_fetch_array($duration_query);
    return $duration['duration'];
  }

  function xtc_get_ebay_revise_automatics(){
    $revise_array = array(
    	0=>array('id' => '', 'text' => TEXT_AUTOMATIC_REVISE_SELECT_NO),
    	1=>array('id' => 'to_qty', 'text' => TEXT_AUTOMATIC_REVISE_SELECT_TO_QTY)
    );
    return $revise_array;
  }
  
  function xtc_cfg_pull_down_ebay_revise_automatic($revise,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    return xtc_draw_pull_down_menu($name, xtc_get_ebay_revise_automatics(), $revise);
  }

  function xtc_get_ebay_revise_automatic_name($revise) {
  	switch($revise){
  		case 'to_qty':
  			return TEXT_AUTOMATIC_REVISE_SELECT_TO_QTY;
  			break;
  		default:
  			return TEXT_AUTOMATIC_REVISE_SELECT_NO;
  			break;
  	}
  }

  function xtc_get_ebay_site_id_name($site_id) {
    return $site_id;
  }

  function xtc_cfg_pull_down_ebay_site_id_list($site_id,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $site_query = xtc_db_query("select site_id from ebay_sitecodes");
    $sites_array = array();
    while ($sites = xtc_db_fetch_array($site_query)) {
      $sites_array[] = array('id' => $sites['site_id'],
                               'text' => $sites['site_id']);
    }
    return xtc_draw_pull_down_menu($name, $sites_array, $site_id);
  }
  
  
  function xtc_cfg_pull_down_ebay_countries($country_code,$key='') {

    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $countries_array = array(array('id' => '0', 'text' => TEXT_NONE));

    $countries_query = xtc_db_query("select * from " . TABLE_EBAY_COUNTRIES);

    while ($countries = xtc_db_fetch_array($countries_query)) {

      $countries_array[] = array('id' => $countries['country_value'],

                                 'text' => $countries['country_name']." (".$countries["country_value"].")");

    }

    return xtc_draw_pull_down_menu($name, $countries_array, $country_code);

  }

  function xtc_get_ebay_country_name($country_code) {

    $country_query = xtc_db_query("select * from " . TABLE_EBAY_COUNTRIES . " where country_value = '" . $country_code . "'");

    $country = xtc_db_fetch_array($country_query);

    return $country['country_name']." (".$country['country_value'].")";

  }

  function xtc_draw_ebay_duration_pull_down( $name, $parameters = '', $exclude = '', $value='' ) {
    if ($exclude == '') {
      $exclude = array();
    }
    $select_string = '<select name="' . $name . '"';
    if ($parameters) {
      $select_string .= ' ' . $parameters;
    }
    $select_string .= '>';
    $durations_query = xtc_db_query("select * FROM ".TABLE_EBAY_DURATIONS);
    while ($durations = xtc_db_fetch_array($durations_query)) {
     	if ( !xtc_in_array( $durations['duration'], $exclude)) {
        	$select_string .= '<option value="' . $durations['id'].'"';
        	if($value == $durations["duration"])
        		$select_string .= ' selected';
		if($durations['id'] > 0)
	       		$select_string .= '>' . $durations['duration'] . '</option>';
		else
	       		$select_string .= '>Bis auf Widerruf</option>';
        }
    }
    $select_string .= '</select>';
    return $select_string;
  }

  function xtc_get_ebay_duration_value( $duration_id ) {
    $duration_query = xtc_db_query("select duration FROM ".TABLE_EBAY_DURATIONS." WHERE id='".$duration_id."'");
    $duration = xtc_db_fetch_array($duration_query);
    return $duration['duration'];
  }

  function xtc_get_ebay_carrier_value( $carrier_id ) {
    return $carrier_id;
  }

  function xtc_draw_ebay_type_pull_down( $name, $parameters = '', $exclude = '',$value = '' ) {
    if ($exclude == '') {
      $exclude = array();
    }
    $select_string = '<select name="' . $name . '"';
    if ($parameters) {
      $select_string .= ' ' . $parameters;
    }
    $select_string .= '>';
  	$checked = ($value == '1') ? ' selected' : '';
   	$select_string .= "<option value='1'".$checked.">Auktion</option>";
  	$checked = ($value == '9') ? ' selected' : '';
   	$select_string .= "<option value='9'".$checked.">Festpreis</option>";
    $select_string .= '</select>';
    return $select_string;
  }

  // ********** E N D   E B A Y ************************


  function check_stock($products_id) {
  if (constant('STOCK_CHECK') == 'true') {
    $stock_flag = '';
    $stock_query = xtc_db_query("SELECT products_quantity FROM " . TABLE_PRODUCTS . " where products_id = '" . $products_id . "'");
    $stock_values = xtc_db_fetch_array($stock_query);
    if ($stock_values['products_quantity'] <= '0') {
      $stock_flag = 'true';
      $stock_warn = TEXT_WARN_MAIN;
    }

    if ($stock_flag == 'true' && $products_id != '') {
      return '<td class="dataTableContent">' . xtc_image(DIR_WS_IMAGES . 'icon_status_red.gif', IMAGE_ICON_STATUS_GREEN, 10, 10) . ' ' . $stock_warn . '</td>';
    } else {
      return '<td class="dataTableContent">' . xtc_image(DIR_WS_IMAGES . 'icon_status_green.gif', IMAGE_ICON_STATUS_GREEN, 10, 10) . '</td>';
    }
    }
  }

// Set Categorie Status
function xtc_set_categories_status($categories_id, $status) {
    if ($status == '1') {
        $upd = new \YES4Trade\Model\category([
            'categories_id'=>(int)$categories_id,
            'categories_status' => 1
        ]);
        $upd->update();
        return true;
    } elseif ($status == '0') {
        $upd = new \YES4Trade\Model\category([
            'categories_id'=>(int)$categories_id,
            'categories_status' => 0
        ]);
        $upd->update();
        return true;
    }
    return false;
}

function xtc_set_groups($categories_id,$shops) {

    // get products in categorie
    $_products = [];
    $products_query=xtc_db_query("SELECT products_id FROM ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id='".$categories_id."'");
    while ($products=xtc_db_fetch_array($products_query)) {
        $_products[] = $products;
    }
    foreach($_products as $products){
        xtc_db_query("UPDATE ".TABLE_PRODUCTS." SET group_ids='".$shops."' where products_id='".$products['products_id']."'");
    }
    $_products = null;
    $upd = new \YES4Trade\Model\category([
        'categories_id'=>(int)$categories_id,
        'group_ids'=>$shops
    ]);
    $upd->update();
    $_categories = [];
    $categories_query=xtc_db_query("SELECT categories_id FROM ".TABLE_CATEGORIES." where parent_id='".$categories_id."'");
    while ($categories=xtc_db_fetch_array($categories_query)) {
        $_categories[] = $categories;
    }
    foreach($_categories as $categories){
        xtc_set_groups($categories['categories_id'],$shops);
    }
}

function xtc_set_categories_rekursiv($categories_id,$status,$update_products=1,$update_subcategories=1,$update_products_shop_status=0) {
    // BRAUCHEN WIR FUER DEN FALL, DAS SUBKATEGORIEN NICHT AKTUALISIERT WERDEN SOLLEN, ABER DIE ARTIKEL
    global $start_cid;
    // get products in categorie
    if($update_products == 1){
        $products_query=xtc_db_query("SELECT products_id FROM ".TABLE_PRODUCTS_TO_CATEGORIES." where categories_id='".$categories_id."'");
        while ($products=xtc_db_fetch_array($products_query)) {
            // NEUER PARAMETER - Ticket 3276
            if(isset($update_products_shop_status) and $update_products_shop_status == 1){
                xtc_db_query("UPDATE ".TABLE_PRODUCTS." SET products_status='".$status."',products_listing_status='".$status."' where products_id='".$products['products_id']."'");
            }else{
                xtc_db_query("UPDATE ".TABLE_PRODUCTS." SET products_status='".$status."' where products_id='".$products['products_id']."'");
            }
        }
    }
    // set status of categorie
    if($update_subcategories == 1 or ($update_subcategories == 0 and $start_cid == $categories_id)){
        $upd = new \YES4Trade\Model\category([
            'categories_id'=>(int)$categories_id,
            'categories_status' => (int)$status
        ]);
        $upd->update();
    }
    // look for deeper categories and go rekursiv
    $categories_query=xtc_db_query("SELECT categories_id FROM ".TABLE_CATEGORIES." where parent_id='".$categories_id."'");
    while ($categories=xtc_db_fetch_array($categories_query)) {
        xtc_set_categories_rekursiv($categories['categories_id'],$status,$update_products,$update_subcategories, $update_products_shop_status);
    }
}

function xtc_set_categories_ebayapi_cart_rekursiv($categories_id,$ebayapi_cart) {
    // BRAUCHEN WIR FUER DEN FALL, DAS SUBKATEGORIEN NICHT AKTUALISIERT WERDEN SOLLEN, ABER DIE ARTIKEL
    global $start_cid;
    $upd = new \YES4Trade\Model\category([
        'categories_id'=>(int)$categories_id,
        'ebayapi_cart' => $ebayapi_cart
    ]);
    $upd->update();
    // look for deeper categories and go rekursiv
    $child_categories = \YES4Trade\Model\category::get_by_parent_id((int)$categories_id,[
        'categories_id'
    ]);
    foreach($child_categories as $cc){
        xtc_set_categories_ebayapi_cart_rekursiv($cc->categories_id,$ebayapi_cart);
    }
}


  // Set Admin Access Rights
  function xtc_set_admin_access($fieldname, $status, $cID) {
    global $InstanceCache;
    xtc_db_query(sprintf(
            "update %s set %s = '%d' where customers_id = '%d'",
            TABLE_ADMIN_ACCESS,
            $fieldname,
            (int)$status,
            (int)$cID
    ));
    $InstanceCache->deleteItem('admin_access');
}

// Check whether a referer has enough permission to open an admin page
function xtc_check_permission($pagename){
    if ($pagename!='index') {
      try{
        $access_permission = yes_query(sprintf(
          "select `%s` from %s where customers_id =:id",
            $pagename,
            TABLE_ADMIN_ACCESS,
          ),[
            'id'=>intval($_SESSION['customer_id']),
          ],true
        );
      }catch(PDOException $Exception){
        die($Exception->getMessage( ) .' - Code: '. $Exception->getCode( ) );
      }
        if($access_permission === false){
          die('No auth for '.$pagename);
          return false;
        }
        switch($pagename){
            case 'kasse':
                if(has_concergio_special_auth()){
                    return true;
                }
                break;
        }
        if (($_SESSION['customers_status']['customers_status_id'] == '0') && (intval($access_permission[$pagename]) == 1)) {
            return true;
        } else {
            return false;
        }
    } else {
        xtc_redirect(xtc_href_link(FILENAME_LOGIN));
    }
}


  ////
  // Redirect to another page or site
  function xtc_redirect($url) {
    global $logger;

    header('Location: ' . $url);

    if (constant('STORE_PAGE_PARSE_TIME') == 'true') {
      if (!is_object($logger)) $logger = new logger;
      $logger->timer_stop();
    }

    exit;
  }

  function xtc_get_path($current_category_id = '') {
    global $cPath_array;

    if ($current_category_id == '') {
      $cPath_new = implode('_', $cPath_array);
    } else {
      if (!is_countable($cPath_array) or sizeof($cPath_array) == 0) {
        $cPath_new = $current_category_id;
      } else {
        $cPath_new = '';
        $last_category_query = xtc_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . $cPath_array[(sizeof($cPath_array)-1)] . "'");
        $last_category = xtc_db_fetch_array($last_category_query);
        $current_category_query = xtc_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . $current_category_id . "'");
        $current_category = xtc_db_fetch_array($current_category_query);
        if ($last_category['parent_id'] == $current_category['parent_id']) {
          for ($i = 0, $n = sizeof($cPath_array) - 1; $i < $n; $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        } else {
          for ($i = 0, $n = sizeof($cPath_array); $i < $n; $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        }
        $cPath_new .= '_' . $current_category_id;
        if (substr($cPath_new, 0, 1) == '_') {
          $cPath_new = substr($cPath_new, 1);
        }
      }
    }

    return 'cPath=' . $cPath_new;
  }

  function xtc_get_all_get_params($exclude_array = '') {

    if ($exclude_array == '') $exclude_array = array();

    $get_url = '';

    reset($_GET);
    foreach($_GET as $key=>$value){
        if (($key != session_name()) && ($key != 'error') && (!xtc_in_array($key, $exclude_array))) {
            if(is_array($value)){
                foreach($value as $val){
                    $get_url .= $key . '[]=' . urlencode($val) . '&';
                }
            }else{
                $get_url .= $key . '=' . urlencode($value) . '&';
            }
	}
    }

    return $get_url;
  }

  function xtc_date_long($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;
    setlocale(LC_TIME, 'de_DE.UTF-8', 'de_DE', 'deu_deu');
    $date = new \DateTime($raw_date);
  // Erstelle einen IntlDateFormatter für Deutsch
    $formatter = new \IntlDateFormatter(
      'de_DE', 
      IntlDateFormatter::FULL, 
      IntlDateFormatter::FULL, 
      'Europe/Berlin',
      IntlDateFormatter::GREGORIAN
    );
    $formatter->setPattern('EEE, dd MMM yyyy HH:mm:ss z');
    return $formatter->format($date);
/* 2025/05 raus
    $year = (int)substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    return yes_strftime(DATE_FORMAT_LONG, mktime($hour, $minute, $second, $month, $day, $year));
    */
  }

  ////
  // Output a raw date string in the selected locale date format
  // $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
  // NOTE: Includes a workaround for dates before 01/01/1970 that fail on windows servers
  function xtc_date_short($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;
    
    return yes_date_short($raw_date);

    $year = substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    if (@date('Y', mktime($hour, $minute, $second, $month, $day, $year)) == $year) {
      return date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
    } else {
      return ereg_replace('2037' . '$', $year, date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, 2037)));
    }

  }

  function xtc_datetime_short($raw_datetime) {
    if ( ($raw_datetime == '0000-00-00 00:00:00') || ($raw_datetime == '') ) return false;

    $year = (int)substr($raw_datetime, 0, 4);
    $month = (int)substr($raw_datetime, 5, 2);
    $day = (int)substr($raw_datetime, 8, 2);
    $hour = (int)substr($raw_datetime, 11, 2);
    $minute = (int)substr($raw_datetime, 14, 2);
    $second = (int)substr($raw_datetime, 17, 2);

    return yes_strftime(DATE_TIME_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
  }

  function xtc_array_merge($array1, $array2, $array3 = '') {
    
    if (!is_countable($array1)){ 
        $array1 = array(); 
    }
    if (!is_countable($array2)){ 
        $array2 = array(); 
    }
    if (!is_countable($array3)) { 
        $array3 = array(); 
    }
    if (function_exists('array_merge')) {
      $array_merged = array_merge($array1, $array2, $array3);
    } else {
      foreach($array1 as $key => $val) $array_merged[$key] = $val;
      foreach($array2 as $key => $val) $array_merged[$key] = $val;
      if(sizeof($array3) > 0){ 
          foreach($array3 as $key => $val) {
              $array_merged[$key] = $val;
          }
      }
    }

    return (array) $array_merged;
  }

  function xtc_in_array($lookup_value, $lookup_array) {
    if (function_exists('in_array')) {
      if (in_array($lookup_value, $lookup_array)) return true;
    } else {
      reset($lookup_array);
      foreach($lookup_array as $key => $value) {
        if ($value == $lookup_value) return true;
      }
    }

    return false;
  }
  
  function xtc_cfg_pull_down_shop_categories($categories_id,$key = -1){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $categories_values = \YES4Trade\Model\category::get_categories_id_text_values_by_categories_id(0);
    return xtc_draw_pull_down_menu($name, $categories_values,$categories_id);
  }
  $exct = array();


  function xtc_info_image($image, $alt, $width = '', $height = '') {
    if ( ($image) && (file_exists(DIR_FS_CATALOG_IMAGES . $image)) ) {
      $image = xtc_image(DIR_WS_CATALOG_IMAGES . $image, $alt, $width, $height);
    } else {
        
      $image = TEXT_IMAGE_NONEXISTENT;
    }

    return $image;
  }

    function xtc_info_image_c($image, $alt, $width = '', $height = '') {
    if ( ($image) && (file_exists(DIR_FS_CATALOG_IMAGES .'categories/'. $image)) ) {
      $image = xtc_image(DIR_WS_CATALOG_IMAGES .'categories/'. $image, $alt, $width, $height);
    } else {
      $image = TEXT_IMAGE_NONEXISTENT;
    }

    return $image;
  }

  function xtc_product_info_image($image, $alt, $width = '', $height = '') {
    if ( ($image) && (file_exists(DIR_FS_CATALOG_INFO_IMAGES . $image)) ) {
      $image = xtc_image(DIR_WS_CATALOG_INFO_IMAGES . $image, $alt, $width, $height);
    } else {
      $image = TEXT_IMAGE_NONEXISTENT;
    }

    return $image;
  }

  function xtc_product_thumb_image($image, $alt, $width = '', $height = '') {
    if ( ($image) && (file_exists(DIR_FS_CATALOG_THUMBNAIL_IMAGES . $image)) ) {
      $image = xtc_image(DIR_WS_CATALOG_THUMBNAIL_IMAGES . $image, $alt, $width, $height);
    } else {
      $image = TEXT_IMAGE_NONEXISTENT;
    }

    return $image;
  }


  function xtc_break_string($string, $len, $break_char = '-') {
    $l = 0;
    $output = '';
    for ($i = 0; $i < strlen($string); $i++) {
      $char = substr($string, $i, 1);
      if ($char != ' ') {
        $l++;
      } else {
        $l = 0;
      }
      if ($l > $len) {
        $l = 1;
        $output .= $break_char;
      }
      $output .= $char;
    }

    return $output;
  }

  function xtc_get_country_name($country_id) {
    $country_query = xtc_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . $country_id . "'");

    if (!xtc_db_num_rows($country_query)) {
      return $country_id;
    } else {
      $country = xtc_db_fetch_array($country_query);
      return $country['countries_name'];
    }
  }

  function xtc_get_zone_name($country_id, $zone_id, $default_zone) {
    $zone_query = xtc_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . $country_id . "' and zone_id = '" . $zone_id . "'");
    if (xtc_db_num_rows($zone_query)) {
      $zone = xtc_db_fetch_array($zone_query);
      return $zone['zone_name'];
    } else {
      return $default_zone;
    }
  }


  function xtc_browser_detect($component) {

    return stristr($_SERVER['HTTP_USER_AGENT'], $component);
  }

  function xtc_tax_classes_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $classes_query = xtc_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
    while ($classes = xtc_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['tax_class_id'] . '"';
      if ($selected == $classes['tax_class_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['tax_class_title'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
  }

function xtc_geo_zones_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $zones = \YES4Trade\Model\geo_zones::get_id_text_list();
    foreach ($zones as $zone) {
        $select_string .= '<option value="' . $zone['id'] . '"';
        if (intval($selected) == intval($zone['id'])){
            $select_string .= ' SELECTED';
        }
        $select_string .= '>' . $zone['text'] . '</option>';
    }
    $select_string .= '</select>';

    return $select_string;
}

function xtc_get_geo_zone_name($geo_zone_id) {
    $geo_zone = \YES4Trade\Model\geo_zones::get_by_geo_zone_id(intval($geo_zone_id),[
        'geo_zone_name'
    ]);
    if($geo_zone === null){
        return 'Geo Zone ID #'.$geo_zone_id;
    }
    return $geo_zone->geo_zone_name;
}

  function xtc_address_format($address_format_id, $address, $html, $boln, $eoln) {
    $address_format_query = xtc_db_query("select address_format as format from " . TABLE_ADDRESS_FORMAT . " where address_format_id = '" . $address_format_id . "'");
    $address_format = xtc_db_fetch_array($address_format_query);

    $company = addslashes($address['company']);
	if(isset($address['firstname']))
		$firstname = addslashes($address['firstname']);
	else
		$firstname = '';
	if(isset($address['lastname']))
		$lastname = addslashes($address['lastname']);
	else
		$lastname = '';
	if(isset($address['csID']))
		$cid = addslashes($address['csID']);
	else
		$cid = '';
    $street = addslashes($address['street_address']);
    $suburb = addslashes($address['suburb']);
    $city = addslashes($address['city']);
    $state = addslashes($address['state']);
	if(isset($address['country_id']))
		$country_id = $address['country_id'];
	else
		$country_id = '';
	if(isset($address['zone_id']))
		$zone_id = $address['zone_id'];
	else
		$zone_id = '';
    $postcode = addslashes($address['postcode']);
    $zip = $postcode;
    $country = xtc_get_country_name($country_id);
    $state = xtc_get_zone_code($country_id, $zone_id, $state);

    if ($html) {
      // HTML Mode
      $HR = '<hr>';
      $hr = '<hr>';
      if ( ($boln == '') && ($eoln == "\n") ) { // Values not specified, use rational defaults
        $CR = '<br>';
        $cr = '<br>';
        $eoln = $cr;
      } else { // Use values supplied
        $CR = $eoln . $boln;
        $cr = $CR;
      }
    } else {
      // Text Mode
      $CR = $eoln;
      $cr = $CR;
      $HR = '----------------------------------------';
      $hr = '----------------------------------------';
    }

    $statecomma = '';
    $streets = $street;
    if ($suburb != '') $streets = $street . $cr . $suburb;
    if ($firstname == '') $firstname = addslashes($address['name']);
    if ($country == '') $country = addslashes($address['country']);
    if ($state != '') $statecomma = $state . ', ';

    $fmt = $address_format['format'];
    eval("\$address = \"$fmt\";");
    $address = stripslashes($address);

    if ( (constant('ACCOUNT_COMPANY') == 'true') && (xtc_not_null($company)) ) {
      $address = stripslashes($company) . $cr . $address;
    }

    return $address;
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Function    : xtc_get_zone_code
  //
  // Arguments   : country           country code string
  //               zone              state/province zone_id
  //               def_state         default string if zone==0
  //
  // Return      : state_prov_code   state/province code
  //
  // Description : Function to retrieve the state/province code (as in FL for Florida etc)
  //
  ////////////////////////////////////////////////////////////////////////////////////////////////
  function xtc_get_zone_code($country, $zone, $def_state) {

    $state_prov_query = xtc_db_query("select zone_code from " . TABLE_ZONES . " where zone_country_id = '" . $country . "' and zone_id = '" . $zone . "'");

    if (!xtc_db_num_rows($state_prov_query)) {
      $state_prov_code = $def_state;
    }
    else {
      $state_prov_values = xtc_db_fetch_array($state_prov_query);
      $state_prov_code = $state_prov_values['zone_code'];
    }

    return $state_prov_code;
  }

  function xtc_get_uprid($prid, $params) {
    $uprid = $prid;
    if ( (is_array($params)) && (!strstr($prid, '{') and !strstr($prid, '(')) ) {
      foreach($params as $option => $value) {
          if(!strstr($option,':')){
              $uprid = $uprid . '{' . $option . '}' . $value;
          }else{
              $uprid = $uprid . '(' . $option . ')' . $value;
          }
      }
    }
    return $uprid;
  }

  function xtc_get_prid($uprid) {
    if(strstr($uprid,'(')){
        $pieces = explode('(',$uprid);
        $uprid = $pieces[0];
    }
    $pieces = explode ('{', $uprid);
    return $pieces[0];
  }

function xtc_get_languages() {
    $languages_array = [];
    foreach(\YES4Trade\Model\languages::get_list() as $languages) {
        $languages_array[] = array(
            'id' => $languages['languages_id'],
            'name' => $languages['name'],
            'code' => $languages['code'],
            'image' => $languages['image'],
            'directory' => $languages['directory']
        );
    }
    return $languages_array;
}

function xtc_get_categories_name($category_id, $language_id=0):string {
    if($language_id == 0) {
        $language_id = $_SESSION['languages_id']??2;
    }
    if(strpos($category_id,'_')>-1) {
    	$cat = explode('_',$category_id);
    	$category_id = $cat[ (sizeOf($cat)-1) ];
    }
    if($category_id == 0){
        return 'TOP';
    }
    $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
        intval($category_id), intval($language_id),[
            'categories_name'
        ]
    );
    if($cd !== null){
        return $cd->categories_name;
    }
    return 'unknown';
}

  function xtc_get_categories_heading_title($category_id, $language_id) {
        if($language_id == 0){
            $language_id = $_SESSION['languages_id']??2;
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($category_id), intval($language_id),[
                'categories_heading_title'
            ]
        );
        if($cd !== null){
            return $cd->categories_heading_title;
        }
        return '';
  }

  function xtc_get_categories_description($category_id, $language_id) {
        if($language_id == 0){
            $language_id = $_SESSION['languages_id']??2;
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($category_id), intval($language_id),[
                'categories_description'
            ]
        );
        if($cd !== null){
            return $cd->categories_description;
        }
        return '';
  }

  function xtc_get_categories_meta_title($category_id, $language_id) {
        if($language_id == 0){
            $language_id = $_SESSION['languages_id']??2;
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($category_id), intval($language_id),[
                'categories_meta_title'
            ]
        );
        if($cd !== null){
            return $cd->categories_meta_title;
        }
        return '';
  }

  function xtc_get_categories_meta_description($category_id, $language_id) {
        if($language_id == 0){
            $language_id = $_SESSION['languages_id']??2;
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($category_id), intval($language_id),[
                'categories_meta_description'
            ]
        );
        if($cd !== null){
            return $cd->categories_meta_description;
        }
        return '';
  }

  function xtc_get_categories_meta_keywords($category_id, $language_id) {
        if($language_id == 0){
            $language_id = $_SESSION['languages_id']??2;
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($category_id), intval($language_id),[
                'categories_meta_keywords'
            ]
        );
        if($cd !== null){
            return $cd->categories_meta_keywords;
        }
        return '';
  }

function xtc_get_orders_status_name($orders_status_id, $language_id = '') {
    return main::get_orders_status_name( intval($orders_status_id), intval($language_id));
}

function xtc_get_shipping_status_name($shipping_status_id, $language_id = '') {
    if($shipping_status_id < 1){
        return '';
    }
    if (empty($language_id) or $language_id<1) {
        $language_id = $_SESSION['languages_id'];
    }
    $shipping_statuses = \YES4Trade\Model\shipping_status::get_list($language_id);
    foreach($shipping_statuses as $ss){
        if($ss['shipping_status_id']==$shipping_status_id){
            return $ss['shipping_status_name'];
        }
    }
    return 'Unknown shipping status #'.$shipping_status_id;
}

  /**
   * Gibt ein Array der vorhandenen orders_status_id + name zurueck
   * 20.12.10 mario: exclude array eingefuehrt
   *
   * @param Array $exclude_statuses
   * @return array
   */
function xtc_get_orders_status($exclude_statuses = array()) {
    global $InstanceCache;
    $lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
    $excl = implode('_',$exclude_statuses);
    $key = 'orders_status_id_text_values_'.$lang_id.'_'.$excl;
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        $orders_status_array = array();
        $orders_status_query = xtc_db_query(sprintf(
            "select orders_status_id, orders_status_name from %s where language_id = '%d' order by orders_status_id",
            TABLE_ORDERS_STATUS, $lang_id
        ));
        while ($orders_status = xtc_db_fetch_array($orders_status_query)) {
            if(!in_array($orders_status['orders_status_id'],$exclude_statuses)){
                $orders_status_array[] = array(
                    'id' => $orders_status['orders_status_id'],
                    'text' => $orders_status['orders_status_name']
                );
            }
        }
        $CachedString->set($orders_status_array)->expiresAfter(0)->addTag('admin');//orders_status_id_text_values_*
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $orders_status_array = $CachedString->get();
    }
    return $orders_status_array;
}

    function yes_get_installed_languages(){
        $languages = xtc_get_languages();
        foreach($languages as $lang){
            $lang_array[] = array(
                'id'=>$lang['id'],
                'text'=>$lang['name']
            );
        }
        return $lang_array;
    }
	function yes_cfg_pull_down_installed_languages($languages_id) {
		return xtc_draw_pull_down_menu('configuration_value', yes_get_installed_languages(), $languages_id);
	}

	function yes_get_language_name($languages_id) {
            $languages = \YES4Trade\Model\languages::get_list();
            foreach($languages as $lang){
                if($lang['languages_id'] == $languages_id){
                    return $lang['name'];
                }
            }
            throw new Exception('Invalid Language '.$languages_id);
	}
    function yes_get_tax_classes() {
		$tax_class_array = array();
		$query = xtc_db_query("select tax_class_id, tax_class_title from tax_class order by tax_class_id");
		while ($record = xtc_db_fetch_array($query)) {
			$tax_class_array[] = array('id' => $record['tax_class_id'],
				'text' => $record['tax_class_title']
			);
		}
		return $tax_class_array;
	}
	function yes_cfg_pull_down_tax_classes($tax_class_id) {
		return xtc_draw_pull_down_menu('configuration_value', yes_get_tax_classes(), $tax_class_id);
	}
	function yes_get_tax_class_name($tax_class_id) {
		$query = xtc_db_query("select tax_class_title from tax_class where tax_class_id = '" . $tax_class_id . "'");
		$record = xtc_db_fetch_array($query);
		return $record['tax_class_title'];
	}

    function xtc_get_shipping_status() {
        $shipping_status_array = [];
        $shipping_statuses = \YES4Trade\Model\shipping_status::get_list($_SESSION['languages_id']);
	foreach($shipping_statuses as $shipping_status) {
            $shipping_status_array[] = array(
                'id' => $shipping_status['shipping_status_id'],
		'text' => $shipping_status['shipping_status_name']
            );
	}
	return $shipping_status_array;
    }

  function xtc_get_products_name($product_id, $language_id = 0) {

    if ($language_id == 0) {
      $language_id = $_SESSION['languages_id']??2;
    }
    $product_query = xtc_db_query("select products_name from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['products_name']??'';
  }

  function xtc_get_products_description($product_id, $language_id) {
    $product_query = xtc_db_query("select products_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['products_description'];
  }

  function xtc_get_products_ebay_title($product_id, $language_id) {
    $product_query = xtc_db_query("select ebay_title from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['ebay_title'];
  }

function xtc_get_products_slave_title($product_id, $language_id = ''){
    if($language_id == '') {
        $language_id = $_SESSION['languages_id'];
    }
    $product_query = xtc_db_query("select slave_title from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);
    return $product['slave_title'];
}

  function xtc_get_products_extra_text($product_id, $language_id) {
    $product_query = xtc_db_query("select products_extra_text from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);
    return $product['products_extra_text'];
  }

    function xtc_get_products_short_description($product_id, $language_id) {
    $product_query = xtc_db_query("select products_short_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['products_short_description'];
  }

  function xtc_get_products_meta_title($product_id, $language_id) {
    $product_query = xtc_db_query("select products_meta_title from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['products_meta_title'];
  }

  function xtc_get_products_meta_description($product_id, $language_id) {
    $product_query = xtc_db_query("select products_meta_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['products_meta_description'];
  }

  function xtc_get_products_meta_keywords($product_id, $language_id) {
    $product_query = xtc_db_query("select products_meta_keywords from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['products_meta_keywords'];
  }

  function xtc_get_products_url($product_id, $language_id) {
    $product_query = xtc_db_query("select products_url from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);

    return $product['products_url'];
  }

  ////
  // Return the manufacturers URL in the needed language
  // TABLES: manufacturers_info
  function xtc_get_manufacturer_url($manufacturer_id, $language_id) {
    $manufacturer_query = xtc_db_query("select manufacturers_url from " . TABLE_MANUFACTURERS_INFO . " where manufacturers_id = '" . $manufacturer_id . "' and languages_id = '" . $language_id . "'");
    $manufacturer = xtc_db_fetch_array($manufacturer_query);

    return $manufacturer['manufacturers_url'];
  }

  ////
  // Wrapper for class_exists() function
  // This function is not available in all PHP versions so we test it before using it.
  function xtc_class_exists($class_name) {
    if (function_exists('class_exists')) {
      return class_exists($class_name);
    } else {
      return true;
    }
  }

  ////
  // Count how many products exist in a category
  // TABLES: products, products_to_categories, categories
  function xtc_products_in_category_count($categories_id, $include_deactivated = false) {
    $products_count = 0;
    if ($include_deactivated) {
      $products_query = xtc_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . $categories_id . "'");
    } else {
      $products_query = xtc_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id = '" . $categories_id . "'");
    }

    $products = xtc_db_fetch_array($products_query);

    $products_count += $products['total'];

    $childs_query = xtc_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . $categories_id . "'");
    if (xtc_db_num_rows($childs_query)) {
      while ($childs = xtc_db_fetch_array($childs_query)) {
        $products_count += xtc_products_in_category_count($childs['categories_id'], $include_deactivated);
      }
    }

    return $products_count;
  }

  ////
  // Count how many subcategories exist in a category
  // TABLES: categories
  function xtc_childs_in_category_count($categories_id) {
    $categories_count = 0;

    $categories_query = xtc_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . $categories_id . "'");
    while ($categories = xtc_db_fetch_array($categories_query)) {
      $categories_count++;
      $categories_count += xtc_childs_in_category_count($categories['categories_id']);
    }

    return $categories_count;
  }

  ////
  // Returns an array with countries
  // TABLES: countries
  function xtc_get_countries($default = '',$utf8 = false) {
    $countries_array = array();
    if ($default) {
      $countries_array[] = array('id' => constant('STORE_COUNTRY'),
                                 'text' => $default);
    }
    $countries_query = xtc_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " order by countries_name");
    while ($countries = xtc_db_fetch_array($countries_query)) {
		if($utf8){
			$countries['countries_name'] = yes_encode_string($countries['countries_name']);
		}
      $countries_array[] = array('id' => $countries['countries_id'],
                                 'text' => $countries['countries_name']);
    }

    return $countries_array;
  }

  ////
  // return an array with country zones
  function xtc_get_country_zones($country_id) {
    $zones_array = array();
    $zones_query = xtc_db_query("select zone_id, zone_name from " . TABLE_ZONES . " where zone_country_id = '" . $country_id . "' order by zone_name");
    while ($zones = xtc_db_fetch_array($zones_query)) {
      $zones_array[] = array('id' => $zones['zone_id'],
                             'text' => $zones['zone_name']);
    }

    return $zones_array;
  }

  function xtc_prepare_country_zones_pull_down($country_id = '') {
    // preset the width of the drop-down for Netscape
    $pre = '';
    if ( (!xtc_browser_detect('MSIE')) && (xtc_browser_detect('Mozilla/4')) ) {
      for ($i=0; $i<45; $i++) $pre .= '&nbsp;';
    }

    $zones = xtc_get_country_zones($country_id);

    if (sizeof($zones) > 0) {
      $zones_select = array(array('id' => '', 'text' => PLEASE_SELECT));
      $zones = xtc_array_merge($zones_select, $zones);
    } else {
      $zones = array(array('id' => '', 'text' => TYPE_BELOW));
      // create dummy options for Netscape to preset the height of the drop-down
      if ( (!xtc_browser_detect('MSIE')) && (xtc_browser_detect('Mozilla/4')) ) {
        for ($i=0; $i<9; $i++) {
          $zones[] = array('id' => '', 'text' => $pre);
        }
      }
    }

    return $zones;
  }

  ////
  // Get list of address_format_id's
  function xtc_get_address_formats() {
    $address_format_query = xtc_db_query("select address_format_id from " . TABLE_ADDRESS_FORMAT . " order by address_format_id");
    $address_format_array = array();
    while ($address_format_values = xtc_db_fetch_array($address_format_query)) {
      $address_format_array[] = array('id' => $address_format_values['address_format_id'],
                                      'text' => $address_format_values['address_format_id']);
    }
    return $address_format_array;
  }

  ////
  // Alias function for Store configuration values in the Administration Tool
  function xtc_cfg_pull_down_country_list($country_id) {
    return xtc_draw_pull_down_menu('configuration_value', xtc_get_countries(), $country_id);
  }

  function xtc_cfg_pull_down_zone_list($zone_id) {
    return xtc_draw_pull_down_menu('configuration_value', xtc_get_country_zones(constant('STORE_COUNTRY')), $zone_id);
  }

  function xtc_cfg_pull_down_tax_classes($tax_class_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $tax_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $tax_class_query = xtc_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
    while ($tax_class = xtc_db_fetch_array($tax_class_query)) {
      $tax_class_array[] = array('id' => $tax_class['tax_class_id'],
                                 'text' => $tax_class['tax_class_title']);
    }

    return xtc_draw_pull_down_menu($name, $tax_class_array, $tax_class_id);
  }

  ////
  // Function to read in text area in admin
 function xtc_cfg_textarea($text) {
    return xtc_draw_textarea_field('configuration_value', false, 35, 5, $text);
  }

  function xtc_cfg_get_zone_name($zone_id) {
    $zone_query = xtc_db_query("select zone_name from " . TABLE_ZONES . " where zone_id = '" . $zone_id . "'");

    if (!xtc_db_num_rows($zone_query)) {
      return $zone_id;
    } else {
      $zone = xtc_db_fetch_array($zone_query);
      return $zone['zone_name'];
    }
  }

  ////
  // Sets the status of a banner
  function xtc_set_banner_status($banners_id, $status) {
    if ($status == '1') {
      return xtc_db_query("update " . TABLE_BANNERS . " set status = '1', expires_impressions = NULL, expires_date = NULL, date_status_change = NULL where banners_id = '" . $banners_id . "'");
    } elseif ($status == '0') {
      return xtc_db_query("update " . TABLE_BANNERS . " set status = '0', date_status_change = now() where banners_id = '" . $banners_id . "'");
    } else {
      return -1;
    }
  }

  ////
  // Sets the status of a product
  function xtc_set_product_status($products_id, $status) {
    if ($status == '1') {
      return xtc_db_query("update " . TABLE_PRODUCTS . " set products_status = '1', products_last_modified = now() where products_id = '" . $products_id . "'");
    } elseif ($status == '0') {
      return xtc_db_query("update " . TABLE_PRODUCTS . " set products_status = '0', products_last_modified = now() where products_id = '" . $products_id . "'");
    } else {
      return -1;
    }
  }

  ////
  // Sets timeout for the current script.
  // Cant be used in safe mode.
  function xtc_set_time_limit($limit) {
    if (!get_cfg_var('safe_mode')) {
      @set_time_limit($limit);
    }
  }

  ////
  // Alias function for Store configuration values in the Administration Tool
  function xtc_cfg_select_option($select_array, $key_value, $key = '') {
	  $string = '';
    for ($i = 0, $n = sizeof($select_array); $i < $n; $i++) {
      $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
      $string .= '<br><input type="radio" name="' . $name . '" value="' . $select_array[$i] . '"';
      if ($key_value == $select_array[$i]) $string .= ' CHECKED';
      $string .= '> ' . $select_array[$i];
    }

    return $string;
  }

  function xtc_cfg_select_date($src,$key_value,$key=''){
	  switch($src){
		  case 'modules':
			  $form_name = $src;
			  break;
		  default:
			  die( 'Unbekannter SRC Parameter bei xtc_cfg_select_date' );
			  break;
	  }
      $name = (($key) ? $key : 'configuration_value');
      $js_name = $key;
	  $js = '<script language="javascript">'."\r\n".
		'var '.$js_name.' = new ctlSpiffyCalendarBox("'.$js_name.'", "'.$form_name.'", "'.$name.'","btnDate1","'.$key_value.'",scBTNMODE_CUSTOMBLUE);'."\r\n".
		$js_name.'.writeControl(); '."\r\n".
		$js_name.'.dateFormat="yyyy-MM-dd";'."\r\n".
		'</script>';
	  return $js;
  }

  ////
  // Alias function for module configuration keys
function xtc_mod_select_option($select_array, $key_name, $key_value) {
    reset($select_array);
    $string = '';
    foreach($select_array as $key => $value) {
      if (is_int($key)) {
        $key = $value;
      }
      $string .= '<br><input type="radio" name="configuration[' . $key_name . ']" value="' . $key . '"';
      if ($key_value == $key) {
        $string .= ' CHECKED';
      }
      $string .= '> ' . $value;
    }
    return $string;
}

  function xtc_array_shift(&$array) {
    if (function_exists('array_shift')) {
      return array_shift($array);
    } else {
      $i = 0;
      $shifted_array = array();
      reset($array);
      foreach($array as $key => $value) {
        if ($i > 0) {
          $shifted_array[$key] = $value;
        } else {
          $return = $array[$key];
        }
        $i++;
      }
      $array = $shifted_array;

      return $return;
    }
  }

  function xtc_array_reverse($array) {
    if (function_exists('array_reverse')) {
      return array_reverse($array);
    } else {
      $reversed_array = array();
      for ($i=sizeof($array)-1; $i>=0; $i--) {
        $reversed_array[] = $array[$i];
      }
      return $reversed_array;
    }
  }

  function xtc_generate_category_path($id, $from = 'category', $categories_array = '', $index = 0) {

    if (!is_array($categories_array)) $categories_array = array();

    if ($from == 'product') {
      $categories_query = xtc_db_query("select categories_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . $id . "'");
      while ($categories = xtc_db_fetch_array($categories_query)) {
        if ($categories['categories_id'] == '0') {
          $categories_array[$index][] = array('id' => '0', 'text' => TEXT_TOP);
        } else {
          $category_query = xtc_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . $categories['categories_id'] . "' and c.categories_id = cd.categories_id and cd.language_id = '" . $_SESSION['languages_id'] . "'");
          $category = xtc_db_fetch_array($category_query);
          $categories_array[$index][] = array('id' => $categories['categories_id'], 'text' => $category['categories_name']);
          if ( (xtc_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = xtc_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
          $categories_array[$index] = xtc_array_reverse($categories_array[$index]);
        }
        $index++;
      }
    } elseif ($from == 'category') {
      $category_query = xtc_db_query("select cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . $id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . $_SESSION['languages_id'] . "'");
      $category = xtc_db_fetch_array($category_query);
      $categories_array[$index][] = array('id' => $id, 'text' => $category['categories_name']);
      if ( (xtc_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = xtc_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
    }

    return $categories_array;
  }

  function xtc_output_generated_category_path($id, $from = 'category',$links = false) {
    $calculated_category_path_string = '';
    $calculated_category_path = xtc_generate_category_path($id, $from);
    for ($i = 0, $n = sizeof($calculated_category_path); $i < $n; $i++) {
      for ($j = 0, $k = sizeof($calculated_category_path[$i]); $j < $k; $j++) {
	if(!$links)
	        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
	else
	        $calculated_category_path_string .= '<a style="font-size:14px; font-family: arial,helvetica,sans-serif;color:#000000;" href="'.xtc_href_link(FILENAME_CATEGORIES,'cPath='.$calculated_category_path[$i][$j]['id']).'" title="'.str_replace('"',' ',$calculated_category_path[$i][$j]['text']).'" />'.$calculated_category_path[$i][$j]['text'] . '</a>&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);

    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;

    return $calculated_category_path_string;
  }

  function xtc_remove_category($category_id) {
    $category_image_query = xtc_db_query("select categories_image from " . TABLE_CATEGORIES . " where categories_id = '" . xtc_db_input($category_id) . "'");
    $category_image = xtc_db_fetch_array($category_image_query);

    $duplicate_image_query = xtc_db_query("select count(*) as total from " . TABLE_CATEGORIES . " where categories_image = '" . xtc_db_input($category_image['categories_image']) . "'");
    $duplicate_image = xtc_db_fetch_array($duplicate_image_query);

    if ($duplicate_image['total'] < 2) {
        if (file_exists(DIR_FS_CATALOG_IMAGES . 'categories/' . $category_image['categories_image'])) {
            @unlink(DIR_FS_CATALOG_IMAGES . 'categories/' . $category_image['categories_image']);
        }
    }

    // BOF - default_category
    xtc_db_query(sprintf(
            "UPDATE %s SET default_category=0 where default_category = '%d'",
            TABLE_PRODUCTS,xtc_db_input($category_id)
    ));
    // EOF - default_category
    
    \YES4Trade\Model\category::delete((int)$category_id);
    if (constant('USE_CACHE') == 'true') {
      xtc_reset_cache_block('categories');
      xtc_reset_cache_block('also_purchased');
    }
  }

  //deletes all product image files by filename
  function xtc_del_image_file($image) {
      if (file_exists(DIR_FS_CATALOG_POPUP_IMAGES . $image)) {
        @unlink(DIR_FS_CATALOG_POPUP_IMAGES . $image);
      }
      if (file_exists(DIR_FS_CATALOG_ORIGINAL_IMAGES . $image)) {
        @unlink(DIR_FS_CATALOG_ORIGINAL_IMAGES . $image);
      }
      if (file_exists(DIR_FS_CATALOG_THUMBNAIL_IMAGES . $image)) {
        @unlink(DIR_FS_CATALOG_THUMBNAIL_IMAGES . $image);
      }
      if (file_exists(DIR_FS_CATALOG_INFO_IMAGES . $image)) {
        @unlink(DIR_FS_CATALOG_INFO_IMAGES . $image);
      }
      if (file_exists(DIR_FS_CATALOG_EBAYCATEGORY_IMAGES . $image)) {
        @unlink(DIR_FS_CATALOG_EBAYCATEGORY_IMAGES . $image);
      }
  }

function mc_float()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}
function _lz($process,$action){
	global $lz;
	if(!isset($lz[$process])){
		$lz[$process] = array(
			'total'=>0,
			'start'=>0
		);
	}
	switch($action){
		case 0:
			$lz[$process]['start'] = mc_float();
			break;
		case 1:
			$lz[$process]['total'] += (mc_float() - $lz[$process]['start']);
			break;
	}
}
function xtc_remove_product($product_id) {
    $EBAYAPI = new ebayAPI;
    $product = new product($product_id);
    $statuses = xtc_get_customers_statuses();
    $product->delete($statuses);
  }

  function xtc_remove_order($order_id, $restock = false) {
    if ($restock == 'on') {
      $order_query = xtc_db_query("select products_id, products_quantity from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . xtc_db_input($order_id) . "'");
      while ($order = xtc_db_fetch_array($order_query)) {
        xtc_db_query("update " . TABLE_PRODUCTS . " set products_quantity = products_quantity + " . $order['products_quantity'] . ", products_ordered = products_ordered - " . $order['products_quantity'] . " where products_id = '" . $order['products_id'] . "'");
        // yes bestand
        xtc_db_query("INSERT INTO history_bestand SET products_id='".$order['products_id']."',orders_id='".$order_id."',quantity_change='".$order['products_quantity']."',title='Bestellung geloescht, Gutschrift.'");
      }
    }

    xtc_db_query("delete from " . TABLE_ORDERS . " where orders_id = '" . xtc_db_input($order_id) . "'");
    xtc_db_query("delete from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . xtc_db_input($order_id) . "'");
    xtc_db_query("delete from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '" . xtc_db_input($order_id) . "'");
    xtc_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . xtc_db_input($order_id) . "'");

  }

  function xtc_reset_cache_block($cache_block) {
    global $cache_blocks;

    for ($i = 0, $n = sizeof($cache_blocks); $i < $n; $i++) {
      if ($cache_blocks[$i]['code'] == $cache_block) {
        if ($cache_blocks[$i]['multiple']) {
          if ($dir = @opendir(constant('DIR_FS_CACHE'))) {
            while ($cache_file = readdir($dir)) {
              $cached_file = $cache_blocks[$i]['file'];
              $languages = xtc_get_languages();
              for ($j = 0, $k = sizeof($languages); $j < $k; $j++) {
                $cached_file_unlink = ereg_replace('-language', '-' . $languages[$j]['directory'], $cached_file);
                if (ereg('^' . $cached_file_unlink, $cache_file)) {
                  @unlink(constant('DIR_FS_CACHE') . $cache_file);
                }
              }
            }
            closedir($dir);
          }
        } else {
          $cached_file = $cache_blocks[$i]['file'];
          $languages = xtc_get_languages();
          for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $cached_file = ereg_replace('-language', '-' . $languages[$i]['directory'], $cached_file);
            @unlink(constant('DIR_FS_CACHE') . $cached_file);
          }
        }
        break;
      }
    }
  }

  function xtc_get_file_permissions($mode) {
    // determine type
    if ( ($mode & 0xC000) == 0xC000) { // unix domain socket
      $type = 's';
    } elseif ( ($mode & 0x4000) == 0x4000) { // directory
      $type = 'd';
    } elseif ( ($mode & 0xA000) == 0xA000) { // symbolic link
      $type = 'l';
    } elseif ( ($mode & 0x8000) == 0x8000) { // regular file
      $type = '-';
    } elseif ( ($mode & 0x6000) == 0x6000) { //bBlock special file
      $type = 'b';
    } elseif ( ($mode & 0x2000) == 0x2000) { // character special file
      $type = 'c';
    } elseif ( ($mode & 0x1000) == 0x1000) { // named pipe
      $type = 'p';
    } else { // unknown
      $type = '?';
    }

    // determine permissions
    $owner['read']    = ($mode & 00400) ? 'r' : '-';
    $owner['write']   = ($mode & 00200) ? 'w' : '-';
    $owner['execute'] = ($mode & 00100) ? 'x' : '-';
    $group['read']    = ($mode & 00040) ? 'r' : '-';
    $group['write']   = ($mode & 00020) ? 'w' : '-';
    $group['execute'] = ($mode & 00010) ? 'x' : '-';
    $world['read']    = ($mode & 00004) ? 'r' : '-';
    $world['write']   = ($mode & 00002) ? 'w' : '-';
    $world['execute'] = ($mode & 00001) ? 'x' : '-';

    // adjust for SUID, SGID and sticky bit
    if ($mode & 0x800 ) $owner['execute'] = ($owner['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x400 ) $group['execute'] = ($group['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x200 ) $world['execute'] = ($world['execute'] == 'x') ? 't' : 'T';

    return $type .
           $owner['read'] . $owner['write'] . $owner['execute'] .
           $group['read'] . $group['write'] . $group['execute'] .
           $world['read'] . $world['write'] . $world['execute'];
  }

  function xtc_array_slice($array, $offset, $length = '0') {
    if (function_exists('array_slice')) {
      return array_slice($array, $offset, $length);
    } else {
      $length = abs($length);
      if ($length == 0) {
        $high = sizeof($array);
      } else {
        $high = $offset+$length;
      }

      for ($i=$offset; $i<$high; $i++) {
        $new_array[$i-$offset] = $array[$i];
      }

      return $new_array;
    }
  }

  function xtc_remove($source) {
    global $messageStack, $xtc_remove_error;

    if (isset($xtc_remove_error)) $xtc_remove_error = false;

    if (is_dir($source)) {
      $dir = dir($source);
      while ($file = $dir->read()) {
        if ( ($file != '.') && ($file != '..') ) {
          if (is_writeable($source . '/' . $file)) {
            xtc_remove($source . '/' . $file);
          } else {
            $messageStack->add(sprintf(ERROR_FILE_NOT_REMOVEABLE, $source . '/' . $file), 'error');
            $xtc_remove_error = true;
          }
        }
      }
      $dir->close();

      if (is_writeable($source)) {
        rmdir($source);
      } else {
        $messageStack->add(sprintf(ERROR_DIRECTORY_NOT_REMOVEABLE, $source), 'error');
        $xtc_remove_error = true;
      }
    } else {
      if (is_writeable($source)) {
        unlink($source);
      } else {
        $messageStack->add(sprintf(ERROR_FILE_NOT_REMOVEABLE, $source), 'error');
        $xtc_remove_error = true;
      }
    }
  }

  ////
  // Wrapper for constant() function
  // Needed because its only available in PHP 4.0.4 and higher.
  function xtc_constant($constant) {
    if (function_exists('constant')) {
      $temp = constant($constant);
    } else {
      eval("\$temp=$constant;");
    }
    return $temp;
  }

  ////
  // Output the tax percentage with optional padded decimals
  function xtc_display_tax_value($value, $padding = 2) {
    if (strpos($value, '.')) {
      $loop = true;
      while ($loop) {
        if (substr($value, -1) == '0') {
          $value = substr($value, 0, -1);
        } else {
          $loop = false;
          if (substr($value, -1) == '.') {
            $value = substr($value, 0, -1);
          }
        }
      }
    }

    if ($padding > 0) {
      if ($decimal_pos = strpos($value, '.')) {
        $decimals = strlen(substr($value, ($decimal_pos+1)));
        for ($i=$decimals; $i<$padding; $i++) {
          $value .= '0';
        }
      } else {
        $value .= '.';
        for ($i=0; $i<$padding; $i++) {
          $value .= '0';
        }
      }
    }

    return $value;
  }



  function xtc_get_tax_class_title($tax_class_id) {
    if ($tax_class_id == '0') {
      return TEXT_NONE;
    } else {
      $classes_query = xtc_db_query("select tax_class_title from " . TABLE_TAX_CLASS . " where tax_class_id = '" . $tax_class_id . "'");
      $classes = xtc_db_fetch_array($classes_query);

      return $classes['tax_class_title'];
    }
  }

  function xtc_banner_image_extension() {
    if (function_exists('imagetypes')) {
      if (imagetypes() & IMG_PNG) {
        return 'png';
      } elseif (imagetypes() & IMG_JPG) {
        return 'jpg';
      } elseif (imagetypes() & IMG_GIF) {
        return 'gif';
      }
    } elseif (function_exists('imagecreatefrompng') && function_exists('imagepng')) {
      return 'png';
    } elseif (function_exists('imagecreatefromjpeg') && function_exists('imagejpeg')) {
      return 'jpg';
    } elseif (function_exists('imagecreatefromgif') && function_exists('imagegif')) {
      return 'gif';
    }

    return false;
  }

  ////
  // Wrapper function for round()
  function xtc_round($value, $precision) {
      return round((float)$value, $precision);
  }

  ////
  // Add tax to a products price
  /*
  function xtc_add_tax($price, $tax) {
    global $currencies;

    if (DISPLAY_PRICE_WITH_TAX == 'true') {
      return xtc_round($price, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']) + xtc_calculate_tax($price, $tax);
    } else {
      return xtc_round($price, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']);
    }
  }
*/
  // Calculates Tax rounding the result
  function xtc_calculate_tax($price, $tax) {
    global $currencies;

    return xtc_round($price * $tax / 100, $currencies->currencies[constant('DEFAULT_CURRENCY')]['decimal_places']);
  }

  function xtc_call_function($function, $parameter, $object = '') {
    if ($object == '') {
      return call_user_func($function, $parameter);
    } else {
      return call_user_func(array($object, $function), $parameter);
    }
  }

function xtc_get_zone_class_title($zone_class_id) {
    if (intval($zone_class_id) == 0) {
      return TEXT_NONE;
    }
    return xtc_get_geo_zone_name(intval($zone_class_id));
}

function xtc_cfg_pull_down_template_sets() {
  $name = ((isset($key)) ? 'configuration[' . $key . ']' : 'configuration_value');
  if ($dir= opendir(constant('DIR_FS_CATALOG').'templates/')){
  while  (($templates = readdir($dir)) !==false) {
        if (is_dir( constant('DIR_FS_CATALOG').'templates/'."//".$templates) and ($templates !="CVS") and ($templates!=".") and ($templates !="..")) {
        $templates_array[]=array(
                        'id' => $templates,
                        'text' => $templates);
        }
        }
        closedir($dir);
        sort($templates_array);
 return xtc_draw_pull_down_menu($name, $templates_array, 0);
 }
}

function xtc_cfg_pull_down_zone_classes($zone_class_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $zone_class_top = array(array('id' => '0', 'text' => TEXT_NONE));
    $zone_class_array = array_merge($zone_class_top,
        \YES4Trade\Model\geo_zones::get_id_text_list()
    );
    return xtc_draw_pull_down_menu($name, $zone_class_array, $zone_class_id);
}

  function xtc_cfg_pull_down_order_statuses($order_status_id, $key = '') {

    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');

    $statuses_array = array(array('id' => '0', 'text' => TEXT_DEFAULT));
    $statuses = xtc_get_orders_status([]);
    return xtc_draw_pull_down_menu($name, $statuses, $order_status_id);
  }

  function xtc_get_order_status_name($order_status_id, $language_id = '') {
    if ($order_status_id < 1) {
        return TEXT_DEFAULT;
    }
    if (!is_numeric($language_id)) {
        $language_id = $_SESSION['languages_id'];
    }
    return main::get_orders_status_name($order_status_id, $language_id);
  }

  ////
  // Return a random value
  function xtc_rand($min = null, $max = null) {
    static $seeded;

    if (!$seeded) {
      mt_srand((double)microtime()*1000000);
      $seeded = true;
    }

    if (isset($min) && isset($max)) {
      if ($min >= $max) {
        return $min;
      } else {
        return mt_rand($min, $max);
      }
    } else {
      return mt_rand();
    }
  }

  // nl2br() prior PHP 4.2.0 did not convert linefeeds on all OSs (it only converted \n)
  function xtc_convert_linefeeds($from, $to, $string) {
    if ((PHP_VERSION < "4.0.5") && is_array($from)) {
      return ereg_replace('(' . implode('|', $from) . ')', $to, $string);
    } else {
      return str_replace($from, $to, $string);
    }
  }

  // Return all customers statuses for a specified language_id and return an array(array())
  // Use it to make pull_down_menu, checkbox....
  function xtc_get_customers_statuses( int $language_id = 0) {
    global $InstanceCache;
    if($language_id > 0){
        $lang_id = $language_id;
    }else{
        $lang_id = $_SESSION['languages_id']??2;
    }
    $key = 'admin_customers_statuses_'.$lang_id;
    $customers_statuses_array = [];
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
      $customers_statuses = \YES4Trade\Model\customers_status::get_by_language_id(intval($lang_id));
      foreach($customers_statuses as $customers_status) {
        $customers_statuses = $customers_status->toArray();
        $customers_statuses_array[] = array(
            'id' => $customers_statuses['customers_status_id'],
            'text' => $customers_statuses['customers_status_name'],
            'csa_public' => $customers_statuses['customers_status_public'],
            'csa_image' => $customers_statuses['customers_status_image']??'',
            'customers_status_image' => $customers_statuses['customers_status_image']??'',
            'csa_discount' => $customers_statuses['customers_status_discount'],
            'csa_ot_discount_flag' => $customers_statuses['customers_status_ot_discount_flag'],
            'csa_ot_discount' => $customers_statuses['customers_status_ot_discount'],
            'csa_graduated_prices' => $customers_statuses['customers_status_graduated_prices'],
            'customers_status_payment_unallowed'=>$customers_statuses['customers_status_payment_unallowed'],
            // weil ein paar Funktionen altes Handling verwenden
            'customers_status_id' => $customers_statuses['customers_status_id'],
            'customers_status_name' => $customers_statuses['customers_status_name'],
            'customers_status_description' => $customers_statuses['customers_status_description']??'',

            'csa_public' => $customers_statuses['customers_status_public'],
            'csa_show_price' => $customers_statuses['customers_status_show_price'],
            'csa_show_price_tax' => $customers_statuses['customers_status_show_price_tax'],
            'csa_add_tax_ot' => $customers_statuses['customers_status_add_tax_ot'],
            'csa_payment_unallowed' => $customers_statuses['customers_status_payment_unallowed'],
            'csa_shipping_unallowed' => $customers_statuses['customers_status_shipping_unallowed'],
            'csa_discount_attributes' => $customers_statuses['customers_status_discount_attributes'],
            'customers_fsk18' => $customers_statuses['customers_fsk18'],
            'customers_fsk18_display' => $customers_statuses['customers_fsk18_display']
        );
      }
      $CachedString->set($customers_statuses_array)->expiresAfter(0)->addTags(['admin']);//admin_customers_statuses_*
      $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
      return $customers_statuses_array;
    }else{
      return $CachedString->get();// Will print 'First product'
    }
  }


  function xtc_get_customer_status($customers_id) {
    $customer_status_query = xtc_db_query("select customers_status, member_flag, customers_status_name, customers_status_public, customers_status_image, customers_status_discount, customers_status_ot_discount_flag, customers_status_ot_discount, customers_status_graduated_prices,customers_status_payment_unallowed  FROM " . TABLE_CUSTOMERS . " left join " . TABLE_CUSTOMERS_STATUS . " on customers_status = customers_status_id where customers_id='" . $customers_id . "' and language_id = '" . $_SESSION['languages_id'] . "'");
    $customer_status_array = xtc_db_fetch_array($customer_status_query);
    return $customer_status_array;
  }

   function xtc_get_customers_status_name($customers_status_id, $language_id = '') {
     if ($language_id == '') {
         $language_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
     }
     $customers_status = main::get_customers_status($customers_status_id, $language_id);
     return $customers_status['customers_status_name'];
   }

   function xtc_get_customers_status_delivery_conditions($customers_status_id, $language_id = ''){
     if (empty($language_id)) {
         $language_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
     }
     $customers_status = main::get_customers_status($customers_status_id, $language_id);
     return $customers_status['customers_status_delivery_conditions'];
   }

  //to set customers status in admin for default value, newsletter, guest...
  function xtc_cfg_pull_down_customers_status_list($customers_status_id, $key = '') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $cs_array = xtc_get_customers_statuses();
    return xtc_draw_pull_down_menu($name, $cs_array, $customers_status_id);
  }

  // Function for collecting ip
  // return all log info for a customer_id
  function xtc_get_user_info($customer_id) {
    $user_info_array = xtc_db_query("select customers_ip, customers_ip_date, customers_host, customers_advertiser, customers_referer_url FROM " . TABLE_CUSTOMERS_IP . " where customers_id = '" . $customer_id . "'");
    return $user_info_array;
  }

  //---------------------------------------------------------------kommt wieder raus sp�ter!!
  function xtc_get_uploaded_file($filename) {
    if (isset($_FILES[$filename])) {
      $uploaded_file = array('name' => $_FILES[$filename]['name'],
                             'type' => $_FILES[$filename]['type'],
                             'size' => $_FILES[$filename]['size'],
                             'tmp_name' => $_FILES[$filename]['tmp_name']);
    } elseif (isset($_FILES[$filename])) {
      $uploaded_file = array('name' => $_FILES[$filename]['name'],
                             'type' => $_FILES[$filename]['type'],
                             'size' => $_FILES[$filename]['size'],
                             'tmp_name' => $_FILES[$filename]['tmp_name']);
    } else {
      $uploaded_file = array('name' => $GLOBALS[$filename . '_name'],
                             'type' => $GLOBALS[$filename . '_type'],
                             'size' => $GLOBALS[$filename . '_size'],
                             'tmp_name' => $GLOBALS[$filename]);
    }

    return $uploaded_file;
  }

function format_price($price_string, $price_special, $currency, $allow_tax, $tax_rate) {
    // calculate currencies
    $currencies_value = xtc_get_currencies_values((string) $currency);
    $currencies_data = array(
      'SYMBOL_LEFT' => $currencies_value['symbol_left'],
      'SYMBOL_RIGHT' => $currencies_value['symbol_right'],
      'DECIMAL_PLACES' => $currencies_value['decimal_places'],
      'VALUE' => $currencies_value['value']);

    // round price
    if ($allow_tax == 1) {
        $price_string = $price_string/((100+$tax_rate)/100);
    }
    $price_string = precision($price_string, $currencies_data['DECIMAL_PLACES']);
    if ($price_special == '1') {
      $price_string = $currencies_data['SYMBOL_LEFT'] . ' ' . $price_string . ' ' . $currencies_data['SYMBOL_RIGHT'];
    }
    return $price_string;
}

  function precision($number, $places) {
    $number = number_format($number, $places, '.', '');
    return $number;
  }

  function xtc_get_lang_definition($search_lang, $lang_array, $modifier) {
    $search_lang=$search_lang.$modifier;
    return $lang_array[$search_lang];
  }

  function xtc_CheckExt($filename, $ext) {
    $passed = FALSE;
    $testExt = "\.".$ext."$";
    if (eregi($testExt, $filename)) {
      $passed = TRUE;
    }
    return $passed;
  }

  function xtc_get_status_users($status_id) {
    $status_query = xtc_db_query("SELECT count(customers_status) as count FROM " . TABLE_CUSTOMERS . " WHERE customers_status = '" . $status_id . "'");
    $status_data = xtc_db_fetch_array($status_query);
    return $status_data['count'];
  }
  function xtc_mkdirs($path,$perm) {

  if (is_dir($path)) {
  return true;
 } else {

  //$path=dirname($path);
  if (!mkdir($path,$perm)) return false;
  mkdir($path,$perm);
  return true;
}
}

function xtc_spaceUsed($dir) {
	if(!isset($GLOBALS['total'])) $GLOBALS['total'] = 0;
	if(is_dir($dir)) {
		if ($dh=opendir($dir)){
			while (($file=readdir($dh)) !==false) {
				if (is_dir($dir.$file) && $file !='.' && $file != '..') {
					xtc_spaceUsed($dir.$file.'/');
				}else{
					$GLOBALS['total']+=filesize($dir.$file);
				}
			}
			closedir($dh);
		}
	}
}

  function create_coupon_code($salt="secret", $length=SECURITY_CODE_LENGTH) {
    $ccid = md5(uniqid("","salt"));
    $ccid .= md5(uniqid("","salt"));
    $ccid .= md5(uniqid("","salt"));
    $ccid .= md5(uniqid("","salt"));
    srand((double)microtime()*1000000); // seed the random number generator
    $random_start = @rand(0, (128-$length));
    $good_result = 0;
    while ($good_result == 0) {
        $id1=substr($ccid, $random_start,$length);
        $coupon = \YES4Trade\Model\coupons::get_by_coupon_code($id1,[
            'coupon_code'
        ]);
        if ($coupon === null) {
            $good_result = 1;
        }
    }
    return $id1;
  }

  // Update the Customers GV account
function xtc_gv_account_update($customer_id, $gv_id) {
    $coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($gv_id),[
        'coupon_amount'
    ]);
    if($coupon === null){
        throw new Exception('invalid coupon id @xtc_gv_account_update()');
    }
    $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id(intval($customer_id));
    if ($gvc !== null) {
        $new_gv_amount = (float)$gvc->amount + (float)$coupon->coupon_amount;
        $upd = new \YES4Trade\Model\coupon_gv_customer([
            'amount' => $new_gv_amount,
            'customer_id' => intval($customer_id)
        ]);
        $upd->update();
    } else {
        $new = new \YES4Trade\Model\coupon_gv_customer([
            'customer_id'=>intval($customer_id), 
            'amount' => (float)$coupon->coupon_amount
        ]);
        $new->create();
    }
}

  // Output a day/month/year dropdown selector
  function xtc_draw_date_selector($prefix, $date='') {
    $month_array = array();
    $month_array[1] =_JANUARY;
    $month_array[2] =_FEBRUARY;
    $month_array[3] =_MARCH;
    $month_array[4] =_APRIL;
    $month_array[5] =_MAY;
    $month_array[6] =_JUNE;
    $month_array[7] =_JULY;
    $month_array[8] =_AUGUST;
    $month_array[9] =_SEPTEMBER;
    $month_array[10] =_OCTOBER;
    $month_array[11] =_NOVEMBER;
    $month_array[12] =_DECEMBER;
    $usedate = getdate(strtotime($date));
    $day = $usedate['mday'];
    $month = $usedate['mon'];
    $year = $usedate['year'];
    $date_selector = '<select name="'. $prefix .'_day">';
    for ($i=1;$i<32;$i++){
      $date_selector .= '<option value="' . $i . '"';
      if ($i==$day) $date_selector .= 'selected';
      $date_selector .= '>' . $i . '</option>';
    }
    $date_selector .= '</select>';
    $date_selector .= '<select name="'. $prefix .'_month">';
    for ($i=1;$i<13;$i++){
      $date_selector .= '<option value="' . $i . '"';
      if ($i==$month) $date_selector .= 'selected';
      $date_selector .= '>' . $month_array[$i] . '</option>';
    }
    $date_selector .= '</select>';
    $date_selector .= '<select name="'. $prefix .'_year">';
    for ($i=2010;$i<2030;$i++){
      $date_selector .= '<option value="' . $i . '"';
      if ($i==$year) $date_selector .= 'selected';
      $date_selector .= '>' . $i . '</option>';
    }
    $date_selector .= '</select>';
    return $date_selector;
  }

  function xtc_getDownloads() {

  $files=array();

  $dir=DIR_FS_CATALOG.'download/';
  if ($fp=opendir($dir)) {
  while  ($file = readdir($fp)) {
        if (is_file($dir.$file) && $file!='.htaccess'){
         $size=filesize($dir.$file);
        $files[]=array(
                        'id' => $file,
                        'text' => $file.' | '.xtc_format_filesize($size),
                        'size'=>$size,
                        'date'=>date ("F d Y H:i:s.", filemtime($dir.$file)));
        }//if
        } // while
        closedir($fp);
  }
  return $files;
  }

function xtc_try_upload($file = '', $destination = '', $permissions = '755', $extensions = ''){
    //printf('file: %s, destin: %s, perm: %s,ext: %s', $file, $destination, $permissions, $extensions);
    $file_object = new upload($file, $destination, $permissions, $extensions);
    if ($file_object->filename != '') return $file_object; else return false;
}

  function yes_try_upload($file = '', $destination = '', $permissions = '755', $extensions = '',$target_name = ''){
  	$file_object = new upload;
	$file_object->upload_name($file, $destination, $permissions, $extensions,$target_name);
  	if ($file_object->filename != '') return $file_object; else return false;
  }

  
  
  
  
  
  
  
  
  
  // MASTER/SLAVE
// Master Products
  function xtc_get_products_master_status($product_id) {

    $product_query = xtc_db_query("select products_master_status from " . TABLE_PRODUCTS . " where products_id = '" . (int)$product_id . "'");
    $product = xtc_db_fetch_array($product_query);
    return $product['products_master_status'];
  }  

  function xtc_get_available_ebay_payments( $ebay_category_id ){
        $EBAYAPI = new ebayApi;
        $sandbox = (defined('EBAY_TESTMODE') and constant('EBAY_TESTMODE') == '1') ? true : false;
        if($sandbox){
          $array = [
            ['id'=>'MOCC','text'=>'MOCC (sandbox)']
          ];
        }else{
          $array = [];
        }
          $ebaycalls = new \YES4Trade\Model\ebaycalls();
          $res = $ebaycalls->tradingQuery(constant('EBAY_USER'),
            'GetCategoryFeatures',
            $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
            [
              'CategoryID'=>$ebay_category_id,
              'FeatureID'=>['PaymentMethods']
            ]
          );
        foreach($res->FeatureDefinitions->PaymentMethod as $pm){
            $array[] = ['id'=>$pm, 'text'=>$pm];
        }
        /*
      foreach($res->PaymentOptionDetails as $po){
	  $array[] = array('id'=>$po->PaymentOption,
	      'text'=>$po->Description.' ('.$po->PaymentOption.')'
	  );
      }
         * 
         */
      return $array;
  }  
  
  function xtc_get_ebay_payments(){
  	$EBAYAPI = new ebayApi;
	$payment_codes = '';
        if(defined('EBAY_CATEGORY') and constant('EBAY_CATEGORY') > 0){
            $payments = $EBAYAPI->get_payments('ebay_default_payments',0,xtc_get_available_ebay_payments(constant('EBAY_CATEGORY')));
            foreach($payments as $k=>$v){
                    $payment_codes .= $v.', ';
            }
            $payment_codes = substr($payment_codes,0,(strlen($payment_codes)-2));
        }else{
            $payment_codes = 'Es wurde keine Standard eBay-Kategorie konfiguriert. Zahlungsmethoden werden immer anhand der eBay Kategorien ermittelt.';
        }
	return $payment_codes;
  }
  
  function xtc_cfg_pull_down_ebay_payments($payment,$key='') {
  	$EBAYAPI = new ebayApi;
    // vorher ohne payment parameter 2025/05
	  return $EBAYAPI->draw_payments_select('default',0,xtc_get_available_ebay_payments($payment));
  }
  
  function xtc_cfg_pull_down_ebay_preferred_payments($payment,$key='') {
    // vorher ohne payment parameter 2025/05
	  return xtc_draw_pull_down_menu('configuration_value',xtc_get_available_ebay_payments($payment),$payment);
  }
  
  function xtc_get_ebay_shippingmethods(){
  	$EBAYAPI = new ebayApi;
	$shippingmethods = '';
	$EBAYAPI->get_shippingcosts_value('default',$item_shippingcosts);
	if(sizeOf($item_shippingcosts)>0){
		foreach($item_shippingcosts as $k=>$shipArr){
			foreach($shipArr as $shipKey=>$ship){
				if($ship['shipService']){
					$shippingmethods .= 'National '.$ship['shipService'].': '.number_format($ship['shipFee'],2,',','.');
					if($ship['shipAdditionalFee']>0)
						$shippingmethods .= ' ('.number_format($ship['shipAdditionalFee'],2,',','.').')';
				}else{
					$shippingmethods .= 'International: '.$ship['shipServiceIntl'].': '.number_format($ship['shipFeeIntl'],2,',','.');
					if($ship['shipAdditionalFeeIntl']>0)
						$shippingmethods .= ' ('.number_format($ship['shipAdditionalFeeIntl'],2,',','.').')';
				}
				$shippingmethods .= ', ';
			}
		}
		$shippingmethods = substr($shippingmethods,0,(strlen($shippingmethods)-2));

	}
	return $shippingmethods;
  }
  
  function xtc_cfg_pull_down_ebay_shippingmethods($shippingmethod,$key='') {
  	$EBAYAPI = new ebayApi;
	return $EBAYAPI->draw_shippingmethods_select('default',$EBAYAPI->get_site_id_from_name(EBAY_SITE_ID));
  }

  function _get_files($path){
	  $files = array();
	 if ($dir = opendir($path)) {
    while (false !== ($file = readdir($dir))) {
			if($file != '.' and $file != '..' and stristr($file,'.htm')){
				$files[] = array('id'=>$file,'text'=>$file);
			}
		  }
	 }
	 return $files;
  }
  function xtc_cfg_pull_down_products_template($template_file,$key='') {
	 $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	 $files = _get_files(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/product_info/');
	 return xtc_draw_pull_down_menu($name,$files,$template_file);
  }
  function xtc_cfg_pull_down_ebay_template($template_file,$key='') {
	 $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	 $files = _get_files(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/ebay_templates/');
	 return xtc_draw_pull_down_menu($name,$files,$template_file);
  }
  function xtc_cfg_pull_down_characteristics_template($template_file,$key='') {
	 $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	 $files = _get_files(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/product_characteristics/');
	 return xtc_draw_pull_down_menu($name,$files,$template_file);
  }
  function xtc_cfg_pull_down_shipping_status($shipping_status,$key=''){
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$statuses = xtc_get_shipping_status();
	return xtc_draw_pull_down_menu($name,$statuses,$shipping_status);
  }

  function xtc_cfg_pull_down_ebay_itemspecifics($itemspecifics,$key=''){
	  $EBAYAPI = new ebayApi;
	  return $EBAYAPI->draw_itemspecifics_select('default');
  }

  function xtc_get_ebay_itemspecifics(){
	  $string = '';
	  $records = array();
	  $query = xtc_db_query("SELECT * FROM ebay_default_itemspecifics ORDER BY is_name");
	  while($row = xtc_db_fetch_array($query)){
		  $string .= $row['is_name'].'='.$row['is_value'].';';
	  }
	  return substr($string,0,(strlen($string)-1));
  }
  
    function yes_get_ebay_category_features(string $site_name,string $ebay_category_id,string $ebay_user = EBAY_USER){
        $EBAYAPI = new ebayApi;
        $ebaycalls = new \YES4Trade\Model\ebaycalls();
        $res = $ebaycalls->tradingQuery($ebay_user, 
          'GetCategoryFeatures',
          $EBAYAPI->get_site_id_from_name($site_name),
          [
            'CategoryID'=>$ebay_category_id,
            'DetailLevel'=>['ReturnAll'],
          ]
        );
        $category = $res->Category; 
        if($category->ConditionEnabled != 'Disabled'){
          return $category;
        }
        if(isset($res->SiteDefaults)){
          return $res->SiteDefaults;
        }
        if(!is_array($res->Category)){
          return $res;
        }
        return current(current($res->Category));
    }

	function yes_get_ebay_itemcondition_name($condition_id){
		if($condition_id == 0)
			return '';
		$ebay_itemcondition_array = array(); // KAT-ABHAENGIG
		if(!defined('EBAY_CATEGORY') or constant('EBAY_CATEGORY') < 1)
			return '';
		$category = yes_get_ebay_category_features(EBAY_SITE,EBAY_CATEGORY,EBAY_USER );
		switch($category->ConditionEnabled){
			case 'Enabled':
			case 'Required':
				$condition_values = $category->ConditionValues;
				foreach($condition_values->Condition as $condition){
					if($condition->ID == $condition_id){
						return $condition->DisplayName;
					}
				}
				break;
		}
		return '';
	}

function yes_cfg_pull_down_ebay_itemcondition_list($item_condition,$key=''){
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$ebay_itemcondition_array = array(); // KAT-ABHAENGIG
	if(!defined('EBAY_CATEGORY') or constant('EBAY_CATEGORY') < 1)
		return MSG_ERROR_NO_EBAY_DEFAULT_CATEGORY;
	$category = yes_get_ebay_category_features(	EBAY_SITE,EBAY_CATEGORY,EBAY_USER );
	switch($category->getConditionEnabled()){
		case 'Enabled':
		case 'Required':
			$condition_values = $category->getConditionValues();
			foreach($condition_values->Condition as $condition){
				$ebay_itemcondition_array[] = array(
					'id'=>$condition->getId(),
					'text'=>$condition->getDisplayName()
				);
			}
			break;
	}

	return xtc_draw_pull_down_menu($name,$ebay_itemcondition_array,$item_condition);
}
//--------------------------------------------------------------------------------------Ende

function yes_add_history($comment){
	$user_id = intval($_SESSION['customer_id']??0);
	if(!empty($comment)){
            $insert_sql_array = array(
                'date_added'=>'now()',
                'comments'=>$comment,
                'editor_id'=>$user_id
            );
            xtc_db_perform('history',$insert_sql_array);
	}
}

function yes_add_products_history($pID,$comments){
    product::add_history_static(intval($pID), $comments);
}

/**
 * Liest den Status eines Action Keys der Tabelle table_lock aus
 * @return array
 * @param string $action_key
 */
function yes_table_lock_get_status($action_key){
	$lock_query = xtc_db_query(sprintf("SELECT status,last_lock FROM table_lock WHERE action_key='%s'",$action_key));
	$lock = xtc_db_fetch_array($lock_query);
	return $lock;
}

/**
 * Gibt zurueck ob der Lock-Status noch aktiv ist
 *
 * @param date $last_lock
 * @param int $lock_duration_time
 * @return boolean
 */
function yes_table_lock_is_locked($last_lock,$lock_duration_time){
	$calculated_lock_duration = strtotime( $last_lock ) + $lock_duration_time;
	if($calculated_lock_duration <= time() )
		return false;
	else
		return true;
}

/**
 * Setzt die Spalte "last_lock" der tabelle table_lock fuer einen action_key auf now()
 * 
 * @param string $action_key
 */
function yes_table_lock_set_last_lock($action_key){
	xtc_db_query(sprintf("UPDATE table_lock SET last_lock=now() WHERE action_key='%s'",$action_key));
}

/**
 * Setzt den Status fuer einen Action Key in der Tabelle table_lock
 * Der Status kann "locked" oder "open" sein
 *
 * @param string $action_key
 * @param string $status
 */
function yes_table_lock_set_status($action_key,$status){
	switch($status){
		case 'locked':
			// last_lock auf now setzen
			xtc_db_query(sprintf("UPDATE table_lock SET status='%s',last_lock=now() WHERE action_key='%s'",$action_key,$status));
			break;
		default:
			xtc_db_query(sprintf("UPDATE table_lock SET status='%s' WHERE action_key='%s'",$action_key,$status));
			break;
	}
}

/**
 * Fuegt einen neuen Table Lock status ein
 * @param string $action_key
 * @param string $status 
 */
function yes_table_lock_add($action_key){
    xtc_db_query(sprintf("INSERT INTO table_lock SET status='locked',last_lock=now(),action_key='%s'",$action_key));
}

/**
 * Prueft ob $action_key in der Tabelle table_lock existiert
 * @param type $action_key
 * @return bool
 */
function yes_table_lock_exists($action_key){
    $query = xtc_db_query(sprintf(
	"SELECT id FROM table_lock WHERE action_key='%s'",
	$action_key
    ));
    if(xtc_db_num_rows($query))
	return true;
    return false;
}

function yes_get_customer_branches($cID){
	$branches = array();
	if($cID == 0)
		return $branches;
	if($cID == 1){
		$query = xtc_db_query("SELECT branches_id FROM branches ORDER BY title");
	}else{
		$query = xtc_db_query(sprintf(
			"SELECT branches_id FROM branches_to_customers WHERE customers_id='%s'",
			$cID)
		);
	}
	while($result = xtc_db_fetch_array($query)){
		$branches[] = $result['branches_id'];
	}
	return $branches;
}

function yes_get_httpinfo(){
	$str = '<code><b>'.$_SERVER['SCRIPT_NAME'].'</b>';
	if($_SERVER['REQUEST_URI'] != ''){
		$str .= ' Request from: '.$_SERVER['REQUEST_URI'];
	}
	$str .= '</code>';
	return $str;
}

function yes_get_shipping_list_size($value){
	if($value < 1)
		$value = 1;
	if($value > 200)#
		$value = 200;
	return $value;
}
function yes_set_shipping_list_size($value){
	return xtc_draw_input_field('configuration_value',$value);
}

function yes_get_products_distributor_number($pID,$distributor_id=false){
	if(!$distributor_id){
		$query_raw = sprintf(
			"SELECT distributor_products_number FROM products_distributors WHERE products_id='%s' ORDER BY is_default DESC LIMIT 1",
			$pID
		);
	}else{
		$query_raw = sprintf(
			"SELECT distributor_products_number FROM products_distributors WHERE products_id='%s' and distributor_id='%s'",
			$pID,$distributor_id
		);
	}
	$query = xtc_db_query($query_raw);
	if(!xtc_db_num_rows($query))
		return '';
	$record = xtc_db_fetch_array($query);
	return $record['distributor_products_number'];
}

function yes_get_products_distributor_comment($pID,$distributor_id=false){
	if(!$distributor_id){
		$query_raw = sprintf(
			"SELECT comments FROM products_distributors WHERE products_id='%s' ORDER BY is_default DESC LIMIT 1",
			$pID
		);
	}else{
		$query_raw = sprintf(
			"SELECT comments FROM products_distributors WHERE products_id='%s' and distributor_id='%s'",
			$pID,$distributor_id
		);
	}
	$query = xtc_db_query($query_raw);
	if(!xtc_db_num_rows($query))
		return '';
	$record = xtc_db_fetch_array($query);
	return xtc_db_prepare_input($record['comments']);
}

function yes_get_products_amazon_values($pID,$selling_partner_id=''){
	if(empty($selling_partner_id)){
		$query_raw = sprintf("SELECT * FROM amazon_products WHERE products_id='%s'",
			$pID
		);
	}else{
		$query_raw = sprintf("SELECT * FROM amazon_products WHERE products_id='%s' AND selling_partner_id='%s'",
			$pID,$selling_partner_id
		);
	}
	$query = xtc_db_query($query_raw);
	if(xtc_db_num_rows($query) == 1){
		if(empty($merchant_id)){
			return array(xtc_db_fetch_array($query));
		}else{
			return xtc_db_fetch_array($query);
		}
	}
	$array = array();
	while($record = xtc_db_fetch_array($query)){
		$array[] = $record;
	}
	return $array;
}

function yes_get_amazon_sku($pID,$ean){
	return sprintf('%s-%s',$pID,$ean);
}

function yes_get_products_id_from_amazon_sku($sku,$selling_partner_id=''){
	if(empty($selling_partner_id)){
		$query = xtc_db_query(sprintf(
			"SELECT products_id FROM amazon_products WHERE sku='%s'",
			$sku
		));
	}else{
		$query = xtc_db_query(sprintf(
			"SELECT products_id FROM amazon_products WHERE sku='%s' AND selling_partner_id='%s'",
			$sku,$selling_partner_id
		));
	}
	if(!xtc_db_num_rows($query))
		return -1;
	$record = xtc_db_fetch_array($query);
	return $record['products_id'];
}

function yes_get_amazon_products_qty($sku,$selling_partner_id = ''){
	if(empty($selling_partner_id)){
		$query = xtc_db_query(sprintf(
			"SELECT SUM(quantity) as qty FROM amazon_products WHERE sku='%s'",
			$sku
		));
		$record = xtc_db_fetch_array($query);
	}else{
		$query = xtc_db_query(sprintf(
			"SELECT SUM(quantity) as qty FROM amazon_products WHERE sku='%s' AND selling_partner_id='%s'",
			$sku,$selling_partner_id
		));
		$record = xtc_db_fetch_array($query);
	}
	return (int)$record['qty'];
}

function yes_get_country_id_from_iso2($iso2){
	if(empty($iso2) or strlen($iso2) != 2){
		return -1;
	}
	$query = yes_db_query(sprintf(
		"SELECT countries_id FROM countries WHERE countries_iso_code_2='%s'",
		strtoupper($iso2)
	),true);

	if($query){
		$record = current($query);
		return $record['countries_id'];
	}
	return -1;
}

/**
 * Ermittelt die EAN einer pID
 * @param int $pID
 * @return String
 */
function yes_get_products_ean($pID){
    $query = yes_db_query(sprintf(
	"SELECT products_ean FROM products WHERE products_id='%s'",
	$pID
    ),true);
    if(yes_db_num_rows($query)){
	$record = current($query);
	return $record['products_ean'];
    }
    return '';
}

function xtc_get_distributor_kundennummer($dID){
	$query = xtc_db_query(sprintf(
		"SELECT kundennummer FROM distributors WHERE id='%s'",
		$dID
	));
	if(xtc_db_num_rows($query)){
		$record = xtc_db_fetch_array($query);
		return $record['kundennummer'];
	}
	return '';
}

if(!function_exists('_is_test')){
	function _is_test($pID){
		return true;
	}
}
function yes_get_iso_code3($country_name){
	$query = yes_db_query(sprintf(
		"SELECT countries_iso_code_3 FROM countries WHERE countries_name='%s'",
		$country_name
	),true);
	$record = current($query);
	return $record['countries_iso_code_3'];
}

function yes_get_manufacturers_name(int $manufacturers_id){
    if(!is_int($manufacturers_id) or $manufacturers_id < 1){
        return '';
    }
    $query = yes_db_query(sprintf(
            "SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id='%s'",
            $manufacturers_id
    ),true);
    if(yes_db_num_rows($query)){
        $record = current($query);
        return $record['manufacturers_name'];
    }
    return '';
}

function yes_get_products_manufacturers_name($products_id){
	$query = yes_db_query(sprintf(
		"SELECT manufacturers_name FROM products LEFT JOIN manufacturers USING(manufacturers_id) WHERE products_id='%s'",
		$products_id
	),true);
	if(yes_db_num_rows($query)){
		$record = current($query);
		return $record['manufacturers_name'];
	}
	return '';
}

function yes_get_subcategories(&$categories,$id){
	$csql = xtc_db_query(sprintf(
		"SELECT categories_id, parent_id FROM categories WHERE parent_id=%s order by sort_order",
		$id
	));
	if(xtc_db_num_rows($csql)){
		while($row = xtc_db_fetch_array($csql)){
//			$categories[$id][] = $row['categories_id'];
			$categories[] = $row['categories_id'];
			yes_get_subcategories($categories,$row['categories_id']);
		}
	}
}

function yes_get_storage_info($storage_id){
	$query = xtc_db_query(sprintf(
		"SELECT * FROM storages WHERE id=%s",
		$storage_id
	));
	return xtc_db_fetch_array($query);
}

function yes_get_products_default_shipper(int $products_id){
    return \YES4Trade\Model\shipper_profiles::get_products_id_value($products_id);
}

/**
 * HOLT ALLE DATENSAETZE AUS storage_products_transfer ZU EINEM AUTRAG/REKLA
 * 
 * *** 09/2017 ***
 * Der Parameter $shipping_products_id begrenzt die Datensaetze auf einen
 * bestimmten Versanddatensatz, so das auch Teillieferungen abgebildet werden
 * koennen
 * 
 * @param type $products_id
 * @param type $reason_class
 * @param type $reason_id
 * @param type $reason_subclass
 * @param type $is_colli
 * @param type $shipping_products_id
 * @return array
 */
function yes_get_transferred_storage_products($products_id,$reason_class,$reason_id,$reason_subclass='',$is_colli = false, $shipping_products_id=0){
	$items = array();
        $query_raw = sprintf(
		"SELECT source_storage_products_id,quantity FROM storage_products_transfer WHERE reason_class='%s' and reason_id=%s %s",
		$reason_class,$reason_id,(($reason_subclass != '') ? sprintf("AND reason_subclass='%s'",$reason_subclass):'')
	);
        if($shipping_products_id > 0){
            $query_raw .= sprintf(" AND shipping_products_id='%s'",$shipping_products_id);
        }
	$query = xtc_db_query($query_raw);
	if(!xtc_db_num_rows($query)){
		return $items;
	}
	$storage_products = array();
	while($record = xtc_db_fetch_array($query)){
            if(!isset($storage_products[ $record['source_storage_products_id'] ])){
                $storage_products[ $record['source_storage_products_id'] ] = 0;
            }
            $storage_products[ $record['source_storage_products_id'] ] += $record['quantity'];
	}
	foreach($storage_products as $spID=>$qty){
		$query = xtc_db_query(sprintf(
			"SELECT storage_id,name, storage_places_id FROM storage_products sp LEFT JOIN storages s ON sp.storage_id=s.id WHERE sp.id=%s AND sp.products_id=%s",
			$spID,$products_id
		));
		if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			if($record['storage_places_id']>0){
			    $record['storage_place'] = yes_get_storage_place_title($record['storage_places_id']);
			}
			$record['quantity'] = $qty;
			if($is_colli){
			    $record['is_colli'] = true;
			    $record['collie_products_id'] = $products_id;
			}
			$items[] = $record;
		}
	}
	return $items;
}

function xtc_get_products_vpe_name($products_vpe_id, $language_id = '') {
	if (!$language_id){
            $language_id = $_SESSION['languages_id'];
        }
	$products_vpe_query = xtc_db_query("select products_vpe_name from ".TABLE_PRODUCTS_VPE." where products_vpe_id = '".$products_vpe_id."' and language_id = '".$language_id."'");
  if(xtc_db_num_rows($products_vpe_query)){
	  $products_vpe = xtc_db_fetch_array($products_vpe_query);
	  return $products_vpe['products_vpe_name'];
  }
  return '';
}

function xtc_get_storage_number($storage_id,$products_id){
	$query = xtc_db_query(sprintf(
		"SELECT nummer FROM storage_numbers WHERE products_id='%s' AND storage_id='%s'",
		$products_id,$storage_id
	));
	if(!xtc_db_num_rows($query))
		return '';
	$record = xtc_db_fetch_array($query);
	return xtc_db_prepare_input( $record['nummer'] );
}

function yes_get_order_product_properties($opID){
		$properties_array = array();
		$properties_query = xtc_db_query(sprintf(
			"SELECT property_title,property_value,price_netto,input_span FROM orders_products_properties WHERE orders_products_id='%s' ORDER BY property_title",
			$opID
		));
		if(xtc_db_num_rows($properties_query)){
			while($properties = xtc_db_fetch_array($properties_query)){
				 $properties_array[] = $properties;
			}
		}
		return $properties_array;
}

function yes_count_shippable_order_products($orders_id){
	$check_op_query = xtc_db_query(sprintf(
		"SELECT products_quantity-quantity_shipped-not_ship as qty_to_send FROM orders_products WHERE orders_id='%s'",
		$orders_id
	));
	$shippable_products = 0;
	while($check_op = xtc_db_fetch_array($check_op_query)){
		if($check_op['qty_to_send'] > 0){
			$shippable_products++;
		}
	}
	return $shippable_products;
}

function yes_get_shippings_products($shippings_id){
	$shippings_products_array = array();
	$shippings_products_query = xtc_db_query(sprintf(
		"SELECT * FROM shippings_products WHERE shippings_id='%d'",
		$shippings_id
	));
	while($shippings_products = xtc_db_fetch_array($shippings_products_query)){
		$shippings_products_array[] = $shippings_products;
	}
	return $shippings_products_array;
}


function yes_get_ebay_returnswithincode_name($returnswithincode){
    if(!defined('EBAY_USER') or empty(constant('EBAY_USER'))){
        return 'UNBEKANNT';
    }
    $EBAYAPI = new ebayApi;
    $rtw = $EBAYAPI->get_ebay_details('ReturnPolicyDetails');
    foreach($rtw->ReturnPolicyDetails->ReturnsWithin as $code){
	if($returnswithincode == $code->ReturnsWithinOption)
	    return $code->Description;
    }
    return 'UNBEKANNT';
}
function yes_cfg_pull_down_ebay_returnswithincodes($returnswithincode,$key=''){
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
	$EBAYAPI = new ebayApi;
	$rtw = $EBAYAPI->get_ebay_details('ReturnPolicyDetails');
	foreach($rtw->ReturnPolicyDetails->ReturnsWithin as $code){
	    $array[] = array(
		'id'=>$code->ReturnsWithinOption,
		'text'=>$code->Description
	    );
	}
	return xtc_draw_pull_down_menu($name, $array,$returnswithincode);
}

function yes_get_ebay_shippingcostpaidby_name($shippingcostpaidby){
    if(!defined('EBAY_USER') or empty(constant('EBAY_USER'))){
        return '';
    }
    $EBAYAPI = new ebayApi;
    $res = $EBAYAPI->get_ebay_details('ReturnPolicyDetails');
    foreach($res->ReturnPolicyDetails->ShippingCostPaidBy as $scpb){
	if($shippingcostpaidby == $scpb->ShippingCostPaidByOption){
	    return $scpb->Description;
	}
    }
}

function yes_cfg_pull_down_ebay_shippingcostpaidbycodes($shippingcostpaidby,$key=''){
    $array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $EBAYAPI = new ebayApi;
    $res = $EBAYAPI->get_ebay_details('ReturnPolicyDetails');
    if($res->Ack == 'Failure'){
        $err = current(current($res->Errors));
        return '<span class="error">Request Error (ReturnPolicyDetails): '.$err->ShortMessage.'<br /><i>'.$err->LongMessage.'</i></span>';
    }
    foreach($res->ReturnPolicyDetails->ShippingCostPaidBy as $scpb){
	$array[] = array(
	    'id'=>$scpb->ShippingCostPaidByOption,
	    'text'=>$scpb->Description
	);
    }
    return xtc_draw_pull_down_menu($name, $array,$shippingcostpaidby);
}





function qpa_save_images(int $products_id,string $products_image_name,int $image_number,int $noshop){
    $product = new product($products_id);
    $products_image_name = $product->copy_and_save_image(DIR_FS_CATALOG_ORIGINAL_IMAGES.$products_image_name,$image_number);

    // ORIG IMAGES SIND ZU GROSS - POPUP NEHMEN
    if(defined('USE_NO_ORIGINAL_IMAGES') and constant('USE_NO_ORIGINAL_IMAGES') == 'True'){
      unlink(DIR_FS_CATALOG_ORIGINAL_IMAGES.'/'.$products_image_name);
      copy(DIR_FS_CATALOG_POPUP_IMAGES.'/'.$products_image_name,DIR_FS_CATALOG_ORIGINAL_IMAGES.'/'.$products_image_name);
    }
    if($image_number > 0 and $noshop == 0){
        $sql_data_array = array(
          'noshop'=>1
        );
        yes_db_perform('products_images',$sql_data_array,'update',[
          'products_id'=>$products_id,
          'image_nr'=>$image_number,
        ]);
    }
}

function yes_get_categories_amazon_flatfile($categories_id,$language_id){
        if($language_id == 0){
            $language_id = $_SESSION['languages_id']??2;
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($categories_id), intval($language_id),[
                'amazon_flatfile'
            ]
        );
        if($cd !== null){
            return $cd->amazon_flatfile;
        }
        return '';
}

function yes_get_categories_amazon_browse_node_id($categories_id,$language_id){
        if($language_id == 0){
            $language_id = $_SESSION['languages_id']??2;
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($categories_id), intval($language_id),[
                'amazon_browse_node_id'
            ]
        );
        if($cd !== null){
            return $cd->amazon_browse_node_id;
        }
        return '';
}

function yes_get_products_amazon_flatfile($products_id,$language_id){
    $query = xtc_db_query(sprintf(
	    "SELECT amazon_flatfile FROM products_description WHERE products_id='%s' AND language_id='%s'",
	    $products_id,$language_id
    ));
    if(!xtc_db_num_rows($query))
	return '';
    $record = xtc_db_fetch_array($query);
    return $record['amazon_flatfile'];
}

function yes_get_products_amazon_browse_node_id($products_id,$language_id){
    $query = xtc_db_query(sprintf(
	    "SELECT amazon_browse_node_id FROM products_description WHERE products_id='%s' AND language_id='%s'",
	    $products_id,$language_id
    ));
    if(!xtc_db_num_rows($query))
	return '';
    $record = xtc_db_fetch_array($query);
    return $record['amazon_browse_node_id'];
}

function yes_get_products_description_amazon($products_id,$language_id){
    $query = xtc_db_query(sprintf(
	    "SELECT products_description_amazon FROM products_description WHERE products_id='%s' AND language_id='%s'",
	    $products_id,$language_id
    ));
    if(!xtc_db_num_rows($query))
	return '';
    $record = xtc_db_fetch_array($query);
    return $record['products_description_amazon'];
}

function xtc_get_navtrail_product_title_type($value){
    if(!defined('NAVTRAIL_PRODUCTS_TITLE_VALUE_'.strtoupper($value)))
	    return 'unknown navtrail product type';
    return constant('NAVTRAIL_PRODUCTS_TITLE_VALUE_'.strtoupper($value));
}

function xtc_cfg_pull_down_navtrail_product_title_types($type, $key=''){
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$array = array(
	    array('id'=>'','text'=>TEXT_SELECT),
	    array('id'=>'products_model','text'=>NAVTRAIL_PRODUCTS_TITLE_VALUE_PRODUCTS_MODEL),
	    array('id'=>'products_name','text'=>NAVTRAIL_PRODUCTS_TITLE_VALUE_PRODUCTS_NAME),
	    array('id'=>'products_id','text'=>NAVTRAIL_PRODUCTS_TITLE_VALUE_PRODUCTS_ID),
	    array('id'=>'products_ean','text'=>NAVTRAIL_PRODUCTS_TITLE_VALUE_PRODUCTS_EAN)
	);
	
	return xtc_draw_pull_down_menu($name, $array,$type);
}
function yes_get_products_sells($products_id, $days, $set_products = array(),$status_filter = array(ORDERS_STATUS_STORNIERT),$src = false){
	$from = date('Y-m-d',time()-(60*60*24*$days)).' 00:00:00';
	$query_raw = sprintf("SELECT SUM(op.products_quantity) as pqty,o.source FROM orders_products op,orders o WHERE op.orders_id=o.orders_id and o.orders_status NOT IN(%s) and o.date_purchased > '%s' and op.products_id='%s'",
	    implode(',',$status_filter),
	    $from,$products_id
	);
	if($src){
	    $sources = array();
	    $query_raw .= ' GROUP BY o.source';
	    $query = xtc_db_query($query_raw);
	    while($record = xtc_db_fetch_array($query)){
		if(empty($record['source'])) $record['source'] = 'unknown';
		if(!isset($sources[$record['source']])) $sources[$record['source']] = 0;
		$sources[$record['source']] += $record['pqty'];
		if(is_array($set_products) and sizeOf($set_products)){
		    foreach($set_products as $set){
			$_sells = yes_get_products_sells($set['products_id'], $days, array(),$status_filter,$src);
			if(isset($_sells[ $record['source'] ]))
			    $sources[$record['source']] += $_sells[ $record['source'] ]*$set['quantity'];
		    }
		}
	    }
	    return $sources;
	}else{
	    $query = xtc_db_query($query_raw);
	    $record = xtc_db_fetch_array($query);
	    $num = (int)$record['pqty'];
	    if(is_array($set_products) and sizeOf($set_products)){
		foreach($set_products as $set){
		    $num += yes_get_products_sells($set['products_id'], $days, array(),$status_filter,$src)*$set['quantity'];
		}
	    }
	    return $num;
	}
	
}

function yes_die(){
    die("\r\nAbbruch um ".date('Y-m-d H:i:s'));
}

function xtc_get_products_amazon_title($product_id,$language_id){
    $product_query = xtc_db_query("select amazon_title from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $language_id . "'");
    $product = xtc_db_fetch_array($product_query);
    return $product['amazon_title'];
}

function yes_get_mime_type($file){
	// MIME TYPE PRUEFEN
	/*
	$finfo = finfo_open(FILEINFO_MIME_TYPE); // return mime type ala mimetype extension
	$mime_type = finfo_file($finfo, $file);
	finfo_close($finfo);
	 * 
	 */
	$filename = escapeshellcmd($file);
	$command = "file -b --mime-type -m /usr/share/misc/magic {$filename}";
	$mimeType = shell_exec($command);
	$mime_type = trim($mimeType);
	return $mime_type;
}

function yes_return_bytes($val) {
    $val = trim($val);
    $last = strtolower($val[strlen($val)-1]);
    switch($last) {
        // The 'G' modifier is available since PHP 5.1.0
        case 'g':
            $val *= 1024;
        case 'm':
            $val *= 1024;
        case 'k':
            $val *= 1024;
    }

    return $val;
}

function yes_cfg_pull_down_reclamation_types($reclamations_types_id,$key=''){
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
	$query = xtc_db_query("SELECT reclamations_types_id,reclamations_types_title FROM reclamations_types ORDER BY reclamations_types_title");
	while($record = xtc_db_fetch_array($query)){
		$array[] = array('id'=>$record['reclamations_types_id'],'text'=>$record['reclamations_types_title']);
	}
	return xtc_draw_pull_down_menu($name, $array,$reclamations_types_id);
}

function yes_get_products_amazon_fulfillmentlatency($products_id){
	$query = xtc_db_query(sprintf(
		"SELECT amazon_fulfillmentlatency FROM %s WHERE products_id='%s'",
		TABLE_PRODUCTS,$products_id
	));
	if(!xtc_db_num_rows($query)){
		return 0;
	}
	$record = xtc_db_fetch_array($query);
	if($record['amazon_fulfillmentlatency'] < 1){
		return constant('MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY');
	}
	return $record['amazon_fulfillmentlatency'];
}
function xtc_cfg_select_image_path($image_path,$key=''){
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	$array = array(
	    array('id'=>'','text'=>TEXT_SELECT),
	    array('id'=>'original_images','text'=>'original_images'),
	    array('id'=>'thumbnail_images','text'=>'thumbnail_images'),
	    array('id'=>'popup_images','text'=>'popup_images'),
	    array('id'=>'info_images','text'=>'info_images')
	);
        if(is_dir(DIR_FS_CATALOG.'images/product_images/ebaycategory_images')){
            $array[] = array('id'=>'ebaycategory_images','text'=>'ebaycategory_images');
        }
	return xtc_draw_pull_down_menu($name, $array,$image_path);
}

/**
 * Ermittele pID anhand einer eBay SKU
 * 
 * Es wird in ebay_auctions (bzw ebay_auctions_variations) anhand der uebergebenen
 * SKU ermittelt, welche pID verlinkt ist. Dabei wird der zuletzt eingestellte
 * Auktionsdatensatz verwendet (ORDER BY ea.start_time DESC LIMIT 1)
 * Es wird -1 zurueckgegeben wenn kein Auktionsdatensatz gefunden wurde. Dies
 * waere zb der Fall wenn die Auktion mit einem anderen Tool eingestellt wurde
 * 
 * @param string $sku
 * @param bool $variation
 * @return int
 */
function yes_get_products_id_from_ebay_sku($sku,$variation=false){
    if($variation){
	    $query = xtc_db_query(sprintf(
        "SELECT eav.products_id FROM ebay_auctions_variations eav LEFT JOIN ebay_auctions ea ON eav.ebay_auctions_id=ea.id WHERE eav.sku='%s' AND ea.products_id < 1 ORDER BY ea.start_time DESC LIMIT 1",
            $sku
	      )
      );
      if(!xtc_db_num_rows($query)){
        return -1;
      }
      $record = xtc_db_fetch_array($query);
      $pID = $record['products_id'];
    }else{
      $pID = \YES4Trade\Model\ebay_auctions::get_products_id_from_last_used_ebay_sku($sku);
    }
    return intval($pID);
}

function yes_get_product_comments($pID){
  $query = xtc_db_query(sprintf(
	  "SELECT comments FROM %s WHERE products_id='%d'",
	  TABLE_PRODUCTS,$pID
  ));
  $record = xtc_db_fetch_array($query);
  return $record['comments'];
}

function yes_get_storage_place_title($stpID){
    $query = xtc_db_query(sprintf(
	    "SELECT title FROM storage_places WHERE storage_places_id='%d'",
	    $stpID
    ));
    $record = xtc_db_prepare_input(xtc_db_fetch_array($query));
    return $record['title'];
}

function xtc_cfg_pull_down_ebay_seller_profile_payment_id($seller_profile_payment_id,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $EBAYAPI = new ebayApi;
    return $EBAYAPI->draw_seller_profile_select('payment',$name,$seller_profile_payment_id);
}

function xtc_cfg_pull_down_ebay_seller_profile_return_policy_id($seller_profile_return_policy_id,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $EBAYAPI = new ebayApi;
    return $EBAYAPI->draw_seller_profile_select('return_policy',$name,$seller_profile_return_policy_id);
}

function xtc_cfg_pull_down_ebay_seller_profile_shipping_id($seller_profile_shipping_id,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $EBAYAPI = new ebayApi;
    return $EBAYAPI->draw_seller_profile_select('shipping',$name,$seller_profile_shipping_id);
}
function xtc_cfg_select_gpf_availabilities($availibility,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $values = \google_product_feed::get_gpf_availabilities();
    return xtc_draw_pull_down_menu($name,$values,$availibility);
}
function xtc_cfg_select_gpf_conditions($condition,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $values = google_product_feed::get_gpf_conditions();
    return xtc_draw_pull_down_menu($name,$values,$condition);
}

function xtc_cfg_select_ebaymich_file($file, $key=''){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $basics = new basics;
    $values = $basics->get_directory_content(DIR_FS_CATALOG.'ebaymich/');
    $files = array(array('id'=>'','text'=>TEXT_SELECT));
    foreach($values as $file){
        $files[] = array('id'=>$file,'text'=>$file);
    }
    return xtc_draw_pull_down_menu($name,$files,$file);
}

function xtc_cfg_module_textarea($text,$key='') {
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    return xtc_draw_textarea_field($name, false, 35, 5, $text);
}

/**
 * Liest die Datei database_table_structure.ini als INI ein
 * 
 * @return array Strukturiertes INI Array mit den Tables als Sections
 */
function yes_get_database_table_ini(){
    $ini_file = \main::get_importdata_path().'database_table_structure.ini';
    if(!is_file($ini_file)){
        return array();
    }
    return parse_ini_file($ini_file,true);
}

/**
 * 
 * @param Array $ini INI Array mit Tables als Section
 * @param String $table MYSQL Tabellenname
 * @param String $field MYSQL Tabelle Feld
 * @return int Laenge des Feldes oder -1 wenn es nicht ermittelt werden kann
 */
function yes_get_database_table_field_length($ini,$table,$field,$filter = 'varchar'){
    if(!isset($ini[$table][$field])){
        return -1;
    }
    if( preg_match( '!'.$filter.'\(([^\)]+)\)!', $ini[$table][$field], $match ) ){
        return (int)$match[1];
    }
    return -1;
}

function xtc_cfg_module_other_meta_opengraph_image_properties($url, $key){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    return xtc_draw_input_field($name, $url).' <a href="javascript:get_meta_opengraph_image_properties(\''.$name.'\');">Info</a>';
}

function has_concergio_special_auth(){
    if(!defined('CONCERGIO_ALLOW_KASSE_PROCESS_ORDER_CUSTOMERS_ID') or constant('CONCERGIO_ALLOW_KASSE_PROCESS_ORDER_CUSTOMERS_ID') == ''){
        return false;
    }
    if(in_array($_SESSION['customer_id'], explode(',',constant('CONCERGIO_ALLOW_KASSE_PROCESS_ORDER_CUSTOMERS_ID')))){
        return true;
    }
    return false;
}

function xtc_cfg_pull_down_vpe_values($vpe_id,$key){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $values = array();
    $query = xtc_db_query(
            "SELECT products_vpe_id, products_vpe_name FROM products_vpe WHERE language_id='2' ORDER BY products_vpe_name"
    );
    while($record = xtc_db_fetch_array($query)){
        $values[] = array(
            'id'=>$record['products_vpe_id'],
            'text'=>$record['products_vpe_name']
        );
    }
    return xtc_draw_pull_down_menu($name, $values, $vpe_id);
}
function yes_get_packaging_name($packagings_id){
    $packagings_id = (int)xtc_db_input($packagings_id);
    if($packagings_id < 1){
        return '';
    }
    $query = xtc_db_query(sprintf(
            "SELECT title FROM packagings WHERE packagings_id='%d'",
            $packagings_id
    ));
    if(!xtc_db_num_rows($query)){
        return '';
    }
    $record = xtc_db_fetch_array($query);
    return $record['title'];
}

function xtc_cfg_pull_down_packagings($packagings_id,$key){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $values = array(array(
        'id'=>'',
        'text'=>TEXT_SELECT
    ));
    $query = xtc_db_query(
            "SELECT packagings_id, title FROM packagings ORDER BY title"
    );
    while($record = xtc_db_fetch_array($query)){
        $values[] = array(
            'id'=>$record['packagings_id'],
            'text'=>$record['title']
        );
    }
    return xtc_draw_pull_down_menu($name, $values, $packagings_id);
}

function xtc_cfg_yes_hitmeister_carrier_allocation($carrier_allocation,$key){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');   
    require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
    global $VERSENDER;
    $rows = array();
    // zb: GLS:GLS,Spedition:Other
    $carrier_allocation_values = array();
    $carrier_allocation = explode(',',$carrier_allocation);
    foreach($carrier_allocation as $all){
        $parts = explode(':',$all);
        $carrier_allocation_values[ $parts[0] ] = $parts[1];
    }
    foreach($VERSENDER as $V){
        $rows[] = sprintf(
                '<div style="width: 120px;float: left;">%s:</div> %s',
                $V,
                xtc_draw_pull_down_menu('YES_HITMEISTER_CARRIER['.$V.']',yes_hitmeister::hitmeister_carrier(),$carrier_allocation_values[$V])
        );
    }
    return implode('<br clear="all" />',$rows);
}

function xtc_cfg_pull_down_order_listing_country_src(string $order_listing_country_src, string $key=''){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');   
    $values = [
        [
            'id'=>'o.customers_country',
            'text'=>ORDER_LISTING_COUNTRY_SRC_CUSTOMER,
        ],
        [
            'id'=>'o.billing_country',
            'text'=>ORDER_LISTING_COUNTRY_SRC_BILLING,
        ],
        [
            'id'=>'o.delivery_country',
            'text'=>ORDER_LISTING_COUNTRY_SRC_DELIVERY,
        ],
    ];
    return xtc_draw_pull_down_menu($name, $values, $order_listing_country_src);
}
function xtc_get_order_listing_country_src_name(string $order_listing_country_src){
    switch($order_listing_country_src){
        case 'o.billing_country':
            return ORDER_LISTING_COUNTRY_SRC_BILLING;
        case 'o.delivery_country':
            return ORDER_LISTING_COUNTRY_SRC_DELIVERY;
    }
    return ORDER_LISTING_COUNTRY_SRC_CUSTOMER;
}

function yes_wemalo_webhooks_selection(string $active_webhooks_string, string $key=''){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');   
    $events = ['status_update','stock_change','trackingnumber_added','item_failed'];
    $string = '<script>function wem(event,deleteFlag){'
            . '     var deleteParam = (deleteFlag==1) ? "&delete=1" : ""; '
            . '     $.ajax({'
            . '          url: \'shipping.php?action=wemalo_webhook_add_event\'+deleteParam+\'&event=\'+event,'
            . '          dataType: \'json\','
            . '          success: function(json){'
            . '             if(json.OK == 1){'
            . '                 if( deleteFlag == 1 ){'
            . '                     $(\'button#wembutton_\'+event).css(\'background-color\',\'lightgrey\').prop("onclick", null).off("click");'
            . '                     $(\'button#wembutton_\'+event).on("click", function(){'
            . '                         wem(event,0);'
            . '                     });'
            . '                     alert(\'Webhook \'+event+\' entfernt.\');return false;'
            . '                 }else{'
            . '                     $(\'button#wembutton_\'+event).css(\'background-color\',\'lightgreen\').prop("onclick", null).off("click");'
            . '                     $(\'button#wembutton_\'+event).on("click", function(){'
            . '                         wem(event,1);'
            . '                     });'
            . '                     alert(\'Webhook gespeichert/aktualisiert.\');return false;'
            . '                 }'
            . '             }else{'
            . '                 alert(\'Cant add wemalo webhook event\');return false;'
            . '             }'
            . '          },'
            . '          error: function( xhr ){'
            . '             alert(\'Cant add wemalo webhook event \'+event);return false;'
            . '          }'
            . '     }); return false;'
            . '}</script>';
    $saved = explode(',',MODULE_SHIPPING_WEMALO_WEBHOOKS);
    foreach($events as $e){
        if( !in_array($e, $saved )){
            $string .= '<button id="wembutton_'.$e.'" type="button" style="width: 200px;" onclick="wem(\''.$e.'\',0)">'.$e.'</button><br />';
        }else{
            $string .= '<button id="wembutton_'.$e.'" type="button" style="background-color: lightgreen; width: 200px;" onclick="wem(\''.$e.'\',1)">'.$e.'</button><br />';
        }
    }
    return $string;
}

function yes_boxes_get_config(){
    $YB = new \YES4Trade\Model\yes_boxes();
    return $YB->get_config_string();
}

function yes_boxes_set_config( $configuration_value, $key=''){
    $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
    $config = [];
    $YB = new \YES4Trade\Model\yes_boxes();
    foreach($YB->get_list() as $yes_box){
        $checked = $yes_box->get_active();
        $config[] = xtc_draw_checkbox_field('yes_box[]',$yes_box->get_id(),$checked).' '.$yes_box->get_id();
    }
    
    $js  = '<script>function convert_yes_box_config_string(){';
    $js .= "    let input_value = '';";
    $js .= "    \$('input[name=\"yes_box[]\"]').each(function(){";
    $js .= "        if(\$(this).prop('checked')){";
    $js .= "            if( input_value != ''){";
    $js .= "                input_value += ';';";
    $js .= "            }";
    $js .= "            input_value += $(this).val();";
    $js .= "        }";
    $js .= "    });";
    $js .= "    return input_value;";
    $js .= '}';
    $js .= "\$(function(){";
    $js .= "    \$('form[name=\"configuration\"]').on('submit',function(){";
    $js .= "        \$('input[name=\"".$name."\"]').val(convert_yes_box_config_string());return true;";
    $js .= "    });";
    $js .= "});";
    $js .= '</script>';
    return '<br />'.$js.implode('<br />',$config).xtc_draw_hidden_field($name, '');
}

function yes_dhlgkapi_teilnahme_config_save( $value ){
    require_once(DIR_WS_CLASSES.'DHL_Paket_DE_Versenden_REST_API.php');
    if(!empty($value)){
        $obj = (array)json_decode($value);
    }
    $items = array();
    
    foreach(DHL_Paket_DE_Versenden_REST_API::PRODUKTE as $p){
        $checked = false;
        $tn_default = $p['Teilnahme'];
        if(isset($obj[$p['id']])){
            $tn_default = substr($obj[$p['id']],-2);
            $checked = true;
        }
        $items[] = sprintf(
                '<div class="ui-widget"><div style="padding: 4px;" class="ui-widget-content"><b>[%s]</b> %s</div>Aktiv: %s <span style="color: #666;" title="Verfahren Teilnahme">(%s %s)</span></div>',
                $p['GKV_API'],$p['description'],
                xtc_draw_checkbox_field('dhl_api['.$p['id'].']',
                        1,
                        $checked
                ),
                $p['Verfahren'], 
                xtc_draw_pull_down_menu('Teilnahme['.$p['id'].']',[
                    ['id'=>'01','text'=>'01'],
                    ['id'=>'02','text'=>'02'],
                    ['id'=>'03','text'=>'03'],
                    ['id'=>'04','text'=>'04'],
                    ['id'=>'05','text'=>'05'],
                    ['id'=>'06','text'=>'06'],
                    ['id'=>'07','text'=>'07'],
                    ['id'=>'08','text'=>'08'],
                    ['id'=>'09','text'=>'09'],
                ],$tn_default)
        );
    }
    return '<br />'.implode('<br />',$items);
}

function yes_dhlgkapi_teilnahme_config_get( ){
    require_once(DIR_WS_CLASSES.'DHL_Paket_DE_Versenden_REST_API.php');
    $items = array();
    
    if(defined('MODULE_SHIPPING_DHLGKAPI_TEILNAHME') and !empty(MODULE_SHIPPING_DHLGKAPI_TEILNAHME)){
        $obj = (array)json_decode(MODULE_SHIPPING_DHLGKAPI_TEILNAHME);
    }
    foreach(DHL_Paket_DE_Versenden_REST_API::PRODUKTE as $p){
        $active = NO;
        $num = '';
        if(isset($obj[$p['id']])){
            $active = sprintf('<b>%s</b>',YES);
            $num = sprintf('<span style="color: green"> (%s)</span>',$obj[$p['id']]);
        }
        $items[] = sprintf(
                '<div class="ui-widget" title="%s">%s<br />Aktiv: %s%s</div>',
                $p['id'],$p['description'],$active,
                $num
        );
    }
    return implode('<br />',$items);
}

function yes_dhlgkapi_get_produkt_verfahren_teilnahme(string $produkt, string $verfahren){
    if(defined('MODULE_SHIPPING_DHLGKAPI_TEILNAHME') and !empty(MODULE_SHIPPING_DHLGKAPI_TEILNAHME)){
        $obj = json_decode(MODULE_SHIPPING_DHLGKAPI_TEILNAHME);
        yes_debug($obj);
    }
}