<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_EMAILEXPORT_TEXT_DESCRIPTION', 'Export - E-Mail Adressen Ihrer Kunden');
define('MODULE_EMAILEXPORT_TEXT_TITLE', 'E-Mail Adressen Export - CSV');
define('MODULE_EMAILEXPORT_STATUS_DESC','Modulstatus');
define('MODULE_EMAILEXPORT_STATUS_TITLE','Status');
define('MODULE_EMAILEXPORT_GROUP','Exportiere E-Mailadressen der Kundengruppe');
define('MODULE_EMAILEXPORT_EXPORTTEXT','<br />Es wird im CSV Format exportiert, der Texttrenner ist Tabulator. Aus Performancegr&uuml;nden wird die Export-Datei im .zip Format als Download zur Verf&uuml;gung gestellt.');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
define('CSV_SEPARATOR',"\t");
define('ADMIN_GROUP_ID',0);
define('MAX_ITEMS_PER_EXPORT','5000');
// include needed functions

  class emailexport{
    var $code, $title, $description, $enabled,$categories_string,
            $_check,$selected_categories,$group,$groups;


    function __construct() {
      $this->TextSign = '';
      $this->code = 'emailexport';
      $this->title = MODULE_EMAILEXPORT_TEXT_TITLE;
      $this->description = MODULE_EMAILEXPORT_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_EMAILEXPORT_SORT_ORDER')) ? MODULE_EMAILEXPORT_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_EMAILEXPORT_STATUS') and MODULE_EMAILEXPORT_STATUS == 'True') ? true : false);
    }

    function get_cstatus_name($id){
    	foreach($this->groups as $k=>$group){
    		if($group['id'] == $id){
    			return $group['text']; 
    		}
    	}
    }
    
    function get_newsletter_active($customers_email_address){
    	$nl_active_query_raw = sprintf("SELECT mail_id FROM newsletter_recipients WHERE customers_email_address='%s' AND mail_status=1",$customers_email_address);
    	$nl_active_query = xtc_db_query($nl_active_query_raw);
    	if(xtc_db_num_rows($nl_active_query))
    		return 'j';
    	else
    		return 'n';
    }

    function process() {
        @xtc_set_time_limit(0);
        $basics = new basics;

        $header = array('cID','Kundennummer','Vorname','Nachname','Land','E-Mail','Newsletter','Kundengruppe');
        $csv_string = implode(CSV_SEPARATOR,$header)."\r\n";
    	$this->groups = xtc_get_customers_statuses();
	if(isset($_GET['step'])){
		$selected_group = (int)xtc_db_input($_GET['export_group']);
		if(ADMIN_GROUP_ID == $selected_group) die('CANNOT EXPORT ADMINGROUP');
		$where = " customers_status = '".$selected_group."' and customers_id!='".KASSE_USER."' ";

		$limit1 = (int)$_GET['step'] * MAX_ITEMS_PER_EXPORT;
		$limit2 = $limit1 + MAX_ITEMS_PER_EXPORT;
		
		$nl_query_raw = sprintf(
			"SELECT c.customers_id,co.countries_name,c.customers_cid,c.customers_email_address,c.customers_firstname,c.customers_lastname, c.customers_status
				FROM customers c LEFT JOIN address_book ab USING(customers_id)
				LEFT JOIN countries co ON ab.entry_country_id = co.countries_id
				WHERE c.customers_default_address_id = ab.address_book_id and %s ORDER BY c.customers_id LIMIT %s,%s",
			$where,$limit1,$limit2
		);
	}else{
		$selected_groups = $_POST['export_group'];
		$where = " customers_status != '".ADMIN_GROUP_ID."' and customers_id!='".KASSE_USER."' ";
		$where_filter = '';
		for($i=0;$i<sizeOf($selected_groups);$i++){
			if($selected_groups[$i] != ''){
				$where_filter .= " customers_status = '".$selected_groups[$i]."' OR ";
			}
		}
		if($where_filter != ''){
			$where_filter = substr($where_filter,0,strlen($where_filter)-4);
			$where .= " AND ($where_filter) "; 
		}
		$nl_query_raw = sprintf(
			"SELECT c.customers_id,co.countries_name,c.customers_cid,c.customers_email_address,c.customers_firstname,c.customers_lastname, c.customers_status
				FROM customers c LEFT JOIN address_book ab USING(customers_id)
				LEFT JOIN countries co ON ab.entry_country_id = co.countries_id
				WHERE c.customers_default_address_id = ab.address_book_id and %s",
			$where
		);
	}
		$nl_query = xtc_db_query($nl_query_raw);
		while($nl = xtc_db_fetch_array($nl_query)){
			$add_item = array(
				$nl['customers_id'],
				$nl['customers_cid'],
				trim($nl['customers_firstname']),
				trim($nl['customers_lastname']),
				$nl['countries_name'],
				$nl['customers_email_address'],
				$this->get_newsletter_active($nl['customers_email_address']),
				$this->get_cstatus_name($nl['customers_status'])
			);
		    $csv_string .= implode(CSV_SEPARATOR,$add_item)."\r\n";
		}
		
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		if(isset($_GET['step'])){
			$filename = sprintf('emailaddressexport_PART%s_%s.csv',(int)$_GET['step'],$crypt_file);
		}else{
			$filename = sprintf('emailaddressexport_%s.csv',$crypt_file);
		}
		$filepath = \main::get_exportdata_path();
		$basics->create_file($filepath.$filename,$csv_string);
		$basics->zip_file($filepath,$filename,$filename.'.zip',true);

		$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
		unlink($filepath.$filename.'.zip');
		// send File to Browser
		if(isset($_GET['step'])){
			$file = 'EMAILADRESSEN_PART_'.((int)$_GET['step']+1).'-'.date('Y-m-d_H_i_s').'.zip';
		}else{
			$file = 'EMAILADRESSEN_'.date('Y-m-d_H_i_s').'.zip';
		}
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Content-disposition: attachment; filename=' . $file);
		echo $file_contents;
		exit;
    }


    function display() {
    	$js = '<script type="text/javascript">';
    	$js .= 'function group_select(active_element){';
    	$js .= '	dom = document.forms["modules"];';
    	$js .= '	group_field_name = "export_group[]";';
    	$js .= "	if(active_element.value == '' && active_element.checked == true){
    					for(i=0;i<dom.elements[group_field_name].length;i++){
    						el = dom.elements[group_field_name][i];
    						if(el.value != '') el.checked = false;
    					}
    				}
    				if(active_element.value != ''){
    					for(i=0;i<dom.elements[group_field_name].length;i++){
    						el = dom.elements[group_field_name][i];
    						if(el.value == '') el.checked = false;
    					}
    				}
    		   ";
    	$js .= '}';
    	$js .= '</script>';
    	$groups = xtc_get_customers_statuses();
    	$group_selector = '<input type="checkbox" name="export_group[]" onclick="group_select(this);" value="" checked>&nbsp;Alle<br />';
    	foreach($groups as $k=>$group){
			$number_of_addresses_query_raw = sprintf(
				"SELECT count(1) AS anz FROM customers WHERE customers_status='%s'",
				$group['id']
			);
			$num = 0;
			$number_of_addresses_query = yes_db_query($number_of_addresses_query_raw);
			if($number_of_addresses_query){
				$number_of_addresses = current($number_of_addresses_query);
				$num = $number_of_addresses['anz'];
			}
			$export_input_size_rest = 0;
			if($num > 0){
				$export_input_size = ($num-($num % MAX_ITEMS_PER_EXPORT))/MAX_ITEMS_PER_EXPORT;
				if(($num % MAX_ITEMS_PER_EXPORT) > 0){
					$export_input_size++;
					$export_input_size_rest = ($num % MAX_ITEMS_PER_EXPORT);
				}
			}else{
				$export_input_size = 1;
			}

	    		if($group['id'] != ADMIN_GROUP_ID){
				if($export_input_size < 2){
		    			$group_selector .= '<input type="checkbox" name="export_group[]" onclick="group_select(this);" value="'.$group['id'].'">&nbsp;'.$group['text'].' ('.$num.')<br />';
				}else{
					$group_selector .= '<br />&nbsp;&nbsp;<b>'.$group['text'].' ('.$num.')</b><br />';
					for($eis=0;$eis<($export_input_size-1);$eis++){
						$title = sprintf('&nbsp;&nbsp;DOWNLOAD&nbsp;[%s-%s]',
							($eis*MAX_ITEMS_PER_EXPORT),
							(($eis*MAX_ITEMS_PER_EXPORT)+MAX_ITEMS_PER_EXPORT)
						);
						$group_selector .= '&nbsp;&nbsp;<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'action=save&step='.$eis.'&export_group='.$group['id']).'" title="'.$title.'">'.$title.'</a><br />';
					}
					if($export_input_size_rest > 0){
						$title = sprintf('&nbsp;&nbsp;DOWNLOAD&nbsp;[%s-%s]',
							($eis*MAX_ITEMS_PER_EXPORT),
							(($eis*MAX_ITEMS_PER_EXPORT)+$export_input_size_rest)
						);
						$group_selector .= '&nbsp;&nbsp;<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'action=save&step='.$eis.'&export_group='.$group['id']).'" title="'.$title.'">'.$title.'</a><br />';
					}
				}
    			}
    	}
		$array = array(
			'text' => $js.'<br />'.xtc_draw_separator('pixel_black.gif').'<br /><br />'.MODULE_EMAILEXPORT_GROUP.'<br />' . $group_selector.'<br />'.MODULE_EMAILEXPORT_EXPORTTEXT.'<br /><br />'.xtc_image_submit('button_export.gif',IMAGE_EXPORT) .
                      '<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=emailexport').'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>');
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_EMAILEXPORT_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_EMAILEXPORT_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_EMAILEXPORT_STATUS');
    }
  }
