<?php
/* --------------------------------------------------------------
   $Id: group_prices.php,v 1.24 2018/06/04 09:26:24 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(based on original files from OSCommerce CVS 2.2 2002/08/28 02:14:35); www.oscommerce.com
   (c) 2003	 nextcommerce (group_prices.php,v 1.16 2003/08/21); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------
   based on Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   --------------------------------------------------------------*/
require_once(DIR_FS_INC . 'xtc_get_tax_rate.inc.php');
//require_once(DIR_FS_INC . 'xtc_format_price.inc.php');

require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
$xtPrice = new xtcPrice(DEFAULT_CURRENCY,$_SESSION['customers_status']['customers_status_id']);

$i = 0;
$prices_smarty = new yesSmarty;
$prices_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$prices_smarty->assign('HEADING_PRICES_OPTIONS',HEADING_PRICES_OPTIONS);
$prices_smarty->assign('ek_price_link',xtc_href_link('distributor_products.php','pID='.$_GET['pID']));
$prices_smarty->assign('num_collies',sizeOf($collies));
if($admin_access['f_change_products_status'] == '1')
	$prices_smarty->assign('price_fixing_input',xtc_draw_checkbox_field('price_fixing','1',$pInfo->price_fixing));
$prices_smarty->assign('TEXT_PRODUCTS_PRICE',TEXT_PRODUCTS_PRICE);

$country_id = STORE_COUNTRY;
$zone_id = 0;
$tax_class_id = yes_eu_oss_get_products_tax_class_id($pInfo->products_id, $country_id, $zone_id);

$preisbindung_tax_rate = xtc_get_tax_rate($tax_class_id, $country_id, $zone_id);
  // calculate brutto price for display
$preisbindung_aktiv = false;
if(COLLI_ACTIVE){
    if(sizeOf($collies)>0){
        if(xtc_is_preisbindung($pInfo->products_id)){
            $preisbindung_aktiv = true;
            $prices_smarty->assign('preisbindung_aktiv',$preisbindung_aktiv);
            $preisbindung_tax_rate = xtc_get_product_collies_tax_value($collies, $country_id, $zone_id);
        }
    }
}

if (PRICE_IS_BRUTTO=='true'){
    $products_price = xtc_round($pInfo->products_price*((100+$preisbindung_tax_rate)/100),PRICE_PRECISION);
} else {
    $products_price = xtc_round($pInfo->products_price,PRICE_PRECISION);
}
if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')){
    $_price = number_format($products_price,2,'.','');
}
$prices_smarty->assign('price_input',xtc_draw_input_field('products_price', $_price, $parameters = '', $required = false, $type = 'text', $reinsert_value = false));

$prices_smarty->assign('PRICE_IS_BRUTTO',PRICE_IS_BRUTTO);
$prices_smarty->assign('TEXT_PRODUCTS_DISCOUNT_ALLOWED',TEXT_PRODUCTS_DISCOUNT_ALLOWED);
$prices_smarty->assign('TEXT_PRODUCTS_TAX_CLASS',TEXT_PRODUCTS_TAX_CLASS);
$prices_smarty->assign('SEPARATOR',xtc_draw_separator('pixel_trans.gif', '1', '10'));
if(PRICE_IS_BRUTTO == 'true'){
    $prices_smarty->assign('netto',TEXT_NETTO .'<b>'.$xtPrice->xtcFormat($pInfo->products_price,true).'</b>');
}

$prices_smarty->assign('formated_price',number_format($products_price,2,',','.'));
// im artikellisting keine staffelpreise
if(isset($USE_NO_STAFFELPREISE) and $USE_NO_STAFFELPREISE == 1){
    $prices_smarty->assign('USE_NO_STAFFELPREISE',$USE_NO_STAFFELPREISE);
}
$group_data = [];
$group_values_array = xtc_get_customers_statuses();
foreach($group_values_array as $group_values) {
    if($group_values['id'] === 0){
        continue;
    }
    $group_data[] = array(
        'STATUS_NAME' => $group_values['text'],
        'STATUS_IMAGE' => $group_values['csa_image'],
        'STATUS_ID' => $group_values['id']
    );
}
if(!$preisbindung_aktiv){
    // KEINE PREISBINDUNG, GRUPPEN/SPEZIALPREISE ERLAUBT
    $group_array = array();
    for ($col = 0, $n = sizeof($group_data); $col < $n+1; $col++) {
        if (!isset($group_data[$col]['STATUS_NAME']) or empty($group_data[$col]['STATUS_NAME'])) {
            continue;
        }
        $group_array[$col]['name'] = $group_data[$col]['STATUS_NAME'];
        $group_array[$col]['STATUS_ID'] = $group_data[$col]['STATUS_ID'];
        $group_price_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
            $group_array[$col]['STATUS_ID'], $pInfo->products_id
        );

        $values = array();
        foreach($group_price_items as $GPI) {
            // qty = 1 ist der Artikelpreis
            if($GPI->quantity == 1){
                if (PRICE_IS_BRUTTO=='true'){
                    $products_price = number_format(xtc_round(
                        $GPI->personal_offer
                        *((100+$preisbindung_tax_rate)/100),PRICE_PRECISION),2,'.','');
                } else {
                    $products_price = number_format(xtc_round($GPI->personal_offer,PRICE_PRECISION),2,'.','');
                }
                $GPI_one = $GPI;
                continue;
            }
            $val = $GPI->toArray();
            if (PRICE_IS_BRUTTO=='true'){
                $st_products_price = xtc_round($val['personal_offer']*((100+$preisbindung_tax_rate)/100),PRICE_PRECISION);
                $val['price_netto'] = ' <br /><i>'.TEXT_NETTO . $xtPrice->xtcFormat( $val['personal_offer'],true) .'</i>  ';
            } else {
                $st_products_price = xtc_round($val['personal_offer'],PRICE_PRECISION);
            }
            $val['products_price'] = number_format($st_products_price,2,',','.');

            // yes accounting
            if( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')){
                $val['delete_link'] = xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&function=delete&quantity=' . $GPI->quantity . '&statusID=' . $group_data[$col]['STATUS_ID'] . '&action=new_product&pID=' . $_GET['pID']);
                $val['delete_icon'] = xtc_image('images/minus.gif', IMAGE_DELETE,12,12,'class="delete_staffelprice" id="IMGSTAFFEL'.$group_data[$col]['STATUS_ID'].'_'.$GPI->quantity.'"');
            }
            $values[] = $val;
        }
        $group_array[$col]['staffel_values'] = $values;
        // yes accounting
        $btn_class = (sizeOf($values)) ? 'ui-state-highlight' : 'ui-state-default';
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')) {
            $group_array[$col]['price'] = xtc_draw_input_field('products_price_' . $group_data[$col]['STATUS_ID'], $products_price);
        }else{
            $group_array[$col]['price'] = '<a href="#" onClick="alert(\''.TEXT_GROUP_PRICES_MISSING_AUTH_EDIT.'\');">'.number_format($products_price,2,',','.').'</a>&nbsp;';
        }

        if (PRICE_IS_BRUTTO=='true' && $GPI->personal_offer <> 0){
            $group_array[$col]['price_netto'] = TEXT_NETTO . '<b>'.$xtPrice->xtcFormat($GPI_one->personal_offer,true) .'</b>  ';
        }
        if (isset($_GET['pID']) and $_GET['pID'] != '') {
            $group_array[$col]['staffel'] =  ' <button type="button" id="'.$group_data[$col]['STATUS_ID'].'" class="'.$btn_class.' ui-corner-all edit_staffel">' . TXT_STAFFELPREIS.'</button>';
        }

        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')) {
            $group_array[$col]['edit_staffel'] =  array(
                'INPUT_QUANTITY_LABEL'=>TXT_STK,
                'INPUT_QUANTITY'=>xtc_draw_small_input_field('products_quantity_staffel_'.$group_data[$col]['STATUS_ID'], '0'),
                'INPUT_PRICE_LABEL'=>TXT_PRICE,
                'INPUT_PRICE'=>xtc_draw_input_field('products_price_staffel_'.$group_data[$col]['STATUS_ID'], '0,00'),
                'ID'=>$group_data[$col]['STATUS_ID']
            );
        }else{
            $group_array[$col]['edit_staffel'] = array(
                'error'=>TEXT_GROUP_PRICES_MISSING_AUTH_ADD
            );
        }
    } // END for ($col = 0, $n = sizeof($group_data); $col < $n+1; $col++)
    $prices_smarty->assign('group_array',$group_array);
    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')) {
        $prices_smarty->assign('delete_staffel_base_link',xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&function=delete&ajax=1&action=new_product&pID=' . $_GET['pID']));
        $prices_smarty->assign('add_staffel_base_link',xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&function=add&ajax=1&action=new_product&pID=' . $_GET['pID']));
        $prices_smarty->assign('update_staffel_base_link',xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&function=update_staffelprice&ajax=1&action=new_product&pID=' . $_GET['pID']));
    }
    // yes accounting
    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')) {
        $prices_smarty->assign('products_discount_allowed',xtc_draw_input_field('products_discount_allowed', $pInfo->products_discount_allowed)); 
    }else{
        $prices_smarty->assign('products_discount_allowed',($pInfo->products_discount_allowed == 1) ? 'erlaubt' : 'nicht erlaubt</a>'); 
    }
} // END IF !PREISBINDUNG

  // yes accounting
if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_change_products_price'] == '1')) {
    if($_GET['pID']){
        if($tax_class_id > 0)
            $products_tax_class_id = $tax_class_id;
        else
            $products_tax_class_id = 1;
    }else{
            $products_tax_class_id = '1';
    }
    if(!$preisbindung_aktiv){
        $prices_smarty->assign('edit_products_tax_class_id',xtc_draw_pull_down_menu('products_tax_class_id', $tax_class_array, $products_tax_class_id));
    }else{
        $prices_smarty->assign('products_tax_class_id',$preisbindung_tax_rate);
    }
}else{
    $rate = '';
    if(sizeOf($collies)==0){
        $rate = xtc_get_tax_rate($_GET['pID'], $country_id, $zone_id).'%';
    }
    $prices_smarty->assign('rate',$rate);
}
$prices_smarty->assign(array(
    'TEXT_COPY_STAFFELPREISE'=>TEXT_COPY_STAFFELPREISE,
    'PRODUCTS_ID'=>(int)xtc_db_input($_GET['pID'])
));
$phtml = $prices_smarty->fetch(DIR_FS_ADMIN.'templates/group_prices.html');
$smarty->assign('group_prices',$phtml);
