<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require('includes/classes/order.php');
require('includes/classes/class.payment.php');
require("includes/classes/class.csv.php");
require("includes/classes/split_page_results_array.php");

$PAY = new incoming_payment;
// yes accounting
$admin_access = main::get_admin_access();

if (isset($_REQUEST['date_start'])) {
    $tabdatum = date('d.m.Y',strtotime($_REQUEST['date_start']));
} else {
    $tabdatum = date('d.m.Y');
}


if(!isset($_GET['search']) and !isset($_GET['search_pay_from']) ){
    $query_raw = sprintf("select ip.*,po.orders_id,po.created from incoming_payments ip left join payment_orders po on ip.id=po.payment_id where ip.buchungstag='%s'",
        $tabdatum
    );
}else{
    if(isset($_GET['search'])){
        if($_GET['search'] != ''){
            $searchwhere = ' (';
            for( $vwz = 1; $vwz<15; $vwz++ ){
                $searchwhere .= 'verwendungszweck'.$vwz." like '%".xtc_db_input($_GET['search'])."%'";
                if($vwz<14){
                    $searchwhere .= " or ";
                }
            }
            $searchwhere .= ')';
        }
        if(isset($_REQUEST['search_vwz_date'])){
            if($searchwhere != ''){
                $searchwhere .= ' AND ';
            }
            $searchwhere .= sprintf(" (buchungstag_date >= '%s' AND buchungstag_date <= '%s' )",
                xtc_db_input($_REQUEST['search_date_start']),
                xtc_db_input($_REQUEST['search_date_end'])
            );
        }
    }else if(isset($_GET['search_pay_from'])){
        if($_GET['search_pay_to'] > 0 or (isset($_GET['search_pay_from']) and strlen($_GET['search_pay_from']) > 0)){
            $searchwhere = sprintf(" (ip.betrag >= '%s' and ip.betrag <= '%s') ",
                str_replace(',','.',xtc_db_input($_GET['search_pay_from'])),
                str_replace(',','.',xtc_db_input($_GET['search_pay_to']))
            );
        }
    }
    $query_raw = "select ip.*,po.orders_id,po.created from incoming_payments ip left join payment_orders po on ip.id=po.payment_id";
    if( $searchwhere != ''){
            $query_raw .= " where $searchwhere";
    }
}
$stats_query = xtc_db_query($query_raw);  
while($stats = xtc_db_fetch_array($stats_query)){
	if(isset($_REQUEST['search_pay_date'])){
		$paydatum = split('\.',$stats['buchungstag']);
		$pay_time = strtotime($paydatum[2].'-'.$paydatum[1].'-'.$paydatum[0].' 00:00:00');

		$sdatum = strtotime($_REQUEST['report_date_start']);
		$edatum = strtotime($_REQUEST['report_date_end']);
		$stats['formatted_price'] = number_format($stats['betrag'],2,',','.');
		if($stats['orders_id']>0){ 
			$stats['order_str'] = '<a href="'.xtc_href_link('orders.php','action=edit&oID='.$stats['orders_id']).'" target="_blank"><u>'.$stats['orders_id'].'</u></a><br>Gebucht: '.date('d.m.y',strtotime($stats['created']));
		}
		$stats['vwz_str'] = '';
		for( $vwz = 1; $vwz<15; $vwz++ ){
			if($vwz != 2){
				if( trim( $stats['verwendungszweck'.$vwz] ) !=''  ) {
					$stats['vwz_str'] .= $stats['verwendungszweck'.$vwz]."<br />\n";
				}
			}
		}
		if( $pay_time >= $sdatum and $pay_time <= $edatum ){
			$products_data[] = $stats;
		}
	}else{
		if($stats['orders_id']>0){ 
			$stats['order_str'] = '<a href="'.xtc_href_link('orders.php','action=edit&oID='.$stats['orders_id']).'" target="_blank"><u>'.$stats['orders_id'].'</u></a><br>Gebucht: '.date('d.m.y',strtotime($stats['created']));
		}
		$stats['vwz_str'] = '';
		for( $vwz = 1; $vwz<15; $vwz++ ){
			if($vwz != 2){
				if( trim( $stats['verwendungszweck'.$vwz] ) !=''  ) {
					$stats['vwz_str'] .= $stats['verwendungszweck'.$vwz]."<br />\n";
				}
			}
		}
		$stats['formatted_price'] = number_format($stats['betrag'],2,',','.');
  		$products_data[] = $stats;
	}
  }
  $stats_split = new splitPageResultsArray( $_GET['page'], $view_limit=MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $products_data, $stats_query_numrows);
  
  if(isset($_REQUEST['csv_export']) and $_REQUEST['csv_export'] == 1){
	  $csv_array = array();
	  $csv_array[] = array(
		  'Betrag','Buchungstag','Re-Nr','Gebucht','Name','Verwendungszweck'
	  );
	  foreach($products_data as $ip){
		  $vwz_string = '';
		  for( $vwz = 1; $vwz<15; $vwz++ ){
				if($vwz != 2){
					if( trim( $ip['verwendungszweck'.$vwz] ) !=''  ) {
						$vwz_string .= $ip['verwendungszweck'.$vwz]." ";
					}
				}
		  }
		  $csv_array[] = array(
			number_format($ip['betrag'],2,',','.'),
			$ip['buchungstag'],
			$ip['orders_id'],
			date('d.m.y',strtotime($ip['created'])),
			$ip['verwendungszweck2'],
			$vwz_string
		  );
	  }
	  $output = '';
	  foreach($csv_array as $row){
		  $output .= implode("\t",$row);
		  $output .= "\r\n";
	  }
	  header('Content-type: application/x-octet-stream');
	  header('Content-disposition: attachment; filename=Zahlungseingaenge.csv');
	  echo $output;
	  exit;
}
$smarty = new yesSmarty;

$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$buttons = array();

$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE  ,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));

if(is_array($products_data)){
	$smarty->assign('products_data',$products_data);
	if($admin_access['incoming_payments'] == 1){
		$smarty->assign('STATS_LINK',xtc_href_link('incoming_payments_stats.php',xtc_get_all_get_params().'csv_export=1'));
	}
}
$smarty->assign(array(
    'SEPARATOR'=>xtc_draw_separator(),
    'INPUT_SEARCH'=>xtc_draw_input_field('search',@$_GET['search'],'size="15"'),
    'INPUT_PRICE_FROM'=>xtc_draw_input_field('search_pay_from',@$_GET['search_pay_from'],'size="5"'),
    'INPUT_PRICE_TO'=>xtc_draw_input_field('search_pay_to',@$_GET['search_pay_to'],'size="5"'),
    'SPLIT'=>$stats_split->display_count($stats_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, @$_GET['page'], 'Angezeigt werden %s bis %s von insgesamt %s Datens&auml;tzen',xtc_get_all_get_params(array('page'))).
            $stats_split->display_links($stats_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, MAX_DISPLAY_PAGE_LINKS, @$_GET['page'], xtc_get_all_get_params(array('page'))),
    'PARAM_DATE_START'=>$_REQUEST['date_start']??'',
    'PARAM_REPORT_DATE_START'=>$_REQUEST['report_date_start']??'',
    'PARAM_REPORT_DATE_END'=>$_REQUEST['report_date_end']??'',
    'PARAM_SEARCH_DATE_START'=>$_REQUEST['search_date_start']??'',
    'PARAM_SEARCH_DATE_END'=>$_REQUEST['search_date_end']??'',
    'INPUT_SEARCH_PAYDATE'=>xtc_draw_checkbox_field('search_pay_date','1',((isset($_REQUEST['search_pay_date']) and $_REQUEST['search_pay_date'] == 1)?true:false)),
    'INPUT_SEARCH_VWZ_DATE'=>xtc_draw_checkbox_field('search_vwz_date','1',((isset($_REQUEST['search_vwz_date']) and $_REQUEST['search_vwz_date'] == 1)?true:false)),
    'REPORT_DAY_DATE'=>REPORT_DAY_DATE

));
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$smarty->display('incoming_payments_stats.html');
?>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
