<?php
/* --------------------------------------------------------------
  $Id: stats_auctionfees.php,v 1.12 2017/01/09 09:17:30 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(stats_products_purchased.php,v 1.27 2002/11/18); www.oscommerce.com 
   (c) 2003	 nextcommerce (stats_products_purchased.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');


require(DIR_WS_CLASSES . 'currencies.php');
require(DIR_WS_CLASSES . 'class.csv.php');
$currencies = new currencies();

// default detail no detail
$srDefaultDetail = 0;
// default view (daily)
$srDefaultView = 1;
// default export
$srDefaultExp = 0;
// default sort
$srDefaultSort = 4;

// report views (1: yearly 2: monthly 3: weekly 4: daily)
if ( ($_GET['report']) && (xtc_not_null($_GET['report'])) ){    
  $srView = $_GET['report'];
}
if ($srView < 1 || $srView > 4) {
  $srView = $srDefaultView;
}

  // detail
if ( ($_GET['detail']) && (xtc_not_null($_GET['detail'])) ){    
  $srDetail = $_GET['detail'];
}
if ($srDetail < 0 || $srDetail > 2) {
  $srDetail = $srDefaultDetail;
}
  
// report views (1: yearly 2: monthly 3: weekly 4: daily)
if ( ($_GET['export']) && (xtc_not_null($_GET['export'])) ){    
  $srExp = $_GET['export'];
}
if ($srExp < 0 || $srExp > 2) {
    $srExp = $srDefaultExp;
}
  
  // item_level
if ( ($_GET['max']) && (xtc_not_null($_GET['max'])) ) {
  $srMax = $_GET['max'];
}
if (!is_numeric($srMax)) {
  $srMax = 0;
}
      
// order status
if ( ($_GET['status']) && (xtc_not_null($_GET['status'])) ){    
  $srStatus = $_GET['status'];
}
if (!is_numeric($srStatus)) {
  $srStatus = 0;
}
  
// check start and end Date
$startDate = "";
$startDateG = 0;
if ( ($_GET['startD']) && (xtc_not_null($_GET['startD'])) ){    
  $sDay = $_GET['startD'];
  $startDateG = 1;
} else {
  $sDay = 1;
}

if ( ($_GET['startM']) && (xtc_not_null($_GET['startM'])) ){    
  $sMon = $_GET['startM'];
  $startDateG = 1;
} else {
  $sMon = 1;
}
if ( ($_GET['startY']) && (xtc_not_null($_GET['startY'])) ){    
  $sYear = $_GET['startY'];
  $startDateG = 1;
} else {
  $sYear = date("Y");
}
if ($startDateG) {
  $startDate = mktime(0, 0, 0, $sMon, $sDay, $sYear);
} else {
  $startDate = mktime(0, 0, 0, date("m"), date('d'), date("Y"));
}
    
$endDate = "";
$endDateG = 0;
if ( ($_GET['endD']) && (xtc_not_null($_GET['endD'])) ) {
  $eDay = $_GET['endD'];
  $endDateG = 1;
} else {
  $eDay = 1;
}
if ( ($_GET['endM']) && (xtc_not_null($_GET['endM'])) ) {
  $eMon = $_GET['endM'];
  $endDateG = 1;
} else {
  $eMon = 1;
}
if ( ($_GET['endY']) && (xtc_not_null($_GET['endY'])) ) {
  $eYear = $_GET['endY'];
  $endDateG = 1;
} else {
  $eYear = date("Y");
}
if ($endDateG) {
  $endDate = mktime(0, 0, 0, $eMon, $eDay + 1, $eYear);
} else {
  $endDate = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y"));
}
  
  
if($_GET['action'] == 'csv'){
    $path = \main::get_exportdata_path()."auctionfees/";
    if(!is_dir($path)){
      mkdir($path);
    }
    $datei = 'gebuehren.csv';
    $filename = $path.'/'.$datei;

    $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
    fclose($fh);
    $csv = new CSVfile($filename);
    $csv->open("w");
    $data[] = '"EBAYNR"';
    $data[] = '"STARTDATUM"';
    $data[] = '"ENDDATUM"';
    $data[] = '"DAUER"';
    $data[] = '"TITEL"';
    $data[] = '"GEBUEHR"';
    $csv->addRow($data);

    $all_items = \YES4Trade\Model\ebay_auctions::get_by_enddate_span($startDate, $endDate);
    foreach($all_items as $ea_item ){
      $data = array(
        '"'.$ea_item->ebay_id.'"',
        '"'.$ea_item->start_time.'"',
        '"'.$ea_item->end_time.'"',
        '"'.$ea_item->duration.'"',
        '"'.xtc_db_input($ea_item->title).'"',
        '"'.$ea_item->auction_fees.'"'
      );
      $csv->addRow($data);
    }
    $csv->close();
    
    $data = array();
    $datei = 'provision.csv';
    $filename = $path.'/'.$datei;
    
    $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
    fclose($fh);
    $csv = new CSVfile($filename);
    $csv->open("w");
    $data[] = '"EBAYNR"';
    $data[] = '"ENDDATUM"';
    $data[] = '"EINGESTELLT"';
    $data[] = '"TITEL"';
    $data[] = '"VERKAUFT"';
    $data[] = '"STARTPREIS"';
    $data[] = '"VERKAUFSPREIS"';
    $csv->addRow($data);
      
    $all_query = xtc_db_query("select ea.title,et.transactionprice,ea.quantity,et.ebayid,ea.end_time,et.quantitypurchased,ea.auctionprice,et.transactionprice from ebay_auctions ea,ebay_transactions et where UNIX_TIMESTAMP(ea.end_time) > $startDate && UNIX_TIMESTAMP(ea.end_time) < $endDate and et.ebayid=ea.ebay_id");
    while($all = xtc_db_fetch_array($all_query) ){
      $data = array(
        '"'.$all['ebayid'].'"',
        '"'.$all['end_time'].'"',
        '"'.$all['quantity'].'"',
        '"'.xtc_db_input($all['title']).'"',
        '"'.$all['quantitypurchased'].'"',
        '"'.$all['auctionprice'].'"',
        '"'.$all['transactionprice'].'"'
      );
      $csv->addRow($data);
    }
    $csv->close();
    
    exec("tar cvfz ".\main::get_exportdata_path()."fee.tar.gz ".$path);
    $messageStack->add_session('Archiv wurde erzeugt','success');
    xtc_redirect( xtc_href_link('stats_auctionfees.php',xtc_get_all_get_params(array('action'))) );
}
  

// zu unique um das extra in die yes4trade ebay_auctions Klasse zu packen
$query_raw = "select SUM(auction_fees) as sumfee, COUNT(id) as numauctions, SUM(quantity) as sumqty, SUM(quantity_sold) as sumsold from ebay_auctions where UNIX_TIMESTAMP(end_time) > $startDate && UNIX_TIMESTAMP(end_time) < $endDate";
$stats_query = xtc_db_query($query_raw);
$stats = xtc_db_fetch_array($stats_query);
if($_GET['details']=='1'){
  $det_raw = "select et.transactionprice from ebay_auctions ea,ebay_transactions et where UNIX_TIMESTAMP(ea.end_time) > $startDate && UNIX_TIMESTAMP(ea.end_time) < $endDate and et.ebayid=ea.ebay_id";
  $det_query = xtc_db_query($det_raw);
  $fee = array(
    '< 50'=>0,
    '> 50'=>0,
    '> 500'=>0,
    '> 2000'=>0
  );
  while($details = xtc_db_fetch_array($det_query)){
		if((float)$details['transactionprice'] < 50.01)
			$matrix = '1';
		if((float)$details['transactionprice'] >= 50.01 and (float)$details['transactionprice'] < 500.01)
			$matrix = '2';
		if((float)$details['transactionprice'] >= 500.01 and (float)$details['transactionprice'] < 2000.01)
			$matrix = '3';
		if((float)$details['transactionprice'] > 2000)
			$matrix = '4';
			
		switch($matrix){
			case '1':
				$fee['< 50'] += (($details['transactionprice']/100)*5);
				break;
			case '2':
				$rest = $details['transactionprice'] - 50.01;
				if($rest > 0){
					$rest_fee = (($rest/100)*4);
				}
				$fee['> 50'] += (2.50 + $rest_fee);
				break;
			case '3':
				$rest = $details['transactionprice'] - 500.01;
				if($rest > 0){
					$rest_fee = (($rest/100)*2);
				}
				$fee['> 500'] += (20.50 + $rest_fee);
				break;
			case '4':
				$fee['> 2000'] += 50.50;
				break;
		}
	}
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<div class="pageHeading">Einstellgeb&uuml;hren Ebay</div>

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
<tr>
	<td valign="top">
		<table border="0" width="100%" cellspacing="0" cellpadding="2">
      		<tr>
        		<td class="main">
	
<table width="100%" border="0" width="350">
<?php
    if ($srExp < 1) {
?>
        <tr>
          <td colspan="2">
            <form action="" method="get">
              <table border="0" style="border: 1px solid; border-color: #cccccc;" width="350" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="menuBoxHeading">
Report Startdatum<br>
                    <select name="startD" size="1">
<?php
      if ($startDate) {
        $j = date("j", $startDate);
      } else {
        $j = 1;
      }
      for ($i = 1; $i < 32; $i++) {
?>
                        <option<?php if ($j == $i) echo " selected"; ?>><?php echo $i; ?></option>
<?php
      }
?>
                    </select>
                    <select name="startM" size="1">
<?php
      if ($startDate) {
        $m = date("n", $startDate);
      } else {
        $m = 1;
      }
      for ($i = 1; $i < 13; $i++) {
?>
                      <option<?php if ($m == $i) echo " selected"; ?> value="<?php echo $i; ?>"><?php echo yes_strftime("%B", mktime(0, 0, 0, $i, 1)); ?></option>
<?php
      }
?>
                    </select>
                    <select name="startY" size="1">
<?php
      if ($startDate) {
        $y = date("Y") - date("Y", $startDate);
      } else {
        $y = 0;
      }
      for ($i = 10; $i >= 0; $i--) {
?>
                      <option<?php if ($y == $i) echo " selected"; ?>><?php echo date("Y") - $i; ?></option>
<?php
    }
?>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td class="menuBoxHeading">
Report Enddatum<br>
                    <select name="endD" size="1">
<?php
    if ($endDate) {
      $j = date("j", $endDate - 60* 60 * 24);
    } else {
      $j = date("j");
    }
    for ($i = 1; $i < 32; $i++) {
?>
                      <option<?php if ($j == $i) echo " selected"; ?>><?php echo $i; ?></option>
<?php
    }
?>
                    </select>
                    <select name="endM" size="1">
<?php
    if ($endDate) {
      $m = date("n", $endDate - 60* 60 * 24);
    } else {
      $m = date("n");
    }
    for ($i = 1; $i < 13; $i++) {
?>
                      <option<?php if ($m == $i) echo " selected"; ?> value="<?php echo $i; ?>"><?php echo yes_strftime("%B", mktime(0, 0, 0, $i, 1)); ?></option>
<?php
    }
?>
                    </select>
                    <select name="endY" size="1">
<?php
    if ($endDate) {
      $y = date("Y") - date("Y", $endDate - 60* 60 * 24);
    } else {
      $y = 0;
    }
    for ($i = 10; $i >= 0; $i--) {
?>
                      <option<?php if ($y == $i) echo " selected"; ?>><?php echo
date("Y") - $i; ?></option><?php
    }
?>
                    </select>
                        <?php 
                        $alt = (defined('IMAGE_BUTTON_UPDATE_CART')) ? IMAGE_BUTTON_UPDATE_CART : 'Aktualisieren';
                        echo xtc_image_submit('button_update.gif', $alt); 
                        ?>
	    
		  </td>
                </tr>
              </table>
            </form>
          </td>
        </tr>
<?php
  } // end of ($srExp < 1)
?>
</table>

<?php if( $_GET['startD']>0){ ?>
<p>F&uuml;r den Zeitraum fielen Einstellgeb&uuml;hren in H&ouml;he von <b><?php echo number_format($stats['sumfee'],2,',',''); ?> <?php echo DEFAULT_CURRENCY; ?></b> an, bei insgesamt <b><?php echo $stats['numauctions']; ?></b> Auktionen.</p>
<p>In diesem Zeitraum wurden insgesamt <b><?php echo $stats['sumqty']; ?></b> Produkte bei Ebay in Auktionen angeboten. Davon wurden <b><?php echo $stats['sumsold']; ?></b> verkauft.</p>

<?php if(!$_GET['details']  == '1') {
	echo '<p><a href="'.xtc_href_link('stats_auctionfees.php',xtc_get_all_get_params(array('details')).'details=1').'"><u>Details anzeigen</u></a></p>';
}
?>


<?php if($_GET['details']  == '1') {
?>
<br><b>Verkaufsprovisionen</b><br>
<table border="0" class="formArea">
<?php
$gesamt = 0;
foreach($fee as $k=>$v){
	echo '<tr><td class="main"><b>VK Preis '.$k .':</b></td><td class="main" align="right">&nbsp;'.number_format($v,2,',','').' '.DEFAULT_CURRENCY.'</td></tr>';
	$gesamt += $v;
}
echo '<tr><td class="main"><b>Gesamt:</td><td class="main" align="right">'.number_format($gesamt,2,',','').' '.DEFAULT_CURRENCY.'</td></tr>';

} ?>
</table>
<?php } ?>
<hr>
<?php if($_GET['details']  == '1') {?>
<p><b>Gesamtsumme:</b> <?php echo number_format((float)$stats['sumfee'] + (float)$gesamt,2,',','');?> <?php echo DEFAULT_CURRENCY; ?></p>
<?php }else{ ?>
<p><b>Gesamtsumme ohne VK Provision:</b> <?php echo number_format((float)$stats['sumfee'] + (float)$gesamt,2,',','');?> <?php echo DEFAULT_CURRENCY;?></p>
<?php } ?>

<?php if( $_GET['startD']>0){ ?>
<br>
<table border="0" class="formArea">
<tr>
	<td class="main"><a href="<?php echo xtc_href_link('stats_auctionfees.php',xtc_get_all_get_params( array('action') ).'action=csv' ); ?>">CSV Datei aller Geb&uuml;hren dieses Zeitraums generieren.</a></td><td><a href="<?php echo xtc_href_link('stats_auctionfees.php',xtc_get_all_get_params( array('action') ).'action=csv' ); ?>"><?php echo xtc_image('images/icons/icon_edit.gif', 'Download'); ?></a></td>
</tr>
</table>
<?php } 
$file = \main::get_exportdata_path().'fee.tar.gz';
if(is_file($file) ){
	echo "<p><a href='$file'>ARCHIV VOM ".yes_strftime('%d.%m.%Y %H:%M:%S',fileatime($file))." DOWNLOADEN</a></p>";
}
?>

</td>
          </tr>
        </table></td>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
