<?php
chdir('../../');
include('includes/application_top.php');
include(DIR_WS_CLASSES . 'language.php');
require_once( DIR_WS_CLASSES.'currencies.php');
$currencies = new currencies();
include(DIR_FS_CATALOG.'lang/german/admin/incoming_payments.php');
include(DIR_WS_CLASSES . 'order.php');
include(DIR_FS_CATALOG.'admin/includes/config.ebayapi.inc.php');
include(DIR_FS_CATALOG.'admin/includes/classes/class.ebay.php');
$EBAYAPI = new ebayAPI;
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
$headers = array_change_key_case(getallheaders(), CASE_UPPER);
$rawBody = file_get_contents('php://input');

if(main::isDev(true)){
    $rawBody_examples = [
        '{"id":"WH-1BK99639E97258508-0LR25806X6924662P","event_version":"1.0","create_time":"2025-05-17T12:07:05.463Z","resource_type":"checkout-order","resource_version":"2.0","event_type":"CHECKOUT.ORDER.APPROVED","summary":"An order has been approved by buyer","resource":{"create_time":"2025-05-17T12:06:50Z","purchase_units":[{"reference_id":"default","amount":{"currency_code":"EUR","value":"2.07","breakdown":{}},"payee":{"email_address":"agri@yes-websolutions.de","merchant_id":"JEC2P2AVYQWZW"},"shipping":{"name":{"full_name":"Felix Agri"},"address":{"address_line_1":"Meiendorfer Weg 124B","admin_area_2":"Hamburg","postal_code":"22359","country_code":"DE"}}}],"links":[{"href":"https://api.paypal.com/v2/checkout/orders/66D89204AL252832F","rel":"self","method":"GET"},{"href":"https://api.paypal.com/v2/checkout/orders/66D89204AL252832F","rel":"update","method":"PATCH"},{"href":"https://api.paypal.com/v2/checkout/orders/66D89204AL252832F/capture","rel":"capture","method":"POST"}],"id":"66D89204AL252832F","payment_source":{"paypal":{"email_address":"noafelix.agri@gmail.com","account_id":"ZQBBW3NL2VWCW","account_status":"VERIFIED","name":{"given_name":"Felix","surname":"Agri"},"address":{"country_code":"DE"}}},"intent":"CAPTURE","payer":{"name":{"given_name":"Felix","surname":"Agri"},"email_address":"noafelix.agri@gmail.com","payer_id":"ZQBBW3NL2VWCW","address":{"country_code":"DE"}},"status":"APPROVED"},"links":[{"href":"https://api.paypal.com/v1/notifications/webhooks-events/WH-1BK99639E97258508-0LR25806X6924662P","rel":"self","method":"GET"},{"href":"https://api.paypal.com/v1/notifications/webhooks-events/WH-1BK99639E97258508-0LR25806X6924662P/resend","rel":"resend","method":"POST"}]}',
        '{"id":"WH-6FW85480104715949-38845633S83888835","event_version":"1.0","create_time":"2025-05-17T12:07:12.945Z","resource_type":"capture","resource_version":"2.0","event_type":"PAYMENT.CAPTURE.COMPLETED","summary":"Payment completed for € 2.07 EUR","resource":{"id":"0MB93161VB604541F","amount":{"currency_code":"EUR","value":"2.07"},"final_capture":true,"seller_protection":{"status":"ELIGIBLE","dispute_categories":["ITEM_NOT_RECEIVED","UNAUTHORIZED_TRANSACTION"]},"seller_receivable_breakdown":{"gross_amount":{"currency_code":"EUR","value":"2.07"},"paypal_fee":{"currency_code":"EUR","value":"0.45"},"net_amount":{"currency_code":"EUR","value":"1.62"}},"status":"COMPLETED","supplementary_data":{"related_ids":{"order_id":"66D89204AL252832F"}},"payee":{"email_address":"agri@yes-websolutions.de","merchant_id":"JEC2P2AVYQWZW"},"create_time":"2025-05-17T12:07:09Z","update_time":"2025-05-17T12:07:09Z","links":[{"href":"https://api.paypal.com/v2/payments/captures/0MB93161VB604541F","rel":"self","method":"GET"},{"href":"https://api.paypal.com/v2/payments/captures/0MB93161VB604541F/refund","rel":"refund","method":"POST"},{"href":"https://api.paypal.com/v2/checkout/orders/66D89204AL252832F","rel":"up","method":"GET"}]},"links":[{"href":"https://api.paypal.com/v1/notifications/webhooks-events/WH-6FW85480104715949-38845633S83888835","rel":"self","method":"GET"},{"href":"https://api.paypal.com/v1/notifications/webhooks-events/WH-6FW85480104715949-38845633S83888835/resend","rel":"resend","method":"POST"}]}',
    ];
    $rawBody = $rawBody_examples[1];
}else{
    if(empty($rawBody)){
        yes_mail_debug('Paypal ipn2 Aufruf ohne Daten.'.print_r($_POST,true)."\n\n\nheaders:\n".print_r($headers,true)."\n\nrawBody:\n".$rawBody,
            false,'Paypal Webhook empty'
        );
        exit;
    }
}

$recipients_array = main::get_notice_recipients('incoming_payments');
$sender = 0; // absender fuer notizen 0=System
$pp = new \YES4Trade\Model\paypal_api();
try{
	$token = $pp->getAccess_token();
	$pp->set_access_token($token);
}catch(Exception $e){
	yes_mail_debug('Kann Paypal Instanz nicht laden. '.$e->getMessage()."\n\n\nheaders:\n".print_r($headers,true)."\n\nrawBody:\n".$rawBody,
        true, 'Paypal Webhook Access denied'
    );
	exit;
}

$webhook_id = $pp->get_webhook_id();
if($webhook_id === null){
	yes_mail_debug('Keine Webhook ID gespeichert.',true,'Paypal Webhook local missing');
	exit;
}
if(!main::isDev(true)){
    try{
        $isValid = $pp->verifyWebhook($headers, $rawBody, $webhook_id);
    }catch(Exception $e){
        yes_mail_debug('verifyWebhook failed. '.$e->getMessage()."\n\n\nheaders:\n".print_r($headers,true)."\n\nrawBody:\n".$rawBody."\n\nwebhook_id:".$webhook_id,
            true, 'Paypal Webhook verify failed'
        );
        exit;
    }
}else{
    $isValid = true; 
}
if($isValid){
    $hook = json_decode($rawBody);
    switch($hook->event_type){
        case 'CHECKOUT.ORDER.COMPLETED':
            break;
        case 'CHECKOUT.ORDER.APPROVED':
            $xtc_order_id = \YES4Trade\Model\paypal_api::get_yes_orders_id_from_paypal_order_id($hook->resource->id);
            if($xtc_order_id === null){
                // ist eh immer null, egal weil es nur eine info ist
                //yes_mail_debug('yes_ppp:webHook '.$hook->event_type.' erhalten aber kein Auftrag gefunden zur ID '.$hook->resource->id."\n\nWebhook Summary: ".$hook->summary,
                //    false, 'Paypal Webhook '.$hook->event_type.' unknown order allocation'
                //);
            }else{
                $os = \order::get_orders_status($xtc_order_id);
                if($os !== null){
                    \order::add_history_static($xtc_order_id, $os, false, $hook->summary);
                }
            }
            break;
        case 'PAYMENT.CAPTURE.COMPLETED':
            //yes_mail_debug("HOOK:\n".print_r($hook->resource,true)."\n\n\nPOST:\n".print_r($_POST,true)."\n\n\nGET:\n".print_r($_GET,true));
            $paypal_orderId = $hook->resource->supplementary_data->related_ids->order_id;
            $xtc_order_id = \YES4Trade\Model\paypal_api::get_yes_orders_id_from_paypal_order_id($paypal_orderId);
            if($xtc_order_id === null){
                yes_mail_debug('yes_ppp:webHook '.$hook->event_type.' erhalten aber kein Auftrag gefunden zur ID '.$hook->resource->id."\n\nWebhook Summary: ".$hook->summary."\n\n".print_r($hook,true),
                    true, 'Paypal Webhook '.$hook->event_type.' unknown order allocation'
                );
                yes_write_notice(
                    'Paypal Payment Status Complete Problem',
                    'Zur Paypal Order ID '.$paypal_orderId.' wurde gemeldet dass die Zahlung erfolgreich war, aber es wurde kein passender Auftrag im YES System gefunden. Bitte pr&uuml;fen Sie den Vorgang manuell.'."\n\n\n<br /><br /><pre><code>".print_r($hook,true).'</code></pre>',
                    $sender,$recipients_array
                );

            }else{
                $update_sql_array = [
                    'orders_status'=>intval(constant('ORDERS_STATUS_BEZAHLT')),
                    'last_modified'=>date('Y-m-d H:i:s'),
                    'date_payment'=>date('Y-m-d H:i:s')
                ];
                yes_db_perform(TABLE_ORDERS, $update_sql_array, 'update', [
                    'orders_id'=>$xtc_order_id
                ]);
                \order::add_history_static($xtc_order_id, $update_sql_array['orders_status'], false, $hook->summary);
            }
            break;
        case 'CHECKOUT.PAYMENT-APPROVAL.REVERSED':
            $xtc_order_id = \YES4Trade\Model\paypal_api::get_yes_orders_id_from_paypal_order_id($hook->resource->id);
            if($xtc_order_id === null){
                yes_mail_debug('yes_ppp:webHook '.$hook->event_type.' erhalten aber kein Auftrag gefunden zur ID '.$hook->resource->id."\n\nWebhook Summary: ".$hook->summary."\n\n".print_r($hook,true),
                    false, 'Paypal Webhook '.$hook->event_type.' no order allocation'
                );
                yes_write_notice(
                    'Paypal Payment Status Reversed Problem',
                    'Zur Paypal ID '.$hook->resource->id.' wurde gemeldet dass die Zahlung zurueckgezogen wurde, aber es wurde kein passender Auftrag im YES System gefunden. Bitte pr&uuml;fen Sie den Vorgang manuell.'."\n\n\n<br /><br /><pre><code>".print_r($hook,true).'</code></pre>',
                    $sender,$recipients_array
                );
            }else{
                $os = \order::get_orders_status($xtc_order_id);
                if($os === null){
                    yes_write_notice(
                        'Paypal Payment Status Reversed Problem',
                        'Zur Paypal ID '.$hook->resource->id.' wurde gemeldet dass die Zahlung zurueckgezogen wurde, aber es wurde kein passender Auftrag im YES System gefunden. Bitte pr&uuml;fen Sie den Vorgang manuell.'."\n\n\n<br /><br /><pre><code>".print_r($hook,true).'</code></pre>',
                        $sender,$recipients_array
                    );
                }else{
                    \order::add_history_static($xtc_order_id, $os, false, $hook->summary);
                    yes_write_notice(
                        'Paypal Payment Status Reversed',
                        'Zur Paypal ID '.$hook->resource->id.' wurde gemeldet dass die Zahlung zurueckgezogen wurde. Bitte pr&uuml;fen Sie den Vorgang zum Auftrag '.$xtc_order_id.'.'."\n\n\n<br /><br /><pre><code>".print_r($hook,true).'</code></pre>',
                        $sender,$recipients_array
                    );
                }
            }
            break;
        case 'PAYMENT.CAPTURE.REFUNDED':
            $query = yes_query("SELECT xtc_order_id FROM paypal WHERE invoice=:id",[
                'id'=>(string)$hook->resource->invoice_id
            ],true);
            if($query === false or $query === null){
                yes_write_notice(
                    'Paypal Payment Status Refunded Problem',
                    'Zur Paypal ID '.$hook->resource->id.' wurde gemeldet dass die Zahlung r&uuml;ckerstattet wurde, aber es wurde kein passender Auftrag im YES System gefunden. Bitte pr&uuml;fen Sie den Vorgang manuell.'."\n\n\n<br /><br /><pre><code>".print_r($hook,true).'</code></pre>',
                    $sender,$recipients_array
                );
            }else{
                $xtc_order_id = $query['xtc_order_id'];
                if($xtc_order_id<1){
                    die('refund: unbekannter Vorgang / keine Referenz in YES / nichts zu tun');
                }

                $os = \order::get_orders_status($xtc_order_id);
                if($os === null){
                    yes_write_notice(
                        'Paypal Payment Status Refunded Problem',
                        'Zur Paypal ID '.$hook->resource->id.' wurde gemeldet dass die Zahlung r&uuml;ckerstattet wurde, aber es wurde kein passender Auftrag im YES System gefunden. Bitte pr&uuml;fen Sie den Vorgang manuell.'."\n\n\n<br /><br /><pre><code>".print_r($hook,true).'</code></pre>',
                        $sender,$recipients_array
                    );
                }else{
                    yes_write_notice(
                        'Paypal Payment Status Refunded',
                        'Zur Paypal ID '.$hook->resource->id.' wurde gemeldet dass die Zahlung r&uuml;ckerstattet wurde. Bitte pr&uuml;fen Sie ggf. den Vorgang zum Auftrag '.$xtc_order_id,
                        $sender,$recipients_array
                    );
                    \order::add_history_static($xtc_order_id, $os, false, $hook->summary);
                }
            }
            break;
        default:
            yes_mail_debug('Unbekannter event Hook '.$hook->event_type."\n\nBody: ".print_r($hook,true),
                false, 'Paypal Webhook unknown event_type: '.$hook->event_type
            );
            exit;
            break;
    }
}else{
	yes_mail_debug('verifyWebhook NOT verified. '."\n\n\nheaders:\n".print_r($headers,true)."\n\nrawBody:\n".$rawBody."\n\nwebhook_id:".$webhook_id,
        true, 'Paypal Webhook not verified'
    );
}
die('Done');