<?php
/* -----------------------------------------------------------------------------------------
   $Id: checkout_process.php,v 1.68 2019/12/12 15:03:16 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2005 mario aspeleiter
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(checkout_process.php,v 1.128 2003/05/28); www.oscommerce.com
   (c) 2003	 nextcommerce (checkout_process.php,v 1.30 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License
    ----------------------------------------------------------------------------------------
   Third Party contribution:

   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
include( 'includes/application_top.php');
require_once( 'admin/includes/classes/class.storagequantity.php');
require_once( DIR_WS_CLASSES.'currencies.php');
// include needed functions
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_get_serial_number.inc.php');
require_once(DIR_FS_INC . 'xtc_calculate_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_address_label.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'changedatain.inc.php');
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
// initialize smarty
$smarty = new yesSmarty;
/*
$sql_data_array = ['customers_email_address'=>$csem];
yes_db_perform(TABLE_ORDERS, $sql_data_array);
die('HMMMMM');*/

// if the customer is not logged on, redirect them to the login page
$yes_amz_pay_guestaccount = false;
if (!isset ($_SESSION['customer_id'])) {
    if($_SESSION['payment'] == 'yes_amazon_pay' and isset($_SESSION['yes_amazon_pay_reference_id'])){
        $yes_amz_pay_guestaccount = true;
    }elseif($_SESSION['payment'] == 'yes_ppp'){
        $yes_ppp_guestaccount = true; // paypal express nur gast
    }else{
        xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
    }
}
if ($_SESSION['customers_status']['customers_status_show_price'] != '1') {
    xtc_redirect(xtc_href_link(FILENAME_DEFAULT, '', ''));
}
// BOF - Mario 02.05.2013 - CHECK SHIPPING
if(!isset($_SESSION['shipping'])){
    if(!isset($_SESSION['shipping']['id'])){
        // HAB BEISPIELE GEHABT BEIM TESTEN VON KLARNA, WO VERSANDKOSTENFREI
        // WAR UND GEMECKERT WURDE DASS KEINE VERSANDKOSTEN GEWAEHLT SIND
        // DARUM NOCH EINE EXTRA ABFRAGE OB shipping cost = 0 EXISTIERT
        if(!isset($_SESSION['shipping']['cost']) or $_SESSION['shipping']['cost']>0){
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING.'?error_message=Fehlende+Versandart'));
        }
    }
}
// EOF - Mario 02.05.2013 - CHECK SHIPPING

if (!isset ($_SESSION['sendto']) and !$yes_amz_pay_guestaccount and !$yes_ppp_guestaccount){
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
}
if ((xtc_not_null(MODULE_PAYMENT_INSTALLED)) && (!isset($_SESSION['payment']))){
    if(defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True'){
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
    }
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
}
// avoid hack attempts during the checkout procedure by checking the internal cartID
if (isset ($_SESSION['cart']->cartID) && isset ($_SESSION['cartID'])){
    if ($_SESSION['cart']->cartID != $_SESSION['cartID']){
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
}

$currencies = new currencies();
require(DIR_WS_CLASSES . 'order.php');
$order = new order('',$xtPrice);

$allowed_delivery_countries = main::get_allowed_delivery_countries();
$valid_country = false;
foreach($allowed_delivery_countries as $adc){
    if($order->delivery['country_id'] == $adc['id']){
        $valid_country = true;
        break;
    }
}
if(!$valid_country){
    $error = TEXT_INVALID_DELIVERY_COUNTRY;
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=' . urlencode($error), 'SSL', true, false));
}



// Stock Check
$any_out_of_stock = false;
$any_disabled = false;
if (STOCK_CHECK == 'true' or STOCK_ALLOW_CHECKOUT != 'true') {
	$same_products_qty = array();
	for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
		if(!isset($same_products_qty[ $order->products[$i]['id'] ])){
            $same_products_qty[ $order->products[$i]['id'] ] = 0;
        }
		
		$SQ = new products_quantity($order->products[$i]['id']);
		$qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
		// QTY und PRODUCTS_STATUS PRUEFEN
		if($qty_total<$order->products[$i]['qty']+$same_products_qty[ $order->products[$i]['id'] ] ){
			$any_out_of_stock = 1;
		}
		if(!$SQ->get_products_status() ){
			$any_disabled = 1;
		}
		$same_products_qty[ $order->products[$i]['id'] ] += $order->products[$i]['qty'];
	}
	// Out of Stock
	if (STOCK_CHECK == 'true' and $any_out_of_stock == true) {
		xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
	}
	if ( STOCK_ALLOW_CHECKOUT != 'true' and $any_disabled ) {
		xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
	}
}
// EOF Stock Check


// ONE-PAGE-CHECKOUT
if(isset($_POST['checkout_xajax']) and $_POST['checkout_xajax'] == 1) {
    $_SESSION['comments'] = strip_tags($_POST['comments']);
}
  // load selected payment module
require(DIR_WS_CLASSES . 'payment.php');

if (isset($_SESSION['credit_covers'])) {
    $_SESSION['payment']=''; //ICW added for CREDIT CLASS
}

$payment_modules = new payment($_SESSION['payment']);

// WORKAROUND UM UNERLAUBTE BEZAHLARTEN ENDGUELTIG ZU FILTERN!!!
// prueft den status, ob payment fuer land erlaubt
$payment_modules->update_status();
if(isset($_SESSION['payment'])){
    $P = $_SESSION['payment'];
}
// GV Code line changed
if ((is_array($payment_modules->modules) && (sizeof($payment_modules->modules) > 1) && (!is_object($GLOBALS[$P]))  && (!isset($_SESSION['credit_covers'])))  || (is_object($GLOBALS[$P]) && ($GLOBALS[$P]->enabled == false)) ) {
    if(defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True'){
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
    }
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
}
// load the selected shipping module

// ORIGINAL STELLE - 11/2017
require(DIR_WS_CLASSES . 'shipping.php');
$shipping_modules = new shipping($_SESSION['shipping']);
require(DIR_WS_CLASSES . 'order_total.php');

// load the before_process function from the payment modules
/*if(strstr($_SESSION['payment'],'secupay')){
    if (!isset($_SESSION['sp_success'])) {
        $order_total_modules = new order_total($xtPrice);
        $order_totals = $order_total_modules->process();
        $payment_modules->process_button();
    }
}*/

if(strstr($_SESSION['payment'],'yes_amazon_pay')){
    if (!isset($_SESSION['yes_amazon_pay_reference'])) {
        if(!isset($_GET['OrderReferenceID'])){
                xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
        }
        xtc_redirect(xtc_href_link('amazon_create_account.php','action=setOrderReferenceDetails').'&OrderReferenceID='.$_GET['OrderReferenceID']);
    }
}

/**
 * BEI KLARNA BEZAHLART WIRD $_SESSION['klarna_payment_result'] ARRAY GESETZT 
 * UND ENTHAELT                    
 *  'order_id'
 *  'payment_method' // zb invoice
 */
$order_total_modules = new order_total($xtPrice);
$order_totals = $order_total_modules->process();


$payment_modules->before_process();


// check if tmp order id exists
if (isset ($_SESSION['tmp_oID']) && is_int($_SESSION['tmp_oID'])) {
    $tmp = false;
    $insert_id = $_SESSION['tmp_oID'];
}else{
	$customers_status = $_SESSION['customers_status']['customers_status_id'];
	// check if tmp order need to be created
	if (isset($GLOBALS[$P]->tmpOrders) and $GLOBALS[$P]->tmpOrders == true) {
		$tmp = true;
		$tmp_status = $GLOBALS[$P]->tmpStatus;
	} else {
		$tmp = false;
		$tmp_status = $order->info['order_status'];
		switch($order->info['payment_method']){
			case 'yes_amazon_pay':
				$tmp_status = MODULE_PAYMENT_YES_AMAZON_PAY_ORDERS_STATUS_PENDING;
				if(!isset($_SESSION['customer_id'])){
					$customers_status = MODULE_PAYMENT_YES_AMAZON_PAY_CUSTOMERS_STATUS;
				}
				break;
		}
	}
	// BMC CC Mod Start
	if ( defined('CC_ENC') and strtolower(CC_ENC) == 'true' ) {
		$key = changeme;
		$plain_data = $order->info['cc_number'];
		$order->info['cc_number'] = changedatain($plain_data,$key);
	}
	// BMC CC Mod End

	if ($_SESSION['customers_status']['customers_status_ot_discount_flag']==1) {
		$discount=$_SESSION['customers_status']['customers_status_ot_discount'];
	} else {
		$discount='0.00';
	}
	// BOF - DEFAULT VERSENDER
        $default_shipper = '';
	if(sizeof($order->products) == 1 and $order->products[0]['qty'] == 1){
        	$default_shipper = \YES4Trade\Model\shipper_profiles::get_products_id_value(xtc_get_prid($order->products[0]['id']));
	}
	// EOF - DEFAULT VERSENDER
	
	$delivery_email_address	= (isset($_SESSION['delivery_email_address']))?$_SESSION['delivery_email_address']:'';
	$delivery_telephone = (isset($_SESSION['delivery_telephone']))?$_SESSION['delivery_telephone']:'';

    $notfall_email = null;
	if($order->customer['email_address'] === null or empty($order->customer['email_address'])){
        $notfall_email = (defined('EMAIL_SUPPORT_ADDRESS') and !empty(constant('EMAIL_SUPPORT_ADDRESS')))  ? constant('EMAIL_SUPPORT_ADDRESS') : 'dummy@shop.de';
        $notfall_email = str_replace('@',date('ymdhis').'@',$notfall_email);
        $order->customer['email_address'] = $notfall_email;
    }
	
	$customers_ip = ((isset($_SERVER["HTTP_X_FORWARDED_FOR"]))?$_SERVER["HTTP_X_FORWARDED_FOR"]:$_SERVER["REMOTE_ADDR"]);
	if( !isset($_SESSION['credit_covers']) or $_SESSION['credit_covers']!='1' ) {
            // TICKET 3454 - es kam bei einer paypal Zahlung vor dass ein
            // auftrag keine address_format_id Eintraege hatte, bzw diese auf
            // 0 standen, was dann dazu führt das Adresse in Dokumenten nicht
            // angezeigt wird.
            $format_id_cust = ($order->customer['format_id']>0)?$order->customer['format_id']:5;
            $format_id_deli = ($order->delivery['format_id']>0)?$order->delivery['format_id']:5;
            $format_id_bill = ($order->billing['format_id']>0)?$order->billing['format_id']:5;
		$sql_data_array = array('customers_id' => $order->get_customers_id(),
			'customers_name' => $order->customer['firstname'] . ' ' . $order->customer['lastname'],
			'customers_cid' => $order->customer['csID']??'',
			'customers_vat_id' => (isset($_SESSION['customer_vat_id']))?$_SESSION['customer_vat_id']:'',
			'customers_company' => $order->customer['company']??'',
			'customers_status' => intval($customers_status),
			'customers_status_name' => $_SESSION['customers_status']['customers_status_name']??'',
			'customers_status_image' => $_SESSION['customers_status']['customers_status_image']??'',
			'customers_status_discount' => floatval($discount),
			'customers_street_address' => $order->customer['street_address']??'',
			'customers_suburb' => $order->customer['suburb']??'',
			'customers_city' => $order->customer['city']??'',
			'customers_postcode' => $order->customer['postcode']??'',
			'customers_state' => $order->customer['state']??'',
			'customers_country' => $order->customer['country']['title'],
			'customers_telephone' => $order->customer['telephone']??'',
			'customers_email_address' => $order->customer['email_address'],
			'customers_address_format_id' => intval($format_id_cust),
			'delivery_name' => $order->delivery['firstname'] . ' ' . $order->delivery['lastname'],
			'delivery_company' => $order->delivery['company']??'',
			'delivery_street_address' => $order->delivery['street_address']??'',
			'delivery_suburb' => $order->delivery['suburb']??'',
			'delivery_city' => $order->delivery['city']??'',
			'delivery_postcode' => $order->delivery['postcode']??'',
			'delivery_state' => $order->delivery['state']??'',
			'delivery_country' => $order->delivery['country']['title'],
			'delivery_address_format_id' => intval($format_id_deli),
			'billing_name' => $order->billing['firstname'] . ' ' . $order->billing['lastname'],
			'billing_company' => $order->billing['company']??'',
			'billing_street_address' => $order->billing['street_address']??'',
			'billing_suburb' => $order->billing['suburb']??'',
			'billing_city' => $order->billing['city']??'',
			'billing_postcode' => $order->billing['postcode']??'',
			'billing_state' => $order->billing['state']??'',
			'billing_country' => $order->billing['country']['title'],
			'billing_address_format_id' => intval($format_id_bill),
			'payment_method' => $order->info['payment_method']??'',
			'payment_class' => $order->info['payment_class']??'',
			'shipping_method' => $order->info['shipping_method']??'',
			'shipping_class' => $order->info['shipping_class']??'',
			'cc_type' => $order->info['cc_type']??'',
			'cc_owner' => $order->info['cc_owner']??'',
			'cc_number' => $order->info['cc_number']??'',
			'cc_expires' => $order->info['cc_expires']??'',
			// BMC CC Mod Start
			'cc_start' => $order->info['cc_start']??'',
			'cc_cvv' => $order->info['cc_cvv']??'',
			'cc_issue' => $order->info['cc_issue']??'',
			// BMC CC Mod End
			'date_purchased' => date('Y-m-d H:i:s'),
			'orders_status' => intval($tmp_status),
			'currency' => $order->info['currency'],
			'currency_value' => floatval($order->info['currency_value']),
			'customers_ip' => $customers_ip,
			'language'=>$_SESSION['language'],
			'comments' => $order->info['comments']??'',
			'source'=>'shop',
		    'versender'=>$default_shipper,
		    'delivery_email_address'=>$delivery_email_address,
		    'delivery_telephone'=>$delivery_telephone??'',
            'allow_email_shipper'=>(isset($_SESSION['allow_email_shipper']) and $_SESSION['allow_email_shipper'] == 1)?1:0
		);
        $order->info['orders_status_id'] = intval($tmp_status);
	} else {
	   	// free gift , no paymentaddress
		$sql_data_array = array('customers_id' => $_SESSION['customer_id'],
			'customers_name' => $order->customer['firstname'] . ' ' . $order->customer['lastname'],
			'customers_cid' => $order->customer['csID']??'',
			'customers_vat_id' => $_SESSION['customer_vat_id']??'',
			'customers_company' => $order->customer['company']??'',
			'customers_status' => intval($customers_status),
			'customers_status_name' => $_SESSION['customers_status']['customers_status_name'],
			'customers_status_image' => $_SESSION['customers_status']['customers_status_image'],
			'customers_status_discount' => $discount,
			'customers_street_address' => $order->customer['street_address'],
			'customers_suburb' => $order->customer['suburb'],
			'customers_city' => $order->customer['city'],
			'customers_postcode' => $order->customer['postcode']??'',
			'customers_state' => $order->customer['state']??'',
			'customers_country' => $order->customer['country']['title'],
			'customers_telephone' => "".$order->customer['telephone']??'',
			'customers_email_address' => $order->customer['email_address'],
			'customers_address_format_id' => intval($order->customer['format_id']??5),
			'delivery_name' => $order->delivery['firstname'] . ' ' . $order->delivery['lastname'],
			'delivery_company' => $order->delivery['company']??'',
			'delivery_street_address' => $order->delivery['street_address']??'',
			'delivery_suburb' => $order->delivery['suburb']??'',
			'delivery_city' => $order->delivery['city']??'',
			'delivery_postcode' => $order->delivery['postcode']??'',
			'delivery_state' => $order->delivery['state']??'',
			'delivery_country' => $order->delivery['country']['title'],
			'delivery_address_format_id' => intval($order->delivery['format_id'])??5,
			'payment_method' => $order->info['payment_method'],
			'payment_class' => $order->info['payment_class'],
			'shipping_method' => $order->info['shipping_method'],
			'shipping_class' => $order->info['shipping_class']['title'],
			'cc_type' => $order->info['cc_type']??'',
			'cc_owner' => $order->info['cc_owner']??'',
			'cc_number' => $order->info['cc_number']??'',
			'cc_expires' => $order->info['cc_expires']??'',
			'date_purchased' => date('Y-m-d H:i:s'),
			'orders_status' => intval($tmp_status),
			'currency' => $order->info['currency'],
			'currency_value' => floatval($order->info['currency_value']),
			'customers_ip' =>  $_SERVER['REMOTE_ADDR']??'',
			'comments' => $order->info['comments']??'',
		    'source'=>'shop',
		    'versender'=>$default_shipper??'',
		    'delivery_email_address'=>$delivery_email_address??'',
		    'delivery_telephone'=>$delivery_telephone??'',
            'allow_email_shipper'=>(isset($_SESSION['allow_email_shipper']) and $_SESSION['allow_email_shipper'] == 1)?1:0,
		);
        $order->info['orders_status_id'] = intval($tmp_status);
	}
	if(isset($_SESSION['yes_amazon_pay_reference'])){
		$sql_data_array['yes_amazon_pay_reference'] = $_SESSION['yes_amazon_pay_reference'];
		$sql_data_array['yes_amazon_pay_reference_id'] = $_SESSION['yes_amazon_pay_reference_id'];
	}
    try{
        yes_db_perform(TABLE_ORDERS, $sql_data_array);
    }catch(Exception $e){
        yes_mail_debug(print_r($sql_data_array,true)."\n\n".print_r($_SESSION,true),true,'Checkout Process Error');
	    $recipients_array = main::get_notice_recipients('orders');
        $comm_text = sprintf(
            "Es gab im checkout Prozess einen unerwarteten Fehler - Ein Auftrag konnte nicht angelegt werden. Das Team von YES wurde ebenfalls autom. benachrichtigt. Da an dieser Stelle bereits der Auftrag als Bezahlt gilt muss der Vorgang manuell geprüft und der Auftrag manuell erzeugt werden. Auch der Käufer sollte entsprechend benachrichtigt werden. Hier die Daten des Auftrags in einer strukturellen Übersicht:\n<pre>%s</pre>\n\nFür technische Infos an das Team von YES folgender Hinweis zum Fehler:\n\n%s",
            print_r($sql_data_array,true)."\n\n".print_r($_SESSION,true),
            $e->getMessage()
        );
	    yes_write_notice('Shopkauf - Fehler',$comm_text , 0, $recipients_array);
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING,'error_msg='.urlencode('Error - please contact '.constant('EMAIL_SUPPORT_ADDRESS'))));
    }
    $insert_id = xtc_db_insert_id();
    if($notfall_email !== null){
        yes_mail_debug(print_r($sql_data_array,true)."\n\n".print_r($_SESSION,true),true,'Checkout Process - keine Email');
	    $recipients_array = main::get_notice_recipients('orders');
        $comm_text = sprintf(
            "Auftrag %d wurde erzeugt, ohne das eine Kunden Email Adresse bekannt ist. Es wurde die Emailadresse %s autom. verwendet. Bitte prüfen Sie den Vorgang und korrigieren Sie die Email Adresse des Kunden.",
            $insert_id, $notfall_email
        );
	    yes_write_notice('Shopkauf ohne Email',$comm_text , 0, $recipients_array);
    }
	
	
	
	$order->info['id'] = $insert_id; // ID SETZEN FUER HISTORIEN EINTRAEGE

	switch($order->info['payment_method']){
		case 'invoice':
		case 'eustandardtransfer':
		case 'moneyorder':
			//$code = $order->get_sofortueberweisung_paycode();
			break;
        }
	for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
		$sql_data_array = array('orders_id' => $insert_id,
			'title' => $order_totals[$i]['title'],
			'text' => $order_totals[$i]['text'],
			'value' => $order_totals[$i]['value'],
			'class' => $order_totals[$i]['code'],
			'sort_order' => $order_totals[$i]['sort_order'],
			'tax_rate_percent'=>$order_totals[$i]['tax_rate_percent']
		);
		xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
	}

	// initialized for the email confirmation
	$products_ordered = '';
	$products_ordered_html = '';
	$subtotal = 0;
	$total_tax = 0;
	$total_weight = 0;
	$total_cost = 0;
	for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
            // Stock Update - Joao Correia
            if (STOCK_LIMITED == 'true') {
                if (product::exists(intval(xtc_get_prid( $order->products[$i]['id'])))) {
                    $SQ = new products_quantity(xtc_get_prid( $order->products[$i]['id']) );
                    $new_qty = $order->products[$i]['qty'];
                    $qty_total = $SQ->get_products_total_qty();
                    product::add_history_static(
                         intval(xtc_get_prid( $order->products[$i]['id'])),
                        'Re-Nr '.$insert_id.' Im Shop gekauft: '.$new_qty.' Stk.'
                    );
                    $stock_left = $qty_total;

                    if ( ($stock_left < 1) and (STOCK_ALLOW_CHECKOUT == 'false') ) {
                        xtc_db_query(sprintf(
                            "update %s set products_status = '0' where products_id = '%d'",
                            TABLE_PRODUCTS,xtc_get_prid($order->products[$i]['id'])
                        ));
                    }
                }
            }

            // Update products_ordered (for bestsellers list)
            xtc_db_query(sprintf(
                "UPDATE %s SET products_ordered = products_ordered + %d WHERE products_id = '%d'",
                TABLE_PRODUCTS,sprintf('%d', $order->products[$i]['qty']),
                xtc_get_prid($order->products[$i]['id'])
            ));
            $sql_data_array = array('orders_id' => $insert_id,
                'products_id' => xtc_get_prid($order->products[$i]['id']),
                'products_model' => $order->products[$i]['model'],
                'products_name' => $order->products[$i]['name'],
                'products_price' => $order->products[$i]['price'],
                'final_price' => $order->products[$i]['final_price'],
                'products_tax' => $order->products[$i]['tax'],
                'products_quantity' => $order->products[$i]['qty'],
                'allow_tax' => $_SESSION['customers_status']['customers_status_show_price_tax']
            );
            yes_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
            $order_products_id = xtc_db_insert_id();
                
            $total_products_price = $order->products[$i]['final_price'];

            // BOF - properties
            if(sizeOf($order->products[$i]['properties'])){
                foreach($order->products[$i]['properties'] as $property){
                    $insert_sql_array = array(
                        'orders_products_id'=>$order_products_id,
                        'property_title'=>$property['property'],
                        'property_value'=>$property['value'],
                        'price_netto'=>$property['price_netto'],
                        // BOF - input_span AENDERUNGEN 2023/06
                        'input_span'=>$property['input_span']
                        // EOF - input_span AENDERUNGEN 2023/06
                    );
                    xtc_db_perform('orders_products_properties',$insert_sql_array);
                }
            }

            // EVTL ERSCHEINUNGSDATUM/LIEFERFRISTEN ALS KOMMENTAR SPEICHERN
            $order->save_order_product_estimated_date_receipt_as_comment($order->products[$i]['id']);

            $collies = xtc_get_product_collies(xtc_get_prid($order->products[$i]['id']));
            if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                yes_end_auction_add($order->products[$i]['id'],
                    $order->products[$i]['qty']
                );
            }

            // Aenderung Specials Quantity Anfang
            $specials_result = xtc_db_query(sprintf(
                "SELECT products_id, specials_quantity,sell_to_v1null,ebay_price_revise from %s WHERE products_id = '%d' ",
                TABLE_SPECIALS, (int)xtc_get_prid($order->products[$i]['id'])
            ));
            if (xtc_db_num_rows($specials_result)) {
			
			// EBAY SPECIALS HANDLING
			if(!function_exists('xtc_get_tax_rate')){
				require_once(DIR_FS_INC.'xtc_get_tax_rate.inc.php');
			}
			
			$special_deleted = false;
			$ebay_price_revise = false;
			$spq = xtc_db_fetch_array($specials_result);
			$new_sp_quantity = ($spq['specials_quantity'] - $order->products[$i]['qty']);
			if($spq['sell_to_v1null'] == 1){
                            $SQ = new products_quantity(xtc_get_prid( $order->products[$i]['id']) );
                            if($SQ->get_available1_qty() <= 0){
                                xtc_db_query(sprintf("DELETE FROM %s WHERE products_id='%d'",
                                    TABLE_SPECIALS,
                                    (int)xtc_get_prid($order->products[$i]['id'])
                                ));
                                $special_deleted = true;
                                $ebay_price_revise = true;
                            }
			}
			if(!$special_deleted){
                            if ($new_sp_quantity >= 1){
                                xtc_db_query(sprintf(
                                    "update %s set specials_quantity = '%d' where products_id = '%d'",
                                    TABLE_SPECIALS,$new_sp_quantity,
                                    (int)xtc_get_prid($order->products[$i]['id'])
                                ));
                            }
			}
                        $country_id = $order->delivery['country_id'];
                        $zone_id = $order->delivery['zone_id'];
                        
			if( $spq['ebay_price_revise'] == 1 and $ebay_price_revise ){
                            // GELOESCHT
                            // BOF - ebay price revise
                            $products_query = xtc_db_query(sprintf(
                                    "SELECT products_price FROM products WHERE products_id='%d'",
                                    (int)xtc_get_prid($order->products[$i]['id'])
                            ));
                            $products_record = xtc_db_fetch_array($products_query);
                            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                                xtc_get_prid($order->products[$i]['id']),$country_id
                            );
                            $tax_rate = xtc_get_tax_rate($products_tax_class_id, $country);
                            $revise_price_brutto = ($products_record['products_price']* ($tax_rate+100) /100);
                            $revise_products_id = xtc_get_prid($order->products[$i]['id']);

                            // start - ebay revise price
                            // WENN EIN EINTRAG IN ebay_auctions_price_revise_auctions EXISTIERT
                            // DANN SOLL DER NORMALE ARTIKELPREIS AN EBAY GESENDET WERDEN, DER
                            // EINTRAG IN ebay_auctions_price_revise_auctions WIRD DANACH GELOESCHT
                            // 
                            // SICHERGEHEN DAS KEIN WEITERER EINTRAG DRIN IST - WENN SINDS VERALTETE DURCH SPECIALMELDUNG DIE NICHT AUSGEFUEHRT WORDEN
                            \YES4Trade\Model\ebay_auctions_price_revise::delete_by_products_id((int)$revise_products_id);

                            $ebay_auctions_price_revise_auctions = \YES4Trade\Model\ebay_auctions_price_revise_auctions::get_by_products_id((int)$revise_products_id);
                            if(!sizeOf($ebay_auctions_price_revise_auctions)){
                                continue;
                            }

                            \YES4Trade\Model\ebay_auctions_price_revise::create_ebay_auctions_price_revise([
                                'price'=>(float)$revise_price_brutto,
                                'products_id'=>intval($revise_products_id)
                            ]);

                            foreach($ebay_auctions_price_revise_auctions as $eapra){
                                \YES4Trade\Model\ebay_auctions_price_revise_auctions::create_ebay_auctions_price_revise_auctions([
                                    'ebay_auctions_id'=>intval($eapra->ebay_auctions_id),
                                    'date_added'=>date('Y-m-d H:i:s'),
                                    'products_id'=>intval($revise_products_id)
                                ]);
                                \YES4Trade\Model\ebay_auctions_price_revise_auctions::delete(intval($eapra->ebay_auctions_price_revise_auctions_id));
                            }
                            // EOF - ebay revise price
			}
            }
            // Aenderung Ende


            $order_total_modules->update_credit_account($i);// GV Code ICW ADDED FOR CREDIT CLASS SYSTEM
            //------insert customer choosen option eof ----
            $total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
            $total_tax += xtc_calculate_tax($total_products_price, $order->products[$i]['tax']) * $order->products[$i]['qty'];
            $total_cost += $total_products_price;
	}
	
	$customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
	$comm_text = 'Bestellung Webshop per '.$order->info['payment_method'].(($_SESSION['comments']!='')?' Kommentar: '.$_SESSION['comments']:'');
        
        if(isset($_SESSION['klarna_payment_result'])){
            $comm_text .= sprintf(' - Klarna Order #%s (%s)',
                $_SESSION['klarna_payment_result']['order_id'],
                $_SESSION['klarna_payment_result']['payment_method']
            );
        }
	$sql_data_array = array('orders_id' => $insert_id,
		'orders_status_id' => $order->info['order_status'],
		'date_added' => 'now()',
		'customer_notified' => $customer_notification,
		'comments' => $comm_text
	);
	yes_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
	if($_SESSION['comments']!=''){
	    $recipients_array = main::get_notice_recipients('orders');
            // BOF - ADMIN LINK ZUM AUFTRAG HINZUFUEGEN
            // TICKET 2809
            $comm_text .= sprintf('<p><a target="_blank" href="%s">%s %s</a></p>',
                'orders.php?action=edit&oID='.$insert_id,
                TEXT_ORDER,
                $insert_id
            );
            // EOF - ADMIN LINK ZUM AUFTRAG HINZUFUEGEN
	    yes_write_notice(sprintf(TEXT_NEW_SHOPORDER_COMMENT,$insert_id),$comm_text , 0, $recipients_array);
	}
	
} // end if !tmp
if(isset($_SESSION['dhlgkapi_wunschpaket']) and strstr($order->info['shipping_class'],'dhlgkapi')){
    $insert_sql_array = array();
    foreach($_SESSION['dhlgkapi_wunschpaket'] as $key=>$val){
        if($val != ''){
            $insert_sql_array[$key] = $val;
        }
    }
    if(sizeOf($insert_sql_array)){
        $insert_sql_array['orders_id'] = $insert_id;
        yes_db_perform('orders_dhl_paketsteuerung',$insert_sql_array);
    }
    unset($_SESSION['dhlgkapi_wunschpaket']);
}


// bof - realkosten
$order->save_real_shipping_cost();
// eof - realkosten


// redirect to payment service
if ($tmp){
    $payment_modules->payment_action();
}


if (!$tmp) {
    // NEW EMAIL configuration !
    $order_totals = $order_total_modules->apply_credit();
    // load the after_process function from the payment modules
    $payment_modules->after_process();
    $_SESSION['cart']->reset(true);

    // unregister session variables used during checkout
    unset($_SESSION['sendto']);
    unset($_SESSION['billto']);
    unset($_SESSION['shipping']);
    unset($_SESSION['delivery_email_address']);
    unset($_SESSION['delivery_telephone']);

    unset($_SESSION['comments']);
    unset($_SESSION['rehash']);
    unset($_SESSION['nvpReqArray']);
    unset($_SESSION['last_order']);

    unset($_SESSION['yes_amazon_pay_access_token']);
    unset($_SESSION['yes_amazon_pay_reference']);
    unset($_SESSION['yes_amazon_pay_reference_id']);
    unset($_SESSION['yes_amazon_payment']);
    unset($_SESSION['AmazonOrderReferenceId']);
    unset($_SESSION['dhl_postfiliale']);
    unset($_SESSION['dhlgkapi_wunschpaket']);
    unset($_SESSION['allow_email_shipper']);
    $last_order = $insert_id;
    //GV Code Start
    if (strpos($payment_modules->selected_module, 'hp') === false){
        if( !strstr($order->info['payment_method'],'secupay')){
            include ('send_order.php');
        }
    }
    if(strstr($order->info['payment_method'],'secupay') ){
        include ('send_order.php');
    }
    if(isset($_SESSION['credit_covers'])) {
        unset($_SESSION['credit_covers']);
    }
    $order_total_modules->clear_posts();//ICW ADDED FOR CREDIT CLASS SYSTEM
    // GV Code End
	  
    if (!isset($mail_error)) {
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SUCCESS, '', 'SSL'));
    }  else {
        echo $mail_error;
    }
    require(DIR_WS_INCLUDES . 'application_bottom.php');
}
