<?php
/* -----------------------------------------------------------------------------------------
   $Id: ebay_send_order.php,v 1.30 2020/06/12 13:28:47 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (send_order.php,v 1.1 2003/08/24); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

// check if customer is allowed to send this order!
require_once(DIR_FS_INC.'xtc_get_short_description.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');


$order_query_check = xtc_db_query(sprintf(
        "SELECT customers_id,customers_email_address,customers_name FROM %s WHERE orders_id='%d'",
        TABLE_ORDERS,$insert_id
));
  					
$order_check = xtc_db_fetch_array($order_query_check);
if ($transaction['customer_id'] == $order_check['customers_id']){
    $order = new order($insert_id,$xtPrice);
      // send mail to customer
    $send_to_email = $order_check['customers_email_address'];
    
    // BOF - IN V2 GEBEN WIR DAS VOR - Array mit user und site (08/24)
    $ebay_site = [
        'user'=>'',
        'site'=>''
    ];
    if(!isset($ebay_site)){
        $ea_obj = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($transaction['ebay_id'],[
            'site','user'
        ]);
	    $ebay_site = $ea_obj->toArray();
    }
    // EOF - IN V2 GEBEN WIR DAS VOR - Array mit user und site (08/24)
    $ebay_seller = $ebay_site['user'];

    $ebay_seller_query_raw = sprintf(
        "SELECT store_name,email_address,bank,vat_id,store_name_wrap,bank_wrap FROM ebay_auth WHERE user='%s' and environment='%s'",
        $ebay_seller,((defined('EBAY_TESTMODE') and intval(EBAY_TESTMODE) == 1)?'sandbox':'production'
    ));
    $ebay_seller_data_query = xtc_db_query($ebay_seller_query_raw);
    $ebay_seller_data = xtc_db_fetch_array($ebay_seller_data_query);
    $ebay_seller_data = xtc_db_prepare_input($ebay_seller_data);

    $lang_path = xtc_get_lang_path_from_ebay_site($ebay_site['site']);

    // assign language to template for caching
    $smarty->assign('language', $lang_path);
    $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
    $smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
    $smarty->assign('oID',$insert_id);

    // dont allow cache
    $smarty->caching = false;

    $smarty->assign('ebayID',$transaction['ebay_id']);

    $newuser = ($is_registered) ? '0' : '1';
    $smarty->assign('NEW_USER',$newuser);
    $smarty->assign('SHOP_URL',HTTP_SERVER.DIR_WS_CATALOG.'login.php');
    $smarty->assign('EBAYUSERLOGIN_USERNAME',$order->customer['email_address']);
    $smarty->assign('EBAYUSER',$transaction['ebay_user']);
    $smarty->assign('EBAYUSERLOGIN_PASSWORD',$transaction['password']);
    $smarty->assign('NAME',$order_check['customers_name']);

    $smarty->assign('PASSWORD_LINK',HTTP_SERVER.DIR_WS_CATALOG.'password_double_opt.php');

    // NUR FUER AELTERE TEMPLATES DIE IRGENDWO NOCH $EBAYUSERLOGIN_URL VERWENDEN
    $smarty->assign('EBAYUSERLOGIN_URL',HTTP_SERVER.DIR_WS_CATALOG.'login.php');


    // NEUE VARIABLEN
    $smarty->assign('BANK_WRAP',$ebay_seller_data['bank_wrap']);
    $smarty->assign('STORE_NAME_ADDRESS',$ebay_seller_data['store_name_wrap']);

    $smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
    $smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br>'));
    $order_query=xtc_db_query(sprintf(
        "SELECT products_id, orders_products_id, products_model, products_name, products_price, final_price, products_quantity FROM %s WHERE orders_id='%d'",
        TABLE_ORDERS_PRODUCTS, $insert_id
    ));
    $order_data=array();

    while ($order_data_values = xtc_db_fetch_array($order_query)) {
        $order_data[]=array(
            'PRODUCTS_MODEL' => $order_data_values['products_model'],
            'PRODUCTS_NAME' => $order_data_values['products_name'],
            'PRODUCTS_WEIGHT'=>  xtc_get_ext_products_weight($order_data_values['products_id'])*$order_data_values['products_quantity'],
            'PRODUCTS_PRICE' => $xtPrice->xtcFormat($order_data_values['final_price'],true),
            'PRODUCTS_SINGLE_PRICE' => $xtPrice->xtcFormat($order_data_values['products_price'],true),
            'PRODUCTS_QTY' => $order_data_values['products_quantity'],
            'PRODUCTS_SHORT_DESCRIPTION'=>  xtc_get_short_description($order_data_values['products_id'], $_SESSION['languages_id'])
        );
    }
    // get order_total data
    $oder_total_query=xtc_db_query(sprintf(
            "SELECT title, text, sort_order FROM %s WHERE orders_id='%d' ORDER BY sort_order ASC",
            TABLE_ORDERS_TOTAL,$insert_id
    ));

    $order_total=array();
    while ($oder_total_values = xtc_db_fetch_array($oder_total_query)) {
        $order_total[] = array(
            'TITLE' => $oder_total_values['title'],
            'TEXT' => $oder_total_values['text']
        );
    }

    $smarty->assign('order_data', $order_data);
    $smarty->assign('order_total', $order_total);
    $smarty->assign('NAME',$order->customer['name']);

    $conditions = '';
    $conditions_txt = '';
    $shop_content_data = yes_get_shop_content(3, ((isset($_SESSION['languages_id'])?$_SESSION['languages_id']:2)),false);
    if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
        $conditions = $shop_content_data['content_text'];
        $conditions_txt = yes_get_shop_content_html_stripped($conditions);
    }
	
    // WIDERRUF
    $widerruf = '';
    $widerruf_txt = '';
    $shop_content_data = yes_get_shop_content(9, ((isset($_SESSION['languages_id'])?$_SESSION['languages_id']:2)),false);
    if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
        $widerruf = $shop_content_data['content_text'];
        $widerruf_txt = yes_get_shop_content_html_stripped($widerruf);
    }
    $smarty->assign(array(
        'conditions'=>$conditions,
        'widerruf'=>$widerruf,
        'conditions_txt'=>$conditions_txt,
        'widerruf_txt'=>$widerruf_txt
    ));
    $payment_method = $order->info['payment_method'];

    if ($order->info['payment_method']!='' && $order->info['payment_method']!='no_payment') {
        if(!defined('MODULE_PAYMENT_'.strtoupper($order->info['payment_method']).'_TEXT_TITLE')){
            if(is_file(DIR_WS_LANGUAGES.((isset($_SESSION['language'])?$_SESSION['language']:'german')).'/modules/payment/'.$order->info['payment_method'].'.php'))
                require_once(DIR_WS_LANGUAGES.((isset($_SESSION['language'])?$_SESSION['language']:'german')).'/modules/payment/'.$order->info['payment_method'].'.php');
        }
        if(defined(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'))){
            $payment_method=constant(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'));
        }
    }
    $smarty->assign('PAYMENT_METHOD',$payment_method);

    $html_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$lang_path.'/order_ebay_mail.html');
    $txt_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$lang_path.'/order_ebay_mail.txt');
    
    if(defined('EBAY_EMAIL_SUBJECT') and EBAY_EMAIL_SUBJECT != ''){
        $order_subject=str_replace('{$orders_id}',$insert_id,EBAY_EMAIL_SUBJECT);
        $order_subject=str_replace('{$ebay_id}',$transaction['ebay_id'],$order_subject);
        $order_subject=str_replace('{$ebay_userid}',$transaction['ebay_user'],$order_subject);
    }else{
        // create subject
        $order_subject=str_replace('{$nr}',$insert_id,EMAIL_BILLING_SUBJECT_ORDER);
        $order_subject=str_replace('{$date}',yes_strftime(DATE_FORMAT_LONG),$order_subject);
        $order_subject=str_replace('{$lastname}',$order->customer['name'],$order_subject);
        $order_subject=str_replace('{$firstname}',$order->customer['name'],$order_subject);
    }
    xtc_php_mail($ebay_seller_data['email_address'],
        $ebay_seller_data['store_name'],
        $send_to_email ,
        $order->customer['name'],
        '',
        $ebay_seller_data['email_address'],
        $ebay_seller_data['store_name'],
        '',
        '',
        $order_subject,
        $html_mail ,
        $txt_mail 
    );
    \YES4Trade\Model\ebay_emails::create_ebay_emails([
        'subject'=>$order_subject,
        'mailto'=>$order->customer['email_address'],
        'from_name'=>$ebay_seller_data['store_name'],
        'from_email'=>$ebay_seller_data['email_address'],
        'date'=>date('Y-m-d H:i:s'),
        'ebay_id'=>$transaction['ebay_id'],
        'customers_id'=>intval($transaction['customer_id']),
        'orders_id'=>intval($insert_id),
        'allocation_status'=>'1',
        'saved'=>1,
        'ownmail'=>'1',
        'format'=>'text/html'
    ],$html_mail);
} else {
	$smarty->assign('ERROR','You are not allowed to view this order!');
	$smarty->display(CURRENT_TEMPLATE . '/module/error_message.html');	
}
