<?php
/* -----------------------------------------------------------------------------------------
   $Id: gv_redeem.php,v 1.4 2012/08/10 14:25:52 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project (earlier name of osCommerce)
   (c) 2002-2003 osCommerce (gv_redeem.php,v 1.3.2.1 2003/04/18); www.oscommerce.com

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

require('includes/application_top.php');

if(!defined('ACTIVATE_GIFT_SYSTEM') or ACTIVATE_GIFT_SYSTEM!='true') {
    xtc_redirect(FILENAME_DEFAULT);
}

require_once(DIR_FS_INC . 'xtc_image_button.inc.php');

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

require(DIR_WS_INCLUDES . 'header.php');
// check for a voucher number in the url
if (!isset($_GET['gv_no'])) {
    xtc_redirect(FILENAME_DEFAULT);
}
$error = true;
$parameters = ['coupon_code'=>$_GET['gv_no'] ];
$gv_query_raw = sprintf(
    "select c.coupon_id, c.coupon_amount from %s c, %s et where coupon_code = :coupon_code and c.coupon_id = et.coupon_id",
    TABLE_COUPONS, TABLE_COUPON_EMAIL_TRACK
);
$gv_query = yes_query($gv_query_raw, $parameters);
if (sizeOf($gv_query)) {
    $coupon = current($gv_query);
    $items = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($coupon['coupon_id']),[
        'coupon_id'
    ]);
    if (!sizeOf($items)) {
        // check for required session variables
        $_SESSION['gv_id'] = $coupon['coupon_id'];
        $error = false;
    } else {
        $error = true;
    }
}
if (!$error and isset($_SESSION['customer_id'])) {
    $new = new \YES4Trade\Model\coupon_redeem_track([
        'coupon_id'=>intval($coupon['coupon_id']), 
        'customer_id'=>intval($_SESSION['customer_id']), 
        'redeem_date'=>date('Y-m-d H:i:s'), 
        'redeem_ip'=>$REMOTE_ADDR
    ]);
    $new->create();
    
    $upd = new \YES4Trade\Model\coupons([
        'coupon_active' => 'N',
        'coupon_id'=>intval($coupon['coupon_id'])
    ]);
    $upd->update();
    xtc_gv_account_update($_SESSION['customer_id'], $_SESSION['gv_id']);
    unset($_SESSION['gv_id']);
}
  
$breadcrumb->add(NAVBAR_GV_REDEEM);

$smarty->assign('coupon_amount', $xtPrice->xtcFormat($coupon['coupon_amount'],true));
$smarty->assign('LINK_DEFAULT', '<a href="' . xtc_href_link(FILENAME_DEFAULT) . '">' . xtc_image_button('button_continue.gif', IMAGE_BUTTON_CONTINUE) . '</a>');
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/gv_redeem.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
