<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_lang_path_from_ebay_site.inc.php,v 1.3 2009/02/09 08:45:52 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2003	 nextcommerce (xtc_php_mail.inc.php,v 1.17 2003/08/24); www.nextcommerce.org


   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
function _xtc_get_languages() {
    $languages_array = [];
    foreach(\YES4Trade\Model\languages::get_list() as $languages) {
        $languages_array[] = array(
            'id' => $languages['languages_id'],
            'name' => $languages['name'],
            'code' => $languages['code'],
            'image' => $languages['image'],
            'directory' => $languages['directory']
        );
    }
    return $languages_array;
}
 
 function xtc_get_lang_path_from_ebay_site($site) {
	 require_once(DIR_FS_CATALOG.'inc/xtc_get_site_country_id.inc.php');
	$languages = _xtc_get_languages();
	if(empty($site)){
		$site = 'Germany';
	}
	$cID = xtc_get_site_country_id($site);
	$iso2 = main::get_country_values($cID);

	// HIER EINIGE ALTERNATIVEN
	switch($iso2['countries_iso_code_2']){
		case 'GB':
		case 'FR':
		case 'US':
			$iso2['countries_iso_code_2'] = 'EN';
			foreach($languages as $k=>$lang){
				if(strtoupper($lang['code']) == 'FR' && $site == 'France'){
					$iso2['countries_iso_code_2'] = 'FR';
				}
			}
			break;
		case 'AT':
		case 'CH':
			$iso2['countries_iso_code_2'] = 'DE';
			break;
	}

	switch($iso2['countries_iso_code_2']){
		case 'EN':
			return 'english';
			break;
		case 'DE':
			return 'german';
			break;
		case 'FR':
			return 'france';
			break;
		default:
			return 'german';
			break;
	}
 }

