<?php
namespace yesDSGVO;
class yesDSGVOmain
{
	var $consents, $def_file, $debug, $url_backend, $url_action, $javascript_functions_file, $use_function;
	function __construct(){
		$debug = false;
		$this->debug = $debug;
		$this->url_backend = "yesDSGVO-consent-backend.php";
		$this->url_action = 'index.php';
		$this->javascript_functions_file = 'includes/yesDSGVO-consent-script.js';
		
		$this->def_file = 'templates/'.CURRENT_TEMPLATE.'/yes_consent_template.html';
		if(!empty($def_file)){
			$this->def_file = $def_file;
		}
		$this->consents = [];
		$jsonString = MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS;
		if(!empty($jsonString)){
			$jsonData = json_decode($jsonString, true);
			foreach($jsonData as $jsd){
				$script_src = (isset($jsd['script_src'])) ? $jsd['script_src'] : Null;
				$use_function = (isset($jsd['use_function'])) ? $jsd['use_function'] : Null;
				$this->use_function = $use_function;
				$this->consents[] = new \yesDSGVO\yesDSGVOconsent($script_src, $use_function, $jsd['description'], $jsd['code']);
			}
		}
	}
	
	
	private function consents_to_json(){
		$json_array = [];
		foreach($this->consents as $c){
			$json_array[] = $c->as_array();
		}
		return json_encode($json_array);
	}
	
	public function get_load_scripts_js(){
		$out = '';
		if($this->debug){
			$out .= 'console.log("Das Script website-script.js wurde geladen. Hier können beliebige Dienste nachgeladen werden");'."\r\n";
		}
		$out .= 'let consent_cookie_value = yesDSGVO_getCookie("yesDSGVO_consent").split(",");'."\r\n";
		$out .= 'let yesDSGVO_allow_script = true;'."\r\n";
		if($this->debug){
			$out .= "console.log('[yesDGVO] Nachladescript gestartet');\r\n";
		}
		foreach($this->consents as $nr=>$s){
			// Nur wenn der User die nr des Consents erlaubt hat.
			$out .= "if( consent_cookie_value.indexOf('".($nr+1)."') > -1){\r\n";
			if($this->debug){
				$out .= sprintf("\tconsole.log('[yesDGVO] --- script_src: [%s], use_function: [%s], code: [%s],  description: [%s]');\r\n",
					$s->script_src,
					$s->use_function,
					$s->code,
					substr($s->description,0,16)
				);
			}
			if( isset($s->use_function) and !empty($s->use_function)){
				$out .= "\t".'if (typeof '.$s->use_function.' !== "function") {'."\r\n";
				$out .= "\t".'	console.log("\t\t\t[yesDGVO] FEHLER: '.$s->use_function.'() ist keine Funktion - diese muss aber definiert sein.");'."\r\n";
				$out .= "\t".'}'."\r\n";
			}
			if( isset($s->code) and !empty($s->code) ){
				$out .= "\t".'if( $(\'#yesDSGVO_code_'.$s->code.'\').length){'."\r\n";
				if($this->debug){
					$out .= "\t".'	console.log("\t\t\t [yesDGVO] Code '.$s->code.' Platzhalter gefunden!");'."\r\n";
				}
				if( isset($s->script_src) and !empty($s->script_src)){
					$out .= "\t".'		var scriptabc_'.$nr.' = document.createElement("script");'."\r\n";
					$out .= "\t".'		scriptabc_'.$nr.'.src = "'.$s->script_src.'";'."\r\n";
					$out .= "\t".'		document.head.appendChild(scriptabc_'.$nr.');'."\r\n";
					if($this->debug){
						$out .= "\t".'		console.log("\t\t\t [yesDGVO] Script '.$s->script_src.' geladen");'."\r\n";
					}
				}else{
					$out .= "\t".'		'.$s->use_function."();\r\n";
					if($this->debug){
						$out .= "\t".'		console.log("\t\t\t [yesDGVO] Funktion '.$s->use_function.'() ausgefuehrt");'."\r\n";
					}
				}
				$out .= "\t}else{\r\n";
					if($this->debug){
						$out .= "\t".'	console.log("\t\t\t [yesDGVO] Code '.$s->code.' definiert, aber kein Platzhalter #yesDSGVO_code_'.$s->code.' gefunden.");'."\r\n";
					}
				$out .= "\t}\r\n";
			}else{
				if($this->debug){
					$out .= "\t".'console.log("\t\t\t [yesDGVO] ohne code = ueberall einbinden");'."\r\n";
				}
				if( isset($s->script_src) and !empty($s->script_src)){
					$out .= "\t".'var scriptabc_'.$nr.' = document.createElement("script");'."\r\n";
					$out .= "\t".'scriptabc_'.$nr.'.src = "'.$s->script_src.'";'."\r\n";
					$out .= "\t".'document.head.appendChild(scriptabc_'.$nr.');'."\r\n";
					if($this->debug){
						$out .= "\t".'console.log("\t\t\t [yesDGVO] Script '.$s->script_src.' geladen");'."\r\n";
					}
				}else{
					$out .= $s->use_function."();\r\n";
					if($this->debug){
						$out .= "\t".'console.log("\t\t\t [yesDGVO] Funktion '.$s->use_function.'() ausgefuehrt");'."\r\n";
					}
				}
			}
			$out .= '} // end if activated'."\r\n";
		}
		return $out;
	}
	
	public function get_bottom_js(){
		return '<script data-src="'.$this->url_action.'?yesDSGVO_load_scripts=1" id="yesDSGVO_script"></script>'
		     . '<script src="'.$this->javascript_functions_file.'"></script>';
	
	}
	public function get_heading_js(){
		$debug       = ($this->debug) ? 'true' : 'false';
		$url_backend = $this->url_backend;
		$url_action  = $this->url_action;
		return 
<<<BISHIERJS
		var YESCONSENTSCRIPTDEBUG = $debug;
		var YESCONSENTURL_BACKEND = "$url_backend";
		var YESCONSENTURL_ACTION = "$url_action";
BISHIERJS;
	}
	
	public function get_details(){
		$replace_str = '<!--[CONSENTS]//-->';
                if(!is_file($this->def_file)){
                    printf('<script>alert("YESDSGVO: Fehlende Datei: %s");</script>',
                            $this->def_file
                    );
                }
		$html = file_get_contents($this->def_file);
		$insert = '<br />';
		foreach($this->consents as $nr=>$s){
			$active = false;
			$checked = ($active) ? 'checked="checked"' : '';
			$insert .= '<input class="yesDSGVO_consent_item_active" type="checkbox" name="yesDSGVO_consent_nr[]" value="'.($nr+1).'" '.$checked.'>'.$s->description.'<br />';
		}
		return str_replace($replace_str, $insert, $html);
	}
}

