<?php
/* -----------------------------------------------------------------------------------------
   $Id: ot_loworderfee.php,v 1.4 2019/06/28 08:17:50 re511548 Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(ot_loworderfee.php,v 1.11 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (ot_loworderfee.php,v 1.7 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   

  class ot_loworderfee {
    var $title, $output, $code, $description, $enabled,$sort_order, $Price,$tax_value,$tax_rate,$tax_class_id;

    function __construct($price) {
      $this->code = 'ot_loworderfee';
      $this->title = MODULE_ORDER_TOTAL_LOWORDERFEE_TITLE;
      $this->description = MODULE_ORDER_TOTAL_LOWORDERFEE_DESCRIPTION;
      $this->enabled = ((defined('MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS') and MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS == 'true') ? true : false);
      $this->sort_order = (defined('MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER')) ? MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER : 0;
      $this->Price=$price;
      $this->tax_value = 0;
      $this->tax_rate = 0;
      $this->tax_class_id = (defined('MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS'))?MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS:0;
      $this->output = array();
    }
    
    function process() {
      global $order, $currencies;

      if (MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE == 'true') {
        switch (MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION) {
          case 'national':
            if ($order->delivery['country_id'] == STORE_COUNTRY) $pass = true; break;
          case 'international':
            if ($order->delivery['country_id'] != STORE_COUNTRY) $pass = true; break;
          case 'both':
            $pass = true; break;
          default:
            $pass = false; break;
        }

        if ( ($pass == true) && ( ($order->info['total'] - $order->info['shipping_cost']) < MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER) ) {
            // Steuerklasse ermitteln aus anteiligem Artikelmwst Satz
            $this->tax_class_id = $order->get_shipping_tax_class();
            $country_id = $order->delivery['country']['id'];
            $zone_id = 0;
            
            // BUGF_CH_OSS
            $this->tax_rate = xtc_get_tax_rate($this->tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
            $tax_description = TAX_ADD_TAX . xtc_get_tax_description($this->tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
            
            
            
          // UM DIE order->info[tax_groups] einheitlich zu fuellen, habe ich
          // wie in den anderen steuerpflichtigen ot_ Klassen TAX_ADD_TAX als
          // prefix vorangestellt (06/19)
          $fee = (float)str_replace(',','.',MODULE_ORDER_TOTAL_LOWORDERFEE_FEE);
            // BUGFIX - MwSt von xtPrice ermitteln lassen, vorher statisch
            // 2021/02/25
            if ($this->Price->cStatus['customers_status_show_price_tax'] =='0'){
                $this->tax_value = 0;
            }else{
                // BUGFIX - HIER WURDE FALSCH GERECHNET, ES WURDE xtcGetPrice
                // VERWENDET, WAS AN DER STELLE VOELLIG FALSCH IST
                // 2021/07
                $this->tax_value = ($this->Price->xtcAddTax($fee, $this->tax_rate))-$fee;
            }
            // ALT
            // $this->tax_value = xtc_calculate_tax(MODULE_ORDER_TOTAL_LOWORDERFEE_FEE, $tax);
          $order->info['tax'] += $this->tax_value;
          $order->info['tax_groups']["$tax_description"] += $this->tax_value;
          $order->info['total'] += $fee + $this->tax_value;
          $this->output[] = array('title' => $this->title . ':',
            'text' => $this->Price->xtcFormat($fee + $this->tax_value, true),
            'value' => $fee + $this->tax_value,
            'tax_rate_percent'=>$this->tax_rate
          );
        }
      }
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS', 'MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER', 'MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE', 'MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER', 'MODULE_ORDER_TOTAL_LOWORDERFEE_FEE', 'MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION', 'MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS');
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER', '4', '6', '2', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE', 'false', '6', '3', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, date_added) values ('MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER', '50','6', '4', 'currencies->format', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, date_added) values ('MODULE_ORDER_TOTAL_LOWORDERFEE_FEE', '5','6', '5', 'currencies->format', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION', 'both','6', '6', 'xtc_cfg_select_option(array(\'national\', \'international\', \'both\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS', '0','6', '7', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }