<?php
/**
 * @version sofort�berweisung.de 4.0.1 - $Date: 2020/04/28 12:57:24 $
 * @author Payment Network AG (integration@payment-network.com)
 * @link http://www.payment-network.com/
 *
 * @copyright 2006 - 2007 Henri Schmidhuber
 * @link http://www.in-solution.de
 *
 * @link http://www.xt-commerce.com
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 ***********************************************************************************
 * this file contains code based on:
 * (c) 2000 - 2001 The Exchange Project
 * (c) 2001 - 2003 osCommerce, Open Source E-Commerce Solutions
 * (c) 2003	 nextcommerce (account_history_info.php,v 1.17 2003/08/17); www.nextcommerce.org
 * (c) 2003 - 2006 XT-Commerce
 * Released under the GNU General Public License
 ***********************************************************************************
 *
 * $Id: pn_sofortueberweisung.php,v 1.5 2020/04/28 12:57:24 ssh-511548-cvs Exp $
 *
 */
class pn_sofortueberweisung {

	var $code, $title, $description, $enabled, $version, $info, $tmpOrders, 
		$tmpStatus, $order_status, $form_action_url,$defaultCurrency, $sort_order;
	function __construct() {
		global $order;
		$this->code = 'pn_sofortueberweisung';
		$this->version = 'pn_xtc_v4.0.1';
		$this->title = MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_TITLE;
		$this->description = MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION;
		$this->sort_order = (defined('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_SORT_ORDER')) ? MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_SORT_ORDER : 0;
		$this->enabled = ((defined('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS') and MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS == 'True') ? true : false);
		if($this->enabled === true){
			$this->info = MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_INFO;
			$this->tmpOrders = true;
			$this->tmpStatus = MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TMP_STATUS_ID;
			if ((int) MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ORDER_STATUS_ID > 0) {
				$this->order_status = MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ORDER_STATUS_ID;
			}
			$this->form_action_url = 'https://www.sofortueberweisung.de/payment/start';
			$this->defaultCurrency = DEFAULT_CURRENCY;
		}
		if (is_object($order)){
			$this->update_status();
		}

		//if old installation and notification password not set we need to upgrade the database
		if (defined('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS')	&& (MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS == 'True')
		&& !defined('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_NOTIF_PASSWORD'))
			$this->_upgrade();

	}
	function update_status (){
            global $order;
            if (($this->enabled == true) && ((int) MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ZONE > 0)) {
                $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                    intval(MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ZONE),
                    intval($order->billing['country']['id']),
                    intval($order->billing['zone_id'])
                );
                if ($check_flag == false) {
                        $this->enabled = false;
                }
            }
	}
	function javascript_validation () {
		return false;
	}
	function selection () {
		/* If temporary order is still in session, check if order ID exists and delete order and all relating (session) data
		 * User might have returned to the shop for changing the order or payment method
		 */
		if (! empty($_SESSION['cart_pn_sofortueberweisung_ID'])) {
			$order_id = substr($_SESSION['cart_pn_sofortueberweisung_ID'], strpos($_SESSION['cart_pn_sofortueberweisung_ID'], '-') + 1);
			$check_query = yes_query(
                                'SELECT orders_status FROM ' . TABLE_ORDERS . ' WHERE orders_id =:orders_id LIMIT 1',
                                ['orders_id'=>(int) $order_id]
                        );
			if (is_countable($check_query) and sizeOf($check_query)) {
                            $result = current($check_query);
				if ($result['orders_status'] == MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TMP_STATUS_ID) {
					$this->_remove_order( (int) $order_id, 'off');
					unset($_SESSION['cart_pn_sofortueberweisung_ID']);
					unset($_SESSION['tmp_oID']);
				}
			}
		}
		$title = '';
		switch (MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_IMAGE) {
			case 'Logo & Text':
				$image = xtc_image(sprintf('lang/%s/modules/payment/images/sofortueberweisung_logo.gif', $_SESSION['language']), MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGEALT);
				$title = str_replace('{{image}}', $image, sprintf(MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGE, MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_TEXT));
				break;
			case 'Logo':
				$image = xtc_image(sprintf('lang/%s/modules/payment/images/sofortueberweisung_logo.gif', $_SESSION['language']), MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGEALT);
				$title = str_replace('{{image}}', $image, sprintf(MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGE, ''));
				break;
			case 'Infographic':
				$image = xtc_image(sprintf('lang/%s/modules/payment/images/sofortueberweisung_info.gif', $_SESSION['language']), MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGEALT);
				$title = str_replace('{{image}}', $image, sprintf(MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_DESCRIPTION_CHECKOUT_PAYMENT_IMAGE, ''));
				break;
		}
		return array('id' => $this->code , 'module' => $this->title , 'description' => $title);
	}
	function pre_confirmation_check () {
		// Fix for XTC Bug
		// We need a cartID
		if (empty($_SESSION['cart']->cartID)) {
			$_SESSION['cart']->cartID = $_SESSION['cart']->generate_cart_id();
		}
		return false;
	}
	function confirmation () {
		global $order;

		/* If temporary order is still in session, check if order ID exists and delete order and all relating (session) data
		 * User might have returned to the shop for changing the order or payment method
		 */
		if (! empty($_SESSION['cart_pn_sofortueberweisung_ID'])) {
			$order_id = substr($_SESSION['cart_pn_sofortueberweisung_ID'], strpos($_SESSION['cart_pn_sofortueberweisung_ID'], '-') + 1);
			$cartID = substr($_SESSION['cart_pn_sofortueberweisung_ID'], 0, strlen($_SESSION['cart']->cartID));
			$result = yes_query(
                                "SELECT currency, orders_status FROM " . TABLE_ORDERS . " WHERE orders_id =:orders_id",
                                ['orders_id'=>(int) $order_id],
                                true
                        );
			if (($result['orders_status'] == MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TMP_STATUS_ID) || ($result['currency'] != $order->info['currency']) || ($_SESSION['cart']->cartID != $cartID)) {
				$this->_remove_order( (int) $order_id, 'off');
				unset($_SESSION['cart_pn_sofortueberweisung_ID']);
				unset($_SESSION['tmp_oID']);
			}
		}
		return false;
	}
	function process_button () {
		return false;
	}
	function before_process () {
		return false;
	}
	function payment_action () {
		global $order, $xtPrice, $insert_id;

		$customer_id = $_SESSION['customer_id'];
		$order_id = $insert_id;
		$_SESSION['cart_pn_sofortueberweisung_ID'] = $_SESSION['cart']->cartID . '-' . $insert_id;

		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
			$total = $order->info['total'] + $order->info['tax'];
		} else {
			$total = $order->info['total'];
		}

		// Fix for XTC Bug
		// $order->info['total'] is in 'before_process' String without Tax, after email it is TEXT with currency
		// so it has to be set here

		$amount = round($total, $xtPrice->get_decimal_places($_SESSION['currency']));
		$amount = number_format($amount, 2, '.', '');
		
		$_SESSION['sofortueberweisung_total'] = $amount;
		$parameter = array();
		$parameter['user_id'] = MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_USER_ID;
		$parameter['project_id'] = MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_ID;
		$parameter['amount'] = $amount;
		$parameter['currency_id'] = $_SESSION['currency'];

		$reason_1 = str_replace('{{order_id}}', $order_id, MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_REASON_1);
		$reason_2 = str_replace('{{order_id}}', $order_id, MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_REASON_2);
		$reason_1 = str_replace('{{customer_id}}', $customer_id, $reason_1);
		$reason_2 = str_replace('{{customer_id}}', $customer_id, $reason_2);

		$reason_2 = str_replace('{{order_date}}', yes_strftime(DATE_FORMAT_SHORT), $reason_2);
		$reason_2 = str_replace('{{customer_name}}', $order->customer['firstname'] . ' ' . $order->customer['lastname'], $reason_2);
		$reason_2 = str_replace('{{customer_company}}', $order->customer['company'], $reason_2);
		$reason_2 = str_replace('{{customer_email}}', $order->customer['email_address'], $reason_2);

		$reason_1 = substr($reason_1, 0, 27);
		$reason_2 = substr($reason_2, 0, 27);


		$parameter['reason_1'] = $reason_1;
		$parameter['reason_2'] = $reason_2;
		$parameter['user_variable_0'] = $order_id;
		$parameter['user_variable_1'] = $customer_id;

		$session = '&' . session_name() . '=' . session_id();

		if (ENABLE_SSL == true)
		$server = str_replace('https://', '', HTTPS_SERVER);
		else
		$server = str_replace('http://', '', HTTP_SERVER);

		// success return url:
		$parameter['user_variable_2'] = $server . DIR_WS_CATALOG . FILENAME_CHECKOUT_PROCESS . '?transaction=-TRANSACTION-' . $session;

		// cancel return url:
		$parameter['user_variable_3'] = $server . DIR_WS_CATALOG . FILENAME_CHECKOUT_PAYMENT . '?payment_error=pn_sofortueberweisung' . $session;

		// notification url:
		$parameter['user_variable_4'] = $server . DIR_WS_CATALOG . 'callback/pn_sofortueberweisung/callback.php';

		$parameter['user_variable_5'] = $_SESSION['cart']->cartID;
		
		if (strlen(MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_PASSWORD) > 0) {
			$tmparray = array(
			$parameter['user_id'],
			$parameter['project_id'],
				'', // sender_holder
				'', // sender_account_number
				'', // sender_bank_code
				'', // sender_country_id|
			$parameter['amount'],
			$parameter['currency_id'],
			$parameter['reason_1'],
			$parameter['reason_2'],
			$parameter['user_variable_0'],
			$parameter['user_variable_1'],
			$parameter['user_variable_2'],
			$parameter['user_variable_3'],
			$parameter['user_variable_4'],
			$parameter['user_variable_5'],
			MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_PASSWORD);

			$msg = implode("|", $tmparray);
			$parameter['hash'] = pn_create_hash(MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_HASH_ALGORITHM, $msg);
		}

		$parameter['encoding'] = 'iso-8859-1';
		$parameter['payment_module'] = sprintf('XTC %s (v%s)', $this->code, $this->version);
		$parameter['interface_version'] = $this->version;
		

		// Additionally update status
		$sql_data_array = array(
                    'orders_id' => (int) $order_id , 
                    'orders_status_id' => MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TMP_STATUS_ID , 
                    'date_added' => 'now()' , 
                    'customer_notified' => '0' 
                    , 'comments' => MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_TITLE
                );
		yes_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);


		$dataString = '';
		foreach ($parameter as $key => $value) {
			$dataString .= $key . '=' . urlencode($value) . '&';
		}
		xtc_redirect($this->form_action_url . '?' . $dataString);
	}
	function after_process () {
		/* Clear our session data
		 * All other session data will be handled in checkout_process.php
		 */
		if (isset($_SESSION)) {
			if (isset($_SESSION['cart_pn_sofortueberweisung_ID'])) unset($_SESSION['cart_pn_sofortueberweisung_ID']);
			if (isset($_SESSION['sofortueberweisung_total'])) unset($_SESSION['sofortueberweisung_total']);
		}
	}
	function output_error (){
		return false;
	}
	function check () {
		if (! isset($this->_check)) {
			$check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}
	function get_error () {
		$error = false;
		if (! empty($_GET['payment_error'])) {
			$error = array('title' => MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_ERROR_HEADING , 'error' => MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_ERROR_MESSAGE);
		}
		return $error;
	}

	function autoinstall() {

	if (!isset($_SESSION['pn_sofortueberweisung_pw'])) {
		$_SESSION['pn_sofortueberweisung_pw'] = $this->_create_random_value(20);
		$_SESSION['pn_sofortueberweisung_pw2'] = $this->_create_random_value(20);
	}
		
	$_SESSION['pn_sofortueberweisung_hashAlgorithm'] = 'sha1';
	//mcrypt installed? use sha256 instead
	if(function_exists('hash') && in_array('sha256', hash_algos()))
		$_SESSION['pn_sofortueberweisung_hashAlgorithm'] = 'sha256';		

	$backlink = xtc_href_link(FILENAME_MODULES, 'set=payment&module=pn_sofortueberweisung&action=install', 'SSL');

	$header_redir_url = 'http://-USER_VARIABLE_2-';
	if (ENABLE_SSL_CATALOG == 'true' && strpos(HTTPS_CATALOG_SERVER, 'tps://') === 2) {
		$header_redir_url = 'https://-USER_VARIABLE_2-'; //
	}
	$html_abortlink = 'http://-USER_VARIABLE_3-';
	if (ENABLE_SSL_CATALOG == 'true' && strpos(HTTPS_CATALOG_SERVER, 'tps://') === 2) {
		$html_abortlink = 'https://-USER_VARIABLE_3-'; //
	}
	$alert_http_url = 'http://-USER_VARIABLE_4-';
	if (ENABLE_SSL_CATALOG == 'true' && strpos(HTTPS_CATALOG_SERVER, 'tps://') === 2) {
		$alert_http_url = 'https://-USER_VARIABLE_4-'; //
	}

		$html = <<<HTML
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/> 
<title>Schnellregistrierung | sofortueberweisung.de</title>
</head>
<body onload="document.getElementById('form').submit()">
<form method="post" action="https://www.sofortueberweisung.de/payment/createNew/" id="form">
<input type="hidden" name="project_name" value="%s">
<input type="hidden" name="project_homepage" value="%s">
<input type="hidden" name="projectsnotification_email_email" value="%s">
<input type="hidden" name="projectsnotification_email_activated" value="1">
<input type="hidden" name="projectsnotification_email_language_id" value="%s">
<input type="hidden" name="projectssetting_interface_cancel_link" value="%s">
<input type="hidden" name="projectssetting_interface_success_link_redirect" value="1">
<input type="hidden" name="projectssetting_interface_success_link" value="%s">
<input type="hidden" name="projectssetting_currency_id" value="%s">
<input type="hidden" name="projectssetting_locked_amount" value="1">
<input type="hidden" name="projectssetting_locked_reason_1" value="1">
<input type="hidden" name="projectssetting_locked_reason_2" value="1">
<input type="hidden" name="projectssetting_interface_input_hash_check_enabled" value="1">
<input type="hidden" name="projectssetting_project_password" value="%s">
<input type="hidden" name="project_notification_password" value="%s">
<input type="hidden" name="project_shop_system_id" value="4">
<input type="hidden" name="project_hash_algorithm" value="%s">
<input type="hidden" name="user_shop_system_id" value="4">
<input type="hidden" name="projectsnotification_http_activated" value="1">
<input type="hidden" name="projectsnotification_http_url" value="%s">
<input type="hidden" name="projectsnotification_http_method" value="1">
<input type="hidden" name="backlink" value="%s">
<input type="hidden" name="debug" value="0">
<noscript><input type="submit"></noscript>
</form>
</body>
</html>
HTML;

		$html = sprintf($html, STORE_NAME, xtc_catalog_href_link(), STORE_OWNER_EMAIL_ADDRESS, DEFAULT_LANGUAGE, $html_abortlink, $header_redir_url,
		DEFAULT_CURRENCY, $_SESSION['pn_sofortueberweisung_pw'], $_SESSION['pn_sofortueberweisung_pw2'],$_SESSION['pn_sofortueberweisung_hashAlgorithm'], $alert_http_url, $backlink);

		return $html;
	}
	function install () {

		if (isset($_GET['autoinstall']) && ($_GET['autoinstall'] == '1')) {
			// Module already installed
			if (defined('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS') && (MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS == 'True')) {
				xtc_redirect(xtc_href_link_admin('admin/modules.php', 'set=payment&module=pn_sofortueberweisung', 'SSL'));
			}
			print $this->autoinstall();
			exit();
		} else {

			$user_id = (! empty($_GET['user_id'])) ? xtc_db_prepare_input($_GET['user_id']) : '10000';
			$project_id = (! empty($_GET['project_id'])) ? xtc_db_prepare_input($_GET['project_id']) : '500000';

			if (isset($_SESSION['pn_sofortueberweisung_pw']) && !empty($_SESSION['pn_sofortueberweisung_pw'])) {
				$project_password = $_SESSION['pn_sofortueberweisung_pw'];
				unset($_SESSION['pn_sofortueberweisung_pw']);
			} else $project_password = '';
			if (isset($_SESSION['pn_sofortueberweisung_pw2']) && !empty($_SESSION['pn_sofortueberweisung_pw2'])) {
				$project_password2 = $_SESSION['pn_sofortueberweisung_pw2'];
				unset($_SESSION['pn_sofortueberweisung_pw2']);
			} else $project_password2 = '';
			if (isset($_SESSION['pn_sofortueberweisung_hashAlgorithm']) && !empty($_SESSION['pn_sofortueberweisung_hashAlgorithm'])) {
				$hashAlgorithm = $_SESSION['pn_sofortueberweisung_hashAlgorithm'];
				unset($_SESSION['pn_sofortueberweisung_hashAlgorithm']);
			} else $hashAlgorithm = 'sha1';

			
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS', 'True', '6', '3', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ALLOWED', '', '6', '0', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_USER_ID', '" . (int) $user_id . "',  '6', '4', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_ID', '" . (int) $project_id . "',  '6', '4', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_PASSWORD', '". $project_password ."',  '6', '4', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_NOTIF_PASSWORD', '". $project_password2 ."',  '6', '4', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added, set_function) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_HASH_ALGORITHM', '". $hashAlgorithm ."',  '6', '4', now(), 'xtc_draw_pull_down_menu(\'configuration[MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_HASH_ALGORITHM]\', array (array (\'id\' => \'md5\', \'text\' => \'md5\'),array (\'id\' => \'sha1\', \'text\' => \'sha1\'),array (\'id\' => \'sha256\', \'text\' => \'sha256\')),')");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_SORT_ORDER', '1', '6', '0', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ZONE', '0', '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ORDER_STATUS_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TMP_STATUS_ID', '0',  '6', '8', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_UNC_STATUS_ID', '0',  '6', '8', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_REASON_1', 'Nr. {{order_id}} Kd-Nr. {{customer_id}}',  '6', '4', 'xtc_cfg_select_option(array(\'Nr. {{order_id}} Kd-Nr. {{customer_id}}\',\'-TRANSACTION-\'), ', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_REASON_2', '" . STORE_NAME . "', '6', '4', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_IMAGE', 'Logo & Text',  '6', '6', 'xtc_cfg_select_option(array(\'Infographic\',\'Logo & Text\',\'Logo\'), ', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_IS_SHIPPING_BEFORE_PAYMENT', 'True', '6', '3', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		}
	}
	
	/**
	 * if old installation and notification password not set we need to upgrade the database
	 */
	function _upgrade() {
		$check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_NOTIF_PASSWORD'");
		if(!xtc_db_num_rows($check_query)) {
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_NOTIF_PASSWORD', '',  '6', '4', now())");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added, set_function) values ('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_HASH_ALGORITHM', 'sha1',  '6', '4', now(), 'xtc_draw_pull_down_menu(\'configuration[MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_HASH_ALGORITHM]\', array (array (\'id\' => \'md5\', \'text\' => \'md5\'),array (\'id\' => \'sha1\', \'text\' => \'sha1\'),array (\'id\' => \'sha256\', \'text\' => \'sha256\')),')");
		}
	}
	
	function remove () {
		xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key IN ('" . implode("', '", $this->keys()) . "')");
	}
	function keys () {
		return array('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_STATUS' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ALLOWED' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_USER_ID' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_ID' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_PASSWORD',  
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_PROJECT_NOTIF_PASSWORD', 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_HASH_ALGORITHM' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ZONE' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_REASON_1', 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TEXT_REASON_2' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_IMAGE' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_TMP_STATUS_ID' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_UNC_STATUS_ID' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_ORDER_STATUS_ID' , 
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_SORT_ORDER',
		'MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_IS_SHIPPING_BEFORE_PAYMENT'
		);
	}

	/**
	 * @param int $length length of return value
	 * @param string $type chars|digit|mixed
	 * @return string 
	 */
	function _create_random_value($length, $type = 'mixed') {
		//character classes
		$numericalCharacters = '0123456789';
		$alphaCharacters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
		$specialCharacters = '!$%/()?+*~^,.-;:_|}][{=#@';
		$characters = '';
				
		if($type == 'chars')
			$characters = $alphaCharacters;
		elseif($type == 'digits')
			$characters = $numericalCharacters;
		elseif($type == 'mixed')
			$characters = $numericalCharacters.$alphaCharacters.$specialCharacters;
		else
			return false;
		
		$charactersLength = strlen($characters)-1; 
		$randomValue = '';
		
		//select some random characters from all characters
		for ($i = 0; $i < $length; $i++) {
			$randomValue .= $characters[mt_rand(0, $charactersLength)];
		}

		return $randomValue;
	}

	// xtc_remove_order() in admin/includes/functions/general.php
	// mods by Gambio
	function _remove_order($order_id, $restock = false, $canceled = false) {
                $order_query = yes_query(
                    "select orders_products_id, products_id, products_quantity from ".TABLE_ORDERS_PRODUCTS." where orders_id = :orders_id",
                    ['orders_id'=>(int)$order_id]
                );
                foreach($order_query as $order) {
                    if ($restock == 'on') {
                        yes_query(
                            "update ".TABLE_PRODUCTS." set products_quantity = products_quantity + :qty, products_ordered = products_ordered - :qty2 where products_id =:products_id",
                            [
                                'qty'=>(int)$order['products_quantity'],
                                'qty2'=>(int)$order['products_quantity'],
                                'products_id'=> $order['products_id']
                            ]
                        );
                        $SQ = new products_quantity( $order['products_id'] );
                        $new_qty = $order['products_quantity'];
                        $qty_total = $SQ->get_products_total_qty();
                        xtc_db_query("delete from orders_products_price_fixing where orders_products_id = '".$order['orders_products_id']."'");
                    }
                    product::add_history_static(intval($order['products_id']),
                        'Re-Nr '.xtc_db_input($order_id).' durch Sofortueberweisung-Callback storniert.'
                    );
                }

		if(!$canceled) {
                    $del_params = ['orders_id'=>(int)$order_id];
                    yes_query("delete from ".TABLE_ORDERS." where orders_id =:orders_id",$del_params);
                    yes_query("delete from ".TABLE_ORDERS_PRODUCTS." where orders_id =:orders_id",$del_params);
                    yes_query("delete from ".TABLE_ORDERS_STATUS_HISTORY." where orders_id =:orders_id",$del_params);
                    yes_query("delete from ".TABLE_ORDERS_TOTAL." where orders_id =:orders_id",$del_params);
		}else{
                    $update_sql_array = array(
                        'orders_status'=>ORDERS_STATUS_STORNIERT,
                        'last_modified'=>'now()'
                    );
                    yes_db_perform(TABLE_ORDERS,$update_sql_array,'update',[
                        'orders_id'=>(int)$order_id
                    ]);
                    $insert_sql_array = array(
                        'orders_id'=>xtc_db_input($order_id),
                        'orders_status_id'=>ORDERS_STATUS_STORNIERT,
                        'date_added'=>'now()',
                        'customer_notified'=>false,
                        'comments'=>'Sofortueberweisung Zahlung fehlgeschlagen',
                        'editor_id'=>0
                    );
                    yes_db_perform(TABLE_ORDERS_STATUS_HISTORY,$insert_sql_array);
                }
	}
}

	
/**
 * @param string $algorithm hashing algorithm md5|sha1|sha256
 * @param unknown_type $data string to be hashed
 * @return string the hash
 */
function pn_create_hash($algorithm, $data){
	if($algorithm == 'sha1' && function_exists('sha1'))
		return sha1($data);

	//md5
	if($algorithm == 'md5' && function_exists('md5'))
		return md5($data);

	//mcrypt installed?
	if(function_exists('hash') && in_array($algorithm, hash_algos()))
		return hash($algorithm, $data);
		
	return false;
}
