<?php
/* -----------------------------------------------------------------------------------------
   $Id: yes_cod.php,v 1.2 2017/01/18 07:40:34 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (cod.php,v 1.7 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   

  class yes_cod {
    var $GROUP_ID_OTHER = 999999;

    var $code, $title, $description, $enabled,$grID,$fee;


    function __construct() {
      global $order;

      $this->code = 'yes_cod';
      $this->title = MODULE_PAYMENT_YES_COD_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_YES_COD_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PAYMENT_YES_COD_SORT_ORDER')) ? MODULE_PAYMENT_YES_COD_SORT_ORDER : 0;

      $this->enabled = ((defined('MODULE_PAYMENT_YES_COD_STATUS') and MODULE_PAYMENT_YES_COD_STATUS == 'True') ? true : false);

      $country_id = $order->delivery['country']['id']??yes_get_store_country_id();
      $this->grID = $this->get_shipping_graduation_groups_id($country_id);

      $this->fee = $this->get_fee();
	       
      if (defined('MODULE_PAYMENT_YES_COD_ORDER_STATUS_ID') and (int)MODULE_PAYMENT_YES_COD_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_YES_COD_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();
    }


    function update_status() {
      global $order;

      if ( ($this->enabled == true) ) {

        $check_flag = false;

        // HIER CHECKEN WIR OB ANHAND DER LAENDERGRUPPE DIE BEZAHLART NACHNAHME
	// IM YES VERSANDMODUL ERLAUBT IST
	$check_flag = $this->get_group_allow_cod();

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }

    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return false;
    }

    function process_button() {
      return false;
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function get_error() {
      return false;
    }

    function get_shipping_graduation_groups_id($country_id){
	$grid_res = yes_query(
            "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id=:country_id",
            ['country_id'=>(int)$country_id],
            true
        );
	$grID = $grid_res['shipping_graduation_groups_id'];
	if($grID < 1)
		$grID = $this->GROUP_ID_OTHER;
	return $grID;
    }

    function get_group_allow_cod(){
	$cod_query = xtc_db_query("SELECT allow_cod FROM shipping_graduation_groups WHERE shipping_graduation_groups_id='".$this->grID."'");
	$cod = xtc_db_fetch_array($cod_query);
	return ($cod['allow_cod'] == 1) ? true : false;
    }

    function get_fee(){
	$cod_query = xtc_db_query("SELECT cod_fee FROM shipping_graduation_groups WHERE shipping_graduation_groups_id='".$this->grID."'");
	$cod = xtc_db_fetch_array($cod_query);
	return $cod['cod_fee'];
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_YES_COD_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_YES_COD_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_COD_SORT_ORDER', '0',  '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_YES_COD_ORDER_STATUS_ID', '0','6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_YES_COD_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_YES_COD_ZONE', '0', '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
   }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_YES_COD_STATUS', 'MODULE_PAYMENT_YES_COD_ORDER_STATUS_ID', 'MODULE_PAYMENT_YES_COD_SORT_ORDER','MODULE_PAYMENT_YES_COD_ALLOWED','MODULE_PAYMENT_YES_COD_ZONE');
    }
  }
