<?php
/* -----------------------------------------------------------------------------------------
   $Id: print_product_info.php,v 1.13 2014/06/16 14:21:36 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(product_info.php,v 1.94 2003/05/04); www.oscommerce.com 
   (c) 2003	 nextcommerce (print_product_info.php,v 1.16 2003/08/25); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');

// include needed functions
define('DIR_FS_ADMIN',DIR_FS_CATALOG.'admin/');
require_once(DIR_FS_INC . 'xtc_get_products_mo_images.inc.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
//require_once(DIR_FS_INC.'xtc_get_products_vpe.inc.php');

$smarty = new yesSmarty;
if(!isset($_SESSION['languages_id'])){
    $_SESSION['languages_id'] = 2;
}
$product = new product((int)$_GET['products_id']);
// assign language to template for caching
$smarty->assign('language', $_SESSION['language']);	
$product_info = $product->buildDataArray($product->data,$xtPrice);
$PRODUCTS_VPE = '';
if ($product_info['PRODUCTS_VPE_STATUS'] == 1 && $product_info['PRODUCTS_VPE_VALUE'] != 0.0){
    $PRODUCTS_VPE = $xtPrice->xtcFormat( ((float)str_replace(',','.',$product_info['PRODUCTS_PRICE_CLEAN'])) * (1 / $product_info['PRODUCTS_VPE_VALUE']), true).TXT_PER.xtc_get_vpe_name($product_info['PRODUCTS_VPE']);
    $smarty->assign('PRODUCTS_VPE',$PRODUCTS_VPE);
}
$smarty->assign('INFO',$product_info);

include(DIR_WS_MODULES . 'product_characteristics.php');
$smarty->assign('CHARACTERISTICS', $module);
    

$smarty->assign('PRODUCTS_NAME', $product_info['PRODUCTS_NAME']);
$smarty->assign('PRODUCTS_MODEL', $product_info['PRODUCTS_MODEL']);
$smarty->assign('PRODUCTS_DESCRIPTION', $product_info['PRODUCTS_DESCRIPTION']);
$smarty->assign('PRODUCTS_EXTRA_TEXT', $product_info['PRODUCTS_EXTRA_TEXT']);
$smarty->assign('PRODUCTS_IMAGE',$product_info['PRODUCTS_IMAGE']);
$smarty->assign('PRODUCTS_PRICE', $product_info['PRODUCTS_PRICE']);
$smarty->assign('PRODUCTS_SHIPPING_LINK', $product_info['PRODUCTS_SHIPPING_LINK']);
$smarty->assign('PRODUCTS_TAX_RATE', $product_info['PRODUCTS_TAX_RATE']);
$smarty->assign('PRODUCTS_TAX_INFO', $product_info['PRODUCTS_TAX_INFO']);
$smarty->assign('PRODUCTS_ID', $product_info['PRODUCTS_ID']);
  
$smarty->assign('STORE', STORE_NAME_ADDRESS);
$smarty->assign('logo_path', xtc_href_link('templates/'.CURRENT_TEMPLATE.'/img/'));
  
if(isset($module_content)){
      $smarty->assign('module_content', $module_content);
}
  
//more images - by Novalis
$mo_images = xtc_get_products_mo_images($product_info['PRODUCTS_ID']);
if (isset($mo_images)){ 
    foreach($mo_images as $img) {
        if($img['noshop']==0){
              $mo_img = xtc_href_link(DIR_WS_INFO_IMAGES . $img['image_name']);
              $smarty->assign('PRODUCTS_IMAGE_'.$img['image_nr'], $mo_img);  	
        }
    }
}

// set cache ID
if (USE_CACHE=='false') {
    $smarty->caching = 0;
} else {
    $smarty->caching = 1;	
    $smarty->cache_lifetime=CACHE_LIFETIME;
    $smarty->cache_modified_check=CACHE_CHECK;
}
$cache_id = $_SESSION['language'] . '_' . $product_info['PRODUCTS_ID'];
$smarty->display(CURRENT_TEMPLATE . '/module/print_product_info.html', $cache_id);
include( 'includes/application_bottom.php');
